/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.CellPoint;
import SharpTools.Formula;
import SharpTools.Function;
import SharpTools.FunctionCount;
import SharpTools.Node;
import SharpTools.ParserException;
import SharpTools.SharpTableModel;
import SharpTools.SharpTools;
import java.util.LinkedList;

class FunctionMedian
extends Function {
    FunctionMedian() {
    }

    @Override
    public Number evaluate(SharpTableModel table, Node node, int row, int col) throws ParserException {
        this.checkParamsExist(node);
        int nCells = (int)new FunctionCount().evaluate(table, node, row, col).floatValue();
        float[] values = new float[nCells];
        int index = 0;
        LinkedList params = node.getParams();
        if (params != null) {
            for (Node exp : params) {
                if (this.isRange(exp)) {
                    CellPoint[] addr = this.getFirst(exp).getAddressRange(row, col);
                    for (int i = addr[0].getRow(); i <= addr[1].getRow(); ++i) {
                        for (int j = addr[0].getCol(); j <= addr[1].getCol(); ++j) {
                            values[index++] = table.getNumericValueAt(i, j).floatValue();
                        }
                    }
                    continue;
                }
                values[index++] = Formula.evaluate(table, exp.getExp(), row, col).floatValue();
            }
        }
        for (int m = 0; m < nCells - 1; ++m) {
            for (int n = m; n < nCells - 1; ++n) {
                if (!(values[m] > values[n])) continue;
                float tmp = values[m];
                values[m] = values[n];
                values[n] = tmp;
            }
        }
        int half = nCells / 2;
        if (nCells != half * 2) {
            return new Float(values[half]);
        }
        return new Float((values[half - 1] + values[half]) / 2.0f);
    }

    @Override
    public String getUsage() {
        return "MEDIAN(value1,value2,...)";
    }

    @Override
    public String getDescription() {
        return SharpTools.translation.getProperty("median_desc");
    }
}

