# 2025-05-20 Triage Log

A relatively quiet week, likely caused by not that many PRs being merged as many contributors
were at RustWeek and the All Hands event. There were several nice wins in trait solving;
the benchmark suite now contains benchmarks that use the new trait solver, so we can now
focus on optimizing its performance in the near future.

Triage done by **@kobzol**.
Revision range: [718ddf66..59372f2c](https://perf.rust-lang.org/?start=718ddf660e6a1802c39b4962cf7eaa4db57025ef&end=59372f2c81ba74554d9a71b12a4ed7f29adb33a2&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.1%, 1.8%]   | 25    |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.1%, 3.1%]   | 23    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.6%, -0.1%] | 33    |
| Improvements ✅ <br /> (secondary) | -2.2% | [-9.2%, -0.1%] | 26    |
| All ❌✅ (primary)                 | 0.1%  | [-0.6%, 1.8%]  | 58    |


2 Regressions, 5 Improvements, 3 Mixed; 3 of them in rollups
41 artifact comparisons made in total

#### Regressions

Remove manual WF hack [#140557](https://github.com/rust-lang/rust/pull/140557) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6d1875f99b2d5c1499410505f4233fbf8dbdc23b&end=7e19eef048ba58c28c70afbf5f95da4829c15796&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.1%, 0.6%] | 34    |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.1%, 0.2%] | 5     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.1%, 0.6%] | 34    |

- Small genuine regression, but the PR removed hack from the type system code, which is worth it.
- Marked as triaged.

Add `std::io::Seek` instance for `std::io::Take` [#138023](https://github.com/rust-lang/rust/pull/138023) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=59372f2c81ba74554d9a71b12a4ed7f29adb33a2&end=60dabef95a3de3ec974dcb50926e4bfe743f078f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.0% | [1.0%, 3.0%] | 2     |
| Regressions ❌ <br /> (secondary)  | 1.0% | [1.0%, 1.0%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 2.0% | [1.0%, 3.0%] | 2     |

- Noise produced by newly added benchmarks.
- Marked as triaged.

#### Improvements

Rollup of 7 pull requests [#141011](https://github.com/rust-lang/rust/pull/141011) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2a5da7acd4c3eae638aa1c46f3a537940e60a0e4&end=d163a28381c297a56417d4a5dfe88c6c65429265&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-0.9%, -0.8%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.2%] | 8     |
| All ❌✅ (primary)                 | -0.8% | [-0.9%, -0.8%] | 4     |


trait_sel: deep reject `match_normalize_trait_ref` [#140978](https://github.com/rust-lang/rust/pull/140978) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=16d2276fa6fccb0cc239a542d4c3f0eb46f660ec&end=c8bda740ea5c21af42fe4afa907f89805ab2b905&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -5.7% | [-9.3%, -0.1%] | 9     |
| All ❌✅ (primary)                 | -     | -              | 0     |


Rollup of 8 pull requests [#141113](https://github.com/rust-lang/rust/pull/141113) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b0e925903a04fc3b2e0903ce6110938e871c61a1&end=a43b8d1d2b10bf4d9e9d935aed497f7ebbeeb6e4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.1%, -0.1%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.0% | [-0.0%, -0.0%] | 2     |
| All ❌✅ (primary)                 | -0.1% | [-0.1%, -0.1%] | 4     |


move expensive layout sanity check to debug assertions [#141039](https://github.com/rust-lang/rust/pull/141039) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=16244bc37a6ff610daa38afcddfc1a8bb226702e&end=ac17c3486c6fdfbb0c3c18b99f3d8dfbff625d29&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 22    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.6%, -0.4%] | 8     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.1%] | 22    |


Fast path for `register_region_obligation` [#141129](https://github.com/rust-lang/rust/pull/141129) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ae3b909a323aa771db8ee3919c1454b77db05fbf&end=7205fc537d0fe8c3c2560b313e54fcb91ab6f3d1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 30    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.0%, -0.0%] | 12    |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.1%] | 30    |


#### Mixed

Use the new solver in the `impossible_predicates` [#136988](https://github.com/rust-lang/rust/pull/136988) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d163a28381c297a56417d4a5dfe88c6c65429265&end=c4e05e53d19b550a358ee8b2e29ecd5a11075800&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.4%, 1.1%]   | 5     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.3%, 1.0%]   | 27    |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.1%, -0.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.2%, -0.1%] | 6     |
| All ❌✅ (primary)                 | 0.8%  | [-0.1%, 1.1%]  | 6     |

- The regressions are mostly in `helloworld` and tiny benchmarks, and they are relatively small.
- We generally expect the perf. of the new solver to improve over time.
- Marked as triaged.

Optimize `ToString` implementation for integers [#136264](https://github.com/rust-lang/rust/pull/136264) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c4e05e53d19b550a358ee8b2e29ecd5a11075800&end=d97326eabfc3b2c33abcb08d6bc117aefa697cb7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.3%, 1.1%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.3%  | [-0.2%, 1.1%]  | 4     |

- Regression on a single benchmark that is new and doesn't have proper noise bounds yet.
- Also a nice win on the `fmt-write-str` runtime benchmark, which should be expected here!
- Marked as triaged.

Rollup of 8 pull requests [#141232](https://github.com/rust-lang/rust/pull/141232) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b53e5c9db04c89fa15c96f03ae2e0c538b598940&end=4455c8937007f3cc3c078375a335d86dbab391ce&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.4%, 1.2%]   | 8     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.2%, 3.2%]   | 15    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.0%, -0.0%] | 4     |
| All ❌✅ (primary)                 | 0.8%  | [0.4%, 1.2%]   | 8     |

- The binary size and the biggest icount regressions come from [#140628](https://github.com/rust-lang/rust/pull/140628).
- Marked as triaged, following up on #140628.
