# 2023-11-14 Triage Log

A week dominated by one particular perf improvement that lead to huge performance gains - an avg of 5% improvement across 121 test cases! The perf improvement comes from adding an `#[inline]` hint to the output from `#[derive(Debug)]` which presumably allows the compiler to more easily do deadcode elimination reducing the binary size and the amount of code that actually needs to be code-gened.

Triage done by **@rylev**.
Revision range: [7b97a5ca..173b6e68](https://perf.rust-lang.org/?start=7b97a5ca8422d1495a8918106d3249aa405812d4&end=173b6e686b158dbad7d072c64bef3ced2052312b&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.9%]    | 10    |
| Regressions ❌ <br /> (secondary)  | 1.9%  | [0.2%, 3.6%]    | 12    |
| Improvements ✅ <br /> (primary)   | -5.6% | [-49.2%, -0.1%] | 111   |
| Improvements ✅ <br /> (secondary) | -3.5% | [-25.0%, -0.2%] | 155   |
| All ❌✅ (primary)                 | -5.1% | [-49.2%, 0.9%]  | 121   |


2 Regressions, 2 Improvements, 3 Mixed; 3 of them in rollups
55 artifact comparisons made in total

#### Regressions

Bump libc dependency [#117617](https://github.com/rust-lang/rust/pull/117617) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9bd71afb90c2a6e0348cdd4a2b10a3bf39908f19&end=118a2deea5f7aba3de1ab13143a998b6bad13704&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 8.3% | [1.1%, 19.0%] | 9     |
| Regressions ❌ <br /> (secondary)  | -    | -             | 0     |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | 8.3% | [1.1%, 19.0%] | 9     |
- A curious perf infra glitch - the regression returned to normal after a few runs.


Rollup of 6 pull requests [#117736](https://github.com/rust-lang/rust/pull/117736) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d8dbf7ca0ee9c6da0fd039b1eb8cf7c7cb840f43&end=492e57c6adeb9e7635e9dfb7bab591997edd7f98&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 0.5%] | 5     |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.6%, 0.6%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 0.5%] | 5     |
- The only PR that includes actual changes to the compiler is [#117645](https://github.com/rust-lang/rust/pull/117645). Kicked off a test to see if that's the root cause. 


#### Improvements

Rollup of 4 pull requests [#117680](https://github.com/rust-lang/rust/pull/117680) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=118a2deea5f7aba3de1ab13143a998b6bad13704&end=7adc89b69b941afceadcf8609dd6b2999353e550&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -9.1% | [-16.0%, -2.6%] | 7     |
| Improvements ✅ <br /> (secondary) | -     | -               | 0     |
| All ❌✅ (primary)                 | -9.1% | [-16.0%, -2.6%] | 7     |
- The flip side of [#117617](https://github.com/rust-lang/rust/pull/117617)'s strange perf regression.


Add `std::hash::{DefaultHasher, RandomState}` exports (needs FCP) [#115694](https://github.com/rust-lang/rust/pull/115694) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ed086d86b8b224f7df2da09cf48ac2a654bf841e&end=2c1b65ee1431f8d3fe2142e821eb13c623bbf8a0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.2%, -0.4%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.9% | [-1.2%, -0.4%] | 6     |


#### Mixed

Only use `normalize_param_env` when normalizing predicate in `check_item_bounds` [#117542](https://github.com/rust-lang/rust/pull/117542) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=750c2ecd1503fe7ff39e41603977d12de33417d8&end=fab1054e1742790c22ccc92a625736d658363677&stat=instructions:u)

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%   | [0.4%, 0.4%]    | 1     |
| Regressions ❌ <br /> (secondary)  | 1.4%   | [0.8%, 2.3%]    | 12    |
| Improvements ✅ <br /> (primary)   | -18.4% | [-49.6%, -0.2%] | 20    |
| Improvements ✅ <br /> (secondary) | -      | -               | 0     |
| All ❌✅ (primary)                 | -17.5% | [-49.6%, 0.4%]  | 21    |
- Fixing https://github.com/rust-lang/rust/pull/117131#issuecomment-1791852906 and deemed acceptable for the small regressions.


Emit #[inline] on derive(Debug) [#117727](https://github.com/rust-lang/rust/pull/117727) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=eae4135939881ae730342bd336ae6302c3787e27&end=0f44eb32f1123ac93ab404d74c295263ce468343&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.1%  | [0.3%, 13.7%]   | 5     |
| Regressions ❌ <br /> (secondary)  | 1.8%  | [0.2%, 3.4%]    | 6     |
| Improvements ✅ <br /> (primary)   | -2.3% | [-10.6%, -0.1%] | 110   |
| Improvements ✅ <br /> (secondary) | -3.2% | [-25.2%, -0.1%] | 177   |
| All ❌✅ (primary)                 | -2.1% | [-10.6%, 13.7%] | 115   |
- Huge wins outweigh the small losses.


Rollup of 6 pull requests [#117769](https://github.com/rust-lang/rust/pull/117769) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0f44eb32f1123ac93ab404d74c295263ce468343&end=d42d73b144fbb6ccc9684b197a3b6ed53592d09b&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]    | 1     |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [1.0%, 1.0%]    | 1     |
| Improvements ✅ <br /> (primary)   | -6.5% | [-12.3%, -0.7%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -               | 0     |
| All ❌✅ (primary)                 | -4.2% | [-12.3%, 0.3%]  | 3     |
- Noise

