/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Itinerary {
    /// journey duration in seconds
    #[serde(rename = "duration")]
    pub duration: i32,
    /// journey departure time
    #[serde(rename = "startTime")]
    pub start_time: String,
    /// journey arrival time
    #[serde(rename = "endTime")]
    pub end_time: String,
    /// The number of transfers this trip has.
    #[serde(rename = "transfers")]
    pub transfers: i32,
    /// Journey legs
    #[serde(rename = "legs")]
    pub legs: Vec<models::Leg>,
    /// Fare information
    #[serde(rename = "fareTransfers", skip_serializing_if = "Option::is_none")]
    pub fare_transfers: Option<Vec<models::FareTransfer>>,
}

impl Itinerary {
    pub fn new(duration: i32, start_time: String, end_time: String, transfers: i32, legs: Vec<models::Leg>) -> Itinerary {
        Itinerary {
            duration,
            start_time,
            end_time,
            transfers,
            legs,
            fare_transfers: None,
        }
    }
}

