% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend_api-11.SequentialFutureBackend-class.R
\name{sequential}
\alias{sequential}
\alias{uniprocess}
\title{Create a sequential future whose value will be in the current \R session}
\usage{
sequential(..., envir = parent.frame())
}
\arguments{
\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{\ldots}{Not used.}
}
\description{
\emph{WARNING: This function must never be called.
It may only be used with \code{\link[=plan]{plan()}}}
}
\details{
A sequential future is a future that is evaluated sequentially in the
current \R session similarly to how \R expressions are evaluated in \R.
The only difference to \R itself is that globals are validated
by default just as for all other types of futures in this package.

This function is must \emph{not} be called directly.  Instead, the
typical usages are:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Evaluate futures sequentially in the current R process
plan(sequential)
}\if{html}{\out{</div>}}
}
\examples{
## Use sequential futures
plan(sequential)

## A global variable
a <- 0

## Create a sequential future
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## Since 'a' is a global variable in future 'f' which
## is eagerly resolved (default), this global has already
## been resolved / incorporated, and any changes to 'a'
## at this point will _not_ affect the value of 'f'.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)
}
