# Copyright (C) 2024 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

"""Data relating to timezones and CLDR.

This is not implicated in public APIs, so may safely be changed.
Contrast the enumdata.py, where public API is implicated.

Scripts digesting CLDR data shall report the updates you need to make,
if any arise.

The windowsIdList is a list of twoples (ID, offset), associating each
Windows-specific ID for a zone with that zone's offset from UTC, in
seconds. Entries are sorted in case-insensitive lexical order by
ID. If a script reports that it has found a Windows ID not listed
here, research the relevant zone's offset and add a new entry to the
list of twoples, preserving the ordering. Internet search engines and
timeanddate.com can help with researching the offset. Note that some
UTC offset zones (giving only the hour) are present in windowsIdList.
When adding an entry to windowsIdList, check whether its offset
corresponds to that of some entry in utcIdList; if not, add such an
entry.

The utcIdList is a simple list of various UTC-offset names. Aside from
'UTC' itself, shared with windowsIdList, these include minutes in
their offsets even when they are whole hour offsets. The list contains
the UTC-equivalents of all offsets seen in the windowsIdList, plus the
whole hours out to ±14 hours, the two verbose forms of UTC±00:00 and
any legacy entries from past Windows zone offsets. Entries should not
be removed, even if the relevant Windows ID becomes obsolete or
switches to a different offset, as they make up the available zones of
the UTC back-end. (That recognizes other offset zones, and its
is-available check will accept them, but it leaves them out of its
list. There are, after all, thousands of possible offset zones, but
relatively few are widely used.)

Note: -00:00 (without the UTC prefix) was introduced in RFC3339 as a
way to indicate that a date-time has been converted to UTC but its use
should not be understood to say anything about the local time of the
origin of the message using it. However, ISO 8601 has, since 2000,
forbidden this as an offset suffix. The more recent compromise is to
use Z to convey the meaning RFC3339 gave to -00:00. So the use of
-00:00 as offset suffix should be avoided (and, by extension, likewise
for UTC-00:00 as a zone ID), but this suffix (and ID) should be
recognized when consuming data generated by other sources, for
backwards compatibility.

"""

# Do not remove IDs, as each entry is part of the API/behavior guarantee.
# IDs for the same offset shall be space-joined; list the preferred ID first.
utcIdList = (
    'UTC-14:00',
    'UTC-13:00',
    'UTC-12:00',
    'UTC-11:00',
    'UTC-10:00', 'UTC-09:30',
    'UTC-09:00',
    'UTC-08:00',
    'UTC-07:00',
    'UTC-06:00',
    'UTC-05:00', 'UTC-04:30',
    'UTC-04:00', 'UTC-03:30',
    'UTC-03:00',
    'UTC-02:00',
    'UTC-01:00',
    # UTC Goes first (among zero-offset) to be default:
    'UTC', 'UTC+00:00', 'UTC-00:00',
    'UTC+01:00',
    'UTC+02:00',
    'UTC+03:00', 'UTC+03:30',
    'UTC+04:00', 'UTC+04:30',
    'UTC+05:00', 'UTC+05:30', 'UTC+05:45',
    'UTC+06:00', 'UTC+06:30',
    'UTC+07:00',
    'UTC+08:00', 'UTC+08:30', 'UTC+08:45',
    'UTC+09:00', 'UTC+09:30',
    'UTC+10:00', 'UTC+10:30',
    'UTC+11:00',
    'UTC+12:00', 'UTC+12:45',
    'UTC+13:00',
    'UTC+14:00',
)

# ( Windows Id, Offset Seconds )
windowsIdList = (
    ('Afghanistan Standard Time',        16200),
    ('Alaskan Standard Time',           -32400),
    ('Aleutian Standard Time',          -36000),
    ('Altai Standard Time',              25200),
    ('Arab Standard Time',               10800),
    ('Arabian Standard Time',            14400),
    ('Arabic Standard Time',             10800),
    ('Argentina Standard Time',         -10800),
    ('Astrakhan Standard Time',          14400),
    ('Atlantic Standard Time',          -14400),
    ('AUS Central Standard Time',        34200),
    ('Aus Central W. Standard Time',     31500),
    ('AUS Eastern Standard Time',        36000),
    ('Azerbaijan Standard Time',         14400),
    ('Azores Standard Time',             -3600),
    ('Bahia Standard Time',             -10800),
    ('Bangladesh Standard Time',         21600),
    ('Belarus Standard Time',            10800),
    ('Bougainville Standard Time',       39600),
    ('Canada Central Standard Time',    -21600),
    ('Cape Verde Standard Time',         -3600),
    ('Caucasus Standard Time',           14400),
    ('Cen. Australia Standard Time',     34200),
    ('Central America Standard Time',   -21600),
    ('Central Asia Standard Time',       21600),
    ('Central Brazilian Standard Time', -14400),
    ('Central Europe Standard Time',      3600),
    ('Central European Standard Time',    3600),
    ('Central Pacific Standard Time',    39600),
    ('Central Standard Time',           -21600),
    ('Central Standard Time (Mexico)',  -21600),
    ('Chatham Islands Standard Time',    45900),
    ('China Standard Time',              28800),
    ('Cuba Standard Time',              -18000),
    ('Dateline Standard Time',          -43200),
    ('E. Africa Standard Time',          10800),
    ('E. Australia Standard Time',       36000),
    ('E. Europe Standard Time',           7200),
    ('E. South America Standard Time',  -10800),
    ('Easter Island Standard Time',     -21600),
    ('Eastern Standard Time',           -18000),
    ('Eastern Standard Time (Mexico)',  -18000),
    ('Egypt Standard Time',               7200),
    ('Ekaterinburg Standard Time',       18000),
    ('Fiji Standard Time',               43200),
    ('FLE Standard Time',                 7200),
    ('Georgian Standard Time',           14400),
    ('GMT Standard Time',                    0),
    ('Greenland Standard Time',         -10800),
    ('Greenwich Standard Time',              0),
    ('GTB Standard Time',                 7200),
    ('Haiti Standard Time',             -18000),
    ('Hawaiian Standard Time',          -36000),
    ('India Standard Time',              19800),
    ('Iran Standard Time',               12600),
    ('Israel Standard Time',              7200),
    ('Jordan Standard Time',              7200),
    ('Kaliningrad Standard Time',         7200),
    ('Korea Standard Time',              32400),
    ('Libya Standard Time',               7200),
    ('Line Islands Standard Time',       50400),
    ('Lord Howe Standard Time',          37800),
    ('Magadan Standard Time',            36000),
    ('Magallanes Standard Time',        -10800), # permanent DST
    ('Marquesas Standard Time',         -34200),
    ('Mauritius Standard Time',          14400),
    ('Middle East Standard Time',         7200),
    ('Montevideo Standard Time',        -10800),
    ('Morocco Standard Time',                0),
    ('Mountain Standard Time',          -25200),
    ('Mountain Standard Time (Mexico)', -25200),
    ('Myanmar Standard Time',            23400),
    ('N. Central Asia Standard Time',    21600),
    ('Namibia Standard Time',             3600),
    ('Nepal Standard Time',              20700),
    ('New Zealand Standard Time',        43200),
    ('Newfoundland Standard Time',      -12600),
    ('Norfolk Standard Time',            39600),
    ('North Asia East Standard Time',    28800),
    ('North Asia Standard Time',         25200),
    ('North Korea Standard Time',        30600),
    ('Omsk Standard Time',               21600),
    ('Pacific SA Standard Time',        -10800),
    ('Pacific Standard Time',           -28800),
    ('Pacific Standard Time (Mexico)',  -28800),
    ('Pakistan Standard Time',           18000),
    ('Paraguay Standard Time',          -14400),
    ('Qyzylorda Standard Time',          18000), # a.k.a. Kyzylorda, in Kazakhstan
    ('Romance Standard Time',             3600),
    ('Russia Time Zone 10',              39600),
    ('Russia Time Zone 11',              43200),
    ('Russia Time Zone 3',               14400),
    ('Russian Standard Time',            10800),
    ('SA Eastern Standard Time',        -10800),
    ('SA Pacific Standard Time',        -18000),
    ('SA Western Standard Time',        -14400),
    ('Saint Pierre Standard Time',      -10800), # New France
    ('Sakhalin Standard Time',           39600),
    ('Samoa Standard Time',              46800),
    ('Sao Tome Standard Time',               0),
    ('Saratov Standard Time',            14400),
    ('SE Asia Standard Time',            25200),
    ('Singapore Standard Time',          28800),
    ('South Africa Standard Time',        7200),
    ('South Sudan Standard Time',         7200),
    ('Sri Lanka Standard Time',          19800),
    ('Sudan Standard Time',               7200), # unless they mean South Sudan, +03:00
    ('Syria Standard Time',               7200),
    ('Taipei Standard Time',             28800),
    ('Tasmania Standard Time',           36000),
    ('Tocantins Standard Time',         -10800),
    ('Tokyo Standard Time',              32400),
    ('Tomsk Standard Time',              25200),
    ('Tonga Standard Time',              46800),
    ('Transbaikal Standard Time',        32400), # Yakutsk
    ('Turkey Standard Time',              7200),
    ('Turks And Caicos Standard Time',  -14400),
    ('Ulaanbaatar Standard Time',        28800),
    ('US Eastern Standard Time',        -18000),
    ('US Mountain Standard Time',       -25200),
    ('UTC',                                  0),
    # Lexical order: '+' < '-'
    ('UTC+12',                           43200),
    ('UTC+13',                           46800),
    ('UTC-02',                           -7200),
    ('UTC-08',                          -28800),
    ('UTC-09',                          -32400),
    ('UTC-11',                          -39600),
    ('Venezuela Standard Time',         -16200),
    ('Vladivostok Standard Time',        36000),
    ('Volgograd Standard Time',          14400),
    ('W. Australia Standard Time',       28800),
    ('W. Central Africa Standard Time',   3600),
    ('W. Europe Standard Time',           3600),
    ('W. Mongolia Standard Time',        25200), # Hovd
    ('West Asia Standard Time',          18000),
    ('West Bank Standard Time',           7200),
    ('West Pacific Standard Time',       36000),
    ('Yakutsk Standard Time',            32400),
    ('Yukon Standard Time',             -25200), # Non-DST Mountain Standard Time since 2020-11-01
)
