# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.communication.aio import CommunicationServiceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCommunicationServiceManagementSuppressionListsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CommunicationServiceManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_suppression_lists_list_by_domain(self, resource_group):
        response = self.client.suppression_lists.list_by_domain(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            api_version="2025-09-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_suppression_lists_get(self, resource_group):
        response = await self.client.suppression_lists.get(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            suppression_list_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_suppression_lists_create_or_update(self, resource_group):
        response = await self.client.suppression_lists.create_or_update(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            suppression_list_name="str",
            parameters={
                "createdTimeStamp": "str",
                "dataLocation": "str",
                "id": "str",
                "lastUpdatedTimeStamp": "str",
                "listName": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_suppression_lists_delete(self, resource_group):
        response = await self.client.suppression_lists.delete(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            suppression_list_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...
