"""Drive test constants."""
# pylint: disable=line-too-long

DRIVEWSID = "FOLDER::com.apple.CloudDocs::root"
ZONE = "com.apple.CloudDocs"
DATE_CREATED = "2019-12-12T14:33:55-08:00"
FOLDER1 = "FOLDER::com.apple.CloudDocs::1C7F1760-D940-480F-8C4F-005824A4E05B"
FOLDER2 = "FOLDER::com.apple.CloudDocs::D5AA0425-E84F-4501-AF5D-60F1D92648CF"
# Data
DRIVE_ROOT_WORKING = [
    {
        "drivewsid": DRIVEWSID,
        "docwsid": "root",
        "zone": ZONE,
        "name": "",
        "etag": "31",
        "type": "FOLDER",
        "assetQuota": 62418076,
        "fileCount": 7,
        "shareCount": 0,
        "shareAliasCount": 0,
        "directChildrenCount": 3,
        "items": [
            {
                "dateCreated": DATE_CREATED,
                "drivewsid": "FOLDER::com.apple.Keynote::documents",
                "docwsid": "documents",
                "zone": "com.apple.Keynote",
                "name": "Keynote",
                "parentId": DRIVEWSID,
                "etag": "2m",
                "type": "APP_LIBRARY",
                "maxDepth": "ANY",
                "icons": [
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Keynote&field=icon120x120_iOS",
                        "type": "IOS",
                        "size": 120,
                    },
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Keynote&field=icon80x80_iOS",
                        "type": "IOS",
                        "size": 80,
                    },
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Keynote&field=icon40x40_iOS",
                        "type": "IOS",
                        "size": 40,
                    },
                ],
                "supportedExtensions": [
                    "pptx",
                    "ppsx",
                    "pps",
                    "pot",
                    "key-tef",
                    "ppt",
                    "potx",
                    "potm",
                    "pptm",
                    "ppsm",
                    "key",
                    "kth",
                ],
                "supportedTypes": [
                    "com.microsoft.powerpoint.pps",
                    "com.microsoft.powerpoint.pot",
                    "com.microsoft.powerpoint.ppt",
                    "org.openxmlformats.presentationml.template.macroenabled",
                    "org.openxmlformats.presentationml.slideshow.macroenabled",
                    "com.apple.iwork.keynote.key-tef",
                    "org.openxmlformats.presentationml.template",
                    "org.openxmlformats.presentationml.presentation.macroenabled",
                    "com.apple.iwork.keynote.key",
                    "com.apple.iwork.keynote.kth",
                    "org.openxmlformats.presentationml.presentation",
                    "org.openxmlformats.presentationml.slideshow",
                    "com.apple.iwork.keynote.sffkey",
                    "com.apple.iwork.keynote.sffkth",
                ],
            },
            {
                "dateCreated": DATE_CREATED,
                "drivewsid": "FOLDER::com.apple.Numbers::documents",
                "docwsid": "documents",
                "zone": "com.apple.Numbers",
                "name": "Numbers",
                "parentId": DRIVEWSID,
                "etag": "3k",
                "type": "APP_LIBRARY",
                "maxDepth": "ANY",
                "icons": [
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Numbers&field=icon120x120_iOS",
                        "type": "IOS",
                        "size": 120,
                    },
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Numbers&field=icon80x80_iOS",
                        "type": "IOS",
                        "size": 80,
                    },
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Numbers&field=icon40x40_iOS",
                        "type": "IOS",
                        "size": 40,
                    },
                ],
                "supportedExtensions": [
                    "hh",
                    "ksh",
                    "lm",
                    "xlt",
                    "c++",
                    "f95",
                    "lid",
                    "csv",
                    "numbers",
                    "php4",
                    "hp",
                    "py",
                    "nmbtemplate",
                    "lmm",
                    "jscript",
                    "php3",
                    "crash",
                    "patch",
                    "java",
                    "ym",
                    "xlam",
                    "text",
                    "mi",
                    "exp",
                    "adb",
                    "jav",
                    "ada",
                    "ii",
                    "defs",
                    "mm",
                    "cpp",
                    "cxx",
                    "pas",
                    "diff",
                    "pch++",
                    "javascript",
                    "panic",
                    "rb",
                    "ads",
                    "tcsh",
                    "ypp",
                    "yxx",
                    "ph3",
                    "ph4",
                    "phtml",
                    "xltx",
                    "hang",
                    "rbw",
                    "f77",
                    "for",
                    "js",
                    "h++",
                    "mig",
                    "gpurestart",
                    "mii",
                    "zsh",
                    "m3u",
                    "pch",
                    "sh",
                    "xltm",
                    "applescript",
                    "tsv",
                    "ymm",
                    "shutdownstall",
                    "cc",
                    "xlsx",
                    "scpt",
                    "c",
                    "inl",
                    "f",
                    "numbers-tef",
                    "h",
                    "i",
                    "hpp",
                    "hxx",
                    "dlyan",
                    "xla",
                    "l",
                    "cp",
                    "m",
                    "lpp",
                    "lxx",
                    "txt",
                    "r",
                    "s",
                    "xlsm",
                    "spin",
                    "php",
                    "csh",
                    "y",
                    "bash",
                    "m3u8",
                    "pl",
                    "f90",
                    "pm",
                    "xls",
                ],
                "supportedTypes": [
                    "org.openxmlformats.spreadsheetml.sheet",
                    "com.microsoft.excel.xla",
                    "com.apple.iwork.numbers.template",
                    "org.openxmlformats.spreadsheetml.sheet.macroenabled",
                    "com.apple.iwork.numbers.sffnumbers",
                    "com.apple.iwork.numbers.numbers",
                    "public.plain-text",
                    "com.microsoft.excel.xlt",
                    "org.openxmlformats.spreadsheetml.template",
                    "com.microsoft.excel.xls",
                    "public.comma-separated-values-text",
                    "com.apple.iwork.numbers.numbers-tef",
                    "org.openxmlformats.spreadsheetml.template.macroenabled",
                    "public.tab-separated-values-text",
                    "com.apple.iwork.numbers.sfftemplate",
                    "com.microsoft.excel.openxml.addin",
                ],
            },
            {
                "dateCreated": DATE_CREATED,
                "drivewsid": "FOLDER::com.apple.Pages::documents",
                "docwsid": "documents",
                "zone": "com.apple.Pages",
                "name": "Pages",
                "parentId": DRIVEWSID,
                "etag": "km",
                "type": "APP_LIBRARY",
                "maxDepth": "ANY",
                "icons": [
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Pages&field=icon120x120_iOS",
                        "type": "IOS",
                        "size": 120,
                    },
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Pages&field=icon80x80_iOS",
                        "type": "IOS",
                        "size": 80,
                    },
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Pages&field=icon40x40_iOS",
                        "type": "IOS",
                        "size": 40,
                    },
                ],
                "supportedExtensions": [
                    "hh",
                    "ksh",
                    "lm",
                    "c++",
                    "f95",
                    "lid",
                    "php4",
                    "hp",
                    "py",
                    "lmm",
                    "jscript",
                    "php3",
                    "crash",
                    "patch",
                    "pages",
                    "java",
                    "ym",
                    "text",
                    "mi",
                    "exp",
                    "adb",
                    "jav",
                    "ada",
                    "ii",
                    "defs",
                    "mm",
                    "cpp",
                    "cxx",
                    "pas",
                    "pages-tef",
                    "diff",
                    "pch++",
                    "javascript",
                    "panic",
                    "rb",
                    "ads",
                    "tcsh",
                    "rtfd",
                    "ypp",
                    "yxx",
                    "doc",
                    "ph3",
                    "ph4",
                    "template",
                    "phtml",
                    "hang",
                    "rbw",
                    "f77",
                    "dot",
                    "for",
                    "js",
                    "h++",
                    "mig",
                    "gpurestart",
                    "mii",
                    "zsh",
                    "m3u",
                    "pch",
                    "sh",
                    "applescript",
                    "ymm",
                    "shutdownstall",
                    "dotx",
                    "cc",
                    "scpt",
                    "c",
                    "rtf",
                    "inl",
                    "f",
                    "h",
                    "i",
                    "hpp",
                    "hxx",
                    "dlyan",
                    "l",
                    "cp",
                    "m",
                    "lpp",
                    "lxx",
                    "docx",
                    "txt",
                    "r",
                    "s",
                    "spin",
                    "php",
                    "csh",
                    "y",
                    "bash",
                    "m3u8",
                    "pl",
                    "f90",
                    "pm",
                ],
                "supportedTypes": [
                    "com.apple.rtfd",
                    "com.apple.iwork.pages.sffpages",
                    "com.apple.iwork.pages.sfftemplate",
                    "com.microsoft.word.dot",
                    "com.apple.iwork.pages.pages",
                    "com.microsoft.word.doc",
                    "org.openxmlformats.wordprocessingml.template",
                    "org.openxmlformats.wordprocessingml.document",
                    "com.apple.iwork.pages.pages-tef",
                    "com.apple.iwork.pages.template",
                    "public.rtf",
                    "public.plain-text",
                ],
            },
            {
                "dateCreated": DATE_CREATED,
                "drivewsid": "FOLDER::com.apple.Preview::documents",
                "docwsid": "documents",
                "zone": "com.apple.Preview",
                "name": "Preview",
                "parentId": DRIVEWSID,
                "etag": "bv",
                "type": "APP_LIBRARY",
                "maxDepth": "ANY",
                "icons": [
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Preview&field=icon32x32_OSX",
                        "type": "OSX",
                        "size": 32,
                    },
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Preview&field=icon128x128_OSX",
                        "type": "OSX",
                        "size": 128,
                    },
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Preview&field=icon16x16_OSX",
                        "type": "OSX",
                        "size": 16,
                    },
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Preview&field=icon256x256_OSX",
                        "type": "OSX",
                        "size": 256,
                    },
                    {
                        "url": "https://p31-drivews.icloud.com/getIcons?id=com.apple.Preview&field=icon64x64_OSX",
                        "type": "OSX",
                        "size": 64,
                    },
                ],
                "supportedExtensions": [
                    "ps",
                    "nmbtemplate",
                    "astc",
                    "mpkg",
                    "prefpane",
                    "pef",
                    "mos",
                    "qlgenerator",
                    "scptd",
                    "raf",
                    "saver",
                    "band",
                    "dng",
                    "pict",
                    "exr",
                    "kth",
                    "appex",
                    "app",
                    "pages-tef",
                    "slidesaver",
                    "pluginkit",
                    "distz",
                    "ai",
                    "png",
                    "eps",
                    "raw",
                    "pvr",
                    "mpo",
                    "ktx",
                    "nrw",
                    "lpdf",
                    "pfm",
                    "3fr",
                    "template",
                    "imovielibrary",
                    "pwl",
                    "iwwebpackage",
                    "wdgt",
                    "tga",
                    "pgm",
                    "erf",
                    "jpeg",
                    "j2c",
                    "bundle",
                    "key",
                    "j2k",
                    "abc",
                    "arw",
                    "xpc",
                    "pic",
                    "ppm",
                    "menu",
                    "icns",
                    "mrw",
                    "plugin",
                    "mdimporter",
                    "bmp",
                    "numbers",
                    "dae",
                    "dist",
                    "pic",
                    "rw2",
                    "nef",
                    "tif",
                    "pages",
                    "sgi",
                    "ico",
                    "theater",
                    "gbproj",
                    "webplugin",
                    "cr2",
                    "fff",
                    "webp",
                    "jp2",
                    "sr2",
                    "rtfd",
                    "pbm",
                    "pkpass",
                    "jfx",
                    "fpbf",
                    "psd",
                    "xbm",
                    "tiff",
                    "avchd",
                    "gif",
                    "pntg",
                    "rwl",
                    "pset",
                    "pkg",
                    "dcr",
                    "hdr",
                    "jpe",
                    "pct",
                    "jpg",
                    "jpf",
                    "orf",
                    "srf",
                    "numbers-tef",
                    "iconset",
                    "crw",
                    "fpx",
                    "dds",
                    "pdf",
                    "jpx",
                    "key-tef",
                    "efx",
                    "hdr",
                    "srw",
                ],
                "supportedTypes": [
                    "com.adobe.illustrator.ai-image",
                    "com.kodak.flashpix-image",
                    "public.pbm",
                    "com.apple.pict",
                    "com.ilm.openexr-image",
                    "com.sgi.sgi-image",
                    "com.apple.icns",
                    "public.heifs",
                    "com.truevision.tga-image",
                    "com.adobe.postscript",
                    "public.camera-raw-image",
                    "public.pvr",
                    "public.png",
                    "com.adobe.photoshop-image",
                    "public.heif",
                    "com.microsoft.ico",
                    "com.adobe.pdf",
                    "public.heic",
                    "public.xbitmap-image",
                    "com.apple.localized-pdf-bundle",
                    "public.3d-content",
                    "com.compuserve.gif",
                    "public.avci",
                    "public.jpeg",
                    "com.apple.rjpeg",
                    "com.adobe.encapsulated-postscript",
                    "com.microsoft.bmp",
                    "public.fax",
                    "org.khronos.astc",
                    "com.apple.application-bundle",
                    "public.avcs",
                    "public.webp",
                    "public.heics",
                    "com.apple.macpaint-image",
                    "public.mpo-image",
                    "public.jpeg-2000",
                    "public.tiff",
                    "com.microsoft.dds",
                    "com.apple.pdf-printer-settings",
                    "org.khronos.ktx",
                    "public.radiance",
                    "com.apple.package",
                    "public.folder",
                ],
            },
            {
                "drivewsid": FOLDER1,
                "docwsid": "1C7F1760-D940-480F-8C4F-005824A4E05B",
                "zone": ZONE,
                "name": "pyiCloud",
                "parentId": DRIVEWSID,
                "etag": "30",
                "type": "FOLDER",
                "assetQuota": 42199575,
                "fileCount": 2,
                "shareCount": 0,
                "shareAliasCount": 0,
                "directChildrenCount": 1,
            },
        ],
        "numberOfItems": 5,
    }
]

# App specific folder (Keynote, Numbers, Pages, Preview ...) type=APP_LIBRARY
DRIVE_ROOT_INVALID = [
    {"drivewsid": "FOLDER::com.apple.CloudDocs::documents", "status": "ID_INVALID"}
]

DRIVE_FOLDER_WORKING = [
    {
        "drivewsid": FOLDER1,
        "docwsid": "1C7F1760-D940-480F-8C4F-005824A4E05B",
        "zone": ZONE,
        "name": "pyiCloud",
        "parentId": DRIVEWSID,
        "etag": "30",
        "type": "FOLDER",
        "assetQuota": 42199575,
        "fileCount": 2,
        "shareCount": 0,
        "shareAliasCount": 0,
        "directChildrenCount": 1,
        "items": [
            {
                "drivewsid": FOLDER2,
                "docwsid": "D5AA0425-E84F-4501-AF5D-60F1D92648CF",
                "zone": ZONE,
                "name": "Test",
                "parentId": FOLDER1,
                "etag": "2z",
                "type": "FOLDER",
                "assetQuota": 42199575,
                "fileCount": 2,
                "shareCount": 0,
                "shareAliasCount": 0,
                "directChildrenCount": 2,
            }
        ],
        "numberOfItems": 1,
    }
]

DRIVE_SUBFOLDER_WORKING = [
    {
        "drivewsid": FOLDER2,
        "docwsid": "D5AA0425-E84F-4501-AF5D-60F1D92648CF",
        "zone": ZONE,
        "name": "Test",
        "parentId": FOLDER1,
        "etag": "2z",
        "type": "FOLDER",
        "assetQuota": 42199575,
        "fileCount": 2,
        "shareCount": 0,
        "shareAliasCount": 0,
        "directChildrenCount": 2,
        "items": [
            {
                "drivewsid": "FILE::com.apple.CloudDocs::33A41112-4131-4938-9691-7F356CE3C51D",
                "docwsid": "33A41112-4131-4938-9691-7F356CE3C51D",
                "zone": ZONE,
                "name": "Document scanné 2",
                "parentId": FOLDER2,
                "dateModified": "2020-04-27T21:37:36Z",
                "dateChanged": "2020-04-27T14:44:29-07:00",
                "size": 19876991,
                "etag": "2k::2j",
                "extension": "pdf",
                "hiddenExtension": True,
                "lastOpenTime": "2020-04-27T21:37:36Z",
                "type": "FILE",
            },
            {
                "drivewsid": "FILE::com.apple.CloudDocs::516C896C-6AA5-4A30-B30E-5502C2333DAE",
                "docwsid": "516C896C-6AA5-4A30-B30E-5502C2333DAE",
                "zone": ZONE,
                "name": "Scanned document 1",
                "parentId": FOLDER2,
                "dateModified": "2020-05-03T00:15:17Z",
                "dateChanged": "2020-05-02T17:16:17-07:00",
                "size": 21644358,
                "etag": "32::2x",
                "extension": "pdf",
                "hiddenExtension": True,
                "lastOpenTime": "2020-05-03T00:24:25Z",
                "type": "FILE",
            },
        ],
        "numberOfItems": 2,
    }
]

DRIVE_FILE_DOWNLOAD_WORKING = {
    "document_id": "516C896C-6AA5-4A30-B30E-5502C2333DAE",
    "data_token": {
        "url": "https://cvws.icloud-content.com/B/signature1ref_signature1/Scanned+document+1.pdf?o=object1&v=1&x=3&a=token1&e=1588472097&k=wrapping_key1&fl=&r=request&ckc=com.apple.clouddocs&ckz=com.apple.CloudDocs&p=31&s=s1",
        "token": "token1",
        "signature": "signature1",
        "wrapping_key": "wrapping_key1==",
        "reference_signature": "ref_signature1",
    },
    "thumbnail_token": {
        "url": "https://cvws.icloud-content.com/B/signature2ref_signature2/Scanned+document+1.jpg?o=object2&v=1&x=3&a=token2&e=1588472097&k=wrapping_key2&fl=&r=request&ckc=com.apple.clouddocs&ckz=com.apple.CloudDocs&p=31&s=s2",
        "token": "token2",
        "signature": "signature2",
        "wrapping_key": "wrapping_key2==",
        "reference_signature": "ref_signature2",
    },
    "double_etag": "32::2x",
}

DRIVE_TRASH_WORKING = [
    {
        "items": [
            {
                "dateCreated": "2022-06-23T20:58:35Z",
                "drivewsid": "FILE::com.apple.CloudDocs::C2AD01E4-E625-47FE-AE83-4DF311A05A48",
                "docwsid": "C2AD01E4-E625-47FE-AE83-4DF311A05A48",
                "zone": ZONE,
                "name": "dead-file",
                "extension": "download",
                "parentId": "TRASH_ROOT",
                "dateExpiration": "2024-12-12T02:17:55Z",
                "isChainedToParent": True,
                "dateModified": "2022-06-23T20:43:02Z",
                "dateChanged": "2024-11-12T02:17:55Z",
                "size": 11364977,
                "etag": "o72::o6y",
                "restorePath": "Downloads/dead-file.download",
                "lastOpenTime": "2024-11-12T02:15:18Z",
                "type": "FILE",
            },
            {
                "dateCreated": "2024-11-12T04:41:18Z",
                "drivewsid": "FOLDER::com.apple.CloudDocs::31102B37-D62F-4322-862C-EDE2030C8AFA",
                "docwsid": "31102B37-D62F-4322-862C-EDE2030C8AFA",
                "zone": ZONE,
                "name": "test_create_folder",
                "parentId": "TRASH_ROOT",
                "dateExpiration": "2024-12-12T04:48:22Z",
                "isChainedToParent": True,
                "restorePath": "test_create_folder",
                "etag": "o96",
                "type": "FOLDER",
                "assetQuota": 0,
                "fileCount": 0,
                "shareCount": 0,
                "shareAliasCount": 0,
                "directChildrenCount": 0,
            },
            {
                "dateCreated": "2024-11-12T04:18:13Z",
                "drivewsid": "FOLDER::com.apple.CloudDocs::478AEA23-42A2-468A-ABC1-1A04BC07F738",
                "docwsid": "478AEA23-42A2-468A-ABC1-1A04BC07F738",
                "zone": ZONE,
                "name": "test_delete_forever_and_ever",
                "parentId": "TRASH_ROOT",
                "dateExpiration": "2024-12-12T04:18:20Z",
                "isChainedToParent": True,
                "restorePath": "test_delete_forever_and_ever",
                "etag": "o8h",
                "type": "FOLDER",
                "assetQuota": 0,
                "fileCount": 0,
                "shareCount": 0,
                "shareAliasCount": 0,
                "directChildrenCount": 0,
            },
            {
                "dateCreated": "2024-11-12T03:41:18Z",
                "drivewsid": "FOLDER::com.apple.CloudDocs::E63A9193-4428-4AE1-A334-83B880C75379",
                "docwsid": "E63A9193-4428-4AE1-A334-83B880C75379",
                "zone": ZONE,
                "name": "test_files_1",
                "parentId": "TRASH_ROOT",
                "dateExpiration": "2024-12-12T03:42:07Z",
                "isChainedToParent": True,
                "restorePath": "test_files_1",
                "etag": "o7s",
                "type": "FOLDER",
                "assetQuota": 7,
                "fileCount": 1,
                "shareCount": 0,
                "shareAliasCount": 0,
                "directChildrenCount": 1,
            },
            {
                "dateCreated": "2024-11-12T03:37:13Z",
                "drivewsid": "FOLDER::com.apple.CloudDocs::2BF8600B-5DCC-4421-805A-1C28D07197D5",
                "docwsid": "2BF8600B-5DCC-4421-805A-1C28D07197D5",
                "zone": ZONE,
                "name": "test_random_uuid",
                "parentId": "TRASH_ROOT",
                "dateExpiration": "2024-12-12T03:57:30Z",
                "isChainedToParent": True,
                "restorePath": "test_random_uuid",
                "etag": "o9a",
                "type": "FOLDER",
                "assetQuota": 0,
                "fileCount": 0,
                "shareCount": 0,
                "shareAliasCount": 0,
                "directChildrenCount": 0,
            },
            {
                "dateCreated": "2024-11-12T04:25:27Z",
                "drivewsid": "FOLDER::com.apple.CloudDocs::B9B90B8D-CCC2-4BDB-A58D-289F746C3478",
                "docwsid": "B9B90B8D-CCC2-4BDB-A58D-289F746C3478",
                "zone": ZONE,
                "name": "test12345",
                "parentId": "TRASH_ROOT",
                "dateExpiration": "2024-12-12T04:31:46Z",
                "isChainedToParent": True,
                "restorePath": "test12345",
                "etag": "o8y",
                "type": "FOLDER",
                "assetQuota": 0,
                "fileCount": 0,
                "shareCount": 0,
                "shareAliasCount": 0,
                "directChildrenCount": 0,
            },
        ],
        "numberOfItems": 6,
        "drivewsid": "TRASH_ROOT",
    }
]

DRIVE_TRASH_RECOVER_WORKING = {
    "items": [
        {
            "dateCreated": "2024-11-12T03:37:13Z",
            "drivewsid": "FOLDER::com.apple.CloudDocs::2BF8600B-5DCC-4421-805A-1C28D07197D5",
            "docwsid": "2BF8600B-5DCC-4421-805A-1C28D07197D5",
            "zone": ZONE,
            "name": "test_random_uuid",
            "parentId": DRIVEWSID,
            "isChainedToParent": True,
            "item_id": "CJC_vaYFEAAiEH8Y2nkmm0bfntz-AmIQWC4",
            "etag": "o9g",
            "type": "FOLDER",
            "assetQuota": 0,
            "fileCount": 0,
            "shareCount": 0,
            "shareAliasCount": 0,
            "directChildrenCount": 0,
            "status": "OK",
        }
    ]
}

DRIVE_TRASH_DELETE_FOREVER_WORKING = {
    "items": [
        {
            "dateCreated": "2024-11-12T04:18:14Z",
            "drivewsid": "FOLDER::com.apple.CloudDocs::478AEA23-42A2-468A-ABC1-1A04BC07F738",
            "docwsid": "478AEA23-42A2-468A-ABC1-1A04BC07F738",
            "zone": ZONE,
            "name": "test_delete_forever_and_ever",
            "isDeleted": True,
            "parentId": "FOLDER::com.apple.CloudDocs::43D7C666-6E6E-4522-8999-0B519C3A1F4B",
            "dateExpiration": "2024-12-12T04:18:20Z",
            "isChainedToParent": True,
            "item_id": "CJqQty4QACIQjiS90WklSeGExLvHPWWruzgB",
            "restorePath": "test_delete_forever_and_ever",
            "etag": "null",
            "type": "FOLDER",
            "assetQuota": 0,
            "fileCount": 0,
            "shareCount": 0,
            "shareAliasCount": 0,
            "directChildrenCount": 0,
            "status": "OK",
        }
    ]
}
