;; __kernel void test_64(__global int* res)
;; {
;;     long tid = get_global_id(0);
;;
;;     switch(tid)
;;     {
;;     case 0:
;;         res[tid] = 1;
;;         break;
;;     case 1:
;;         res[tid] = 2;
;;         break;
;;     case 21474836481:
;;         res[tid] = 3;
;;         break;
;;     }
;; }
;; bash$ clang -cc1 -triple spir64-unknown-unknown -x cl -cl-std=CL2.0 -O0 -include opencl.h -emit-llvm OpSwitch.cl -o test_64.ll

; RUN: llc -O0 -mtriple=spirv64-unknown-unknown %s -o - | FileCheck %s --check-prefix=CHECK-SPIRV

; RUN: %if spirv-tools %{ llc -O0 -mtriple=spirv64-unknown-unknown %s -o - -filetype=obj | spirv-val %}

; RUN: %if spirv-tools %{ llc -O0 -mtriple=spirv64-unknown-unknown %s -o - -filetype=asm | spirv-as - -o /dev/null %}

; CHECK-SPIRV: OpSwitch %[[#]] %[[#]] 0 %[[#]] 1 %[[#]] 21474836481 %[[#]]

define spir_kernel void @test_64(ptr addrspace(1) %res) {
entry:
  %res.addr = alloca ptr addrspace(1), align 8
  %tid = alloca i64, align 8
  store ptr addrspace(1) %res, ptr %res.addr, align 8
  %call = call spir_func i64 @_Z13get_global_idj(i32 0)
  store i64 %call, ptr %tid, align 8
  %0 = load i64, ptr %tid, align 8
  switch i64 %0, label %sw.epilog [
    i64 0, label %sw.bb
    i64 1, label %sw.bb1
    i64 21474836481, label %sw.bb3
  ]

sw.bb:                                            ; preds = %entry
  %1 = load i64, ptr %tid, align 8
  %2 = load ptr addrspace(1), ptr %res.addr, align 8
  %arrayidx = getelementptr inbounds i32, ptr addrspace(1) %2, i64 %1
  store i32 1, ptr addrspace(1) %arrayidx, align 4
  br label %sw.epilog

sw.bb1:                                           ; preds = %entry
  %3 = load i64, ptr %tid, align 8
  %4 = load ptr addrspace(1), ptr %res.addr, align 8
  %arrayidx2 = getelementptr inbounds i32, ptr addrspace(1) %4, i64 %3
  store i32 2, ptr addrspace(1) %arrayidx2, align 4
  br label %sw.epilog

sw.bb3:                                           ; preds = %entry
  %5 = load i64, ptr %tid, align 8
  %6 = load ptr addrspace(1), ptr %res.addr, align 8
  %arrayidx4 = getelementptr inbounds i32, ptr addrspace(1) %6, i64 %5
  store i32 3, ptr addrspace(1) %arrayidx4, align 4
  br label %sw.epilog

sw.epilog:                                        ; preds = %entry, %sw.bb3, %sw.bb1, %sw.bb
  ret void
}

declare spir_func i64 @_Z13get_global_idj(i32)
