; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=mipsel < %s | FileCheck -check-prefix=MIPSEL %s
; RUN: llc -mtriple=mips < %s | FileCheck %s -check-prefixes=SOFT-FLOAT-32
; RUN: llc -mtriple=mips64 < %s | FileCheck %s -check-prefixes=SOFT-FLOAT-64

define { half, half } @test_sincos_f16(half %a) #0 {
; MIPSEL-LABEL: test_sincos_f16:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -32
; MIPSEL-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 24($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    jal __extendhfsf2
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:    addiu $5, $sp, 20
; MIPSEL-NEXT:    addiu $6, $sp, 16
; MIPSEL-NEXT:    jal sincosf
; MIPSEL-NEXT:    mov.s $f12, $f0
; MIPSEL-NEXT:    jal __truncsfhf2
; MIPSEL-NEXT:    lwc1 $f12, 20($sp)
; MIPSEL-NEXT:    move $16, $2
; MIPSEL-NEXT:    jal __truncsfhf2
; MIPSEL-NEXT:    lwc1 $f12, 16($sp)
; MIPSEL-NEXT:    move $3, $2
; MIPSEL-NEXT:    move $2, $16
; MIPSEL-NEXT:    lw $16, 24($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-32-LABEL: test_sincos_f16:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -32
; SOFT-FLOAT-32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 24($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-32-NEXT:    nop
; SOFT-FLOAT-32-NEXT:    addiu $5, $sp, 20
; SOFT-FLOAT-32-NEXT:    addiu $6, $sp, 16
; SOFT-FLOAT-32-NEXT:    jal sincosf
; SOFT-FLOAT-32-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-32-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-32-NEXT:    lwc1 $f12, 20($sp)
; SOFT-FLOAT-32-NEXT:    move $16, $2
; SOFT-FLOAT-32-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-32-NEXT:    lwc1 $f12, 16($sp)
; SOFT-FLOAT-32-NEXT:    move $3, $2
; SOFT-FLOAT-32-NEXT:    move $2, $16
; SOFT-FLOAT-32-NEXT:    lw $16, 24($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-64-LABEL: test_sincos_f16:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -32
; SOFT-FLOAT-64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-64-NEXT:    sll $4, $4, 0
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 12
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 8
; SOFT-FLOAT-64-NEXT:    jal sincosf
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-64-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-64-NEXT:    lwc1 $f12, 12($sp)
; SOFT-FLOAT-64-NEXT:    move $16, $2
; SOFT-FLOAT-64-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-64-NEXT:    lwc1 $f12, 8($sp)
; SOFT-FLOAT-64-NEXT:    move $3, $2
; SOFT-FLOAT-64-NEXT:    move $2, $16
; SOFT-FLOAT-64-NEXT:    ld $16, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 32
  %result = call { half, half } @llvm.sincos.f16(half %a)
  ret { half, half } %result
}

define half @test_sincos_f16_only_use_sin(half %a) #0 {
; MIPSEL-LABEL: test_sincos_f16_only_use_sin:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -32
; MIPSEL-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    jal __extendhfsf2
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:    addiu $5, $sp, 24
; MIPSEL-NEXT:    addiu $6, $sp, 20
; MIPSEL-NEXT:    jal sincosf
; MIPSEL-NEXT:    mov.s $f12, $f0
; MIPSEL-NEXT:    jal __truncsfhf2
; MIPSEL-NEXT:    lwc1 $f12, 24($sp)
; MIPSEL-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-32-LABEL: test_sincos_f16_only_use_sin:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -32
; SOFT-FLOAT-32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-32-NEXT:    nop
; SOFT-FLOAT-32-NEXT:    addiu $5, $sp, 24
; SOFT-FLOAT-32-NEXT:    addiu $6, $sp, 20
; SOFT-FLOAT-32-NEXT:    jal sincosf
; SOFT-FLOAT-32-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-32-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-32-NEXT:    lwc1 $f12, 24($sp)
; SOFT-FLOAT-32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-64-LABEL: test_sincos_f16_only_use_sin:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-64-NEXT:    sll $4, $4, 0
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 4
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 0
; SOFT-FLOAT-64-NEXT:    jal sincosf
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-64-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-64-NEXT:    lwc1 $f12, 4($sp)
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.0 = extractvalue { half, half } %result, 0
  ret half %result.0
}

define half @test_sincos_f16_only_use_cos(half %a) #0 {
; MIPSEL-LABEL: test_sincos_f16_only_use_cos:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -32
; MIPSEL-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    jal __extendhfsf2
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:    addiu $5, $sp, 24
; MIPSEL-NEXT:    addiu $6, $sp, 20
; MIPSEL-NEXT:    jal sincosf
; MIPSEL-NEXT:    mov.s $f12, $f0
; MIPSEL-NEXT:    jal __truncsfhf2
; MIPSEL-NEXT:    lwc1 $f12, 20($sp)
; MIPSEL-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-32-LABEL: test_sincos_f16_only_use_cos:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -32
; SOFT-FLOAT-32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-32-NEXT:    nop
; SOFT-FLOAT-32-NEXT:    addiu $5, $sp, 24
; SOFT-FLOAT-32-NEXT:    addiu $6, $sp, 20
; SOFT-FLOAT-32-NEXT:    jal sincosf
; SOFT-FLOAT-32-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-32-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-32-NEXT:    lwc1 $f12, 20($sp)
; SOFT-FLOAT-32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-64-LABEL: test_sincos_f16_only_use_cos:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-64-NEXT:    sll $4, $4, 0
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 4
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 0
; SOFT-FLOAT-64-NEXT:    jal sincosf
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-64-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-64-NEXT:    lwc1 $f12, 0($sp)
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.1 = extractvalue { half, half } %result, 1
  ret half %result.1
}

define { <2 x half>, <2 x half> } @test_sincos_v2f16(<2 x half> %a) #0 {
; MIPSEL-LABEL: test_sincos_v2f16:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -48
; MIPSEL-NEXT:    sw $ra, 44($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $17, 40($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 36($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    move $16, $5
; MIPSEL-NEXT:    move $17, $4
; MIPSEL-NEXT:    jal __extendhfsf2
; MIPSEL-NEXT:    move $4, $5
; MIPSEL-NEXT:    addiu $5, $sp, 24
; MIPSEL-NEXT:    addiu $6, $sp, 20
; MIPSEL-NEXT:    jal sincosf
; MIPSEL-NEXT:    mov.s $f12, $f0
; MIPSEL-NEXT:    jal __extendhfsf2
; MIPSEL-NEXT:    srl $4, $16, 16
; MIPSEL-NEXT:    addiu $5, $sp, 32
; MIPSEL-NEXT:    addiu $6, $sp, 28
; MIPSEL-NEXT:    jal sincosf
; MIPSEL-NEXT:    mov.s $f12, $f0
; MIPSEL-NEXT:    jal __truncsfhf2
; MIPSEL-NEXT:    lwc1 $f12, 20($sp)
; MIPSEL-NEXT:    lwc1 $f12, 24($sp)
; MIPSEL-NEXT:    jal __truncsfhf2
; MIPSEL-NEXT:    sh $2, 4($17)
; MIPSEL-NEXT:    sh $2, 0($17)
; MIPSEL-NEXT:    jal __truncsfhf2
; MIPSEL-NEXT:    lwc1 $f12, 28($sp)
; MIPSEL-NEXT:    sh $2, 6($17)
; MIPSEL-NEXT:    jal __truncsfhf2
; MIPSEL-NEXT:    lwc1 $f12, 32($sp)
; MIPSEL-NEXT:    sh $2, 2($17)
; MIPSEL-NEXT:    lw $16, 36($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $17, 40($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 44($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 48
;
; SOFT-FLOAT-32-LABEL: test_sincos_v2f16:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -48
; SOFT-FLOAT-32-NEXT:    sw $ra, 44($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $17, 40($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 36($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $16, $5
; SOFT-FLOAT-32-NEXT:    move $17, $4
; SOFT-FLOAT-32-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-32-NEXT:    move $4, $5
; SOFT-FLOAT-32-NEXT:    addiu $5, $sp, 24
; SOFT-FLOAT-32-NEXT:    addiu $6, $sp, 20
; SOFT-FLOAT-32-NEXT:    jal sincosf
; SOFT-FLOAT-32-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-32-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-32-NEXT:    srl $4, $16, 16
; SOFT-FLOAT-32-NEXT:    addiu $5, $sp, 32
; SOFT-FLOAT-32-NEXT:    addiu $6, $sp, 28
; SOFT-FLOAT-32-NEXT:    jal sincosf
; SOFT-FLOAT-32-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-32-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-32-NEXT:    lwc1 $f12, 20($sp)
; SOFT-FLOAT-32-NEXT:    lwc1 $f12, 24($sp)
; SOFT-FLOAT-32-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-32-NEXT:    sh $2, 6($17)
; SOFT-FLOAT-32-NEXT:    sh $2, 2($17)
; SOFT-FLOAT-32-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-32-NEXT:    lwc1 $f12, 28($sp)
; SOFT-FLOAT-32-NEXT:    sh $2, 4($17)
; SOFT-FLOAT-32-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-32-NEXT:    lwc1 $f12, 32($sp)
; SOFT-FLOAT-32-NEXT:    sh $2, 0($17)
; SOFT-FLOAT-32-NEXT:    lw $16, 36($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $17, 40($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 44($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 48
;
; SOFT-FLOAT-64-LABEL: test_sincos_v2f16:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -48
; SOFT-FLOAT-64-NEXT:    sd $ra, 40($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $17, 32($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    move $17, $5
; SOFT-FLOAT-64-NEXT:    move $16, $4
; SOFT-FLOAT-64-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-64-NEXT:    sll $4, $5, 0
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 12
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 8
; SOFT-FLOAT-64-NEXT:    jal sincosf
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-64-NEXT:    sll $1, $17, 0
; SOFT-FLOAT-64-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-64-NEXT:    srl $4, $1, 16
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 20
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 16
; SOFT-FLOAT-64-NEXT:    jal sincosf
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-64-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-64-NEXT:    lwc1 $f12, 8($sp)
; SOFT-FLOAT-64-NEXT:    lwc1 $f12, 12($sp)
; SOFT-FLOAT-64-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-64-NEXT:    sh $2, 6($16)
; SOFT-FLOAT-64-NEXT:    sh $2, 2($16)
; SOFT-FLOAT-64-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-64-NEXT:    lwc1 $f12, 16($sp)
; SOFT-FLOAT-64-NEXT:    sh $2, 4($16)
; SOFT-FLOAT-64-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-64-NEXT:    lwc1 $f12, 20($sp)
; SOFT-FLOAT-64-NEXT:    sh $2, 0($16)
; SOFT-FLOAT-64-NEXT:    ld $16, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $17, 32($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 40($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 48
  %result = call { <2 x half>, <2 x half> } @llvm.sincos.v2f16(<2 x half> %a)
  ret { <2 x half>, <2 x half> } %result
}

define { float, float } @test_sincos_f32(float %a) #0 {
; MIPSEL-LABEL: test_sincos_f32:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -32
; MIPSEL-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    addiu $5, $sp, 24
; MIPSEL-NEXT:    jal sincosf
; MIPSEL-NEXT:    addiu $6, $sp, 20
; MIPSEL-NEXT:    lwc1 $f0, 24($sp)
; MIPSEL-NEXT:    lwc1 $f2, 20($sp)
; MIPSEL-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-32-LABEL: test_sincos_f32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -32
; SOFT-FLOAT-32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    addiu $5, $sp, 24
; SOFT-FLOAT-32-NEXT:    jal sincosf
; SOFT-FLOAT-32-NEXT:    addiu $6, $sp, 20
; SOFT-FLOAT-32-NEXT:    lwc1 $f0, 24($sp)
; SOFT-FLOAT-32-NEXT:    lwc1 $f2, 20($sp)
; SOFT-FLOAT-32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-64-LABEL: test_sincos_f32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 4
; SOFT-FLOAT-64-NEXT:    jal sincosf
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 0
; SOFT-FLOAT-64-NEXT:    lwc1 $f0, 4($sp)
; SOFT-FLOAT-64-NEXT:    lwc1 $f2, 0($sp)
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
  %result = call { float, float } @llvm.sincos.f32(float %a)
  ret { float, float } %result
}

define { <2 x float>, <2 x float> } @test_sincos_v2f32(<2 x float> %a) #0 {
; MIPSEL-LABEL: test_sincos_v2f32:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -32
; MIPSEL-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    move $16, $6
; MIPSEL-NEXT:    move $17, $4
; MIPSEL-NEXT:    mtc1 $7, $f12
; MIPSEL-NEXT:    addiu $5, $4, 4
; MIPSEL-NEXT:    jal sincosf
; MIPSEL-NEXT:    addiu $6, $4, 12
; MIPSEL-NEXT:    mtc1 $16, $f12
; MIPSEL-NEXT:    addiu $6, $17, 8
; MIPSEL-NEXT:    jal sincosf
; MIPSEL-NEXT:    move $5, $17
; MIPSEL-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-32-LABEL: test_sincos_v2f32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -32
; SOFT-FLOAT-32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $16, $6
; SOFT-FLOAT-32-NEXT:    move $17, $4
; SOFT-FLOAT-32-NEXT:    mtc1 $7, $f12
; SOFT-FLOAT-32-NEXT:    addiu $5, $4, 4
; SOFT-FLOAT-32-NEXT:    jal sincosf
; SOFT-FLOAT-32-NEXT:    addiu $6, $4, 12
; SOFT-FLOAT-32-NEXT:    mtc1 $16, $f12
; SOFT-FLOAT-32-NEXT:    addiu $6, $17, 8
; SOFT-FLOAT-32-NEXT:    jal sincosf
; SOFT-FLOAT-32-NEXT:    move $5, $17
; SOFT-FLOAT-32-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-64-LABEL: test_sincos_v2f32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -32
; SOFT-FLOAT-64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    move $16, $4
; SOFT-FLOAT-64-NEXT:    dsrl $1, $4, 32
; SOFT-FLOAT-64-NEXT:    sll $1, $1, 0
; SOFT-FLOAT-64-NEXT:    mtc1 $1, $f12
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 12
; SOFT-FLOAT-64-NEXT:    jal sincosf
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 8
; SOFT-FLOAT-64-NEXT:    sll $1, $16, 0
; SOFT-FLOAT-64-NEXT:    mtc1 $1, $f12
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 4
; SOFT-FLOAT-64-NEXT:    jal sincosf
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 0
; SOFT-FLOAT-64-NEXT:    lwc1 $f0, 12($sp)
; SOFT-FLOAT-64-NEXT:    mfc1 $1, $f0
; SOFT-FLOAT-64-NEXT:    dsll $1, $1, 32
; SOFT-FLOAT-64-NEXT:    lwc1 $f0, 8($sp)
; SOFT-FLOAT-64-NEXT:    mfc1 $3, $f0
; SOFT-FLOAT-64-NEXT:    lwc1 $f0, 4($sp)
; SOFT-FLOAT-64-NEXT:    mfc1 $2, $f0
; SOFT-FLOAT-64-NEXT:    dsll $2, $2, 32
; SOFT-FLOAT-64-NEXT:    dsrl $2, $2, 32
; SOFT-FLOAT-64-NEXT:    or $2, $2, $1
; SOFT-FLOAT-64-NEXT:    dsll $1, $3, 32
; SOFT-FLOAT-64-NEXT:    lwc1 $f0, 0($sp)
; SOFT-FLOAT-64-NEXT:    mfc1 $3, $f0
; SOFT-FLOAT-64-NEXT:    dsll $3, $3, 32
; SOFT-FLOAT-64-NEXT:    dsrl $3, $3, 32
; SOFT-FLOAT-64-NEXT:    or $3, $3, $1
; SOFT-FLOAT-64-NEXT:    ld $16, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 32
; SOFT-FLOAT-64R2-LABEL: test_sincos_v2f32:
; SOFT-FLOAT-64R2:       # %bb.0:
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, -32
; SOFT-FLOAT-64R2-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $16, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    move $16, $4
; SOFT-FLOAT-64R2-NEXT:    dsrl $1, $4, 32
; SOFT-FLOAT-64R2-NEXT:    sll $1, $1, 0
; SOFT-FLOAT-64R2-NEXT:    mtc1 $1, $f12
; SOFT-FLOAT-64R2-NEXT:    daddiu $5, $sp, 12
; SOFT-FLOAT-64R2-NEXT:    jal sincosf
; SOFT-FLOAT-64R2-NEXT:    daddiu $6, $sp, 8
; SOFT-FLOAT-64R2-NEXT:    sll $1, $16, 0
; SOFT-FLOAT-64R2-NEXT:    mtc1 $1, $f12
; SOFT-FLOAT-64R2-NEXT:    daddiu $5, $sp, 4
; SOFT-FLOAT-64R2-NEXT:    jal sincosf
; SOFT-FLOAT-64R2-NEXT:    daddiu $6, $sp, 0
; SOFT-FLOAT-64R2-NEXT:    lwc1 $f0, 12($sp)
; SOFT-FLOAT-64R2-NEXT:    mfc1 $1, $f0
; SOFT-FLOAT-64R2-NEXT:    dsll $1, $1, 32
; SOFT-FLOAT-64R2-NEXT:    lwc1 $f0, 4($sp)
; SOFT-FLOAT-64R2-NEXT:    mfc1 $2, $f0
; SOFT-FLOAT-64R2-NEXT:    dext $2, $2, 0, 32
; SOFT-FLOAT-64R2-NEXT:    lwc1 $f0, 8($sp)
; SOFT-FLOAT-64R2-NEXT:    or $2, $2, $1
; SOFT-FLOAT-64R2-NEXT:    mfc1 $1, $f0
; SOFT-FLOAT-64R2-NEXT:    dsll $1, $1, 32
; SOFT-FLOAT-64R2-NEXT:    lwc1 $f0, 0($sp)
; SOFT-FLOAT-64R2-NEXT:    mfc1 $3, $f0
; SOFT-FLOAT-64R2-NEXT:    dext $3, $3, 0, 32
; SOFT-FLOAT-64R2-NEXT:    or $3, $3, $1
; SOFT-FLOAT-64R2-NEXT:    ld $16, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    jr $ra
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, 32
  %result = call { <2 x float>, <2 x float> } @llvm.sincos.v2f32(<2 x float> %a)
  ret { <2 x float>, <2 x float> } %result
}

define { <3 x float>, <3 x float> } @test_sincos_v3f32(<3 x float> %a) #0 {
; MIPSEL-LABEL: test_sincos_v3f32:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -32
; MIPSEL-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $18, 24($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $17, 20($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    move $16, $6
; MIPSEL-NEXT:    move $17, $5
; MIPSEL-NEXT:    move $18, $4
; MIPSEL-NEXT:    mtc1 $7, $f12
; MIPSEL-NEXT:    addiu $5, $4, 8
; MIPSEL-NEXT:    jal sincosf
; MIPSEL-NEXT:    addiu $6, $4, 24
; MIPSEL-NEXT:    mtc1 $16, $f12
; MIPSEL-NEXT:    addiu $5, $18, 4
; MIPSEL-NEXT:    jal sincosf
; MIPSEL-NEXT:    addiu $6, $18, 20
; MIPSEL-NEXT:    mtc1 $17, $f12
; MIPSEL-NEXT:    addiu $6, $18, 16
; MIPSEL-NEXT:    jal sincosf
; MIPSEL-NEXT:    move $5, $18
; MIPSEL-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $17, 20($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $18, 24($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-32-LABEL: test_sincos_v3f32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -32
; SOFT-FLOAT-32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $18, 24($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $17, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $16, $6
; SOFT-FLOAT-32-NEXT:    move $17, $5
; SOFT-FLOAT-32-NEXT:    move $18, $4
; SOFT-FLOAT-32-NEXT:    mtc1 $7, $f12
; SOFT-FLOAT-32-NEXT:    addiu $5, $4, 8
; SOFT-FLOAT-32-NEXT:    jal sincosf
; SOFT-FLOAT-32-NEXT:    addiu $6, $4, 24
; SOFT-FLOAT-32-NEXT:    mtc1 $16, $f12
; SOFT-FLOAT-32-NEXT:    addiu $5, $18, 4
; SOFT-FLOAT-32-NEXT:    jal sincosf
; SOFT-FLOAT-32-NEXT:    addiu $6, $18, 20
; SOFT-FLOAT-32-NEXT:    mtc1 $17, $f12
; SOFT-FLOAT-32-NEXT:    addiu $6, $18, 16
; SOFT-FLOAT-32-NEXT:    jal sincosf
; SOFT-FLOAT-32-NEXT:    move $5, $18
; SOFT-FLOAT-32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $17, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $18, 24($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-64-LABEL: test_sincos_v3f32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -48
; SOFT-FLOAT-64-NEXT:    sdc1 $f25, 40($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sdc1 $f24, 32($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    mov.s $f24, $f15
; SOFT-FLOAT-64-NEXT:    mov.s $f25, $f14
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f13
; SOFT-FLOAT-64-NEXT:    move $16, $4
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 4
; SOFT-FLOAT-64-NEXT:    jal sincosf
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 0
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 12
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 8
; SOFT-FLOAT-64-NEXT:    jal sincosf
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f25
; SOFT-FLOAT-64-NEXT:    daddiu $5, $16, 8
; SOFT-FLOAT-64-NEXT:    daddiu $6, $16, 24
; SOFT-FLOAT-64-NEXT:    jal sincosf
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f24
; SOFT-FLOAT-64-NEXT:    lwc1 $f0, 0($sp)
; SOFT-FLOAT-64-NEXT:    mfc1 $1, $f0
; SOFT-FLOAT-64-NEXT:    lwc1 $f0, 4($sp)
; SOFT-FLOAT-64-NEXT:    mfc1 $2, $f0
; SOFT-FLOAT-64-NEXT:    dsll $1, $1, 32
; SOFT-FLOAT-64-NEXT:    lwc1 $f0, 8($sp)
; SOFT-FLOAT-64-NEXT:    mfc1 $3, $f0
; SOFT-FLOAT-64-NEXT:    dsll $3, $3, 32
; SOFT-FLOAT-64-NEXT:    dsrl $3, $3, 32
; SOFT-FLOAT-64-NEXT:    or $1, $3, $1
; SOFT-FLOAT-64-NEXT:    sd $1, 16($16)
; SOFT-FLOAT-64-NEXT:    dsll $1, $2, 32
; SOFT-FLOAT-64-NEXT:    lwc1 $f0, 12($sp)
; SOFT-FLOAT-64-NEXT:    mfc1 $2, $f0
; SOFT-FLOAT-64-NEXT:    dsll $2, $2, 32
; SOFT-FLOAT-64-NEXT:    dsrl $2, $2, 32
; SOFT-FLOAT-64-NEXT:    or $1, $2, $1
; SOFT-FLOAT-64-NEXT:    sd $1, 0($16)
; SOFT-FLOAT-64-NEXT:    ld $16, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ldc1 $f24, 32($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ldc1 $f25, 40($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 48
; SOFT-FLOAT-64R2-LABEL: test_sincos_v3f32:
; SOFT-FLOAT-64R2:       # %bb.0:
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, -48
; SOFT-FLOAT-64R2-NEXT:    sdc1 $f25, 40($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sdc1 $f24, 32($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    sd $16, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64R2-NEXT:    mov.s $f24, $f15
; SOFT-FLOAT-64R2-NEXT:    mov.s $f25, $f14
; SOFT-FLOAT-64R2-NEXT:    mov.s $f12, $f13
; SOFT-FLOAT-64R2-NEXT:    move $16, $4
; SOFT-FLOAT-64R2-NEXT:    daddiu $5, $sp, 4
; SOFT-FLOAT-64R2-NEXT:    jal sincosf
; SOFT-FLOAT-64R2-NEXT:    daddiu $6, $sp, 0
; SOFT-FLOAT-64R2-NEXT:    daddiu $5, $sp, 12
; SOFT-FLOAT-64R2-NEXT:    daddiu $6, $sp, 8
; SOFT-FLOAT-64R2-NEXT:    jal sincosf
; SOFT-FLOAT-64R2-NEXT:    mov.s $f12, $f25
; SOFT-FLOAT-64R2-NEXT:    daddiu $5, $16, 8
; SOFT-FLOAT-64R2-NEXT:    daddiu $6, $16, 24
; SOFT-FLOAT-64R2-NEXT:    jal sincosf
; SOFT-FLOAT-64R2-NEXT:    mov.s $f12, $f24
; SOFT-FLOAT-64R2-NEXT:    lwc1 $f0, 0($sp)
; SOFT-FLOAT-64R2-NEXT:    mfc1 $1, $f0
; SOFT-FLOAT-64R2-NEXT:    dsll $1, $1, 32
; SOFT-FLOAT-64R2-NEXT:    lwc1 $f0, 8($sp)
; SOFT-FLOAT-64R2-NEXT:    mfc1 $2, $f0
; SOFT-FLOAT-64R2-NEXT:    dext $2, $2, 0, 32
; SOFT-FLOAT-64R2-NEXT:    or $1, $2, $1
; SOFT-FLOAT-64R2-NEXT:    lwc1 $f0, 4($sp)
; SOFT-FLOAT-64R2-NEXT:    mfc1 $2, $f0
; SOFT-FLOAT-64R2-NEXT:    sd $1, 16($16)
; SOFT-FLOAT-64R2-NEXT:    dsll $1, $2, 32
; SOFT-FLOAT-64R2-NEXT:    lwc1 $f0, 12($sp)
; SOFT-FLOAT-64R2-NEXT:    mfc1 $2, $f0
; SOFT-FLOAT-64R2-NEXT:    dext $2, $2, 0, 32
; SOFT-FLOAT-64R2-NEXT:    or $1, $2, $1
; SOFT-FLOAT-64R2-NEXT:    sd $1, 0($16)
; SOFT-FLOAT-64R2-NEXT:    ld $16, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ldc1 $f24, 32($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    ldc1 $f25, 40($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64R2-NEXT:    jr $ra
; SOFT-FLOAT-64R2-NEXT:    daddiu $sp, $sp, 48
  %result = call { <3 x float>, <3 x float> } @llvm.sincos.v3f32(<3 x float> %a)
  ret { <3 x float>, <3 x float> } %result
}

define { double, double } @test_sincos_f64(double %a) #0 {
; MIPSEL-LABEL: test_sincos_f64:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -40
; MIPSEL-NEXT:    sw $ra, 36($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    addiu $6, $sp, 24
; MIPSEL-NEXT:    jal sincos
; MIPSEL-NEXT:    addiu $7, $sp, 16
; MIPSEL-NEXT:    ldc1 $f0, 24($sp)
; MIPSEL-NEXT:    ldc1 $f2, 16($sp)
; MIPSEL-NEXT:    lw $ra, 36($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 40
;
; SOFT-FLOAT-32-LABEL: test_sincos_f64:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -40
; SOFT-FLOAT-32-NEXT:    sw $ra, 36($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    addiu $6, $sp, 24
; SOFT-FLOAT-32-NEXT:    jal sincos
; SOFT-FLOAT-32-NEXT:    addiu $7, $sp, 16
; SOFT-FLOAT-32-NEXT:    ldc1 $f0, 24($sp)
; SOFT-FLOAT-32-NEXT:    ldc1 $f2, 16($sp)
; SOFT-FLOAT-32-NEXT:    lw $ra, 36($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 40
;
; SOFT-FLOAT-64-LABEL: test_sincos_f64:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -32
; SOFT-FLOAT-64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 16
; SOFT-FLOAT-64-NEXT:    jal sincos
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 8
; SOFT-FLOAT-64-NEXT:    ldc1 $f0, 16($sp)
; SOFT-FLOAT-64-NEXT:    ldc1 $f2, 8($sp)
; SOFT-FLOAT-64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 32
  %result = call { double, double } @llvm.sincos.f64(double %a)
  ret { double, double } %result
}

define { <2 x double>, <2 x double> } @test_sincos_v2f64(<2 x double> %a) #0 {
; MIPSEL-LABEL: test_sincos_v2f64:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -40
; MIPSEL-NEXT:    sw $ra, 36($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 32($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    move $16, $4
; MIPSEL-NEXT:    lw $1, 56($sp)
; MIPSEL-NEXT:    lw $2, 60($sp)
; MIPSEL-NEXT:    sw $2, 28($sp)
; MIPSEL-NEXT:    sw $1, 24($sp)
; MIPSEL-NEXT:    sw $7, 20($sp)
; MIPSEL-NEXT:    sw $6, 16($sp)
; MIPSEL-NEXT:    addiu $6, $4, 8
; MIPSEL-NEXT:    addiu $7, $4, 24
; MIPSEL-NEXT:    jal sincos
; MIPSEL-NEXT:    ldc1 $f12, 24($sp)
; MIPSEL-NEXT:    addiu $7, $16, 16
; MIPSEL-NEXT:    ldc1 $f12, 16($sp)
; MIPSEL-NEXT:    jal sincos
; MIPSEL-NEXT:    move $6, $16
; MIPSEL-NEXT:    lw $16, 32($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 36($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 40
;
; SOFT-FLOAT-32-LABEL: test_sincos_v2f64:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -40
; SOFT-FLOAT-32-NEXT:    sw $ra, 36($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 32($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $16, $4
; SOFT-FLOAT-32-NEXT:    lw $1, 56($sp)
; SOFT-FLOAT-32-NEXT:    lw $2, 60($sp)
; SOFT-FLOAT-32-NEXT:    sw $2, 28($sp)
; SOFT-FLOAT-32-NEXT:    sw $1, 24($sp)
; SOFT-FLOAT-32-NEXT:    sw $7, 20($sp)
; SOFT-FLOAT-32-NEXT:    sw $6, 16($sp)
; SOFT-FLOAT-32-NEXT:    addiu $6, $4, 8
; SOFT-FLOAT-32-NEXT:    addiu $7, $4, 24
; SOFT-FLOAT-32-NEXT:    jal sincos
; SOFT-FLOAT-32-NEXT:    ldc1 $f12, 24($sp)
; SOFT-FLOAT-32-NEXT:    addiu $7, $16, 16
; SOFT-FLOAT-32-NEXT:    ldc1 $f12, 16($sp)
; SOFT-FLOAT-32-NEXT:    jal sincos
; SOFT-FLOAT-32-NEXT:    move $6, $16
; SOFT-FLOAT-32-NEXT:    lw $16, 32($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 36($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 40
;
; SOFT-FLOAT-64-LABEL: test_sincos_v2f64:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -32
; SOFT-FLOAT-64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $17, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    move $16, $5
; SOFT-FLOAT-64-NEXT:    move $17, $4
; SOFT-FLOAT-64-NEXT:    dmtc1 $6, $f12
; SOFT-FLOAT-64-NEXT:    daddiu $5, $4, 8
; SOFT-FLOAT-64-NEXT:    jal sincos
; SOFT-FLOAT-64-NEXT:    daddiu $6, $4, 24
; SOFT-FLOAT-64-NEXT:    dmtc1 $16, $f12
; SOFT-FLOAT-64-NEXT:    daddiu $6, $17, 16
; SOFT-FLOAT-64-NEXT:    jal sincos
; SOFT-FLOAT-64-NEXT:    move $5, $17
; SOFT-FLOAT-64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $17, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 32
; SOFT-FLOAT-32R2-LABEL: test_sincos_v2f64:
; SOFT-FLOAT-32R2:       # %bb.0:
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, -32
; SOFT-FLOAT-32R2-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $18, 24($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $17, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32R2-NEXT:    move $16, $7
; SOFT-FLOAT-32R2-NEXT:    move $17, $6
; SOFT-FLOAT-32R2-NEXT:    move $18, $4
; SOFT-FLOAT-32R2-NEXT:    lw $1, 48($sp)
; SOFT-FLOAT-32R2-NEXT:    lw $2, 52($sp)
; SOFT-FLOAT-32R2-NEXT:    mtc1 $2, $f12
; SOFT-FLOAT-32R2-NEXT:    mthc1 $1, $f12
; SOFT-FLOAT-32R2-NEXT:    addiu $6, $4, 8
; SOFT-FLOAT-32R2-NEXT:    jal sincos
; SOFT-FLOAT-32R2-NEXT:    addiu $7, $4, 24
; SOFT-FLOAT-32R2-NEXT:    mtc1 $16, $f12
; SOFT-FLOAT-32R2-NEXT:    mthc1 $17, $f12
; SOFT-FLOAT-32R2-NEXT:    addiu $7, $18, 16
; SOFT-FLOAT-32R2-NEXT:    jal sincos
; SOFT-FLOAT-32R2-NEXT:    move $6, $18
; SOFT-FLOAT-32R2-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $17, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $18, 24($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32R2-NEXT:    jr $ra
; SOFT-FLOAT-32R2-NEXT:    addiu $sp, $sp, 32
  %result = call { <2 x double>, <2 x double> } @llvm.sincos.v2f64(<2 x double> %a)
  ret { <2 x double>, <2 x double> } %result
}

define { fp128, fp128 } @test_sincos_f128(fp128 %a) #0 {
; MIPSEL-LABEL: test_sincos_f128:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -64
; MIPSEL-NEXT:    sw $ra, 60($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 56($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    move $1, $7
; MIPSEL-NEXT:    move $16, $4
; MIPSEL-NEXT:    addiu $2, $sp, 24
; MIPSEL-NEXT:    sw $2, 20($sp)
; MIPSEL-NEXT:    addiu $2, $sp, 40
; MIPSEL-NEXT:    sw $2, 16($sp)
; MIPSEL-NEXT:    lw $7, 80($sp)
; MIPSEL-NEXT:    move $4, $5
; MIPSEL-NEXT:    move $5, $6
; MIPSEL-NEXT:    jal sincosl
; MIPSEL-NEXT:    move $6, $1
; MIPSEL-NEXT:    lw $1, 52($sp)
; MIPSEL-NEXT:    lw $2, 24($sp)
; MIPSEL-NEXT:    lw $3, 28($sp)
; MIPSEL-NEXT:    lw $4, 32($sp)
; MIPSEL-NEXT:    lw $5, 36($sp)
; MIPSEL-NEXT:    sw $5, 28($16)
; MIPSEL-NEXT:    sw $4, 24($16)
; MIPSEL-NEXT:    sw $3, 20($16)
; MIPSEL-NEXT:    sw $2, 16($16)
; MIPSEL-NEXT:    sw $1, 12($16)
; MIPSEL-NEXT:    lw $1, 48($sp)
; MIPSEL-NEXT:    sw $1, 8($16)
; MIPSEL-NEXT:    lw $1, 44($sp)
; MIPSEL-NEXT:    sw $1, 4($16)
; MIPSEL-NEXT:    lw $1, 40($sp)
; MIPSEL-NEXT:    sw $1, 0($16)
; MIPSEL-NEXT:    lw $16, 56($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 60($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 64
;
; SOFT-FLOAT-32-LABEL: test_sincos_f128:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -64
; SOFT-FLOAT-32-NEXT:    sw $ra, 60($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 56($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $1, $7
; SOFT-FLOAT-32-NEXT:    move $16, $4
; SOFT-FLOAT-32-NEXT:    addiu $2, $sp, 24
; SOFT-FLOAT-32-NEXT:    sw $2, 20($sp)
; SOFT-FLOAT-32-NEXT:    addiu $2, $sp, 40
; SOFT-FLOAT-32-NEXT:    sw $2, 16($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 80($sp)
; SOFT-FLOAT-32-NEXT:    move $4, $5
; SOFT-FLOAT-32-NEXT:    move $5, $6
; SOFT-FLOAT-32-NEXT:    jal sincosl
; SOFT-FLOAT-32-NEXT:    move $6, $1
; SOFT-FLOAT-32-NEXT:    lw $1, 52($sp)
; SOFT-FLOAT-32-NEXT:    lw $2, 24($sp)
; SOFT-FLOAT-32-NEXT:    lw $3, 28($sp)
; SOFT-FLOAT-32-NEXT:    lw $4, 32($sp)
; SOFT-FLOAT-32-NEXT:    lw $5, 36($sp)
; SOFT-FLOAT-32-NEXT:    sw $5, 28($16)
; SOFT-FLOAT-32-NEXT:    sw $4, 24($16)
; SOFT-FLOAT-32-NEXT:    sw $3, 20($16)
; SOFT-FLOAT-32-NEXT:    sw $2, 16($16)
; SOFT-FLOAT-32-NEXT:    sw $1, 12($16)
; SOFT-FLOAT-32-NEXT:    lw $1, 48($sp)
; SOFT-FLOAT-32-NEXT:    sw $1, 8($16)
; SOFT-FLOAT-32-NEXT:    lw $1, 44($sp)
; SOFT-FLOAT-32-NEXT:    sw $1, 4($16)
; SOFT-FLOAT-32-NEXT:    lw $1, 40($sp)
; SOFT-FLOAT-32-NEXT:    sw $1, 0($16)
; SOFT-FLOAT-32-NEXT:    lw $16, 56($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 60($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 64
;
; SOFT-FLOAT-64-LABEL: test_sincos_f128:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -48
; SOFT-FLOAT-64-NEXT:    sd $ra, 40($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 16
; SOFT-FLOAT-64-NEXT:    jal sincosl
; SOFT-FLOAT-64-NEXT:    daddiu $7, $sp, 0
; SOFT-FLOAT-64-NEXT:    ldc1 $f0, 16($sp)
; SOFT-FLOAT-64-NEXT:    ldc1 $f2, 24($sp)
; SOFT-FLOAT-64-NEXT:    ld $2, 0($sp)
; SOFT-FLOAT-64-NEXT:    ld $3, 8($sp)
; SOFT-FLOAT-64-NEXT:    ld $ra, 40($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 48
  %result = call { fp128, fp128 } @llvm.sincos.f128(fp128 %a)
  ret { fp128, fp128 } %result
}

define { <2 x fp128>, <2 x fp128> } @test_sincos_v2f128(<2 x fp128> %a) #0 {
; MIPSEL-LABEL: test_sincos_v2f128:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -96
; MIPSEL-NEXT:    sw $ra, 92($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 88($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    move $5, $7
; MIPSEL-NEXT:    move $1, $6
; MIPSEL-NEXT:    move $16, $4
; MIPSEL-NEXT:    addiu $2, $sp, 24
; MIPSEL-NEXT:    sw $2, 20($sp)
; MIPSEL-NEXT:    addiu $2, $sp, 40
; MIPSEL-NEXT:    sw $2, 16($sp)
; MIPSEL-NEXT:    lw $6, 112($sp)
; MIPSEL-NEXT:    lw $7, 116($sp)
; MIPSEL-NEXT:    jal sincosl
; MIPSEL-NEXT:    move $4, $1
; MIPSEL-NEXT:    addiu $1, $sp, 56
; MIPSEL-NEXT:    sw $1, 20($sp)
; MIPSEL-NEXT:    addiu $1, $sp, 72
; MIPSEL-NEXT:    sw $1, 16($sp)
; MIPSEL-NEXT:    lw $4, 120($sp)
; MIPSEL-NEXT:    lw $5, 124($sp)
; MIPSEL-NEXT:    lw $6, 128($sp)
; MIPSEL-NEXT:    lw $7, 132($sp)
; MIPSEL-NEXT:    jal sincosl
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:    lw $1, 36($sp)
; MIPSEL-NEXT:    lw $2, 56($sp)
; MIPSEL-NEXT:    lw $3, 60($sp)
; MIPSEL-NEXT:    lw $4, 64($sp)
; MIPSEL-NEXT:    lw $5, 52($sp)
; MIPSEL-NEXT:    lw $6, 72($sp)
; MIPSEL-NEXT:    lw $7, 76($sp)
; MIPSEL-NEXT:    lw $8, 80($sp)
; MIPSEL-NEXT:    lw $9, 84($sp)
; MIPSEL-NEXT:    lw $10, 24($sp)
; MIPSEL-NEXT:    lw $11, 28($sp)
; MIPSEL-NEXT:    lw $12, 32($sp)
; MIPSEL-NEXT:    lw $13, 68($sp)
; MIPSEL-NEXT:    sw $13, 60($16)
; MIPSEL-NEXT:    sw $4, 56($16)
; MIPSEL-NEXT:    sw $3, 52($16)
; MIPSEL-NEXT:    sw $2, 48($16)
; MIPSEL-NEXT:    sw $1, 44($16)
; MIPSEL-NEXT:    sw $12, 40($16)
; MIPSEL-NEXT:    sw $11, 36($16)
; MIPSEL-NEXT:    sw $10, 32($16)
; MIPSEL-NEXT:    sw $9, 28($16)
; MIPSEL-NEXT:    sw $8, 24($16)
; MIPSEL-NEXT:    sw $7, 20($16)
; MIPSEL-NEXT:    sw $6, 16($16)
; MIPSEL-NEXT:    sw $5, 12($16)
; MIPSEL-NEXT:    lw $1, 48($sp)
; MIPSEL-NEXT:    sw $1, 8($16)
; MIPSEL-NEXT:    lw $1, 44($sp)
; MIPSEL-NEXT:    sw $1, 4($16)
; MIPSEL-NEXT:    lw $1, 40($sp)
; MIPSEL-NEXT:    sw $1, 0($16)
; MIPSEL-NEXT:    lw $16, 88($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 92($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 96
;
; SOFT-FLOAT-32-LABEL: test_sincos_v2f128:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -96
; SOFT-FLOAT-32-NEXT:    sw $ra, 92($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 88($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $5, $7
; SOFT-FLOAT-32-NEXT:    move $1, $6
; SOFT-FLOAT-32-NEXT:    move $16, $4
; SOFT-FLOAT-32-NEXT:    addiu $2, $sp, 24
; SOFT-FLOAT-32-NEXT:    sw $2, 20($sp)
; SOFT-FLOAT-32-NEXT:    addiu $2, $sp, 40
; SOFT-FLOAT-32-NEXT:    sw $2, 16($sp)
; SOFT-FLOAT-32-NEXT:    lw $6, 112($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 116($sp)
; SOFT-FLOAT-32-NEXT:    jal sincosl
; SOFT-FLOAT-32-NEXT:    move $4, $1
; SOFT-FLOAT-32-NEXT:    addiu $1, $sp, 56
; SOFT-FLOAT-32-NEXT:    sw $1, 20($sp)
; SOFT-FLOAT-32-NEXT:    addiu $1, $sp, 72
; SOFT-FLOAT-32-NEXT:    sw $1, 16($sp)
; SOFT-FLOAT-32-NEXT:    lw $4, 120($sp)
; SOFT-FLOAT-32-NEXT:    lw $5, 124($sp)
; SOFT-FLOAT-32-NEXT:    lw $6, 128($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 132($sp)
; SOFT-FLOAT-32-NEXT:    jal sincosl
; SOFT-FLOAT-32-NEXT:    nop
; SOFT-FLOAT-32-NEXT:    lw $1, 36($sp)
; SOFT-FLOAT-32-NEXT:    lw $2, 56($sp)
; SOFT-FLOAT-32-NEXT:    lw $3, 60($sp)
; SOFT-FLOAT-32-NEXT:    lw $4, 64($sp)
; SOFT-FLOAT-32-NEXT:    lw $5, 52($sp)
; SOFT-FLOAT-32-NEXT:    lw $6, 72($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 76($sp)
; SOFT-FLOAT-32-NEXT:    lw $8, 80($sp)
; SOFT-FLOAT-32-NEXT:    lw $9, 84($sp)
; SOFT-FLOAT-32-NEXT:    lw $10, 24($sp)
; SOFT-FLOAT-32-NEXT:    lw $11, 28($sp)
; SOFT-FLOAT-32-NEXT:    lw $12, 32($sp)
; SOFT-FLOAT-32-NEXT:    lw $13, 68($sp)
; SOFT-FLOAT-32-NEXT:    sw $13, 60($16)
; SOFT-FLOAT-32-NEXT:    sw $4, 56($16)
; SOFT-FLOAT-32-NEXT:    sw $3, 52($16)
; SOFT-FLOAT-32-NEXT:    sw $2, 48($16)
; SOFT-FLOAT-32-NEXT:    sw $1, 44($16)
; SOFT-FLOAT-32-NEXT:    sw $12, 40($16)
; SOFT-FLOAT-32-NEXT:    sw $11, 36($16)
; SOFT-FLOAT-32-NEXT:    sw $10, 32($16)
; SOFT-FLOAT-32-NEXT:    sw $9, 28($16)
; SOFT-FLOAT-32-NEXT:    sw $8, 24($16)
; SOFT-FLOAT-32-NEXT:    sw $7, 20($16)
; SOFT-FLOAT-32-NEXT:    sw $6, 16($16)
; SOFT-FLOAT-32-NEXT:    sw $5, 12($16)
; SOFT-FLOAT-32-NEXT:    lw $1, 48($sp)
; SOFT-FLOAT-32-NEXT:    sw $1, 8($16)
; SOFT-FLOAT-32-NEXT:    lw $1, 44($sp)
; SOFT-FLOAT-32-NEXT:    sw $1, 4($16)
; SOFT-FLOAT-32-NEXT:    lw $1, 40($sp)
; SOFT-FLOAT-32-NEXT:    sw $1, 0($16)
; SOFT-FLOAT-32-NEXT:    lw $16, 88($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 92($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 96
;
; SOFT-FLOAT-64-LABEL: test_sincos_v2f128:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -96
; SOFT-FLOAT-64-NEXT:    sd $ra, 88($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $18, 80($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $17, 72($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 64($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    move $16, $6
; SOFT-FLOAT-64-NEXT:    move $17, $5
; SOFT-FLOAT-64-NEXT:    move $18, $4
; SOFT-FLOAT-64-NEXT:    dmtc1 $7, $f12
; SOFT-FLOAT-64-NEXT:    dmtc1 $8, $f13
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 48
; SOFT-FLOAT-64-NEXT:    jal sincosl
; SOFT-FLOAT-64-NEXT:    daddiu $7, $sp, 32
; SOFT-FLOAT-64-NEXT:    dmtc1 $17, $f12
; SOFT-FLOAT-64-NEXT:    dmtc1 $16, $f13
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 16
; SOFT-FLOAT-64-NEXT:    jal sincosl
; SOFT-FLOAT-64-NEXT:    daddiu $7, $sp, 0
; SOFT-FLOAT-64-NEXT:    ld $1, 56($sp)
; SOFT-FLOAT-64-NEXT:    ld $2, 0($sp)
; SOFT-FLOAT-64-NEXT:    ld $3, 8($sp)
; SOFT-FLOAT-64-NEXT:    ld $4, 32($sp)
; SOFT-FLOAT-64-NEXT:    ld $5, 40($sp)
; SOFT-FLOAT-64-NEXT:    sd $5, 56($18)
; SOFT-FLOAT-64-NEXT:    sd $4, 48($18)
; SOFT-FLOAT-64-NEXT:    sd $3, 40($18)
; SOFT-FLOAT-64-NEXT:    sd $2, 32($18)
; SOFT-FLOAT-64-NEXT:    sd $1, 24($18)
; SOFT-FLOAT-64-NEXT:    ld $1, 48($sp)
; SOFT-FLOAT-64-NEXT:    sd $1, 16($18)
; SOFT-FLOAT-64-NEXT:    ld $1, 24($sp)
; SOFT-FLOAT-64-NEXT:    sd $1, 8($18)
; SOFT-FLOAT-64-NEXT:    ld $1, 16($sp)
; SOFT-FLOAT-64-NEXT:    sd $1, 0($18)
; SOFT-FLOAT-64-NEXT:    ld $16, 64($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $17, 72($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $18, 80($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 88($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 96
  %result = call { <2 x fp128>, <2 x fp128> } @llvm.sincos.v2f128(<2 x fp128> %a)
  ret { <2 x fp128>, <2 x fp128> } %result
}

attributes #0 = { nounwind }
