; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=mipsel < %s | FileCheck -check-prefix=MIPSEL %s
; RUN: llc -mtriple=mips < %s | FileCheck %s -check-prefixes=SOFT-FLOAT-32
; RUN: llc -mtriple=mips64 < %s | FileCheck %s -check-prefixes=SOFT-FLOAT-64

define { half, i32 } @test_frexp_f16_i32(half %a) nounwind {
; MIPSEL-LABEL: test_frexp_f16_i32:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -24
; MIPSEL-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    jal __extendhfsf2
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:    addiu $5, $sp, 16
; MIPSEL-NEXT:    jal frexpf
; MIPSEL-NEXT:    mov.s $f12, $f0
; MIPSEL-NEXT:    jal __truncsfhf2
; MIPSEL-NEXT:    mov.s $f12, $f0
; MIPSEL-NEXT:    lw $3, 16($sp)
; MIPSEL-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-32-LABEL: test_frexp_f16_i32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-32-NEXT:    nop
; SOFT-FLOAT-32-NEXT:    addiu $5, $sp, 16
; SOFT-FLOAT-32-NEXT:    jal frexpf
; SOFT-FLOAT-32-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-32-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-32-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-32-NEXT:    lw $3, 16($sp)
; SOFT-FLOAT-32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-64-LABEL: test_frexp_f16_i32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-64-NEXT:    sll $4, $4, 0
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 4
; SOFT-FLOAT-64-NEXT:    jal frexpf
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-64-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-64-NEXT:    lw $3, 4($sp)
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
%result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  ret { half, i32 } %result
}

define { <2 x half>, <2 x i32> } @test_frexp_v2f16_v2i32(<2 x half> %a) nounwind {
; MIPSEL-LABEL: test_frexp_v2f16_v2i32:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -32
; MIPSEL-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $18, 24($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $17, 20($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    move $16, $5
; MIPSEL-NEXT:    move $17, $4
; MIPSEL-NEXT:    jal __extendhfsf2
; MIPSEL-NEXT:    srl $4, $5, 16
; MIPSEL-NEXT:    addiu $5, $17, 12
; MIPSEL-NEXT:    jal frexpf
; MIPSEL-NEXT:    mov.s $f12, $f0
; MIPSEL-NEXT:    jal __truncsfhf2
; MIPSEL-NEXT:    mov.s $f12, $f0
; MIPSEL-NEXT:    move $18, $2
; MIPSEL-NEXT:    jal __extendhfsf2
; MIPSEL-NEXT:    move $4, $16
; MIPSEL-NEXT:    addiu $5, $17, 8
; MIPSEL-NEXT:    jal frexpf
; MIPSEL-NEXT:    mov.s $f12, $f0
; MIPSEL-NEXT:    sh $18, 2($17)
; MIPSEL-NEXT:    jal __truncsfhf2
; MIPSEL-NEXT:    mov.s $f12, $f0
; MIPSEL-NEXT:    sh $2, 0($17)
; MIPSEL-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $17, 20($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $18, 24($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-32-LABEL: test_frexp_v2f16_v2i32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -32
; SOFT-FLOAT-32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $18, 24($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $17, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $16, $5
; SOFT-FLOAT-32-NEXT:    move $17, $4
; SOFT-FLOAT-32-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-32-NEXT:    move $4, $5
; SOFT-FLOAT-32-NEXT:    addiu $5, $17, 12
; SOFT-FLOAT-32-NEXT:    jal frexpf
; SOFT-FLOAT-32-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-32-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-32-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-32-NEXT:    move $18, $2
; SOFT-FLOAT-32-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-32-NEXT:    srl $4, $16, 16
; SOFT-FLOAT-32-NEXT:    addiu $5, $17, 8
; SOFT-FLOAT-32-NEXT:    jal frexpf
; SOFT-FLOAT-32-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-32-NEXT:    sh $18, 2($17)
; SOFT-FLOAT-32-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-32-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-32-NEXT:    sh $2, 0($17)
; SOFT-FLOAT-32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $17, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $18, 24($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-64-LABEL: test_frexp_v2f16_v2i32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -32
; SOFT-FLOAT-64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $18, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $17, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    move $16, $5
; SOFT-FLOAT-64-NEXT:    move $17, $4
; SOFT-FLOAT-64-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-64-NEXT:    sll $4, $5, 0
; SOFT-FLOAT-64-NEXT:    daddiu $5, $17, 12
; SOFT-FLOAT-64-NEXT:    jal frexpf
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-64-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-64-NEXT:    move $18, $2
; SOFT-FLOAT-64-NEXT:    sll $1, $16, 0
; SOFT-FLOAT-64-NEXT:    jal __extendhfsf2
; SOFT-FLOAT-64-NEXT:    srl $4, $1, 16
; SOFT-FLOAT-64-NEXT:    daddiu $5, $17, 8
; SOFT-FLOAT-64-NEXT:    jal frexpf
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-64-NEXT:    sh $18, 2($17)
; SOFT-FLOAT-64-NEXT:    jal __truncsfhf2
; SOFT-FLOAT-64-NEXT:    mov.s $f12, $f0
; SOFT-FLOAT-64-NEXT:    sh $2, 0($17)
; SOFT-FLOAT-64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $17, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $18, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 32
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  ret { <2 x half>, <2 x i32> } %result
}

define { float, i32 } @test_frexp_f32_i32(float %a) nounwind {
; MIPSEL-LABEL: test_frexp_f32_i32:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -24
; MIPSEL-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    jal frexpf
; MIPSEL-NEXT:    addiu $5, $sp, 16
; MIPSEL-NEXT:    lw $2, 16($sp)
; MIPSEL-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-32-LABEL: test_frexp_f32_i32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    jal frexpf
; SOFT-FLOAT-32-NEXT:    addiu $5, $sp, 16
; SOFT-FLOAT-32-NEXT:    lw $2, 16($sp)
; SOFT-FLOAT-32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-64-LABEL: test_frexp_f32_i32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    jal frexpf
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 4
; SOFT-FLOAT-64-NEXT:    lw $2, 4($sp)
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  ret { float, i32 } %result
}

define { float, i32 } @test_frexp_f32_i32_tailcall(float %a) nounwind {
; MIPSEL-LABEL: test_frexp_f32_i32_tailcall:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -24
; MIPSEL-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    jal frexpf
; MIPSEL-NEXT:    addiu $5, $sp, 16
; MIPSEL-NEXT:    lw $2, 16($sp)
; MIPSEL-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-32-LABEL: test_frexp_f32_i32_tailcall:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    jal frexpf
; SOFT-FLOAT-32-NEXT:    addiu $5, $sp, 16
; SOFT-FLOAT-32-NEXT:    lw $2, 16($sp)
; SOFT-FLOAT-32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-64-LABEL: test_frexp_f32_i32_tailcall:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    jal frexpf
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 4
; SOFT-FLOAT-64-NEXT:    lw $2, 4($sp)
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
  %result = tail call { float, i32 } @llvm.frexp.f32.i32(float %a)
  ret { float, i32 } %result
}

define { <2 x float>, <2 x i32> } @test_frexp_v2f32_v2i32(<2 x float> %a) nounwind {
; MIPSEL-LABEL: test_frexp_v2f32_v2i32:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -32
; MIPSEL-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    move $16, $6
; MIPSEL-NEXT:    move $17, $4
; MIPSEL-NEXT:    mtc1 $7, $f12
; MIPSEL-NEXT:    jal frexpf
; MIPSEL-NEXT:    addiu $5, $4, 12
; MIPSEL-NEXT:    swc1 $f0, 4($17)
; MIPSEL-NEXT:    mtc1 $16, $f12
; MIPSEL-NEXT:    jal frexpf
; MIPSEL-NEXT:    addiu $5, $17, 8
; MIPSEL-NEXT:    swc1 $f0, 0($17)
; MIPSEL-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-32-LABEL: test_frexp_v2f32_v2i32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -32
; SOFT-FLOAT-32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $16, $6
; SOFT-FLOAT-32-NEXT:    move $17, $4
; SOFT-FLOAT-32-NEXT:    mtc1 $7, $f12
; SOFT-FLOAT-32-NEXT:    jal frexpf
; SOFT-FLOAT-32-NEXT:    addiu $5, $4, 12
; SOFT-FLOAT-32-NEXT:    swc1 $f0, 4($17)
; SOFT-FLOAT-32-NEXT:    mtc1 $16, $f12
; SOFT-FLOAT-32-NEXT:    jal frexpf
; SOFT-FLOAT-32-NEXT:    addiu $5, $17, 8
; SOFT-FLOAT-32-NEXT:    swc1 $f0, 0($17)
; SOFT-FLOAT-32-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 32
;
; SOFT-FLOAT-64-LABEL: test_frexp_v2f32_v2i32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -32
; SOFT-FLOAT-64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    move $16, $4
; SOFT-FLOAT-64-NEXT:    sll $1, $16, 0
; SOFT-FLOAT-64-NEXT:    mtc1 $1, $f12
; SOFT-FLOAT-64-NEXT:    jal frexpf
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 8
; SOFT-FLOAT-64-NEXT:    mfc1 $1, $f0
; SOFT-FLOAT-64-NEXT:    dsll $1, $1, 32
; SOFT-FLOAT-64-NEXT:    dsrl $2, $16, 32
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 12
; SOFT-FLOAT-64-NEXT:    dsrl $16, $1, 32
; SOFT-FLOAT-64-NEXT:    sll $1, $2, 0
; SOFT-FLOAT-64-NEXT:    jal frexpf
; SOFT-FLOAT-64-NEXT:    mtc1 $1, $f12
; SOFT-FLOAT-64-NEXT:    mfc1 $1, $f0
; SOFT-FLOAT-64-NEXT:    dsll $1, $1, 32
; SOFT-FLOAT-64-NEXT:    or $2, $16, $1
; SOFT-FLOAT-64-NEXT:    lw $1, 12($sp)
; SOFT-FLOAT-64-NEXT:    dsll $1, $1, 32
; SOFT-FLOAT-64-NEXT:    lw $3, 8($sp)
; SOFT-FLOAT-64-NEXT:    dsll $3, $3, 32
; SOFT-FLOAT-64-NEXT:    dsrl $3, $3, 32
; SOFT-FLOAT-64-NEXT:    or $3, $3, $1
; SOFT-FLOAT-64-NEXT:    ld $16, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 32
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  ret { <2 x float>, <2 x i32> } %result
}

define { double, i32 } @test_frexp_f64_i32(double %a) nounwind {
; MIPSEL-LABEL: test_frexp_f64_i32:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -24
; MIPSEL-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    jal frexp
; MIPSEL-NEXT:    addiu $6, $sp, 16
; MIPSEL-NEXT:    lw $2, 16($sp)
; MIPSEL-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-32-LABEL: test_frexp_f64_i32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -24
; SOFT-FLOAT-32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    jal frexp
; SOFT-FLOAT-32-NEXT:    addiu $6, $sp, 16
; SOFT-FLOAT-32-NEXT:    lw $2, 16($sp)
; SOFT-FLOAT-32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 24
;
; SOFT-FLOAT-64-LABEL: test_frexp_f64_i32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    jal frexp
; SOFT-FLOAT-64-NEXT:    daddiu $5, $sp, 4
; SOFT-FLOAT-64-NEXT:    lw $2, 4($sp)
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  ret { double, i32 } %result
}

define { <2 x double>, <2 x i32> } @test_frexp_v2f64_v2i32(<2 x double> %a) nounwind {
; MIPSEL-LABEL: test_frexp_v2f64_v2i32:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -48
; MIPSEL-NEXT:    sw $ra, 44($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $18, 40($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $17, 36($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 32($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    move $16, $7
; MIPSEL-NEXT:    move $17, $6
; MIPSEL-NEXT:    move $18, $4
; MIPSEL-NEXT:    lw $1, 64($sp)
; MIPSEL-NEXT:    lw $2, 68($sp)
; MIPSEL-NEXT:    sw $2, 28($sp)
; MIPSEL-NEXT:    sw $1, 24($sp)
; MIPSEL-NEXT:    addiu $6, $4, 20
; MIPSEL-NEXT:    jal frexp
; MIPSEL-NEXT:    ldc1 $f12, 24($sp)
; MIPSEL-NEXT:    sdc1 $f0, 8($18)
; MIPSEL-NEXT:    sw $16, 20($sp)
; MIPSEL-NEXT:    sw $17, 16($sp)
; MIPSEL-NEXT:    addiu $6, $18, 16
; MIPSEL-NEXT:    jal frexp
; MIPSEL-NEXT:    ldc1 $f12, 16($sp)
; MIPSEL-NEXT:    sdc1 $f0, 0($18)
; MIPSEL-NEXT:    lw $16, 32($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $17, 36($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $18, 40($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 44($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 48
;
; SOFT-FLOAT-32-LABEL: test_frexp_v2f64_v2i32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -48
; SOFT-FLOAT-32-NEXT:    sw $ra, 44($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $18, 40($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $17, 36($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 32($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $16, $7
; SOFT-FLOAT-32-NEXT:    move $17, $6
; SOFT-FLOAT-32-NEXT:    move $18, $4
; SOFT-FLOAT-32-NEXT:    lw $1, 64($sp)
; SOFT-FLOAT-32-NEXT:    lw $2, 68($sp)
; SOFT-FLOAT-32-NEXT:    sw $2, 28($sp)
; SOFT-FLOAT-32-NEXT:    sw $1, 24($sp)
; SOFT-FLOAT-32-NEXT:    addiu $6, $4, 20
; SOFT-FLOAT-32-NEXT:    jal frexp
; SOFT-FLOAT-32-NEXT:    ldc1 $f12, 24($sp)
; SOFT-FLOAT-32-NEXT:    sdc1 $f0, 8($18)
; SOFT-FLOAT-32-NEXT:    sw $16, 20($sp)
; SOFT-FLOAT-32-NEXT:    sw $17, 16($sp)
; SOFT-FLOAT-32-NEXT:    addiu $6, $18, 16
; SOFT-FLOAT-32-NEXT:    jal frexp
; SOFT-FLOAT-32-NEXT:    ldc1 $f12, 16($sp)
; SOFT-FLOAT-32-NEXT:    sdc1 $f0, 0($18)
; SOFT-FLOAT-32-NEXT:    lw $16, 32($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $17, 36($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $18, 40($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 44($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 48
;
; SOFT-FLOAT-64-LABEL: test_frexp_v2f64_v2i32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -32
; SOFT-FLOAT-64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $17, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    move $16, $5
; SOFT-FLOAT-64-NEXT:    move $17, $4
; SOFT-FLOAT-64-NEXT:    dmtc1 $6, $f12
; SOFT-FLOAT-64-NEXT:    jal frexp
; SOFT-FLOAT-64-NEXT:    daddiu $5, $4, 20
; SOFT-FLOAT-64-NEXT:    sdc1 $f0, 8($17)
; SOFT-FLOAT-64-NEXT:    dmtc1 $16, $f12
; SOFT-FLOAT-64-NEXT:    jal frexp
; SOFT-FLOAT-64-NEXT:    daddiu $5, $17, 16
; SOFT-FLOAT-64-NEXT:    sdc1 $f0, 0($17)
; SOFT-FLOAT-64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $17, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 32
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  ret { <2 x double>, <2 x i32> } %result
}

define { fp128, i32 } @test_frexp_fp128_i32(fp128 %a) nounwind {
; MIPSEL-LABEL: test_frexp_fp128_i32:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -40
; MIPSEL-NEXT:    sw $ra, 36($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 32($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    move $1, $7
; MIPSEL-NEXT:    move $16, $4
; MIPSEL-NEXT:    addiu $2, $sp, 28
; MIPSEL-NEXT:    sw $2, 16($sp)
; MIPSEL-NEXT:    lw $7, 56($sp)
; MIPSEL-NEXT:    move $4, $5
; MIPSEL-NEXT:    move $5, $6
; MIPSEL-NEXT:    jal frexpl
; MIPSEL-NEXT:    move $6, $1
; MIPSEL-NEXT:    sw $5, 12($16)
; MIPSEL-NEXT:    sw $4, 8($16)
; MIPSEL-NEXT:    sw $3, 4($16)
; MIPSEL-NEXT:    sw $2, 0($16)
; MIPSEL-NEXT:    lw $1, 28($sp)
; MIPSEL-NEXT:    sw $1, 16($16)
; MIPSEL-NEXT:    lw $16, 32($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 36($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 40
;
; SOFT-FLOAT-32-LABEL: test_frexp_fp128_i32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -40
; SOFT-FLOAT-32-NEXT:    sw $ra, 36($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 32($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $1, $7
; SOFT-FLOAT-32-NEXT:    move $16, $4
; SOFT-FLOAT-32-NEXT:    addiu $2, $sp, 28
; SOFT-FLOAT-32-NEXT:    sw $2, 16($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 56($sp)
; SOFT-FLOAT-32-NEXT:    move $4, $5
; SOFT-FLOAT-32-NEXT:    move $5, $6
; SOFT-FLOAT-32-NEXT:    jal frexpl
; SOFT-FLOAT-32-NEXT:    move $6, $1
; SOFT-FLOAT-32-NEXT:    sw $5, 12($16)
; SOFT-FLOAT-32-NEXT:    sw $4, 8($16)
; SOFT-FLOAT-32-NEXT:    sw $3, 4($16)
; SOFT-FLOAT-32-NEXT:    sw $2, 0($16)
; SOFT-FLOAT-32-NEXT:    lw $1, 28($sp)
; SOFT-FLOAT-32-NEXT:    sw $1, 16($16)
; SOFT-FLOAT-32-NEXT:    lw $16, 32($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 36($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 40
;
; SOFT-FLOAT-64-LABEL: test_frexp_fp128_i32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -16
; SOFT-FLOAT-64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    jal frexpl
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 4
; SOFT-FLOAT-64-NEXT:    lw $2, 4($sp)
; SOFT-FLOAT-64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 16
  %result = call { fp128, i32 } @llvm.frexp.fp128.i32(fp128 %a)
  ret { fp128, i32 } %result
}

define { <2 x fp128>, <2 x i32> } @test_frexp_v2fp128_v2i32(<2 x fp128> %a) nounwind {
; MIPSEL-LABEL: test_frexp_v2fp128_v2i32:
; MIPSEL:       # %bb.0:
; MIPSEL-NEXT:    addiu $sp, $sp, -48
; MIPSEL-NEXT:    sw $ra, 44($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $18, 40($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $17, 36($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    sw $16, 32($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:    move $16, $7
; MIPSEL-NEXT:    move $17, $6
; MIPSEL-NEXT:    move $18, $4
; MIPSEL-NEXT:    addiu $1, $sp, 28
; MIPSEL-NEXT:    sw $1, 16($sp)
; MIPSEL-NEXT:    lw $4, 72($sp)
; MIPSEL-NEXT:    lw $5, 76($sp)
; MIPSEL-NEXT:    lw $6, 80($sp)
; MIPSEL-NEXT:    lw $7, 84($sp)
; MIPSEL-NEXT:    jal frexpl
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:    addiu $1, $sp, 24
; MIPSEL-NEXT:    sw $1, 16($sp)
; MIPSEL-NEXT:    lw $7, 68($sp)
; MIPSEL-NEXT:    lw $6, 64($sp)
; MIPSEL-NEXT:    sw $5, 28($18)
; MIPSEL-NEXT:    sw $4, 24($18)
; MIPSEL-NEXT:    sw $3, 20($18)
; MIPSEL-NEXT:    sw $2, 16($18)
; MIPSEL-NEXT:    move $4, $17
; MIPSEL-NEXT:    jal frexpl
; MIPSEL-NEXT:    move $5, $16
; MIPSEL-NEXT:    sw $5, 12($18)
; MIPSEL-NEXT:    sw $4, 8($18)
; MIPSEL-NEXT:    sw $3, 4($18)
; MIPSEL-NEXT:    sw $2, 0($18)
; MIPSEL-NEXT:    lw $1, 28($sp)
; MIPSEL-NEXT:    sw $1, 36($18)
; MIPSEL-NEXT:    lw $1, 24($sp)
; MIPSEL-NEXT:    sw $1, 32($18)
; MIPSEL-NEXT:    lw $16, 32($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $17, 36($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $18, 40($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    lw $ra, 44($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    addiu $sp, $sp, 48
;
; SOFT-FLOAT-32-LABEL: test_frexp_v2fp128_v2i32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, -48
; SOFT-FLOAT-32-NEXT:    sw $ra, 44($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $18, 40($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $17, 36($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    sw $16, 32($sp) # 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    move $16, $7
; SOFT-FLOAT-32-NEXT:    move $17, $6
; SOFT-FLOAT-32-NEXT:    move $18, $4
; SOFT-FLOAT-32-NEXT:    addiu $1, $sp, 28
; SOFT-FLOAT-32-NEXT:    sw $1, 16($sp)
; SOFT-FLOAT-32-NEXT:    lw $4, 72($sp)
; SOFT-FLOAT-32-NEXT:    lw $5, 76($sp)
; SOFT-FLOAT-32-NEXT:    lw $6, 80($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 84($sp)
; SOFT-FLOAT-32-NEXT:    jal frexpl
; SOFT-FLOAT-32-NEXT:    nop
; SOFT-FLOAT-32-NEXT:    addiu $1, $sp, 24
; SOFT-FLOAT-32-NEXT:    sw $1, 16($sp)
; SOFT-FLOAT-32-NEXT:    lw $7, 68($sp)
; SOFT-FLOAT-32-NEXT:    lw $6, 64($sp)
; SOFT-FLOAT-32-NEXT:    sw $5, 28($18)
; SOFT-FLOAT-32-NEXT:    sw $4, 24($18)
; SOFT-FLOAT-32-NEXT:    sw $3, 20($18)
; SOFT-FLOAT-32-NEXT:    sw $2, 16($18)
; SOFT-FLOAT-32-NEXT:    move $4, $17
; SOFT-FLOAT-32-NEXT:    jal frexpl
; SOFT-FLOAT-32-NEXT:    move $5, $16
; SOFT-FLOAT-32-NEXT:    sw $5, 12($18)
; SOFT-FLOAT-32-NEXT:    sw $4, 8($18)
; SOFT-FLOAT-32-NEXT:    sw $3, 4($18)
; SOFT-FLOAT-32-NEXT:    sw $2, 0($18)
; SOFT-FLOAT-32-NEXT:    lw $1, 28($sp)
; SOFT-FLOAT-32-NEXT:    sw $1, 36($18)
; SOFT-FLOAT-32-NEXT:    lw $1, 24($sp)
; SOFT-FLOAT-32-NEXT:    sw $1, 32($18)
; SOFT-FLOAT-32-NEXT:    lw $16, 32($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $17, 36($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $18, 40($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    lw $ra, 44($sp) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    jr $ra
; SOFT-FLOAT-32-NEXT:    addiu $sp, $sp, 48
;
; SOFT-FLOAT-64-LABEL: test_frexp_v2fp128_v2i32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, -64
; SOFT-FLOAT-64-NEXT:    sdc1 $f25, 56($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sdc1 $f24, 48($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $ra, 40($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $18, 32($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $17, 24($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    sd $16, 16($sp) # 8-byte Folded Spill
; SOFT-FLOAT-64-NEXT:    move $16, $6
; SOFT-FLOAT-64-NEXT:    move $17, $5
; SOFT-FLOAT-64-NEXT:    move $18, $4
; SOFT-FLOAT-64-NEXT:    dmtc1 $7, $f12
; SOFT-FLOAT-64-NEXT:    dmtc1 $8, $f13
; SOFT-FLOAT-64-NEXT:    jal frexpl
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 12
; SOFT-FLOAT-64-NEXT:    mov.d $f24, $f0
; SOFT-FLOAT-64-NEXT:    mov.d $f25, $f2
; SOFT-FLOAT-64-NEXT:    dmtc1 $17, $f12
; SOFT-FLOAT-64-NEXT:    dmtc1 $16, $f13
; SOFT-FLOAT-64-NEXT:    daddiu $6, $sp, 8
; SOFT-FLOAT-64-NEXT:    lw $1, 12($sp)
; SOFT-FLOAT-64-NEXT:    jal frexpl
; SOFT-FLOAT-64-NEXT:    sw $1, 36($18)
; SOFT-FLOAT-64-NEXT:    lw $1, 8($sp)
; SOFT-FLOAT-64-NEXT:    sw $1, 32($18)
; SOFT-FLOAT-64-NEXT:    sdc1 $f25, 24($18)
; SOFT-FLOAT-64-NEXT:    sdc1 $f24, 16($18)
; SOFT-FLOAT-64-NEXT:    sdc1 $f2, 8($18)
; SOFT-FLOAT-64-NEXT:    sdc1 $f0, 0($18)
; SOFT-FLOAT-64-NEXT:    ld $16, 16($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $17, 24($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $18, 32($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ld $ra, 40($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ldc1 $f24, 48($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    ldc1 $f25, 56($sp) # 8-byte Folded Reload
; SOFT-FLOAT-64-NEXT:    jr $ra
; SOFT-FLOAT-64-NEXT:    daddiu $sp, $sp, 64
  %result = call { <2 x fp128>, <2 x i32> } @llvm.frexp.v2fp128.v2i32(<2 x fp128> %a)
  ret { <2 x fp128>, <2 x i32> } %result
}

declare { half, i32 } @llvm.frexp.f16.i32(half) #0
declare { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half>) #0

declare { float, i32 } @llvm.frexp.f32.i32(float) #0
declare { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float>) #0

declare { double, i32 } @llvm.frexp.f64.i32(double) #0
declare { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double>) #0

declare { fp128, i32 } @llvm.frexp.fp128.i32(fp128) #0
declare { <2 x fp128>, <2 x i32> } @llvm.frexp.v2fp128.v2i32(<2 x fp128>) #0

attributes #0 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
