#pragma once
/*
 *  $Id: gwyappinternal.h 28811 2025-11-05 18:52:44Z yeti-dn $
 *  Copyright (C) 2004-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*< private_header >*/

#ifndef __GWYAPP_INTERNAL_H__
#define __GWYAPP_INTERNAL_H__

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <libgwyddion/spectra.h>
#include <libgwyddion/brick.h>
#include <libgwyddion/lawn.h>
#include <libgwyui/gwydatawindow.h>
#include <libgwyui/gwyglwindow.h>
#include <libgwyui/graph-window.h>
#include <libgwyui/sensitivity-group.h>

#include <libgwyapp/gwyappfilechooser.h>
#include <libgwyapp/file.h>
#include <libgwyapp/params.h>
#include <libgwyapp/data-browser.h>
#include <libgwyapp/app-image-window.h>

G_BEGIN_DECLS

/* The GtkTargetEntry for tree model drags.
 * FIXME: Is it Gtk+ private or what? */
#define GTK_TREE_MODEL_ROW { "GTK_TREE_MODEL_ROW", GTK_TARGET_SAME_APP, 0 }

enum {
    THUMB_SIZE = 60,
    TMS_NORMAL_THUMB_SIZE = 128,
    GWY_FILE_N_KINDS = GWY_FILE_CMAP + 1,
};

typedef struct {
    GLogLevelFlags log_level;
    GQuark log_domain;
    gchar *message;
} GwyAppLogMessage;

G_GNUC_INTERNAL gint              _gwy_app_get_n_recent_files           (void);
G_GNUC_INTERNAL GdkPixbuf*        _gwy_app_recent_file_try_thumbnail    (const gchar *filename_sys);
G_GNUC_INTERNAL void              _gwy_app_recent_file_write_thumbnail  (const gchar *filename_sys,
                                                                         GwyFile *data,
                                                                         GwyDataKind data_kind,
                                                                         gint id,
                                                                         GdkPixbuf *pixbuf);
G_GNUC_INTERNAL void              _gwy_app_log_start_message_capture    (void);
G_GNUC_INTERNAL void              _gwy_app_log_discard_captured_messages(void);
G_GNUC_INTERNAL GwyAppLogMessage* _gwy_app_log_get_captured_messages    (guint *nmesg);
G_GNUC_INTERNAL void              _gwy_data_browser_add_messages        (GwyFile *data);
G_GNUC_INTERNAL GtkTextBuffer*    _gwy_app_log_create_textbuf           (void);
G_GNUC_INTERNAL void              _gwy_app_log_add_message_to_textbuf   (GtkTextBuffer *textbuf,
                                                                         const gchar *message,
                                                                         GLogLevelFlags log_level);
G_GNUC_INTERNAL GwyField*         _gwy_app_create_brick_preview_field   (GwyBrick *brick);
G_GNUC_INTERNAL GwyField*         _gwy_app_create_lawn_preview_field    (GwyLawn *lawn);
G_GNUC_INTERNAL void              _gwy_file_set_info                    (GwyFile *file,
                                                                         const gchar *name,
                                                                         const gchar *filename_sys);
G_GNUC_INTERNAL const gchar*      _gwy_data_kind_name                   (GwyDataKind data_kind);
G_GNUC_INTERNAL const gchar*      _gwy_file_piece_name                  (GwyFilePiece piece);
G_GNUC_INTERNAL void              _gwy_save_widget_screen_size          (GtkWidget *widget,
                                                                         const GdkRectangle *allocation,
                                                                         GwyFile *file,
                                                                         GwyDataKind data_kind,
                                                                         gint id,
                                                                         gboolean absolute_too);
G_GNUC_INTERNAL void              _gwy_restore_window_size              (GtkWindow *window,
                                                                         GwyContainer *container,
                                                                         const gchar *prefix);
G_GNUC_INTERNAL GwyParams*        _gwy_app_image_window_get_params      (GwyAppImageWindow *window);
G_GNUC_INTERNAL void              _gwy_app_change_volume_preview        (GwyAppImageWindow *window);
G_GNUC_INTERNAL void              _gwy_app_change_cmap_preview          (GwyAppImageWindow *window);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
