import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Data } from "@ot-builder/prelude";
import { WriteTimeIVS } from "@ot-builder/var-store";
import { CffStringSink } from "../strings/sink";
export declare class CffWriteContext {
    readonly version: number;
    readonly upm: number;
    ivs: WriteTimeIVS | null;
    strings: CffStringSink | null;
    stat: CffGlyphStatSink;
    constructor(version: number, upm: number, acceptVariation?: boolean, gss?: Data.Maybe<OtGlyph.Stat.Sink>);
    getLimits(): CffLimits;
}
export interface CffLimits {
    readonly maxStack: number;
    readonly maxRecursion: number;
    readonly maxSubrs: number;
    readonly retSize: number;
    readonly endCharSize: number;
}
export declare const Cff1Limits: CffLimits;
export declare const Cff2Limits: CffLimits;
export interface CffEncodingOptions extends CffLimits {
    readonly forceBlendToPleaseTtx?: boolean;
    readonly blendOperator: number;
    readonly vsIndexOperator: number;
}
export declare class CffGlyphStatSink implements OtGlyph.Stat.Sink {
    private readonly outer?;
    fontBBox: OtGlyph.Stat.BoundingBoxBuilder;
    constructor(outer?: Data.Maybe<OtGlyph.Stat.Sink>);
    setMetric(gid: number, horizontal: OtGlyph.Metric, vertical: OtGlyph.Metric, extent: OtGlyph.Stat.BoundingBox): void;
    setNumGlyphs(count: number): void;
    simpleGlyphStat(st: OtGlyph.Stat.SimpleGlyphStat): void;
    complexGlyphStat(st: OtGlyph.Stat.ComplexGlyphStat): void;
    instructionsStat(size: number): void;
    settle(): void;
}
//# sourceMappingURL=write.d.ts.map