"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ptr16GlyphMathKernInfoMap = exports.Ptr16GlyphMathValueRecordMap = exports.GlyphMathKernInfoMap = exports.GlyphMathValueRecordMap = exports.GlyphValueMapIo = void 0;
const bin_composite_types_1 = require("@ot-builder/bin-composite-types");
const coverage_1 = require("../shared/coverage");
const math_value_record_1 = require("../shared/math-value-record");
const kern_1 = require("./kern");
class GlyphValueMapIo {
    constructor(ioProc) {
        this.ioProc = ioProc;
    }
    read(bv, gOrd) {
        const cov = bv.next(coverage_1.Ptr16GidCoverage);
        const count = bv.uint16();
        const values = bv.array(count, this.ioProc);
        return new Map(coverage_1.CovUtils.mapFromNumbers(cov, values, gOrd));
    }
    write(fr, x, gOrd) {
        const aux = coverage_1.CovUtils.auxMapFromMap(x, gOrd);
        fr.push(coverage_1.Ptr16GidCoverage, coverage_1.CovUtils.gidListFromAuxMap(aux));
        fr.uint16(aux.length);
        fr.arrayN(this.ioProc, aux.length, coverage_1.CovUtils.valueListFromAuxMap(aux));
    }
}
exports.GlyphValueMapIo = GlyphValueMapIo;
exports.GlyphMathValueRecordMap = new GlyphValueMapIo(math_value_record_1.MathValueRecord);
exports.GlyphMathKernInfoMap = new GlyphValueMapIo(kern_1.MathKernInfo);
exports.Ptr16GlyphMathValueRecordMap = (0, bin_composite_types_1.NonNullablePtr16)(exports.GlyphMathValueRecordMap);
exports.Ptr16GlyphMathKernInfoMap = (0, bin_composite_types_1.NonNullablePtr16)(exports.GlyphMathKernInfoMap);
//# sourceMappingURL=glyph-value-map.js.map