#![allow(non_upper_case_globals)]
// Represents the range of values belonging to a prefix code:
// [offset, offset + 2^nbits)
pub struct PrefixCodeRange {
  pub offset: u16,
  pub nbits: u8,
}

pub const kBlockLengthPrefixCode: [PrefixCodeRange; 26] = [PrefixCodeRange {
                                                             offset: 1,
                                                             nbits: 2,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 5,
                                                             nbits: 2,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 9,
                                                             nbits: 2,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 13,
                                                             nbits: 2,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 17,
                                                             nbits: 3,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 25,
                                                             nbits: 3,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 33,
                                                             nbits: 3,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 41,
                                                             nbits: 3,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 49,
                                                             nbits: 4,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 65,
                                                             nbits: 4,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 81,
                                                             nbits: 4,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 97,
                                                             nbits: 4,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 113,
                                                             nbits: 5,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 145,
                                                             nbits: 5,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 177,
                                                             nbits: 5,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 209,
                                                             nbits: 5,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 241,
                                                             nbits: 6,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 305,
                                                             nbits: 6,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 369,
                                                             nbits: 7,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 497,
                                                             nbits: 8,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 753,
                                                             nbits: 9,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 1265,
                                                             nbits: 10,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 2289,
                                                             nbits: 11,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 4337,
                                                             nbits: 12,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 8433,
                                                             nbits: 13,
                                                           },
                                                           PrefixCodeRange {
                                                             offset: 16625,
                                                             nbits: 24,
                                                           }];


#[derive(Debug, Copy, Clone)]
pub struct CmdLutElement {
  pub insert_len_extra_bits: u8,
  pub copy_len_extra_bits: u8,
  pub distance_code: i8,
  pub context: u8,
  pub insert_len_offset: u16,
  pub copy_len_offset: u16,
}
pub const kCmdLut: [CmdLutElement; 704] = [CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x00,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x01,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x02,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x00,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x01,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x02,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x00,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x01,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x02,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x00,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x01,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x02,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x00,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x01,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x02,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x00,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x01,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x02,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x00,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x01,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x02,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x00,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x01,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x02,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: 0,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0000,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0001,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0002,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0003,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0004,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x00,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0005,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0006,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x01,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0008,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x00,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0002,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x01,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0003,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x02,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0004,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0005,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0006,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0007,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0008,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x00,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0009,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000a,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x02,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x000e,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0012,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x03,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x001a,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0022,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x04,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0032,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0042,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x05,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0062,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x000a,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x01,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x000c,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x000e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x02,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0012,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0016,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x03,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x001e,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0026,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x04,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0036,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x06,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0082,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x07,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x00c2,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x08,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0142,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x09,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0242,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0a,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0442,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0c,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x0842,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x0e,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x1842,
                                             copy_len_offset: 0x0846,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0046,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x05,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0066,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x06,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0086,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x07,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x00c6,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x08,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0146,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x09,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0246,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x0a,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0446,
                                           },
                                           CmdLutElement {
                                             insert_len_extra_bits: 0x18,
                                             copy_len_extra_bits: 0x18,
                                             distance_code: -1,
                                             context: 0x03,
                                             insert_len_offset: 0x5842,
                                             copy_len_offset: 0x0846,
                                           }];
