# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AccessControlList(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The Access Control List resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar configuration_type: Input method to configure Access Control List. Known values are:
     "File" and "Inline".
    :vartype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
    :ivar acls_url: Access Control List file URL.
    :vartype acls_url: str
    :ivar match_configurations: List of match configurations.
    :vartype match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchConfiguration]
    :ivar dynamic_match_configurations: List of dynamic match configurations.
    :vartype dynamic_match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
    :ivar last_synced_time: The last synced timestamp.
    :vartype last_synced_time: ~datetime.datetime
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "acls_url": {"min_length": 1},
        "match_configurations": {"min_items": 1},
        "dynamic_match_configurations": {"min_items": 1},
        "last_synced_time": {"readonly": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "configuration_type": {"key": "properties.configurationType", "type": "str"},
        "acls_url": {"key": "properties.aclsUrl", "type": "str"},
        "match_configurations": {
            "key": "properties.matchConfigurations",
            "type": "[AccessControlListMatchConfiguration]",
        },
        "dynamic_match_configurations": {
            "key": "properties.dynamicMatchConfigurations",
            "type": "[CommonDynamicMatchConfiguration]",
        },
        "last_synced_time": {"key": "properties.lastSyncedTime", "type": "iso-8601"},
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        acls_url: Optional[str] = None,
        match_configurations: Optional[List["_models.AccessControlListMatchConfiguration"]] = None,
        dynamic_match_configurations: Optional[List["_models.CommonDynamicMatchConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword configuration_type: Input method to configure Access Control List. Known values are:
         "File" and "Inline".
        :paramtype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
        :keyword acls_url: Access Control List file URL.
        :paramtype acls_url: str
        :keyword match_configurations: List of match configurations.
        :paramtype match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchConfiguration]
        :keyword dynamic_match_configurations: List of dynamic match configurations.
        :paramtype dynamic_match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.configuration_type = configuration_type
        self.acls_url = acls_url
        self.match_configurations = match_configurations
        self.dynamic_match_configurations = dynamic_match_configurations
        self.last_synced_time = None
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class AccessControlListAction(_serialization.Model):
    """Action that need to performed.

    :ivar type: Type of actions that can be performed. Known values are: "Drop", "Count", and
     "Log".
    :vartype type: str or ~azure.mgmt.managednetworkfabric.models.AclActionType
    :ivar counter_name: Name of the counter block to get match count information.
    :vartype counter_name: str
    """

    _validation = {
        "counter_name": {"min_length": 1},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "counter_name": {"key": "counterName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.AclActionType"]] = None,
        counter_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of actions that can be performed. Known values are: "Drop", "Count", and
         "Log".
        :paramtype type: str or ~azure.mgmt.managednetworkfabric.models.AclActionType
        :keyword counter_name: Name of the counter block to get match count information.
        :paramtype counter_name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.counter_name = counter_name


class CommonMatchConditions(_serialization.Model):
    """Defines the common match conditions of the ACL and Network Tap Rule.

    :ivar protocol_types: List of the protocols that need to be matched.
    :vartype protocol_types: list[str]
    :ivar vlan_match_condition: Vlan match condition that needs to be matched.
    :vartype vlan_match_condition: ~azure.mgmt.managednetworkfabric.models.VlanMatchCondition
    :ivar ip_condition: IP condition that needs to be matched.
    :vartype ip_condition: ~azure.mgmt.managednetworkfabric.models.IpMatchCondition
    """

    _validation = {
        "protocol_types": {"min_items": 1},
    }

    _attribute_map = {
        "protocol_types": {"key": "protocolTypes", "type": "[str]"},
        "vlan_match_condition": {"key": "vlanMatchCondition", "type": "VlanMatchCondition"},
        "ip_condition": {"key": "ipCondition", "type": "IpMatchCondition"},
    }

    def __init__(
        self,
        *,
        protocol_types: Optional[List[str]] = None,
        vlan_match_condition: Optional["_models.VlanMatchCondition"] = None,
        ip_condition: Optional["_models.IpMatchCondition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol_types: List of the protocols that need to be matched.
        :paramtype protocol_types: list[str]
        :keyword vlan_match_condition: Vlan match condition that needs to be matched.
        :paramtype vlan_match_condition: ~azure.mgmt.managednetworkfabric.models.VlanMatchCondition
        :keyword ip_condition: IP condition that needs to be matched.
        :paramtype ip_condition: ~azure.mgmt.managednetworkfabric.models.IpMatchCondition
        """
        super().__init__(**kwargs)
        self.protocol_types = protocol_types
        self.vlan_match_condition = vlan_match_condition
        self.ip_condition = ip_condition


class AccessControlListMatchCondition(CommonMatchConditions):
    """Defines the match condition that is supported to filter the traffic.

    :ivar protocol_types: List of the protocols that need to be matched.
    :vartype protocol_types: list[str]
    :ivar vlan_match_condition: Vlan match condition that needs to be matched.
    :vartype vlan_match_condition: ~azure.mgmt.managednetworkfabric.models.VlanMatchCondition
    :ivar ip_condition: IP condition that needs to be matched.
    :vartype ip_condition: ~azure.mgmt.managednetworkfabric.models.IpMatchCondition
    :ivar ether_types: List of ether type values that needs to be matched.
    :vartype ether_types: list[str]
    :ivar fragments: List of IP fragment packets that needs to be matched.
    :vartype fragments: list[str]
    :ivar ip_lengths: List of IP Lengths that needs to be matched.
    :vartype ip_lengths: list[str]
    :ivar ttl_values: List of TTL [Time To Live] values that needs to be matched.
    :vartype ttl_values: list[str]
    :ivar dscp_markings: List of DSCP Markings that needs to be matched.
    :vartype dscp_markings: list[str]
    :ivar port_condition: Defines the port condition that needs to be matched.
    :vartype port_condition: ~azure.mgmt.managednetworkfabric.models.AccessControlListPortCondition
    """

    _validation = {
        "protocol_types": {"min_items": 1},
        "ether_types": {"min_items": 1},
        "fragments": {"min_items": 1},
        "ip_lengths": {"min_items": 1},
        "ttl_values": {"min_items": 1},
        "dscp_markings": {"min_items": 1},
    }

    _attribute_map = {
        "protocol_types": {"key": "protocolTypes", "type": "[str]"},
        "vlan_match_condition": {"key": "vlanMatchCondition", "type": "VlanMatchCondition"},
        "ip_condition": {"key": "ipCondition", "type": "IpMatchCondition"},
        "ether_types": {"key": "etherTypes", "type": "[str]"},
        "fragments": {"key": "fragments", "type": "[str]"},
        "ip_lengths": {"key": "ipLengths", "type": "[str]"},
        "ttl_values": {"key": "ttlValues", "type": "[str]"},
        "dscp_markings": {"key": "dscpMarkings", "type": "[str]"},
        "port_condition": {"key": "portCondition", "type": "AccessControlListPortCondition"},
    }

    def __init__(
        self,
        *,
        protocol_types: Optional[List[str]] = None,
        vlan_match_condition: Optional["_models.VlanMatchCondition"] = None,
        ip_condition: Optional["_models.IpMatchCondition"] = None,
        ether_types: Optional[List[str]] = None,
        fragments: Optional[List[str]] = None,
        ip_lengths: Optional[List[str]] = None,
        ttl_values: Optional[List[str]] = None,
        dscp_markings: Optional[List[str]] = None,
        port_condition: Optional["_models.AccessControlListPortCondition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol_types: List of the protocols that need to be matched.
        :paramtype protocol_types: list[str]
        :keyword vlan_match_condition: Vlan match condition that needs to be matched.
        :paramtype vlan_match_condition: ~azure.mgmt.managednetworkfabric.models.VlanMatchCondition
        :keyword ip_condition: IP condition that needs to be matched.
        :paramtype ip_condition: ~azure.mgmt.managednetworkfabric.models.IpMatchCondition
        :keyword ether_types: List of ether type values that needs to be matched.
        :paramtype ether_types: list[str]
        :keyword fragments: List of IP fragment packets that needs to be matched.
        :paramtype fragments: list[str]
        :keyword ip_lengths: List of IP Lengths that needs to be matched.
        :paramtype ip_lengths: list[str]
        :keyword ttl_values: List of TTL [Time To Live] values that needs to be matched.
        :paramtype ttl_values: list[str]
        :keyword dscp_markings: List of DSCP Markings that needs to be matched.
        :paramtype dscp_markings: list[str]
        :keyword port_condition: Defines the port condition that needs to be matched.
        :paramtype port_condition:
         ~azure.mgmt.managednetworkfabric.models.AccessControlListPortCondition
        """
        super().__init__(
            protocol_types=protocol_types,
            vlan_match_condition=vlan_match_condition,
            ip_condition=ip_condition,
            **kwargs
        )
        self.ether_types = ether_types
        self.fragments = fragments
        self.ip_lengths = ip_lengths
        self.ttl_values = ttl_values
        self.dscp_markings = dscp_markings
        self.port_condition = port_condition


class AccessControlListMatchConfiguration(_serialization.Model):
    """Defines the match configuration that are supported to filter the traffic.

    :ivar match_configuration_name: The name of the match configuration.
    :vartype match_configuration_name: str
    :ivar sequence_number: Sequence Number of the match configuration.
    :vartype sequence_number: int
    :ivar ip_address_type: Type of IP Address. IPv4 or IPv6. Known values are: "IPv4" and "IPv6".
    :vartype ip_address_type: str or ~azure.mgmt.managednetworkfabric.models.IPAddressType
    :ivar match_conditions: List of the match conditions.
    :vartype match_conditions:
     list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchCondition]
    :ivar actions: List of actions that need to be performed for the matched conditions.
    :vartype actions: list[~azure.mgmt.managednetworkfabric.models.AccessControlListAction]
    """

    _validation = {
        "match_configuration_name": {"min_length": 1},
        "sequence_number": {"maximum": 4294967295, "minimum": 1},
        "match_conditions": {"min_items": 1},
        "actions": {"min_items": 1},
    }

    _attribute_map = {
        "match_configuration_name": {"key": "matchConfigurationName", "type": "str"},
        "sequence_number": {"key": "sequenceNumber", "type": "int"},
        "ip_address_type": {"key": "ipAddressType", "type": "str"},
        "match_conditions": {"key": "matchConditions", "type": "[AccessControlListMatchCondition]"},
        "actions": {"key": "actions", "type": "[AccessControlListAction]"},
    }

    def __init__(
        self,
        *,
        match_configuration_name: Optional[str] = None,
        sequence_number: Optional[int] = None,
        ip_address_type: Optional[Union[str, "_models.IPAddressType"]] = None,
        match_conditions: Optional[List["_models.AccessControlListMatchCondition"]] = None,
        actions: Optional[List["_models.AccessControlListAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword match_configuration_name: The name of the match configuration.
        :paramtype match_configuration_name: str
        :keyword sequence_number: Sequence Number of the match configuration.
        :paramtype sequence_number: int
        :keyword ip_address_type: Type of IP Address. IPv4 or IPv6. Known values are: "IPv4" and
         "IPv6".
        :paramtype ip_address_type: str or ~azure.mgmt.managednetworkfabric.models.IPAddressType
        :keyword match_conditions: List of the match conditions.
        :paramtype match_conditions:
         list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchCondition]
        :keyword actions: List of actions that need to be performed for the matched conditions.
        :paramtype actions: list[~azure.mgmt.managednetworkfabric.models.AccessControlListAction]
        """
        super().__init__(**kwargs)
        self.match_configuration_name = match_configuration_name
        self.sequence_number = sequence_number
        self.ip_address_type = ip_address_type
        self.match_conditions = match_conditions
        self.actions = actions


class TagsUpdate(_serialization.Model):
    """Base tracked resource type for PATCH updates.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class AccessControlListPatch(TagsUpdate):
    """The Access Control Lists patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar configuration_type: Input method to configure Access Control List. Known values are:
     "File" and "Inline".
    :vartype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
    :ivar acls_url: Access Control List file URL.
    :vartype acls_url: str
    :ivar match_configurations: List of match configurations.
    :vartype match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchConfiguration]
    :ivar dynamic_match_configurations: List of dynamic match configurations.
    :vartype dynamic_match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _validation = {
        "acls_url": {"min_length": 1},
        "match_configurations": {"min_items": 1},
        "dynamic_match_configurations": {"min_items": 1},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "configuration_type": {"key": "properties.configurationType", "type": "str"},
        "acls_url": {"key": "properties.aclsUrl", "type": "str"},
        "match_configurations": {
            "key": "properties.matchConfigurations",
            "type": "[AccessControlListMatchConfiguration]",
        },
        "dynamic_match_configurations": {
            "key": "properties.dynamicMatchConfigurations",
            "type": "[CommonDynamicMatchConfiguration]",
        },
        "annotation": {"key": "properties.annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        acls_url: Optional[str] = None,
        match_configurations: Optional[List["_models.AccessControlListMatchConfiguration"]] = None,
        dynamic_match_configurations: Optional[List["_models.CommonDynamicMatchConfiguration"]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword configuration_type: Input method to configure Access Control List. Known values are:
         "File" and "Inline".
        :paramtype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
        :keyword acls_url: Access Control List file URL.
        :paramtype acls_url: str
        :keyword match_configurations: List of match configurations.
        :paramtype match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchConfiguration]
        :keyword dynamic_match_configurations: List of dynamic match configurations.
        :paramtype dynamic_match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(tags=tags, **kwargs)
        self.configuration_type = configuration_type
        self.acls_url = acls_url
        self.match_configurations = match_configurations
        self.dynamic_match_configurations = dynamic_match_configurations
        self.annotation = annotation


class AccessControlListPatchableProperties(_serialization.Model):
    """Access Control List Patch Properties defines the patchable resource properties.

    :ivar configuration_type: Input method to configure Access Control List. Known values are:
     "File" and "Inline".
    :vartype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
    :ivar acls_url: Access Control List file URL.
    :vartype acls_url: str
    :ivar match_configurations: List of match configurations.
    :vartype match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchConfiguration]
    :ivar dynamic_match_configurations: List of dynamic match configurations.
    :vartype dynamic_match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
    """

    _validation = {
        "acls_url": {"min_length": 1},
        "match_configurations": {"min_items": 1},
        "dynamic_match_configurations": {"min_items": 1},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
        "acls_url": {"key": "aclsUrl", "type": "str"},
        "match_configurations": {"key": "matchConfigurations", "type": "[AccessControlListMatchConfiguration]"},
        "dynamic_match_configurations": {
            "key": "dynamicMatchConfigurations",
            "type": "[CommonDynamicMatchConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        acls_url: Optional[str] = None,
        match_configurations: Optional[List["_models.AccessControlListMatchConfiguration"]] = None,
        dynamic_match_configurations: Optional[List["_models.CommonDynamicMatchConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configuration_type: Input method to configure Access Control List. Known values are:
         "File" and "Inline".
        :paramtype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
        :keyword acls_url: Access Control List file URL.
        :paramtype acls_url: str
        :keyword match_configurations: List of match configurations.
        :paramtype match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchConfiguration]
        :keyword dynamic_match_configurations: List of dynamic match configurations.
        :paramtype dynamic_match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
        """
        super().__init__(**kwargs)
        self.configuration_type = configuration_type
        self.acls_url = acls_url
        self.match_configurations = match_configurations
        self.dynamic_match_configurations = dynamic_match_configurations


class AnnotationResource(_serialization.Model):
    """Switch configuration entries require a description to discern between configuration groups.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(self, *, annotation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(**kwargs)
        self.annotation = annotation


class AccessControlListPatchProperties(AccessControlListPatchableProperties, AnnotationResource):
    """Access Control Lists patch properties.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar configuration_type: Input method to configure Access Control List. Known values are:
     "File" and "Inline".
    :vartype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
    :ivar acls_url: Access Control List file URL.
    :vartype acls_url: str
    :ivar match_configurations: List of match configurations.
    :vartype match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchConfiguration]
    :ivar dynamic_match_configurations: List of dynamic match configurations.
    :vartype dynamic_match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
    """

    _validation = {
        "acls_url": {"min_length": 1},
        "match_configurations": {"min_items": 1},
        "dynamic_match_configurations": {"min_items": 1},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "configuration_type": {"key": "configurationType", "type": "str"},
        "acls_url": {"key": "aclsUrl", "type": "str"},
        "match_configurations": {"key": "matchConfigurations", "type": "[AccessControlListMatchConfiguration]"},
        "dynamic_match_configurations": {
            "key": "dynamicMatchConfigurations",
            "type": "[CommonDynamicMatchConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        annotation: Optional[str] = None,
        configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        acls_url: Optional[str] = None,
        match_configurations: Optional[List["_models.AccessControlListMatchConfiguration"]] = None,
        dynamic_match_configurations: Optional[List["_models.CommonDynamicMatchConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword configuration_type: Input method to configure Access Control List. Known values are:
         "File" and "Inline".
        :paramtype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
        :keyword acls_url: Access Control List file URL.
        :paramtype acls_url: str
        :keyword match_configurations: List of match configurations.
        :paramtype match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchConfiguration]
        :keyword dynamic_match_configurations: List of dynamic match configurations.
        :paramtype dynamic_match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
        """
        super().__init__(
            configuration_type=configuration_type,
            acls_url=acls_url,
            match_configurations=match_configurations,
            dynamic_match_configurations=dynamic_match_configurations,
            annotation=annotation,
            **kwargs
        )
        self.annotation = annotation
        self.configuration_type = configuration_type
        self.acls_url = acls_url
        self.match_configurations = match_configurations
        self.dynamic_match_configurations = dynamic_match_configurations


class PortCondition(_serialization.Model):
    """Port condition that needs to be matched.

    All required parameters must be populated in order to send to Azure.

    :ivar port_type: Port type that needs to be matched. Known values are: "SourcePort" and
     "DestinationPort".
    :vartype port_type: str or ~azure.mgmt.managednetworkfabric.models.PortType
    :ivar layer4_protocol: Layer4 protocol type that needs to be matched. Required. Known values
     are: "TCP" and "UDP".
    :vartype layer4_protocol: str or ~azure.mgmt.managednetworkfabric.models.Layer4Protocol
    :ivar ports: List of the Ports that need to be matched.
    :vartype ports: list[str]
    :ivar port_group_names: List of the port Group Names that to be matched.
    :vartype port_group_names: list[str]
    """

    _validation = {
        "layer4_protocol": {"required": True},
        "ports": {"min_items": 1},
        "port_group_names": {"min_items": 1},
    }

    _attribute_map = {
        "port_type": {"key": "portType", "type": "str"},
        "layer4_protocol": {"key": "layer4Protocol", "type": "str"},
        "ports": {"key": "ports", "type": "[str]"},
        "port_group_names": {"key": "portGroupNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        layer4_protocol: Union[str, "_models.Layer4Protocol"],
        port_type: Optional[Union[str, "_models.PortType"]] = None,
        ports: Optional[List[str]] = None,
        port_group_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword port_type: Port type that needs to be matched. Known values are: "SourcePort" and
         "DestinationPort".
        :paramtype port_type: str or ~azure.mgmt.managednetworkfabric.models.PortType
        :keyword layer4_protocol: Layer4 protocol type that needs to be matched. Required. Known values
         are: "TCP" and "UDP".
        :paramtype layer4_protocol: str or ~azure.mgmt.managednetworkfabric.models.Layer4Protocol
        :keyword ports: List of the Ports that need to be matched.
        :paramtype ports: list[str]
        :keyword port_group_names: List of the port Group Names that to be matched.
        :paramtype port_group_names: list[str]
        """
        super().__init__(**kwargs)
        self.port_type = port_type
        self.layer4_protocol = layer4_protocol
        self.ports = ports
        self.port_group_names = port_group_names


class AccessControlListPortCondition(PortCondition):
    """Defines the port condition that needs to be matched.

    All required parameters must be populated in order to send to Azure.

    :ivar port_type: Port type that needs to be matched. Known values are: "SourcePort" and
     "DestinationPort".
    :vartype port_type: str or ~azure.mgmt.managednetworkfabric.models.PortType
    :ivar layer4_protocol: Layer4 protocol type that needs to be matched. Required. Known values
     are: "TCP" and "UDP".
    :vartype layer4_protocol: str or ~azure.mgmt.managednetworkfabric.models.Layer4Protocol
    :ivar ports: List of the Ports that need to be matched.
    :vartype ports: list[str]
    :ivar port_group_names: List of the port Group Names that to be matched.
    :vartype port_group_names: list[str]
    :ivar flags: List of protocol flags that needs to be matched.
    :vartype flags: list[str]
    """

    _validation = {
        "layer4_protocol": {"required": True},
        "ports": {"min_items": 1},
        "port_group_names": {"min_items": 1},
    }

    _attribute_map = {
        "port_type": {"key": "portType", "type": "str"},
        "layer4_protocol": {"key": "layer4Protocol", "type": "str"},
        "ports": {"key": "ports", "type": "[str]"},
        "port_group_names": {"key": "portGroupNames", "type": "[str]"},
        "flags": {"key": "flags", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        layer4_protocol: Union[str, "_models.Layer4Protocol"],
        port_type: Optional[Union[str, "_models.PortType"]] = None,
        ports: Optional[List[str]] = None,
        port_group_names: Optional[List[str]] = None,
        flags: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword port_type: Port type that needs to be matched. Known values are: "SourcePort" and
         "DestinationPort".
        :paramtype port_type: str or ~azure.mgmt.managednetworkfabric.models.PortType
        :keyword layer4_protocol: Layer4 protocol type that needs to be matched. Required. Known values
         are: "TCP" and "UDP".
        :paramtype layer4_protocol: str or ~azure.mgmt.managednetworkfabric.models.Layer4Protocol
        :keyword ports: List of the Ports that need to be matched.
        :paramtype ports: list[str]
        :keyword port_group_names: List of the port Group Names that to be matched.
        :paramtype port_group_names: list[str]
        :keyword flags: List of protocol flags that needs to be matched.
        :paramtype flags: list[str]
        """
        super().__init__(
            port_type=port_type,
            layer4_protocol=layer4_protocol,
            ports=ports,
            port_group_names=port_group_names,
            **kwargs
        )
        self.flags = flags


class AccessControlListProperties(AnnotationResource, AccessControlListPatchableProperties):
    """Access Control List Properties defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar configuration_type: Input method to configure Access Control List. Known values are:
     "File" and "Inline".
    :vartype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
    :ivar acls_url: Access Control List file URL.
    :vartype acls_url: str
    :ivar match_configurations: List of match configurations.
    :vartype match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchConfiguration]
    :ivar dynamic_match_configurations: List of dynamic match configurations.
    :vartype dynamic_match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar last_synced_time: The last synced timestamp.
    :vartype last_synced_time: ~datetime.datetime
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "acls_url": {"min_length": 1},
        "match_configurations": {"min_items": 1},
        "dynamic_match_configurations": {"min_items": 1},
        "last_synced_time": {"readonly": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
        "acls_url": {"key": "aclsUrl", "type": "str"},
        "match_configurations": {"key": "matchConfigurations", "type": "[AccessControlListMatchConfiguration]"},
        "dynamic_match_configurations": {
            "key": "dynamicMatchConfigurations",
            "type": "[CommonDynamicMatchConfiguration]",
        },
        "annotation": {"key": "annotation", "type": "str"},
        "last_synced_time": {"key": "lastSyncedTime", "type": "iso-8601"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        acls_url: Optional[str] = None,
        match_configurations: Optional[List["_models.AccessControlListMatchConfiguration"]] = None,
        dynamic_match_configurations: Optional[List["_models.CommonDynamicMatchConfiguration"]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configuration_type: Input method to configure Access Control List. Known values are:
         "File" and "Inline".
        :paramtype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
        :keyword acls_url: Access Control List file URL.
        :paramtype acls_url: str
        :keyword match_configurations: List of match configurations.
        :paramtype match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.AccessControlListMatchConfiguration]
        :keyword dynamic_match_configurations: List of dynamic match configurations.
        :paramtype dynamic_match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(
            annotation=annotation,
            configuration_type=configuration_type,
            acls_url=acls_url,
            match_configurations=match_configurations,
            dynamic_match_configurations=dynamic_match_configurations,
            **kwargs
        )
        self.configuration_type = configuration_type
        self.acls_url = acls_url
        self.match_configurations = match_configurations
        self.dynamic_match_configurations = dynamic_match_configurations
        self.last_synced_time = None
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None
        self.annotation = annotation


class AccessControlListsListResult(_serialization.Model):
    """List of Access Control Lists.

    :ivar value: List of Access Control List resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.AccessControlList]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AccessControlList]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AccessControlList"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Access Control List resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.AccessControlList]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpCommunitySetOperationProperties(_serialization.Model):
    """IP Community set operation properties.

    :ivar set: List of IP Community IDs.
    :vartype set: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    """

    _attribute_map = {
        "set": {"key": "set", "type": "IpCommunityIdList"},
    }

    def __init__(self, *, set: Optional["_models.IpCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword set: List of IP Community IDs.
        :paramtype set: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        """
        super().__init__(**kwargs)
        self.set = set


class IpCommunityDeleteOperationProperties(_serialization.Model):
    """IP Community delete operation properties.

    :ivar delete: List of IP Community IDs.
    :vartype delete: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    """

    _attribute_map = {
        "delete": {"key": "delete", "type": "IpCommunityIdList"},
    }

    def __init__(self, *, delete: Optional["_models.IpCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword delete: List of IP Community IDs.
        :paramtype delete: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        """
        super().__init__(**kwargs)
        self.delete = delete


class IpCommunityAddOperationProperties(_serialization.Model):
    """IP Community add operation properties.

    :ivar add: List of IP Community IDs.
    :vartype add: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    """

    _attribute_map = {
        "add": {"key": "add", "type": "IpCommunityIdList"},
    }

    def __init__(self, *, add: Optional["_models.IpCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword add: List of IP Community IDs.
        :paramtype add: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        """
        super().__init__(**kwargs)
        self.add = add


class ActionIpCommunityProperties(
    IpCommunityAddOperationProperties, IpCommunityDeleteOperationProperties, IpCommunitySetOperationProperties
):
    """IP Community Properties.

    :ivar set: List of IP Community IDs.
    :vartype set: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    :ivar delete: List of IP Community IDs.
    :vartype delete: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    :ivar add: List of IP Community IDs.
    :vartype add: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
    """

    _attribute_map = {
        "set": {"key": "set", "type": "IpCommunityIdList"},
        "delete": {"key": "delete", "type": "IpCommunityIdList"},
        "add": {"key": "add", "type": "IpCommunityIdList"},
    }

    def __init__(
        self,
        *,
        set: Optional["_models.IpCommunityIdList"] = None,
        delete: Optional["_models.IpCommunityIdList"] = None,
        add: Optional["_models.IpCommunityIdList"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword set: List of IP Community IDs.
        :paramtype set: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        :keyword delete: List of IP Community IDs.
        :paramtype delete: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        :keyword add: List of IP Community IDs.
        :paramtype add: ~azure.mgmt.managednetworkfabric.models.IpCommunityIdList
        """
        super().__init__(add=add, delete=delete, set=set, **kwargs)
        self.set = set
        self.delete = delete
        self.add = add


class IpExtendedCommunitySetOperationProperties(_serialization.Model):
    """IP Extended Community set operation properties.

    :ivar set: List of IP Extended Community IDs.
    :vartype set: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    """

    _attribute_map = {
        "set": {"key": "set", "type": "IpExtendedCommunityIdList"},
    }

    def __init__(self, *, set: Optional["_models.IpExtendedCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword set: List of IP Extended Community IDs.
        :paramtype set: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        """
        super().__init__(**kwargs)
        self.set = set


class IpExtendedCommunityDeleteOperationProperties(_serialization.Model):
    """IP Extended Community delete operation properties.

    :ivar delete: List of IP Extended Community IDs.
    :vartype delete: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    """

    _attribute_map = {
        "delete": {"key": "delete", "type": "IpExtendedCommunityIdList"},
    }

    def __init__(self, *, delete: Optional["_models.IpExtendedCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword delete: List of IP Extended Community IDs.
        :paramtype delete: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        """
        super().__init__(**kwargs)
        self.delete = delete


class IpExtendedCommunityAddOperationProperties(_serialization.Model):
    """IP Extended Community add operation properties.

    :ivar add: List of IP Extended Community IDs.
    :vartype add: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    """

    _attribute_map = {
        "add": {"key": "add", "type": "IpExtendedCommunityIdList"},
    }

    def __init__(self, *, add: Optional["_models.IpExtendedCommunityIdList"] = None, **kwargs: Any) -> None:
        """
        :keyword add: List of IP Extended Community IDs.
        :paramtype add: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        """
        super().__init__(**kwargs)
        self.add = add


class ActionIpExtendedCommunityProperties(
    IpExtendedCommunityAddOperationProperties,
    IpExtendedCommunityDeleteOperationProperties,
    IpExtendedCommunitySetOperationProperties,
):
    """IP Extended Community Properties.

    :ivar set: List of IP Extended Community IDs.
    :vartype set: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    :ivar delete: List of IP Extended Community IDs.
    :vartype delete: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    :ivar add: List of IP Extended Community IDs.
    :vartype add: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
    """

    _attribute_map = {
        "set": {"key": "set", "type": "IpExtendedCommunityIdList"},
        "delete": {"key": "delete", "type": "IpExtendedCommunityIdList"},
        "add": {"key": "add", "type": "IpExtendedCommunityIdList"},
    }

    def __init__(
        self,
        *,
        set: Optional["_models.IpExtendedCommunityIdList"] = None,
        delete: Optional["_models.IpExtendedCommunityIdList"] = None,
        add: Optional["_models.IpExtendedCommunityIdList"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword set: List of IP Extended Community IDs.
        :paramtype set: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        :keyword delete: List of IP Extended Community IDs.
        :paramtype delete: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        :keyword add: List of IP Extended Community IDs.
        :paramtype add: ~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityIdList
        """
        super().__init__(add=add, delete=delete, set=set, **kwargs)
        self.set = set
        self.delete = delete
        self.add = add


class AggregateRoute(_serialization.Model):
    """aggregateIpv4Route model.

    All required parameters must be populated in order to send to Azure.

    :ivar prefix: IPv4 Prefix of the aggregate Ipv4Route. Required.
    :vartype prefix: str
    """

    _validation = {
        "prefix": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "prefix": {"key": "prefix", "type": "str"},
    }

    def __init__(self, *, prefix: str, **kwargs: Any) -> None:
        """
        :keyword prefix: IPv4 Prefix of the aggregate Ipv4Route. Required.
        :paramtype prefix: str
        """
        super().__init__(**kwargs)
        self.prefix = prefix


class AggregateRouteConfiguration(_serialization.Model):
    """List of IPv4 and IPv6 aggregate routes.

    :ivar ipv4_routes: List of IPv4 Route prefixes.
    :vartype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.AggregateRoute]
    :ivar ipv6_routes: List of Ipv6Routes prefixes.
    :vartype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.AggregateRoute]
    """

    _validation = {
        "ipv4_routes": {"min_items": 1},
        "ipv6_routes": {"min_items": 1},
    }

    _attribute_map = {
        "ipv4_routes": {"key": "ipv4Routes", "type": "[AggregateRoute]"},
        "ipv6_routes": {"key": "ipv6Routes", "type": "[AggregateRoute]"},
    }

    def __init__(
        self,
        *,
        ipv4_routes: Optional[List["_models.AggregateRoute"]] = None,
        ipv6_routes: Optional[List["_models.AggregateRoute"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ipv4_routes: List of IPv4 Route prefixes.
        :paramtype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.AggregateRoute]
        :keyword ipv6_routes: List of Ipv6Routes prefixes.
        :paramtype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.AggregateRoute]
        """
        super().__init__(**kwargs)
        self.ipv4_routes = ipv4_routes
        self.ipv6_routes = ipv6_routes


class BfdConfiguration(_serialization.Model):
    """BFD configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar administrative_state: Administrative state of the BfdConfiguration. Example: Enabled |
     Disabled. Known values are: "Enabled", "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.BfdAdministrativeState
    :ivar interval_in_milli_seconds: Interval in milliseconds. Example: 300.
    :vartype interval_in_milli_seconds: int
    :ivar multiplier: Multiplier for the Bfd Configuration. Example: 5.
    :vartype multiplier: int
    """

    _validation = {
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "administrative_state": {"key": "administrativeState", "type": "str"},
        "interval_in_milli_seconds": {"key": "intervalInMilliSeconds", "type": "int"},
        "multiplier": {"key": "multiplier", "type": "int"},
    }

    def __init__(self, *, interval_in_milli_seconds: int = 300, multiplier: int = 5, **kwargs: Any) -> None:
        """
        :keyword interval_in_milli_seconds: Interval in milliseconds. Example: 300.
        :paramtype interval_in_milli_seconds: int
        :keyword multiplier: Multiplier for the Bfd Configuration. Example: 5.
        :paramtype multiplier: int
        """
        super().__init__(**kwargs)
        self.administrative_state = None
        self.interval_in_milli_seconds = interval_in_milli_seconds
        self.multiplier = multiplier


class BgpConfiguration(AnnotationResource):  # pylint: disable=too-many-instance-attributes
    """BGP configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar bfd_configuration: BFD configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    :ivar default_route_originate: Originate a defaultRoute. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype default_route_originate: str or
     ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
    :ivar allow_as: Allows for routes to be received and processed even if the router detects its
     own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
    :vartype allow_as: int
    :ivar allow_as_override: Enable Or Disable state. Known values are: "Enable" and "Disable".
    :vartype allow_as_override: str or ~azure.mgmt.managednetworkfabric.models.AllowASOverride
    :ivar fabric_asn: ASN of Network Fabric. Example: 65048.
    :vartype fabric_asn: int
    :ivar peer_asn: Peer ASN. Example: 65047.
    :vartype peer_asn: int
    :ivar ipv4_listen_range_prefixes: List of BGP IPv4 Listen Range prefixes.
    :vartype ipv4_listen_range_prefixes: list[str]
    :ivar ipv6_listen_range_prefixes: List of BGP IPv6 Listen Ranges prefixes.
    :vartype ipv6_listen_range_prefixes: list[str]
    :ivar ipv4_neighbor_address: List with stringified IPv4 Neighbor Addresses.
    :vartype ipv4_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
    :ivar ipv6_neighbor_address: List with stringified IPv6 Neighbor Address.
    :vartype ipv6_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
    """

    _validation = {
        "allow_as": {"maximum": 10, "minimum": 0},
        "fabric_asn": {"readonly": True},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
        "ipv4_listen_range_prefixes": {"min_items": 1},
        "ipv6_listen_range_prefixes": {"min_items": 1},
        "ipv4_neighbor_address": {"min_items": 1},
        "ipv6_neighbor_address": {"min_items": 1},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
        "default_route_originate": {"key": "defaultRouteOriginate", "type": "str"},
        "allow_as": {"key": "allowAS", "type": "int"},
        "allow_as_override": {"key": "allowASOverride", "type": "str"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "ipv4_listen_range_prefixes": {"key": "ipv4ListenRangePrefixes", "type": "[str]"},
        "ipv6_listen_range_prefixes": {"key": "ipv6ListenRangePrefixes", "type": "[str]"},
        "ipv4_neighbor_address": {"key": "ipv4NeighborAddress", "type": "[NeighborAddress]"},
        "ipv6_neighbor_address": {"key": "ipv6NeighborAddress", "type": "[NeighborAddress]"},
    }

    def __init__(
        self,
        *,
        annotation: Optional[str] = None,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        default_route_originate: Optional[Union[str, "_models.BooleanEnumProperty"]] = None,
        allow_as: int = 2,
        allow_as_override: Optional[Union[str, "_models.AllowASOverride"]] = None,
        peer_asn: Optional[int] = None,
        ipv4_listen_range_prefixes: Optional[List[str]] = None,
        ipv6_listen_range_prefixes: Optional[List[str]] = None,
        ipv4_neighbor_address: Optional[List["_models.NeighborAddress"]] = None,
        ipv6_neighbor_address: Optional[List["_models.NeighborAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword bfd_configuration: BFD configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        :keyword default_route_originate: Originate a defaultRoute. Ex: "True" | "False". Known values
         are: "True" and "False".
        :paramtype default_route_originate: str or
         ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
        :keyword allow_as: Allows for routes to be received and processed even if the router detects
         its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
        :paramtype allow_as: int
        :keyword allow_as_override: Enable Or Disable state. Known values are: "Enable" and "Disable".
        :paramtype allow_as_override: str or ~azure.mgmt.managednetworkfabric.models.AllowASOverride
        :keyword peer_asn: Peer ASN. Example: 65047.
        :paramtype peer_asn: int
        :keyword ipv4_listen_range_prefixes: List of BGP IPv4 Listen Range prefixes.
        :paramtype ipv4_listen_range_prefixes: list[str]
        :keyword ipv6_listen_range_prefixes: List of BGP IPv6 Listen Ranges prefixes.
        :paramtype ipv6_listen_range_prefixes: list[str]
        :keyword ipv4_neighbor_address: List with stringified IPv4 Neighbor Addresses.
        :paramtype ipv4_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
        :keyword ipv6_neighbor_address: List with stringified IPv6 Neighbor Address.
        :paramtype ipv6_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
        """
        super().__init__(annotation=annotation, **kwargs)
        self.bfd_configuration = bfd_configuration
        self.default_route_originate = default_route_originate
        self.allow_as = allow_as
        self.allow_as_override = allow_as_override
        self.fabric_asn = None
        self.peer_asn = peer_asn
        self.ipv4_listen_range_prefixes = ipv4_listen_range_prefixes
        self.ipv6_listen_range_prefixes = ipv6_listen_range_prefixes
        self.ipv4_neighbor_address = ipv4_neighbor_address
        self.ipv6_neighbor_address = ipv6_neighbor_address


class CommonDynamicMatchConfiguration(_serialization.Model):
    """Dynamic match configuration object.

    :ivar ip_groups: List of IP Groups.
    :vartype ip_groups: list[~azure.mgmt.managednetworkfabric.models.IpGroupProperties]
    :ivar vlan_groups: List of vlan groups.
    :vartype vlan_groups: list[~azure.mgmt.managednetworkfabric.models.VlanGroupProperties]
    :ivar port_groups: List of the port group.
    :vartype port_groups: list[~azure.mgmt.managednetworkfabric.models.PortGroupProperties]
    """

    _validation = {
        "ip_groups": {"min_items": 1},
        "vlan_groups": {"min_items": 1},
        "port_groups": {"min_items": 1},
    }

    _attribute_map = {
        "ip_groups": {"key": "ipGroups", "type": "[IpGroupProperties]"},
        "vlan_groups": {"key": "vlanGroups", "type": "[VlanGroupProperties]"},
        "port_groups": {"key": "portGroups", "type": "[PortGroupProperties]"},
    }

    def __init__(
        self,
        *,
        ip_groups: Optional[List["_models.IpGroupProperties"]] = None,
        vlan_groups: Optional[List["_models.VlanGroupProperties"]] = None,
        port_groups: Optional[List["_models.PortGroupProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_groups: List of IP Groups.
        :paramtype ip_groups: list[~azure.mgmt.managednetworkfabric.models.IpGroupProperties]
        :keyword vlan_groups: List of vlan groups.
        :paramtype vlan_groups: list[~azure.mgmt.managednetworkfabric.models.VlanGroupProperties]
        :keyword port_groups: List of the port group.
        :paramtype port_groups: list[~azure.mgmt.managednetworkfabric.models.PortGroupProperties]
        """
        super().__init__(**kwargs)
        self.ip_groups = ip_groups
        self.vlan_groups = vlan_groups
        self.port_groups = port_groups


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.managednetworkfabric.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.managednetworkfabric.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class CommonPostActionResponseForDeviceUpdate(ErrorResponse):
    """Common response for device updates.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.managednetworkfabric.models.ErrorDetail
    :ivar configuration_state: Gets the configuration state. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar successful_devices: List of ARM Resource IDs for which the given action applied
     successfully.
    :vartype successful_devices: list[str]
    :ivar failed_devices: List of ARM Resource IDs for which the given action failed to apply.
    :vartype failed_devices: list[str]
    """

    _validation = {
        "configuration_state": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "successful_devices": {"key": "successfulDevices", "type": "[str]"},
        "failed_devices": {"key": "failedDevices", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
        successful_devices: Optional[List[str]] = None,
        failed_devices: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.managednetworkfabric.models.ErrorDetail
        :keyword successful_devices: List of ARM Resource IDs for which the given action applied
         successfully.
        :paramtype successful_devices: list[str]
        :keyword failed_devices: List of ARM Resource IDs for which the given action failed to apply.
        :paramtype failed_devices: list[str]
        """
        super().__init__(error=error, **kwargs)
        self.configuration_state = None
        self.successful_devices = successful_devices
        self.failed_devices = failed_devices


class CommonPostActionResponseForStateUpdate(ErrorResponse):
    """Common response for the state updates.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.managednetworkfabric.models.ErrorDetail
    :ivar configuration_state: Gets the configuration state. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    """

    _validation = {
        "configuration_state": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
        "configuration_state": {"key": "configurationState", "type": "str"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.managednetworkfabric.models.ErrorDetail
        """
        super().__init__(error=error, **kwargs)
        self.configuration_state = None


class ConnectedSubnet(AnnotationResource):
    """Connected Subnet properties.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar prefix: Prefix of the Connected Subnet. Required.
    :vartype prefix: str
    """

    _validation = {
        "prefix": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "prefix": {"key": "prefix", "type": "str"},
    }

    def __init__(self, *, prefix: str, annotation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword prefix: Prefix of the Connected Subnet. Required.
        :paramtype prefix: str
        """
        super().__init__(annotation=annotation, **kwargs)
        self.prefix = prefix


class ConnectedSubnetRoutePolicy(_serialization.Model):
    """Connected Subnet Route Policy properties.

    :ivar export_route_policy_id: ARM Resource ID of the Route Policy. This is used for the
     backward compatibility.
    :vartype export_route_policy_id: str
    :ivar export_route_policy: Array of ARM Resource ID of the RoutePolicies.
    :vartype export_route_policy: ~azure.mgmt.managednetworkfabric.models.L3ExportRoutePolicy
    """

    _attribute_map = {
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "export_route_policy": {"key": "exportRoutePolicy", "type": "L3ExportRoutePolicy"},
    }

    def __init__(
        self,
        *,
        export_route_policy_id: Optional[str] = None,
        export_route_policy: Optional["_models.L3ExportRoutePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword export_route_policy_id: ARM Resource ID of the Route Policy. This is used for the
         backward compatibility.
        :paramtype export_route_policy_id: str
        :keyword export_route_policy: Array of ARM Resource ID of the RoutePolicies.
        :paramtype export_route_policy: ~azure.mgmt.managednetworkfabric.models.L3ExportRoutePolicy
        """
        super().__init__(**kwargs)
        self.export_route_policy_id = export_route_policy_id
        self.export_route_policy = export_route_policy


class ControllerServices(_serialization.Model):
    """Network Fabric Controller services.

    :ivar ipv4_address_spaces: The IPv4 Address space is optional, if the value is not defined at
     the time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address
     subnet is an optional attribute.
    :vartype ipv4_address_spaces: list[str]
    :ivar ipv6_address_spaces: The IPv6 is not supported right now.
    :vartype ipv6_address_spaces: list[str]
    """

    _attribute_map = {
        "ipv4_address_spaces": {"key": "ipv4AddressSpaces", "type": "[str]"},
        "ipv6_address_spaces": {"key": "ipv6AddressSpaces", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        ipv4_address_spaces: Optional[List[str]] = None,
        ipv6_address_spaces: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ipv4_address_spaces: The IPv4 Address space is optional, if the value is not defined
         at the time of NFC creation, then the default value 10.0.0.0/19 is considered. The IPV4 address
         subnet is an optional attribute.
        :paramtype ipv4_address_spaces: list[str]
        :keyword ipv6_address_spaces: The IPv6 is not supported right now.
        :paramtype ipv6_address_spaces: list[str]
        """
        super().__init__(**kwargs)
        self.ipv4_address_spaces = ipv4_address_spaces
        self.ipv6_address_spaces = ipv6_address_spaces


class DestinationProperties(_serialization.Model):
    """The network tap destination properties.

    :ivar name: Destination name.
    :vartype name: str
    :ivar destination_type: Type of destination. Input can be IsolationDomain or Direct. Known
     values are: "IsolationDomain" and "Direct".
    :vartype destination_type: str or ~azure.mgmt.managednetworkfabric.models.DestinationType
    :ivar destination_id: The destination Id. ARM Resource ID of either NNI or Internal Networks.
    :vartype destination_id: str
    :ivar isolation_domain_properties: Isolation Domain Properties.
    :vartype isolation_domain_properties:
     ~azure.mgmt.managednetworkfabric.models.IsolationDomainProperties
    :ivar destination_tap_rule_id: ARM Resource ID of destination Tap Rule that contains match
     configurations.
    :vartype destination_tap_rule_id: str
    """

    _validation = {
        "name": {"min_length": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "destination_type": {"key": "destinationType", "type": "str"},
        "destination_id": {"key": "destinationId", "type": "str"},
        "isolation_domain_properties": {"key": "isolationDomainProperties", "type": "IsolationDomainProperties"},
        "destination_tap_rule_id": {"key": "destinationTapRuleId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        destination_type: Optional[Union[str, "_models.DestinationType"]] = None,
        destination_id: Optional[str] = None,
        isolation_domain_properties: Optional["_models.IsolationDomainProperties"] = None,
        destination_tap_rule_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Destination name.
        :paramtype name: str
        :keyword destination_type: Type of destination. Input can be IsolationDomain or Direct. Known
         values are: "IsolationDomain" and "Direct".
        :paramtype destination_type: str or ~azure.mgmt.managednetworkfabric.models.DestinationType
        :keyword destination_id: The destination Id. ARM Resource ID of either NNI or Internal
         Networks.
        :paramtype destination_id: str
        :keyword isolation_domain_properties: Isolation Domain Properties.
        :paramtype isolation_domain_properties:
         ~azure.mgmt.managednetworkfabric.models.IsolationDomainProperties
        :keyword destination_tap_rule_id: ARM Resource ID of destination Tap Rule that contains match
         configurations.
        :paramtype destination_tap_rule_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.destination_type = destination_type
        self.destination_id = destination_id
        self.isolation_domain_properties = isolation_domain_properties
        self.destination_tap_rule_id = destination_tap_rule_id


class DeviceInterfaceProperties(_serialization.Model):
    """Network device interface properties.

    :ivar identifier: Interface identifier. Example: HundredGigE0/0.
    :vartype identifier: str
    :ivar interface_type: Interface type.
    :vartype interface_type: str
    :ivar supported_connector_types: List of supported connector types.
    :vartype supported_connector_types:
     list[~azure.mgmt.managednetworkfabric.models.SupportedConnectorProperties]
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "interface_type": {"key": "interfaceType", "type": "str"},
        "supported_connector_types": {"key": "supportedConnectorTypes", "type": "[SupportedConnectorProperties]"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        interface_type: Optional[str] = None,
        supported_connector_types: Optional[List["_models.SupportedConnectorProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identifier: Interface identifier. Example: HundredGigE0/0.
        :paramtype identifier: str
        :keyword interface_type: Interface type.
        :paramtype interface_type: str
        :keyword supported_connector_types: List of supported connector types.
        :paramtype supported_connector_types:
         list[~azure.mgmt.managednetworkfabric.models.SupportedConnectorProperties]
        """
        super().__init__(**kwargs)
        self.identifier = identifier
        self.interface_type = interface_type
        self.supported_connector_types = supported_connector_types


class EnableDisableOnResources(_serialization.Model):
    """Update administrative state on list of resources.

    :ivar resource_ids: Network Fabrics or Network Rack resource Id.
    :vartype resource_ids: list[str]
    """

    _attribute_map = {
        "resource_ids": {"key": "resourceIds", "type": "[str]"},
    }

    def __init__(self, *, resource_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword resource_ids: Network Fabrics or Network Rack resource Id.
        :paramtype resource_ids: list[str]
        """
        super().__init__(**kwargs)
        self.resource_ids = resource_ids


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.managednetworkfabric.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.managednetworkfabric.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ExportRoutePolicy(_serialization.Model):
    """Export Route Policy either IPv4 or IPv6.

    :ivar export_ipv4_route_policy_id: ARM resource ID of RoutePolicy.
    :vartype export_ipv4_route_policy_id: str
    :ivar export_ipv6_route_policy_id: ARM resource ID of RoutePolicy.
    :vartype export_ipv6_route_policy_id: str
    """

    _attribute_map = {
        "export_ipv4_route_policy_id": {"key": "exportIpv4RoutePolicyId", "type": "str"},
        "export_ipv6_route_policy_id": {"key": "exportIpv6RoutePolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        export_ipv4_route_policy_id: Optional[str] = None,
        export_ipv6_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword export_ipv4_route_policy_id: ARM resource ID of RoutePolicy.
        :paramtype export_ipv4_route_policy_id: str
        :keyword export_ipv6_route_policy_id: ARM resource ID of RoutePolicy.
        :paramtype export_ipv6_route_policy_id: str
        """
        super().__init__(**kwargs)
        self.export_ipv4_route_policy_id = export_ipv4_route_policy_id
        self.export_ipv6_route_policy_id = export_ipv6_route_policy_id


class ExportRoutePolicyInformation(_serialization.Model):
    """Export Route Policy Configuration.

    :ivar export_ipv4_route_policy_id: Export IPv4 Route Policy Id.
    :vartype export_ipv4_route_policy_id: str
    :ivar export_ipv6_route_policy_id: Export IPv6 Route Policy Id.
    :vartype export_ipv6_route_policy_id: str
    """

    _attribute_map = {
        "export_ipv4_route_policy_id": {"key": "exportIpv4RoutePolicyId", "type": "str"},
        "export_ipv6_route_policy_id": {"key": "exportIpv6RoutePolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        export_ipv4_route_policy_id: Optional[str] = None,
        export_ipv6_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword export_ipv4_route_policy_id: Export IPv4 Route Policy Id.
        :paramtype export_ipv4_route_policy_id: str
        :keyword export_ipv6_route_policy_id: Export IPv6 Route Policy Id.
        :paramtype export_ipv6_route_policy_id: str
        """
        super().__init__(**kwargs)
        self.export_ipv4_route_policy_id = export_ipv4_route_policy_id
        self.export_ipv6_route_policy_id = export_ipv6_route_policy_id


class ExpressRouteConnectionInformation(_serialization.Model):
    """The ExpressRoute circuit ID and the Auth Key are required for you to successfully deploy NFC
    service.

    All required parameters must be populated in order to send to Azure.

    :ivar express_route_circuit_id: The express route circuit Azure resource ID, must be of type
     Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory
     attribute. Required.
    :vartype express_route_circuit_id: str
    :ivar express_route_authorization_key: Authorization key for the circuit, must be of type
     Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
     Required.
    :vartype express_route_authorization_key: str
    """

    _validation = {
        "express_route_circuit_id": {"required": True},
        "express_route_authorization_key": {"required": True},
    }

    _attribute_map = {
        "express_route_circuit_id": {"key": "expressRouteCircuitId", "type": "str"},
        "express_route_authorization_key": {"key": "expressRouteAuthorizationKey", "type": "str"},
    }

    def __init__(self, *, express_route_circuit_id: str, express_route_authorization_key: str, **kwargs: Any) -> None:
        """
        :keyword express_route_circuit_id: The express route circuit Azure resource ID, must be of type
         Microsoft.Network/expressRouteCircuits/circuitName. The ExpressRoute Circuit is a mandatory
         attribute. Required.
        :paramtype express_route_circuit_id: str
        :keyword express_route_authorization_key: Authorization key for the circuit, must be of type
         Microsoft.Network/expressRouteCircuits/authorizations. The Auth Key is a mandatory attribute.
         Required.
        :paramtype express_route_authorization_key: str
        """
        super().__init__(**kwargs)
        self.express_route_circuit_id = express_route_circuit_id
        self.express_route_authorization_key = express_route_authorization_key


class ExtendedLocation(_serialization.Model):
    """The extended location.

    :ivar type: The extended location type.
    :vartype type: str
    :ivar name: The extended location name.
    :vartype name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: Optional[str] = None, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword type: The extended location type.
        :paramtype type: str
        :keyword name: The extended location name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class ExtensionEnumProperty(_serialization.Model):
    """Extension property.

    :ivar extension: Extension. Example: NoExtension | NPB. Known values are: "NoExtension" and
     "NPB".
    :vartype extension: str or ~azure.mgmt.managednetworkfabric.models.Extension
    """

    _attribute_map = {
        "extension": {"key": "extension", "type": "str"},
    }

    def __init__(self, *, extension: Union[str, "_models.Extension"] = "NoExtension", **kwargs: Any) -> None:
        """
        :keyword extension: Extension. Example: NoExtension | NPB. Known values are: "NoExtension" and
         "NPB".
        :paramtype extension: str or ~azure.mgmt.managednetworkfabric.models.Extension
        """
        super().__init__(**kwargs)
        self.extension = extension


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ExternalNetwork(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Defines the External Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype export_route_policy_id: str
    :ivar import_route_policy: Import Route Policy either IPv4 or IPv6.
    :vartype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
    :ivar export_route_policy: Export Route Policy either IPv4 or IPv6.
    :vartype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
    :ivar network_to_network_interconnect_id: Gets the networkToNetworkInterconnectId of the
     resource.
    :vartype network_to_network_interconnect_id: str
    :ivar peering_option: Peering option list. Required. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties object.
    :vartype option_b_properties: ~azure.mgmt.managednetworkfabric.models.L3OptionBProperties
    :ivar option_a_properties: option A properties object.
    :vartype option_a_properties:
     ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPropertiesOptionAProperties
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "network_to_network_interconnect_id": {"readonly": True},
        "peering_option": {"required": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "import_route_policy_id": {"key": "properties.importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "properties.exportRoutePolicyId", "type": "str"},
        "import_route_policy": {"key": "properties.importRoutePolicy", "type": "ImportRoutePolicy"},
        "export_route_policy": {"key": "properties.exportRoutePolicy", "type": "ExportRoutePolicy"},
        "network_to_network_interconnect_id": {"key": "properties.networkToNetworkInterconnectId", "type": "str"},
        "peering_option": {"key": "properties.peeringOption", "type": "str"},
        "option_b_properties": {"key": "properties.optionBProperties", "type": "L3OptionBProperties"},
        "option_a_properties": {
            "key": "properties.optionAProperties",
            "type": "ExternalNetworkPropertiesOptionAProperties",
        },
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        peering_option: Union[str, "_models.PeeringOption"],
        annotation: Optional[str] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        import_route_policy: Optional["_models.ImportRoutePolicy"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicy"] = None,
        option_b_properties: Optional["_models.L3OptionBProperties"] = None,
        option_a_properties: Optional["_models.ExternalNetworkPropertiesOptionAProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype export_route_policy_id: str
        :keyword import_route_policy: Import Route Policy either IPv4 or IPv6.
        :paramtype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
        :keyword export_route_policy: Export Route Policy either IPv4 or IPv6.
        :paramtype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
        :keyword peering_option: Peering option list. Required. Known values are: "OptionA" and
         "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties object.
        :paramtype option_b_properties: ~azure.mgmt.managednetworkfabric.models.L3OptionBProperties
        :keyword option_a_properties: option A properties object.
        :paramtype option_a_properties:
         ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPropertiesOptionAProperties
        """
        super().__init__(**kwargs)
        self.annotation = annotation
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy
        self.network_to_network_interconnect_id = None
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class ExternalNetworkPatch(_serialization.Model):
    """The ExternalNetwork patch resource definition.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype export_route_policy_id: str
    :ivar import_route_policy: Import Route Policy either IPv4 or IPv6.
    :vartype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
    :ivar export_route_policy: Export Route Policy either IPv4 or IPv6.
    :vartype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
    :ivar peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties object.
    :vartype option_b_properties: ~azure.mgmt.managednetworkfabric.models.L3OptionBProperties
    :ivar option_a_properties: option A properties object.
    :vartype option_a_properties:
     ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPatchPropertiesOptionAProperties
    """

    _attribute_map = {
        "annotation": {"key": "properties.annotation", "type": "str"},
        "import_route_policy_id": {"key": "properties.importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "properties.exportRoutePolicyId", "type": "str"},
        "import_route_policy": {"key": "properties.importRoutePolicy", "type": "ImportRoutePolicy"},
        "export_route_policy": {"key": "properties.exportRoutePolicy", "type": "ExportRoutePolicy"},
        "peering_option": {"key": "properties.peeringOption", "type": "str"},
        "option_b_properties": {"key": "properties.optionBProperties", "type": "L3OptionBProperties"},
        "option_a_properties": {
            "key": "properties.optionAProperties",
            "type": "ExternalNetworkPatchPropertiesOptionAProperties",
        },
    }

    def __init__(
        self,
        *,
        annotation: Optional[str] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        import_route_policy: Optional["_models.ImportRoutePolicy"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicy"] = None,
        peering_option: Optional[Union[str, "_models.PeeringOption"]] = None,
        option_b_properties: Optional["_models.L3OptionBProperties"] = None,
        option_a_properties: Optional["_models.ExternalNetworkPatchPropertiesOptionAProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype export_route_policy_id: str
        :keyword import_route_policy: Import Route Policy either IPv4 or IPv6.
        :paramtype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
        :keyword export_route_policy: Export Route Policy either IPv4 or IPv6.
        :paramtype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
        :keyword peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties object.
        :paramtype option_b_properties: ~azure.mgmt.managednetworkfabric.models.L3OptionBProperties
        :keyword option_a_properties: option A properties object.
        :paramtype option_a_properties:
         ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPatchPropertiesOptionAProperties
        """
        super().__init__(**kwargs)
        self.annotation = annotation
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties


class ExternalNetworkPatchableProperties(_serialization.Model):
    """The ExternalNetwork patchable properties.

    :ivar import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype export_route_policy_id: str
    :ivar import_route_policy: Import Route Policy either IPv4 or IPv6.
    :vartype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
    :ivar export_route_policy: Export Route Policy either IPv4 or IPv6.
    :vartype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
    """

    _attribute_map = {
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "import_route_policy": {"key": "importRoutePolicy", "type": "ImportRoutePolicy"},
        "export_route_policy": {"key": "exportRoutePolicy", "type": "ExportRoutePolicy"},
    }

    def __init__(
        self,
        *,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        import_route_policy: Optional["_models.ImportRoutePolicy"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype export_route_policy_id: str
        :keyword import_route_policy: Import Route Policy either IPv4 or IPv6.
        :paramtype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
        :keyword export_route_policy: Export Route Policy either IPv4 or IPv6.
        :paramtype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
        """
        super().__init__(**kwargs)
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy


class ExternalNetworkPatchProperties(AnnotationResource, ExternalNetworkPatchableProperties):
    """External Network Patch properties.

    :ivar import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype export_route_policy_id: str
    :ivar import_route_policy: Import Route Policy either IPv4 or IPv6.
    :vartype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
    :ivar export_route_policy: Export Route Policy either IPv4 or IPv6.
    :vartype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties object.
    :vartype option_b_properties: ~azure.mgmt.managednetworkfabric.models.L3OptionBProperties
    :ivar option_a_properties: option A properties object.
    :vartype option_a_properties:
     ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPatchPropertiesOptionAProperties
    """

    _attribute_map = {
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "import_route_policy": {"key": "importRoutePolicy", "type": "ImportRoutePolicy"},
        "export_route_policy": {"key": "exportRoutePolicy", "type": "ExportRoutePolicy"},
        "annotation": {"key": "annotation", "type": "str"},
        "peering_option": {"key": "peeringOption", "type": "str"},
        "option_b_properties": {"key": "optionBProperties", "type": "L3OptionBProperties"},
        "option_a_properties": {"key": "optionAProperties", "type": "ExternalNetworkPatchPropertiesOptionAProperties"},
    }

    def __init__(
        self,
        *,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        import_route_policy: Optional["_models.ImportRoutePolicy"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicy"] = None,
        annotation: Optional[str] = None,
        peering_option: Optional[Union[str, "_models.PeeringOption"]] = None,
        option_b_properties: Optional["_models.L3OptionBProperties"] = None,
        option_a_properties: Optional["_models.ExternalNetworkPatchPropertiesOptionAProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype export_route_policy_id: str
        :keyword import_route_policy: Import Route Policy either IPv4 or IPv6.
        :paramtype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
        :keyword export_route_policy: Export Route Policy either IPv4 or IPv6.
        :paramtype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties object.
        :paramtype option_b_properties: ~azure.mgmt.managednetworkfabric.models.L3OptionBProperties
        :keyword option_a_properties: option A properties object.
        :paramtype option_a_properties:
         ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPatchPropertiesOptionAProperties
        """
        super().__init__(
            annotation=annotation,
            import_route_policy_id=import_route_policy_id,
            export_route_policy_id=export_route_policy_id,
            import_route_policy=import_route_policy,
            export_route_policy=export_route_policy,
            **kwargs
        )
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties
        self.annotation = annotation


class L3OptionAProperties(_serialization.Model):
    """Peering optionA properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mtu: MTU to use for option A peering.
    :vartype mtu: int
    :ivar vlan_id: Vlan identifier. Example : 501.
    :vartype vlan_id: int
    :ivar fabric_asn: Fabric ASN number. Example 65001.
    :vartype fabric_asn: int
    :ivar peer_asn: Peer ASN number.Example : 28.
    :vartype peer_asn: int
    :ivar bfd_configuration: BFD configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    :ivar ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
    :vartype ingress_acl_id: str
    :ivar egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
    :vartype egress_acl_id: str
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
        "vlan_id": {"maximum": 4094, "minimum": 501},
        "fabric_asn": {"readonly": True, "maximum": 4294967295, "minimum": 1},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
    }

    _attribute_map = {
        "mtu": {"key": "mtu", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
        "ingress_acl_id": {"key": "ingressAclId", "type": "str"},
        "egress_acl_id": {"key": "egressAclId", "type": "str"},
    }

    def __init__(
        self,
        *,
        mtu: int = 1500,
        vlan_id: Optional[int] = None,
        peer_asn: Optional[int] = None,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        ingress_acl_id: Optional[str] = None,
        egress_acl_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mtu: MTU to use for option A peering.
        :paramtype mtu: int
        :keyword vlan_id: Vlan identifier. Example : 501.
        :paramtype vlan_id: int
        :keyword peer_asn: Peer ASN number.Example : 28.
        :paramtype peer_asn: int
        :keyword bfd_configuration: BFD configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        :keyword ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
        :paramtype ingress_acl_id: str
        :keyword egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
        :paramtype egress_acl_id: str
        """
        super().__init__(**kwargs)
        self.mtu = mtu
        self.vlan_id = vlan_id
        self.fabric_asn = None
        self.peer_asn = peer_asn
        self.bfd_configuration = bfd_configuration
        self.ingress_acl_id = ingress_acl_id
        self.egress_acl_id = egress_acl_id


class Layer3IpPrefixProperties(_serialization.Model):
    """Layer 3 primary and secondary IP Address prefixes.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
    :vartype secondary_ipv6_prefix: str
    """

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
        :paramtype secondary_ipv6_prefix: str
        """
        super().__init__(**kwargs)
        self.primary_ipv4_prefix = primary_ipv4_prefix
        self.primary_ipv6_prefix = primary_ipv6_prefix
        self.secondary_ipv4_prefix = secondary_ipv4_prefix
        self.secondary_ipv6_prefix = secondary_ipv6_prefix


class ExternalNetworkPatchPropertiesOptionAProperties(
    Layer3IpPrefixProperties, L3OptionAProperties
):  # pylint: disable=too-many-instance-attributes
    """option A properties object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mtu: MTU to use for option A peering.
    :vartype mtu: int
    :ivar vlan_id: Vlan identifier. Example : 501.
    :vartype vlan_id: int
    :ivar fabric_asn: Fabric ASN number. Example 65001.
    :vartype fabric_asn: int
    :ivar peer_asn: Peer ASN number.Example : 28.
    :vartype peer_asn: int
    :ivar bfd_configuration: BFD configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    :ivar ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
    :vartype ingress_acl_id: str
    :ivar egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
    :vartype egress_acl_id: str
    :ivar primary_ipv4_prefix: IPv4 Address Prefix.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
    :vartype secondary_ipv6_prefix: str
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
        "vlan_id": {"maximum": 4094, "minimum": 501},
        "fabric_asn": {"readonly": True, "maximum": 4294967295, "minimum": 1},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
    }

    _attribute_map = {
        "mtu": {"key": "mtu", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
        "ingress_acl_id": {"key": "ingressAclId", "type": "str"},
        "egress_acl_id": {"key": "egressAclId", "type": "str"},
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
    }

    def __init__(
        self,
        *,
        mtu: int = 1500,
        vlan_id: Optional[int] = None,
        peer_asn: Optional[int] = None,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        ingress_acl_id: Optional[str] = None,
        egress_acl_id: Optional[str] = None,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mtu: MTU to use for option A peering.
        :paramtype mtu: int
        :keyword vlan_id: Vlan identifier. Example : 501.
        :paramtype vlan_id: int
        :keyword peer_asn: Peer ASN number.Example : 28.
        :paramtype peer_asn: int
        :keyword bfd_configuration: BFD configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        :keyword ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
        :paramtype ingress_acl_id: str
        :keyword egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
        :paramtype egress_acl_id: str
        :keyword primary_ipv4_prefix: IPv4 Address Prefix.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
        :paramtype secondary_ipv6_prefix: str
        """
        super().__init__(
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            mtu=mtu,
            vlan_id=vlan_id,
            peer_asn=peer_asn,
            bfd_configuration=bfd_configuration,
            ingress_acl_id=ingress_acl_id,
            egress_acl_id=egress_acl_id,
            **kwargs
        )
        self.mtu = mtu
        self.vlan_id = vlan_id
        self.fabric_asn = None
        self.peer_asn = peer_asn
        self.bfd_configuration = bfd_configuration
        self.ingress_acl_id = ingress_acl_id
        self.egress_acl_id = egress_acl_id
        self.primary_ipv4_prefix = primary_ipv4_prefix
        self.primary_ipv6_prefix = primary_ipv6_prefix
        self.secondary_ipv4_prefix = secondary_ipv4_prefix
        self.secondary_ipv6_prefix = secondary_ipv6_prefix


class ExternalNetworkProperties(
    AnnotationResource, ExternalNetworkPatchableProperties
):  # pylint: disable=too-many-instance-attributes
    """External Network Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype export_route_policy_id: str
    :ivar import_route_policy: Import Route Policy either IPv4 or IPv6.
    :vartype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
    :ivar export_route_policy: Export Route Policy either IPv4 or IPv6.
    :vartype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_to_network_interconnect_id: Gets the networkToNetworkInterconnectId of the
     resource.
    :vartype network_to_network_interconnect_id: str
    :ivar peering_option: Peering option list. Required. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties object.
    :vartype option_b_properties: ~azure.mgmt.managednetworkfabric.models.L3OptionBProperties
    :ivar option_a_properties: option A properties object.
    :vartype option_a_properties:
     ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPropertiesOptionAProperties
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "network_to_network_interconnect_id": {"readonly": True},
        "peering_option": {"required": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "import_route_policy": {"key": "importRoutePolicy", "type": "ImportRoutePolicy"},
        "export_route_policy": {"key": "exportRoutePolicy", "type": "ExportRoutePolicy"},
        "annotation": {"key": "annotation", "type": "str"},
        "network_to_network_interconnect_id": {"key": "networkToNetworkInterconnectId", "type": "str"},
        "peering_option": {"key": "peeringOption", "type": "str"},
        "option_b_properties": {"key": "optionBProperties", "type": "L3OptionBProperties"},
        "option_a_properties": {"key": "optionAProperties", "type": "ExternalNetworkPropertiesOptionAProperties"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        peering_option: Union[str, "_models.PeeringOption"],
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        import_route_policy: Optional["_models.ImportRoutePolicy"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicy"] = None,
        annotation: Optional[str] = None,
        option_b_properties: Optional["_models.L3OptionBProperties"] = None,
        option_a_properties: Optional["_models.ExternalNetworkPropertiesOptionAProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype export_route_policy_id: str
        :keyword import_route_policy: Import Route Policy either IPv4 or IPv6.
        :paramtype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
        :keyword export_route_policy: Export Route Policy either IPv4 or IPv6.
        :paramtype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword peering_option: Peering option list. Required. Known values are: "OptionA" and
         "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties object.
        :paramtype option_b_properties: ~azure.mgmt.managednetworkfabric.models.L3OptionBProperties
        :keyword option_a_properties: option A properties object.
        :paramtype option_a_properties:
         ~azure.mgmt.managednetworkfabric.models.ExternalNetworkPropertiesOptionAProperties
        """
        super().__init__(
            annotation=annotation,
            import_route_policy_id=import_route_policy_id,
            export_route_policy_id=export_route_policy_id,
            import_route_policy=import_route_policy,
            export_route_policy=export_route_policy,
            **kwargs
        )
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy
        self.network_to_network_interconnect_id = None
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None
        self.annotation = annotation


class ExternalNetworkPropertiesOptionAProperties(
    Layer3IpPrefixProperties, L3OptionAProperties
):  # pylint: disable=too-many-instance-attributes
    """option A properties object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mtu: MTU to use for option A peering.
    :vartype mtu: int
    :ivar vlan_id: Vlan identifier. Example : 501.
    :vartype vlan_id: int
    :ivar fabric_asn: Fabric ASN number. Example 65001.
    :vartype fabric_asn: int
    :ivar peer_asn: Peer ASN number.Example : 28.
    :vartype peer_asn: int
    :ivar bfd_configuration: BFD configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    :ivar ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
    :vartype ingress_acl_id: str
    :ivar egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
    :vartype egress_acl_id: str
    :ivar primary_ipv4_prefix: IPv4 Address Prefix.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
    :vartype secondary_ipv6_prefix: str
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
        "vlan_id": {"maximum": 4094, "minimum": 501},
        "fabric_asn": {"readonly": True, "maximum": 4294967295, "minimum": 1},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
    }

    _attribute_map = {
        "mtu": {"key": "mtu", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
        "ingress_acl_id": {"key": "ingressAclId", "type": "str"},
        "egress_acl_id": {"key": "egressAclId", "type": "str"},
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
    }

    def __init__(
        self,
        *,
        mtu: int = 1500,
        vlan_id: Optional[int] = None,
        peer_asn: Optional[int] = None,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        ingress_acl_id: Optional[str] = None,
        egress_acl_id: Optional[str] = None,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mtu: MTU to use for option A peering.
        :paramtype mtu: int
        :keyword vlan_id: Vlan identifier. Example : 501.
        :paramtype vlan_id: int
        :keyword peer_asn: Peer ASN number.Example : 28.
        :paramtype peer_asn: int
        :keyword bfd_configuration: BFD configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        :keyword ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
        :paramtype ingress_acl_id: str
        :keyword egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
        :paramtype egress_acl_id: str
        :keyword primary_ipv4_prefix: IPv4 Address Prefix.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
        :paramtype secondary_ipv6_prefix: str
        """
        super().__init__(
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            mtu=mtu,
            vlan_id=vlan_id,
            peer_asn=peer_asn,
            bfd_configuration=bfd_configuration,
            ingress_acl_id=ingress_acl_id,
            egress_acl_id=egress_acl_id,
            **kwargs
        )
        self.mtu = mtu
        self.vlan_id = vlan_id
        self.fabric_asn = None
        self.peer_asn = peer_asn
        self.bfd_configuration = bfd_configuration
        self.ingress_acl_id = ingress_acl_id
        self.egress_acl_id = egress_acl_id
        self.primary_ipv4_prefix = primary_ipv4_prefix
        self.primary_ipv6_prefix = primary_ipv6_prefix
        self.secondary_ipv4_prefix = secondary_ipv4_prefix
        self.secondary_ipv6_prefix = secondary_ipv6_prefix


class ExternalNetworksList(_serialization.Model):
    """List of External Networks.

    :ivar value: List of External Network resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.ExternalNetwork]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExternalNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExternalNetwork"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of External Network resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.ExternalNetwork]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImportRoutePolicy(_serialization.Model):
    """Import Route Policy either IPv4 or IPv6.

    :ivar import_ipv4_route_policy_id: ARM resource ID of RoutePolicy.
    :vartype import_ipv4_route_policy_id: str
    :ivar import_ipv6_route_policy_id: ARM resource ID of RoutePolicy.
    :vartype import_ipv6_route_policy_id: str
    """

    _attribute_map = {
        "import_ipv4_route_policy_id": {"key": "importIpv4RoutePolicyId", "type": "str"},
        "import_ipv6_route_policy_id": {"key": "importIpv6RoutePolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        import_ipv4_route_policy_id: Optional[str] = None,
        import_ipv6_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword import_ipv4_route_policy_id: ARM resource ID of RoutePolicy.
        :paramtype import_ipv4_route_policy_id: str
        :keyword import_ipv6_route_policy_id: ARM resource ID of RoutePolicy.
        :paramtype import_ipv6_route_policy_id: str
        """
        super().__init__(**kwargs)
        self.import_ipv4_route_policy_id = import_ipv4_route_policy_id
        self.import_ipv6_route_policy_id = import_ipv6_route_policy_id


class ImportRoutePolicyInformation(_serialization.Model):
    """Import Route Policy Configuration.

    :ivar import_ipv4_route_policy_id: Import IPv4 Route Policy Id.
    :vartype import_ipv4_route_policy_id: str
    :ivar import_ipv6_route_policy_id: Import IPv6 Route Policy Id.
    :vartype import_ipv6_route_policy_id: str
    """

    _attribute_map = {
        "import_ipv4_route_policy_id": {"key": "importIpv4RoutePolicyId", "type": "str"},
        "import_ipv6_route_policy_id": {"key": "importIpv6RoutePolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        import_ipv4_route_policy_id: Optional[str] = None,
        import_ipv6_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword import_ipv4_route_policy_id: Import IPv4 Route Policy Id.
        :paramtype import_ipv4_route_policy_id: str
        :keyword import_ipv6_route_policy_id: Import IPv6 Route Policy Id.
        :paramtype import_ipv6_route_policy_id: str
        """
        super().__init__(**kwargs)
        self.import_ipv4_route_policy_id = import_ipv4_route_policy_id
        self.import_ipv6_route_policy_id = import_ipv6_route_policy_id


class InternalNetwork(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Defines the Internal Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar connected_i_pv4_subnets: List of Connected IPv4 Subnets.
    :vartype connected_i_pv4_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar connected_i_pv6_subnets: List of connected IPv6 Subnets.
    :vartype connected_i_pv6_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype export_route_policy_id: str
    :ivar import_route_policy: Import Route Policy either IPv4 or IPv6.
    :vartype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
    :ivar export_route_policy: Export Route Policy either IPv4 or IPv6.
    :vartype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
    :ivar ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
    :vartype ingress_acl_id: str
    :ivar egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
    :vartype egress_acl_id: str
    :ivar is_monitoring_enabled: To check whether monitoring of internal network is enabled or not.
     Known values are: "True" and "False".
    :vartype is_monitoring_enabled: str or
     ~azure.mgmt.managednetworkfabric.models.IsMonitoringEnabled
    :ivar extension: Extension. Example: NoExtension | NPB. Known values are: "NoExtension" and
     "NPB".
    :vartype extension: str or ~azure.mgmt.managednetworkfabric.models.Extension
    :ivar vlan_id: Vlan identifier. Example: 1001. Required.
    :vartype vlan_id: int
    :ivar bgp_configuration: BGP configuration properties.
    :vartype bgp_configuration:
     ~azure.mgmt.managednetworkfabric.models.InternalNetworkPropertiesBgpConfiguration
    :ivar static_route_configuration: Static Route Configuration properties.
    :vartype static_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.InternalNetworkPropertiesStaticRouteConfiguration
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "mtu": {"maximum": 9200, "minimum": 64},
        "connected_i_pv4_subnets": {"min_items": 1},
        "connected_i_pv6_subnets": {"min_items": 1},
        "vlan_id": {"required": True, "maximum": 4094, "minimum": 100},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "mtu": {"key": "properties.mtu", "type": "int"},
        "connected_i_pv4_subnets": {"key": "properties.connectedIPv4Subnets", "type": "[ConnectedSubnet]"},
        "connected_i_pv6_subnets": {"key": "properties.connectedIPv6Subnets", "type": "[ConnectedSubnet]"},
        "import_route_policy_id": {"key": "properties.importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "properties.exportRoutePolicyId", "type": "str"},
        "import_route_policy": {"key": "properties.importRoutePolicy", "type": "ImportRoutePolicy"},
        "export_route_policy": {"key": "properties.exportRoutePolicy", "type": "ExportRoutePolicy"},
        "ingress_acl_id": {"key": "properties.ingressAclId", "type": "str"},
        "egress_acl_id": {"key": "properties.egressAclId", "type": "str"},
        "is_monitoring_enabled": {"key": "properties.isMonitoringEnabled", "type": "str"},
        "extension": {"key": "properties.extension", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
        "bgp_configuration": {
            "key": "properties.bgpConfiguration",
            "type": "InternalNetworkPropertiesBgpConfiguration",
        },
        "static_route_configuration": {
            "key": "properties.staticRouteConfiguration",
            "type": "InternalNetworkPropertiesStaticRouteConfiguration",
        },
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        vlan_id: int,
        annotation: Optional[str] = None,
        mtu: int = 1500,
        connected_i_pv4_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        connected_i_pv6_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        import_route_policy: Optional["_models.ImportRoutePolicy"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicy"] = None,
        ingress_acl_id: Optional[str] = None,
        egress_acl_id: Optional[str] = None,
        is_monitoring_enabled: Union[str, "_models.IsMonitoringEnabled"] = "False",
        extension: Union[str, "_models.Extension"] = "NoExtension",
        bgp_configuration: Optional["_models.InternalNetworkPropertiesBgpConfiguration"] = None,
        static_route_configuration: Optional["_models.InternalNetworkPropertiesStaticRouteConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        :keyword connected_i_pv4_subnets: List of Connected IPv4 Subnets.
        :paramtype connected_i_pv4_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword connected_i_pv6_subnets: List of connected IPv6 Subnets.
        :paramtype connected_i_pv6_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype export_route_policy_id: str
        :keyword import_route_policy: Import Route Policy either IPv4 or IPv6.
        :paramtype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
        :keyword export_route_policy: Export Route Policy either IPv4 or IPv6.
        :paramtype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
        :keyword ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
        :paramtype ingress_acl_id: str
        :keyword egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
        :paramtype egress_acl_id: str
        :keyword is_monitoring_enabled: To check whether monitoring of internal network is enabled or
         not. Known values are: "True" and "False".
        :paramtype is_monitoring_enabled: str or
         ~azure.mgmt.managednetworkfabric.models.IsMonitoringEnabled
        :keyword extension: Extension. Example: NoExtension | NPB. Known values are: "NoExtension" and
         "NPB".
        :paramtype extension: str or ~azure.mgmt.managednetworkfabric.models.Extension
        :keyword vlan_id: Vlan identifier. Example: 1001. Required.
        :paramtype vlan_id: int
        :keyword bgp_configuration: BGP configuration properties.
        :paramtype bgp_configuration:
         ~azure.mgmt.managednetworkfabric.models.InternalNetworkPropertiesBgpConfiguration
        :keyword static_route_configuration: Static Route Configuration properties.
        :paramtype static_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.InternalNetworkPropertiesStaticRouteConfiguration
        """
        super().__init__(**kwargs)
        self.annotation = annotation
        self.mtu = mtu
        self.connected_i_pv4_subnets = connected_i_pv4_subnets
        self.connected_i_pv6_subnets = connected_i_pv6_subnets
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy
        self.ingress_acl_id = ingress_acl_id
        self.egress_acl_id = egress_acl_id
        self.is_monitoring_enabled = is_monitoring_enabled
        self.extension = extension
        self.vlan_id = vlan_id
        self.bgp_configuration = bgp_configuration
        self.static_route_configuration = static_route_configuration
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class InternalNetworkPatch(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The InternalNetwork patch resource definition.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar connected_i_pv4_subnets: List of Connected IPv4 Subnets.
    :vartype connected_i_pv4_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar connected_i_pv6_subnets: List of connected IPv6 Subnets.
    :vartype connected_i_pv6_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype export_route_policy_id: str
    :ivar import_route_policy: Import Route Policy either IPv4 or IPv6.
    :vartype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
    :ivar export_route_policy: Export Route Policy either IPv4 or IPv6.
    :vartype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
    :ivar ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
    :vartype ingress_acl_id: str
    :ivar egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
    :vartype egress_acl_id: str
    :ivar is_monitoring_enabled: To check whether monitoring of internal network is enabled or not.
     Known values are: "True" and "False".
    :vartype is_monitoring_enabled: str or
     ~azure.mgmt.managednetworkfabric.models.IsMonitoringEnabled
    :ivar bgp_configuration: BGP configuration properties.
    :vartype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
    :ivar static_route_configuration: Static Route Configuration properties.
    :vartype static_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
        "connected_i_pv4_subnets": {"min_items": 1},
        "connected_i_pv6_subnets": {"min_items": 1},
    }

    _attribute_map = {
        "annotation": {"key": "properties.annotation", "type": "str"},
        "mtu": {"key": "properties.mtu", "type": "int"},
        "connected_i_pv4_subnets": {"key": "properties.connectedIPv4Subnets", "type": "[ConnectedSubnet]"},
        "connected_i_pv6_subnets": {"key": "properties.connectedIPv6Subnets", "type": "[ConnectedSubnet]"},
        "import_route_policy_id": {"key": "properties.importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "properties.exportRoutePolicyId", "type": "str"},
        "import_route_policy": {"key": "properties.importRoutePolicy", "type": "ImportRoutePolicy"},
        "export_route_policy": {"key": "properties.exportRoutePolicy", "type": "ExportRoutePolicy"},
        "ingress_acl_id": {"key": "properties.ingressAclId", "type": "str"},
        "egress_acl_id": {"key": "properties.egressAclId", "type": "str"},
        "is_monitoring_enabled": {"key": "properties.isMonitoringEnabled", "type": "str"},
        "bgp_configuration": {"key": "properties.bgpConfiguration", "type": "BgpConfiguration"},
        "static_route_configuration": {
            "key": "properties.staticRouteConfiguration",
            "type": "StaticRouteConfiguration",
        },
    }

    def __init__(
        self,
        *,
        annotation: Optional[str] = None,
        mtu: int = 1500,
        connected_i_pv4_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        connected_i_pv6_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        import_route_policy: Optional["_models.ImportRoutePolicy"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicy"] = None,
        ingress_acl_id: Optional[str] = None,
        egress_acl_id: Optional[str] = None,
        is_monitoring_enabled: Union[str, "_models.IsMonitoringEnabled"] = "False",
        bgp_configuration: Optional["_models.BgpConfiguration"] = None,
        static_route_configuration: Optional["_models.StaticRouteConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        :keyword connected_i_pv4_subnets: List of Connected IPv4 Subnets.
        :paramtype connected_i_pv4_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword connected_i_pv6_subnets: List of connected IPv6 Subnets.
        :paramtype connected_i_pv6_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype export_route_policy_id: str
        :keyword import_route_policy: Import Route Policy either IPv4 or IPv6.
        :paramtype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
        :keyword export_route_policy: Export Route Policy either IPv4 or IPv6.
        :paramtype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
        :keyword ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
        :paramtype ingress_acl_id: str
        :keyword egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
        :paramtype egress_acl_id: str
        :keyword is_monitoring_enabled: To check whether monitoring of internal network is enabled or
         not. Known values are: "True" and "False".
        :paramtype is_monitoring_enabled: str or
         ~azure.mgmt.managednetworkfabric.models.IsMonitoringEnabled
        :keyword bgp_configuration: BGP configuration properties.
        :paramtype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
        :keyword static_route_configuration: Static Route Configuration properties.
        :paramtype static_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
        """
        super().__init__(**kwargs)
        self.annotation = annotation
        self.mtu = mtu
        self.connected_i_pv4_subnets = connected_i_pv4_subnets
        self.connected_i_pv6_subnets = connected_i_pv6_subnets
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy
        self.ingress_acl_id = ingress_acl_id
        self.egress_acl_id = egress_acl_id
        self.is_monitoring_enabled = is_monitoring_enabled
        self.bgp_configuration = bgp_configuration
        self.static_route_configuration = static_route_configuration


class InternalNetworkPatchableProperties(_serialization.Model):
    """The InternalNetwork patchable properties.

    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar connected_i_pv4_subnets: List of Connected IPv4 Subnets.
    :vartype connected_i_pv4_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar connected_i_pv6_subnets: List of connected IPv6 Subnets.
    :vartype connected_i_pv6_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype export_route_policy_id: str
    :ivar import_route_policy: Import Route Policy either IPv4 or IPv6.
    :vartype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
    :ivar export_route_policy: Export Route Policy either IPv4 or IPv6.
    :vartype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
    :ivar ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
    :vartype ingress_acl_id: str
    :ivar egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
    :vartype egress_acl_id: str
    :ivar is_monitoring_enabled: To check whether monitoring of internal network is enabled or not.
     Known values are: "True" and "False".
    :vartype is_monitoring_enabled: str or
     ~azure.mgmt.managednetworkfabric.models.IsMonitoringEnabled
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
        "connected_i_pv4_subnets": {"min_items": 1},
        "connected_i_pv6_subnets": {"min_items": 1},
    }

    _attribute_map = {
        "mtu": {"key": "mtu", "type": "int"},
        "connected_i_pv4_subnets": {"key": "connectedIPv4Subnets", "type": "[ConnectedSubnet]"},
        "connected_i_pv6_subnets": {"key": "connectedIPv6Subnets", "type": "[ConnectedSubnet]"},
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "import_route_policy": {"key": "importRoutePolicy", "type": "ImportRoutePolicy"},
        "export_route_policy": {"key": "exportRoutePolicy", "type": "ExportRoutePolicy"},
        "ingress_acl_id": {"key": "ingressAclId", "type": "str"},
        "egress_acl_id": {"key": "egressAclId", "type": "str"},
        "is_monitoring_enabled": {"key": "isMonitoringEnabled", "type": "str"},
    }

    def __init__(
        self,
        *,
        mtu: int = 1500,
        connected_i_pv4_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        connected_i_pv6_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        import_route_policy: Optional["_models.ImportRoutePolicy"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicy"] = None,
        ingress_acl_id: Optional[str] = None,
        egress_acl_id: Optional[str] = None,
        is_monitoring_enabled: Union[str, "_models.IsMonitoringEnabled"] = "False",
        **kwargs: Any
    ) -> None:
        """
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        :keyword connected_i_pv4_subnets: List of Connected IPv4 Subnets.
        :paramtype connected_i_pv4_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword connected_i_pv6_subnets: List of connected IPv6 Subnets.
        :paramtype connected_i_pv6_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype export_route_policy_id: str
        :keyword import_route_policy: Import Route Policy either IPv4 or IPv6.
        :paramtype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
        :keyword export_route_policy: Export Route Policy either IPv4 or IPv6.
        :paramtype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
        :keyword ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
        :paramtype ingress_acl_id: str
        :keyword egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
        :paramtype egress_acl_id: str
        :keyword is_monitoring_enabled: To check whether monitoring of internal network is enabled or
         not. Known values are: "True" and "False".
        :paramtype is_monitoring_enabled: str or
         ~azure.mgmt.managednetworkfabric.models.IsMonitoringEnabled
        """
        super().__init__(**kwargs)
        self.mtu = mtu
        self.connected_i_pv4_subnets = connected_i_pv4_subnets
        self.connected_i_pv6_subnets = connected_i_pv6_subnets
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy
        self.ingress_acl_id = ingress_acl_id
        self.egress_acl_id = egress_acl_id
        self.is_monitoring_enabled = is_monitoring_enabled


class InternalNetworkPatchProperties(
    AnnotationResource, InternalNetworkPatchableProperties
):  # pylint: disable=too-many-instance-attributes
    """InternalNetwork Patch properties.

    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar connected_i_pv4_subnets: List of Connected IPv4 Subnets.
    :vartype connected_i_pv4_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar connected_i_pv6_subnets: List of connected IPv6 Subnets.
    :vartype connected_i_pv6_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype export_route_policy_id: str
    :ivar import_route_policy: Import Route Policy either IPv4 or IPv6.
    :vartype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
    :ivar export_route_policy: Export Route Policy either IPv4 or IPv6.
    :vartype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
    :ivar ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
    :vartype ingress_acl_id: str
    :ivar egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
    :vartype egress_acl_id: str
    :ivar is_monitoring_enabled: To check whether monitoring of internal network is enabled or not.
     Known values are: "True" and "False".
    :vartype is_monitoring_enabled: str or
     ~azure.mgmt.managednetworkfabric.models.IsMonitoringEnabled
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar bgp_configuration: BGP configuration properties.
    :vartype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
    :ivar static_route_configuration: Static Route Configuration properties.
    :vartype static_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
        "connected_i_pv4_subnets": {"min_items": 1},
        "connected_i_pv6_subnets": {"min_items": 1},
    }

    _attribute_map = {
        "mtu": {"key": "mtu", "type": "int"},
        "connected_i_pv4_subnets": {"key": "connectedIPv4Subnets", "type": "[ConnectedSubnet]"},
        "connected_i_pv6_subnets": {"key": "connectedIPv6Subnets", "type": "[ConnectedSubnet]"},
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "import_route_policy": {"key": "importRoutePolicy", "type": "ImportRoutePolicy"},
        "export_route_policy": {"key": "exportRoutePolicy", "type": "ExportRoutePolicy"},
        "ingress_acl_id": {"key": "ingressAclId", "type": "str"},
        "egress_acl_id": {"key": "egressAclId", "type": "str"},
        "is_monitoring_enabled": {"key": "isMonitoringEnabled", "type": "str"},
        "annotation": {"key": "annotation", "type": "str"},
        "bgp_configuration": {"key": "bgpConfiguration", "type": "BgpConfiguration"},
        "static_route_configuration": {"key": "staticRouteConfiguration", "type": "StaticRouteConfiguration"},
    }

    def __init__(
        self,
        *,
        mtu: int = 1500,
        connected_i_pv4_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        connected_i_pv6_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        import_route_policy: Optional["_models.ImportRoutePolicy"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicy"] = None,
        ingress_acl_id: Optional[str] = None,
        egress_acl_id: Optional[str] = None,
        is_monitoring_enabled: Union[str, "_models.IsMonitoringEnabled"] = "False",
        annotation: Optional[str] = None,
        bgp_configuration: Optional["_models.BgpConfiguration"] = None,
        static_route_configuration: Optional["_models.StaticRouteConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        :keyword connected_i_pv4_subnets: List of Connected IPv4 Subnets.
        :paramtype connected_i_pv4_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword connected_i_pv6_subnets: List of connected IPv6 Subnets.
        :paramtype connected_i_pv6_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype export_route_policy_id: str
        :keyword import_route_policy: Import Route Policy either IPv4 or IPv6.
        :paramtype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
        :keyword export_route_policy: Export Route Policy either IPv4 or IPv6.
        :paramtype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
        :keyword ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
        :paramtype ingress_acl_id: str
        :keyword egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
        :paramtype egress_acl_id: str
        :keyword is_monitoring_enabled: To check whether monitoring of internal network is enabled or
         not. Known values are: "True" and "False".
        :paramtype is_monitoring_enabled: str or
         ~azure.mgmt.managednetworkfabric.models.IsMonitoringEnabled
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword bgp_configuration: BGP configuration properties.
        :paramtype bgp_configuration: ~azure.mgmt.managednetworkfabric.models.BgpConfiguration
        :keyword static_route_configuration: Static Route Configuration properties.
        :paramtype static_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.StaticRouteConfiguration
        """
        super().__init__(
            annotation=annotation,
            mtu=mtu,
            connected_i_pv4_subnets=connected_i_pv4_subnets,
            connected_i_pv6_subnets=connected_i_pv6_subnets,
            import_route_policy_id=import_route_policy_id,
            export_route_policy_id=export_route_policy_id,
            import_route_policy=import_route_policy,
            export_route_policy=export_route_policy,
            ingress_acl_id=ingress_acl_id,
            egress_acl_id=egress_acl_id,
            is_monitoring_enabled=is_monitoring_enabled,
            **kwargs
        )
        self.mtu = mtu
        self.connected_i_pv4_subnets = connected_i_pv4_subnets
        self.connected_i_pv6_subnets = connected_i_pv6_subnets
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy
        self.ingress_acl_id = ingress_acl_id
        self.egress_acl_id = egress_acl_id
        self.is_monitoring_enabled = is_monitoring_enabled
        self.bgp_configuration = bgp_configuration
        self.static_route_configuration = static_route_configuration
        self.annotation = annotation


class InternalNetworkProperties(
    AnnotationResource, InternalNetworkPatchableProperties, ExtensionEnumProperty
):  # pylint: disable=too-many-instance-attributes
    """Internal Network Properties defines the properties of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar extension: Extension. Example: NoExtension | NPB. Known values are: "NoExtension" and
     "NPB".
    :vartype extension: str or ~azure.mgmt.managednetworkfabric.models.Extension
    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar connected_i_pv4_subnets: List of Connected IPv4 Subnets.
    :vartype connected_i_pv4_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar connected_i_pv6_subnets: List of connected IPv6 Subnets.
    :vartype connected_i_pv6_subnets: list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
    :ivar import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype import_route_policy_id: str
    :ivar export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the backward
     compatibility.
    :vartype export_route_policy_id: str
    :ivar import_route_policy: Import Route Policy either IPv4 or IPv6.
    :vartype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
    :ivar export_route_policy: Export Route Policy either IPv4 or IPv6.
    :vartype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
    :ivar ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
    :vartype ingress_acl_id: str
    :ivar egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
    :vartype egress_acl_id: str
    :ivar is_monitoring_enabled: To check whether monitoring of internal network is enabled or not.
     Known values are: "True" and "False".
    :vartype is_monitoring_enabled: str or
     ~azure.mgmt.managednetworkfabric.models.IsMonitoringEnabled
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar vlan_id: Vlan identifier. Example: 1001. Required.
    :vartype vlan_id: int
    :ivar bgp_configuration: BGP configuration properties.
    :vartype bgp_configuration:
     ~azure.mgmt.managednetworkfabric.models.InternalNetworkPropertiesBgpConfiguration
    :ivar static_route_configuration: Static Route Configuration properties.
    :vartype static_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.InternalNetworkPropertiesStaticRouteConfiguration
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
        "connected_i_pv4_subnets": {"min_items": 1},
        "connected_i_pv6_subnets": {"min_items": 1},
        "vlan_id": {"required": True, "maximum": 4094, "minimum": 100},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "extension": {"key": "extension", "type": "str"},
        "mtu": {"key": "mtu", "type": "int"},
        "connected_i_pv4_subnets": {"key": "connectedIPv4Subnets", "type": "[ConnectedSubnet]"},
        "connected_i_pv6_subnets": {"key": "connectedIPv6Subnets", "type": "[ConnectedSubnet]"},
        "import_route_policy_id": {"key": "importRoutePolicyId", "type": "str"},
        "export_route_policy_id": {"key": "exportRoutePolicyId", "type": "str"},
        "import_route_policy": {"key": "importRoutePolicy", "type": "ImportRoutePolicy"},
        "export_route_policy": {"key": "exportRoutePolicy", "type": "ExportRoutePolicy"},
        "ingress_acl_id": {"key": "ingressAclId", "type": "str"},
        "egress_acl_id": {"key": "egressAclId", "type": "str"},
        "is_monitoring_enabled": {"key": "isMonitoringEnabled", "type": "str"},
        "annotation": {"key": "annotation", "type": "str"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "bgp_configuration": {"key": "bgpConfiguration", "type": "InternalNetworkPropertiesBgpConfiguration"},
        "static_route_configuration": {
            "key": "staticRouteConfiguration",
            "type": "InternalNetworkPropertiesStaticRouteConfiguration",
        },
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        vlan_id: int,
        extension: Union[str, "_models.Extension"] = "NoExtension",
        mtu: int = 1500,
        connected_i_pv4_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        connected_i_pv6_subnets: Optional[List["_models.ConnectedSubnet"]] = None,
        import_route_policy_id: Optional[str] = None,
        export_route_policy_id: Optional[str] = None,
        import_route_policy: Optional["_models.ImportRoutePolicy"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicy"] = None,
        ingress_acl_id: Optional[str] = None,
        egress_acl_id: Optional[str] = None,
        is_monitoring_enabled: Union[str, "_models.IsMonitoringEnabled"] = "False",
        annotation: Optional[str] = None,
        bgp_configuration: Optional["_models.InternalNetworkPropertiesBgpConfiguration"] = None,
        static_route_configuration: Optional["_models.InternalNetworkPropertiesStaticRouteConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extension: Extension. Example: NoExtension | NPB. Known values are: "NoExtension" and
         "NPB".
        :paramtype extension: str or ~azure.mgmt.managednetworkfabric.models.Extension
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        :keyword connected_i_pv4_subnets: List of Connected IPv4 Subnets.
        :paramtype connected_i_pv4_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword connected_i_pv6_subnets: List of connected IPv6 Subnets.
        :paramtype connected_i_pv6_subnets:
         list[~azure.mgmt.managednetworkfabric.models.ConnectedSubnet]
        :keyword import_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype import_route_policy_id: str
        :keyword export_route_policy_id: ARM Resource ID of the RoutePolicy. This is used for the
         backward compatibility.
        :paramtype export_route_policy_id: str
        :keyword import_route_policy: Import Route Policy either IPv4 or IPv6.
        :paramtype import_route_policy: ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicy
        :keyword export_route_policy: Export Route Policy either IPv4 or IPv6.
        :paramtype export_route_policy: ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicy
        :keyword ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
        :paramtype ingress_acl_id: str
        :keyword egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
        :paramtype egress_acl_id: str
        :keyword is_monitoring_enabled: To check whether monitoring of internal network is enabled or
         not. Known values are: "True" and "False".
        :paramtype is_monitoring_enabled: str or
         ~azure.mgmt.managednetworkfabric.models.IsMonitoringEnabled
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword vlan_id: Vlan identifier. Example: 1001. Required.
        :paramtype vlan_id: int
        :keyword bgp_configuration: BGP configuration properties.
        :paramtype bgp_configuration:
         ~azure.mgmt.managednetworkfabric.models.InternalNetworkPropertiesBgpConfiguration
        :keyword static_route_configuration: Static Route Configuration properties.
        :paramtype static_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.InternalNetworkPropertiesStaticRouteConfiguration
        """
        super().__init__(
            annotation=annotation,
            mtu=mtu,
            connected_i_pv4_subnets=connected_i_pv4_subnets,
            connected_i_pv6_subnets=connected_i_pv6_subnets,
            import_route_policy_id=import_route_policy_id,
            export_route_policy_id=export_route_policy_id,
            import_route_policy=import_route_policy,
            export_route_policy=export_route_policy,
            ingress_acl_id=ingress_acl_id,
            egress_acl_id=egress_acl_id,
            is_monitoring_enabled=is_monitoring_enabled,
            extension=extension,
            **kwargs
        )
        self.extension = extension
        self.mtu = mtu
        self.connected_i_pv4_subnets = connected_i_pv4_subnets
        self.connected_i_pv6_subnets = connected_i_pv6_subnets
        self.import_route_policy_id = import_route_policy_id
        self.export_route_policy_id = export_route_policy_id
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy
        self.ingress_acl_id = ingress_acl_id
        self.egress_acl_id = egress_acl_id
        self.is_monitoring_enabled = is_monitoring_enabled
        self.vlan_id = vlan_id
        self.bgp_configuration = bgp_configuration
        self.static_route_configuration = static_route_configuration
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None
        self.annotation = annotation


class InternalNetworkPropertiesBgpConfiguration(BgpConfiguration):  # pylint: disable=too-many-instance-attributes
    """BGP configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar bfd_configuration: BFD configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    :ivar default_route_originate: Originate a defaultRoute. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype default_route_originate: str or
     ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
    :ivar allow_as: Allows for routes to be received and processed even if the router detects its
     own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
    :vartype allow_as: int
    :ivar allow_as_override: Enable Or Disable state. Known values are: "Enable" and "Disable".
    :vartype allow_as_override: str or ~azure.mgmt.managednetworkfabric.models.AllowASOverride
    :ivar fabric_asn: ASN of Network Fabric. Example: 65048.
    :vartype fabric_asn: int
    :ivar peer_asn: Peer ASN. Example: 65047.
    :vartype peer_asn: int
    :ivar ipv4_listen_range_prefixes: List of BGP IPv4 Listen Range prefixes.
    :vartype ipv4_listen_range_prefixes: list[str]
    :ivar ipv6_listen_range_prefixes: List of BGP IPv6 Listen Ranges prefixes.
    :vartype ipv6_listen_range_prefixes: list[str]
    :ivar ipv4_neighbor_address: List with stringified IPv4 Neighbor Addresses.
    :vartype ipv4_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
    :ivar ipv6_neighbor_address: List with stringified IPv6 Neighbor Address.
    :vartype ipv6_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
    """

    _validation = {
        "allow_as": {"maximum": 10, "minimum": 0},
        "fabric_asn": {"readonly": True},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
        "ipv4_listen_range_prefixes": {"min_items": 1},
        "ipv6_listen_range_prefixes": {"min_items": 1},
        "ipv4_neighbor_address": {"min_items": 1},
        "ipv6_neighbor_address": {"min_items": 1},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
        "default_route_originate": {"key": "defaultRouteOriginate", "type": "str"},
        "allow_as": {"key": "allowAS", "type": "int"},
        "allow_as_override": {"key": "allowASOverride", "type": "str"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "ipv4_listen_range_prefixes": {"key": "ipv4ListenRangePrefixes", "type": "[str]"},
        "ipv6_listen_range_prefixes": {"key": "ipv6ListenRangePrefixes", "type": "[str]"},
        "ipv4_neighbor_address": {"key": "ipv4NeighborAddress", "type": "[NeighborAddress]"},
        "ipv6_neighbor_address": {"key": "ipv6NeighborAddress", "type": "[NeighborAddress]"},
    }

    def __init__(
        self,
        *,
        annotation: Optional[str] = None,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        default_route_originate: Optional[Union[str, "_models.BooleanEnumProperty"]] = None,
        allow_as: int = 2,
        allow_as_override: Optional[Union[str, "_models.AllowASOverride"]] = None,
        peer_asn: Optional[int] = None,
        ipv4_listen_range_prefixes: Optional[List[str]] = None,
        ipv6_listen_range_prefixes: Optional[List[str]] = None,
        ipv4_neighbor_address: Optional[List["_models.NeighborAddress"]] = None,
        ipv6_neighbor_address: Optional[List["_models.NeighborAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword bfd_configuration: BFD configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        :keyword default_route_originate: Originate a defaultRoute. Ex: "True" | "False". Known values
         are: "True" and "False".
        :paramtype default_route_originate: str or
         ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
        :keyword allow_as: Allows for routes to be received and processed even if the router detects
         its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
        :paramtype allow_as: int
        :keyword allow_as_override: Enable Or Disable state. Known values are: "Enable" and "Disable".
        :paramtype allow_as_override: str or ~azure.mgmt.managednetworkfabric.models.AllowASOverride
        :keyword peer_asn: Peer ASN. Example: 65047.
        :paramtype peer_asn: int
        :keyword ipv4_listen_range_prefixes: List of BGP IPv4 Listen Range prefixes.
        :paramtype ipv4_listen_range_prefixes: list[str]
        :keyword ipv6_listen_range_prefixes: List of BGP IPv6 Listen Ranges prefixes.
        :paramtype ipv6_listen_range_prefixes: list[str]
        :keyword ipv4_neighbor_address: List with stringified IPv4 Neighbor Addresses.
        :paramtype ipv4_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
        :keyword ipv6_neighbor_address: List with stringified IPv6 Neighbor Address.
        :paramtype ipv6_neighbor_address: list[~azure.mgmt.managednetworkfabric.models.NeighborAddress]
        """
        super().__init__(
            annotation=annotation,
            bfd_configuration=bfd_configuration,
            default_route_originate=default_route_originate,
            allow_as=allow_as,
            allow_as_override=allow_as_override,
            peer_asn=peer_asn,
            ipv4_listen_range_prefixes=ipv4_listen_range_prefixes,
            ipv6_listen_range_prefixes=ipv6_listen_range_prefixes,
            ipv4_neighbor_address=ipv4_neighbor_address,
            ipv6_neighbor_address=ipv6_neighbor_address,
            **kwargs
        )


class StaticRouteConfiguration(_serialization.Model):
    """Static Route Configuration properties.

    :ivar bfd_configuration: BFD configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    :ivar ipv4_routes: List of IPv4 Routes.
    :vartype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
    :ivar ipv6_routes: List of IPv6 Routes.
    :vartype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
    """

    _validation = {
        "ipv4_routes": {"min_items": 1},
        "ipv6_routes": {"min_items": 1},
    }

    _attribute_map = {
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
        "ipv4_routes": {"key": "ipv4Routes", "type": "[StaticRouteProperties]"},
        "ipv6_routes": {"key": "ipv6Routes", "type": "[StaticRouteProperties]"},
    }

    def __init__(
        self,
        *,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        ipv4_routes: Optional[List["_models.StaticRouteProperties"]] = None,
        ipv6_routes: Optional[List["_models.StaticRouteProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bfd_configuration: BFD configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        :keyword ipv4_routes: List of IPv4 Routes.
        :paramtype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
        :keyword ipv6_routes: List of IPv6 Routes.
        :paramtype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
        """
        super().__init__(**kwargs)
        self.bfd_configuration = bfd_configuration
        self.ipv4_routes = ipv4_routes
        self.ipv6_routes = ipv6_routes


class InternalNetworkPropertiesStaticRouteConfiguration(StaticRouteConfiguration, ExtensionEnumProperty):
    """Static Route Configuration properties.

    :ivar extension: Extension. Example: NoExtension | NPB. Known values are: "NoExtension" and
     "NPB".
    :vartype extension: str or ~azure.mgmt.managednetworkfabric.models.Extension
    :ivar bfd_configuration: BFD configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    :ivar ipv4_routes: List of IPv4 Routes.
    :vartype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
    :ivar ipv6_routes: List of IPv6 Routes.
    :vartype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
    """

    _validation = {
        "ipv4_routes": {"min_items": 1},
        "ipv6_routes": {"min_items": 1},
    }

    _attribute_map = {
        "extension": {"key": "extension", "type": "str"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
        "ipv4_routes": {"key": "ipv4Routes", "type": "[StaticRouteProperties]"},
        "ipv6_routes": {"key": "ipv6Routes", "type": "[StaticRouteProperties]"},
    }

    def __init__(
        self,
        *,
        extension: Union[str, "_models.Extension"] = "NoExtension",
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        ipv4_routes: Optional[List["_models.StaticRouteProperties"]] = None,
        ipv6_routes: Optional[List["_models.StaticRouteProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extension: Extension. Example: NoExtension | NPB. Known values are: "NoExtension" and
         "NPB".
        :paramtype extension: str or ~azure.mgmt.managednetworkfabric.models.Extension
        :keyword bfd_configuration: BFD configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        :keyword ipv4_routes: List of IPv4 Routes.
        :paramtype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
        :keyword ipv6_routes: List of IPv6 Routes.
        :paramtype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
        """
        super().__init__(
            bfd_configuration=bfd_configuration,
            ipv4_routes=ipv4_routes,
            ipv6_routes=ipv6_routes,
            extension=extension,
            **kwargs
        )
        self.extension = extension
        self.bfd_configuration = bfd_configuration
        self.ipv4_routes = ipv4_routes
        self.ipv6_routes = ipv6_routes


class InternalNetworksList(_serialization.Model):
    """List of Internal Networks.

    :ivar value: List of Internal Network resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.InternalNetwork]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[InternalNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.InternalNetwork"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Internal Network resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.InternalNetwork]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class InternetGateway(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The Internet Gateway resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar internet_gateway_rule_id: ARM Resource ID of the Internet Gateway Rule.
    :vartype internet_gateway_rule_id: str
    :ivar ipv4_address: IPv4 Address of Internet Gateway.
    :vartype ipv4_address: str
    :ivar port: Port number of Internet Gateway.
    :vartype port: int
    :ivar type_properties_type: Gateway Type of the resource. Required. Known values are:
     "Infrastructure" and "Workload".
    :vartype type_properties_type: str or ~azure.mgmt.managednetworkfabric.models.GatewayType
    :ivar network_fabric_controller_id: ARM Resource ID of the Network Fabric Controller. Required.
    :vartype network_fabric_controller_id: str
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "ipv4_address": {"readonly": True},
        "port": {"readonly": True},
        "type_properties_type": {"required": True},
        "network_fabric_controller_id": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "internet_gateway_rule_id": {"key": "properties.internetGatewayRuleId", "type": "str"},
        "ipv4_address": {"key": "properties.ipv4Address", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "network_fabric_controller_id": {"key": "properties.networkFabricControllerId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        type_properties_type: Union[str, "_models.GatewayType"],
        network_fabric_controller_id: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        internet_gateway_rule_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword internet_gateway_rule_id: ARM Resource ID of the Internet Gateway Rule.
        :paramtype internet_gateway_rule_id: str
        :keyword type_properties_type: Gateway Type of the resource. Required. Known values are:
         "Infrastructure" and "Workload".
        :paramtype type_properties_type: str or ~azure.mgmt.managednetworkfabric.models.GatewayType
        :keyword network_fabric_controller_id: ARM Resource ID of the Network Fabric Controller.
         Required.
        :paramtype network_fabric_controller_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.internet_gateway_rule_id = internet_gateway_rule_id
        self.ipv4_address = None
        self.port = None
        self.type_properties_type = type_properties_type
        self.network_fabric_controller_id = network_fabric_controller_id
        self.provisioning_state = None


class InternetGatewayPatch(TagsUpdate):
    """The Internet Gateway patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar internet_gateway_rule_id: ARM Resource ID of the Internet Gateway Rule.
    :vartype internet_gateway_rule_id: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "internet_gateway_rule_id": {"key": "properties.internetGatewayRuleId", "type": "str"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, internet_gateway_rule_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword internet_gateway_rule_id: ARM Resource ID of the Internet Gateway Rule.
        :paramtype internet_gateway_rule_id: str
        """
        super().__init__(tags=tags, **kwargs)
        self.internet_gateway_rule_id = internet_gateway_rule_id


class InternetGatewayPatchableProperties(_serialization.Model):
    """Internet Gateway Patchable Properties defines the patchable properties of the resource.

    :ivar internet_gateway_rule_id: ARM Resource ID of the Internet Gateway Rule.
    :vartype internet_gateway_rule_id: str
    """

    _attribute_map = {
        "internet_gateway_rule_id": {"key": "internetGatewayRuleId", "type": "str"},
    }

    def __init__(self, *, internet_gateway_rule_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword internet_gateway_rule_id: ARM Resource ID of the Internet Gateway Rule.
        :paramtype internet_gateway_rule_id: str
        """
        super().__init__(**kwargs)
        self.internet_gateway_rule_id = internet_gateway_rule_id


class InternetGatewayProperties(AnnotationResource, InternetGatewayPatchableProperties):
    """Internet Gateway Properties defines the properties of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar internet_gateway_rule_id: ARM Resource ID of the Internet Gateway Rule.
    :vartype internet_gateway_rule_id: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar ipv4_address: IPv4 Address of Internet Gateway.
    :vartype ipv4_address: str
    :ivar port: Port number of Internet Gateway.
    :vartype port: int
    :ivar type: Gateway Type of the resource. Required. Known values are: "Infrastructure" and
     "Workload".
    :vartype type: str or ~azure.mgmt.managednetworkfabric.models.GatewayType
    :ivar network_fabric_controller_id: ARM Resource ID of the Network Fabric Controller. Required.
    :vartype network_fabric_controller_id: str
    :ivar provisioning_state: Provisioning state of resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "ipv4_address": {"readonly": True},
        "port": {"readonly": True},
        "type": {"required": True},
        "network_fabric_controller_id": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "internet_gateway_rule_id": {"key": "internetGatewayRuleId", "type": "str"},
        "annotation": {"key": "annotation", "type": "str"},
        "ipv4_address": {"key": "ipv4Address", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "network_fabric_controller_id": {"key": "networkFabricControllerId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.GatewayType"],
        network_fabric_controller_id: str,
        internet_gateway_rule_id: Optional[str] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword internet_gateway_rule_id: ARM Resource ID of the Internet Gateway Rule.
        :paramtype internet_gateway_rule_id: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword type: Gateway Type of the resource. Required. Known values are: "Infrastructure" and
         "Workload".
        :paramtype type: str or ~azure.mgmt.managednetworkfabric.models.GatewayType
        :keyword network_fabric_controller_id: ARM Resource ID of the Network Fabric Controller.
         Required.
        :paramtype network_fabric_controller_id: str
        """
        super().__init__(annotation=annotation, internet_gateway_rule_id=internet_gateway_rule_id, **kwargs)
        self.internet_gateway_rule_id = internet_gateway_rule_id
        self.ipv4_address = None
        self.port = None
        self.type = type
        self.network_fabric_controller_id = network_fabric_controller_id
        self.provisioning_state = None
        self.annotation = annotation


class InternetGatewayRule(TrackedResource):
    """The Internet Gateway Rule resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar rule_properties: Rules for the InternetGateways. Required.
    :vartype rule_properties: ~azure.mgmt.managednetworkfabric.models.RuleProperties
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar internet_gateway_ids: List of Internet Gateway resource Id.
    :vartype internet_gateway_ids: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "rule_properties": {"required": True},
        "provisioning_state": {"readonly": True},
        "internet_gateway_ids": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "rule_properties": {"key": "properties.ruleProperties", "type": "RuleProperties"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "internet_gateway_ids": {"key": "properties.internetGatewayIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: str,
        rule_properties: "_models.RuleProperties",
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword rule_properties: Rules for the InternetGateways. Required.
        :paramtype rule_properties: ~azure.mgmt.managednetworkfabric.models.RuleProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.rule_properties = rule_properties
        self.provisioning_state = None
        self.internet_gateway_ids = None


class InternetGatewayRulePatch(TagsUpdate):
    """The Internet Gateway Rules patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(tags=tags, **kwargs)


class InternetGatewayRuleProperties(AnnotationResource):
    """Internet Gateway Rule Properties defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar rule_properties: Rules for the InternetGateways. Required.
    :vartype rule_properties: ~azure.mgmt.managednetworkfabric.models.RuleProperties
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar internet_gateway_ids: List of Internet Gateway resource Id.
    :vartype internet_gateway_ids: list[str]
    """

    _validation = {
        "rule_properties": {"required": True},
        "provisioning_state": {"readonly": True},
        "internet_gateway_ids": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "rule_properties": {"key": "ruleProperties", "type": "RuleProperties"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "internet_gateway_ids": {"key": "internetGatewayIds", "type": "[str]"},
    }

    def __init__(
        self, *, rule_properties: "_models.RuleProperties", annotation: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword rule_properties: Rules for the InternetGateways. Required.
        :paramtype rule_properties: ~azure.mgmt.managednetworkfabric.models.RuleProperties
        """
        super().__init__(annotation=annotation, **kwargs)
        self.rule_properties = rule_properties
        self.provisioning_state = None
        self.internet_gateway_ids = None


class InternetGatewayRulesListResult(_serialization.Model):
    """List of Internet Gateway Rules.

    :ivar value: List of Internet Gateway Rule resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.InternetGatewayRule]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[InternetGatewayRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.InternetGatewayRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Internet Gateway Rule resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.InternetGatewayRule]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class InternetGatewaysListResult(_serialization.Model):
    """List of InternetGateways.

    :ivar value: Displays list of Internet Gateway resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.InternetGateway]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[InternetGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.InternetGateway"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Displays list of Internet Gateway resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.InternetGateway]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpCommunitiesListResult(_serialization.Model):
    """List of IP Communities.

    :ivar value: List of IP Community resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.IpCommunity]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[IpCommunity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.IpCommunity"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of IP Community resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.IpCommunity]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpCommunity(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The IP Community resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar ip_community_rules: List of IP Community Rules.
    :vartype ip_community_rules: list[~azure.mgmt.managednetworkfabric.models.IpCommunityRule]
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "ip_community_rules": {"key": "properties.ipCommunityRules", "type": "[IpCommunityRule]"},
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        ip_community_rules: Optional[List["_models.IpCommunityRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword ip_community_rules: List of IP Community Rules.
        :paramtype ip_community_rules: list[~azure.mgmt.managednetworkfabric.models.IpCommunityRule]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.ip_community_rules = ip_community_rules
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class IpCommunityIdList(_serialization.Model):
    """IP Community ID list properties.

    :ivar ip_community_ids: List of IP Community resource IDs.
    :vartype ip_community_ids: list[str]
    """

    _attribute_map = {
        "ip_community_ids": {"key": "ipCommunityIds", "type": "[str]"},
    }

    def __init__(self, *, ip_community_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword ip_community_ids: List of IP Community resource IDs.
        :paramtype ip_community_ids: list[str]
        """
        super().__init__(**kwargs)
        self.ip_community_ids = ip_community_ids


class IpCommunityPatch(TagsUpdate):
    """The IP Community patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar ip_community_rules: List of IP Community Rules.
    :vartype ip_community_rules: list[~azure.mgmt.managednetworkfabric.models.IpCommunityRule]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "ip_community_rules": {"key": "properties.ipCommunityRules", "type": "[IpCommunityRule]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        ip_community_rules: Optional[List["_models.IpCommunityRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword ip_community_rules: List of IP Community Rules.
        :paramtype ip_community_rules: list[~azure.mgmt.managednetworkfabric.models.IpCommunityRule]
        """
        super().__init__(tags=tags, **kwargs)
        self.ip_community_rules = ip_community_rules


class IpCommunityPatchableProperties(_serialization.Model):
    """IP Community patchable properties.

    :ivar ip_community_rules: List of IP Community Rules.
    :vartype ip_community_rules: list[~azure.mgmt.managednetworkfabric.models.IpCommunityRule]
    """

    _attribute_map = {
        "ip_community_rules": {"key": "ipCommunityRules", "type": "[IpCommunityRule]"},
    }

    def __init__(self, *, ip_community_rules: Optional[List["_models.IpCommunityRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword ip_community_rules: List of IP Community Rules.
        :paramtype ip_community_rules: list[~azure.mgmt.managednetworkfabric.models.IpCommunityRule]
        """
        super().__init__(**kwargs)
        self.ip_community_rules = ip_community_rules


class IpCommunityProperties(AnnotationResource, IpCommunityPatchableProperties):
    """IP Community Properties defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ip_community_rules: List of IP Community Rules.
    :vartype ip_community_rules: list[~azure.mgmt.managednetworkfabric.models.IpCommunityRule]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "ip_community_rules": {"key": "ipCommunityRules", "type": "[IpCommunityRule]"},
        "annotation": {"key": "annotation", "type": "str"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_community_rules: Optional[List["_models.IpCommunityRule"]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_community_rules: List of IP Community Rules.
        :paramtype ip_community_rules: list[~azure.mgmt.managednetworkfabric.models.IpCommunityRule]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, ip_community_rules=ip_community_rules, **kwargs)
        self.ip_community_rules = ip_community_rules
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None
        self.annotation = annotation


class IpCommunityRule(_serialization.Model):
    """IP Community patchable properties.

    All required parameters must be populated in order to send to Azure.

    :ivar action: Action to be taken on the configuration. Example: Permit | Deny. Required. Known
     values are: "Permit" and "Deny".
    :vartype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
    :ivar sequence_number: Sequence to insert to/delete from existing route. Prefix lists are
     evaluated starting with the lowest sequence number and continue down the list until a match is
     made. Once a match is made, the permit or deny statement is applied to that network and the
     rest of the list is ignored. Required.
    :vartype sequence_number: int
    :ivar well_known_communities: Supported well known Community List.
    :vartype well_known_communities: list[str or
     ~azure.mgmt.managednetworkfabric.models.WellKnownCommunities]
    :ivar community_members: List the community members of IP Community. Required.
    :vartype community_members: list[str]
    """

    _validation = {
        "action": {"required": True},
        "sequence_number": {"required": True, "maximum": 4294967295, "minimum": 1},
        "well_known_communities": {"unique": True},
        "community_members": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "sequence_number": {"key": "sequenceNumber", "type": "int"},
        "well_known_communities": {"key": "wellKnownCommunities", "type": "[str]"},
        "community_members": {"key": "communityMembers", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        action: Union[str, "_models.CommunityActionTypes"],
        sequence_number: int,
        community_members: List[str],
        well_known_communities: Optional[List[Union[str, "_models.WellKnownCommunities"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action: Action to be taken on the configuration. Example: Permit | Deny. Required.
         Known values are: "Permit" and "Deny".
        :paramtype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
        :keyword sequence_number: Sequence to insert to/delete from existing route. Prefix lists are
         evaluated starting with the lowest sequence number and continue down the list until a match is
         made. Once a match is made, the permit or deny statement is applied to that network and the
         rest of the list is ignored. Required.
        :paramtype sequence_number: int
        :keyword well_known_communities: Supported well known Community List.
        :paramtype well_known_communities: list[str or
         ~azure.mgmt.managednetworkfabric.models.WellKnownCommunities]
        :keyword community_members: List the community members of IP Community. Required.
        :paramtype community_members: list[str]
        """
        super().__init__(**kwargs)
        self.action = action
        self.sequence_number = sequence_number
        self.well_known_communities = well_known_communities
        self.community_members = community_members


class IpExtendedCommunity(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The IP Extended Community resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar ip_extended_community_rules: List of IP Extended Community Rules. Required.
    :vartype ip_extended_community_rules:
     list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityRule]
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "ip_extended_community_rules": {"required": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "ip_extended_community_rules": {
            "key": "properties.ipExtendedCommunityRules",
            "type": "[IpExtendedCommunityRule]",
        },
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        ip_extended_community_rules: List["_models.IpExtendedCommunityRule"],
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword ip_extended_community_rules: List of IP Extended Community Rules. Required.
        :paramtype ip_extended_community_rules:
         list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityRule]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.ip_extended_community_rules = ip_extended_community_rules
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class IpExtendedCommunityIdList(_serialization.Model):
    """IP Extended Community Id list properties.

    :ivar ip_extended_community_ids: List of IP Extended Community resource IDs.
    :vartype ip_extended_community_ids: list[str]
    """

    _attribute_map = {
        "ip_extended_community_ids": {"key": "ipExtendedCommunityIds", "type": "[str]"},
    }

    def __init__(self, *, ip_extended_community_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword ip_extended_community_ids: List of IP Extended Community resource IDs.
        :paramtype ip_extended_community_ids: list[str]
        """
        super().__init__(**kwargs)
        self.ip_extended_community_ids = ip_extended_community_ids


class IpExtendedCommunityListResult(_serialization.Model):
    """List of IP Extended Communities.

    :ivar value: List of IP Extended Communities resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunity]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[IpExtendedCommunity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.IpExtendedCommunity"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of IP Extended Communities resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunity]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpExtendedCommunityPatch(TagsUpdate):
    """The IP Extended Communities patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar ip_extended_community_rules: List of IP Extended Community Rules.
    :vartype ip_extended_community_rules:
     list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityRule]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "ip_extended_community_rules": {
            "key": "properties.ipExtendedCommunityRules",
            "type": "[IpExtendedCommunityRule]",
        },
        "annotation": {"key": "properties.annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        ip_extended_community_rules: Optional[List["_models.IpExtendedCommunityRule"]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword ip_extended_community_rules: List of IP Extended Community Rules.
        :paramtype ip_extended_community_rules:
         list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityRule]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(tags=tags, **kwargs)
        self.ip_extended_community_rules = ip_extended_community_rules
        self.annotation = annotation


class IpExtendedCommunityPatchableProperties(_serialization.Model):
    """IP Extended Community patchable properties.

    All required parameters must be populated in order to send to Azure.

    :ivar ip_extended_community_rules: List of IP Extended Community Rules. Required.
    :vartype ip_extended_community_rules:
     list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityRule]
    """

    _validation = {
        "ip_extended_community_rules": {"required": True},
    }

    _attribute_map = {
        "ip_extended_community_rules": {"key": "ipExtendedCommunityRules", "type": "[IpExtendedCommunityRule]"},
    }

    def __init__(self, *, ip_extended_community_rules: List["_models.IpExtendedCommunityRule"], **kwargs: Any) -> None:
        """
        :keyword ip_extended_community_rules: List of IP Extended Community Rules. Required.
        :paramtype ip_extended_community_rules:
         list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityRule]
        """
        super().__init__(**kwargs)
        self.ip_extended_community_rules = ip_extended_community_rules


class IpExtendedCommunityPatchProperties(IpExtendedCommunityPatchableProperties, AnnotationResource):
    """IP Extended Community patchable properties.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar ip_extended_community_rules: List of IP Extended Community Rules. Required.
    :vartype ip_extended_community_rules:
     list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityRule]
    """

    _validation = {
        "ip_extended_community_rules": {"required": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "ip_extended_community_rules": {"key": "ipExtendedCommunityRules", "type": "[IpExtendedCommunityRule]"},
    }

    def __init__(
        self,
        *,
        ip_extended_community_rules: List["_models.IpExtendedCommunityRule"],
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword ip_extended_community_rules: List of IP Extended Community Rules. Required.
        :paramtype ip_extended_community_rules:
         list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityRule]
        """
        super().__init__(ip_extended_community_rules=ip_extended_community_rules, annotation=annotation, **kwargs)
        self.annotation = annotation
        self.ip_extended_community_rules = ip_extended_community_rules


class IpExtendedCommunityProperties(AnnotationResource, IpExtendedCommunityPatchableProperties):
    """IP Extended Community Properties defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar ip_extended_community_rules: List of IP Extended Community Rules. Required.
    :vartype ip_extended_community_rules:
     list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityRule]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "ip_extended_community_rules": {"required": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "ip_extended_community_rules": {"key": "ipExtendedCommunityRules", "type": "[IpExtendedCommunityRule]"},
        "annotation": {"key": "annotation", "type": "str"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_extended_community_rules: List["_models.IpExtendedCommunityRule"],
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_extended_community_rules: List of IP Extended Community Rules. Required.
        :paramtype ip_extended_community_rules:
         list[~azure.mgmt.managednetworkfabric.models.IpExtendedCommunityRule]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, ip_extended_community_rules=ip_extended_community_rules, **kwargs)
        self.ip_extended_community_rules = ip_extended_community_rules
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None
        self.annotation = annotation


class IpExtendedCommunityRule(_serialization.Model):
    """List of IP Extended Community Rules.

    All required parameters must be populated in order to send to Azure.

    :ivar action: Action to be taken on the configuration. Example: Permit | Deny. Required. Known
     values are: "Permit" and "Deny".
    :vartype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
    :ivar sequence_number: Sequence to insert to/delete from existing route. Prefix lists are
     evaluated starting with the lowest sequence number and continue down the list until a match is
     made. Once a match is made, the permit or deny statement is applied to that network and the
     rest of the list is ignored. Required.
    :vartype sequence_number: int
    :ivar route_targets: Route Target List.The expected formats are ASN(plain):NN >> example
     4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example
     10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in
     range of 0-4294967295. Required.
    :vartype route_targets: list[str]
    """

    _validation = {
        "action": {"required": True},
        "sequence_number": {"required": True, "maximum": 4294967295, "minimum": 1},
        "route_targets": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "sequence_number": {"key": "sequenceNumber", "type": "int"},
        "route_targets": {"key": "routeTargets", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        action: Union[str, "_models.CommunityActionTypes"],
        sequence_number: int,
        route_targets: List[str],
        **kwargs: Any
    ) -> None:
        """
        :keyword action: Action to be taken on the configuration. Example: Permit | Deny. Required.
         Known values are: "Permit" and "Deny".
        :paramtype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
        :keyword sequence_number: Sequence to insert to/delete from existing route. Prefix lists are
         evaluated starting with the lowest sequence number and continue down the list until a match is
         made. Once a match is made, the permit or deny statement is applied to that network and the
         rest of the list is ignored. Required.
        :paramtype sequence_number: int
        :keyword route_targets: Route Target List.The expected formats are ASN(plain):NN >> example
         4294967294:50, ASN.ASN:NN >> example 65533.65333:40, IP-address:NN >> example
         10.10.10.10:65535. The possible values of ASN,NN are in range of 0-65535, ASN(plain) is in
         range of 0-4294967295. Required.
        :paramtype route_targets: list[str]
        """
        super().__init__(**kwargs)
        self.action = action
        self.sequence_number = sequence_number
        self.route_targets = route_targets


class IpGroupProperties(_serialization.Model):
    """IP Group properties.

    :ivar name: IP Group name.
    :vartype name: str
    :ivar ip_address_type: IP Address type. Known values are: "IPv4" and "IPv6".
    :vartype ip_address_type: str or ~azure.mgmt.managednetworkfabric.models.IPAddressType
    :ivar ip_prefixes: List of IP Prefixes.
    :vartype ip_prefixes: list[str]
    """

    _validation = {
        "name": {"min_length": 1},
        "ip_prefixes": {"min_items": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "ip_address_type": {"key": "ipAddressType", "type": "str"},
        "ip_prefixes": {"key": "ipPrefixes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ip_address_type: Optional[Union[str, "_models.IPAddressType"]] = None,
        ip_prefixes: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: IP Group name.
        :paramtype name: str
        :keyword ip_address_type: IP Address type. Known values are: "IPv4" and "IPv6".
        :paramtype ip_address_type: str or ~azure.mgmt.managednetworkfabric.models.IPAddressType
        :keyword ip_prefixes: List of IP Prefixes.
        :paramtype ip_prefixes: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.ip_address_type = ip_address_type
        self.ip_prefixes = ip_prefixes


class IpMatchCondition(_serialization.Model):
    """Defines the condition that can be filtered using the selected IPs.

    :ivar type: IP Address type. Known values are: "SourceIP" and "DestinationIP".
    :vartype type: str or ~azure.mgmt.managednetworkfabric.models.SourceDestinationType
    :ivar prefix_type: IP Prefix Type. Known values are: "Prefix" and "LongestPrefix".
    :vartype prefix_type: str or ~azure.mgmt.managednetworkfabric.models.PrefixType
    :ivar ip_prefix_values: The list of IP Prefixes.
    :vartype ip_prefix_values: list[str]
    :ivar ip_group_names: The List of IP Group Names that need to be matched.
    :vartype ip_group_names: list[str]
    """

    _validation = {
        "ip_prefix_values": {"min_items": 1},
        "ip_group_names": {"min_items": 1},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "prefix_type": {"key": "prefixType", "type": "str"},
        "ip_prefix_values": {"key": "ipPrefixValues", "type": "[str]"},
        "ip_group_names": {"key": "ipGroupNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.SourceDestinationType"]] = None,
        prefix_type: Optional[Union[str, "_models.PrefixType"]] = None,
        ip_prefix_values: Optional[List[str]] = None,
        ip_group_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: IP Address type. Known values are: "SourceIP" and "DestinationIP".
        :paramtype type: str or ~azure.mgmt.managednetworkfabric.models.SourceDestinationType
        :keyword prefix_type: IP Prefix Type. Known values are: "Prefix" and "LongestPrefix".
        :paramtype prefix_type: str or ~azure.mgmt.managednetworkfabric.models.PrefixType
        :keyword ip_prefix_values: The list of IP Prefixes.
        :paramtype ip_prefix_values: list[str]
        :keyword ip_group_names: The List of IP Group Names that need to be matched.
        :paramtype ip_group_names: list[str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.prefix_type = prefix_type
        self.ip_prefix_values = ip_prefix_values
        self.ip_group_names = ip_group_names


class IpPrefix(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The IP Prefix resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar ip_prefix_rules: The list of IP Prefix Rules.
    :vartype ip_prefix_rules: list[~azure.mgmt.managednetworkfabric.models.IpPrefixRule]
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "ip_prefix_rules": {"key": "properties.ipPrefixRules", "type": "[IpPrefixRule]"},
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        ip_prefix_rules: Optional[List["_models.IpPrefixRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword ip_prefix_rules: The list of IP Prefix Rules.
        :paramtype ip_prefix_rules: list[~azure.mgmt.managednetworkfabric.models.IpPrefixRule]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.ip_prefix_rules = ip_prefix_rules
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class IpPrefixesListResult(_serialization.Model):
    """List of IP Prefixes.

    :ivar value: List of IP Prefix resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.IpPrefix]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[IpPrefix]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.IpPrefix"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of IP Prefix resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.IpPrefix]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IpPrefixPatch(TagsUpdate):
    """The IP Prefix patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar ip_prefix_rules: The list of IP Prefix Rules.
    :vartype ip_prefix_rules: list[~azure.mgmt.managednetworkfabric.models.IpPrefixRule]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "ip_prefix_rules": {"key": "properties.ipPrefixRules", "type": "[IpPrefixRule]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        ip_prefix_rules: Optional[List["_models.IpPrefixRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword ip_prefix_rules: The list of IP Prefix Rules.
        :paramtype ip_prefix_rules: list[~azure.mgmt.managednetworkfabric.models.IpPrefixRule]
        """
        super().__init__(tags=tags, **kwargs)
        self.annotation = annotation
        self.ip_prefix_rules = ip_prefix_rules


class IpPrefixPatchableProperties(_serialization.Model):
    """IP Prefix patchable properties.

    :ivar ip_prefix_rules: The list of IP Prefix Rules.
    :vartype ip_prefix_rules: list[~azure.mgmt.managednetworkfabric.models.IpPrefixRule]
    """

    _attribute_map = {
        "ip_prefix_rules": {"key": "ipPrefixRules", "type": "[IpPrefixRule]"},
    }

    def __init__(self, *, ip_prefix_rules: Optional[List["_models.IpPrefixRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword ip_prefix_rules: The list of IP Prefix Rules.
        :paramtype ip_prefix_rules: list[~azure.mgmt.managednetworkfabric.models.IpPrefixRule]
        """
        super().__init__(**kwargs)
        self.ip_prefix_rules = ip_prefix_rules


class IpPrefixPatchProperties(AnnotationResource, IpPrefixPatchableProperties):
    """IP Prefix patchable properties.

    :ivar ip_prefix_rules: The list of IP Prefix Rules.
    :vartype ip_prefix_rules: list[~azure.mgmt.managednetworkfabric.models.IpPrefixRule]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "ip_prefix_rules": {"key": "ipPrefixRules", "type": "[IpPrefixRule]"},
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_prefix_rules: Optional[List["_models.IpPrefixRule"]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_prefix_rules: The list of IP Prefix Rules.
        :paramtype ip_prefix_rules: list[~azure.mgmt.managednetworkfabric.models.IpPrefixRule]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, ip_prefix_rules=ip_prefix_rules, **kwargs)
        self.ip_prefix_rules = ip_prefix_rules
        self.annotation = annotation


class IpPrefixProperties(AnnotationResource, IpPrefixPatchableProperties):
    """IP Prefix Properties defines the properties of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ip_prefix_rules: The list of IP Prefix Rules.
    :vartype ip_prefix_rules: list[~azure.mgmt.managednetworkfabric.models.IpPrefixRule]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "ip_prefix_rules": {"key": "ipPrefixRules", "type": "[IpPrefixRule]"},
        "annotation": {"key": "annotation", "type": "str"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_prefix_rules: Optional[List["_models.IpPrefixRule"]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_prefix_rules: The list of IP Prefix Rules.
        :paramtype ip_prefix_rules: list[~azure.mgmt.managednetworkfabric.models.IpPrefixRule]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, ip_prefix_rules=ip_prefix_rules, **kwargs)
        self.ip_prefix_rules = ip_prefix_rules
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None
        self.annotation = annotation


class IpPrefixRule(_serialization.Model):
    """IP Prefix Rule properties.

    All required parameters must be populated in order to send to Azure.

    :ivar action: Action to be taken on the configuration. Example: Permit | Deny. Required. Known
     values are: "Permit" and "Deny".
    :vartype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
    :ivar sequence_number: Sequence to insert to/delete from existing route. Prefix lists are
     evaluated starting with the lowest sequence number and continue down the list until a match is
     made. Once a match is made, the permit or deny statement is applied to that network and the
     rest of the list is ignored. Required.
    :vartype sequence_number: int
    :ivar network_prefix: Network Prefix specifying IPv4/IPv6 packets to be permitted or denied.
     Example: 1.1.1.0/24 | 3FFE:FFFF:0:CD30::/126. Required.
    :vartype network_prefix: str
    :ivar condition: Specify prefix-list bounds. Known values are: "EqualTo",
     "GreaterThanOrEqualTo", "LesserThanOrEqualTo", and "Range".
    :vartype condition: str or ~azure.mgmt.managednetworkfabric.models.Condition
    :ivar subnet_mask_length: SubnetMaskLength gives the minimum NetworkPrefix length to be
     matched. Possible values for IPv4 are 1 - 32 . Possible values of IPv6 are 1 - 128.
    :vartype subnet_mask_length: str
    """

    _validation = {
        "action": {"required": True},
        "sequence_number": {"required": True, "maximum": 4294967295, "minimum": 1},
        "network_prefix": {"required": True},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "sequence_number": {"key": "sequenceNumber", "type": "int"},
        "network_prefix": {"key": "networkPrefix", "type": "str"},
        "condition": {"key": "condition", "type": "str"},
        "subnet_mask_length": {"key": "subnetMaskLength", "type": "str"},
    }

    def __init__(
        self,
        *,
        action: Union[str, "_models.CommunityActionTypes"],
        sequence_number: int,
        network_prefix: str,
        condition: Optional[Union[str, "_models.Condition"]] = None,
        subnet_mask_length: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action: Action to be taken on the configuration. Example: Permit | Deny. Required.
         Known values are: "Permit" and "Deny".
        :paramtype action: str or ~azure.mgmt.managednetworkfabric.models.CommunityActionTypes
        :keyword sequence_number: Sequence to insert to/delete from existing route. Prefix lists are
         evaluated starting with the lowest sequence number and continue down the list until a match is
         made. Once a match is made, the permit or deny statement is applied to that network and the
         rest of the list is ignored. Required.
        :paramtype sequence_number: int
        :keyword network_prefix: Network Prefix specifying IPv4/IPv6 packets to be permitted or denied.
         Example: 1.1.1.0/24 | 3FFE:FFFF:0:CD30::/126. Required.
        :paramtype network_prefix: str
        :keyword condition: Specify prefix-list bounds. Known values are: "EqualTo",
         "GreaterThanOrEqualTo", "LesserThanOrEqualTo", and "Range".
        :paramtype condition: str or ~azure.mgmt.managednetworkfabric.models.Condition
        :keyword subnet_mask_length: SubnetMaskLength gives the minimum NetworkPrefix length to be
         matched. Possible values for IPv4 are 1 - 32 . Possible values of IPv6 are 1 - 128.
        :paramtype subnet_mask_length: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.sequence_number = sequence_number
        self.network_prefix = network_prefix
        self.condition = condition
        self.subnet_mask_length = subnet_mask_length


class IsolationDomainProperties(_serialization.Model):
    """Isolation Domain Properties.

    :ivar encapsulation: Type of encapsulation. Known values are: "None" and "GRE".
    :vartype encapsulation: str or ~azure.mgmt.managednetworkfabric.models.Encapsulation
    :ivar neighbor_group_ids: List of Neighbor Group IDs.
    :vartype neighbor_group_ids: list[str]
    """

    _attribute_map = {
        "encapsulation": {"key": "encapsulation", "type": "str"},
        "neighbor_group_ids": {"key": "neighborGroupIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        encapsulation: Optional[Union[str, "_models.Encapsulation"]] = None,
        neighbor_group_ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encapsulation: Type of encapsulation. Known values are: "None" and "GRE".
        :paramtype encapsulation: str or ~azure.mgmt.managednetworkfabric.models.Encapsulation
        :keyword neighbor_group_ids: List of Neighbor Group IDs.
        :paramtype neighbor_group_ids: list[str]
        """
        super().__init__(**kwargs)
        self.encapsulation = encapsulation
        self.neighbor_group_ids = neighbor_group_ids


class L2IsolationDomain(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The L2 Isolation Domain resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_fabric_id: ARM Resource ID of the Network Fabric. Required.
    :vartype network_fabric_id: str
    :ivar vlan_id: Vlan Identifier of the Network Fabric. Example: 501. Required.
    :vartype vlan_id: int
    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "network_fabric_id": {"required": True},
        "vlan_id": {"required": True, "maximum": 4094, "minimum": 100},
        "mtu": {"maximum": 9200, "minimum": 64},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "network_fabric_id": {"key": "properties.networkFabricId", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
        "mtu": {"key": "properties.mtu", "type": "int"},
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        network_fabric_id: str,
        vlan_id: int,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        mtu: int = 1500,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_fabric_id: ARM Resource ID of the Network Fabric. Required.
        :paramtype network_fabric_id: str
        :keyword vlan_id: Vlan Identifier of the Network Fabric. Example: 501. Required.
        :paramtype vlan_id: int
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.network_fabric_id = network_fabric_id
        self.vlan_id = vlan_id
        self.mtu = mtu
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class L2IsolationDomainPatch(TagsUpdate):
    """The L2 Isolation Domain patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "mtu": {"key": "properties.mtu", "type": "int"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, annotation: Optional[str] = None, mtu: int = 1500, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        """
        super().__init__(tags=tags, **kwargs)
        self.annotation = annotation
        self.mtu = mtu


class L2IsolationDomainPatchProperties(AnnotationResource):
    """L2 Isolation Domain Patch Properties defines the patchable properties of the resource.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "mtu": {"key": "mtu", "type": "int"},
    }

    def __init__(self, *, annotation: Optional[str] = None, mtu: int = 1500, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        """
        super().__init__(annotation=annotation, **kwargs)
        self.mtu = mtu


class L2IsolationDomainProperties(AnnotationResource):
    """L2Isolation Domain Properties defines the properties of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_fabric_id: ARM Resource ID of the Network Fabric. Required.
    :vartype network_fabric_id: str
    :ivar vlan_id: Vlan Identifier of the Network Fabric. Example: 501. Required.
    :vartype vlan_id: int
    :ivar mtu: Maximum transmission unit. Default value is 1500.
    :vartype mtu: int
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "network_fabric_id": {"required": True},
        "vlan_id": {"required": True, "maximum": 4094, "minimum": 100},
        "mtu": {"maximum": 9200, "minimum": 64},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "network_fabric_id": {"key": "networkFabricId", "type": "str"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "mtu": {"key": "mtu", "type": "int"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self, *, network_fabric_id: str, vlan_id: int, annotation: Optional[str] = None, mtu: int = 1500, **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_fabric_id: ARM Resource ID of the Network Fabric. Required.
        :paramtype network_fabric_id: str
        :keyword vlan_id: Vlan Identifier of the Network Fabric. Example: 501. Required.
        :paramtype vlan_id: int
        :keyword mtu: Maximum transmission unit. Default value is 1500.
        :paramtype mtu: int
        """
        super().__init__(annotation=annotation, **kwargs)
        self.network_fabric_id = network_fabric_id
        self.vlan_id = vlan_id
        self.mtu = mtu
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class L2IsolationDomainsListResult(_serialization.Model):
    """List of L2 Isolation Domains.

    :ivar value: Displays list of L2 Isolation Domain resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.L2IsolationDomain]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[L2IsolationDomain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.L2IsolationDomain"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Displays list of L2 Isolation Domain resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.L2IsolationDomain]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class L3ExportRoutePolicy(_serialization.Model):
    """Array of ARM Resource ID of the RoutePolicies.

    :ivar export_ipv4_route_policy_id: ARM Resource ID of the RoutePolicy.
    :vartype export_ipv4_route_policy_id: str
    :ivar export_ipv6_route_policy_id: ARM Resource ID of the RoutePolicy.
    :vartype export_ipv6_route_policy_id: str
    """

    _attribute_map = {
        "export_ipv4_route_policy_id": {"key": "exportIpv4RoutePolicyId", "type": "str"},
        "export_ipv6_route_policy_id": {"key": "exportIpv6RoutePolicyId", "type": "str"},
    }

    def __init__(
        self,
        *,
        export_ipv4_route_policy_id: Optional[str] = None,
        export_ipv6_route_policy_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword export_ipv4_route_policy_id: ARM Resource ID of the RoutePolicy.
        :paramtype export_ipv4_route_policy_id: str
        :keyword export_ipv6_route_policy_id: ARM Resource ID of the RoutePolicy.
        :paramtype export_ipv6_route_policy_id: str
        """
        super().__init__(**kwargs)
        self.export_ipv4_route_policy_id = export_ipv4_route_policy_id
        self.export_ipv6_route_policy_id = export_ipv6_route_policy_id


class L3IsolationDomain(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The L3 Isolation Domain resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False". Known
     values are: "True" and "False".
    :vartype redistribute_connected_subnets: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
    :ivar redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype redistribute_static_routes: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
    :ivar aggregate_route_configuration: Aggregate route configurations.
    :vartype aggregate_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
    :ivar connected_subnet_route_policy: Connected Subnet RoutePolicy.
    :vartype connected_subnet_route_policy:
     ~azure.mgmt.managednetworkfabric.models.ConnectedSubnetRoutePolicy
    :ivar network_fabric_id: ARM Resource ID of the Network Fabric. Required.
    :vartype network_fabric_id: str
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "network_fabric_id": {"required": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "redistribute_connected_subnets": {"key": "properties.redistributeConnectedSubnets", "type": "str"},
        "redistribute_static_routes": {"key": "properties.redistributeStaticRoutes", "type": "str"},
        "aggregate_route_configuration": {
            "key": "properties.aggregateRouteConfiguration",
            "type": "AggregateRouteConfiguration",
        },
        "connected_subnet_route_policy": {
            "key": "properties.connectedSubnetRoutePolicy",
            "type": "ConnectedSubnetRoutePolicy",
        },
        "network_fabric_id": {"key": "properties.networkFabricId", "type": "str"},
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        network_fabric_id: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        redistribute_connected_subnets: Union[str, "_models.RedistributeConnectedSubnets"] = "True",
        redistribute_static_routes: Union[str, "_models.RedistributeStaticRoutes"] = "False",
        aggregate_route_configuration: Optional["_models.AggregateRouteConfiguration"] = None,
        connected_subnet_route_policy: Optional["_models.ConnectedSubnetRoutePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False".
         Known values are: "True" and "False".
        :paramtype redistribute_connected_subnets: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
        :keyword redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known
         values are: "True" and "False".
        :paramtype redistribute_static_routes: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
        :keyword aggregate_route_configuration: Aggregate route configurations.
        :paramtype aggregate_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
        :keyword connected_subnet_route_policy: Connected Subnet RoutePolicy.
        :paramtype connected_subnet_route_policy:
         ~azure.mgmt.managednetworkfabric.models.ConnectedSubnetRoutePolicy
        :keyword network_fabric_id: ARM Resource ID of the Network Fabric. Required.
        :paramtype network_fabric_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.redistribute_connected_subnets = redistribute_connected_subnets
        self.redistribute_static_routes = redistribute_static_routes
        self.aggregate_route_configuration = aggregate_route_configuration
        self.connected_subnet_route_policy = connected_subnet_route_policy
        self.network_fabric_id = network_fabric_id
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class L3IsolationDomainPatch(TagsUpdate):
    """The L3 Isolation Domain patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False". Known
     values are: "True" and "False".
    :vartype redistribute_connected_subnets: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
    :ivar redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype redistribute_static_routes: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
    :ivar aggregate_route_configuration: Aggregate route configurations.
    :vartype aggregate_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
    :ivar connected_subnet_route_policy: Connected Subnet RoutePolicy.
    :vartype connected_subnet_route_policy:
     ~azure.mgmt.managednetworkfabric.models.ConnectedSubnetRoutePolicy
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "redistribute_connected_subnets": {"key": "properties.redistributeConnectedSubnets", "type": "str"},
        "redistribute_static_routes": {"key": "properties.redistributeStaticRoutes", "type": "str"},
        "aggregate_route_configuration": {
            "key": "properties.aggregateRouteConfiguration",
            "type": "AggregateRouteConfiguration",
        },
        "connected_subnet_route_policy": {
            "key": "properties.connectedSubnetRoutePolicy",
            "type": "ConnectedSubnetRoutePolicy",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        redistribute_connected_subnets: Union[str, "_models.RedistributeConnectedSubnets"] = "True",
        redistribute_static_routes: Union[str, "_models.RedistributeStaticRoutes"] = "False",
        aggregate_route_configuration: Optional["_models.AggregateRouteConfiguration"] = None,
        connected_subnet_route_policy: Optional["_models.ConnectedSubnetRoutePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False".
         Known values are: "True" and "False".
        :paramtype redistribute_connected_subnets: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
        :keyword redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known
         values are: "True" and "False".
        :paramtype redistribute_static_routes: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
        :keyword aggregate_route_configuration: Aggregate route configurations.
        :paramtype aggregate_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
        :keyword connected_subnet_route_policy: Connected Subnet RoutePolicy.
        :paramtype connected_subnet_route_policy:
         ~azure.mgmt.managednetworkfabric.models.ConnectedSubnetRoutePolicy
        """
        super().__init__(tags=tags, **kwargs)
        self.annotation = annotation
        self.redistribute_connected_subnets = redistribute_connected_subnets
        self.redistribute_static_routes = redistribute_static_routes
        self.aggregate_route_configuration = aggregate_route_configuration
        self.connected_subnet_route_policy = connected_subnet_route_policy


class L3IsolationDomainPatchableProperties(_serialization.Model):
    """L3 Isolation Domain Patch Properties defines the patchable properties of the resource.

    :ivar redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False". Known
     values are: "True" and "False".
    :vartype redistribute_connected_subnets: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
    :ivar redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype redistribute_static_routes: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
    :ivar aggregate_route_configuration: Aggregate route configurations.
    :vartype aggregate_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
    :ivar connected_subnet_route_policy: Connected Subnet RoutePolicy.
    :vartype connected_subnet_route_policy:
     ~azure.mgmt.managednetworkfabric.models.ConnectedSubnetRoutePolicy
    """

    _attribute_map = {
        "redistribute_connected_subnets": {"key": "redistributeConnectedSubnets", "type": "str"},
        "redistribute_static_routes": {"key": "redistributeStaticRoutes", "type": "str"},
        "aggregate_route_configuration": {"key": "aggregateRouteConfiguration", "type": "AggregateRouteConfiguration"},
        "connected_subnet_route_policy": {"key": "connectedSubnetRoutePolicy", "type": "ConnectedSubnetRoutePolicy"},
    }

    def __init__(
        self,
        *,
        redistribute_connected_subnets: Union[str, "_models.RedistributeConnectedSubnets"] = "True",
        redistribute_static_routes: Union[str, "_models.RedistributeStaticRoutes"] = "False",
        aggregate_route_configuration: Optional["_models.AggregateRouteConfiguration"] = None,
        connected_subnet_route_policy: Optional["_models.ConnectedSubnetRoutePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False".
         Known values are: "True" and "False".
        :paramtype redistribute_connected_subnets: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
        :keyword redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known
         values are: "True" and "False".
        :paramtype redistribute_static_routes: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
        :keyword aggregate_route_configuration: Aggregate route configurations.
        :paramtype aggregate_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
        :keyword connected_subnet_route_policy: Connected Subnet RoutePolicy.
        :paramtype connected_subnet_route_policy:
         ~azure.mgmt.managednetworkfabric.models.ConnectedSubnetRoutePolicy
        """
        super().__init__(**kwargs)
        self.redistribute_connected_subnets = redistribute_connected_subnets
        self.redistribute_static_routes = redistribute_static_routes
        self.aggregate_route_configuration = aggregate_route_configuration
        self.connected_subnet_route_policy = connected_subnet_route_policy


class L3IsolationDomainPatchProperties(AnnotationResource, L3IsolationDomainPatchableProperties):
    """Resource properties.

    :ivar redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False". Known
     values are: "True" and "False".
    :vartype redistribute_connected_subnets: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
    :ivar redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype redistribute_static_routes: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
    :ivar aggregate_route_configuration: Aggregate route configurations.
    :vartype aggregate_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
    :ivar connected_subnet_route_policy: Connected Subnet RoutePolicy.
    :vartype connected_subnet_route_policy:
     ~azure.mgmt.managednetworkfabric.models.ConnectedSubnetRoutePolicy
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "redistribute_connected_subnets": {"key": "redistributeConnectedSubnets", "type": "str"},
        "redistribute_static_routes": {"key": "redistributeStaticRoutes", "type": "str"},
        "aggregate_route_configuration": {"key": "aggregateRouteConfiguration", "type": "AggregateRouteConfiguration"},
        "connected_subnet_route_policy": {"key": "connectedSubnetRoutePolicy", "type": "ConnectedSubnetRoutePolicy"},
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        redistribute_connected_subnets: Union[str, "_models.RedistributeConnectedSubnets"] = "True",
        redistribute_static_routes: Union[str, "_models.RedistributeStaticRoutes"] = "False",
        aggregate_route_configuration: Optional["_models.AggregateRouteConfiguration"] = None,
        connected_subnet_route_policy: Optional["_models.ConnectedSubnetRoutePolicy"] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False".
         Known values are: "True" and "False".
        :paramtype redistribute_connected_subnets: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
        :keyword redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known
         values are: "True" and "False".
        :paramtype redistribute_static_routes: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
        :keyword aggregate_route_configuration: Aggregate route configurations.
        :paramtype aggregate_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
        :keyword connected_subnet_route_policy: Connected Subnet RoutePolicy.
        :paramtype connected_subnet_route_policy:
         ~azure.mgmt.managednetworkfabric.models.ConnectedSubnetRoutePolicy
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(
            annotation=annotation,
            redistribute_connected_subnets=redistribute_connected_subnets,
            redistribute_static_routes=redistribute_static_routes,
            aggregate_route_configuration=aggregate_route_configuration,
            connected_subnet_route_policy=connected_subnet_route_policy,
            **kwargs
        )
        self.redistribute_connected_subnets = redistribute_connected_subnets
        self.redistribute_static_routes = redistribute_static_routes
        self.aggregate_route_configuration = aggregate_route_configuration
        self.connected_subnet_route_policy = connected_subnet_route_policy
        self.annotation = annotation


class L3IsolationDomainProperties(AnnotationResource, L3IsolationDomainPatchableProperties):
    """L3 Isolation Domain Properties defines the properties of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False". Known
     values are: "True" and "False".
    :vartype redistribute_connected_subnets: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
    :ivar redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known values
     are: "True" and "False".
    :vartype redistribute_static_routes: str or
     ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
    :ivar aggregate_route_configuration: Aggregate route configurations.
    :vartype aggregate_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
    :ivar connected_subnet_route_policy: Connected Subnet RoutePolicy.
    :vartype connected_subnet_route_policy:
     ~azure.mgmt.managednetworkfabric.models.ConnectedSubnetRoutePolicy
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_fabric_id: ARM Resource ID of the Network Fabric. Required.
    :vartype network_fabric_id: str
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "network_fabric_id": {"required": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "redistribute_connected_subnets": {"key": "redistributeConnectedSubnets", "type": "str"},
        "redistribute_static_routes": {"key": "redistributeStaticRoutes", "type": "str"},
        "aggregate_route_configuration": {"key": "aggregateRouteConfiguration", "type": "AggregateRouteConfiguration"},
        "connected_subnet_route_policy": {"key": "connectedSubnetRoutePolicy", "type": "ConnectedSubnetRoutePolicy"},
        "annotation": {"key": "annotation", "type": "str"},
        "network_fabric_id": {"key": "networkFabricId", "type": "str"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_fabric_id: str,
        redistribute_connected_subnets: Union[str, "_models.RedistributeConnectedSubnets"] = "True",
        redistribute_static_routes: Union[str, "_models.RedistributeStaticRoutes"] = "False",
        aggregate_route_configuration: Optional["_models.AggregateRouteConfiguration"] = None,
        connected_subnet_route_policy: Optional["_models.ConnectedSubnetRoutePolicy"] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword redistribute_connected_subnets: Advertise Connected Subnets. Ex: "True" | "False".
         Known values are: "True" and "False".
        :paramtype redistribute_connected_subnets: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeConnectedSubnets
        :keyword redistribute_static_routes: Advertise Static Routes. Ex: "True" | "False". Known
         values are: "True" and "False".
        :paramtype redistribute_static_routes: str or
         ~azure.mgmt.managednetworkfabric.models.RedistributeStaticRoutes
        :keyword aggregate_route_configuration: Aggregate route configurations.
        :paramtype aggregate_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.AggregateRouteConfiguration
        :keyword connected_subnet_route_policy: Connected Subnet RoutePolicy.
        :paramtype connected_subnet_route_policy:
         ~azure.mgmt.managednetworkfabric.models.ConnectedSubnetRoutePolicy
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_fabric_id: ARM Resource ID of the Network Fabric. Required.
        :paramtype network_fabric_id: str
        """
        super().__init__(
            annotation=annotation,
            redistribute_connected_subnets=redistribute_connected_subnets,
            redistribute_static_routes=redistribute_static_routes,
            aggregate_route_configuration=aggregate_route_configuration,
            connected_subnet_route_policy=connected_subnet_route_policy,
            **kwargs
        )
        self.redistribute_connected_subnets = redistribute_connected_subnets
        self.redistribute_static_routes = redistribute_static_routes
        self.aggregate_route_configuration = aggregate_route_configuration
        self.connected_subnet_route_policy = connected_subnet_route_policy
        self.network_fabric_id = network_fabric_id
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None
        self.annotation = annotation


class L3IsolationDomainsListResult(_serialization.Model):
    """List of L3 Isolation Domains.

    :ivar value: List of L3 Isolation Domain resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.L3IsolationDomain]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[L3IsolationDomain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.L3IsolationDomain"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of L3 Isolation Domain resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.L3IsolationDomain]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class L3OptionBProperties(_serialization.Model):
    """Option B configuration.

    :ivar import_route_targets: RouteTargets to be applied. This is used for the backward
     compatibility.
    :vartype import_route_targets: list[str]
    :ivar export_route_targets: RouteTargets to be applied. This is used for the backward
     compatibility.
    :vartype export_route_targets: list[str]
    :ivar route_targets: RouteTargets to be applied.
    :vartype route_targets: ~azure.mgmt.managednetworkfabric.models.RouteTargetInformation
    """

    _attribute_map = {
        "import_route_targets": {"key": "importRouteTargets", "type": "[str]"},
        "export_route_targets": {"key": "exportRouteTargets", "type": "[str]"},
        "route_targets": {"key": "routeTargets", "type": "RouteTargetInformation"},
    }

    def __init__(
        self,
        *,
        import_route_targets: Optional[List[str]] = None,
        export_route_targets: Optional[List[str]] = None,
        route_targets: Optional["_models.RouteTargetInformation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword import_route_targets: RouteTargets to be applied. This is used for the backward
         compatibility.
        :paramtype import_route_targets: list[str]
        :keyword export_route_targets: RouteTargets to be applied. This is used for the backward
         compatibility.
        :paramtype export_route_targets: list[str]
        :keyword route_targets: RouteTargets to be applied.
        :paramtype route_targets: ~azure.mgmt.managednetworkfabric.models.RouteTargetInformation
        """
        super().__init__(**kwargs)
        self.import_route_targets = import_route_targets
        self.export_route_targets = export_route_targets
        self.route_targets = route_targets


class Layer2Configuration(_serialization.Model):
    """Common properties for Layer2 Configuration.

    :ivar mtu: MTU of the packets between PE & CE.
    :vartype mtu: int
    :ivar interfaces: List of network device interfaces resource IDs.
    :vartype interfaces: list[str]
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
        "interfaces": {"min_items": 1},
    }

    _attribute_map = {
        "mtu": {"key": "mtu", "type": "int"},
        "interfaces": {"key": "interfaces", "type": "[str]"},
    }

    def __init__(self, *, mtu: int = 1500, interfaces: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword mtu: MTU of the packets between PE & CE.
        :paramtype mtu: int
        :keyword interfaces: List of network device interfaces resource IDs.
        :paramtype interfaces: list[str]
        """
        super().__init__(**kwargs)
        self.mtu = mtu
        self.interfaces = interfaces


class ManagedResourceGroupConfiguration(_serialization.Model):
    """Managed Resource Group configuration properties.

    :ivar name: The NFC service will be hosted in a Managed resource group.
    :vartype name: str
    :ivar location: Managed resource group location.
    :vartype location: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The NFC service will be hosted in a Managed resource group.
        :paramtype name: str
        :keyword location: Managed resource group location.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.location = location


class ManagementNetworkConfigurationPatchableProperties(_serialization.Model):
    """Configuration to be used to setup the management network.

    :ivar infrastructure_vpn_configuration: VPN Configuration properties.
    :vartype infrastructure_vpn_configuration:
     ~azure.mgmt.managednetworkfabric.models.VpnConfigurationPatchableProperties
    :ivar workload_vpn_configuration: VPN Configuration properties.
    :vartype workload_vpn_configuration:
     ~azure.mgmt.managednetworkfabric.models.VpnConfigurationPatchableProperties
    """

    _attribute_map = {
        "infrastructure_vpn_configuration": {
            "key": "infrastructureVpnConfiguration",
            "type": "VpnConfigurationPatchableProperties",
        },
        "workload_vpn_configuration": {
            "key": "workloadVpnConfiguration",
            "type": "VpnConfigurationPatchableProperties",
        },
    }

    def __init__(
        self,
        *,
        infrastructure_vpn_configuration: Optional["_models.VpnConfigurationPatchableProperties"] = None,
        workload_vpn_configuration: Optional["_models.VpnConfigurationPatchableProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword infrastructure_vpn_configuration: VPN Configuration properties.
        :paramtype infrastructure_vpn_configuration:
         ~azure.mgmt.managednetworkfabric.models.VpnConfigurationPatchableProperties
        :keyword workload_vpn_configuration: VPN Configuration properties.
        :paramtype workload_vpn_configuration:
         ~azure.mgmt.managednetworkfabric.models.VpnConfigurationPatchableProperties
        """
        super().__init__(**kwargs)
        self.infrastructure_vpn_configuration = infrastructure_vpn_configuration
        self.workload_vpn_configuration = workload_vpn_configuration


class ManagementNetworkConfigurationProperties(_serialization.Model):
    """Configuration to be used to setup the management network.

    All required parameters must be populated in order to send to Azure.

    :ivar infrastructure_vpn_configuration: VPN Configuration properties. Required.
    :vartype infrastructure_vpn_configuration:
     ~azure.mgmt.managednetworkfabric.models.VpnConfigurationProperties
    :ivar workload_vpn_configuration: VPN Configuration properties. Required.
    :vartype workload_vpn_configuration:
     ~azure.mgmt.managednetworkfabric.models.VpnConfigurationProperties
    """

    _validation = {
        "infrastructure_vpn_configuration": {"required": True},
        "workload_vpn_configuration": {"required": True},
    }

    _attribute_map = {
        "infrastructure_vpn_configuration": {
            "key": "infrastructureVpnConfiguration",
            "type": "VpnConfigurationProperties",
        },
        "workload_vpn_configuration": {"key": "workloadVpnConfiguration", "type": "VpnConfigurationProperties"},
    }

    def __init__(
        self,
        *,
        infrastructure_vpn_configuration: "_models.VpnConfigurationProperties",
        workload_vpn_configuration: "_models.VpnConfigurationProperties",
        **kwargs: Any
    ) -> None:
        """
        :keyword infrastructure_vpn_configuration: VPN Configuration properties. Required.
        :paramtype infrastructure_vpn_configuration:
         ~azure.mgmt.managednetworkfabric.models.VpnConfigurationProperties
        :keyword workload_vpn_configuration: VPN Configuration properties. Required.
        :paramtype workload_vpn_configuration:
         ~azure.mgmt.managednetworkfabric.models.VpnConfigurationProperties
        """
        super().__init__(**kwargs)
        self.infrastructure_vpn_configuration = infrastructure_vpn_configuration
        self.workload_vpn_configuration = workload_vpn_configuration


class NeighborAddress(_serialization.Model):
    """Neighbor Address properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar address: IP Address.
    :vartype address: str
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    """

    _validation = {
        "address": {"min_length": 1},
        "configuration_state": {"readonly": True},
    }

    _attribute_map = {
        "address": {"key": "address", "type": "str"},
        "configuration_state": {"key": "configurationState", "type": "str"},
    }

    def __init__(self, *, address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword address: IP Address.
        :paramtype address: str
        """
        super().__init__(**kwargs)
        self.address = address
        self.configuration_state = None


class NeighborGroup(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Defines the Neighbor Group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar destination: An array of destination IPv4 Addresses or IPv6 Addresses.
    :vartype destination: ~azure.mgmt.managednetworkfabric.models.NeighborGroupDestination
    :ivar network_tap_ids: List of NetworkTap IDs where neighbor group is associated.
    :vartype network_tap_ids: list[str]
    :ivar network_tap_rule_ids: List of Network Tap Rule IDs where neighbor group is associated.
    :vartype network_tap_rule_ids: list[str]
    :ivar provisioning_state: The provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "network_tap_ids": {"readonly": True},
        "network_tap_rule_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "destination": {"key": "properties.destination", "type": "NeighborGroupDestination"},
        "network_tap_ids": {"key": "properties.networkTapIds", "type": "[str]"},
        "network_tap_rule_ids": {"key": "properties.networkTapRuleIds", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        destination: Optional["_models.NeighborGroupDestination"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword destination: An array of destination IPv4 Addresses or IPv6 Addresses.
        :paramtype destination: ~azure.mgmt.managednetworkfabric.models.NeighborGroupDestination
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.destination = destination
        self.network_tap_ids = None
        self.network_tap_rule_ids = None
        self.provisioning_state = None


class NeighborGroupDestination(_serialization.Model):
    """An array of destination IPv4 Addresses or IPv6 Addresses.

    :ivar ipv4_addresses: Array of IPv4 Addresses.
    :vartype ipv4_addresses: list[str]
    :ivar ipv6_addresses: Array of IPv6 Addresses.
    :vartype ipv6_addresses: list[str]
    """

    _validation = {
        "ipv4_addresses": {"max_items": 16, "min_items": 0},
        "ipv6_addresses": {"max_items": 16, "min_items": 0},
    }

    _attribute_map = {
        "ipv4_addresses": {"key": "ipv4Addresses", "type": "[str]"},
        "ipv6_addresses": {"key": "ipv6Addresses", "type": "[str]"},
    }

    def __init__(
        self, *, ipv4_addresses: Optional[List[str]] = None, ipv6_addresses: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword ipv4_addresses: Array of IPv4 Addresses.
        :paramtype ipv4_addresses: list[str]
        :keyword ipv6_addresses: Array of IPv6 Addresses.
        :paramtype ipv6_addresses: list[str]
        """
        super().__init__(**kwargs)
        self.ipv4_addresses = ipv4_addresses
        self.ipv6_addresses = ipv6_addresses


class NeighborGroupPatch(TagsUpdate):
    """The Neighbor Group Patch definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar destination: An array of destination IPv4 Addresses or IPv6 Addresses.
    :vartype destination: ~azure.mgmt.managednetworkfabric.models.NeighborGroupDestination
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "destination": {"key": "properties.destination", "type": "NeighborGroupDestination"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        destination: Optional["_models.NeighborGroupDestination"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword destination: An array of destination IPv4 Addresses or IPv6 Addresses.
        :paramtype destination: ~azure.mgmt.managednetworkfabric.models.NeighborGroupDestination
        """
        super().__init__(tags=tags, **kwargs)
        self.annotation = annotation
        self.destination = destination


class NeighborGroupPatchableProperties(_serialization.Model):
    """Neighbor Group Patchable Properties defines the patchable properties of the resource.

    :ivar destination: An array of destination IPv4 Addresses or IPv6 Addresses.
    :vartype destination: ~azure.mgmt.managednetworkfabric.models.NeighborGroupDestination
    """

    _attribute_map = {
        "destination": {"key": "destination", "type": "NeighborGroupDestination"},
    }

    def __init__(self, *, destination: Optional["_models.NeighborGroupDestination"] = None, **kwargs: Any) -> None:
        """
        :keyword destination: An array of destination IPv4 Addresses or IPv6 Addresses.
        :paramtype destination: ~azure.mgmt.managednetworkfabric.models.NeighborGroupDestination
        """
        super().__init__(**kwargs)
        self.destination = destination


class NeighborGroupPatchProperties(AnnotationResource, NeighborGroupPatchableProperties):
    """Neighbor Group Patch properties.

    :ivar destination: An array of destination IPv4 Addresses or IPv6 Addresses.
    :vartype destination: ~azure.mgmt.managednetworkfabric.models.NeighborGroupDestination
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "destination": {"key": "destination", "type": "NeighborGroupDestination"},
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        destination: Optional["_models.NeighborGroupDestination"] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword destination: An array of destination IPv4 Addresses or IPv6 Addresses.
        :paramtype destination: ~azure.mgmt.managednetworkfabric.models.NeighborGroupDestination
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, destination=destination, **kwargs)
        self.destination = destination
        self.annotation = annotation


class NeighborGroupProperties(AnnotationResource, NeighborGroupPatchableProperties):
    """Neighbor Group Properties defines the properties of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar destination: An array of destination IPv4 Addresses or IPv6 Addresses.
    :vartype destination: ~azure.mgmt.managednetworkfabric.models.NeighborGroupDestination
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_tap_ids: List of NetworkTap IDs where neighbor group is associated.
    :vartype network_tap_ids: list[str]
    :ivar network_tap_rule_ids: List of Network Tap Rule IDs where neighbor group is associated.
    :vartype network_tap_rule_ids: list[str]
    :ivar provisioning_state: The provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "network_tap_ids": {"readonly": True},
        "network_tap_rule_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "destination": {"key": "destination", "type": "NeighborGroupDestination"},
        "annotation": {"key": "annotation", "type": "str"},
        "network_tap_ids": {"key": "networkTapIds", "type": "[str]"},
        "network_tap_rule_ids": {"key": "networkTapRuleIds", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        destination: Optional["_models.NeighborGroupDestination"] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword destination: An array of destination IPv4 Addresses or IPv6 Addresses.
        :paramtype destination: ~azure.mgmt.managednetworkfabric.models.NeighborGroupDestination
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, destination=destination, **kwargs)
        self.destination = destination
        self.network_tap_ids = None
        self.network_tap_rule_ids = None
        self.provisioning_state = None
        self.annotation = annotation


class NeighborGroupsListResult(_serialization.Model):
    """List of Neighbor Group.

    :ivar value: List of Neighbor Group resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NeighborGroup]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NeighborGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NeighborGroup"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Neighbor Group resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NeighborGroup]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkDevice(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The Network Device resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar host_name: The host name of the device.
    :vartype host_name: str
    :ivar serial_number: Serial number of the device. Format of serial Number -
     Make;Model;HardwareRevisionId;SerialNumber.
    :vartype serial_number: str
    :ivar version: Current version of the device as defined in SKU.
    :vartype version: str
    :ivar network_device_sku: Network Device SKU name.
    :vartype network_device_sku: str
    :ivar network_device_role: NetworkDeviceRole is the device role: Example: CE | ToR. Known
     values are: "CE", "ToR", "NPB", "TS", and "Management".
    :vartype network_device_role: str or ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRole
    :ivar network_rack_id: Reference to network rack resource id.
    :vartype network_rack_id: str
    :ivar management_ipv4_address: Management IPv4 Address.
    :vartype management_ipv4_address: str
    :ivar management_ipv6_address: Management IPv6 Address.
    :vartype management_ipv6_address: str
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "host_name": {"min_length": 1},
        "serial_number": {"min_length": 1},
        "version": {"readonly": True},
        "network_device_role": {"readonly": True},
        "network_rack_id": {"readonly": True},
        "management_ipv4_address": {"readonly": True},
        "management_ipv6_address": {"readonly": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "network_device_sku": {"key": "properties.networkDeviceSku", "type": "str"},
        "network_device_role": {"key": "properties.networkDeviceRole", "type": "str"},
        "network_rack_id": {"key": "properties.networkRackId", "type": "str"},
        "management_ipv4_address": {"key": "properties.managementIpv4Address", "type": "str"},
        "management_ipv6_address": {"key": "properties.managementIpv6Address", "type": "str"},
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        host_name: Optional[str] = None,
        serial_number: Optional[str] = None,
        network_device_sku: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword host_name: The host name of the device.
        :paramtype host_name: str
        :keyword serial_number: Serial number of the device. Format of serial Number -
         Make;Model;HardwareRevisionId;SerialNumber.
        :paramtype serial_number: str
        :keyword network_device_sku: Network Device SKU name.
        :paramtype network_device_sku: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.host_name = host_name
        self.serial_number = serial_number
        self.version = None
        self.network_device_sku = network_device_sku
        self.network_device_role = None
        self.network_rack_id = None
        self.management_ipv4_address = None
        self.management_ipv6_address = None
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class NetworkDevicePatchableProperties(_serialization.Model):
    """Network Device updatable properties.

    :ivar host_name: The host name of the device.
    :vartype host_name: str
    :ivar serial_number: Serial number of the device. Format of serial Number -
     Make;Model;HardwareRevisionId;SerialNumber.
    :vartype serial_number: str
    """

    _validation = {
        "host_name": {"min_length": 1},
        "serial_number": {"min_length": 1},
    }

    _attribute_map = {
        "host_name": {"key": "hostName", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
    }

    def __init__(self, *, host_name: Optional[str] = None, serial_number: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword host_name: The host name of the device.
        :paramtype host_name: str
        :keyword serial_number: Serial number of the device. Format of serial Number -
         Make;Model;HardwareRevisionId;SerialNumber.
        :paramtype serial_number: str
        """
        super().__init__(**kwargs)
        self.host_name = host_name
        self.serial_number = serial_number


class NetworkDevicePatchParameters(TagsUpdate):
    """The Network Device Patch Parameters defines the patch parameters of the resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar host_name: The host name of the device.
    :vartype host_name: str
    :ivar serial_number: Serial number of the device. Format of serial Number -
     Make;Model;HardwareRevisionId;SerialNumber.
    :vartype serial_number: str
    """

    _validation = {
        "host_name": {"min_length": 1},
        "serial_number": {"min_length": 1},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        host_name: Optional[str] = None,
        serial_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword host_name: The host name of the device.
        :paramtype host_name: str
        :keyword serial_number: Serial number of the device. Format of serial Number -
         Make;Model;HardwareRevisionId;SerialNumber.
        :paramtype serial_number: str
        """
        super().__init__(tags=tags, **kwargs)
        self.annotation = annotation
        self.host_name = host_name
        self.serial_number = serial_number


class NetworkDevicePatchParametersProperties(AnnotationResource, NetworkDevicePatchableProperties):
    """Network Device Patch properties.

    :ivar host_name: The host name of the device.
    :vartype host_name: str
    :ivar serial_number: Serial number of the device. Format of serial Number -
     Make;Model;HardwareRevisionId;SerialNumber.
    :vartype serial_number: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _validation = {
        "host_name": {"min_length": 1},
        "serial_number": {"min_length": 1},
    }

    _attribute_map = {
        "host_name": {"key": "hostName", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        serial_number: Optional[str] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_name: The host name of the device.
        :paramtype host_name: str
        :keyword serial_number: Serial number of the device. Format of serial Number -
         Make;Model;HardwareRevisionId;SerialNumber.
        :paramtype serial_number: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, host_name=host_name, serial_number=serial_number, **kwargs)
        self.host_name = host_name
        self.serial_number = serial_number
        self.annotation = annotation


class NetworkDeviceProperties(
    AnnotationResource, NetworkDevicePatchableProperties
):  # pylint: disable=too-many-instance-attributes
    """Network Device Properties defines the properties of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar host_name: The host name of the device.
    :vartype host_name: str
    :ivar serial_number: Serial number of the device. Format of serial Number -
     Make;Model;HardwareRevisionId;SerialNumber.
    :vartype serial_number: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar version: Current version of the device as defined in SKU.
    :vartype version: str
    :ivar network_device_sku: Network Device SKU name.
    :vartype network_device_sku: str
    :ivar network_device_role: NetworkDeviceRole is the device role: Example: CE | ToR. Known
     values are: "CE", "ToR", "NPB", "TS", and "Management".
    :vartype network_device_role: str or ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRole
    :ivar network_rack_id: Reference to network rack resource id.
    :vartype network_rack_id: str
    :ivar management_ipv4_address: Management IPv4 Address.
    :vartype management_ipv4_address: str
    :ivar management_ipv6_address: Management IPv6 Address.
    :vartype management_ipv6_address: str
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "host_name": {"min_length": 1},
        "serial_number": {"min_length": 1},
        "version": {"readonly": True},
        "network_device_role": {"readonly": True},
        "network_rack_id": {"readonly": True},
        "management_ipv4_address": {"readonly": True},
        "management_ipv6_address": {"readonly": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "host_name": {"key": "hostName", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "annotation": {"key": "annotation", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "network_device_sku": {"key": "networkDeviceSku", "type": "str"},
        "network_device_role": {"key": "networkDeviceRole", "type": "str"},
        "network_rack_id": {"key": "networkRackId", "type": "str"},
        "management_ipv4_address": {"key": "managementIpv4Address", "type": "str"},
        "management_ipv6_address": {"key": "managementIpv6Address", "type": "str"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        serial_number: Optional[str] = None,
        annotation: Optional[str] = None,
        network_device_sku: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_name: The host name of the device.
        :paramtype host_name: str
        :keyword serial_number: Serial number of the device. Format of serial Number -
         Make;Model;HardwareRevisionId;SerialNumber.
        :paramtype serial_number: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_device_sku: Network Device SKU name.
        :paramtype network_device_sku: str
        """
        super().__init__(annotation=annotation, host_name=host_name, serial_number=serial_number, **kwargs)
        self.host_name = host_name
        self.serial_number = serial_number
        self.version = None
        self.network_device_sku = network_device_sku
        self.network_device_role = None
        self.network_rack_id = None
        self.management_ipv4_address = None
        self.management_ipv6_address = None
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None
        self.annotation = annotation


class NetworkDeviceSku(ProxyResource):
    """The NetworkDeviceSku resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar model: Model of the network device. Required.
    :vartype model: str
    :ivar manufacturer: Manufacturer of the network device.
    :vartype manufacturer: str
    :ivar supported_versions: List of supported version details of network device.
    :vartype supported_versions:
     list[~azure.mgmt.managednetworkfabric.models.SupportedVersionProperties]
    :ivar supported_role_types: Available roles for the network device.
    :vartype supported_role_types: list[str or
     ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRoleName]
    :ivar interfaces: List of network device interfaces.
    :vartype interfaces: list[~azure.mgmt.managednetworkfabric.models.DeviceInterfaceProperties]
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "model": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "model": {"key": "properties.model", "type": "str"},
        "manufacturer": {"key": "properties.manufacturer", "type": "str"},
        "supported_versions": {"key": "properties.supportedVersions", "type": "[SupportedVersionProperties]"},
        "supported_role_types": {"key": "properties.supportedRoleTypes", "type": "[str]"},
        "interfaces": {"key": "properties.interfaces", "type": "[DeviceInterfaceProperties]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        model: str,
        manufacturer: Optional[str] = None,
        supported_versions: Optional[List["_models.SupportedVersionProperties"]] = None,
        supported_role_types: Optional[List[Union[str, "_models.NetworkDeviceRoleName"]]] = None,
        interfaces: Optional[List["_models.DeviceInterfaceProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword model: Model of the network device. Required.
        :paramtype model: str
        :keyword manufacturer: Manufacturer of the network device.
        :paramtype manufacturer: str
        :keyword supported_versions: List of supported version details of network device.
        :paramtype supported_versions:
         list[~azure.mgmt.managednetworkfabric.models.SupportedVersionProperties]
        :keyword supported_role_types: Available roles for the network device.
        :paramtype supported_role_types: list[str or
         ~azure.mgmt.managednetworkfabric.models.NetworkDeviceRoleName]
        :keyword interfaces: List of network device interfaces.
        :paramtype interfaces: list[~azure.mgmt.managednetworkfabric.models.DeviceInterfaceProperties]
        """
        super().__init__(**kwargs)
        self.model = model
        self.manufacturer = manufacturer
        self.supported_versions = supported_versions
        self.supported_role_types = supported_role_types
        self.interfaces = interfaces
        self.provisioning_state = None


class NetworkDeviceSkusListResult(_serialization.Model):
    """List of Network Device SKUs.

    :ivar value: List of Network Device SKU resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkDeviceSku]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkDeviceSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkDeviceSku"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Network Device SKU resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkDeviceSku]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkDevicesListResult(_serialization.Model):
    """List of NetworkDevices.

    :ivar value: List of NetworkDevice resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkDevice]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkDevice]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkDevice"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkDevice resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkDevice]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkFabric(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The Network Fabric resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_fabric_sku: Supported Network Fabric SKU.Example: Compute / Aggregate racks. Once
     the user chooses a particular SKU, only supported racks can be added to the Network Fabric. The
     SKU determines whether it is a single / multi rack Network Fabric. Required.
    :vartype network_fabric_sku: str
    :ivar fabric_version: The version of Network Fabric.
    :vartype fabric_version: str
    :ivar router_ids: Array of router IDs.
    :vartype router_ids: list[str]
    :ivar network_fabric_controller_id: Azure resource ID for the NetworkFabricController the
     NetworkFabric belongs. Required.
    :vartype network_fabric_controller_id: str
    :ivar rack_count: Number of compute racks associated to Network Fabric.
    :vartype rack_count: int
    :ivar server_count_per_rack: Number of servers.Possible values are from 1-16. Required.
    :vartype server_count_per_rack: int
    :ivar ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19. Required.
    :vartype ipv4_prefix: str
    :ivar ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
    :vartype ipv6_prefix: str
    :ivar fabric_asn: ASN of CE devices for CE/PE connectivity. Required.
    :vartype fabric_asn: int
    :ivar terminal_server_configuration: Network and credentials configuration currently applied to
     terminal server. Required.
    :vartype terminal_server_configuration:
     ~azure.mgmt.managednetworkfabric.models.TerminalServerConfiguration
    :ivar management_network_configuration: Configuration to be used to setup the management
     network. Required.
    :vartype management_network_configuration:
     ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfigurationProperties
    :ivar racks: List of NetworkRack resource IDs under the Network Fabric. The number of racks
     allowed depends on the Network Fabric SKU.
    :vartype racks: list[str]
    :ivar l2_isolation_domains: List of L2 Isolation Domain resource IDs under the Network Fabric.
    :vartype l2_isolation_domains: list[str]
    :ivar l3_isolation_domains: List of L3 Isolation Domain resource IDs under the Network Fabric.
    :vartype l3_isolation_domains: list[str]
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provides you the latest status of the NFC service, whether it is
     Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on
     the status of NFC provisioning. Known values are: "Accepted", "Succeeded", "Updating",
     "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "network_fabric_sku": {"required": True, "min_length": 1},
        "fabric_version": {"readonly": True},
        "router_ids": {"readonly": True},
        "network_fabric_controller_id": {"required": True},
        "rack_count": {"maximum": 8, "minimum": 1},
        "server_count_per_rack": {"required": True, "maximum": 16, "minimum": 1},
        "ipv4_prefix": {"required": True, "min_length": 1},
        "ipv6_prefix": {"min_length": 1},
        "fabric_asn": {"required": True, "maximum": 4294967295, "minimum": 1},
        "terminal_server_configuration": {"required": True},
        "management_network_configuration": {"required": True},
        "racks": {"readonly": True},
        "l2_isolation_domains": {"readonly": True},
        "l3_isolation_domains": {"readonly": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "network_fabric_sku": {"key": "properties.networkFabricSku", "type": "str"},
        "fabric_version": {"key": "properties.fabricVersion", "type": "str"},
        "router_ids": {"key": "properties.routerIds", "type": "[str]"},
        "network_fabric_controller_id": {"key": "properties.networkFabricControllerId", "type": "str"},
        "rack_count": {"key": "properties.rackCount", "type": "int"},
        "server_count_per_rack": {"key": "properties.serverCountPerRack", "type": "int"},
        "ipv4_prefix": {"key": "properties.ipv4Prefix", "type": "str"},
        "ipv6_prefix": {"key": "properties.ipv6Prefix", "type": "str"},
        "fabric_asn": {"key": "properties.fabricASN", "type": "int"},
        "terminal_server_configuration": {
            "key": "properties.terminalServerConfiguration",
            "type": "TerminalServerConfiguration",
        },
        "management_network_configuration": {
            "key": "properties.managementNetworkConfiguration",
            "type": "ManagementNetworkConfigurationProperties",
        },
        "racks": {"key": "properties.racks", "type": "[str]"},
        "l2_isolation_domains": {"key": "properties.l2IsolationDomains", "type": "[str]"},
        "l3_isolation_domains": {"key": "properties.l3IsolationDomains", "type": "[str]"},
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        network_fabric_sku: str,
        network_fabric_controller_id: str,
        server_count_per_rack: int,
        ipv4_prefix: str,
        fabric_asn: int,
        terminal_server_configuration: "_models.TerminalServerConfiguration",
        management_network_configuration: "_models.ManagementNetworkConfigurationProperties",
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        rack_count: Optional[int] = None,
        ipv6_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_fabric_sku: Supported Network Fabric SKU.Example: Compute / Aggregate racks.
         Once the user chooses a particular SKU, only supported racks can be added to the Network
         Fabric. The SKU determines whether it is a single / multi rack Network Fabric. Required.
        :paramtype network_fabric_sku: str
        :keyword network_fabric_controller_id: Azure resource ID for the NetworkFabricController the
         NetworkFabric belongs. Required.
        :paramtype network_fabric_controller_id: str
        :keyword rack_count: Number of compute racks associated to Network Fabric.
        :paramtype rack_count: int
        :keyword server_count_per_rack: Number of servers.Possible values are from 1-16. Required.
        :paramtype server_count_per_rack: int
        :keyword ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19. Required.
        :paramtype ipv4_prefix: str
        :keyword ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
        :paramtype ipv6_prefix: str
        :keyword fabric_asn: ASN of CE devices for CE/PE connectivity. Required.
        :paramtype fabric_asn: int
        :keyword terminal_server_configuration: Network and credentials configuration currently applied
         to terminal server. Required.
        :paramtype terminal_server_configuration:
         ~azure.mgmt.managednetworkfabric.models.TerminalServerConfiguration
        :keyword management_network_configuration: Configuration to be used to setup the management
         network. Required.
        :paramtype management_network_configuration:
         ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfigurationProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.network_fabric_sku = network_fabric_sku
        self.fabric_version = None
        self.router_ids = None
        self.network_fabric_controller_id = network_fabric_controller_id
        self.rack_count = rack_count
        self.server_count_per_rack = server_count_per_rack
        self.ipv4_prefix = ipv4_prefix
        self.ipv6_prefix = ipv6_prefix
        self.fabric_asn = fabric_asn
        self.terminal_server_configuration = terminal_server_configuration
        self.management_network_configuration = management_network_configuration
        self.racks = None
        self.l2_isolation_domains = None
        self.l3_isolation_domains = None
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class NetworkFabricController(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The Network Fabric Controller resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar infrastructure_express_route_connections: As part of an update, the Infrastructure
     ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
     dedicated for Infrastructure services. (This is a Mandatory attribute).
    :vartype infrastructure_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar workload_express_route_connections: As part of an update, the workload ExpressRoute
     CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
     Workload services. (This is a Mandatory attribute).
    :vartype workload_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar infrastructure_services: InfrastructureServices IP ranges.
    :vartype infrastructure_services: ~azure.mgmt.managednetworkfabric.models.ControllerServices
    :ivar workload_services: WorkloadServices IP ranges.
    :vartype workload_services: ~azure.mgmt.managednetworkfabric.models.ControllerServices
    :ivar managed_resource_group_configuration: Managed Resource Group configuration properties.
    :vartype managed_resource_group_configuration:
     ~azure.mgmt.managednetworkfabric.models.ManagedResourceGroupConfiguration
    :ivar network_fabric_ids: The NF-ID will be an input parameter used by the NF to link and get
     associated with the parent NFC Service.
    :vartype network_fabric_ids: list[str]
    :ivar workload_management_network: A workload management network is required for all the tenant
     (workload) traffic. This traffic is only dedicated for Tenant workloads which are required to
     access internet or any other MSFT/Public endpoints. This is used for the backward
     compatibility.
    :vartype workload_management_network: bool
    :ivar is_workload_management_network_enabled: A workload management network is required for all
     the tenant (workload) traffic. This traffic is only dedicated for Tenant workloads which are
     required to access internet or any other MSFT/Public endpoints. Known values are: "True" and
     "False".
    :vartype is_workload_management_network_enabled: str or
     ~azure.mgmt.managednetworkfabric.models.IsWorkloadManagementNetworkEnabled
    :ivar tenant_internet_gateway_ids: List of tenant InternetGateway resource IDs.
    :vartype tenant_internet_gateway_ids: list[str]
    :ivar ipv4_address_space: IPv4 Network Fabric Controller Address Space.
    :vartype ipv4_address_space: str
    :ivar ipv6_address_space: IPv6 Network Fabric Controller Address Space.
    :vartype ipv6_address_space: str
    :ivar nfc_sku: Network Fabric Controller SKU. Known values are: "Basic", "Standard", and
     "HighPerformance".
    :vartype nfc_sku: str or ~azure.mgmt.managednetworkfabric.models.NfcSku
    :ivar provisioning_state: Provides you the latest status of the NFC service, whether it is
     Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on
     the status of NFC provisioning. Known values are: "Accepted", "Succeeded", "Updating",
     "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "infrastructure_services": {"readonly": True},
        "workload_services": {"readonly": True},
        "network_fabric_ids": {"readonly": True},
        "workload_management_network": {"readonly": True},
        "tenant_internet_gateway_ids": {"readonly": True},
        "ipv4_address_space": {"min_length": 1},
        "ipv6_address_space": {"min_length": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "infrastructure_express_route_connections": {
            "key": "properties.infrastructureExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "workload_express_route_connections": {
            "key": "properties.workloadExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "infrastructure_services": {"key": "properties.infrastructureServices", "type": "ControllerServices"},
        "workload_services": {"key": "properties.workloadServices", "type": "ControllerServices"},
        "managed_resource_group_configuration": {
            "key": "properties.managedResourceGroupConfiguration",
            "type": "ManagedResourceGroupConfiguration",
        },
        "network_fabric_ids": {"key": "properties.networkFabricIds", "type": "[str]"},
        "workload_management_network": {"key": "properties.workloadManagementNetwork", "type": "bool"},
        "is_workload_management_network_enabled": {
            "key": "properties.isWorkloadManagementNetworkEnabled",
            "type": "str",
        },
        "tenant_internet_gateway_ids": {"key": "properties.tenantInternetGatewayIds", "type": "[str]"},
        "ipv4_address_space": {"key": "properties.ipv4AddressSpace", "type": "str"},
        "ipv6_address_space": {"key": "properties.ipv6AddressSpace", "type": "str"},
        "nfc_sku": {"key": "properties.nfcSku", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        infrastructure_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        workload_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        managed_resource_group_configuration: Optional["_models.ManagedResourceGroupConfiguration"] = None,
        is_workload_management_network_enabled: Union[str, "_models.IsWorkloadManagementNetworkEnabled"] = "True",
        ipv4_address_space: str = "10.0.0.0/19",
        ipv6_address_space: str = "FC00::/59",
        nfc_sku: Union[str, "_models.NfcSku"] = "Standard",
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword infrastructure_express_route_connections: As part of an update, the Infrastructure
         ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
         dedicated for Infrastructure services. (This is a Mandatory attribute).
        :paramtype infrastructure_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword workload_express_route_connections: As part of an update, the workload ExpressRoute
         CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
         Workload services. (This is a Mandatory attribute).
        :paramtype workload_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword managed_resource_group_configuration: Managed Resource Group configuration properties.
        :paramtype managed_resource_group_configuration:
         ~azure.mgmt.managednetworkfabric.models.ManagedResourceGroupConfiguration
        :keyword is_workload_management_network_enabled: A workload management network is required for
         all the tenant (workload) traffic. This traffic is only dedicated for Tenant workloads which
         are required to access internet or any other MSFT/Public endpoints. Known values are: "True"
         and "False".
        :paramtype is_workload_management_network_enabled: str or
         ~azure.mgmt.managednetworkfabric.models.IsWorkloadManagementNetworkEnabled
        :keyword ipv4_address_space: IPv4 Network Fabric Controller Address Space.
        :paramtype ipv4_address_space: str
        :keyword ipv6_address_space: IPv6 Network Fabric Controller Address Space.
        :paramtype ipv6_address_space: str
        :keyword nfc_sku: Network Fabric Controller SKU. Known values are: "Basic", "Standard", and
         "HighPerformance".
        :paramtype nfc_sku: str or ~azure.mgmt.managednetworkfabric.models.NfcSku
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.infrastructure_express_route_connections = infrastructure_express_route_connections
        self.workload_express_route_connections = workload_express_route_connections
        self.infrastructure_services = None
        self.workload_services = None
        self.managed_resource_group_configuration = managed_resource_group_configuration
        self.network_fabric_ids = None
        self.workload_management_network = None
        self.is_workload_management_network_enabled = is_workload_management_network_enabled
        self.tenant_internet_gateway_ids = None
        self.ipv4_address_space = ipv4_address_space
        self.ipv6_address_space = ipv6_address_space
        self.nfc_sku = nfc_sku
        self.provisioning_state = None


class NetworkFabricControllerPatch(TagsUpdate):
    """The Network Fabric Controller Patch payload definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar infrastructure_express_route_connections: As part of an update, the Infrastructure
     ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
     dedicated for Infrastructure services. (This is a Mandatory attribute).
    :vartype infrastructure_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar workload_express_route_connections: As part of an update, the workload ExpressRoute
     CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
     Workload services. (This is a Mandatory attribute).
    :vartype workload_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "infrastructure_express_route_connections": {
            "key": "properties.infrastructureExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "workload_express_route_connections": {
            "key": "properties.workloadExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        infrastructure_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        workload_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword infrastructure_express_route_connections: As part of an update, the Infrastructure
         ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
         dedicated for Infrastructure services. (This is a Mandatory attribute).
        :paramtype infrastructure_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword workload_express_route_connections: As part of an update, the workload ExpressRoute
         CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
         Workload services. (This is a Mandatory attribute).
        :paramtype workload_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        """
        super().__init__(tags=tags, **kwargs)
        self.infrastructure_express_route_connections = infrastructure_express_route_connections
        self.workload_express_route_connections = workload_express_route_connections


class NetworkFabricControllerPatchableProperties(_serialization.Model):
    """Network Fabric Controller updatable properties.

    :ivar infrastructure_express_route_connections: As part of an update, the Infrastructure
     ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
     dedicated for Infrastructure services. (This is a Mandatory attribute).
    :vartype infrastructure_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar workload_express_route_connections: As part of an update, the workload ExpressRoute
     CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
     Workload services. (This is a Mandatory attribute).
    :vartype workload_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    """

    _attribute_map = {
        "infrastructure_express_route_connections": {
            "key": "infrastructureExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "workload_express_route_connections": {
            "key": "workloadExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
    }

    def __init__(
        self,
        *,
        infrastructure_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        workload_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword infrastructure_express_route_connections: As part of an update, the Infrastructure
         ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
         dedicated for Infrastructure services. (This is a Mandatory attribute).
        :paramtype infrastructure_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword workload_express_route_connections: As part of an update, the workload ExpressRoute
         CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
         Workload services. (This is a Mandatory attribute).
        :paramtype workload_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        """
        super().__init__(**kwargs)
        self.infrastructure_express_route_connections = infrastructure_express_route_connections
        self.workload_express_route_connections = workload_express_route_connections


class NetworkFabricControllerProperties(
    AnnotationResource, NetworkFabricControllerPatchableProperties
):  # pylint: disable=too-many-instance-attributes
    """NetworkFabricControllerProperties defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar infrastructure_express_route_connections: As part of an update, the Infrastructure
     ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
     dedicated for Infrastructure services. (This is a Mandatory attribute).
    :vartype infrastructure_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar workload_express_route_connections: As part of an update, the workload ExpressRoute
     CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
     Workload services. (This is a Mandatory attribute).
    :vartype workload_express_route_connections:
     list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar infrastructure_services: InfrastructureServices IP ranges.
    :vartype infrastructure_services: ~azure.mgmt.managednetworkfabric.models.ControllerServices
    :ivar workload_services: WorkloadServices IP ranges.
    :vartype workload_services: ~azure.mgmt.managednetworkfabric.models.ControllerServices
    :ivar managed_resource_group_configuration: Managed Resource Group configuration properties.
    :vartype managed_resource_group_configuration:
     ~azure.mgmt.managednetworkfabric.models.ManagedResourceGroupConfiguration
    :ivar network_fabric_ids: The NF-ID will be an input parameter used by the NF to link and get
     associated with the parent NFC Service.
    :vartype network_fabric_ids: list[str]
    :ivar workload_management_network: A workload management network is required for all the tenant
     (workload) traffic. This traffic is only dedicated for Tenant workloads which are required to
     access internet or any other MSFT/Public endpoints. This is used for the backward
     compatibility.
    :vartype workload_management_network: bool
    :ivar is_workload_management_network_enabled: A workload management network is required for all
     the tenant (workload) traffic. This traffic is only dedicated for Tenant workloads which are
     required to access internet or any other MSFT/Public endpoints. Known values are: "True" and
     "False".
    :vartype is_workload_management_network_enabled: str or
     ~azure.mgmt.managednetworkfabric.models.IsWorkloadManagementNetworkEnabled
    :ivar tenant_internet_gateway_ids: List of tenant InternetGateway resource IDs.
    :vartype tenant_internet_gateway_ids: list[str]
    :ivar ipv4_address_space: IPv4 Network Fabric Controller Address Space.
    :vartype ipv4_address_space: str
    :ivar ipv6_address_space: IPv6 Network Fabric Controller Address Space.
    :vartype ipv6_address_space: str
    :ivar nfc_sku: Network Fabric Controller SKU. Known values are: "Basic", "Standard", and
     "HighPerformance".
    :vartype nfc_sku: str or ~azure.mgmt.managednetworkfabric.models.NfcSku
    :ivar provisioning_state: Provides you the latest status of the NFC service, whether it is
     Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on
     the status of NFC provisioning. Known values are: "Accepted", "Succeeded", "Updating",
     "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "infrastructure_services": {"readonly": True},
        "workload_services": {"readonly": True},
        "network_fabric_ids": {"readonly": True},
        "workload_management_network": {"readonly": True},
        "tenant_internet_gateway_ids": {"readonly": True},
        "ipv4_address_space": {"min_length": 1},
        "ipv6_address_space": {"min_length": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "infrastructure_express_route_connections": {
            "key": "infrastructureExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "workload_express_route_connections": {
            "key": "workloadExpressRouteConnections",
            "type": "[ExpressRouteConnectionInformation]",
        },
        "annotation": {"key": "annotation", "type": "str"},
        "infrastructure_services": {"key": "infrastructureServices", "type": "ControllerServices"},
        "workload_services": {"key": "workloadServices", "type": "ControllerServices"},
        "managed_resource_group_configuration": {
            "key": "managedResourceGroupConfiguration",
            "type": "ManagedResourceGroupConfiguration",
        },
        "network_fabric_ids": {"key": "networkFabricIds", "type": "[str]"},
        "workload_management_network": {"key": "workloadManagementNetwork", "type": "bool"},
        "is_workload_management_network_enabled": {"key": "isWorkloadManagementNetworkEnabled", "type": "str"},
        "tenant_internet_gateway_ids": {"key": "tenantInternetGatewayIds", "type": "[str]"},
        "ipv4_address_space": {"key": "ipv4AddressSpace", "type": "str"},
        "ipv6_address_space": {"key": "ipv6AddressSpace", "type": "str"},
        "nfc_sku": {"key": "nfcSku", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        infrastructure_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        workload_express_route_connections: Optional[List["_models.ExpressRouteConnectionInformation"]] = None,
        annotation: Optional[str] = None,
        managed_resource_group_configuration: Optional["_models.ManagedResourceGroupConfiguration"] = None,
        is_workload_management_network_enabled: Union[str, "_models.IsWorkloadManagementNetworkEnabled"] = "True",
        ipv4_address_space: str = "10.0.0.0/19",
        ipv6_address_space: str = "FC00::/59",
        nfc_sku: Union[str, "_models.NfcSku"] = "Standard",
        **kwargs: Any
    ) -> None:
        """
        :keyword infrastructure_express_route_connections: As part of an update, the Infrastructure
         ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is
         dedicated for Infrastructure services. (This is a Mandatory attribute).
        :paramtype infrastructure_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword workload_express_route_connections: As part of an update, the workload ExpressRoute
         CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for
         Workload services. (This is a Mandatory attribute).
        :paramtype workload_express_route_connections:
         list[~azure.mgmt.managednetworkfabric.models.ExpressRouteConnectionInformation]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword managed_resource_group_configuration: Managed Resource Group configuration properties.
        :paramtype managed_resource_group_configuration:
         ~azure.mgmt.managednetworkfabric.models.ManagedResourceGroupConfiguration
        :keyword is_workload_management_network_enabled: A workload management network is required for
         all the tenant (workload) traffic. This traffic is only dedicated for Tenant workloads which
         are required to access internet or any other MSFT/Public endpoints. Known values are: "True"
         and "False".
        :paramtype is_workload_management_network_enabled: str or
         ~azure.mgmt.managednetworkfabric.models.IsWorkloadManagementNetworkEnabled
        :keyword ipv4_address_space: IPv4 Network Fabric Controller Address Space.
        :paramtype ipv4_address_space: str
        :keyword ipv6_address_space: IPv6 Network Fabric Controller Address Space.
        :paramtype ipv6_address_space: str
        :keyword nfc_sku: Network Fabric Controller SKU. Known values are: "Basic", "Standard", and
         "HighPerformance".
        :paramtype nfc_sku: str or ~azure.mgmt.managednetworkfabric.models.NfcSku
        """
        super().__init__(
            annotation=annotation,
            infrastructure_express_route_connections=infrastructure_express_route_connections,
            workload_express_route_connections=workload_express_route_connections,
            **kwargs
        )
        self.infrastructure_express_route_connections = infrastructure_express_route_connections
        self.workload_express_route_connections = workload_express_route_connections
        self.infrastructure_services = None
        self.workload_services = None
        self.managed_resource_group_configuration = managed_resource_group_configuration
        self.network_fabric_ids = None
        self.workload_management_network = None
        self.is_workload_management_network_enabled = is_workload_management_network_enabled
        self.tenant_internet_gateway_ids = None
        self.ipv4_address_space = ipv4_address_space
        self.ipv6_address_space = ipv6_address_space
        self.nfc_sku = nfc_sku
        self.provisioning_state = None
        self.annotation = annotation


class NetworkFabricControllersListResult(_serialization.Model):
    """List of Network Fabric Controllers.

    :ivar value: List of Network Fabric Controller resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabricController]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkFabricController]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkFabricController"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Network Fabric Controller resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabricController]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkFabricPatch(TagsUpdate):
    """The Network Fabric resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar rack_count: Number of compute racks associated to Network Fabric.
    :vartype rack_count: int
    :ivar server_count_per_rack: Number of servers.Possible values are from 1-16.
    :vartype server_count_per_rack: int
    :ivar ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19.
    :vartype ipv4_prefix: str
    :ivar ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
    :vartype ipv6_prefix: str
    :ivar fabric_asn: ASN of CE devices for CE/PE connectivity.
    :vartype fabric_asn: int
    :ivar terminal_server_configuration: Network and credentials configuration already applied to
     terminal server.
    :vartype terminal_server_configuration:
     ~azure.mgmt.managednetworkfabric.models.NetworkFabricPatchablePropertiesTerminalServerConfiguration
    :ivar management_network_configuration: Configuration to be used to setup the management
     network.
    :vartype management_network_configuration:
     ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfigurationPatchableProperties
    """

    _validation = {
        "rack_count": {"maximum": 8, "minimum": 1},
        "server_count_per_rack": {"maximum": 16, "minimum": 1},
        "ipv4_prefix": {"min_length": 1},
        "ipv6_prefix": {"min_length": 1},
        "fabric_asn": {"maximum": 4294967295, "minimum": 1},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "rack_count": {"key": "properties.rackCount", "type": "int"},
        "server_count_per_rack": {"key": "properties.serverCountPerRack", "type": "int"},
        "ipv4_prefix": {"key": "properties.ipv4Prefix", "type": "str"},
        "ipv6_prefix": {"key": "properties.ipv6Prefix", "type": "str"},
        "fabric_asn": {"key": "properties.fabricASN", "type": "int"},
        "terminal_server_configuration": {
            "key": "properties.terminalServerConfiguration",
            "type": "NetworkFabricPatchablePropertiesTerminalServerConfiguration",
        },
        "management_network_configuration": {
            "key": "properties.managementNetworkConfiguration",
            "type": "ManagementNetworkConfigurationPatchableProperties",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        rack_count: Optional[int] = None,
        server_count_per_rack: Optional[int] = None,
        ipv4_prefix: Optional[str] = None,
        ipv6_prefix: Optional[str] = None,
        fabric_asn: Optional[int] = None,
        terminal_server_configuration: Optional[
            "_models.NetworkFabricPatchablePropertiesTerminalServerConfiguration"
        ] = None,
        management_network_configuration: Optional["_models.ManagementNetworkConfigurationPatchableProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword rack_count: Number of compute racks associated to Network Fabric.
        :paramtype rack_count: int
        :keyword server_count_per_rack: Number of servers.Possible values are from 1-16.
        :paramtype server_count_per_rack: int
        :keyword ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19.
        :paramtype ipv4_prefix: str
        :keyword ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
        :paramtype ipv6_prefix: str
        :keyword fabric_asn: ASN of CE devices for CE/PE connectivity.
        :paramtype fabric_asn: int
        :keyword terminal_server_configuration: Network and credentials configuration already applied
         to terminal server.
        :paramtype terminal_server_configuration:
         ~azure.mgmt.managednetworkfabric.models.NetworkFabricPatchablePropertiesTerminalServerConfiguration
        :keyword management_network_configuration: Configuration to be used to setup the management
         network.
        :paramtype management_network_configuration:
         ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfigurationPatchableProperties
        """
        super().__init__(tags=tags, **kwargs)
        self.annotation = annotation
        self.rack_count = rack_count
        self.server_count_per_rack = server_count_per_rack
        self.ipv4_prefix = ipv4_prefix
        self.ipv6_prefix = ipv6_prefix
        self.fabric_asn = fabric_asn
        self.terminal_server_configuration = terminal_server_configuration
        self.management_network_configuration = management_network_configuration


class NetworkFabricPatchableProperties(_serialization.Model):
    """Network Fabric updatable properties.

    :ivar rack_count: Number of compute racks associated to Network Fabric.
    :vartype rack_count: int
    :ivar server_count_per_rack: Number of servers.Possible values are from 1-16.
    :vartype server_count_per_rack: int
    :ivar ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19.
    :vartype ipv4_prefix: str
    :ivar ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
    :vartype ipv6_prefix: str
    :ivar fabric_asn: ASN of CE devices for CE/PE connectivity.
    :vartype fabric_asn: int
    :ivar terminal_server_configuration: Network and credentials configuration already applied to
     terminal server.
    :vartype terminal_server_configuration:
     ~azure.mgmt.managednetworkfabric.models.NetworkFabricPatchablePropertiesTerminalServerConfiguration
    :ivar management_network_configuration: Configuration to be used to setup the management
     network.
    :vartype management_network_configuration:
     ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfigurationPatchableProperties
    """

    _validation = {
        "rack_count": {"maximum": 8, "minimum": 1},
        "server_count_per_rack": {"maximum": 16, "minimum": 1},
        "ipv4_prefix": {"min_length": 1},
        "ipv6_prefix": {"min_length": 1},
        "fabric_asn": {"maximum": 4294967295, "minimum": 1},
    }

    _attribute_map = {
        "rack_count": {"key": "rackCount", "type": "int"},
        "server_count_per_rack": {"key": "serverCountPerRack", "type": "int"},
        "ipv4_prefix": {"key": "ipv4Prefix", "type": "str"},
        "ipv6_prefix": {"key": "ipv6Prefix", "type": "str"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "terminal_server_configuration": {
            "key": "terminalServerConfiguration",
            "type": "NetworkFabricPatchablePropertiesTerminalServerConfiguration",
        },
        "management_network_configuration": {
            "key": "managementNetworkConfiguration",
            "type": "ManagementNetworkConfigurationPatchableProperties",
        },
    }

    def __init__(
        self,
        *,
        rack_count: Optional[int] = None,
        server_count_per_rack: Optional[int] = None,
        ipv4_prefix: Optional[str] = None,
        ipv6_prefix: Optional[str] = None,
        fabric_asn: Optional[int] = None,
        terminal_server_configuration: Optional[
            "_models.NetworkFabricPatchablePropertiesTerminalServerConfiguration"
        ] = None,
        management_network_configuration: Optional["_models.ManagementNetworkConfigurationPatchableProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rack_count: Number of compute racks associated to Network Fabric.
        :paramtype rack_count: int
        :keyword server_count_per_rack: Number of servers.Possible values are from 1-16.
        :paramtype server_count_per_rack: int
        :keyword ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19.
        :paramtype ipv4_prefix: str
        :keyword ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
        :paramtype ipv6_prefix: str
        :keyword fabric_asn: ASN of CE devices for CE/PE connectivity.
        :paramtype fabric_asn: int
        :keyword terminal_server_configuration: Network and credentials configuration already applied
         to terminal server.
        :paramtype terminal_server_configuration:
         ~azure.mgmt.managednetworkfabric.models.NetworkFabricPatchablePropertiesTerminalServerConfiguration
        :keyword management_network_configuration: Configuration to be used to setup the management
         network.
        :paramtype management_network_configuration:
         ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfigurationPatchableProperties
        """
        super().__init__(**kwargs)
        self.rack_count = rack_count
        self.server_count_per_rack = server_count_per_rack
        self.ipv4_prefix = ipv4_prefix
        self.ipv6_prefix = ipv6_prefix
        self.fabric_asn = fabric_asn
        self.terminal_server_configuration = terminal_server_configuration
        self.management_network_configuration = management_network_configuration


class TerminalServerPatchableProperties(_serialization.Model):
    """Network and credential configuration currently applied on terminal server.

    :ivar username: Username for the terminal server connection.
    :vartype username: str
    :ivar password: Password for the terminal server connection.
    :vartype password: str
    :ivar serial_number: Serial Number of Terminal server.
    :vartype serial_number: str
    """

    _validation = {
        "username": {"min_length": 1},
        "password": {"min_length": 1},
        "serial_number": {"min_length": 1},
    }

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        password: Optional[str] = None,
        serial_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword username: Username for the terminal server connection.
        :paramtype username: str
        :keyword password: Password for the terminal server connection.
        :paramtype password: str
        :keyword serial_number: Serial Number of Terminal server.
        :paramtype serial_number: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password
        self.serial_number = serial_number


class NetworkFabricPatchablePropertiesTerminalServerConfiguration(
    TerminalServerPatchableProperties, Layer3IpPrefixProperties
):
    """Network and credentials configuration already applied to terminal server.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
    :vartype secondary_ipv6_prefix: str
    :ivar username: Username for the terminal server connection.
    :vartype username: str
    :ivar password: Password for the terminal server connection.
    :vartype password: str
    :ivar serial_number: Serial Number of Terminal server.
    :vartype serial_number: str
    """

    _validation = {
        "username": {"min_length": 1},
        "password": {"min_length": 1},
        "serial_number": {"min_length": 1},
    }

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        serial_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
        :paramtype secondary_ipv6_prefix: str
        :keyword username: Username for the terminal server connection.
        :paramtype username: str
        :keyword password: Password for the terminal server connection.
        :paramtype password: str
        :keyword serial_number: Serial Number of Terminal server.
        :paramtype serial_number: str
        """
        super().__init__(
            username=username,
            password=password,
            serial_number=serial_number,
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            **kwargs
        )
        self.primary_ipv4_prefix = primary_ipv4_prefix
        self.primary_ipv6_prefix = primary_ipv6_prefix
        self.secondary_ipv4_prefix = secondary_ipv4_prefix
        self.secondary_ipv6_prefix = secondary_ipv6_prefix
        self.username = username
        self.password = password
        self.serial_number = serial_number


class NetworkFabricPatchProperties(AnnotationResource, NetworkFabricPatchableProperties):
    """Network Fabric Patch properties.

    :ivar rack_count: Number of compute racks associated to Network Fabric.
    :vartype rack_count: int
    :ivar server_count_per_rack: Number of servers.Possible values are from 1-16.
    :vartype server_count_per_rack: int
    :ivar ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19.
    :vartype ipv4_prefix: str
    :ivar ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
    :vartype ipv6_prefix: str
    :ivar fabric_asn: ASN of CE devices for CE/PE connectivity.
    :vartype fabric_asn: int
    :ivar terminal_server_configuration: Network and credentials configuration already applied to
     terminal server.
    :vartype terminal_server_configuration:
     ~azure.mgmt.managednetworkfabric.models.NetworkFabricPatchablePropertiesTerminalServerConfiguration
    :ivar management_network_configuration: Configuration to be used to setup the management
     network.
    :vartype management_network_configuration:
     ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfigurationPatchableProperties
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _validation = {
        "rack_count": {"maximum": 8, "minimum": 1},
        "server_count_per_rack": {"maximum": 16, "minimum": 1},
        "ipv4_prefix": {"min_length": 1},
        "ipv6_prefix": {"min_length": 1},
        "fabric_asn": {"maximum": 4294967295, "minimum": 1},
    }

    _attribute_map = {
        "rack_count": {"key": "rackCount", "type": "int"},
        "server_count_per_rack": {"key": "serverCountPerRack", "type": "int"},
        "ipv4_prefix": {"key": "ipv4Prefix", "type": "str"},
        "ipv6_prefix": {"key": "ipv6Prefix", "type": "str"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "terminal_server_configuration": {
            "key": "terminalServerConfiguration",
            "type": "NetworkFabricPatchablePropertiesTerminalServerConfiguration",
        },
        "management_network_configuration": {
            "key": "managementNetworkConfiguration",
            "type": "ManagementNetworkConfigurationPatchableProperties",
        },
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        rack_count: Optional[int] = None,
        server_count_per_rack: Optional[int] = None,
        ipv4_prefix: Optional[str] = None,
        ipv6_prefix: Optional[str] = None,
        fabric_asn: Optional[int] = None,
        terminal_server_configuration: Optional[
            "_models.NetworkFabricPatchablePropertiesTerminalServerConfiguration"
        ] = None,
        management_network_configuration: Optional["_models.ManagementNetworkConfigurationPatchableProperties"] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rack_count: Number of compute racks associated to Network Fabric.
        :paramtype rack_count: int
        :keyword server_count_per_rack: Number of servers.Possible values are from 1-16.
        :paramtype server_count_per_rack: int
        :keyword ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19.
        :paramtype ipv4_prefix: str
        :keyword ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
        :paramtype ipv6_prefix: str
        :keyword fabric_asn: ASN of CE devices for CE/PE connectivity.
        :paramtype fabric_asn: int
        :keyword terminal_server_configuration: Network and credentials configuration already applied
         to terminal server.
        :paramtype terminal_server_configuration:
         ~azure.mgmt.managednetworkfabric.models.NetworkFabricPatchablePropertiesTerminalServerConfiguration
        :keyword management_network_configuration: Configuration to be used to setup the management
         network.
        :paramtype management_network_configuration:
         ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfigurationPatchableProperties
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(
            annotation=annotation,
            rack_count=rack_count,
            server_count_per_rack=server_count_per_rack,
            ipv4_prefix=ipv4_prefix,
            ipv6_prefix=ipv6_prefix,
            fabric_asn=fabric_asn,
            terminal_server_configuration=terminal_server_configuration,
            management_network_configuration=management_network_configuration,
            **kwargs
        )
        self.rack_count = rack_count
        self.server_count_per_rack = server_count_per_rack
        self.ipv4_prefix = ipv4_prefix
        self.ipv6_prefix = ipv6_prefix
        self.fabric_asn = fabric_asn
        self.terminal_server_configuration = terminal_server_configuration
        self.management_network_configuration = management_network_configuration
        self.annotation = annotation


class NetworkFabricProperties(AnnotationResource):  # pylint: disable=too-many-instance-attributes
    """Network Fabric Properties defines the properties of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_fabric_sku: Supported Network Fabric SKU.Example: Compute / Aggregate racks. Once
     the user chooses a particular SKU, only supported racks can be added to the Network Fabric. The
     SKU determines whether it is a single / multi rack Network Fabric. Required.
    :vartype network_fabric_sku: str
    :ivar fabric_version: The version of Network Fabric.
    :vartype fabric_version: str
    :ivar router_ids: Array of router IDs.
    :vartype router_ids: list[str]
    :ivar network_fabric_controller_id: Azure resource ID for the NetworkFabricController the
     NetworkFabric belongs. Required.
    :vartype network_fabric_controller_id: str
    :ivar rack_count: Number of compute racks associated to Network Fabric.
    :vartype rack_count: int
    :ivar server_count_per_rack: Number of servers.Possible values are from 1-16. Required.
    :vartype server_count_per_rack: int
    :ivar ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19. Required.
    :vartype ipv4_prefix: str
    :ivar ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
    :vartype ipv6_prefix: str
    :ivar fabric_asn: ASN of CE devices for CE/PE connectivity. Required.
    :vartype fabric_asn: int
    :ivar terminal_server_configuration: Network and credentials configuration currently applied to
     terminal server. Required.
    :vartype terminal_server_configuration:
     ~azure.mgmt.managednetworkfabric.models.TerminalServerConfiguration
    :ivar management_network_configuration: Configuration to be used to setup the management
     network. Required.
    :vartype management_network_configuration:
     ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfigurationProperties
    :ivar racks: List of NetworkRack resource IDs under the Network Fabric. The number of racks
     allowed depends on the Network Fabric SKU.
    :vartype racks: list[str]
    :ivar l2_isolation_domains: List of L2 Isolation Domain resource IDs under the Network Fabric.
    :vartype l2_isolation_domains: list[str]
    :ivar l3_isolation_domains: List of L3 Isolation Domain resource IDs under the Network Fabric.
    :vartype l3_isolation_domains: list[str]
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provides you the latest status of the NFC service, whether it is
     Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on
     the status of NFC provisioning. Known values are: "Accepted", "Succeeded", "Updating",
     "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "network_fabric_sku": {"required": True, "min_length": 1},
        "fabric_version": {"readonly": True},
        "router_ids": {"readonly": True},
        "network_fabric_controller_id": {"required": True},
        "rack_count": {"maximum": 8, "minimum": 1},
        "server_count_per_rack": {"required": True, "maximum": 16, "minimum": 1},
        "ipv4_prefix": {"required": True, "min_length": 1},
        "ipv6_prefix": {"min_length": 1},
        "fabric_asn": {"required": True, "maximum": 4294967295, "minimum": 1},
        "terminal_server_configuration": {"required": True},
        "management_network_configuration": {"required": True},
        "racks": {"readonly": True},
        "l2_isolation_domains": {"readonly": True},
        "l3_isolation_domains": {"readonly": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "network_fabric_sku": {"key": "networkFabricSku", "type": "str"},
        "fabric_version": {"key": "fabricVersion", "type": "str"},
        "router_ids": {"key": "routerIds", "type": "[str]"},
        "network_fabric_controller_id": {"key": "networkFabricControllerId", "type": "str"},
        "rack_count": {"key": "rackCount", "type": "int"},
        "server_count_per_rack": {"key": "serverCountPerRack", "type": "int"},
        "ipv4_prefix": {"key": "ipv4Prefix", "type": "str"},
        "ipv6_prefix": {"key": "ipv6Prefix", "type": "str"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
        "terminal_server_configuration": {"key": "terminalServerConfiguration", "type": "TerminalServerConfiguration"},
        "management_network_configuration": {
            "key": "managementNetworkConfiguration",
            "type": "ManagementNetworkConfigurationProperties",
        },
        "racks": {"key": "racks", "type": "[str]"},
        "l2_isolation_domains": {"key": "l2IsolationDomains", "type": "[str]"},
        "l3_isolation_domains": {"key": "l3IsolationDomains", "type": "[str]"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_fabric_sku: str,
        network_fabric_controller_id: str,
        server_count_per_rack: int,
        ipv4_prefix: str,
        fabric_asn: int,
        terminal_server_configuration: "_models.TerminalServerConfiguration",
        management_network_configuration: "_models.ManagementNetworkConfigurationProperties",
        annotation: Optional[str] = None,
        rack_count: Optional[int] = None,
        ipv6_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_fabric_sku: Supported Network Fabric SKU.Example: Compute / Aggregate racks.
         Once the user chooses a particular SKU, only supported racks can be added to the Network
         Fabric. The SKU determines whether it is a single / multi rack Network Fabric. Required.
        :paramtype network_fabric_sku: str
        :keyword network_fabric_controller_id: Azure resource ID for the NetworkFabricController the
         NetworkFabric belongs. Required.
        :paramtype network_fabric_controller_id: str
        :keyword rack_count: Number of compute racks associated to Network Fabric.
        :paramtype rack_count: int
        :keyword server_count_per_rack: Number of servers.Possible values are from 1-16. Required.
        :paramtype server_count_per_rack: int
        :keyword ipv4_prefix: IPv4Prefix for Management Network. Example: 10.1.0.0/19. Required.
        :paramtype ipv4_prefix: str
        :keyword ipv6_prefix: IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
        :paramtype ipv6_prefix: str
        :keyword fabric_asn: ASN of CE devices for CE/PE connectivity. Required.
        :paramtype fabric_asn: int
        :keyword terminal_server_configuration: Network and credentials configuration currently applied
         to terminal server. Required.
        :paramtype terminal_server_configuration:
         ~azure.mgmt.managednetworkfabric.models.TerminalServerConfiguration
        :keyword management_network_configuration: Configuration to be used to setup the management
         network. Required.
        :paramtype management_network_configuration:
         ~azure.mgmt.managednetworkfabric.models.ManagementNetworkConfigurationProperties
        """
        super().__init__(annotation=annotation, **kwargs)
        self.network_fabric_sku = network_fabric_sku
        self.fabric_version = None
        self.router_ids = None
        self.network_fabric_controller_id = network_fabric_controller_id
        self.rack_count = rack_count
        self.server_count_per_rack = server_count_per_rack
        self.ipv4_prefix = ipv4_prefix
        self.ipv6_prefix = ipv6_prefix
        self.fabric_asn = fabric_asn
        self.terminal_server_configuration = terminal_server_configuration
        self.management_network_configuration = management_network_configuration
        self.racks = None
        self.l2_isolation_domains = None
        self.l3_isolation_domains = None
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class NetworkFabricSku(ProxyResource):
    """The Network Fabric SKU resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar type_properties_type: Type of Network Fabric SKU. Known values are: "SingleRack" and
     "MultiRack".
    :vartype type_properties_type: str or ~azure.mgmt.managednetworkfabric.models.FabricSkuType
    :ivar max_compute_racks: Maximum number of compute racks available for this Network Fabric SKU.
     The value of max count racks is 4 for 4 rack SKU and 8 for 8 rack SKU.
    :vartype max_compute_racks: int
    :ivar maximum_server_count: Maximum number of servers available for this Network Fabric SKU.
    :vartype maximum_server_count: int
    :ivar supported_versions: List of supported Network Fabric SKU versions.
    :vartype supported_versions: list[str]
    :ivar details: URL providing detailed configuration of the fabric SKU.
    :vartype details: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "type_properties_type": {"readonly": True},
        "supported_versions": {"readonly": True},
        "details": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "max_compute_racks": {"key": "properties.maxComputeRacks", "type": "int"},
        "maximum_server_count": {"key": "properties.maximumServerCount", "type": "int"},
        "supported_versions": {"key": "properties.supportedVersions", "type": "[str]"},
        "details": {"key": "properties.details", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, max_compute_racks: Optional[int] = None, maximum_server_count: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword max_compute_racks: Maximum number of compute racks available for this Network Fabric
         SKU. The value of max count racks is 4 for 4 rack SKU and 8 for 8 rack SKU.
        :paramtype max_compute_racks: int
        :keyword maximum_server_count: Maximum number of servers available for this Network Fabric SKU.
        :paramtype maximum_server_count: int
        """
        super().__init__(**kwargs)
        self.type_properties_type = None
        self.max_compute_racks = max_compute_racks
        self.maximum_server_count = maximum_server_count
        self.supported_versions = None
        self.details = None
        self.provisioning_state = None


class NetworkFabricSkusListResult(_serialization.Model):
    """List of Network Fabric SKUs.

    :ivar value: List of Network Fabric SKU resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabricSku]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkFabricSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkFabricSku"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Network Fabric SKU resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabricSku]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkFabricsListResult(_serialization.Model):
    """List of Network Fabrics.

    :ivar value: List of Network Fabric resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabric]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkFabric]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkFabric"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Network Fabric resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkFabric]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkInterface(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Defines the NetworkInterface resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar physical_identifier: Physical Identifier of the network interface.
    :vartype physical_identifier: str
    :ivar connected_to: The ARM resource id of the interface or compute server its connected to.
    :vartype connected_to: str
    :ivar interface_type: The Interface Type. Example: Management/Data. Known values are:
     "Management" and "Data".
    :vartype interface_type: str or ~azure.mgmt.managednetworkfabric.models.InterfaceType
    :ivar ipv4_address: IPv4Address of the interface.
    :vartype ipv4_address: str
    :ivar ipv6_address: IPv6Address of the interface.
    :vartype ipv6_address: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "physical_identifier": {"readonly": True},
        "connected_to": {"readonly": True},
        "interface_type": {"readonly": True},
        "ipv4_address": {"readonly": True},
        "ipv6_address": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "physical_identifier": {"key": "properties.physicalIdentifier", "type": "str"},
        "connected_to": {"key": "properties.connectedTo", "type": "str"},
        "interface_type": {"key": "properties.interfaceType", "type": "str"},
        "ipv4_address": {"key": "properties.ipv4Address", "type": "str"},
        "ipv6_address": {"key": "properties.ipv6Address", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(self, *, annotation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(**kwargs)
        self.annotation = annotation
        self.physical_identifier = None
        self.connected_to = None
        self.interface_type = None
        self.ipv4_address = None
        self.ipv6_address = None
        self.provisioning_state = None
        self.administrative_state = None


class NetworkInterfacePatch(_serialization.Model):
    """The NetworkInterfacePatch resource definition.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "annotation": {"key": "properties.annotation", "type": "str"},
    }

    def __init__(self, *, annotation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(**kwargs)
        self.annotation = annotation


class NetworkInterfacePatchProperties(AnnotationResource):
    """Network Interface Patch properties.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(self, *, annotation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, **kwargs)


class NetworkInterfaceProperties(AnnotationResource):
    """Network Interface Properties defines the properties of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar physical_identifier: Physical Identifier of the network interface.
    :vartype physical_identifier: str
    :ivar connected_to: The ARM resource id of the interface or compute server its connected to.
    :vartype connected_to: str
    :ivar interface_type: The Interface Type. Example: Management/Data. Known values are:
     "Management" and "Data".
    :vartype interface_type: str or ~azure.mgmt.managednetworkfabric.models.InterfaceType
    :ivar ipv4_address: IPv4Address of the interface.
    :vartype ipv4_address: str
    :ivar ipv6_address: IPv6Address of the interface.
    :vartype ipv6_address: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "physical_identifier": {"readonly": True},
        "connected_to": {"readonly": True},
        "interface_type": {"readonly": True},
        "ipv4_address": {"readonly": True},
        "ipv6_address": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "physical_identifier": {"key": "physicalIdentifier", "type": "str"},
        "connected_to": {"key": "connectedTo", "type": "str"},
        "interface_type": {"key": "interfaceType", "type": "str"},
        "ipv4_address": {"key": "ipv4Address", "type": "str"},
        "ipv6_address": {"key": "ipv6Address", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(self, *, annotation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(annotation=annotation, **kwargs)
        self.physical_identifier = None
        self.connected_to = None
        self.interface_type = None
        self.ipv4_address = None
        self.ipv6_address = None
        self.provisioning_state = None
        self.administrative_state = None


class NetworkInterfacesList(_serialization.Model):
    """List of NetworkInterfaces.

    :ivar value: List of NetworkInterfaces resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkInterface]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterface]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkInterface"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkInterfaces resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkInterface]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkPacketBroker(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The NetworkPacketBroker resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar network_fabric_id: ARM resource ID of the Network Fabric. Required.
    :vartype network_fabric_id: str
    :ivar network_device_ids: List of ARM resource IDs of Network Devices [NPB].
    :vartype network_device_ids: list[str]
    :ivar source_interface_ids: List of network interfaces across NPB devices that are used to
     mirror source traffic.
    :vartype source_interface_ids: list[str]
    :ivar network_tap_ids: List of network Tap IDs configured on NPB.
    :vartype network_tap_ids: list[str]
    :ivar neighbor_group_ids: List of neighbor group IDs configured on NPB.
    :vartype neighbor_group_ids: list[str]
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "network_fabric_id": {"required": True},
        "network_device_ids": {"readonly": True},
        "source_interface_ids": {"readonly": True},
        "network_tap_ids": {"readonly": True},
        "neighbor_group_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "network_fabric_id": {"key": "properties.networkFabricId", "type": "str"},
        "network_device_ids": {"key": "properties.networkDeviceIds", "type": "[str]"},
        "source_interface_ids": {"key": "properties.sourceInterfaceIds", "type": "[str]"},
        "network_tap_ids": {"key": "properties.networkTapIds", "type": "[str]"},
        "neighbor_group_ids": {"key": "properties.neighborGroupIds", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, location: str, network_fabric_id: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword network_fabric_id: ARM resource ID of the Network Fabric. Required.
        :paramtype network_fabric_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.network_fabric_id = network_fabric_id
        self.network_device_ids = None
        self.source_interface_ids = None
        self.network_tap_ids = None
        self.neighbor_group_ids = None
        self.provisioning_state = None


class NetworkPacketBrokerPatch(TagsUpdate):
    """The NetworkPacketBroker patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(tags=tags, **kwargs)


class NetworkPacketBrokersListResult(_serialization.Model):
    """List of NetworkPacketBrokers.

    :ivar value: List of NetworkPacketBroker resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkPacketBroker]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkPacketBroker]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkPacketBroker"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkPacketBroker resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkPacketBroker]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkRack(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The Network Rack resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_rack_type: Network Rack SKU name. Known values are: "Aggregate", "Compute", and
     "Combined".
    :vartype network_rack_type: str or ~azure.mgmt.managednetworkfabric.models.NetworkRackType
    :ivar network_fabric_id: ARM resource ID of the Network Fabric. Required.
    :vartype network_fabric_id: str
    :ivar network_devices: List of network device ARM resource IDs.
    :vartype network_devices: list[str]
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "network_fabric_id": {"required": True},
        "network_devices": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "network_rack_type": {"key": "properties.networkRackType", "type": "str"},
        "network_fabric_id": {"key": "properties.networkFabricId", "type": "str"},
        "network_devices": {"key": "properties.networkDevices", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        network_fabric_id: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        network_rack_type: Optional[Union[str, "_models.NetworkRackType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_rack_type: Network Rack SKU name. Known values are: "Aggregate", "Compute",
         and "Combined".
        :paramtype network_rack_type: str or ~azure.mgmt.managednetworkfabric.models.NetworkRackType
        :keyword network_fabric_id: ARM resource ID of the Network Fabric. Required.
        :paramtype network_fabric_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.network_rack_type = network_rack_type
        self.network_fabric_id = network_fabric_id
        self.network_devices = None
        self.provisioning_state = None


class NetworkRackProperties(AnnotationResource):
    """Network Rack Properties defines the properties of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_rack_type: Network Rack SKU name. Known values are: "Aggregate", "Compute", and
     "Combined".
    :vartype network_rack_type: str or ~azure.mgmt.managednetworkfabric.models.NetworkRackType
    :ivar network_fabric_id: ARM resource ID of the Network Fabric. Required.
    :vartype network_fabric_id: str
    :ivar network_devices: List of network device ARM resource IDs.
    :vartype network_devices: list[str]
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    """

    _validation = {
        "network_fabric_id": {"required": True},
        "network_devices": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "network_rack_type": {"key": "networkRackType", "type": "str"},
        "network_fabric_id": {"key": "networkFabricId", "type": "str"},
        "network_devices": {"key": "networkDevices", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_fabric_id: str,
        annotation: Optional[str] = None,
        network_rack_type: Optional[Union[str, "_models.NetworkRackType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_rack_type: Network Rack SKU name. Known values are: "Aggregate", "Compute",
         and "Combined".
        :paramtype network_rack_type: str or ~azure.mgmt.managednetworkfabric.models.NetworkRackType
        :keyword network_fabric_id: ARM resource ID of the Network Fabric. Required.
        :paramtype network_fabric_id: str
        """
        super().__init__(annotation=annotation, **kwargs)
        self.network_rack_type = network_rack_type
        self.network_fabric_id = network_fabric_id
        self.network_devices = None
        self.provisioning_state = None


class NetworkRacksListResult(_serialization.Model):
    """List of Network Racks.

    :ivar value: List of Network Rack resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkRack]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkRack]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkRack"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Network Rack resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkRack]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkTap(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The Network Tap resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_packet_broker_id: ARM resource ID of the Network Packet Broker. Required.
    :vartype network_packet_broker_id: str
    :ivar source_tap_rule_id: Source Tap Rule Id. ARM Resource ID of the Network Tap Rule.
    :vartype source_tap_rule_id: str
    :ivar destinations: List of destinations to send the filter traffic. Required.
    :vartype destinations:
     list[~azure.mgmt.managednetworkfabric.models.NetworkTapPropertiesDestinationsItem]
    :ivar polling_type: Polling type. Known values are: "Pull" and "Push".
    :vartype polling_type: str or ~azure.mgmt.managednetworkfabric.models.PollingType
    :ivar configuration_state: Gets the configurations state of the resource. Known values are:
     "Succeeded", "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning",
     "Deprovisioning", "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provides you the latest status of the NFC service, whether it is
     Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on
     the status of Network Tap provisioning. Known values are: "Accepted", "Succeeded", "Updating",
     "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Example -Enabled/Disabled.
     Known values are: "Enabled", "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "network_packet_broker_id": {"required": True},
        "source_tap_rule_id": {"readonly": True},
        "destinations": {"required": True, "min_items": 1},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "network_packet_broker_id": {"key": "properties.networkPacketBrokerId", "type": "str"},
        "source_tap_rule_id": {"key": "properties.sourceTapRuleId", "type": "str"},
        "destinations": {"key": "properties.destinations", "type": "[NetworkTapPropertiesDestinationsItem]"},
        "polling_type": {"key": "properties.pollingType", "type": "str"},
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        network_packet_broker_id: str,
        destinations: List["_models.NetworkTapPropertiesDestinationsItem"],
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        polling_type: Optional[Union[str, "_models.PollingType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_packet_broker_id: ARM resource ID of the Network Packet Broker. Required.
        :paramtype network_packet_broker_id: str
        :keyword destinations: List of destinations to send the filter traffic. Required.
        :paramtype destinations:
         list[~azure.mgmt.managednetworkfabric.models.NetworkTapPropertiesDestinationsItem]
        :keyword polling_type: Polling type. Known values are: "Pull" and "Push".
        :paramtype polling_type: str or ~azure.mgmt.managednetworkfabric.models.PollingType
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.network_packet_broker_id = network_packet_broker_id
        self.source_tap_rule_id = None
        self.destinations = destinations
        self.polling_type = polling_type
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class NetworkTapPatch(TagsUpdate):
    """The NetworkFabric resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar polling_type: Polling type. Known values are: "Pull" and "Push".
    :vartype polling_type: str or ~azure.mgmt.managednetworkfabric.models.PollingType
    :ivar destinations: List of destination properties to send the filter traffic.
    :vartype destinations:
     list[~azure.mgmt.managednetworkfabric.models.NetworkTapPatchableParametersDestinationsItem]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "polling_type": {"key": "properties.pollingType", "type": "str"},
        "destinations": {"key": "properties.destinations", "type": "[NetworkTapPatchableParametersDestinationsItem]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        polling_type: Optional[Union[str, "_models.PollingType"]] = None,
        destinations: Optional[List["_models.NetworkTapPatchableParametersDestinationsItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword polling_type: Polling type. Known values are: "Pull" and "Push".
        :paramtype polling_type: str or ~azure.mgmt.managednetworkfabric.models.PollingType
        :keyword destinations: List of destination properties to send the filter traffic.
        :paramtype destinations:
         list[~azure.mgmt.managednetworkfabric.models.NetworkTapPatchableParametersDestinationsItem]
        """
        super().__init__(tags=tags, **kwargs)
        self.annotation = annotation
        self.polling_type = polling_type
        self.destinations = destinations


class NetworkTapPatchableParameters(AnnotationResource):
    """The Network Tap resource patch definition.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar polling_type: Polling type. Known values are: "Pull" and "Push".
    :vartype polling_type: str or ~azure.mgmt.managednetworkfabric.models.PollingType
    :ivar destinations: List of destination properties to send the filter traffic.
    :vartype destinations:
     list[~azure.mgmt.managednetworkfabric.models.NetworkTapPatchableParametersDestinationsItem]
    """

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "polling_type": {"key": "pollingType", "type": "str"},
        "destinations": {"key": "destinations", "type": "[NetworkTapPatchableParametersDestinationsItem]"},
    }

    def __init__(
        self,
        *,
        annotation: Optional[str] = None,
        polling_type: Optional[Union[str, "_models.PollingType"]] = None,
        destinations: Optional[List["_models.NetworkTapPatchableParametersDestinationsItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword polling_type: Polling type. Known values are: "Pull" and "Push".
        :paramtype polling_type: str or ~azure.mgmt.managednetworkfabric.models.PollingType
        :keyword destinations: List of destination properties to send the filter traffic.
        :paramtype destinations:
         list[~azure.mgmt.managednetworkfabric.models.NetworkTapPatchableParametersDestinationsItem]
        """
        super().__init__(annotation=annotation, **kwargs)
        self.polling_type = polling_type
        self.destinations = destinations


class NetworkTapPatchableParametersDestinationsItem(DestinationProperties):
    """Destination.

    :ivar name: Destination name.
    :vartype name: str
    :ivar destination_type: Type of destination. Input can be IsolationDomain or Direct. Known
     values are: "IsolationDomain" and "Direct".
    :vartype destination_type: str or ~azure.mgmt.managednetworkfabric.models.DestinationType
    :ivar destination_id: The destination Id. ARM Resource ID of either NNI or Internal Networks.
    :vartype destination_id: str
    :ivar isolation_domain_properties: Isolation Domain Properties.
    :vartype isolation_domain_properties:
     ~azure.mgmt.managednetworkfabric.models.IsolationDomainProperties
    :ivar destination_tap_rule_id: ARM Resource ID of destination Tap Rule that contains match
     configurations.
    :vartype destination_tap_rule_id: str
    """

    _validation = {
        "name": {"min_length": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "destination_type": {"key": "destinationType", "type": "str"},
        "destination_id": {"key": "destinationId", "type": "str"},
        "isolation_domain_properties": {"key": "isolationDomainProperties", "type": "IsolationDomainProperties"},
        "destination_tap_rule_id": {"key": "destinationTapRuleId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        destination_type: Optional[Union[str, "_models.DestinationType"]] = None,
        destination_id: Optional[str] = None,
        isolation_domain_properties: Optional["_models.IsolationDomainProperties"] = None,
        destination_tap_rule_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Destination name.
        :paramtype name: str
        :keyword destination_type: Type of destination. Input can be IsolationDomain or Direct. Known
         values are: "IsolationDomain" and "Direct".
        :paramtype destination_type: str or ~azure.mgmt.managednetworkfabric.models.DestinationType
        :keyword destination_id: The destination Id. ARM Resource ID of either NNI or Internal
         Networks.
        :paramtype destination_id: str
        :keyword isolation_domain_properties: Isolation Domain Properties.
        :paramtype isolation_domain_properties:
         ~azure.mgmt.managednetworkfabric.models.IsolationDomainProperties
        :keyword destination_tap_rule_id: ARM Resource ID of destination Tap Rule that contains match
         configurations.
        :paramtype destination_tap_rule_id: str
        """
        super().__init__(
            name=name,
            destination_type=destination_type,
            destination_id=destination_id,
            isolation_domain_properties=isolation_domain_properties,
            destination_tap_rule_id=destination_tap_rule_id,
            **kwargs
        )


class NetworkTapProperties(AnnotationResource):
    """Network Tap Properties defines the properties of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_packet_broker_id: ARM resource ID of the Network Packet Broker. Required.
    :vartype network_packet_broker_id: str
    :ivar source_tap_rule_id: Source Tap Rule Id. ARM Resource ID of the Network Tap Rule.
    :vartype source_tap_rule_id: str
    :ivar destinations: List of destinations to send the filter traffic. Required.
    :vartype destinations:
     list[~azure.mgmt.managednetworkfabric.models.NetworkTapPropertiesDestinationsItem]
    :ivar polling_type: Polling type. Known values are: "Pull" and "Push".
    :vartype polling_type: str or ~azure.mgmt.managednetworkfabric.models.PollingType
    :ivar configuration_state: Gets the configurations state of the resource. Known values are:
     "Succeeded", "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning",
     "Deprovisioning", "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provides you the latest status of the NFC service, whether it is
     Accepted, updating, Succeeded or Failed. During this process, the states keep changing based on
     the status of Network Tap provisioning. Known values are: "Accepted", "Succeeded", "Updating",
     "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Example -Enabled/Disabled.
     Known values are: "Enabled", "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "network_packet_broker_id": {"required": True},
        "source_tap_rule_id": {"readonly": True},
        "destinations": {"required": True, "min_items": 1},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "network_packet_broker_id": {"key": "networkPacketBrokerId", "type": "str"},
        "source_tap_rule_id": {"key": "sourceTapRuleId", "type": "str"},
        "destinations": {"key": "destinations", "type": "[NetworkTapPropertiesDestinationsItem]"},
        "polling_type": {"key": "pollingType", "type": "str"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_packet_broker_id: str,
        destinations: List["_models.NetworkTapPropertiesDestinationsItem"],
        annotation: Optional[str] = None,
        polling_type: Optional[Union[str, "_models.PollingType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_packet_broker_id: ARM resource ID of the Network Packet Broker. Required.
        :paramtype network_packet_broker_id: str
        :keyword destinations: List of destinations to send the filter traffic. Required.
        :paramtype destinations:
         list[~azure.mgmt.managednetworkfabric.models.NetworkTapPropertiesDestinationsItem]
        :keyword polling_type: Polling type. Known values are: "Pull" and "Push".
        :paramtype polling_type: str or ~azure.mgmt.managednetworkfabric.models.PollingType
        """
        super().__init__(annotation=annotation, **kwargs)
        self.network_packet_broker_id = network_packet_broker_id
        self.source_tap_rule_id = None
        self.destinations = destinations
        self.polling_type = polling_type
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class NetworkTapPropertiesDestinationsItem(DestinationProperties):
    """Destination.

    :ivar name: Destination name.
    :vartype name: str
    :ivar destination_type: Type of destination. Input can be IsolationDomain or Direct. Known
     values are: "IsolationDomain" and "Direct".
    :vartype destination_type: str or ~azure.mgmt.managednetworkfabric.models.DestinationType
    :ivar destination_id: The destination Id. ARM Resource ID of either NNI or Internal Networks.
    :vartype destination_id: str
    :ivar isolation_domain_properties: Isolation Domain Properties.
    :vartype isolation_domain_properties:
     ~azure.mgmt.managednetworkfabric.models.IsolationDomainProperties
    :ivar destination_tap_rule_id: ARM Resource ID of destination Tap Rule that contains match
     configurations.
    :vartype destination_tap_rule_id: str
    """

    _validation = {
        "name": {"min_length": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "destination_type": {"key": "destinationType", "type": "str"},
        "destination_id": {"key": "destinationId", "type": "str"},
        "isolation_domain_properties": {"key": "isolationDomainProperties", "type": "IsolationDomainProperties"},
        "destination_tap_rule_id": {"key": "destinationTapRuleId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        destination_type: Optional[Union[str, "_models.DestinationType"]] = None,
        destination_id: Optional[str] = None,
        isolation_domain_properties: Optional["_models.IsolationDomainProperties"] = None,
        destination_tap_rule_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Destination name.
        :paramtype name: str
        :keyword destination_type: Type of destination. Input can be IsolationDomain or Direct. Known
         values are: "IsolationDomain" and "Direct".
        :paramtype destination_type: str or ~azure.mgmt.managednetworkfabric.models.DestinationType
        :keyword destination_id: The destination Id. ARM Resource ID of either NNI or Internal
         Networks.
        :paramtype destination_id: str
        :keyword isolation_domain_properties: Isolation Domain Properties.
        :paramtype isolation_domain_properties:
         ~azure.mgmt.managednetworkfabric.models.IsolationDomainProperties
        :keyword destination_tap_rule_id: ARM Resource ID of destination Tap Rule that contains match
         configurations.
        :paramtype destination_tap_rule_id: str
        """
        super().__init__(
            name=name,
            destination_type=destination_type,
            destination_id=destination_id,
            isolation_domain_properties=isolation_domain_properties,
            destination_tap_rule_id=destination_tap_rule_id,
            **kwargs
        )


class NetworkTapRule(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The NetworkTapRule resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar configuration_type: Input method to configure Network Tap Rule. Known values are: "File"
     and "Inline".
    :vartype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
    :ivar tap_rules_url: Network Tap Rules file URL.
    :vartype tap_rules_url: str
    :ivar match_configurations: List of match configurations.
    :vartype match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchConfiguration]
    :ivar dynamic_match_configurations: List of dynamic match configurations.
    :vartype dynamic_match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
    :ivar network_tap_id: The ARM resource Id of the NetworkTap.
    :vartype network_tap_id: str
    :ivar polling_interval_in_seconds: Polling interval in seconds. Known values are: 30, 60, 90,
     and 120.
    :vartype polling_interval_in_seconds: int or
     ~azure.mgmt.managednetworkfabric.models.PollingIntervalInSeconds
    :ivar last_synced_time: The last sync timestamp.
    :vartype last_synced_time: ~datetime.datetime
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "tap_rules_url": {"min_length": 1},
        "match_configurations": {"min_items": 1},
        "dynamic_match_configurations": {"min_items": 1},
        "network_tap_id": {"readonly": True},
        "last_synced_time": {"readonly": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "configuration_type": {"key": "properties.configurationType", "type": "str"},
        "tap_rules_url": {"key": "properties.tapRulesUrl", "type": "str"},
        "match_configurations": {"key": "properties.matchConfigurations", "type": "[NetworkTapRuleMatchConfiguration]"},
        "dynamic_match_configurations": {
            "key": "properties.dynamicMatchConfigurations",
            "type": "[CommonDynamicMatchConfiguration]",
        },
        "network_tap_id": {"key": "properties.networkTapId", "type": "str"},
        "polling_interval_in_seconds": {"key": "properties.pollingIntervalInSeconds", "type": "int"},
        "last_synced_time": {"key": "properties.lastSyncedTime", "type": "iso-8601"},
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        tap_rules_url: Optional[str] = None,
        match_configurations: Optional[List["_models.NetworkTapRuleMatchConfiguration"]] = None,
        dynamic_match_configurations: Optional[List["_models.CommonDynamicMatchConfiguration"]] = None,
        polling_interval_in_seconds: Union[int, "_models.PollingIntervalInSeconds"] = 30,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword configuration_type: Input method to configure Network Tap Rule. Known values are:
         "File" and "Inline".
        :paramtype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
        :keyword tap_rules_url: Network Tap Rules file URL.
        :paramtype tap_rules_url: str
        :keyword match_configurations: List of match configurations.
        :paramtype match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchConfiguration]
        :keyword dynamic_match_configurations: List of dynamic match configurations.
        :paramtype dynamic_match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
        :keyword polling_interval_in_seconds: Polling interval in seconds. Known values are: 30, 60,
         90, and 120.
        :paramtype polling_interval_in_seconds: int or
         ~azure.mgmt.managednetworkfabric.models.PollingIntervalInSeconds
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.configuration_type = configuration_type
        self.tap_rules_url = tap_rules_url
        self.match_configurations = match_configurations
        self.dynamic_match_configurations = dynamic_match_configurations
        self.network_tap_id = None
        self.polling_interval_in_seconds = polling_interval_in_seconds
        self.last_synced_time = None
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class NetworkTapRuleAction(_serialization.Model):
    """Action that need to performed.

    :ivar type: Type of actions that can be performed. Known values are: "Drop", "Count", "Log",
     "Replicate", "Goto", "Redirect", and "Mirror".
    :vartype type: str or ~azure.mgmt.managednetworkfabric.models.TapRuleActionType
    :ivar truncate: Truncate. 0 indicates do not truncate.
    :vartype truncate: str
    :ivar is_timestamp_enabled: The parameter to enable or disable the timestamp. Known values are:
     "True" and "False".
    :vartype is_timestamp_enabled: str or
     ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
    :ivar destination_id: Destination Id. The ARM resource Id may be either Network To Network
     Interconnect or NeighborGroup.
    :vartype destination_id: str
    :ivar match_configuration_name: The name of the match configuration. This is used when Goto
     type is provided. If Goto type is selected and no match configuration name is provided. It goes
     to next configuration.
    :vartype match_configuration_name: str
    """

    _validation = {
        "truncate": {"min_length": 1},
        "match_configuration_name": {"min_length": 1},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "truncate": {"key": "truncate", "type": "str"},
        "is_timestamp_enabled": {"key": "isTimestampEnabled", "type": "str"},
        "destination_id": {"key": "destinationId", "type": "str"},
        "match_configuration_name": {"key": "matchConfigurationName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.TapRuleActionType"]] = None,
        truncate: Optional[str] = None,
        is_timestamp_enabled: Optional[Union[str, "_models.BooleanEnumProperty"]] = None,
        destination_id: Optional[str] = None,
        match_configuration_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of actions that can be performed. Known values are: "Drop", "Count", "Log",
         "Replicate", "Goto", "Redirect", and "Mirror".
        :paramtype type: str or ~azure.mgmt.managednetworkfabric.models.TapRuleActionType
        :keyword truncate: Truncate. 0 indicates do not truncate.
        :paramtype truncate: str
        :keyword is_timestamp_enabled: The parameter to enable or disable the timestamp. Known values
         are: "True" and "False".
        :paramtype is_timestamp_enabled: str or
         ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
        :keyword destination_id: Destination Id. The ARM resource Id may be either Network To Network
         Interconnect or NeighborGroup.
        :paramtype destination_id: str
        :keyword match_configuration_name: The name of the match configuration. This is used when Goto
         type is provided. If Goto type is selected and no match configuration name is provided. It goes
         to next configuration.
        :paramtype match_configuration_name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.truncate = truncate
        self.is_timestamp_enabled = is_timestamp_enabled
        self.destination_id = destination_id
        self.match_configuration_name = match_configuration_name


class NetworkTapRuleMatchCondition(CommonMatchConditions):
    """Defines the match condition that is supported to filter the traffic.

    :ivar protocol_types: List of the protocols that need to be matched.
    :vartype protocol_types: list[str]
    :ivar vlan_match_condition: Vlan match condition that needs to be matched.
    :vartype vlan_match_condition: ~azure.mgmt.managednetworkfabric.models.VlanMatchCondition
    :ivar ip_condition: IP condition that needs to be matched.
    :vartype ip_condition: ~azure.mgmt.managednetworkfabric.models.IpMatchCondition
    :ivar encapsulation_type: Encapsulation Type. Known values are: "None" and "GTPv1".
    :vartype encapsulation_type: str or ~azure.mgmt.managednetworkfabric.models.EncapsulationType
    :ivar port_condition: Defines the port condition that needs to be matched.
    :vartype port_condition: ~azure.mgmt.managednetworkfabric.models.PortCondition
    """

    _validation = {
        "protocol_types": {"min_items": 1},
    }

    _attribute_map = {
        "protocol_types": {"key": "protocolTypes", "type": "[str]"},
        "vlan_match_condition": {"key": "vlanMatchCondition", "type": "VlanMatchCondition"},
        "ip_condition": {"key": "ipCondition", "type": "IpMatchCondition"},
        "encapsulation_type": {"key": "encapsulationType", "type": "str"},
        "port_condition": {"key": "portCondition", "type": "PortCondition"},
    }

    def __init__(
        self,
        *,
        protocol_types: Optional[List[str]] = None,
        vlan_match_condition: Optional["_models.VlanMatchCondition"] = None,
        ip_condition: Optional["_models.IpMatchCondition"] = None,
        encapsulation_type: Union[str, "_models.EncapsulationType"] = "None",
        port_condition: Optional["_models.PortCondition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol_types: List of the protocols that need to be matched.
        :paramtype protocol_types: list[str]
        :keyword vlan_match_condition: Vlan match condition that needs to be matched.
        :paramtype vlan_match_condition: ~azure.mgmt.managednetworkfabric.models.VlanMatchCondition
        :keyword ip_condition: IP condition that needs to be matched.
        :paramtype ip_condition: ~azure.mgmt.managednetworkfabric.models.IpMatchCondition
        :keyword encapsulation_type: Encapsulation Type. Known values are: "None" and "GTPv1".
        :paramtype encapsulation_type: str or ~azure.mgmt.managednetworkfabric.models.EncapsulationType
        :keyword port_condition: Defines the port condition that needs to be matched.
        :paramtype port_condition: ~azure.mgmt.managednetworkfabric.models.PortCondition
        """
        super().__init__(
            protocol_types=protocol_types,
            vlan_match_condition=vlan_match_condition,
            ip_condition=ip_condition,
            **kwargs
        )
        self.encapsulation_type = encapsulation_type
        self.port_condition = port_condition


class NetworkTapRuleMatchConfiguration(_serialization.Model):
    """Defines the match configuration that are supported to filter the traffic.

    :ivar match_configuration_name: The name of the match configuration.
    :vartype match_configuration_name: str
    :ivar sequence_number: Sequence Number of the match configuration..
    :vartype sequence_number: int
    :ivar ip_address_type: Type of IP Address. IPv4 or IPv6. Known values are: "IPv4" and "IPv6".
    :vartype ip_address_type: str or ~azure.mgmt.managednetworkfabric.models.IPAddressType
    :ivar match_conditions: List of the match conditions.
    :vartype match_conditions:
     list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchCondition]
    :ivar actions: List of actions that need to be performed for the matched conditions.
    :vartype actions: list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleAction]
    """

    _validation = {
        "match_configuration_name": {"min_length": 1},
        "sequence_number": {"maximum": 4294967295, "minimum": 1},
        "match_conditions": {"min_items": 1},
        "actions": {"min_items": 1},
    }

    _attribute_map = {
        "match_configuration_name": {"key": "matchConfigurationName", "type": "str"},
        "sequence_number": {"key": "sequenceNumber", "type": "int"},
        "ip_address_type": {"key": "ipAddressType", "type": "str"},
        "match_conditions": {"key": "matchConditions", "type": "[NetworkTapRuleMatchCondition]"},
        "actions": {"key": "actions", "type": "[NetworkTapRuleAction]"},
    }

    def __init__(
        self,
        *,
        match_configuration_name: Optional[str] = None,
        sequence_number: Optional[int] = None,
        ip_address_type: Optional[Union[str, "_models.IPAddressType"]] = None,
        match_conditions: Optional[List["_models.NetworkTapRuleMatchCondition"]] = None,
        actions: Optional[List["_models.NetworkTapRuleAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword match_configuration_name: The name of the match configuration.
        :paramtype match_configuration_name: str
        :keyword sequence_number: Sequence Number of the match configuration..
        :paramtype sequence_number: int
        :keyword ip_address_type: Type of IP Address. IPv4 or IPv6. Known values are: "IPv4" and
         "IPv6".
        :paramtype ip_address_type: str or ~azure.mgmt.managednetworkfabric.models.IPAddressType
        :keyword match_conditions: List of the match conditions.
        :paramtype match_conditions:
         list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchCondition]
        :keyword actions: List of actions that need to be performed for the matched conditions.
        :paramtype actions: list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleAction]
        """
        super().__init__(**kwargs)
        self.match_configuration_name = match_configuration_name
        self.sequence_number = sequence_number
        self.ip_address_type = ip_address_type
        self.match_conditions = match_conditions
        self.actions = actions


class NetworkTapRulePatch(TagsUpdate):
    """The NetworkTapRule resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar configuration_type: Input method to configure Network Tap Rule. Known values are: "File"
     and "Inline".
    :vartype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
    :ivar tap_rules_url: Network Tap Rules file URL.
    :vartype tap_rules_url: str
    :ivar match_configurations: List of match configurations.
    :vartype match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchConfiguration]
    :ivar dynamic_match_configurations: List of dynamic match configurations.
    :vartype dynamic_match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
    """

    _validation = {
        "tap_rules_url": {"min_length": 1},
        "match_configurations": {"min_items": 1},
        "dynamic_match_configurations": {"min_items": 1},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "configuration_type": {"key": "properties.configurationType", "type": "str"},
        "tap_rules_url": {"key": "properties.tapRulesUrl", "type": "str"},
        "match_configurations": {"key": "properties.matchConfigurations", "type": "[NetworkTapRuleMatchConfiguration]"},
        "dynamic_match_configurations": {
            "key": "properties.dynamicMatchConfigurations",
            "type": "[CommonDynamicMatchConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        tap_rules_url: Optional[str] = None,
        match_configurations: Optional[List["_models.NetworkTapRuleMatchConfiguration"]] = None,
        dynamic_match_configurations: Optional[List["_models.CommonDynamicMatchConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword configuration_type: Input method to configure Network Tap Rule. Known values are:
         "File" and "Inline".
        :paramtype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
        :keyword tap_rules_url: Network Tap Rules file URL.
        :paramtype tap_rules_url: str
        :keyword match_configurations: List of match configurations.
        :paramtype match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchConfiguration]
        :keyword dynamic_match_configurations: List of dynamic match configurations.
        :paramtype dynamic_match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
        """
        super().__init__(tags=tags, **kwargs)
        self.annotation = annotation
        self.configuration_type = configuration_type
        self.tap_rules_url = tap_rules_url
        self.match_configurations = match_configurations
        self.dynamic_match_configurations = dynamic_match_configurations


class NetworkTapRulePatchableProperties(_serialization.Model):
    """Network Tap Rule updatable properties.

    :ivar configuration_type: Input method to configure Network Tap Rule. Known values are: "File"
     and "Inline".
    :vartype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
    :ivar tap_rules_url: Network Tap Rules file URL.
    :vartype tap_rules_url: str
    :ivar match_configurations: List of match configurations.
    :vartype match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchConfiguration]
    :ivar dynamic_match_configurations: List of dynamic match configurations.
    :vartype dynamic_match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
    """

    _validation = {
        "tap_rules_url": {"min_length": 1},
        "match_configurations": {"min_items": 1},
        "dynamic_match_configurations": {"min_items": 1},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
        "tap_rules_url": {"key": "tapRulesUrl", "type": "str"},
        "match_configurations": {"key": "matchConfigurations", "type": "[NetworkTapRuleMatchConfiguration]"},
        "dynamic_match_configurations": {
            "key": "dynamicMatchConfigurations",
            "type": "[CommonDynamicMatchConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        tap_rules_url: Optional[str] = None,
        match_configurations: Optional[List["_models.NetworkTapRuleMatchConfiguration"]] = None,
        dynamic_match_configurations: Optional[List["_models.CommonDynamicMatchConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configuration_type: Input method to configure Network Tap Rule. Known values are:
         "File" and "Inline".
        :paramtype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
        :keyword tap_rules_url: Network Tap Rules file URL.
        :paramtype tap_rules_url: str
        :keyword match_configurations: List of match configurations.
        :paramtype match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchConfiguration]
        :keyword dynamic_match_configurations: List of dynamic match configurations.
        :paramtype dynamic_match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
        """
        super().__init__(**kwargs)
        self.configuration_type = configuration_type
        self.tap_rules_url = tap_rules_url
        self.match_configurations = match_configurations
        self.dynamic_match_configurations = dynamic_match_configurations


class NetworkTapRulePatchProperties(AnnotationResource, NetworkTapRulePatchableProperties):
    """Network Tap Rule Patch properties.

    :ivar configuration_type: Input method to configure Network Tap Rule. Known values are: "File"
     and "Inline".
    :vartype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
    :ivar tap_rules_url: Network Tap Rules file URL.
    :vartype tap_rules_url: str
    :ivar match_configurations: List of match configurations.
    :vartype match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchConfiguration]
    :ivar dynamic_match_configurations: List of dynamic match configurations.
    :vartype dynamic_match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    """

    _validation = {
        "tap_rules_url": {"min_length": 1},
        "match_configurations": {"min_items": 1},
        "dynamic_match_configurations": {"min_items": 1},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
        "tap_rules_url": {"key": "tapRulesUrl", "type": "str"},
        "match_configurations": {"key": "matchConfigurations", "type": "[NetworkTapRuleMatchConfiguration]"},
        "dynamic_match_configurations": {
            "key": "dynamicMatchConfigurations",
            "type": "[CommonDynamicMatchConfiguration]",
        },
        "annotation": {"key": "annotation", "type": "str"},
    }

    def __init__(
        self,
        *,
        configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        tap_rules_url: Optional[str] = None,
        match_configurations: Optional[List["_models.NetworkTapRuleMatchConfiguration"]] = None,
        dynamic_match_configurations: Optional[List["_models.CommonDynamicMatchConfiguration"]] = None,
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configuration_type: Input method to configure Network Tap Rule. Known values are:
         "File" and "Inline".
        :paramtype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
        :keyword tap_rules_url: Network Tap Rules file URL.
        :paramtype tap_rules_url: str
        :keyword match_configurations: List of match configurations.
        :paramtype match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchConfiguration]
        :keyword dynamic_match_configurations: List of dynamic match configurations.
        :paramtype dynamic_match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        """
        super().__init__(
            annotation=annotation,
            configuration_type=configuration_type,
            tap_rules_url=tap_rules_url,
            match_configurations=match_configurations,
            dynamic_match_configurations=dynamic_match_configurations,
            **kwargs
        )
        self.configuration_type = configuration_type
        self.tap_rules_url = tap_rules_url
        self.match_configurations = match_configurations
        self.dynamic_match_configurations = dynamic_match_configurations
        self.annotation = annotation


class NetworkTapRuleProperties(
    AnnotationResource, NetworkTapRulePatchableProperties
):  # pylint: disable=too-many-instance-attributes
    """Network Tap Rule Properties defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar configuration_type: Input method to configure Network Tap Rule. Known values are: "File"
     and "Inline".
    :vartype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
    :ivar tap_rules_url: Network Tap Rules file URL.
    :vartype tap_rules_url: str
    :ivar match_configurations: List of match configurations.
    :vartype match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchConfiguration]
    :ivar dynamic_match_configurations: List of dynamic match configurations.
    :vartype dynamic_match_configurations:
     list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_tap_id: The ARM resource Id of the NetworkTap.
    :vartype network_tap_id: str
    :ivar polling_interval_in_seconds: Polling interval in seconds. Known values are: 30, 60, 90,
     and 120.
    :vartype polling_interval_in_seconds: int or
     ~azure.mgmt.managednetworkfabric.models.PollingIntervalInSeconds
    :ivar last_synced_time: The last sync timestamp.
    :vartype last_synced_time: ~datetime.datetime
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "tap_rules_url": {"min_length": 1},
        "match_configurations": {"min_items": 1},
        "dynamic_match_configurations": {"min_items": 1},
        "network_tap_id": {"readonly": True},
        "last_synced_time": {"readonly": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "configuration_type": {"key": "configurationType", "type": "str"},
        "tap_rules_url": {"key": "tapRulesUrl", "type": "str"},
        "match_configurations": {"key": "matchConfigurations", "type": "[NetworkTapRuleMatchConfiguration]"},
        "dynamic_match_configurations": {
            "key": "dynamicMatchConfigurations",
            "type": "[CommonDynamicMatchConfiguration]",
        },
        "annotation": {"key": "annotation", "type": "str"},
        "network_tap_id": {"key": "networkTapId", "type": "str"},
        "polling_interval_in_seconds": {"key": "pollingIntervalInSeconds", "type": "int"},
        "last_synced_time": {"key": "lastSyncedTime", "type": "iso-8601"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        tap_rules_url: Optional[str] = None,
        match_configurations: Optional[List["_models.NetworkTapRuleMatchConfiguration"]] = None,
        dynamic_match_configurations: Optional[List["_models.CommonDynamicMatchConfiguration"]] = None,
        annotation: Optional[str] = None,
        polling_interval_in_seconds: Union[int, "_models.PollingIntervalInSeconds"] = 30,
        **kwargs: Any
    ) -> None:
        """
        :keyword configuration_type: Input method to configure Network Tap Rule. Known values are:
         "File" and "Inline".
        :paramtype configuration_type: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationType
        :keyword tap_rules_url: Network Tap Rules file URL.
        :paramtype tap_rules_url: str
        :keyword match_configurations: List of match configurations.
        :paramtype match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.NetworkTapRuleMatchConfiguration]
        :keyword dynamic_match_configurations: List of dynamic match configurations.
        :paramtype dynamic_match_configurations:
         list[~azure.mgmt.managednetworkfabric.models.CommonDynamicMatchConfiguration]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword polling_interval_in_seconds: Polling interval in seconds. Known values are: 30, 60,
         90, and 120.
        :paramtype polling_interval_in_seconds: int or
         ~azure.mgmt.managednetworkfabric.models.PollingIntervalInSeconds
        """
        super().__init__(
            annotation=annotation,
            configuration_type=configuration_type,
            tap_rules_url=tap_rules_url,
            match_configurations=match_configurations,
            dynamic_match_configurations=dynamic_match_configurations,
            **kwargs
        )
        self.configuration_type = configuration_type
        self.tap_rules_url = tap_rules_url
        self.match_configurations = match_configurations
        self.dynamic_match_configurations = dynamic_match_configurations
        self.network_tap_id = None
        self.polling_interval_in_seconds = polling_interval_in_seconds
        self.last_synced_time = None
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None
        self.annotation = annotation


class NetworkTapRulesListResult(_serialization.Model):
    """List of NetworkTapRules.

    :ivar value: List of NetworkTapRule resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkTapRule]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkTapRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkTapRule"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkTapRule resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkTapRule]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkTapsListResult(_serialization.Model):
    """List of NetworkTaps.

    :ivar value: List of NetworkTap resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkTap]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkTap]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkTap"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkTap resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkTap]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkToNetworkInterconnect(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The Network To Network Interconnect resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar nni_type: Type of NNI used. Example: CE | NPB. Known values are: "CE" and "NPB".
    :vartype nni_type: str or ~azure.mgmt.managednetworkfabric.models.NniType
    :ivar is_management_type: Configuration to use NNI for Infrastructure Management. Example:
     True/False. Known values are: "True" and "False".
    :vartype is_management_type: str or ~azure.mgmt.managednetworkfabric.models.IsManagementType
    :ivar use_option_b: Based on this option layer3 parameters are mandatory. Example: True/False.
     Required. Known values are: "True" and "False".
    :vartype use_option_b: str or ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
    :ivar layer2_configuration: Common properties for Layer2 Configuration.
    :vartype layer2_configuration: ~azure.mgmt.managednetworkfabric.models.Layer2Configuration
    :ivar option_b_layer3_configuration: Common properties for Layer3Configuration.
    :vartype option_b_layer3_configuration:
     ~azure.mgmt.managednetworkfabric.models.NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration
    :ivar npb_static_route_configuration: NPB Static Route Configuration properties.
    :vartype npb_static_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.NpbStaticRouteConfiguration
    :ivar import_route_policy: Import Route Policy configuration.
    :vartype import_route_policy:
     ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicyInformation
    :ivar export_route_policy: Export Route Policy configuration.
    :vartype export_route_policy:
     ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicyInformation
    :ivar egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
    :vartype egress_acl_id: str
    :ivar ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
    :vartype ingress_acl_id: str
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "use_option_b": {"required": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "nni_type": {"key": "properties.nniType", "type": "str"},
        "is_management_type": {"key": "properties.isManagementType", "type": "str"},
        "use_option_b": {"key": "properties.useOptionB", "type": "str"},
        "layer2_configuration": {"key": "properties.layer2Configuration", "type": "Layer2Configuration"},
        "option_b_layer3_configuration": {
            "key": "properties.optionBLayer3Configuration",
            "type": "NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration",
        },
        "npb_static_route_configuration": {
            "key": "properties.npbStaticRouteConfiguration",
            "type": "NpbStaticRouteConfiguration",
        },
        "import_route_policy": {"key": "properties.importRoutePolicy", "type": "ImportRoutePolicyInformation"},
        "export_route_policy": {"key": "properties.exportRoutePolicy", "type": "ExportRoutePolicyInformation"},
        "egress_acl_id": {"key": "properties.egressAclId", "type": "str"},
        "ingress_acl_id": {"key": "properties.ingressAclId", "type": "str"},
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        use_option_b: Union[str, "_models.BooleanEnumProperty"],
        nni_type: Union[str, "_models.NniType"] = "CE",
        is_management_type: Union[str, "_models.IsManagementType"] = "True",
        layer2_configuration: Optional["_models.Layer2Configuration"] = None,
        option_b_layer3_configuration: Optional[
            "_models.NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration"
        ] = None,
        npb_static_route_configuration: Optional["_models.NpbStaticRouteConfiguration"] = None,
        import_route_policy: Optional["_models.ImportRoutePolicyInformation"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicyInformation"] = None,
        egress_acl_id: Optional[str] = None,
        ingress_acl_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword nni_type: Type of NNI used. Example: CE | NPB. Known values are: "CE" and "NPB".
        :paramtype nni_type: str or ~azure.mgmt.managednetworkfabric.models.NniType
        :keyword is_management_type: Configuration to use NNI for Infrastructure Management. Example:
         True/False. Known values are: "True" and "False".
        :paramtype is_management_type: str or ~azure.mgmt.managednetworkfabric.models.IsManagementType
        :keyword use_option_b: Based on this option layer3 parameters are mandatory. Example:
         True/False. Required. Known values are: "True" and "False".
        :paramtype use_option_b: str or ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
        :keyword layer2_configuration: Common properties for Layer2 Configuration.
        :paramtype layer2_configuration: ~azure.mgmt.managednetworkfabric.models.Layer2Configuration
        :keyword option_b_layer3_configuration: Common properties for Layer3Configuration.
        :paramtype option_b_layer3_configuration:
         ~azure.mgmt.managednetworkfabric.models.NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration
        :keyword npb_static_route_configuration: NPB Static Route Configuration properties.
        :paramtype npb_static_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.NpbStaticRouteConfiguration
        :keyword import_route_policy: Import Route Policy configuration.
        :paramtype import_route_policy:
         ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicyInformation
        :keyword export_route_policy: Export Route Policy configuration.
        :paramtype export_route_policy:
         ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicyInformation
        :keyword egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
        :paramtype egress_acl_id: str
        :keyword ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
        :paramtype ingress_acl_id: str
        """
        super().__init__(**kwargs)
        self.nni_type = nni_type
        self.is_management_type = is_management_type
        self.use_option_b = use_option_b
        self.layer2_configuration = layer2_configuration
        self.option_b_layer3_configuration = option_b_layer3_configuration
        self.npb_static_route_configuration = npb_static_route_configuration
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy
        self.egress_acl_id = egress_acl_id
        self.ingress_acl_id = ingress_acl_id
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class NetworkToNetworkInterconnectPatch(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The Network To Network Interconnect resource patch definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar layer2_configuration: Common properties for Layer2Configuration.
    :vartype layer2_configuration: ~azure.mgmt.managednetworkfabric.models.Layer2Configuration
    :ivar option_b_layer3_configuration: Common properties for Layer3Configuration.
    :vartype option_b_layer3_configuration:
     ~azure.mgmt.managednetworkfabric.models.OptionBLayer3Configuration
    :ivar npb_static_route_configuration: NPB Static Route Configuration properties.
    :vartype npb_static_route_configuration:
     ~azure.mgmt.managednetworkfabric.models.NpbStaticRouteConfiguration
    :ivar import_route_policy: Import Route Policy information.
    :vartype import_route_policy:
     ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicyInformation
    :ivar export_route_policy: Export Route Policy information.
    :vartype export_route_policy:
     ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicyInformation
    :ivar egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
    :vartype egress_acl_id: str
    :ivar ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
    :vartype ingress_acl_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "layer2_configuration": {"key": "properties.layer2Configuration", "type": "Layer2Configuration"},
        "option_b_layer3_configuration": {
            "key": "properties.optionBLayer3Configuration",
            "type": "OptionBLayer3Configuration",
        },
        "npb_static_route_configuration": {
            "key": "properties.npbStaticRouteConfiguration",
            "type": "NpbStaticRouteConfiguration",
        },
        "import_route_policy": {"key": "properties.importRoutePolicy", "type": "ImportRoutePolicyInformation"},
        "export_route_policy": {"key": "properties.exportRoutePolicy", "type": "ExportRoutePolicyInformation"},
        "egress_acl_id": {"key": "properties.egressAclId", "type": "str"},
        "ingress_acl_id": {"key": "properties.ingressAclId", "type": "str"},
    }

    def __init__(
        self,
        *,
        layer2_configuration: Optional["_models.Layer2Configuration"] = None,
        option_b_layer3_configuration: Optional["_models.OptionBLayer3Configuration"] = None,
        npb_static_route_configuration: Optional["_models.NpbStaticRouteConfiguration"] = None,
        import_route_policy: Optional["_models.ImportRoutePolicyInformation"] = None,
        export_route_policy: Optional["_models.ExportRoutePolicyInformation"] = None,
        egress_acl_id: Optional[str] = None,
        ingress_acl_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword layer2_configuration: Common properties for Layer2Configuration.
        :paramtype layer2_configuration: ~azure.mgmt.managednetworkfabric.models.Layer2Configuration
        :keyword option_b_layer3_configuration: Common properties for Layer3Configuration.
        :paramtype option_b_layer3_configuration:
         ~azure.mgmt.managednetworkfabric.models.OptionBLayer3Configuration
        :keyword npb_static_route_configuration: NPB Static Route Configuration properties.
        :paramtype npb_static_route_configuration:
         ~azure.mgmt.managednetworkfabric.models.NpbStaticRouteConfiguration
        :keyword import_route_policy: Import Route Policy information.
        :paramtype import_route_policy:
         ~azure.mgmt.managednetworkfabric.models.ImportRoutePolicyInformation
        :keyword export_route_policy: Export Route Policy information.
        :paramtype export_route_policy:
         ~azure.mgmt.managednetworkfabric.models.ExportRoutePolicyInformation
        :keyword egress_acl_id: Egress Acl. ARM resource ID of Access Control Lists.
        :paramtype egress_acl_id: str
        :keyword ingress_acl_id: Ingress Acl. ARM resource ID of Access Control Lists.
        :paramtype ingress_acl_id: str
        """
        super().__init__(**kwargs)
        self.layer2_configuration = layer2_configuration
        self.option_b_layer3_configuration = option_b_layer3_configuration
        self.npb_static_route_configuration = npb_static_route_configuration
        self.import_route_policy = import_route_policy
        self.export_route_policy = export_route_policy
        self.egress_acl_id = egress_acl_id
        self.ingress_acl_id = ingress_acl_id


class OptionBLayer3Configuration(Layer3IpPrefixProperties):
    """OptionB Layer3 Configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
    :vartype secondary_ipv6_prefix: str
    :ivar peer_asn: ASN of PE devices for CE/PE connectivity.Example : 28.
    :vartype peer_asn: int
    :ivar vlan_id: VLAN for CE/PE Layer 3 connectivity.Example : 501.
    :vartype vlan_id: int
    :ivar fabric_asn: ASN of CE devices for CE/PE connectivity.
    :vartype fabric_asn: int
    """

    _validation = {
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
        "vlan_id": {"maximum": 4094, "minimum": 100},
        "fabric_asn": {"readonly": True},
    }

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        peer_asn: Optional[int] = None,
        vlan_id: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
        :paramtype secondary_ipv6_prefix: str
        :keyword peer_asn: ASN of PE devices for CE/PE connectivity.Example : 28.
        :paramtype peer_asn: int
        :keyword vlan_id: VLAN for CE/PE Layer 3 connectivity.Example : 501.
        :paramtype vlan_id: int
        """
        super().__init__(
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            **kwargs
        )
        self.peer_asn = peer_asn
        self.vlan_id = vlan_id
        self.fabric_asn = None


class NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration(OptionBLayer3Configuration):
    """Common properties for Layer3Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
    :vartype secondary_ipv6_prefix: str
    :ivar peer_asn: ASN of PE devices for CE/PE connectivity.Example : 28.
    :vartype peer_asn: int
    :ivar vlan_id: VLAN for CE/PE Layer 3 connectivity.Example : 501.
    :vartype vlan_id: int
    :ivar fabric_asn: ASN of CE devices for CE/PE connectivity.
    :vartype fabric_asn: int
    """

    _validation = {
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
        "vlan_id": {"maximum": 4094, "minimum": 100},
        "fabric_asn": {"readonly": True},
    }

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "fabric_asn": {"key": "fabricASN", "type": "int"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        peer_asn: Optional[int] = None,
        vlan_id: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
        :paramtype secondary_ipv6_prefix: str
        :keyword peer_asn: ASN of PE devices for CE/PE connectivity.Example : 28.
        :paramtype peer_asn: int
        :keyword vlan_id: VLAN for CE/PE Layer 3 connectivity.Example : 501.
        :paramtype vlan_id: int
        """
        super().__init__(
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            peer_asn=peer_asn,
            vlan_id=vlan_id,
            **kwargs
        )


class NetworkToNetworkInterconnectsList(_serialization.Model):
    """List of Network To Network Interconnects.

    :ivar value: List of NetworkToNetworkInterconnects resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.NetworkToNetworkInterconnect]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkToNetworkInterconnect]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkToNetworkInterconnect"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of NetworkToNetworkInterconnects resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.NetworkToNetworkInterconnect]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NpbStaticRouteConfiguration(_serialization.Model):
    """NPB Static Route Configuration properties.

    :ivar bfd_configuration: BFD Configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    :ivar ipv4_routes: List of IPv4 Routes.
    :vartype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
    :ivar ipv6_routes: List of IPv6 Routes.
    :vartype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
    """

    _validation = {
        "ipv4_routes": {"min_items": 1},
        "ipv6_routes": {"min_items": 1},
    }

    _attribute_map = {
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
        "ipv4_routes": {"key": "ipv4Routes", "type": "[StaticRouteProperties]"},
        "ipv6_routes": {"key": "ipv6Routes", "type": "[StaticRouteProperties]"},
    }

    def __init__(
        self,
        *,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        ipv4_routes: Optional[List["_models.StaticRouteProperties"]] = None,
        ipv6_routes: Optional[List["_models.StaticRouteProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bfd_configuration: BFD Configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        :keyword ipv4_routes: List of IPv4 Routes.
        :paramtype ipv4_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
        :keyword ipv6_routes: List of IPv6 Routes.
        :paramtype ipv6_routes: list[~azure.mgmt.managednetworkfabric.models.StaticRouteProperties]
        """
        super().__init__(**kwargs)
        self.bfd_configuration = bfd_configuration
        self.ipv4_routes = ipv4_routes
        self.ipv6_routes = ipv6_routes


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.managednetworkfabric.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.managednetworkfabric.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.managednetworkfabric.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.managednetworkfabric.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OptionAProperties(_serialization.Model):
    """Peering optionA properties.

    :ivar mtu: MTU to use for option A peering.
    :vartype mtu: int
    :ivar vlan_id: Vlan Id.Example : 501.
    :vartype vlan_id: int
    :ivar peer_asn: Peer ASN number.Example : 28.
    :vartype peer_asn: int
    :ivar bfd_configuration: BFD Configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
        "vlan_id": {"maximum": 4094, "minimum": 501},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
    }

    _attribute_map = {
        "mtu": {"key": "mtu", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
    }

    def __init__(
        self,
        *,
        mtu: int = 1500,
        vlan_id: Optional[int] = None,
        peer_asn: Optional[int] = None,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mtu: MTU to use for option A peering.
        :paramtype mtu: int
        :keyword vlan_id: Vlan Id.Example : 501.
        :paramtype vlan_id: int
        :keyword peer_asn: Peer ASN number.Example : 28.
        :paramtype peer_asn: int
        :keyword bfd_configuration: BFD Configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        """
        super().__init__(**kwargs)
        self.mtu = mtu
        self.vlan_id = vlan_id
        self.peer_asn = peer_asn
        self.bfd_configuration = bfd_configuration


class OptionBProperties(_serialization.Model):
    """Option B configuration to be used for Management VPN.

    :ivar import_route_targets: Route Targets to be applied for incoming routes into CE. This is
     for backward compatibility.
    :vartype import_route_targets: list[str]
    :ivar export_route_targets: Route Targets to be applied for outgoing routes from CE. This is
     for backward compatibility.
    :vartype export_route_targets: list[str]
    :ivar route_targets: Route Targets to be applied.
    :vartype route_targets: ~azure.mgmt.managednetworkfabric.models.RouteTargetInformation
    """

    _attribute_map = {
        "import_route_targets": {"key": "importRouteTargets", "type": "[str]"},
        "export_route_targets": {"key": "exportRouteTargets", "type": "[str]"},
        "route_targets": {"key": "routeTargets", "type": "RouteTargetInformation"},
    }

    def __init__(
        self,
        *,
        import_route_targets: Optional[List[str]] = None,
        export_route_targets: Optional[List[str]] = None,
        route_targets: Optional["_models.RouteTargetInformation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword import_route_targets: Route Targets to be applied for incoming routes into CE. This is
         for backward compatibility.
        :paramtype import_route_targets: list[str]
        :keyword export_route_targets: Route Targets to be applied for outgoing routes from CE. This is
         for backward compatibility.
        :paramtype export_route_targets: list[str]
        :keyword route_targets: Route Targets to be applied.
        :paramtype route_targets: ~azure.mgmt.managednetworkfabric.models.RouteTargetInformation
        """
        super().__init__(**kwargs)
        self.import_route_targets = import_route_targets
        self.export_route_targets = export_route_targets
        self.route_targets = route_targets


class PortGroupProperties(_serialization.Model):
    """Port Group properties.

    :ivar name: The name of the port group.
    :vartype name: str
    :ivar ports: List of the ports that needs to be matched.
    :vartype ports: list[str]
    """

    _validation = {
        "name": {"min_length": 1},
        "ports": {"min_items": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "ports": {"key": "ports", "type": "[str]"},
    }

    def __init__(self, *, name: Optional[str] = None, ports: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the port group.
        :paramtype name: str
        :keyword ports: List of the ports that needs to be matched.
        :paramtype ports: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.ports = ports


class RebootProperties(_serialization.Model):
    """Reboot properties.

    :ivar reboot_type: Type of reboot to be performed. Example: GracefulRebootWithZTP. Known values
     are: "GracefulRebootWithZTP", "GracefulRebootWithoutZTP", "UngracefulRebootWithZTP", and
     "UngracefulRebootWithoutZTP".
    :vartype reboot_type: str or ~azure.mgmt.managednetworkfabric.models.RebootType
    """

    _attribute_map = {
        "reboot_type": {"key": "rebootType", "type": "str"},
    }

    def __init__(self, *, reboot_type: Optional[Union[str, "_models.RebootType"]] = None, **kwargs: Any) -> None:
        """
        :keyword reboot_type: Type of reboot to be performed. Example: GracefulRebootWithZTP. Known
         values are: "GracefulRebootWithZTP", "GracefulRebootWithoutZTP", "UngracefulRebootWithZTP", and
         "UngracefulRebootWithoutZTP".
        :paramtype reboot_type: str or ~azure.mgmt.managednetworkfabric.models.RebootType
        """
        super().__init__(**kwargs)
        self.reboot_type = reboot_type


class RoutePoliciesListResult(_serialization.Model):
    """List of RoutePolicies.

    :ivar value: List of RoutePolicy resources.
    :vartype value: list[~azure.mgmt.managednetworkfabric.models.RoutePolicy]
    :ivar next_link: Url to follow for getting next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RoutePolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RoutePolicy"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of RoutePolicy resources.
        :paramtype value: list[~azure.mgmt.managednetworkfabric.models.RoutePolicy]
        :keyword next_link: Url to follow for getting next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoutePolicy(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The RoutePolicy resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.managednetworkfabric.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar statements: Route Policy statements.
    :vartype statements:
     list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
    :ivar network_fabric_id: Arm Resource ID of Network Fabric. Required.
    :vartype network_fabric_id: str
    :ivar address_family_type: AddressFamilyType. This parameter decides whether the given ipv4 or
     ipv6 route policy. Known values are: "IPv4" and "IPv6".
    :vartype address_family_type: str or ~azure.mgmt.managednetworkfabric.models.AddressFamilyType
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "network_fabric_id": {"required": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "annotation": {"key": "properties.annotation", "type": "str"},
        "statements": {"key": "properties.statements", "type": "[RoutePolicyStatementProperties]"},
        "network_fabric_id": {"key": "properties.networkFabricId", "type": "str"},
        "address_family_type": {"key": "properties.addressFamilyType", "type": "str"},
        "configuration_state": {"key": "properties.configurationState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "administrative_state": {"key": "properties.administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        network_fabric_id: str,
        tags: Optional[Dict[str, str]] = None,
        annotation: Optional[str] = None,
        statements: Optional[List["_models.RoutePolicyStatementProperties"]] = None,
        address_family_type: Union[str, "_models.AddressFamilyType"] = "IPv4",
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword statements: Route Policy statements.
        :paramtype statements:
         list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
        :keyword network_fabric_id: Arm Resource ID of Network Fabric. Required.
        :paramtype network_fabric_id: str
        :keyword address_family_type: AddressFamilyType. This parameter decides whether the given ipv4
         or ipv6 route policy. Known values are: "IPv4" and "IPv6".
        :paramtype address_family_type: str or
         ~azure.mgmt.managednetworkfabric.models.AddressFamilyType
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.annotation = annotation
        self.statements = statements
        self.network_fabric_id = network_fabric_id
        self.address_family_type = address_family_type
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None


class RoutePolicyPatch(TagsUpdate):
    """The Route Policy patch resource definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar statements: Route Policy statements.
    :vartype statements:
     list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "statements": {"key": "properties.statements", "type": "[RoutePolicyStatementProperties]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        statements: Optional[List["_models.RoutePolicyStatementProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword statements: Route Policy statements.
        :paramtype statements:
         list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
        """
        super().__init__(tags=tags, **kwargs)
        self.statements = statements


class RoutePolicyPatchableProperties(_serialization.Model):
    """Route Policy patchable properties.

    :ivar statements: Route Policy statements.
    :vartype statements:
     list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
    """

    _attribute_map = {
        "statements": {"key": "statements", "type": "[RoutePolicyStatementProperties]"},
    }

    def __init__(
        self, *, statements: Optional[List["_models.RoutePolicyStatementProperties"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword statements: Route Policy statements.
        :paramtype statements:
         list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
        """
        super().__init__(**kwargs)
        self.statements = statements


class RoutePolicyProperties(AnnotationResource, RoutePolicyPatchableProperties):
    """RoutePolicyProperties defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar statements: Route Policy statements.
    :vartype statements:
     list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar network_fabric_id: Arm Resource ID of Network Fabric. Required.
    :vartype network_fabric_id: str
    :ivar address_family_type: AddressFamilyType. This parameter decides whether the given ipv4 or
     ipv6 route policy. Known values are: "IPv4" and "IPv6".
    :vartype address_family_type: str or ~azure.mgmt.managednetworkfabric.models.AddressFamilyType
    :ivar configuration_state: Configuration state of the resource. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Updating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.managednetworkfabric.models.ProvisioningState
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    """

    _validation = {
        "network_fabric_id": {"required": True},
        "configuration_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "administrative_state": {"readonly": True},
    }

    _attribute_map = {
        "statements": {"key": "statements", "type": "[RoutePolicyStatementProperties]"},
        "annotation": {"key": "annotation", "type": "str"},
        "network_fabric_id": {"key": "networkFabricId", "type": "str"},
        "address_family_type": {"key": "addressFamilyType", "type": "str"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_fabric_id: str,
        statements: Optional[List["_models.RoutePolicyStatementProperties"]] = None,
        annotation: Optional[str] = None,
        address_family_type: Union[str, "_models.AddressFamilyType"] = "IPv4",
        **kwargs: Any
    ) -> None:
        """
        :keyword statements: Route Policy statements.
        :paramtype statements:
         list[~azure.mgmt.managednetworkfabric.models.RoutePolicyStatementProperties]
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword network_fabric_id: Arm Resource ID of Network Fabric. Required.
        :paramtype network_fabric_id: str
        :keyword address_family_type: AddressFamilyType. This parameter decides whether the given ipv4
         or ipv6 route policy. Known values are: "IPv4" and "IPv6".
        :paramtype address_family_type: str or
         ~azure.mgmt.managednetworkfabric.models.AddressFamilyType
        """
        super().__init__(annotation=annotation, statements=statements, **kwargs)
        self.statements = statements
        self.network_fabric_id = network_fabric_id
        self.address_family_type = address_family_type
        self.configuration_state = None
        self.provisioning_state = None
        self.administrative_state = None
        self.annotation = annotation


class RoutePolicyStatementProperties(AnnotationResource):
    """Route Policy Statement properties.

    All required parameters must be populated in order to send to Azure.

    :ivar annotation: Switch configuration description.
    :vartype annotation: str
    :ivar sequence_number: Sequence to insert to/delete from existing route. Required.
    :vartype sequence_number: int
    :ivar condition: Route policy condition properties. Required.
    :vartype condition: ~azure.mgmt.managednetworkfabric.models.StatementConditionProperties
    :ivar action: Route policy action properties. Required.
    :vartype action: ~azure.mgmt.managednetworkfabric.models.StatementActionProperties
    """

    _validation = {
        "sequence_number": {"required": True, "maximum": 4294967295, "minimum": 1},
        "condition": {"required": True},
        "action": {"required": True},
    }

    _attribute_map = {
        "annotation": {"key": "annotation", "type": "str"},
        "sequence_number": {"key": "sequenceNumber", "type": "int"},
        "condition": {"key": "condition", "type": "StatementConditionProperties"},
        "action": {"key": "action", "type": "StatementActionProperties"},
    }

    def __init__(
        self,
        *,
        sequence_number: int,
        condition: "_models.StatementConditionProperties",
        action: "_models.StatementActionProperties",
        annotation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword annotation: Switch configuration description.
        :paramtype annotation: str
        :keyword sequence_number: Sequence to insert to/delete from existing route. Required.
        :paramtype sequence_number: int
        :keyword condition: Route policy condition properties. Required.
        :paramtype condition: ~azure.mgmt.managednetworkfabric.models.StatementConditionProperties
        :keyword action: Route policy action properties. Required.
        :paramtype action: ~azure.mgmt.managednetworkfabric.models.StatementActionProperties
        """
        super().__init__(annotation=annotation, **kwargs)
        self.sequence_number = sequence_number
        self.condition = condition
        self.action = action


class RouteTargetInformation(_serialization.Model):
    """Route Target Configuration.

    :ivar import_ipv4_route_targets: Route Targets to be applied for incoming routes into CE.
    :vartype import_ipv4_route_targets: list[str]
    :ivar import_ipv6_route_targets: Route Targets to be applied for incoming routes from CE.
    :vartype import_ipv6_route_targets: list[str]
    :ivar export_ipv4_route_targets: Route Targets to be applied for outgoing routes into CE.
    :vartype export_ipv4_route_targets: list[str]
    :ivar export_ipv6_route_targets: Route Targets to be applied for outgoing routes from CE.
    :vartype export_ipv6_route_targets: list[str]
    """

    _validation = {
        "import_ipv4_route_targets": {"min_items": 1},
        "import_ipv6_route_targets": {"min_items": 1},
        "export_ipv4_route_targets": {"min_items": 1},
        "export_ipv6_route_targets": {"min_items": 1},
    }

    _attribute_map = {
        "import_ipv4_route_targets": {"key": "importIpv4RouteTargets", "type": "[str]"},
        "import_ipv6_route_targets": {"key": "importIpv6RouteTargets", "type": "[str]"},
        "export_ipv4_route_targets": {"key": "exportIpv4RouteTargets", "type": "[str]"},
        "export_ipv6_route_targets": {"key": "exportIpv6RouteTargets", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        import_ipv4_route_targets: Optional[List[str]] = None,
        import_ipv6_route_targets: Optional[List[str]] = None,
        export_ipv4_route_targets: Optional[List[str]] = None,
        export_ipv6_route_targets: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword import_ipv4_route_targets: Route Targets to be applied for incoming routes into CE.
        :paramtype import_ipv4_route_targets: list[str]
        :keyword import_ipv6_route_targets: Route Targets to be applied for incoming routes from CE.
        :paramtype import_ipv6_route_targets: list[str]
        :keyword export_ipv4_route_targets: Route Targets to be applied for outgoing routes into CE.
        :paramtype export_ipv4_route_targets: list[str]
        :keyword export_ipv6_route_targets: Route Targets to be applied for outgoing routes from CE.
        :paramtype export_ipv6_route_targets: list[str]
        """
        super().__init__(**kwargs)
        self.import_ipv4_route_targets = import_ipv4_route_targets
        self.import_ipv6_route_targets = import_ipv6_route_targets
        self.export_ipv4_route_targets = export_ipv4_route_targets
        self.export_ipv6_route_targets = export_ipv6_route_targets


class RuleProperties(_serialization.Model):
    """Rules for the InternetGateways.

    All required parameters must be populated in order to send to Azure.

    :ivar action: Specify action. Required. Known values are: "Allow" and "Deny".
    :vartype action: str or ~azure.mgmt.managednetworkfabric.models.Action
    :ivar address_list: List of Addresses to be allowed or denied. Required.
    :vartype address_list: list[str]
    """

    _validation = {
        "action": {"required": True},
        "address_list": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "address_list": {"key": "addressList", "type": "[str]"},
    }

    def __init__(self, *, action: Union[str, "_models.Action"], address_list: List[str], **kwargs: Any) -> None:
        """
        :keyword action: Specify action. Required. Known values are: "Allow" and "Deny".
        :paramtype action: str or ~azure.mgmt.managednetworkfabric.models.Action
        :keyword address_list: List of Addresses to be allowed or denied. Required.
        :paramtype address_list: list[str]
        """
        super().__init__(**kwargs)
        self.action = action
        self.address_list = address_list


class StatementActionProperties(_serialization.Model):
    """Route policy action properties.

    All required parameters must be populated in order to send to Azure.

    :ivar local_preference: Local Preference of the route policy.
    :vartype local_preference: int
    :ivar action_type: Action type. Example: Permit | Deny | Continue. Required. Known values are:
     "Permit", "Deny", "Continue", and "Continue".
    :vartype action_type: str or ~azure.mgmt.managednetworkfabric.models.RoutePolicyActionType
    :ivar ip_community_properties: IP Community Properties.
    :vartype ip_community_properties:
     ~azure.mgmt.managednetworkfabric.models.ActionIpCommunityProperties
    :ivar ip_extended_community_properties: IP Extended Community Properties.
    :vartype ip_extended_community_properties:
     ~azure.mgmt.managednetworkfabric.models.ActionIpExtendedCommunityProperties
    """

    _validation = {
        "local_preference": {"maximum": 4294967295, "minimum": 0},
        "action_type": {"required": True},
    }

    _attribute_map = {
        "local_preference": {"key": "localPreference", "type": "int"},
        "action_type": {"key": "actionType", "type": "str"},
        "ip_community_properties": {"key": "ipCommunityProperties", "type": "ActionIpCommunityProperties"},
        "ip_extended_community_properties": {
            "key": "ipExtendedCommunityProperties",
            "type": "ActionIpExtendedCommunityProperties",
        },
    }

    def __init__(
        self,
        *,
        action_type: Union[str, "_models.RoutePolicyActionType"],
        local_preference: Optional[int] = None,
        ip_community_properties: Optional["_models.ActionIpCommunityProperties"] = None,
        ip_extended_community_properties: Optional["_models.ActionIpExtendedCommunityProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword local_preference: Local Preference of the route policy.
        :paramtype local_preference: int
        :keyword action_type: Action type. Example: Permit | Deny | Continue. Required. Known values
         are: "Permit", "Deny", "Continue", and "Continue".
        :paramtype action_type: str or ~azure.mgmt.managednetworkfabric.models.RoutePolicyActionType
        :keyword ip_community_properties: IP Community Properties.
        :paramtype ip_community_properties:
         ~azure.mgmt.managednetworkfabric.models.ActionIpCommunityProperties
        :keyword ip_extended_community_properties: IP Extended Community Properties.
        :paramtype ip_extended_community_properties:
         ~azure.mgmt.managednetworkfabric.models.ActionIpExtendedCommunityProperties
        """
        super().__init__(**kwargs)
        self.local_preference = local_preference
        self.action_type = action_type
        self.ip_community_properties = ip_community_properties
        self.ip_extended_community_properties = ip_extended_community_properties


class StatementConditionProperties(IpCommunityIdList, IpExtendedCommunityIdList):
    """Route policy statement condition properties.

    :ivar ip_extended_community_ids: List of IP Extended Community resource IDs.
    :vartype ip_extended_community_ids: list[str]
    :ivar ip_community_ids: List of IP Community resource IDs.
    :vartype ip_community_ids: list[str]
    :ivar type: Type of the condition used. Known values are: "Or", "And", "Or", and "And".
    :vartype type: str or ~azure.mgmt.managednetworkfabric.models.RoutePolicyConditionType
    :ivar ip_prefix_id: Arm Resource Id of IpPrefix.
    :vartype ip_prefix_id: str
    """

    _attribute_map = {
        "ip_extended_community_ids": {"key": "ipExtendedCommunityIds", "type": "[str]"},
        "ip_community_ids": {"key": "ipCommunityIds", "type": "[str]"},
        "type": {"key": "type", "type": "str"},
        "ip_prefix_id": {"key": "ipPrefixId", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_extended_community_ids: Optional[List[str]] = None,
        ip_community_ids: Optional[List[str]] = None,
        type: Union[str, "_models.RoutePolicyConditionType"] = "Or",
        ip_prefix_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_extended_community_ids: List of IP Extended Community resource IDs.
        :paramtype ip_extended_community_ids: list[str]
        :keyword ip_community_ids: List of IP Community resource IDs.
        :paramtype ip_community_ids: list[str]
        :keyword type: Type of the condition used. Known values are: "Or", "And", "Or", and "And".
        :paramtype type: str or ~azure.mgmt.managednetworkfabric.models.RoutePolicyConditionType
        :keyword ip_prefix_id: Arm Resource Id of IpPrefix.
        :paramtype ip_prefix_id: str
        """
        super().__init__(
            ip_community_ids=ip_community_ids, ip_extended_community_ids=ip_extended_community_ids, **kwargs
        )
        self.ip_extended_community_ids = ip_extended_community_ids
        self.type = type
        self.ip_prefix_id = ip_prefix_id
        self.ip_community_ids = ip_community_ids


class StaticRouteProperties(_serialization.Model):
    """Route Properties.

    All required parameters must be populated in order to send to Azure.

    :ivar prefix: Prefix of the route. Required.
    :vartype prefix: str
    :ivar next_hop: List of next hop addresses. Required.
    :vartype next_hop: list[str]
    """

    _validation = {
        "prefix": {"required": True, "min_length": 1},
        "next_hop": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "prefix": {"key": "prefix", "type": "str"},
        "next_hop": {"key": "nextHop", "type": "[str]"},
    }

    def __init__(self, *, prefix: str, next_hop: List[str], **kwargs: Any) -> None:
        """
        :keyword prefix: Prefix of the route. Required.
        :paramtype prefix: str
        :keyword next_hop: List of next hop addresses. Required.
        :paramtype next_hop: list[str]
        """
        super().__init__(**kwargs)
        self.prefix = prefix
        self.next_hop = next_hop


class SupportedConnectorProperties(_serialization.Model):
    """Supported connector properties.

    :ivar connector_type: Type of connector used. Example: Optical.
    :vartype connector_type: str
    :ivar max_speed_in_mbps: Maximum speed of the connector in Mbps.
    :vartype max_speed_in_mbps: int
    """

    _attribute_map = {
        "connector_type": {"key": "connectorType", "type": "str"},
        "max_speed_in_mbps": {"key": "maxSpeedInMbps", "type": "int"},
    }

    def __init__(
        self, *, connector_type: Optional[str] = None, max_speed_in_mbps: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword connector_type: Type of connector used. Example: Optical.
        :paramtype connector_type: str
        :keyword max_speed_in_mbps: Maximum speed of the connector in Mbps.
        :paramtype max_speed_in_mbps: int
        """
        super().__init__(**kwargs)
        self.connector_type = connector_type
        self.max_speed_in_mbps = max_speed_in_mbps


class SupportedVersionProperties(_serialization.Model):
    """Supported version details of the network device.

    :ivar version: Operating system and firmware combined versions.
    :vartype version: str
    :ivar vendor_os_version: Operating system version.
    :vartype vendor_os_version: str
    :ivar vendor_firmware_version: Firmware version.
    :vartype vendor_firmware_version: str
    :ivar is_default: If true newly provisioned Fabric will use this device version by default to
     bootstrap the network devices for the first time. Known values are: "True" and "False".
    :vartype is_default: str or ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
    """

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "vendor_os_version": {"key": "vendorOsVersion", "type": "str"},
        "vendor_firmware_version": {"key": "vendorFirmwareVersion", "type": "str"},
        "is_default": {"key": "isDefault", "type": "str"},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        vendor_os_version: Optional[str] = None,
        vendor_firmware_version: Optional[str] = None,
        is_default: Optional[Union[str, "_models.BooleanEnumProperty"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: Operating system and firmware combined versions.
        :paramtype version: str
        :keyword vendor_os_version: Operating system version.
        :paramtype vendor_os_version: str
        :keyword vendor_firmware_version: Firmware version.
        :paramtype vendor_firmware_version: str
        :keyword is_default: If true newly provisioned Fabric will use this device version by default
         to bootstrap the network devices for the first time. Known values are: "True" and "False".
        :paramtype is_default: str or ~azure.mgmt.managednetworkfabric.models.BooleanEnumProperty
        """
        super().__init__(**kwargs)
        self.version = version
        self.vendor_os_version = vendor_os_version
        self.vendor_firmware_version = vendor_firmware_version
        self.is_default = is_default


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.managednetworkfabric.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.managednetworkfabric.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.managednetworkfabric.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.managednetworkfabric.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TerminalServerConfiguration(TerminalServerPatchableProperties, Layer3IpPrefixProperties):
    """Network and credentials configuration currently applied to terminal server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
    :vartype secondary_ipv6_prefix: str
    :ivar username: Username for the terminal server connection.
    :vartype username: str
    :ivar password: Password for the terminal server connection.
    :vartype password: str
    :ivar serial_number: Serial Number of Terminal server.
    :vartype serial_number: str
    :ivar network_device_id: ARM Resource ID used for the NetworkDevice.
    :vartype network_device_id: str
    """

    _validation = {
        "username": {"min_length": 1},
        "password": {"min_length": 1},
        "serial_number": {"min_length": 1},
        "network_device_id": {"readonly": True},
    }

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "network_device_id": {"key": "networkDeviceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        serial_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
        :paramtype secondary_ipv6_prefix: str
        :keyword username: Username for the terminal server connection.
        :paramtype username: str
        :keyword password: Password for the terminal server connection.
        :paramtype password: str
        :keyword serial_number: Serial Number of Terminal server.
        :paramtype serial_number: str
        """
        super().__init__(
            username=username,
            password=password,
            serial_number=serial_number,
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            **kwargs
        )
        self.primary_ipv4_prefix = primary_ipv4_prefix
        self.primary_ipv6_prefix = primary_ipv6_prefix
        self.secondary_ipv4_prefix = secondary_ipv4_prefix
        self.secondary_ipv6_prefix = secondary_ipv6_prefix
        self.network_device_id = None
        self.username = username
        self.password = password
        self.serial_number = serial_number


class UpdateAdministrativeState(EnableDisableOnResources):
    """Update administrative state on list of resources.

    :ivar resource_ids: Network Fabrics or Network Rack resource Id.
    :vartype resource_ids: list[str]
    :ivar state: Administrative state. Known values are: "Enable" and "Disable".
    :vartype state: str or ~azure.mgmt.managednetworkfabric.models.EnableDisableState
    """

    _attribute_map = {
        "resource_ids": {"key": "resourceIds", "type": "[str]"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_ids: Optional[List[str]] = None,
        state: Optional[Union[str, "_models.EnableDisableState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_ids: Network Fabrics or Network Rack resource Id.
        :paramtype resource_ids: list[str]
        :keyword state: Administrative state. Known values are: "Enable" and "Disable".
        :paramtype state: str or ~azure.mgmt.managednetworkfabric.models.EnableDisableState
        """
        super().__init__(resource_ids=resource_ids, **kwargs)
        self.state = state


class UpdateDeviceAdministrativeState(EnableDisableOnResources):
    """Update the administrative state on list of resources.

    :ivar resource_ids: Network Fabrics or Network Rack resource Id.
    :vartype resource_ids: list[str]
    :ivar state: Administrative state. Known values are: "RMA", "Resync", "GracefulQuarantine", and
     "Quarantine".
    :vartype state: str or ~azure.mgmt.managednetworkfabric.models.DeviceAdministrativeState
    """

    _attribute_map = {
        "resource_ids": {"key": "resourceIds", "type": "[str]"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_ids: Optional[List[str]] = None,
        state: Optional[Union[str, "_models.DeviceAdministrativeState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_ids: Network Fabrics or Network Rack resource Id.
        :paramtype resource_ids: list[str]
        :keyword state: Administrative state. Known values are: "RMA", "Resync", "GracefulQuarantine",
         and "Quarantine".
        :paramtype state: str or ~azure.mgmt.managednetworkfabric.models.DeviceAdministrativeState
        """
        super().__init__(resource_ids=resource_ids, **kwargs)
        self.state = state


class UpdateVersion(_serialization.Model):
    """Update version properties.

    :ivar version: Specify the version.
    :vartype version: str
    """

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword version: Specify the version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.version = version


class ValidateConfigurationProperties(_serialization.Model):
    """Validation configuration properties.

    :ivar validate_action: Validate action that to be performed. Known values are: "Cabling",
     "Configuration", and "Connectivity".
    :vartype validate_action: str or ~azure.mgmt.managednetworkfabric.models.ValidateAction
    """

    _attribute_map = {
        "validate_action": {"key": "validateAction", "type": "str"},
    }

    def __init__(
        self, *, validate_action: Optional[Union[str, "_models.ValidateAction"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword validate_action: Validate action that to be performed. Known values are: "Cabling",
         "Configuration", and "Connectivity".
        :paramtype validate_action: str or ~azure.mgmt.managednetworkfabric.models.ValidateAction
        """
        super().__init__(**kwargs)
        self.validate_action = validate_action


class ValidateConfigurationResponse(ErrorResponse):
    """The response of the action validate configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.managednetworkfabric.models.ErrorDetail
    :ivar configuration_state: Gets the configuration state. Known values are: "Succeeded",
     "Failed", "Rejected", "Accepted", "Provisioned", "ErrorProvisioning", "Deprovisioning",
     "Deprovisioned", "ErrorDeprovisioning", and "DeferredControl".
    :vartype configuration_state: str or ~azure.mgmt.managednetworkfabric.models.ConfigurationState
    :ivar url: URL for the details of the response.
    :vartype url: str
    """

    _validation = {
        "configuration_state": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
        "configuration_state": {"key": "configurationState", "type": "str"},
        "url": {"key": "url", "type": "str"},
    }

    def __init__(
        self, *, error: Optional["_models.ErrorDetail"] = None, url: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.managednetworkfabric.models.ErrorDetail
        :keyword url: URL for the details of the response.
        :paramtype url: str
        """
        super().__init__(error=error, **kwargs)
        self.configuration_state = None
        self.url = url


class VlanGroupProperties(_serialization.Model):
    """Vlan group properties.

    :ivar name: Vlan group name.
    :vartype name: str
    :ivar vlans: List of vlans.
    :vartype vlans: list[str]
    """

    _validation = {
        "name": {"min_length": 1},
        "vlans": {"min_items": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "vlans": {"key": "vlans", "type": "[str]"},
    }

    def __init__(self, *, name: Optional[str] = None, vlans: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword name: Vlan group name.
        :paramtype name: str
        :keyword vlans: List of vlans.
        :paramtype vlans: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.vlans = vlans


class VlanMatchCondition(_serialization.Model):
    """The vlan match conditions that needs to be matched.

    :ivar vlans: List of vlans that needs to be matched.
    :vartype vlans: list[str]
    :ivar inner_vlans: List of inner vlans that needs to be matched.
    :vartype inner_vlans: list[str]
    :ivar vlan_group_names: List of vlan group names that to be matched.
    :vartype vlan_group_names: list[str]
    """

    _validation = {
        "vlans": {"min_items": 1},
        "inner_vlans": {"min_items": 1},
        "vlan_group_names": {"min_items": 1},
    }

    _attribute_map = {
        "vlans": {"key": "vlans", "type": "[str]"},
        "inner_vlans": {"key": "innerVlans", "type": "[str]"},
        "vlan_group_names": {"key": "vlanGroupNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        vlans: Optional[List[str]] = None,
        inner_vlans: Optional[List[str]] = None,
        vlan_group_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vlans: List of vlans that needs to be matched.
        :paramtype vlans: list[str]
        :keyword inner_vlans: List of inner vlans that needs to be matched.
        :paramtype inner_vlans: list[str]
        :keyword vlan_group_names: List of vlan group names that to be matched.
        :paramtype vlan_group_names: list[str]
        """
        super().__init__(**kwargs)
        self.vlans = vlans
        self.inner_vlans = inner_vlans
        self.vlan_group_names = vlan_group_names


class VpnConfigurationPatchableProperties(_serialization.Model):
    """Network and credential configuration currently applied on terminal server.

    :ivar network_to_network_interconnect_id: ARM Resource ID of the Network To Network
     Interconnect.
    :vartype network_to_network_interconnect_id: str
    :ivar peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties.
    :vartype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
    :ivar option_a_properties: option A properties.
    :vartype option_a_properties:
     ~azure.mgmt.managednetworkfabric.models.VpnConfigurationPatchablePropertiesOptionAProperties
    """

    _attribute_map = {
        "network_to_network_interconnect_id": {"key": "networkToNetworkInterconnectId", "type": "str"},
        "peering_option": {"key": "peeringOption", "type": "str"},
        "option_b_properties": {"key": "optionBProperties", "type": "OptionBProperties"},
        "option_a_properties": {
            "key": "optionAProperties",
            "type": "VpnConfigurationPatchablePropertiesOptionAProperties",
        },
    }

    def __init__(
        self,
        *,
        network_to_network_interconnect_id: Optional[str] = None,
        peering_option: Optional[Union[str, "_models.PeeringOption"]] = None,
        option_b_properties: Optional["_models.OptionBProperties"] = None,
        option_a_properties: Optional["_models.VpnConfigurationPatchablePropertiesOptionAProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_to_network_interconnect_id: ARM Resource ID of the Network To Network
         Interconnect.
        :paramtype network_to_network_interconnect_id: str
        :keyword peering_option: Peering option list. Known values are: "OptionA" and "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties.
        :paramtype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
        :keyword option_a_properties: option A properties.
        :paramtype option_a_properties:
         ~azure.mgmt.managednetworkfabric.models.VpnConfigurationPatchablePropertiesOptionAProperties
        """
        super().__init__(**kwargs)
        self.network_to_network_interconnect_id = network_to_network_interconnect_id
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties


class VpnConfigurationPatchablePropertiesOptionAProperties(OptionAProperties, Layer3IpPrefixProperties):
    """option A properties.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
    :vartype secondary_ipv6_prefix: str
    :ivar mtu: MTU to use for option A peering.
    :vartype mtu: int
    :ivar vlan_id: Vlan Id.Example : 501.
    :vartype vlan_id: int
    :ivar peer_asn: Peer ASN number.Example : 28.
    :vartype peer_asn: int
    :ivar bfd_configuration: BFD Configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
        "vlan_id": {"maximum": 4094, "minimum": 501},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
    }

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
        "mtu": {"key": "mtu", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        mtu: int = 1500,
        vlan_id: Optional[int] = None,
        peer_asn: Optional[int] = None,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
        :paramtype secondary_ipv6_prefix: str
        :keyword mtu: MTU to use for option A peering.
        :paramtype mtu: int
        :keyword vlan_id: Vlan Id.Example : 501.
        :paramtype vlan_id: int
        :keyword peer_asn: Peer ASN number.Example : 28.
        :paramtype peer_asn: int
        :keyword bfd_configuration: BFD Configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        """
        super().__init__(
            mtu=mtu,
            vlan_id=vlan_id,
            peer_asn=peer_asn,
            bfd_configuration=bfd_configuration,
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            **kwargs
        )
        self.primary_ipv4_prefix = primary_ipv4_prefix
        self.primary_ipv6_prefix = primary_ipv6_prefix
        self.secondary_ipv4_prefix = secondary_ipv4_prefix
        self.secondary_ipv6_prefix = secondary_ipv6_prefix
        self.mtu = mtu
        self.vlan_id = vlan_id
        self.peer_asn = peer_asn
        self.bfd_configuration = bfd_configuration


class VpnConfigurationProperties(_serialization.Model):
    """Network and credential configuration currently applied on terminal server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar network_to_network_interconnect_id: ARM Resource ID of the Network To Network
     Interconnect.
    :vartype network_to_network_interconnect_id: str
    :ivar administrative_state: Administrative state of the resource. Known values are: "Enabled",
     "Disabled", "MAT", and "RMA".
    :vartype administrative_state: str or
     ~azure.mgmt.managednetworkfabric.models.AdministrativeState
    :ivar peering_option: Peering option list. Required. Known values are: "OptionA" and "OptionB".
    :vartype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
    :ivar option_b_properties: option B properties.
    :vartype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
    :ivar option_a_properties: option A properties.
    :vartype option_a_properties:
     ~azure.mgmt.managednetworkfabric.models.VpnConfigurationPropertiesOptionAProperties
    """

    _validation = {
        "administrative_state": {"readonly": True},
        "peering_option": {"required": True},
    }

    _attribute_map = {
        "network_to_network_interconnect_id": {"key": "networkToNetworkInterconnectId", "type": "str"},
        "administrative_state": {"key": "administrativeState", "type": "str"},
        "peering_option": {"key": "peeringOption", "type": "str"},
        "option_b_properties": {"key": "optionBProperties", "type": "OptionBProperties"},
        "option_a_properties": {"key": "optionAProperties", "type": "VpnConfigurationPropertiesOptionAProperties"},
    }

    def __init__(
        self,
        *,
        peering_option: Union[str, "_models.PeeringOption"],
        network_to_network_interconnect_id: Optional[str] = None,
        option_b_properties: Optional["_models.OptionBProperties"] = None,
        option_a_properties: Optional["_models.VpnConfigurationPropertiesOptionAProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_to_network_interconnect_id: ARM Resource ID of the Network To Network
         Interconnect.
        :paramtype network_to_network_interconnect_id: str
        :keyword peering_option: Peering option list. Required. Known values are: "OptionA" and
         "OptionB".
        :paramtype peering_option: str or ~azure.mgmt.managednetworkfabric.models.PeeringOption
        :keyword option_b_properties: option B properties.
        :paramtype option_b_properties: ~azure.mgmt.managednetworkfabric.models.OptionBProperties
        :keyword option_a_properties: option A properties.
        :paramtype option_a_properties:
         ~azure.mgmt.managednetworkfabric.models.VpnConfigurationPropertiesOptionAProperties
        """
        super().__init__(**kwargs)
        self.network_to_network_interconnect_id = network_to_network_interconnect_id
        self.administrative_state = None
        self.peering_option = peering_option
        self.option_b_properties = option_b_properties
        self.option_a_properties = option_a_properties


class VpnConfigurationPropertiesOptionAProperties(OptionAProperties, Layer3IpPrefixProperties):
    """option A properties.

    :ivar primary_ipv4_prefix: IPv4 Address Prefix.
    :vartype primary_ipv4_prefix: str
    :ivar primary_ipv6_prefix: IPv6 Address Prefix.
    :vartype primary_ipv6_prefix: str
    :ivar secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
    :vartype secondary_ipv4_prefix: str
    :ivar secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
    :vartype secondary_ipv6_prefix: str
    :ivar mtu: MTU to use for option A peering.
    :vartype mtu: int
    :ivar vlan_id: Vlan Id.Example : 501.
    :vartype vlan_id: int
    :ivar peer_asn: Peer ASN number.Example : 28.
    :vartype peer_asn: int
    :ivar bfd_configuration: BFD Configuration properties.
    :vartype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
    """

    _validation = {
        "mtu": {"maximum": 9200, "minimum": 64},
        "vlan_id": {"maximum": 4094, "minimum": 501},
        "peer_asn": {"maximum": 4294967295, "minimum": 1},
    }

    _attribute_map = {
        "primary_ipv4_prefix": {"key": "primaryIpv4Prefix", "type": "str"},
        "primary_ipv6_prefix": {"key": "primaryIpv6Prefix", "type": "str"},
        "secondary_ipv4_prefix": {"key": "secondaryIpv4Prefix", "type": "str"},
        "secondary_ipv6_prefix": {"key": "secondaryIpv6Prefix", "type": "str"},
        "mtu": {"key": "mtu", "type": "int"},
        "vlan_id": {"key": "vlanId", "type": "int"},
        "peer_asn": {"key": "peerASN", "type": "int"},
        "bfd_configuration": {"key": "bfdConfiguration", "type": "BfdConfiguration"},
    }

    def __init__(
        self,
        *,
        primary_ipv4_prefix: Optional[str] = None,
        primary_ipv6_prefix: Optional[str] = None,
        secondary_ipv4_prefix: Optional[str] = None,
        secondary_ipv6_prefix: Optional[str] = None,
        mtu: int = 1500,
        vlan_id: Optional[int] = None,
        peer_asn: Optional[int] = None,
        bfd_configuration: Optional["_models.BfdConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_ipv4_prefix: IPv4 Address Prefix.
        :paramtype primary_ipv4_prefix: str
        :keyword primary_ipv6_prefix: IPv6 Address Prefix.
        :paramtype primary_ipv6_prefix: str
        :keyword secondary_ipv4_prefix: Secondary IPv4 Address Prefix.
        :paramtype secondary_ipv4_prefix: str
        :keyword secondary_ipv6_prefix: Secondary IPv6 Address Prefix.
        :paramtype secondary_ipv6_prefix: str
        :keyword mtu: MTU to use for option A peering.
        :paramtype mtu: int
        :keyword vlan_id: Vlan Id.Example : 501.
        :paramtype vlan_id: int
        :keyword peer_asn: Peer ASN number.Example : 28.
        :paramtype peer_asn: int
        :keyword bfd_configuration: BFD Configuration properties.
        :paramtype bfd_configuration: ~azure.mgmt.managednetworkfabric.models.BfdConfiguration
        """
        super().__init__(
            mtu=mtu,
            vlan_id=vlan_id,
            peer_asn=peer_asn,
            bfd_configuration=bfd_configuration,
            primary_ipv4_prefix=primary_ipv4_prefix,
            primary_ipv6_prefix=primary_ipv6_prefix,
            secondary_ipv4_prefix=secondary_ipv4_prefix,
            secondary_ipv6_prefix=secondary_ipv6_prefix,
            **kwargs
        )
        self.primary_ipv4_prefix = primary_ipv4_prefix
        self.primary_ipv6_prefix = primary_ipv6_prefix
        self.secondary_ipv4_prefix = secondary_ipv4_prefix
        self.secondary_ipv6_prefix = secondary_ipv6_prefix
        self.mtu = mtu
        self.vlan_id = vlan_id
        self.peer_asn = peer_asn
        self.bfd_configuration = bfd_configuration
