## opkssh audit

Validate policy file entries against provider definitions

### Synopsis

Audit validates all entries in /etc/opk/auth_id and ~/.opk/auth_id against the provider definitions in /etc/opk/providers. For complete audit details use the --json flag. Returns a non-zero exit code if any warnings or errors are found.

The audit command checks that:
  - Each issuer in policy files is defined in the providers file
  - The protocol (http:// or https://) exactly matches between policy and provider files
  - The auth_id policy files do not throw parsing errors

Results are reported with the following status:
  SUCCESS  - Entry is valid
  WARNING  - Entry is valid but may cause problems
  ERROR    - Entry has issues (missing provider, protocol mismatch, etc.)

Exit code: 0 if all entries are valid, 1 if any warnings or errors are found.

```
opkssh audit [flags]
```

### Examples

```
  opkssh audit
```

### Options

```
  -h, --help                    help for audit
  -j, --json                    Output complete audit results in JSON
      --policy-file string      Path to policy file (default "/etc/opk/auth_id")
      --providers-file string   Path to providers file (default "/etc/opk/providers")
      --skip-user-policy        Skip auditing user policy file (~/.opk/auth_id)
```

### SEE ALSO

* [opkssh](opkssh.md)	 - SSH with OpenPubkey

###### Auto generated by spf13/cobra on 21-Jan-2026
