! Offloading test checking interaction of an enter and exit map of an array of
! scalars
! REQUIRES: flang, amdgpu

! RUN: %libomptarget-compile-fortran-run-and-check-generic
program main
    integer :: array(10)

    do I = 1, 10
      array(I) = I + I
    end do

    !$omp target enter data map(to: array)
    ! Shouldn't overwrite data already locked in
    ! on target via enter, this will then be
    ! overwritten by our exit
    do I = 1, 10
      array(I) = 10
    end do

   !$omp target
    do i=1,10
      array(i) = array(i) + i
    end do
  !$omp end target

  !$omp target exit data map(from: array)
  print*, array
end program

!CHECK: 3 6 9 12 15 18 21 24 27 30
