/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2024 Intel Corporation
 */
#ifndef _XE_PMT_H_
#define _XE_PMT_H_

#include "xe_regs.h"

#define BMG_PMT_BASE_OFFSET		0xDB000
#define BMG_DISCOVERY_OFFSET		(SOC_BASE + BMG_PMT_BASE_OFFSET)

#define PUNIT_TELEMETRY_GUID		XE_REG(BMG_DISCOVERY_OFFSET + 0x4)
#define BMG_ENERGY_STATUS_PMT_OFFSET	(0x30)
#define	ENERGY_PKG			REG_GENMASK64(31, 0)
#define	ENERGY_CARD			REG_GENMASK64(63, 32)

#define BMG_TELEMETRY_BASE_OFFSET	0xE0000
#define BMG_TELEMETRY_OFFSET		(SOC_BASE + BMG_TELEMETRY_BASE_OFFSET)

#define SG_REMAP_INDEX1			XE_REG(SOC_BASE + 0x08)
#define   SG_REMAP_BITS			REG_GENMASK(31, 24)

#define BMG_MODS_RESIDENCY_OFFSET		(0x4D0)
#define BMG_G2_RESIDENCY_OFFSET		(0x530)
#define BMG_G6_RESIDENCY_OFFSET		(0x538)
#define BMG_G7_RESIDENCY_OFFSET		(0x4B0)
#define BMG_G8_RESIDENCY_OFFSET		(0x540)
#define BMG_G10_RESIDENCY_OFFSET		(0x548)

#define BMG_PCIE_LINK_L0_RESIDENCY_OFFSET	(0x570)
#define BMG_PCIE_LINK_L1_RESIDENCY_OFFSET	(0x578)
#define BMG_PCIE_LINK_L1_2_RESIDENCY_OFFSET	(0x580)

#endif
