// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/baremetalsolution/v2/network.proto

package baremetalsolutionpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Network type.
type Network_Type int32

const (
	// Unspecified value.
	Network_TYPE_UNSPECIFIED Network_Type = 0
	// Client network, a network peered to a Google Cloud VPC.
	Network_CLIENT Network_Type = 1
	// Private network, a network local to the Bare Metal Solution environment.
	Network_PRIVATE Network_Type = 2
)

// Enum value maps for Network_Type.
var (
	Network_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "CLIENT",
		2: "PRIVATE",
	}
	Network_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"CLIENT":           1,
		"PRIVATE":          2,
	}
)

func (x Network_Type) Enum() *Network_Type {
	p := new(Network_Type)
	*p = x
	return p
}

func (x Network_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Network_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_network_proto_enumTypes[0].Descriptor()
}

func (Network_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_network_proto_enumTypes[0]
}

func (x Network_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Network_Type.Descriptor instead.
func (Network_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{0, 0}
}

// The possible states for this Network.
type Network_State int32

const (
	// The Network is in an unknown state.
	Network_STATE_UNSPECIFIED Network_State = 0
	// The Network is provisioning.
	Network_PROVISIONING Network_State = 1
	// The Network has been provisioned.
	Network_PROVISIONED Network_State = 2
	// The Network is being deprovisioned.
	Network_DEPROVISIONING Network_State = 3
	// The Network is being updated.
	Network_UPDATING Network_State = 4
)

// Enum value maps for Network_State.
var (
	Network_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONING",
		2: "PROVISIONED",
		3: "DEPROVISIONING",
		4: "UPDATING",
	}
	Network_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROVISIONING":      1,
		"PROVISIONED":       2,
		"DEPROVISIONING":    3,
		"UPDATING":          4,
	}
)

func (x Network_State) Enum() *Network_State {
	p := new(Network_State)
	*p = x
	return p
}

func (x Network_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Network_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_network_proto_enumTypes[1].Descriptor()
}

func (Network_State) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_network_proto_enumTypes[1]
}

func (x Network_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Network_State.Descriptor instead.
func (Network_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{0, 1}
}

// The possible states for this VRF.
type VRF_State int32

const (
	// The unspecified state.
	VRF_STATE_UNSPECIFIED VRF_State = 0
	// The vrf is provisioning.
	VRF_PROVISIONING VRF_State = 1
	// The vrf is provisioned.
	VRF_PROVISIONED VRF_State = 2
)

// Enum value maps for VRF_State.
var (
	VRF_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONING",
		2: "PROVISIONED",
	}
	VRF_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROVISIONING":      1,
		"PROVISIONED":       2,
	}
)

func (x VRF_State) Enum() *VRF_State {
	p := new(VRF_State)
	*p = x
	return p
}

func (x VRF_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VRF_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_network_proto_enumTypes[2].Descriptor()
}

func (VRF_State) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_network_proto_enumTypes[2]
}

func (x VRF_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VRF_State.Descriptor instead.
func (VRF_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{2, 0}
}

// A Network.
type Network struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this `Network`.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// Format:
	// `projects/{project}/locations/{location}/networks/{network}`
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// An identifier for the `Network`, generated by the backend.
	Id string `protobuf:"bytes,10,opt,name=id,proto3" json:"id,omitempty"`
	// The type of this network.
	Type Network_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.baremetalsolution.v2.Network_Type" json:"type,omitempty"`
	// IP address configured.
	IpAddress string `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// List of physical interfaces.
	MacAddress []string `protobuf:"bytes,4,rep,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// The Network state.
	State Network_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.baremetalsolution.v2.Network_State" json:"state,omitempty"`
	// The vlan id of the Network.
	VlanId string `protobuf:"bytes,7,opt,name=vlan_id,json=vlanId,proto3" json:"vlan_id,omitempty"`
	// The cidr of the Network.
	Cidr string `protobuf:"bytes,8,opt,name=cidr,proto3" json:"cidr,omitempty"`
	// The vrf for the Network.
	Vrf *VRF `protobuf:"bytes,9,opt,name=vrf,proto3" json:"vrf,omitempty"`
	// Labels as key value pairs.
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// IP range for reserved for services (e.g. NFS).
	ServicesCidr string `protobuf:"bytes,12,opt,name=services_cidr,json=servicesCidr,proto3" json:"services_cidr,omitempty"`
	// List of IP address reservations in this network.
	// When updating this field, an error will be generated if a reservation
	// conflicts with an IP address already allocated to a physical server.
	Reservations []*NetworkAddressReservation `protobuf:"bytes,13,rep,name=reservations,proto3" json:"reservations,omitempty"`
	// Output only. Pod name.
	Pod string `protobuf:"bytes,14,opt,name=pod,proto3" json:"pod,omitempty"`
	// Input only. List of mount points to attach the network to.
	MountPoints []*NetworkMountPoint `protobuf:"bytes,15,rep,name=mount_points,json=mountPoints,proto3" json:"mount_points,omitempty"`
	// Whether network uses standard frames or jumbo ones.
	JumboFramesEnabled bool `protobuf:"varint,16,opt,name=jumbo_frames_enabled,json=jumboFramesEnabled,proto3" json:"jumbo_frames_enabled,omitempty"`
	// Output only. Gateway ip address.
	GatewayIp string `protobuf:"bytes,17,opt,name=gateway_ip,json=gatewayIp,proto3" json:"gateway_ip,omitempty"`
}

func (x *Network) Reset() {
	*x = Network{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Network) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Network) ProtoMessage() {}

func (x *Network) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Network.ProtoReflect.Descriptor instead.
func (*Network) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{0}
}

func (x *Network) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Network) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Network) GetType() Network_Type {
	if x != nil {
		return x.Type
	}
	return Network_TYPE_UNSPECIFIED
}

func (x *Network) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *Network) GetMacAddress() []string {
	if x != nil {
		return x.MacAddress
	}
	return nil
}

func (x *Network) GetState() Network_State {
	if x != nil {
		return x.State
	}
	return Network_STATE_UNSPECIFIED
}

func (x *Network) GetVlanId() string {
	if x != nil {
		return x.VlanId
	}
	return ""
}

func (x *Network) GetCidr() string {
	if x != nil {
		return x.Cidr
	}
	return ""
}

func (x *Network) GetVrf() *VRF {
	if x != nil {
		return x.Vrf
	}
	return nil
}

func (x *Network) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Network) GetServicesCidr() string {
	if x != nil {
		return x.ServicesCidr
	}
	return ""
}

func (x *Network) GetReservations() []*NetworkAddressReservation {
	if x != nil {
		return x.Reservations
	}
	return nil
}

func (x *Network) GetPod() string {
	if x != nil {
		return x.Pod
	}
	return ""
}

func (x *Network) GetMountPoints() []*NetworkMountPoint {
	if x != nil {
		return x.MountPoints
	}
	return nil
}

func (x *Network) GetJumboFramesEnabled() bool {
	if x != nil {
		return x.JumboFramesEnabled
	}
	return false
}

func (x *Network) GetGatewayIp() string {
	if x != nil {
		return x.GatewayIp
	}
	return ""
}

// A reservation of one or more addresses in a network.
type NetworkAddressReservation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The first address of this reservation block.
	// Must be specified as a single IPv4 address, e.g. 10.1.2.2.
	StartAddress string `protobuf:"bytes,1,opt,name=start_address,json=startAddress,proto3" json:"start_address,omitempty"`
	// The last address of this reservation block, inclusive. I.e., for cases when
	// reservations are only single addresses, end_address and start_address will
	// be the same.
	// Must be specified as a single IPv4 address, e.g. 10.1.2.2.
	EndAddress string `protobuf:"bytes,2,opt,name=end_address,json=endAddress,proto3" json:"end_address,omitempty"`
	// A note about this reservation, intended for human consumption.
	Note string `protobuf:"bytes,3,opt,name=note,proto3" json:"note,omitempty"`
}

func (x *NetworkAddressReservation) Reset() {
	*x = NetworkAddressReservation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkAddressReservation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkAddressReservation) ProtoMessage() {}

func (x *NetworkAddressReservation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkAddressReservation.ProtoReflect.Descriptor instead.
func (*NetworkAddressReservation) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{1}
}

func (x *NetworkAddressReservation) GetStartAddress() string {
	if x != nil {
		return x.StartAddress
	}
	return ""
}

func (x *NetworkAddressReservation) GetEndAddress() string {
	if x != nil {
		return x.EndAddress
	}
	return ""
}

func (x *NetworkAddressReservation) GetNote() string {
	if x != nil {
		return x.Note
	}
	return ""
}

// A network VRF.
type VRF struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the VRF.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The possible state of VRF.
	State VRF_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.baremetalsolution.v2.VRF_State" json:"state,omitempty"`
	// The QOS policy applied to this VRF.
	// The value is only meaningful when all the vlan attachments have the same
	// QoS. This field should not be used for new integrations, use vlan
	// attachment level qos instead. The field is left for backward-compatibility.
	QosPolicy *VRF_QosPolicy `protobuf:"bytes,6,opt,name=qos_policy,json=qosPolicy,proto3" json:"qos_policy,omitempty"`
	// The list of VLAN attachments for the VRF.
	VlanAttachments []*VRF_VlanAttachment `protobuf:"bytes,7,rep,name=vlan_attachments,json=vlanAttachments,proto3" json:"vlan_attachments,omitempty"`
}

func (x *VRF) Reset() {
	*x = VRF{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VRF) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VRF) ProtoMessage() {}

func (x *VRF) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VRF.ProtoReflect.Descriptor instead.
func (*VRF) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{2}
}

func (x *VRF) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VRF) GetState() VRF_State {
	if x != nil {
		return x.State
	}
	return VRF_STATE_UNSPECIFIED
}

func (x *VRF) GetQosPolicy() *VRF_QosPolicy {
	if x != nil {
		return x.QosPolicy
	}
	return nil
}

func (x *VRF) GetVlanAttachments() []*VRF_VlanAttachment {
	if x != nil {
		return x.VlanAttachments
	}
	return nil
}

// Each logical interface represents a logical abstraction of the underlying
// physical interface (for eg. bond, nic) of the instance. Each logical
// interface can effectively map to multiple network-IP pairs and still be
// mapped to one underlying physical interface.
type LogicalInterface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of logical network interfaces within a logical interface.
	LogicalNetworkInterfaces []*LogicalInterface_LogicalNetworkInterface `protobuf:"bytes,1,rep,name=logical_network_interfaces,json=logicalNetworkInterfaces,proto3" json:"logical_network_interfaces,omitempty"`
	// Interface name. This is of syntax <bond><bond_mode> or <nic> and
	// forms part of the network template name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The index of the logical interface mapping to the index of the hardware
	// bond or nic on the chosen network template. This field is deprecated.
	//
	// Deprecated: Marked as deprecated in google/cloud/baremetalsolution/v2/network.proto.
	InterfaceIndex int32 `protobuf:"varint,3,opt,name=interface_index,json=interfaceIndex,proto3" json:"interface_index,omitempty"`
}

func (x *LogicalInterface) Reset() {
	*x = LogicalInterface{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogicalInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogicalInterface) ProtoMessage() {}

func (x *LogicalInterface) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogicalInterface.ProtoReflect.Descriptor instead.
func (*LogicalInterface) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{3}
}

func (x *LogicalInterface) GetLogicalNetworkInterfaces() []*LogicalInterface_LogicalNetworkInterface {
	if x != nil {
		return x.LogicalNetworkInterfaces
	}
	return nil
}

func (x *LogicalInterface) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/baremetalsolution/v2/network.proto.
func (x *LogicalInterface) GetInterfaceIndex() int32 {
	if x != nil {
		return x.InterfaceIndex
	}
	return 0
}

// Message for requesting network information.
type GetNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNetworkRequest) Reset() {
	*x = GetNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNetworkRequest) ProtoMessage() {}

func (x *GetNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNetworkRequest.ProtoReflect.Descriptor instead.
func (*GetNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{4}
}

func (x *GetNetworkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for requesting a list of networks.
type ListNetworksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListNetworksRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. The server might return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results from the server.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// List filter.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListNetworksRequest) Reset() {
	*x = ListNetworksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNetworksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNetworksRequest) ProtoMessage() {}

func (x *ListNetworksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNetworksRequest.ProtoReflect.Descriptor instead.
func (*ListNetworksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{5}
}

func (x *ListNetworksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNetworksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNetworksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListNetworksRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message containing the list of networks.
type ListNetworksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of networks.
	Networks []*Network `protobuf:"bytes,1,rep,name=networks,proto3" json:"networks,omitempty"`
	// A token identifying a page of results from the server.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListNetworksResponse) Reset() {
	*x = ListNetworksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNetworksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNetworksResponse) ProtoMessage() {}

func (x *ListNetworksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNetworksResponse.ProtoReflect.Descriptor instead.
func (*ListNetworksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{6}
}

func (x *ListNetworksResponse) GetNetworks() []*Network {
	if x != nil {
		return x.Networks
	}
	return nil
}

func (x *ListNetworksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListNetworksResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message requesting to updating a network.
type UpdateNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The network to update.
	//
	// The `name` field is used to identify the instance to update.
	// Format: projects/{project}/locations/{location}/networks/{network}
	Network *Network `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// The list of fields to update.
	// The only currently supported fields are:
	//
	//	`labels`, `reservations`, `vrf.vlan_attachments`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateNetworkRequest) Reset() {
	*x = UpdateNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNetworkRequest) ProtoMessage() {}

func (x *UpdateNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNetworkRequest.ProtoReflect.Descriptor instead.
func (*UpdateNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateNetworkRequest) GetNetwork() *Network {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *UpdateNetworkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Network with all used IP addresses.
type NetworkUsage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Network.
	Network *Network `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// All used IP addresses in this network.
	UsedIps []string `protobuf:"bytes,2,rep,name=used_ips,json=usedIps,proto3" json:"used_ips,omitempty"`
}

func (x *NetworkUsage) Reset() {
	*x = NetworkUsage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkUsage) ProtoMessage() {}

func (x *NetworkUsage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkUsage.ProtoReflect.Descriptor instead.
func (*NetworkUsage) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{8}
}

func (x *NetworkUsage) GetNetwork() *Network {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *NetworkUsage) GetUsedIps() []string {
	if x != nil {
		return x.UsedIps
	}
	return nil
}

// Request to get networks with IPs.
type ListNetworkUsageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value (project and location).
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *ListNetworkUsageRequest) Reset() {
	*x = ListNetworkUsageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNetworkUsageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNetworkUsageRequest) ProtoMessage() {}

func (x *ListNetworkUsageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNetworkUsageRequest.ProtoReflect.Descriptor instead.
func (*ListNetworkUsageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{9}
}

func (x *ListNetworkUsageRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Response with Networks with IPs
type ListNetworkUsageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Networks with IPs.
	Networks []*NetworkUsage `protobuf:"bytes,1,rep,name=networks,proto3" json:"networks,omitempty"`
}

func (x *ListNetworkUsageResponse) Reset() {
	*x = ListNetworkUsageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNetworkUsageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNetworkUsageResponse) ProtoMessage() {}

func (x *ListNetworkUsageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNetworkUsageResponse.ProtoReflect.Descriptor instead.
func (*ListNetworkUsageResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{10}
}

func (x *ListNetworkUsageResponse) GetNetworks() []*NetworkUsage {
	if x != nil {
		return x.Networks
	}
	return nil
}

// Mount point for a network.
type NetworkMountPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instance to attach network to.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Logical interface to detach from.
	LogicalInterface string `protobuf:"bytes,2,opt,name=logical_interface,json=logicalInterface,proto3" json:"logical_interface,omitempty"`
	// Network should be a default gateway.
	DefaultGateway bool `protobuf:"varint,3,opt,name=default_gateway,json=defaultGateway,proto3" json:"default_gateway,omitempty"`
	// Ip address of the server.
	IpAddress string `protobuf:"bytes,4,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
}

func (x *NetworkMountPoint) Reset() {
	*x = NetworkMountPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkMountPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkMountPoint) ProtoMessage() {}

func (x *NetworkMountPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkMountPoint.ProtoReflect.Descriptor instead.
func (*NetworkMountPoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{11}
}

func (x *NetworkMountPoint) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *NetworkMountPoint) GetLogicalInterface() string {
	if x != nil {
		return x.LogicalInterface
	}
	return ""
}

func (x *NetworkMountPoint) GetDefaultGateway() bool {
	if x != nil {
		return x.DefaultGateway
	}
	return false
}

func (x *NetworkMountPoint) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

// Message requesting rename of a server.
type RenameNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `name` field is used to identify the network.
	// Format: projects/{project}/locations/{location}/networks/{network}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new `id` of the network.
	NewNetworkId string `protobuf:"bytes,2,opt,name=new_network_id,json=newNetworkId,proto3" json:"new_network_id,omitempty"`
}

func (x *RenameNetworkRequest) Reset() {
	*x = RenameNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenameNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameNetworkRequest) ProtoMessage() {}

func (x *RenameNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameNetworkRequest.ProtoReflect.Descriptor instead.
func (*RenameNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{12}
}

func (x *RenameNetworkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RenameNetworkRequest) GetNewNetworkId() string {
	if x != nil {
		return x.NewNetworkId
	}
	return ""
}

// QOS policy parameters.
type VRF_QosPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The bandwidth permitted by the QOS policy, in gbps.
	BandwidthGbps float64 `protobuf:"fixed64,1,opt,name=bandwidth_gbps,json=bandwidthGbps,proto3" json:"bandwidth_gbps,omitempty"`
}

func (x *VRF_QosPolicy) Reset() {
	*x = VRF_QosPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VRF_QosPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VRF_QosPolicy) ProtoMessage() {}

func (x *VRF_QosPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VRF_QosPolicy.ProtoReflect.Descriptor instead.
func (*VRF_QosPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{2, 0}
}

func (x *VRF_QosPolicy) GetBandwidthGbps() float64 {
	if x != nil {
		return x.BandwidthGbps
	}
	return 0
}

// VLAN attachment details.
type VRF_VlanAttachment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The peer vlan ID of the attachment.
	PeerVlanId int64 `protobuf:"varint,1,opt,name=peer_vlan_id,json=peerVlanId,proto3" json:"peer_vlan_id,omitempty"`
	// The peer IP of the attachment.
	PeerIp string `protobuf:"bytes,2,opt,name=peer_ip,json=peerIp,proto3" json:"peer_ip,omitempty"`
	// The router IP of the attachment.
	RouterIp string `protobuf:"bytes,3,opt,name=router_ip,json=routerIp,proto3" json:"router_ip,omitempty"`
	// Input only. Pairing key.
	PairingKey string `protobuf:"bytes,4,opt,name=pairing_key,json=pairingKey,proto3" json:"pairing_key,omitempty"`
	// The QOS policy applied to this VLAN attachment.
	// This value should be preferred to using qos at vrf level.
	QosPolicy *VRF_QosPolicy `protobuf:"bytes,5,opt,name=qos_policy,json=qosPolicy,proto3" json:"qos_policy,omitempty"`
	// Immutable. The identifier of the attachment within vrf.
	Id string `protobuf:"bytes,6,opt,name=id,proto3" json:"id,omitempty"`
	// Optional. The name of the vlan attachment within vrf. This is of the form
	// projects/{project_number}/regions/{region}/interconnectAttachments/{interconnect_attachment}
	InterconnectAttachment string `protobuf:"bytes,7,opt,name=interconnect_attachment,json=interconnectAttachment,proto3" json:"interconnect_attachment,omitempty"`
}

func (x *VRF_VlanAttachment) Reset() {
	*x = VRF_VlanAttachment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VRF_VlanAttachment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VRF_VlanAttachment) ProtoMessage() {}

func (x *VRF_VlanAttachment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VRF_VlanAttachment.ProtoReflect.Descriptor instead.
func (*VRF_VlanAttachment) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{2, 1}
}

func (x *VRF_VlanAttachment) GetPeerVlanId() int64 {
	if x != nil {
		return x.PeerVlanId
	}
	return 0
}

func (x *VRF_VlanAttachment) GetPeerIp() string {
	if x != nil {
		return x.PeerIp
	}
	return ""
}

func (x *VRF_VlanAttachment) GetRouterIp() string {
	if x != nil {
		return x.RouterIp
	}
	return ""
}

func (x *VRF_VlanAttachment) GetPairingKey() string {
	if x != nil {
		return x.PairingKey
	}
	return ""
}

func (x *VRF_VlanAttachment) GetQosPolicy() *VRF_QosPolicy {
	if x != nil {
		return x.QosPolicy
	}
	return nil
}

func (x *VRF_VlanAttachment) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *VRF_VlanAttachment) GetInterconnectAttachment() string {
	if x != nil {
		return x.InterconnectAttachment
	}
	return ""
}

// Each logical network interface is effectively a network and IP pair.
type LogicalInterface_LogicalNetworkInterface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the network
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// IP address in the network
	IpAddress string `protobuf:"bytes,2,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// Whether this interface is the default gateway for the instance. Only
	// one interface can be the default gateway for the instance.
	DefaultGateway bool `protobuf:"varint,3,opt,name=default_gateway,json=defaultGateway,proto3" json:"default_gateway,omitempty"`
	// Type of network.
	NetworkType Network_Type `protobuf:"varint,4,opt,name=network_type,json=networkType,proto3,enum=google.cloud.baremetalsolution.v2.Network_Type" json:"network_type,omitempty"`
	// An identifier for the `Network`, generated by the backend.
	Id string `protobuf:"bytes,5,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *LogicalInterface_LogicalNetworkInterface) Reset() {
	*x = LogicalInterface_LogicalNetworkInterface{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogicalInterface_LogicalNetworkInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogicalInterface_LogicalNetworkInterface) ProtoMessage() {}

func (x *LogicalInterface_LogicalNetworkInterface) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogicalInterface_LogicalNetworkInterface.ProtoReflect.Descriptor instead.
func (*LogicalInterface_LogicalNetworkInterface) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP(), []int{3, 0}
}

func (x *LogicalInterface_LogicalNetworkInterface) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *LogicalInterface_LogicalNetworkInterface) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *LogicalInterface_LogicalNetworkInterface) GetDefaultGateway() bool {
	if x != nil {
		return x.DefaultGateway
	}
	return false
}

func (x *LogicalInterface_LogicalNetworkInterface) GetNetworkType() Network_Type {
	if x != nil {
		return x.NetworkType
	}
	return Network_TYPE_UNSPECIFIED
}

func (x *LogicalInterface_LogicalNetworkInterface) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

var File_google_cloud_baremetalsolution_v2_network_proto protoreflect.FileDescriptor

var file_google_cloud_baremetalsolution_v2_network_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2f, 0x76, 0x32, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xca, 0x08, 0x0a, 0x07, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x43, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6d,
	0x61, 0x63, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0a, 0x6d, 0x61, 0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x46, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x76, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x6c, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x12, 0x0a,
	0x04, 0x63, 0x69, 0x64, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x69, 0x64,
	0x72, 0x12, 0x38, 0x0a, 0x03, 0x76, 0x72, 0x66, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x56, 0x52, 0x46, 0x52, 0x03, 0x76, 0x72, 0x66, 0x12, 0x4e, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x43, 0x69, 0x64, 0x72,
	0x12, 0x60, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x15, 0x0a, 0x03, 0x70, 0x6f, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x70, 0x6f, 0x64, 0x12, 0x5c, 0x0a, 0x0c, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x6f, 0x75, 0x6e, 0x74,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0b, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x6a, 0x75, 0x6d, 0x62, 0x6f,
	0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x6a, 0x75, 0x6d, 0x62, 0x6f, 0x46, 0x72, 0x61, 0x6d,
	0x65, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x70, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x70, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x35, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x02, 0x22,
	0x63, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x3a, 0x69, 0xea, 0x41, 0x66, 0x0a, 0x28, 0x62, 0x61, 0x72, 0x65, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x7d, 0x22,
	0x75, 0x0a, 0x19, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x6e, 0x64, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x6f, 0x74, 0x65, 0x22, 0xee, 0x05, 0x0a, 0x03, 0x56, 0x52, 0x46, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x52, 0x46, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4f, 0x0a, 0x0a, 0x71, 0x6f, 0x73, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56,
	0x52, 0x46, 0x2e, 0x51, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x09, 0x71, 0x6f,
	0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x60, 0x0a, 0x10, 0x76, 0x6c, 0x61, 0x6e, 0x5f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x52, 0x46, 0x2e, 0x56, 0x6c, 0x61, 0x6e, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0f, 0x76, 0x6c, 0x61, 0x6e, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x32, 0x0a, 0x09, 0x51, 0x6f, 0x73,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x5f, 0x67, 0x62, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0d,
	0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x47, 0x62, 0x70, 0x73, 0x1a, 0xe4, 0x02,
	0x0a, 0x0e, 0x56, 0x6c, 0x61, 0x6e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x0c, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x76, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x70, 0x65, 0x65, 0x72, 0x56, 0x6c, 0x61, 0x6e,
	0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x65, 0x65, 0x72, 0x49, 0x70, 0x12, 0x1b, 0x0a, 0x09, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x49, 0x70, 0x12, 0x24, 0x0a, 0x0b, 0x70, 0x61, 0x69, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x04, 0x52, 0x0a, 0x70, 0x61, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x4f,
	0x0a, 0x0a, 0x71, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x52, 0x46, 0x2e, 0x51, 0x6f, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x09, 0x71, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x6e, 0x0a, 0x17, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x16, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x22, 0x41, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53,
	0x49, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x02, 0x22, 0xc1, 0x03, 0x0a, 0x10, 0x4c, 0x6f, 0x67, 0x69,
	0x63, 0x61, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x89, 0x01, 0x0a,
	0x1a, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x18,
	0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x1a, 0xdf, 0x01, 0x0a, 0x17, 0x4c, 0x6f,
	0x67, 0x69, 0x63, 0x61, 0x6c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x52, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72,
	0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x59, 0x0a, 0x11, 0x47,
	0x65, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61,
	0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xac, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa8, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46,
	0x0a, 0x08, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x08, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x9e, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x6f, 0x0a, 0x0c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x44, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x19, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x64, 0x5f,
	0x69, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x75, 0x73, 0x65, 0x64, 0x49,
	0x70, 0x73, 0x22, 0x60, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x4b, 0x0a, 0x08, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x08, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x22, 0xd4, 0x01,
	0x0a, 0x11, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x2b, 0x0a, 0x11, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6c, 0x6f, 0x67, 0x69,
	0x63, 0x61, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x22, 0x87, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x0e, 0x6e, 0x65, 0x77, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x6e, 0x65, 0x77, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x42, 0x85,
	0x03, 0xea, 0x41, 0x86, 0x01, 0x0a, 0x2d, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x55, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x0a, 0x25, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x42, 0x0c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61,
	0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x70, 0x62, 0x3b, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c,
	0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x21, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x61, 0x72, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x32, 0xea,
	0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_baremetalsolution_v2_network_proto_rawDescOnce sync.Once
	file_google_cloud_baremetalsolution_v2_network_proto_rawDescData = file_google_cloud_baremetalsolution_v2_network_proto_rawDesc
)

func file_google_cloud_baremetalsolution_v2_network_proto_rawDescGZIP() []byte {
	file_google_cloud_baremetalsolution_v2_network_proto_rawDescOnce.Do(func() {
		file_google_cloud_baremetalsolution_v2_network_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_baremetalsolution_v2_network_proto_rawDescData)
	})
	return file_google_cloud_baremetalsolution_v2_network_proto_rawDescData
}

var file_google_cloud_baremetalsolution_v2_network_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_baremetalsolution_v2_network_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_baremetalsolution_v2_network_proto_goTypes = []interface{}{
	(Network_Type)(0),                                // 0: google.cloud.baremetalsolution.v2.Network.Type
	(Network_State)(0),                               // 1: google.cloud.baremetalsolution.v2.Network.State
	(VRF_State)(0),                                   // 2: google.cloud.baremetalsolution.v2.VRF.State
	(*Network)(nil),                                  // 3: google.cloud.baremetalsolution.v2.Network
	(*NetworkAddressReservation)(nil),                // 4: google.cloud.baremetalsolution.v2.NetworkAddressReservation
	(*VRF)(nil),                                      // 5: google.cloud.baremetalsolution.v2.VRF
	(*LogicalInterface)(nil),                         // 6: google.cloud.baremetalsolution.v2.LogicalInterface
	(*GetNetworkRequest)(nil),                        // 7: google.cloud.baremetalsolution.v2.GetNetworkRequest
	(*ListNetworksRequest)(nil),                      // 8: google.cloud.baremetalsolution.v2.ListNetworksRequest
	(*ListNetworksResponse)(nil),                     // 9: google.cloud.baremetalsolution.v2.ListNetworksResponse
	(*UpdateNetworkRequest)(nil),                     // 10: google.cloud.baremetalsolution.v2.UpdateNetworkRequest
	(*NetworkUsage)(nil),                             // 11: google.cloud.baremetalsolution.v2.NetworkUsage
	(*ListNetworkUsageRequest)(nil),                  // 12: google.cloud.baremetalsolution.v2.ListNetworkUsageRequest
	(*ListNetworkUsageResponse)(nil),                 // 13: google.cloud.baremetalsolution.v2.ListNetworkUsageResponse
	(*NetworkMountPoint)(nil),                        // 14: google.cloud.baremetalsolution.v2.NetworkMountPoint
	(*RenameNetworkRequest)(nil),                     // 15: google.cloud.baremetalsolution.v2.RenameNetworkRequest
	nil,                                              // 16: google.cloud.baremetalsolution.v2.Network.LabelsEntry
	(*VRF_QosPolicy)(nil),                            // 17: google.cloud.baremetalsolution.v2.VRF.QosPolicy
	(*VRF_VlanAttachment)(nil),                       // 18: google.cloud.baremetalsolution.v2.VRF.VlanAttachment
	(*LogicalInterface_LogicalNetworkInterface)(nil), // 19: google.cloud.baremetalsolution.v2.LogicalInterface.LogicalNetworkInterface
	(*fieldmaskpb.FieldMask)(nil),                    // 20: google.protobuf.FieldMask
}
var file_google_cloud_baremetalsolution_v2_network_proto_depIdxs = []int32{
	0,  // 0: google.cloud.baremetalsolution.v2.Network.type:type_name -> google.cloud.baremetalsolution.v2.Network.Type
	1,  // 1: google.cloud.baremetalsolution.v2.Network.state:type_name -> google.cloud.baremetalsolution.v2.Network.State
	5,  // 2: google.cloud.baremetalsolution.v2.Network.vrf:type_name -> google.cloud.baremetalsolution.v2.VRF
	16, // 3: google.cloud.baremetalsolution.v2.Network.labels:type_name -> google.cloud.baremetalsolution.v2.Network.LabelsEntry
	4,  // 4: google.cloud.baremetalsolution.v2.Network.reservations:type_name -> google.cloud.baremetalsolution.v2.NetworkAddressReservation
	14, // 5: google.cloud.baremetalsolution.v2.Network.mount_points:type_name -> google.cloud.baremetalsolution.v2.NetworkMountPoint
	2,  // 6: google.cloud.baremetalsolution.v2.VRF.state:type_name -> google.cloud.baremetalsolution.v2.VRF.State
	17, // 7: google.cloud.baremetalsolution.v2.VRF.qos_policy:type_name -> google.cloud.baremetalsolution.v2.VRF.QosPolicy
	18, // 8: google.cloud.baremetalsolution.v2.VRF.vlan_attachments:type_name -> google.cloud.baremetalsolution.v2.VRF.VlanAttachment
	19, // 9: google.cloud.baremetalsolution.v2.LogicalInterface.logical_network_interfaces:type_name -> google.cloud.baremetalsolution.v2.LogicalInterface.LogicalNetworkInterface
	3,  // 10: google.cloud.baremetalsolution.v2.ListNetworksResponse.networks:type_name -> google.cloud.baremetalsolution.v2.Network
	3,  // 11: google.cloud.baremetalsolution.v2.UpdateNetworkRequest.network:type_name -> google.cloud.baremetalsolution.v2.Network
	20, // 12: google.cloud.baremetalsolution.v2.UpdateNetworkRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 13: google.cloud.baremetalsolution.v2.NetworkUsage.network:type_name -> google.cloud.baremetalsolution.v2.Network
	11, // 14: google.cloud.baremetalsolution.v2.ListNetworkUsageResponse.networks:type_name -> google.cloud.baremetalsolution.v2.NetworkUsage
	17, // 15: google.cloud.baremetalsolution.v2.VRF.VlanAttachment.qos_policy:type_name -> google.cloud.baremetalsolution.v2.VRF.QosPolicy
	0,  // 16: google.cloud.baremetalsolution.v2.LogicalInterface.LogicalNetworkInterface.network_type:type_name -> google.cloud.baremetalsolution.v2.Network.Type
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_baremetalsolution_v2_network_proto_init() }
func file_google_cloud_baremetalsolution_v2_network_proto_init() {
	if File_google_cloud_baremetalsolution_v2_network_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Network); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkAddressReservation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VRF); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogicalInterface); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNetworksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNetworksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkUsage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNetworkUsageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNetworkUsageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkMountPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenameNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VRF_QosPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VRF_VlanAttachment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_network_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogicalInterface_LogicalNetworkInterface); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_baremetalsolution_v2_network_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_baremetalsolution_v2_network_proto_goTypes,
		DependencyIndexes: file_google_cloud_baremetalsolution_v2_network_proto_depIdxs,
		EnumInfos:         file_google_cloud_baremetalsolution_v2_network_proto_enumTypes,
		MessageInfos:      file_google_cloud_baremetalsolution_v2_network_proto_msgTypes,
	}.Build()
	File_google_cloud_baremetalsolution_v2_network_proto = out.File
	file_google_cloud_baremetalsolution_v2_network_proto_rawDesc = nil
	file_google_cloud_baremetalsolution_v2_network_proto_goTypes = nil
	file_google_cloud_baremetalsolution_v2_network_proto_depIdxs = nil
}
