//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armguestconfiguration

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Subscription ID which uniquely identify Microsoft Azure subscription. The subscription ID forms part of
//     the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAssignmentReportsClient creates a new instance of AssignmentReportsClient.
func (c *ClientFactory) NewAssignmentReportsClient() *AssignmentReportsClient {
	subClient, _ := NewAssignmentReportsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAssignmentReportsVMSSClient creates a new instance of AssignmentReportsVMSSClient.
func (c *ClientFactory) NewAssignmentReportsVMSSClient() *AssignmentReportsVMSSClient {
	subClient, _ := NewAssignmentReportsVMSSClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAssignmentsClient creates a new instance of AssignmentsClient.
func (c *ClientFactory) NewAssignmentsClient() *AssignmentsClient {
	subClient, _ := NewAssignmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAssignmentsVMSSClient creates a new instance of AssignmentsVMSSClient.
func (c *ClientFactory) NewAssignmentsVMSSClient() *AssignmentsVMSSClient {
	subClient, _ := NewAssignmentsVMSSClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewHCRPAssignmentReportsClient creates a new instance of HCRPAssignmentReportsClient.
func (c *ClientFactory) NewHCRPAssignmentReportsClient() *HCRPAssignmentReportsClient {
	subClient, _ := NewHCRPAssignmentReportsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewHCRPAssignmentsClient creates a new instance of HCRPAssignmentsClient.
func (c *ClientFactory) NewHCRPAssignmentsClient() *HCRPAssignmentsClient {
	subClient, _ := NewHCRPAssignmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}
