 /*
  * UAE - The Un*x Amiga Emulator
  *
  * Mac keycodes
  *
  * (c) 1996 Ernesto Corvi
  */

#ifndef UAE_MACKBD_H
#define UAE_MACKBD_H

#define kUpArrowKeyMap				0x7E	/* key map offset for up arrow */
#define kDownArrowKeyMap			0x7D	/* key map offset for down arrow */
#define kRightArrowKeyMap			0x7C	/* key map offset for right arrow */
#define kLeftArrowKeyMap			0x7B	/* key map offset for left arrow */

#define kBackSpaceKeyMap			0x33
#define kReturnKeyMap				0x24
#define kEscapeKeyMap				0x35
#define kLBracketKeyMap				0x21
#define kRBracketKeyMap				0x1E
#define kCommaKeyMap				0x2B
#define kSlashKeyMap				0x2C
#define kSemiColonKeyMap			0x29
#define kMinusKeyMap				0x1B
#define kEqualKeyMap				0x18
#define kQuoteKeyMap				0x27

#define k0KeyMap			       	0x1D
#define k1KeyMap		       		0x12
#define k2KeyMap	       			0x13
#define k3KeyMap       				0x14
#define k4KeyMap			       	0x15
#define k5KeyMap		       		0x17
#define k6KeyMap	       			0x16
#define k7KeyMap       				0x1A
#define k8KeyMap			       	0x1C
#define k9KeyMap		       		0x19

#define kAKeyMap			       	0x00
#define	kBKeyMap		       		0x0B
#define	kCKeyMap	       			0x08
#define	kDKeyMap       				0x02
#define	kEKeyMap			       	0x0E
#define	kFKeyMap		       		0x03
#define	kGKeyMap	       			0x05
#define	kHKeyMap       				0x04
#define	kIKeyMap			       	0x22
#define	kJKeyMap		       		0x26
#define	kKKeyMap	       			0x28
#define	kLKeyMap       				0x25
#define	kMKeyMap			       	0x2E
#define	kNKeyMap		       		0x2D
#define	kOKeyMap	       			0x1F
#define	kPKeyMap       				0x23
#define	kQKeyMap			       	0x0C
#define	kRKeyMap		       		0x0F
#define kSKeyMap	       			0x01
#define kTKeyMap       				0x11
#define kUKeyMap			       	0x20
#define kVKeyMap		       		0x09
#define kWKeyMap	       			0x0D
#define kXKeyMap       				0x07
#define kYKeyMap			       	0x10
#define kZKeyMap		       		0x06
#define kPeriodKeyMap				0x2F
#define	kCommandKeyMap				0x37
#define kSpaceBarMap				0x31
#define	kTabKeyMap		       		0x30
#define	kControlKeyMap				0x3B
#define	kOptionKeyMap				0x3A
#define	kCapsLockKeyMap				0x39
#define	kShiftKeyMap				0x38
#define	kPgUpKeyMap 				0x74
#define	kPgDnKeyMap 				0x79
#define kBackSlash					0x2A


#define kF1KeyMap					0x7A
#define kF2KeyMap					0x78
#define kF3KeyMap					0x63
#define kF4KeyMap					0x76
#define kF5KeyMap					0x60
#define kF6KeyMap					0x61
#define kF7KeyMap					0x62
#define kF8KeyMap					0x64
#define kF9KeyMap					0x65
#define kF10KeyMap					0x6D
#define kF11KeyMap					0x67
#define kF12KeyMap					0x6F

#define	kShiftRawKey				0x3F
#define	kControlRawKey				0x3C
#define kOptionRawKey				0x3D
#define kCapsRawKey					0x3E
#define kCommandRawKey				0x30
#define kUpRawKey					0x79
#define kDownRawKey					0x7A
#define kLeftRawKey					0x7C
#define kRightRawKey				0x7B
#define kSpaceRawKey				0x36

#define kKP0KeyMap					0x52
#define kKP1KeyMap					0x53
#define kKP2KeyMap					0x54
#define kKP3KeyMap					0x55
#define kKP4KeyMap					0x56
#define kKP5KeyMap					0x57
#define kKP6KeyMap					0x58
#define kKP7KeyMap					0x59
#define kKP8KeyMap					0x5B
#define kKP9KeyMap					0x5C

#endif /* UAE_MACKBD_H */
