"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LongDateTime = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const Power2To32 = 0x0100000000;
const OtBaseEpoch = Date.UTC(1904, 1, 1);
exports.LongDateTime = {
    ...(0, bin_util_1.Read)(view => {
        const high = view.uint32();
        const low = view.uint32();
        return new Date((high * Power2To32 + low) * 1000 + OtBaseEpoch);
    }),
    ...(0, bin_util_1.Write)((fr, date) => {
        const time = Math.round((date.getTime() - OtBaseEpoch) / 1000);
        const high = (time / Power2To32) >>> 0;
        const low = time % Power2To32;
        fr.uint32(high);
        fr.uint32(low);
    })
};
//# sourceMappingURL=long-date-time.js.map