"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.clamp = exports.mix = exports.numberClose = void 0;
const constants_1 = require("./constants");
function numberClose(x, y, epsilon = constants_1.EPSILON) {
    return Math.abs(x - y) < epsilon;
}
exports.numberClose = numberClose;
function mix(a, b, t) {
    return a + (b - a) * t;
}
exports.mix = mix;
function clamp(value, min, max) {
    return value < min ? min : value > max ? max : value;
}
exports.clamp = clamp;
