import { IVec2 } from "../point/interface";
import { Point2 } from "../point/point";
import { Shape, ShapeTransform } from "./interface";
export declare class LinearTransform implements ShapeTransform {
    xx: number;
    yx: number;
    xy: number;
    yy: number;
    tx: number;
    ty: number;
    constructor(xx: number, xy: number, yx: number, yy: number, x: number, y: number);
    x(x: number, y: number): number;
    y(x: number, y: number): number;
    dxx(x: number, y: number): number;
    dxy(x: number, y: number): number;
    dyx(x: number, y: number): number;
    dyy(x: number, y: number): number;
    inverse(): LinearTransform;
    static neutral: LinearTransform;
}
export declare class CompositeTransform implements ShapeTransform {
    private a;
    private b;
    private constructor();
    x(x: number, y: number): number;
    y(x: number, y: number): number;
    dxx(x: number, y: number): number;
    dxy(x: number, y: number): number;
    dyx(x: number, y: number): number;
    dyy(x: number, y: number): number;
    static from(a: ShapeTransform, b: ShapeTransform): ShapeTransform;
}
export declare function transformPoint(t: ShapeTransform, z: IVec2): Point2;
export declare function transformPointXY(t: ShapeTransform, x: number, y: number): Point2;
export declare function transformShape(sh: Shape, tfm: ShapeTransform): Shape;
