import { Frag } from "@ot-builder/bin-util";
import { Gpos, Gsub, GsubGpos } from "@ot-builder/ot-layout";
import { LookupWriter, SubtableWriteContext } from "../gsub-gpos-shared/general";
declare abstract class ChainingContextualWriter<L, C extends L & GsubGpos.ChainingProp<L>> implements LookupWriter<L, C> {
    private wCoverageRule;
    private wClassRuleSet;
    protected useChainingLookup(lookup: C, ctx: SubtableWriteContext<L>): boolean;
    abstract getLookupType(lookup: C, ctx: SubtableWriteContext<L>): number;
    abstract getLookupTypeSymbol(lookup: C): symbol;
    abstract canBeUsed(l: L): l is C;
    private estimateCovRuleSize;
    private covSubtable;
    private clsSubtable;
    createSubtableFragments(lookup: C, ctx: SubtableWriteContext<L>): Array<Frag>;
}
export declare class GsubChainingContextualWriter extends ChainingContextualWriter<Gsub.Lookup, Gsub.Chaining> {
    getLookupType(lookup: Gsub.Chaining, ctx: SubtableWriteContext<Gsub.Lookup>): 6 | 5;
    getLookupTypeSymbol(): symbol;
    canBeUsed(l: Gsub.Lookup): l is Gsub.Chaining;
}
export declare class GposChainingContextualWriter extends ChainingContextualWriter<Gpos.Lookup, Gpos.Chaining> {
    getLookupType(lookup: Gpos.Chaining, ctx: SubtableWriteContext<Gpos.Lookup>): 8 | 7;
    getLookupTypeSymbol(): symbol;
    canBeUsed(l: Gpos.Lookup): l is Gpos.Chaining;
}
export {};
//# sourceMappingURL=contextual-write.d.ts.map