// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file ContentFilterTestTypeCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__CONTENTFILTERTESTTYPECDRAUX_IPP
#define FAST_DDS_GENERATED__CONTENTFILTERTESTTYPECDRAUX_IPP

#include "ContentFilterTestTypeCdrAux.hpp"

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const StructType& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.char_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.uint8_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.int16_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.uint16_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.int32_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                data.uint32_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(6),
                data.int64_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(7),
                data.uint64_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(8),
                data.float_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(9),
                data.double_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(10),
                data.long_double_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(11),
                data.bool_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(12),
                data.string_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(13),
                data.enum_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(14),
                data.enum2_field(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const StructType& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.char_field()
        << eprosima::fastcdr::MemberId(1) << data.uint8_field()
        << eprosima::fastcdr::MemberId(2) << data.int16_field()
        << eprosima::fastcdr::MemberId(3) << data.uint16_field()
        << eprosima::fastcdr::MemberId(4) << data.int32_field()
        << eprosima::fastcdr::MemberId(5) << data.uint32_field()
        << eprosima::fastcdr::MemberId(6) << data.int64_field()
        << eprosima::fastcdr::MemberId(7) << data.uint64_field()
        << eprosima::fastcdr::MemberId(8) << data.float_field()
        << eprosima::fastcdr::MemberId(9) << data.double_field()
        << eprosima::fastcdr::MemberId(10) << data.long_double_field()
        << eprosima::fastcdr::MemberId(11) << data.bool_field()
        << eprosima::fastcdr::MemberId(12) << data.string_field()
        << eprosima::fastcdr::MemberId(13) << data.enum_field()
        << eprosima::fastcdr::MemberId(14) << data.enum2_field()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        StructType& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.char_field();
                                            break;

                                        case 1:
                                                dcdr >> data.uint8_field();
                                            break;

                                        case 2:
                                                dcdr >> data.int16_field();
                                            break;

                                        case 3:
                                                dcdr >> data.uint16_field();
                                            break;

                                        case 4:
                                                dcdr >> data.int32_field();
                                            break;

                                        case 5:
                                                dcdr >> data.uint32_field();
                                            break;

                                        case 6:
                                                dcdr >> data.int64_field();
                                            break;

                                        case 7:
                                                dcdr >> data.uint64_field();
                                            break;

                                        case 8:
                                                dcdr >> data.float_field();
                                            break;

                                        case 9:
                                                dcdr >> data.double_field();
                                            break;

                                        case 10:
                                                dcdr >> data.long_double_field();
                                            break;

                                        case 11:
                                                dcdr >> data.bool_field();
                                            break;

                                        case 12:
                                                dcdr >> data.string_field();
                                            break;

                                        case 13:
                                                dcdr >> data.enum_field();
                                            break;

                                        case 14:
                                                dcdr >> data.enum2_field();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const StructType& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.char_field();

                        scdr << data.uint8_field();

                        scdr << data.int16_field();

                        scdr << data.uint16_field();

                        scdr << data.int32_field();

                        scdr << data.uint32_field();

                        scdr << data.int64_field();

                        scdr << data.uint64_field();

                        scdr << data.float_field();

                        scdr << data.double_field();

                        scdr << data.long_double_field();

                        scdr << data.bool_field();

                        scdr << data.string_field();

                        scdr << data.enum_field();

                        scdr << data.enum2_field();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ContentFilterTestType& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.char_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.uint8_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.int16_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.uint16_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.int32_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                data.uint32_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(6),
                data.int64_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(7),
                data.uint64_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(8),
                data.float_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(9),
                data.double_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(10),
                data.long_double_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(11),
                data.bool_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(12),
                data.string_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(13),
                data.enum_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(14),
                data.enum2_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(15),
                data.struct_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(16),
                data.array_char_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(17),
                data.array_uint8_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(18),
                data.array_int16_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(19),
                data.array_uint16_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(20),
                data.array_int32_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(21),
                data.array_uint32_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(22),
                data.array_int64_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(23),
                data.array_uint64_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(24),
                data.array_float_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(25),
                data.array_double_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(26),
                data.array_long_double_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(27),
                data.array_bool_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(28),
                data.array_string_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(29),
                data.array_enum_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(30),
                data.array_enum2_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(31),
                data.array_struct_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(32),
                data.bounded_sequence_char_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(33),
                data.bounded_sequence_uint8_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(34),
                data.bounded_sequence_int16_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(35),
                data.bounded_sequence_uint16_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(36),
                data.bounded_sequence_int32_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(37),
                data.bounded_sequence_uint32_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(38),
                data.bounded_sequence_int64_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(39),
                data.bounded_sequence_uint64_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(40),
                data.bounded_sequence_float_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(41),
                data.bounded_sequence_double_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(42),
                data.bounded_sequence_long_double_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(43),
                data.bounded_sequence_bool_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(44),
                data.bounded_sequence_string_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(45),
                data.bounded_sequence_enum_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(46),
                data.bounded_sequence_enum2_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(47),
                data.bounded_sequence_struct_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(48),
                data.unbounded_sequence_char_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(49),
                data.unbounded_sequence_uint8_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(50),
                data.unbounded_sequence_int16_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(51),
                data.unbounded_sequence_uint16_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(52),
                data.unbounded_sequence_int32_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(53),
                data.unbounded_sequence_uint32_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(54),
                data.unbounded_sequence_int64_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(55),
                data.unbounded_sequence_uint64_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(56),
                data.unbounded_sequence_float_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(57),
                data.unbounded_sequence_double_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(58),
                data.unbounded_sequence_long_double_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(59),
                data.unbounded_sequence_bool_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(60),
                data.unbounded_sequence_string_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(61),
                data.unbounded_sequence_enum_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(62),
                data.unbounded_sequence_enum2_field(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(63),
                data.unbounded_sequence_struct_field(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ContentFilterTestType& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.char_field()
        << eprosima::fastcdr::MemberId(1) << data.uint8_field()
        << eprosima::fastcdr::MemberId(2) << data.int16_field()
        << eprosima::fastcdr::MemberId(3) << data.uint16_field()
        << eprosima::fastcdr::MemberId(4) << data.int32_field()
        << eprosima::fastcdr::MemberId(5) << data.uint32_field()
        << eprosima::fastcdr::MemberId(6) << data.int64_field()
        << eprosima::fastcdr::MemberId(7) << data.uint64_field()
        << eprosima::fastcdr::MemberId(8) << data.float_field()
        << eprosima::fastcdr::MemberId(9) << data.double_field()
        << eprosima::fastcdr::MemberId(10) << data.long_double_field()
        << eprosima::fastcdr::MemberId(11) << data.bool_field()
        << eprosima::fastcdr::MemberId(12) << data.string_field()
        << eprosima::fastcdr::MemberId(13) << data.enum_field()
        << eprosima::fastcdr::MemberId(14) << data.enum2_field()
        << eprosima::fastcdr::MemberId(15) << data.struct_field()
        << eprosima::fastcdr::MemberId(16) << data.array_char_field()
        << eprosima::fastcdr::MemberId(17) << data.array_uint8_field()
        << eprosima::fastcdr::MemberId(18) << data.array_int16_field()
        << eprosima::fastcdr::MemberId(19) << data.array_uint16_field()
        << eprosima::fastcdr::MemberId(20) << data.array_int32_field()
        << eprosima::fastcdr::MemberId(21) << data.array_uint32_field()
        << eprosima::fastcdr::MemberId(22) << data.array_int64_field()
        << eprosima::fastcdr::MemberId(23) << data.array_uint64_field()
        << eprosima::fastcdr::MemberId(24) << data.array_float_field()
        << eprosima::fastcdr::MemberId(25) << data.array_double_field()
        << eprosima::fastcdr::MemberId(26) << data.array_long_double_field()
        << eprosima::fastcdr::MemberId(27) << data.array_bool_field()
        << eprosima::fastcdr::MemberId(28) << data.array_string_field()
        << eprosima::fastcdr::MemberId(29) << data.array_enum_field()
        << eprosima::fastcdr::MemberId(30) << data.array_enum2_field()
        << eprosima::fastcdr::MemberId(31) << data.array_struct_field()
        << eprosima::fastcdr::MemberId(32) << data.bounded_sequence_char_field()
        << eprosima::fastcdr::MemberId(33) << data.bounded_sequence_uint8_field()
        << eprosima::fastcdr::MemberId(34) << data.bounded_sequence_int16_field()
        << eprosima::fastcdr::MemberId(35) << data.bounded_sequence_uint16_field()
        << eprosima::fastcdr::MemberId(36) << data.bounded_sequence_int32_field()
        << eprosima::fastcdr::MemberId(37) << data.bounded_sequence_uint32_field()
        << eprosima::fastcdr::MemberId(38) << data.bounded_sequence_int64_field()
        << eprosima::fastcdr::MemberId(39) << data.bounded_sequence_uint64_field()
        << eprosima::fastcdr::MemberId(40) << data.bounded_sequence_float_field()
        << eprosima::fastcdr::MemberId(41) << data.bounded_sequence_double_field()
        << eprosima::fastcdr::MemberId(42) << data.bounded_sequence_long_double_field()
        << eprosima::fastcdr::MemberId(43) << data.bounded_sequence_bool_field()
        << eprosima::fastcdr::MemberId(44) << data.bounded_sequence_string_field()
        << eprosima::fastcdr::MemberId(45) << data.bounded_sequence_enum_field()
        << eprosima::fastcdr::MemberId(46) << data.bounded_sequence_enum2_field()
        << eprosima::fastcdr::MemberId(47) << data.bounded_sequence_struct_field()
        << eprosima::fastcdr::MemberId(48) << data.unbounded_sequence_char_field()
        << eprosima::fastcdr::MemberId(49) << data.unbounded_sequence_uint8_field()
        << eprosima::fastcdr::MemberId(50) << data.unbounded_sequence_int16_field()
        << eprosima::fastcdr::MemberId(51) << data.unbounded_sequence_uint16_field()
        << eprosima::fastcdr::MemberId(52) << data.unbounded_sequence_int32_field()
        << eprosima::fastcdr::MemberId(53) << data.unbounded_sequence_uint32_field()
        << eprosima::fastcdr::MemberId(54) << data.unbounded_sequence_int64_field()
        << eprosima::fastcdr::MemberId(55) << data.unbounded_sequence_uint64_field()
        << eprosima::fastcdr::MemberId(56) << data.unbounded_sequence_float_field()
        << eprosima::fastcdr::MemberId(57) << data.unbounded_sequence_double_field()
        << eprosima::fastcdr::MemberId(58) << data.unbounded_sequence_long_double_field()
        << eprosima::fastcdr::MemberId(59) << data.unbounded_sequence_bool_field()
        << eprosima::fastcdr::MemberId(60) << data.unbounded_sequence_string_field()
        << eprosima::fastcdr::MemberId(61) << data.unbounded_sequence_enum_field()
        << eprosima::fastcdr::MemberId(62) << data.unbounded_sequence_enum2_field()
        << eprosima::fastcdr::MemberId(63) << data.unbounded_sequence_struct_field()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ContentFilterTestType& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.char_field();
                                            break;

                                        case 1:
                                                dcdr >> data.uint8_field();
                                            break;

                                        case 2:
                                                dcdr >> data.int16_field();
                                            break;

                                        case 3:
                                                dcdr >> data.uint16_field();
                                            break;

                                        case 4:
                                                dcdr >> data.int32_field();
                                            break;

                                        case 5:
                                                dcdr >> data.uint32_field();
                                            break;

                                        case 6:
                                                dcdr >> data.int64_field();
                                            break;

                                        case 7:
                                                dcdr >> data.uint64_field();
                                            break;

                                        case 8:
                                                dcdr >> data.float_field();
                                            break;

                                        case 9:
                                                dcdr >> data.double_field();
                                            break;

                                        case 10:
                                                dcdr >> data.long_double_field();
                                            break;

                                        case 11:
                                                dcdr >> data.bool_field();
                                            break;

                                        case 12:
                                                dcdr >> data.string_field();
                                            break;

                                        case 13:
                                                dcdr >> data.enum_field();
                                            break;

                                        case 14:
                                                dcdr >> data.enum2_field();
                                            break;

                                        case 15:
                                                dcdr >> data.struct_field();
                                            break;

                                        case 16:
                                                dcdr >> data.array_char_field();
                                            break;

                                        case 17:
                                                dcdr >> data.array_uint8_field();
                                            break;

                                        case 18:
                                                dcdr >> data.array_int16_field();
                                            break;

                                        case 19:
                                                dcdr >> data.array_uint16_field();
                                            break;

                                        case 20:
                                                dcdr >> data.array_int32_field();
                                            break;

                                        case 21:
                                                dcdr >> data.array_uint32_field();
                                            break;

                                        case 22:
                                                dcdr >> data.array_int64_field();
                                            break;

                                        case 23:
                                                dcdr >> data.array_uint64_field();
                                            break;

                                        case 24:
                                                dcdr >> data.array_float_field();
                                            break;

                                        case 25:
                                                dcdr >> data.array_double_field();
                                            break;

                                        case 26:
                                                dcdr >> data.array_long_double_field();
                                            break;

                                        case 27:
                                                dcdr >> data.array_bool_field();
                                            break;

                                        case 28:
                                                dcdr >> data.array_string_field();
                                            break;

                                        case 29:
                                                dcdr >> data.array_enum_field();
                                            break;

                                        case 30:
                                                dcdr >> data.array_enum2_field();
                                            break;

                                        case 31:
                                                dcdr >> data.array_struct_field();
                                            break;

                                        case 32:
                                                dcdr >> data.bounded_sequence_char_field();
                                            break;

                                        case 33:
                                                dcdr >> data.bounded_sequence_uint8_field();
                                            break;

                                        case 34:
                                                dcdr >> data.bounded_sequence_int16_field();
                                            break;

                                        case 35:
                                                dcdr >> data.bounded_sequence_uint16_field();
                                            break;

                                        case 36:
                                                dcdr >> data.bounded_sequence_int32_field();
                                            break;

                                        case 37:
                                                dcdr >> data.bounded_sequence_uint32_field();
                                            break;

                                        case 38:
                                                dcdr >> data.bounded_sequence_int64_field();
                                            break;

                                        case 39:
                                                dcdr >> data.bounded_sequence_uint64_field();
                                            break;

                                        case 40:
                                                dcdr >> data.bounded_sequence_float_field();
                                            break;

                                        case 41:
                                                dcdr >> data.bounded_sequence_double_field();
                                            break;

                                        case 42:
                                                dcdr >> data.bounded_sequence_long_double_field();
                                            break;

                                        case 43:
                                                dcdr >> data.bounded_sequence_bool_field();
                                            break;

                                        case 44:
                                                dcdr >> data.bounded_sequence_string_field();
                                            break;

                                        case 45:
                                                dcdr >> data.bounded_sequence_enum_field();
                                            break;

                                        case 46:
                                                dcdr >> data.bounded_sequence_enum2_field();
                                            break;

                                        case 47:
                                                dcdr >> data.bounded_sequence_struct_field();
                                            break;

                                        case 48:
                                                dcdr >> data.unbounded_sequence_char_field();
                                            break;

                                        case 49:
                                                dcdr >> data.unbounded_sequence_uint8_field();
                                            break;

                                        case 50:
                                                dcdr >> data.unbounded_sequence_int16_field();
                                            break;

                                        case 51:
                                                dcdr >> data.unbounded_sequence_uint16_field();
                                            break;

                                        case 52:
                                                dcdr >> data.unbounded_sequence_int32_field();
                                            break;

                                        case 53:
                                                dcdr >> data.unbounded_sequence_uint32_field();
                                            break;

                                        case 54:
                                                dcdr >> data.unbounded_sequence_int64_field();
                                            break;

                                        case 55:
                                                dcdr >> data.unbounded_sequence_uint64_field();
                                            break;

                                        case 56:
                                                dcdr >> data.unbounded_sequence_float_field();
                                            break;

                                        case 57:
                                                dcdr >> data.unbounded_sequence_double_field();
                                            break;

                                        case 58:
                                                dcdr >> data.unbounded_sequence_long_double_field();
                                            break;

                                        case 59:
                                                dcdr >> data.unbounded_sequence_bool_field();
                                            break;

                                        case 60:
                                                dcdr >> data.unbounded_sequence_string_field();
                                            break;

                                        case 61:
                                                dcdr >> data.unbounded_sequence_enum_field();
                                            break;

                                        case 62:
                                                dcdr >> data.unbounded_sequence_enum2_field();
                                            break;

                                        case 63:
                                                dcdr >> data.unbounded_sequence_struct_field();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ContentFilterTestType& data)
{
            extern void serialize_key(
                    Cdr& scdr,
                    const StructType& data);


















































    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.char_field();

                        scdr << data.uint8_field();

                        scdr << data.int16_field();

                        scdr << data.uint16_field();

                        scdr << data.int32_field();

                        scdr << data.uint32_field();

                        scdr << data.int64_field();

                        scdr << data.uint64_field();

                        scdr << data.float_field();

                        scdr << data.double_field();

                        scdr << data.long_double_field();

                        scdr << data.bool_field();

                        scdr << data.string_field();

                        scdr << data.enum_field();

                        scdr << data.enum2_field();

                        serialize_key(scdr, data.struct_field());

                        scdr << data.array_char_field();

                        scdr << data.array_uint8_field();

                        scdr << data.array_int16_field();

                        scdr << data.array_uint16_field();

                        scdr << data.array_int32_field();

                        scdr << data.array_uint32_field();

                        scdr << data.array_int64_field();

                        scdr << data.array_uint64_field();

                        scdr << data.array_float_field();

                        scdr << data.array_double_field();

                        scdr << data.array_long_double_field();

                        scdr << data.array_bool_field();

                        scdr << data.array_string_field();

                        scdr << data.array_enum_field();

                        scdr << data.array_enum2_field();

                        scdr << data.array_struct_field();

                        scdr << data.bounded_sequence_char_field();

                        scdr << data.bounded_sequence_uint8_field();

                        scdr << data.bounded_sequence_int16_field();

                        scdr << data.bounded_sequence_uint16_field();

                        scdr << data.bounded_sequence_int32_field();

                        scdr << data.bounded_sequence_uint32_field();

                        scdr << data.bounded_sequence_int64_field();

                        scdr << data.bounded_sequence_uint64_field();

                        scdr << data.bounded_sequence_float_field();

                        scdr << data.bounded_sequence_double_field();

                        scdr << data.bounded_sequence_long_double_field();

                        scdr << data.bounded_sequence_bool_field();

                        scdr << data.bounded_sequence_string_field();

                        scdr << data.bounded_sequence_enum_field();

                        scdr << data.bounded_sequence_enum2_field();

                        scdr << data.bounded_sequence_struct_field();

                        scdr << data.unbounded_sequence_char_field();

                        scdr << data.unbounded_sequence_uint8_field();

                        scdr << data.unbounded_sequence_int16_field();

                        scdr << data.unbounded_sequence_uint16_field();

                        scdr << data.unbounded_sequence_int32_field();

                        scdr << data.unbounded_sequence_uint32_field();

                        scdr << data.unbounded_sequence_int64_field();

                        scdr << data.unbounded_sequence_uint64_field();

                        scdr << data.unbounded_sequence_float_field();

                        scdr << data.unbounded_sequence_double_field();

                        scdr << data.unbounded_sequence_long_double_field();

                        scdr << data.unbounded_sequence_bool_field();

                        scdr << data.unbounded_sequence_string_field();

                        scdr << data.unbounded_sequence_enum_field();

                        scdr << data.unbounded_sequence_enum2_field();

                        scdr << data.unbounded_sequence_struct_field();

}



} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__CONTENTFILTERTESTTYPECDRAUX_IPP

