// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file mutable.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__MUTABLE_HPP
#define FAST_DDS_GENERATED__MUTABLE_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(MUTABLE_SOURCE)
#define MUTABLE_DllAPI __declspec( dllexport )
#else
#define MUTABLE_DllAPI __declspec( dllimport )
#endif // MUTABLE_SOURCE
#else
#define MUTABLE_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define MUTABLE_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure MutableShortStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableShortStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableShortStruct that will be copied.
     */
    eProsima_user_DllExport MutableShortStruct(
            const MutableShortStruct& x)
    {
                    m_var_short = x.m_var_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableShortStruct that will be copied.
     */
    eProsima_user_DllExport MutableShortStruct(
            MutableShortStruct&& x) noexcept
    {
        m_var_short = x.m_var_short;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableShortStruct that will be copied.
     */
    eProsima_user_DllExport MutableShortStruct& operator =(
            const MutableShortStruct& x)
    {

                    m_var_short = x.m_var_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableShortStruct that will be copied.
     */
    eProsima_user_DllExport MutableShortStruct& operator =(
            MutableShortStruct&& x) noexcept
    {

        m_var_short = x.m_var_short;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableShortStruct& x) const
    {
        return (m_var_short == x.m_var_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableShortStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_short
     * @param _var_short New value for member var_short
     */
    eProsima_user_DllExport void var_short(
            int16_t _var_short)
    {
        m_var_short = _var_short;
    }

    /*!
     * @brief This function returns the value of member var_short
     * @return Value of member var_short
     */
    eProsima_user_DllExport int16_t var_short() const
    {
        return m_var_short;
    }

    /*!
     * @brief This function returns a reference to member var_short
     * @return Reference to member var_short
     */
    eProsima_user_DllExport int16_t& var_short()
    {
        return m_var_short;
    }



private:

    int16_t m_var_short{0};

};
/*!
 * @brief This class represents the structure MutableUShortStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableUShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableUShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableUShortStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableUShortStruct that will be copied.
     */
    eProsima_user_DllExport MutableUShortStruct(
            const MutableUShortStruct& x)
    {
                    m_var_ushort = x.m_var_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableUShortStruct that will be copied.
     */
    eProsima_user_DllExport MutableUShortStruct(
            MutableUShortStruct&& x) noexcept
    {
        m_var_ushort = x.m_var_ushort;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableUShortStruct that will be copied.
     */
    eProsima_user_DllExport MutableUShortStruct& operator =(
            const MutableUShortStruct& x)
    {

                    m_var_ushort = x.m_var_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableUShortStruct that will be copied.
     */
    eProsima_user_DllExport MutableUShortStruct& operator =(
            MutableUShortStruct&& x) noexcept
    {

        m_var_ushort = x.m_var_ushort;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableUShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableUShortStruct& x) const
    {
        return (m_var_ushort == x.m_var_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableUShortStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableUShortStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ushort
     * @param _var_ushort New value for member var_ushort
     */
    eProsima_user_DllExport void var_ushort(
            uint16_t _var_ushort)
    {
        m_var_ushort = _var_ushort;
    }

    /*!
     * @brief This function returns the value of member var_ushort
     * @return Value of member var_ushort
     */
    eProsima_user_DllExport uint16_t var_ushort() const
    {
        return m_var_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_ushort
     * @return Reference to member var_ushort
     */
    eProsima_user_DllExport uint16_t& var_ushort()
    {
        return m_var_ushort;
    }



private:

    uint16_t m_var_ushort{0};

};
/*!
 * @brief This class represents the structure MutableLongStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongStruct(
            const MutableLongStruct& x)
    {
                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongStruct(
            MutableLongStruct&& x) noexcept
    {
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongStruct& operator =(
            const MutableLongStruct& x)
    {

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongStruct& operator =(
            MutableLongStruct&& x) noexcept
    {

        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableLongStruct& x) const
    {
        return (m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    int32_t m_var_long{0};

};
/*!
 * @brief This class represents the structure MutableULongStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableULongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableULongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableULongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableULongStruct that will be copied.
     */
    eProsima_user_DllExport MutableULongStruct(
            const MutableULongStruct& x)
    {
                    m_var_ulong = x.m_var_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableULongStruct that will be copied.
     */
    eProsima_user_DllExport MutableULongStruct(
            MutableULongStruct&& x) noexcept
    {
        m_var_ulong = x.m_var_ulong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableULongStruct that will be copied.
     */
    eProsima_user_DllExport MutableULongStruct& operator =(
            const MutableULongStruct& x)
    {

                    m_var_ulong = x.m_var_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableULongStruct that will be copied.
     */
    eProsima_user_DllExport MutableULongStruct& operator =(
            MutableULongStruct&& x) noexcept
    {

        m_var_ulong = x.m_var_ulong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableULongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableULongStruct& x) const
    {
        return (m_var_ulong == x.m_var_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableULongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableULongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ulong
     * @param _var_ulong New value for member var_ulong
     */
    eProsima_user_DllExport void var_ulong(
            uint32_t _var_ulong)
    {
        m_var_ulong = _var_ulong;
    }

    /*!
     * @brief This function returns the value of member var_ulong
     * @return Value of member var_ulong
     */
    eProsima_user_DllExport uint32_t var_ulong() const
    {
        return m_var_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_ulong
     * @return Reference to member var_ulong
     */
    eProsima_user_DllExport uint32_t& var_ulong()
    {
        return m_var_ulong;
    }



private:

    uint32_t m_var_ulong{0};

};
/*!
 * @brief This class represents the structure MutableLongLongStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableLongLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableLongLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableLongLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableLongLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongLongStruct(
            const MutableLongLongStruct& x)
    {
                    m_var_longlong = x.m_var_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableLongLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongLongStruct(
            MutableLongLongStruct&& x) noexcept
    {
        m_var_longlong = x.m_var_longlong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableLongLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongLongStruct& operator =(
            const MutableLongLongStruct& x)
    {

                    m_var_longlong = x.m_var_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableLongLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongLongStruct& operator =(
            MutableLongLongStruct&& x) noexcept
    {

        m_var_longlong = x.m_var_longlong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableLongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableLongLongStruct& x) const
    {
        return (m_var_longlong == x.m_var_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableLongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableLongLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_longlong
     * @param _var_longlong New value for member var_longlong
     */
    eProsima_user_DllExport void var_longlong(
            int64_t _var_longlong)
    {
        m_var_longlong = _var_longlong;
    }

    /*!
     * @brief This function returns the value of member var_longlong
     * @return Value of member var_longlong
     */
    eProsima_user_DllExport int64_t var_longlong() const
    {
        return m_var_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_longlong
     * @return Reference to member var_longlong
     */
    eProsima_user_DllExport int64_t& var_longlong()
    {
        return m_var_longlong;
    }



private:

    int64_t m_var_longlong{0};

};
/*!
 * @brief This class represents the structure MutableULongLongStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableULongLongStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableULongLongStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableULongLongStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableULongLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableULongLongStruct(
            const MutableULongLongStruct& x)
    {
                    m_var_ulonglong = x.m_var_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableULongLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableULongLongStruct(
            MutableULongLongStruct&& x) noexcept
    {
        m_var_ulonglong = x.m_var_ulonglong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableULongLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableULongLongStruct& operator =(
            const MutableULongLongStruct& x)
    {

                    m_var_ulonglong = x.m_var_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableULongLongStruct that will be copied.
     */
    eProsima_user_DllExport MutableULongLongStruct& operator =(
            MutableULongLongStruct&& x) noexcept
    {

        m_var_ulonglong = x.m_var_ulonglong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableULongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableULongLongStruct& x) const
    {
        return (m_var_ulonglong == x.m_var_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableULongLongStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableULongLongStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ulonglong
     * @param _var_ulonglong New value for member var_ulonglong
     */
    eProsima_user_DllExport void var_ulonglong(
            uint64_t _var_ulonglong)
    {
        m_var_ulonglong = _var_ulonglong;
    }

    /*!
     * @brief This function returns the value of member var_ulonglong
     * @return Value of member var_ulonglong
     */
    eProsima_user_DllExport uint64_t var_ulonglong() const
    {
        return m_var_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_ulonglong
     * @return Reference to member var_ulonglong
     */
    eProsima_user_DllExport uint64_t& var_ulonglong()
    {
        return m_var_ulonglong;
    }



private:

    uint64_t m_var_ulonglong{0};

};
/*!
 * @brief This class represents the structure MutableFloatStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableFloatStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableFloatStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableFloatStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableFloatStruct that will be copied.
     */
    eProsima_user_DllExport MutableFloatStruct(
            const MutableFloatStruct& x)
    {
                    m_var_float = x.m_var_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableFloatStruct that will be copied.
     */
    eProsima_user_DllExport MutableFloatStruct(
            MutableFloatStruct&& x) noexcept
    {
        m_var_float = x.m_var_float;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableFloatStruct that will be copied.
     */
    eProsima_user_DllExport MutableFloatStruct& operator =(
            const MutableFloatStruct& x)
    {

                    m_var_float = x.m_var_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableFloatStruct that will be copied.
     */
    eProsima_user_DllExport MutableFloatStruct& operator =(
            MutableFloatStruct&& x) noexcept
    {

        m_var_float = x.m_var_float;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableFloatStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableFloatStruct& x) const
    {
        return (m_var_float == x.m_var_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableFloatStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableFloatStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_float
     * @param _var_float New value for member var_float
     */
    eProsima_user_DllExport void var_float(
            float _var_float)
    {
        m_var_float = _var_float;
    }

    /*!
     * @brief This function returns the value of member var_float
     * @return Value of member var_float
     */
    eProsima_user_DllExport float var_float() const
    {
        return m_var_float;
    }

    /*!
     * @brief This function returns a reference to member var_float
     * @return Reference to member var_float
     */
    eProsima_user_DllExport float& var_float()
    {
        return m_var_float;
    }



private:

    float m_var_float{0.0};

};
/*!
 * @brief This class represents the structure MutableDoubleStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableDoubleStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableDoubleStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableDoubleStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableDoubleStruct that will be copied.
     */
    eProsima_user_DllExport MutableDoubleStruct(
            const MutableDoubleStruct& x)
    {
                    m_var_double = x.m_var_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableDoubleStruct that will be copied.
     */
    eProsima_user_DllExport MutableDoubleStruct(
            MutableDoubleStruct&& x) noexcept
    {
        m_var_double = x.m_var_double;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableDoubleStruct that will be copied.
     */
    eProsima_user_DllExport MutableDoubleStruct& operator =(
            const MutableDoubleStruct& x)
    {

                    m_var_double = x.m_var_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableDoubleStruct that will be copied.
     */
    eProsima_user_DllExport MutableDoubleStruct& operator =(
            MutableDoubleStruct&& x) noexcept
    {

        m_var_double = x.m_var_double;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableDoubleStruct& x) const
    {
        return (m_var_double == x.m_var_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableDoubleStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_double
     * @param _var_double New value for member var_double
     */
    eProsima_user_DllExport void var_double(
            double _var_double)
    {
        m_var_double = _var_double;
    }

    /*!
     * @brief This function returns the value of member var_double
     * @return Value of member var_double
     */
    eProsima_user_DllExport double var_double() const
    {
        return m_var_double;
    }

    /*!
     * @brief This function returns a reference to member var_double
     * @return Reference to member var_double
     */
    eProsima_user_DllExport double& var_double()
    {
        return m_var_double;
    }



private:

    double m_var_double{0.0};

};
/*!
 * @brief This class represents the structure MutableLongDoubleStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableLongDoubleStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableLongDoubleStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableLongDoubleStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongDoubleStruct(
            const MutableLongDoubleStruct& x)
    {
                    m_var_longdouble = x.m_var_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongDoubleStruct(
            MutableLongDoubleStruct&& x) noexcept
    {
        m_var_longdouble = x.m_var_longdouble;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongDoubleStruct& operator =(
            const MutableLongDoubleStruct& x)
    {

                    m_var_longdouble = x.m_var_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableLongDoubleStruct that will be copied.
     */
    eProsima_user_DllExport MutableLongDoubleStruct& operator =(
            MutableLongDoubleStruct&& x) noexcept
    {

        m_var_longdouble = x.m_var_longdouble;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableLongDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableLongDoubleStruct& x) const
    {
        return (m_var_longdouble == x.m_var_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableLongDoubleStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableLongDoubleStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_longdouble
     * @param _var_longdouble New value for member var_longdouble
     */
    eProsima_user_DllExport void var_longdouble(
            long double _var_longdouble)
    {
        m_var_longdouble = _var_longdouble;
    }

    /*!
     * @brief This function returns the value of member var_longdouble
     * @return Value of member var_longdouble
     */
    eProsima_user_DllExport long double var_longdouble() const
    {
        return m_var_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_longdouble
     * @return Reference to member var_longdouble
     */
    eProsima_user_DllExport long double& var_longdouble()
    {
        return m_var_longdouble;
    }



private:

    long double m_var_longdouble{0.0};

};
/*!
 * @brief This class represents the structure MutableBooleanStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableBooleanStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableBooleanStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableBooleanStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableBooleanStruct that will be copied.
     */
    eProsima_user_DllExport MutableBooleanStruct(
            const MutableBooleanStruct& x)
    {
                    m_var_boolean = x.m_var_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableBooleanStruct that will be copied.
     */
    eProsima_user_DllExport MutableBooleanStruct(
            MutableBooleanStruct&& x) noexcept
    {
        m_var_boolean = x.m_var_boolean;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableBooleanStruct that will be copied.
     */
    eProsima_user_DllExport MutableBooleanStruct& operator =(
            const MutableBooleanStruct& x)
    {

                    m_var_boolean = x.m_var_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableBooleanStruct that will be copied.
     */
    eProsima_user_DllExport MutableBooleanStruct& operator =(
            MutableBooleanStruct&& x) noexcept
    {

        m_var_boolean = x.m_var_boolean;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableBooleanStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableBooleanStruct& x) const
    {
        return (m_var_boolean == x.m_var_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableBooleanStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableBooleanStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_boolean
     * @param _var_boolean New value for member var_boolean
     */
    eProsima_user_DllExport void var_boolean(
            bool _var_boolean)
    {
        m_var_boolean = _var_boolean;
    }

    /*!
     * @brief This function returns the value of member var_boolean
     * @return Value of member var_boolean
     */
    eProsima_user_DllExport bool var_boolean() const
    {
        return m_var_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_boolean
     * @return Reference to member var_boolean
     */
    eProsima_user_DllExport bool& var_boolean()
    {
        return m_var_boolean;
    }



private:

    bool m_var_boolean{false};

};
/*!
 * @brief This class represents the structure MutableOctetStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableOctetStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableOctetStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableOctetStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableOctetStruct that will be copied.
     */
    eProsima_user_DllExport MutableOctetStruct(
            const MutableOctetStruct& x)
    {
                    m_var_octet = x.m_var_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableOctetStruct that will be copied.
     */
    eProsima_user_DllExport MutableOctetStruct(
            MutableOctetStruct&& x) noexcept
    {
        m_var_octet = x.m_var_octet;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableOctetStruct that will be copied.
     */
    eProsima_user_DllExport MutableOctetStruct& operator =(
            const MutableOctetStruct& x)
    {

                    m_var_octet = x.m_var_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableOctetStruct that will be copied.
     */
    eProsima_user_DllExport MutableOctetStruct& operator =(
            MutableOctetStruct&& x) noexcept
    {

        m_var_octet = x.m_var_octet;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableOctetStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableOctetStruct& x) const
    {
        return (m_var_octet == x.m_var_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableOctetStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableOctetStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_octet
     * @param _var_octet New value for member var_octet
     */
    eProsima_user_DllExport void var_octet(
            uint8_t _var_octet)
    {
        m_var_octet = _var_octet;
    }

    /*!
     * @brief This function returns the value of member var_octet
     * @return Value of member var_octet
     */
    eProsima_user_DllExport uint8_t var_octet() const
    {
        return m_var_octet;
    }

    /*!
     * @brief This function returns a reference to member var_octet
     * @return Reference to member var_octet
     */
    eProsima_user_DllExport uint8_t& var_octet()
    {
        return m_var_octet;
    }



private:

    uint8_t m_var_octet{0};

};
/*!
 * @brief This class represents the structure MutableCharStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableCharStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableCharStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableCharStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableCharStruct that will be copied.
     */
    eProsima_user_DllExport MutableCharStruct(
            const MutableCharStruct& x)
    {
                    m_var_char8 = x.m_var_char8;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableCharStruct that will be copied.
     */
    eProsima_user_DllExport MutableCharStruct(
            MutableCharStruct&& x) noexcept
    {
        m_var_char8 = x.m_var_char8;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableCharStruct that will be copied.
     */
    eProsima_user_DllExport MutableCharStruct& operator =(
            const MutableCharStruct& x)
    {

                    m_var_char8 = x.m_var_char8;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableCharStruct that will be copied.
     */
    eProsima_user_DllExport MutableCharStruct& operator =(
            MutableCharStruct&& x) noexcept
    {

        m_var_char8 = x.m_var_char8;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableCharStruct& x) const
    {
        return (m_var_char8 == x.m_var_char8);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableCharStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_char8
     * @param _var_char8 New value for member var_char8
     */
    eProsima_user_DllExport void var_char8(
            char _var_char8)
    {
        m_var_char8 = _var_char8;
    }

    /*!
     * @brief This function returns the value of member var_char8
     * @return Value of member var_char8
     */
    eProsima_user_DllExport char var_char8() const
    {
        return m_var_char8;
    }

    /*!
     * @brief This function returns a reference to member var_char8
     * @return Reference to member var_char8
     */
    eProsima_user_DllExport char& var_char8()
    {
        return m_var_char8;
    }



private:

    char m_var_char8{0};

};
/*!
 * @brief This class represents the structure MutableWCharStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableWCharStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableWCharStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableWCharStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableWCharStruct that will be copied.
     */
    eProsima_user_DllExport MutableWCharStruct(
            const MutableWCharStruct& x)
    {
                    m_var_char16 = x.m_var_char16;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableWCharStruct that will be copied.
     */
    eProsima_user_DllExport MutableWCharStruct(
            MutableWCharStruct&& x) noexcept
    {
        m_var_char16 = x.m_var_char16;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableWCharStruct that will be copied.
     */
    eProsima_user_DllExport MutableWCharStruct& operator =(
            const MutableWCharStruct& x)
    {

                    m_var_char16 = x.m_var_char16;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableWCharStruct that will be copied.
     */
    eProsima_user_DllExport MutableWCharStruct& operator =(
            MutableWCharStruct&& x) noexcept
    {

        m_var_char16 = x.m_var_char16;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableWCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableWCharStruct& x) const
    {
        return (m_var_char16 == x.m_var_char16);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableWCharStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableWCharStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_char16
     * @param _var_char16 New value for member var_char16
     */
    eProsima_user_DllExport void var_char16(
            wchar_t _var_char16)
    {
        m_var_char16 = _var_char16;
    }

    /*!
     * @brief This function returns the value of member var_char16
     * @return Value of member var_char16
     */
    eProsima_user_DllExport wchar_t var_char16() const
    {
        return m_var_char16;
    }

    /*!
     * @brief This function returns a reference to member var_char16
     * @return Reference to member var_char16
     */
    eProsima_user_DllExport wchar_t& var_char16()
    {
        return m_var_char16;
    }



private:

    wchar_t m_var_char16{0};

};
/*!
 * @brief This class represents the structure MutableUnionStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableUnionStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableUnionStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableUnionStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableUnionStruct that will be copied.
     */
    eProsima_user_DllExport MutableUnionStruct(
            const MutableUnionStruct& x)
    {
                    m_var_union = x.m_var_union;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableUnionStruct that will be copied.
     */
    eProsima_user_DllExport MutableUnionStruct(
            MutableUnionStruct&& x) noexcept
    {
        m_var_union = std::move(x.m_var_union);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableUnionStruct that will be copied.
     */
    eProsima_user_DllExport MutableUnionStruct& operator =(
            const MutableUnionStruct& x)
    {

                    m_var_union = x.m_var_union;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableUnionStruct that will be copied.
     */
    eProsima_user_DllExport MutableUnionStruct& operator =(
            MutableUnionStruct&& x) noexcept
    {

        m_var_union = std::move(x.m_var_union);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableUnionStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableUnionStruct& x) const
    {
        return (m_var_union == x.m_var_union);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableUnionStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableUnionStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union
     * @param _var_union New value to be copied in member var_union
     */
    eProsima_user_DllExport void var_union(
            const InnerUnionHelper& _var_union)
    {
        m_var_union = _var_union;
    }

    /*!
     * @brief This function moves the value in member var_union
     * @param _var_union New value to be moved in member var_union
     */
    eProsima_user_DllExport void var_union(
            InnerUnionHelper&& _var_union)
    {
        m_var_union = std::move(_var_union);
    }

    /*!
     * @brief This function returns a constant reference to member var_union
     * @return Constant reference to member var_union
     */
    eProsima_user_DllExport const InnerUnionHelper& var_union() const
    {
        return m_var_union;
    }

    /*!
     * @brief This function returns a reference to member var_union
     * @return Reference to member var_union
     */
    eProsima_user_DllExport InnerUnionHelper& var_union()
    {
        return m_var_union;
    }



private:

    InnerUnionHelper m_var_union;

};
/*!
 * @brief This class represents the structure MutableEmptyStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableEmptyStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableEmptyStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableEmptyStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableEmptyStruct that will be copied.
     */
    eProsima_user_DllExport MutableEmptyStruct(
            const MutableEmptyStruct& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableEmptyStruct that will be copied.
     */
    eProsima_user_DllExport MutableEmptyStruct(
            MutableEmptyStruct&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableEmptyStruct that will be copied.
     */
    eProsima_user_DllExport MutableEmptyStruct& operator =(
            const MutableEmptyStruct& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableEmptyStruct that will be copied.
     */
    eProsima_user_DllExport MutableEmptyStruct& operator =(
            MutableEmptyStruct&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableEmptyStruct& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableEmptyStruct& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure MutableEmptyInheritanceStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableEmptyInheritanceStruct : public MutableEmptyStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableEmptyInheritanceStruct()
        : MutableEmptyStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableEmptyInheritanceStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport MutableEmptyInheritanceStruct(
            const MutableEmptyInheritanceStruct& x)
        : MutableEmptyStruct(x)
    {
                    m_var_str = x.m_var_str;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport MutableEmptyInheritanceStruct(
            MutableEmptyInheritanceStruct&& x) noexcept
        : MutableEmptyStruct(std::move(x))

    {
        m_var_str = std::move(x.m_var_str);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport MutableEmptyInheritanceStruct& operator =(
            const MutableEmptyInheritanceStruct& x)
    {
        MutableEmptyStruct::operator =(x);

                    m_var_str = x.m_var_str;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableEmptyInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport MutableEmptyInheritanceStruct& operator =(
            MutableEmptyInheritanceStruct&& x) noexcept
    {
        MutableEmptyStruct::operator =(std::move(x));

        m_var_str = std::move(x.m_var_str);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableEmptyInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableEmptyInheritanceStruct& x) const
    {
        if (MutableEmptyStruct::operator !=(x))
                {
                    return false;
                }
        return (m_var_str == x.m_var_str);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableEmptyInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableEmptyInheritanceStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_str
     * @param _var_str New value to be copied in member var_str
     */
    eProsima_user_DllExport void var_str(
            const std::string& _var_str)
    {
        m_var_str = _var_str;
    }

    /*!
     * @brief This function moves the value in member var_str
     * @param _var_str New value to be moved in member var_str
     */
    eProsima_user_DllExport void var_str(
            std::string&& _var_str)
    {
        m_var_str = std::move(_var_str);
    }

    /*!
     * @brief This function returns a constant reference to member var_str
     * @return Constant reference to member var_str
     */
    eProsima_user_DllExport const std::string& var_str() const
    {
        return m_var_str;
    }

    /*!
     * @brief This function returns a reference to member var_str
     * @return Reference to member var_str
     */
    eProsima_user_DllExport std::string& var_str()
    {
        return m_var_str;
    }



private:

    std::string m_var_str;

};
/*!
 * @brief This class represents the structure MutableInheritanceStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableInheritanceStruct : public MutableShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableInheritanceStruct()
        : MutableShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableInheritanceStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport MutableInheritanceStruct(
            const MutableInheritanceStruct& x)
        : MutableShortStruct(x)
    {
                    m_var_str = x.m_var_str;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport MutableInheritanceStruct(
            MutableInheritanceStruct&& x) noexcept
        : MutableShortStruct(std::move(x))

    {
        m_var_str = std::move(x.m_var_str);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport MutableInheritanceStruct& operator =(
            const MutableInheritanceStruct& x)
    {
        MutableShortStruct::operator =(x);

                    m_var_str = x.m_var_str;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport MutableInheritanceStruct& operator =(
            MutableInheritanceStruct&& x) noexcept
    {
        MutableShortStruct::operator =(std::move(x));

        m_var_str = std::move(x.m_var_str);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableInheritanceStruct& x) const
    {
        if (MutableShortStruct::operator !=(x))
                {
                    return false;
                }
        return (m_var_str == x.m_var_str);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableInheritanceStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_str
     * @param _var_str New value to be copied in member var_str
     */
    eProsima_user_DllExport void var_str(
            const std::string& _var_str)
    {
        m_var_str = _var_str;
    }

    /*!
     * @brief This function moves the value in member var_str
     * @param _var_str New value to be moved in member var_str
     */
    eProsima_user_DllExport void var_str(
            std::string&& _var_str)
    {
        m_var_str = std::move(_var_str);
    }

    /*!
     * @brief This function returns a constant reference to member var_str
     * @return Constant reference to member var_str
     */
    eProsima_user_DllExport const std::string& var_str() const
    {
        return m_var_str;
    }

    /*!
     * @brief This function returns a reference to member var_str
     * @return Reference to member var_str
     */
    eProsima_user_DllExport std::string& var_str()
    {
        return m_var_str;
    }



private:

    std::string m_var_str;

};
/*!
 * @brief This class represents the structure MutableInheritanceEmptyStruct defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableInheritanceEmptyStruct : public MutableShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableInheritanceEmptyStruct()
        : MutableShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableInheritanceEmptyStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableInheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport MutableInheritanceEmptyStruct(
            const MutableInheritanceEmptyStruct& x)
        : MutableShortStruct(x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableInheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport MutableInheritanceEmptyStruct(
            MutableInheritanceEmptyStruct&& x) noexcept
        : MutableShortStruct(std::move(x))

    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableInheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport MutableInheritanceEmptyStruct& operator =(
            const MutableInheritanceEmptyStruct& x)
    {
        MutableShortStruct::operator =(x);

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableInheritanceEmptyStruct that will be copied.
     */
    eProsima_user_DllExport MutableInheritanceEmptyStruct& operator =(
            MutableInheritanceEmptyStruct&& x) noexcept
    {
        MutableShortStruct::operator =(std::move(x));

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableInheritanceEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableInheritanceEmptyStruct& x) const
    {
        if (MutableShortStruct::operator !=(x))
                {
                    return false;
                }
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableInheritanceEmptyStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableInheritanceEmptyStruct& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure MutableExtensibilityInheritance defined by the user in the IDL file.
 * @ingroup mutable
 */
class MutableExtensibilityInheritance : public MutableShortStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableExtensibilityInheritance()
        : MutableShortStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableExtensibilityInheritance()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport MutableExtensibilityInheritance(
            const MutableExtensibilityInheritance& x)
        : MutableShortStruct(x)
    {
                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport MutableExtensibilityInheritance(
            MutableExtensibilityInheritance&& x) noexcept
        : MutableShortStruct(std::move(x))

    {
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport MutableExtensibilityInheritance& operator =(
            const MutableExtensibilityInheritance& x)
    {
        MutableShortStruct::operator =(x);

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableExtensibilityInheritance that will be copied.
     */
    eProsima_user_DllExport MutableExtensibilityInheritance& operator =(
            MutableExtensibilityInheritance&& x) noexcept
    {
        MutableShortStruct::operator =(std::move(x));

        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableExtensibilityInheritance object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableExtensibilityInheritance& x) const
    {
        if (MutableShortStruct::operator !=(x))
                {
                    return false;
                }
        return (m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableExtensibilityInheritance object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableExtensibilityInheritance& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    int32_t m_var_long{0};

};

#endif // _FAST_DDS_GENERATED_MUTABLE_HPP_


