# Header-параметри

Ви можете визначати параметри заголовків, так само як визначаєте `Query`, `Path` і `Cookie` параметри.

## Імпорт `Header`

Спочатку імпортуйте `Header`:

{* ../../docs_src/header_params/tutorial001_an_py310.py hl[3] *}

## Оголошення параметрів `Header`

Потім оголосіть параметри заголовків, використовуючи ту ж структуру, що й для `Path`, `Query` та `Cookie`.

Ви можете визначити значення за замовчуванням, а також усі додаткові параметри валідації або анотації:

{* ../../docs_src/header_params/tutorial001_an_py310.py hl[9] *}

/// note | Технічні деталі

`Header`є "сестринським" класом для `Path`, `Query` і `Cookie`. Він також успадковується від загального класу `Param`.

Але пам’ятайте, що при імпорті `Query`, `Path`, `Header` та інших із `fastapi`, то насправді вони є функціями, які повертають спеціальні класи.

///

/// info | Інформація

Щоб оголосити заголовки, потрібно використовувати `Header`, інакше параметри будуть інтерпретуватися як параметри запиту.

///

## Автоматичне перетворення

`Header` має додатковий функціонал порівняно з `Path`, `Query` та `Cookie`.

Більшість стандартних заголовків розділяються символом «дефіс», також відомим як «мінус» (`-`).

Але змінна, така як `user-agent`, є недійсною в Python.

Тому, за замовчуванням, `Header` автоматично перетворює символи підкреслення (`_`) на дефіси (`-`) для отримання та документування заголовків.

Оскільки заголовки HTTP не чутливі до регістру, Ви можете використовувати стандартний стиль Python ("snake_case").

Тому Ви можете використовувати `user_agent`, як зазвичай у коді Python, замість того щоб писати з великої літери, як `User_Agent` або щось подібне.

Якщо Вам потрібно вимкнути автоматичне перетворення підкреслень у дефіси, встановіть `convert_underscores` в `Header` значення `False`:

{* ../../docs_src/header_params/tutorial002_an_py310.py hl[10] *}

/// warning | Увага

Перед тим як встановити значення `False` для `convert_underscores` пам’ятайте, що деякі HTTP-проксі та сервери не підтримують заголовки з підкресленнями.

///

## Дубльовані заголовки

Можливо отримати дубльовані заголовки, тобто той самий заголовок із кількома значеннями.

Це можна визначити, використовуючи список у типізації параметра.

Ви отримаєте всі значення дубльованого заголовка у вигляді `list` у Python.

Наприклад, щоб оголосити заголовок `X-Token`, який може з’являтися більше ніж один раз:

{* ../../docs_src/header_params/tutorial003_an_py310.py hl[9] *}

Якщо Ви взаємодієте з цією операцією шляху, надсилаючи два HTTP-заголовки, наприклад:

```
X-Token: foo
X-Token: bar
```

Відповідь буде така:

```JSON
{
    "X-Token values": [
        "bar",
        "foo"
    ]
}
```

## Підсумок

Оголошуйте заголовки за допомогою `Header`, використовуючи той самий підхід, що й для `Query`, `Path` та `Cookie`.

Не хвилюйтеся про підкреслення у змінних — **FastAPI** автоматично конвертує їх.
