/* AnyMeal recipe management software
   Copyright (C) 2021, 2023 Jan Wedekind

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>. */
#include <gtest/gtest.h>
#include "ingredient.hh"


using namespace testing;
using namespace std;


TEST(IngredientTest, DefaultValues) {
  Ingredient ingredient;
  EXPECT_EQ(0, ingredient.amount_integer());
  EXPECT_EQ(0, ingredient.amount_numerator());
  EXPECT_EQ(1, ingredient.amount_denominator());
  EXPECT_EQ(0.0, ingredient.amount_float());
}
