# ANGLE back-ends

This folder contains shared back-end-specific implementation files. The classes
and types in `renderer` are not specified by GLES. They instead are common to
all the various ANGLE implementations.

See [`renderer_utils.h`](renderer_utils.h) for various cross back-end utilties.

## ANGLE Formats

The ANGLE format class, [`angle::Format`][ANGLEFormatDef], works as a union
between GLES and all the various back-end formats. It can represent any type
of format in ANGLE. e.g. Formats in Vulkan that don't exist in GLES, or DXGI
formats that don't exist in GLES, or Windows/Android surface configs that
don't exist anywhere else.

The `glInternalFormat` member of `angle::Format` represents the "closest" GL
format for an ANGLE format. For formats that don't exist in GLES this will
not be exactly what the format represents.

The back-ends also define their own format tables. See the
[Vulkan Format table docs][VulkanFormatDocs] and the
[D3D11 format table docs][D23D11FormatDocs].

## DXGI Format Info

DXGI formats are used in both the GL and D3D11 back-end. Therefore the
generated info table lives in this common shared location.

The DXGI info table is generated by [`gen_dxgi_format_table.py`](gen_dxgi_format_table.py)
and sources data from [`dxgi_format_data.json`](dxgi_format_data.json). The
main purpose of the table is to convert from a DXGI format to an ANGLE
format, where the ANGLE format should have all the necessary information.

[ANGLEFormatDef]: https://chromium.googlesource.com/angle/angle/+/f85ec039a7dcfde3b4a8d9ddfa8baa84ae5ce927/src/libANGLE/renderer/Format.h#24
[VulkanFormatDocs]: vulkan/doc/FormatTablesAndEmulation.md
[D3D11FormatDocs]: d3d/d3d11/FormatTables.md
