#include <stdio.h>

typedef union
{
    double  dbl;
    long long bits[11];
} u_double;

typedef union
{
    float  dbl;
    unsigned bits[11];
} u_float;

double mem[] = {
   23.5,       15.2,       5.01,          -59.0,      456.2,
   -0.25,      0.36,       12.01,         -8974.0,    895.36,
   458.6,      0,          456.2489562,   3.26,       -1.26,
   1384.6,     -7.2945676, 1000000000,    -5786.47,   1752,
   0.0024575,  0.00000001, -2485.76,      -45786.476, 456.2489562,
   34.00046,   45786.476,  17520,         107,        -45667.24,
   -7.2945676
};

float mem1[] = {
   23.5,       15.2,       5.01,          -59.0,      456.2,
   -0.25,      0.36,       12.01,         -8974.0,    895.36,
   458.6,      0,          456.2489562,   3,         -1,
   1384.6,     -7.2945676, 100000,        -5786.47,   1752,
   0.0024575,  0.000001,   -2485.76,      -45786.476, 456.2489562,
   34.00046,   45786.476,  1752,          107,        -456.24,
   -7.2945676
};

unsigned int mem2[] = {
   0x0000e680, 0x00000000, 0x0000e7dc, 0x00000000,
   0x2ab05fd0, 0x0000b6a0, 0x00000000, 0x0000de10,
   0x00000000, 0x2ab05fe0, 0x00000000, 0x00010300
};


unsigned long long condition[] = {
   0x3FF0000000000001ULL, 0x3FF0000000000000ULL,
   0x00000000ffffffffULL, 0x1234563388994400ULL,
   0x0000004412369801ULL, 0x111111eeeeeee220ULL,
   0xAAAAABBBBBCCCDDDULL, 0xaa55cc2266dd2200ULL,
   0x3FF0000000000001ULL, 0x3FF0000000000000ULL,
   0x00000000ffffffffULL
};

unsigned condition1[] = {
   0x3FF00001, 0x3FF00000,
   0x0000ffff, 0x12394400,
   0x00369801, 0x1111e220,
   0xAABBBCDD, 0xaa55c200,
   0x7f800000, 0x8000f000,
   0x7f80f000
};


unsigned flt[] = {
   0xff800000, 0xc3e41eb8, 0x8000f000, 0x80000000, 0x7f80f000,
   0x00000000, 0x0000f000, 0x43e41eb8, 0x7f800000, 0x7fC0f000,
   0x43ad6d26, 0xC3ad6d26
};


unsigned long long dbl[] = {
   0xFFF0000000000000, 0xC141FC309E951EBD, 0x80000000f0000000,
   0x8000000000000000, 0x7FF0000000F00000, 0x0000000000000000,
   0x00000000f0000000, 0x4141FC309E951EBD, 0x7FF0000000000000,
   0x7FF8000000000000, 0x40d6fc568c154c98, 0xC0d6fc568c154c98
};



#define TEST1_S(instruction, FD, FS, FT, FSval, FTval) \
{ \
   float out; \
   int fpcsr = 0xC0000;\
   __asm__ volatile( \
   "l.s $"#FS", %2\n\t"   \
   "l.s $"#FT", %3 \n\t"   \
   "ctc1 %1, $31 \n\t"\
   instruction" $"#FD", $"#FS", $"#FT "\n\t" \
   "cfc1 %1, $31 \n\t"\
   "s.s $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "r" (fpcsr), "m" (FSval), "m" (FTval) \
   : #FD, #FS, #FT,"memory" \
   ); \
   printf(instruction":: fs:%15f ft:%15f out:%15f fpcsr:%08x\n", FSval, FTval, out, fpcsr); \
}

#define TEST1_D(instruction, FD, FS, FT, FSval, FTval) \
{ \
   double out; \
   int fpcsr = 0xC0000;\
   __asm__ volatile( \
   "l.d $"#FS", %2\n\t"   \
   "l.d $"#FT", %3 \n\t"   \
   "ctc1 %1, $31 \n\t"\
   instruction" $"#FD", $"#FS", $"#FT "\n\t" \
   "cfc1 %1, $31 \n\t"\
   "s.d $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "r" (fpcsr), "m" (FSval), "m" (FTval) \
   : #FD, #FS, #FT,"memory" \
   ); \
   printf(instruction":: fs:%10lf ft:%10lf out:%10lf fpcsr:%08x\n", FSval, FTval, out, fpcsr); \
}

#define TEST2_S(instruction, FD, FS, FT, FSval, FTval, FDval) \
{ \
   float out; \
   int fpcsr = 0xC0000 | rm;\
   __asm__ volatile( \
   "l.s $"#FS", %1 \n\t"   \
   "l.s $"#FT", %2 \n\t"   \
   "l.s $"#FD", %3 \n\t" \
   "ctc1 %4, $31 \n\t"\
   instruction" $"#FD", $"#FS", $"#FT "\n\t" \
   "cfc1 %4, $31 \n\t"\
   "s.s $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "m" (FSval), "m" (FTval), "m" (FDval), "r" (fpcsr) \
   : #FD, #FS, #FT,"memory" \
   ); \
   printf(instruction":: fd:%14f fs:%14f ft:%14f out:%16f fpcsr:%08x\n", FDval, FSval, FTval, out, fpcsr); \
}

#define TEST2_D(instruction, FD, FS, FT, FSval, FTval, FDval) \
{ \
   double out; \
   int fpcsr = 0xC0000 | rm;\
   __asm__ volatile( \
   "l.d $"#FS", %1 \n\t"   \
   "l.d $"#FT", %2 \n\t"   \
   "l.d $"#FD", %3 \n\t" \
   "ctc1 %4, $31 \n\t"\
   instruction" $"#FD", $"#FS", $"#FT "\n\t" \
   "cfc1 %4, $31 \n\t"\
   "s.d $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "m" (FSval), "m" (FTval), "m" (FDval), "r" (fpcsr) \
   : #FD, #FS, #FT,"memory" \
   ); \
   printf(instruction":: fd:%14lf fs:%14lf ft:%14lf out:%16lf fpcsr:%08x\n", FDval, FSval, FTval, out, fpcsr); \
}

#define TEST3_S(instruction, FD, FS, FT, FSval, FTval, FDval) \
{ \
   float out; \
   __asm__ volatile( \
   "l.s $"#FS", %1 \n\t"   \
   "l.s $"#FT", %2 \n\t"   \
   "l.s $"#FD", %3 \n\t" \
   instruction" $"#FD", $"#FS", $"#FT"\n\t" \
   "s.s $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "m" (FSval), "m" (FTval), "m" (FDval) \
   : #FD, #FS, #FT,"memory" \
   ); \
   printf(instruction":: fs:%15f ft:%15f fd:%08x out:%15f\n", FSval, FTval, FDval, out); \
}

#define TEST3_D(instruction, FD, FS, FT, FSval, FTval, FDval) \
{ \
   double out; \
   __asm__ volatile( \
   "l.d $"#FS", %1 \n\t"   \
   "l.d $"#FT", %2 \n\t"   \
   "l.d $"#FD", %3 \n\t" \
   instruction" $"#FD", $"#FS", $"#FT"\n\t" \
   "s.d $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "m" (FSval), "m" (FTval), "m" (FDval) \
   : #FD, #FS, #FT,"memory" \
   ); \
   printf(instruction":: fs:%15lf ft:%15lf fd:%016llx out:%15lf\n", FSval, FTval, FDval, out); \
}


#define TEST3_Sv2(instruction, FD, FS, FT, FSval, FTval, FDval) \
{ \
   float out; \
   __asm__ volatile( \
   "l.s $"#FS", %1 \n\t"   \
   "l.s $"#FT", %2 \n\t"   \
   "l.s $"#FD", %3 \n\t" \
   instruction" $"#FD", $"#FS", $"#FT"\n\t" \
   "s.s $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "m" (FSval), "m" (FTval), "m" (FDval) \
   : #FD, #FS, #FT,"memory" \
   ); \
   printf(instruction":: fs:%15f ft:%08x fd:%15f out:%15f\n", FSval, FTval, FDval, out); \
}

#define TEST3_Dv2(instruction, FD, FS, FT, FSval, FTval, FDval) \
{ \
   double out; \
   __asm__ volatile( \
   "l.d $"#FS", %1 \n\t"   \
   "l.d $"#FT", %2 \n\t"   \
   "l.d $"#FD", %3 \n\t" \
   instruction" $"#FD", $"#FS", $"#FT"\n\t" \
   "s.d $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "m" (FSval), "m" (FTval), "m" (FDval) \
   : #FD, #FS, #FT,"memory" \
   ); \
   printf(instruction":: fs:%15lf ft:%016llx fd:%15lf out:%15lf\n", FSval, FTval, FDval, out); \
}


#define TEST4_S(instruction, FD, FS, FSval) \
{ \
   float out; \
   int fpcsr = 0xC0000 | rm;\
   __asm__ volatile( \
   "l.s $"#FS", %1 \n\t"   \
   "ctc1 %2, $31 \n\t"\
   instruction" $"#FD", $"#FS "\n\t"  \
   "cfc1 %2, $31 \n\t"\
   "s.s $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "m" (FSval), "r" (fpcsr)\
   : #FD, #FS, "memory" \
   ); \
   printf(instruction":: fs:%15f out:%15f fpcsr:%08x\n", FSval, out, fpcsr); \
}

#define TEST4_D(instruction, FD, FS, FSval) \
{ \
   double out; \
   int fpcsr = 0xC0000 | rm;\
   __asm__ volatile( \
   "l.d $"#FS", %1 \n\t"   \
   "ctc1 %2, $31 \n\t"\
   instruction" $"#FD", $"#FS "\n\t"  \
   "cfc1 %2, $31 \n\t"\
   "s.d $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "m" (FSval), "r" (fpcsr) \
   : #FD, #FS, "memory" \
   ); \
   printf(instruction":: fs:%15lf out:%15lf fpcsr:%08x\n", FSval, out, fpcsr); \
}


#define TEST5_S(instruction, FD, FS, FSval) \
{ \
   unsigned out; \
   __asm__ volatile( \
   "l.s $"#FS", %1 \n\t"   \
   instruction" $"#FD", $"#FS "\n\t"  \
   "s.s $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "m" (FSval)\
   : #FD, #FS, "memory" \
   ); \
   printf(instruction":: fs:%08x out:%08x\n", FSval, out); \
}

#define TEST5_D(instruction, FD, FS, FSval) \
{ \
   unsigned long long out; \
   __asm__ volatile( \
   "l.d $"#FS", %1 \n\t"   \
   instruction" $"#FD", $"#FS "\n\t"  \
   "s.d $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "m" (FSval)\
   : #FD, #FS, "memory" \
   ); \
   printf(instruction":: fs:%016llx out:%016llx\n", FSval, out); \
}


#define TEST_CMP_S(instruction, FD, FS, FT, FSval, FTval) \
{ \
   unsigned out; \
   int fpcsr = 0xC0000;\
   __asm__ volatile( \
   "l.s $"#FS", %2\n\t"   \
   "l.s $"#FT", %3 \n\t"   \
   "ctc1 %1, $31 \n\t"\
   instruction" $"#FD", $"#FS", $"#FT "\n\t" \
   "cfc1 %1, $31 \n\t"\
   "s.s $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "r" (fpcsr), "m" (FSval), "m" (FTval) \
   : #FD, #FS, #FT,"memory" \
   ); \
   printf(instruction":: fs:%08x ft:%08x out:%08x fpcsr:%08x\n", FSval, FTval, out, fpcsr); \
}


#define TEST_CMP_D(instruction, FD, FS, FT, FSval, FTval) \
{ \
   unsigned long long out; \
   int fpcsr = 0xC0000;\
   __asm__ volatile( \
   "l.d $"#FS", %2\n\t"   \
   "l.d $"#FT", %3 \n\t"   \
   "ctc1 %1, $31 \n\t"\
   instruction" $"#FD", $"#FS", $"#FT "\n\t" \
   "cfc1 %1, $31 \n\t"\
   "s.d $"#FD", %0 \n\t" \
   : "=&m"(out) \
   : "r" (fpcsr), "m" (FSval), "m" (FTval) \
   : #FD, #FS, #FT,"memory" \
   ); \
   printf(instruction":: fs:%016llx ft:%016llx out:%016llx fpcsr:%08x\n", FSval, FTval, out, fpcsr); \
}

int main () {
#if (__mips_isa_rev >= 6)
   int rm;
   printf("max.s\n");
   TEST1_S("max.s", f0, f1, f2, mem1[0], mem1[1]);
   TEST1_S("max.s", f1, f2, f3, mem1[1], mem1[2]);
   TEST1_S("max.s", f2, f3, f4, mem1[2], mem1[3]);
   TEST1_S("max.s", f3, f4, f5, mem1[3], mem1[4]);
   TEST1_S("max.s", f4, f5, f6, mem1[4], mem1[5]);
   TEST1_S("max.s", f5, f6, f7, mem1[5], mem1[6]);
   TEST1_S("max.s", f6, f7, f8, mem1[6], mem1[7]);
   TEST1_S("max.s", f7, f8, f9, mem1[7], mem1[8]);
   TEST1_S("max.s", f8, f9, f10, mem1[8], mem1[9]);
   TEST1_S("max.s", f9, f10, f11, mem1[9], mem1[10]);
   TEST1_S("max.s", f10, f11, f12, mem1[10], mem1[11]);
   TEST1_S("max.s", f11, f12, f13, mem1[11], mem1[12]);
   TEST1_S("max.s", f12, f13, f14, mem1[12], mem1[13]);
   TEST1_S("max.s", f13, f14, f15, mem1[13], mem1[14]);
   TEST1_S("max.s", f14, f15, f16, mem1[14], mem1[15]);
   TEST1_S("max.s", f15, f16, f17, mem1[15], mem1[16]);
   TEST1_S("max.s", f16, f17, f18, mem1[16], mem1[17]);
   TEST1_S("max.s", f17, f18, f19, mem1[17], mem1[18]);
   TEST1_S("max.s", f18, f19, f20, mem1[18], mem1[19]);
   TEST1_S("max.s", f19, f20, f21, mem1[19], mem1[20]);
   TEST1_S("max.s", f20, f21, f22, mem1[20], mem1[21]);
   TEST1_S("max.s", f21, f22, f23, mem1[21], mem1[22]);
   TEST1_S("max.s", f22, f23, f24, mem1[22], mem1[23]);
   TEST1_S("max.s", f23, f24, f25, mem1[23], mem1[24]);
   TEST1_S("max.s", f24, f25, f26, mem1[24], mem1[25]);
   TEST1_S("max.s", f25, f26, f27, mem1[25], mem1[26]);
   TEST1_S("max.s", f26, f27, f28, mem1[26], mem1[27]);
   TEST1_S("max.s", f27, f28, f29, mem1[27], mem1[28]);
   TEST1_S("max.s", f28, f29, f30, mem1[28], mem1[29]);
   TEST1_S("max.s", f29, f30, f31, mem1[29], mem1[30]);

   printf("\nmaxa.s\n");
   TEST1_S("maxa.s", f0, f1, f2, mem1[0], mem1[1]);
   TEST1_S("maxa.s", f1, f2, f3, mem1[1], mem1[2]);
   TEST1_S("maxa.s", f2, f3, f4, mem1[2], mem1[3]);
   TEST1_S("maxa.s", f3, f4, f5, mem1[3], mem1[4]);
   TEST1_S("maxa.s", f4, f5, f6, mem1[4], mem1[5]);
   TEST1_S("maxa.s", f5, f6, f7, mem1[5], mem1[6]);
   TEST1_S("maxa.s", f6, f7, f8, mem1[6], mem1[7]);
   TEST1_S("maxa.s", f7, f8, f9, mem1[7], mem1[8]);
   TEST1_S("maxa.s", f8, f9, f10, mem1[8], mem1[9]);
   TEST1_S("maxa.s", f9, f10, f11, mem1[9], mem1[10]);
   TEST1_S("maxa.s", f10, f11, f12, mem1[10], mem1[11]);
   TEST1_S("maxa.s", f11, f12, f13, mem1[11], mem1[12]);
   TEST1_S("maxa.s", f12, f13, f14, mem1[12], mem1[13]);
   TEST1_S("maxa.s", f13, f14, f15, mem1[13], mem1[14]);
   TEST1_S("maxa.s", f14, f15, f16, mem1[14], mem1[15]);
   TEST1_S("maxa.s", f15, f16, f17, mem1[15], mem1[16]);
   TEST1_S("maxa.s", f16, f17, f18, mem1[16], mem1[17]);
   TEST1_S("maxa.s", f17, f18, f19, mem1[17], mem1[18]);
   TEST1_S("maxa.s", f18, f19, f20, mem1[18], mem1[19]);
   TEST1_S("maxa.s", f19, f20, f21, mem1[19], mem1[20]);
   TEST1_S("maxa.s", f20, f21, f22, mem1[20], mem1[21]);
   TEST1_S("maxa.s", f21, f22, f23, mem1[21], mem1[22]);
   TEST1_S("maxa.s", f22, f23, f24, mem1[22], mem1[23]);
   TEST1_S("maxa.s", f23, f24, f25, mem1[23], mem1[24]);
   TEST1_S("maxa.s", f24, f25, f26, mem1[24], mem1[25]);
   TEST1_S("maxa.s", f25, f26, f27, mem1[25], mem1[26]);
   TEST1_S("maxa.s", f26, f27, f28, mem1[26], mem1[27]);
   TEST1_S("maxa.s", f27, f28, f29, mem1[27], mem1[28]);
   TEST1_S("maxa.s", f28, f29, f30, mem1[28], mem1[29]);
   TEST1_S("maxa.s", f29, f30, f31, mem1[29], mem1[30]);

   printf("\nmin.s\n");
   TEST1_S("min.s", f0, f1, f2, mem1[0], mem1[1]);
   TEST1_S("min.s", f1, f2, f3, mem1[1], mem1[2]);
   TEST1_S("min.s", f2, f3, f4, mem1[2], mem1[3]);
   TEST1_S("min.s", f3, f4, f5, mem1[3], mem1[4]);
   TEST1_S("min.s", f4, f5, f6, mem1[4], mem1[5]);
   TEST1_S("min.s", f5, f6, f7, mem1[5], mem1[6]);
   TEST1_S("min.s", f6, f7, f8, mem1[6], mem1[7]);
   TEST1_S("min.s", f7, f8, f9, mem1[7], mem1[8]);
   TEST1_S("min.s", f8, f9, f10, mem1[8], mem1[9]);
   TEST1_S("min.s", f9, f10, f11, mem1[9], mem1[10]);
   TEST1_S("min.s", f10, f11, f12, mem1[10], mem1[11]);
   TEST1_S("min.s", f11, f12, f13, mem1[11], mem1[12]);
   TEST1_S("min.s", f12, f13, f14, mem1[12], mem1[13]);
   TEST1_S("min.s", f13, f14, f15, mem1[13], mem1[14]);
   TEST1_S("min.s", f14, f15, f16, mem1[14], mem1[15]);
   TEST1_S("min.s", f15, f16, f17, mem1[15], mem1[16]);
   TEST1_S("min.s", f16, f17, f18, mem1[16], mem1[17]);
   TEST1_S("min.s", f17, f18, f19, mem1[17], mem1[18]);
   TEST1_S("min.s", f18, f19, f20, mem1[18], mem1[19]);
   TEST1_S("min.s", f19, f20, f21, mem1[19], mem1[20]);
   TEST1_S("min.s", f20, f21, f22, mem1[20], mem1[21]);
   TEST1_S("min.s", f21, f22, f23, mem1[21], mem1[22]);
   TEST1_S("min.s", f22, f23, f24, mem1[22], mem1[23]);
   TEST1_S("min.s", f23, f24, f25, mem1[23], mem1[24]);
   TEST1_S("min.s", f24, f25, f26, mem1[24], mem1[25]);
   TEST1_S("min.s", f25, f26, f27, mem1[25], mem1[26]);
   TEST1_S("min.s", f26, f27, f28, mem1[26], mem1[27]);
   TEST1_S("min.s", f27, f28, f29, mem1[27], mem1[28]);
   TEST1_S("min.s", f28, f29, f30, mem1[28], mem1[29]);
   TEST1_S("min.s", f29, f30, f31, mem1[29], mem1[30]);

   printf("\nmina.s\n");
   TEST1_S("mina.s", f0, f1, f2, mem1[0], mem1[1]);
   TEST1_S("mina.s", f1, f2, f3, mem1[1], mem1[2]);
   TEST1_S("mina.s", f2, f3, f4, mem1[2], mem1[3]);
   TEST1_S("mina.s", f3, f4, f5, mem1[3], mem1[4]);
   TEST1_S("mina.s", f4, f5, f6, mem1[4], mem1[5]);
   TEST1_S("mina.s", f5, f6, f7, mem1[5], mem1[6]);
   TEST1_S("mina.s", f6, f7, f8, mem1[6], mem1[7]);
   TEST1_S("mina.s", f7, f8, f9, mem1[7], mem1[8]);
   TEST1_S("mina.s", f8, f9, f10, mem1[8], mem1[9]);
   TEST1_S("mina.s", f9, f10, f11, mem1[9], mem1[10]);
   TEST1_S("mina.s", f10, f11, f12, mem1[10], mem1[11]);
   TEST1_S("mina.s", f11, f12, f13, mem1[11], mem1[12]);
   TEST1_S("mina.s", f12, f13, f14, mem1[12], mem1[13]);
   TEST1_S("mina.s", f13, f14, f15, mem1[13], mem1[14]);
   TEST1_S("mina.s", f14, f15, f16, mem1[14], mem1[15]);
   TEST1_S("mina.s", f15, f16, f17, mem1[15], mem1[16]);
   TEST1_S("mina.s", f16, f17, f18, mem1[16], mem1[17]);
   TEST1_S("mina.s", f17, f18, f19, mem1[17], mem1[18]);
   TEST1_S("mina.s", f18, f19, f20, mem1[18], mem1[19]);
   TEST1_S("mina.s", f19, f20, f21, mem1[19], mem1[20]);
   TEST1_S("mina.s", f20, f21, f22, mem1[20], mem1[21]);
   TEST1_S("mina.s", f21, f22, f23, mem1[21], mem1[22]);
   TEST1_S("mina.s", f22, f23, f24, mem1[22], mem1[23]);
   TEST1_S("mina.s", f23, f24, f25, mem1[23], mem1[24]);
   TEST1_S("mina.s", f24, f25, f26, mem1[24], mem1[25]);
   TEST1_S("mina.s", f25, f26, f27, mem1[25], mem1[26]);
   TEST1_S("mina.s", f26, f27, f28, mem1[26], mem1[27]);
   TEST1_S("mina.s", f27, f28, f29, mem1[27], mem1[28]);
   TEST1_S("mina.s", f28, f29, f30, mem1[28], mem1[29]);
   TEST1_S("mina.s", f29, f30, f31, mem1[29], mem1[30]);

   printf("\nmax.d\n");
   TEST1_D("max.d", f0, f1, f2, mem[0], mem[1]);
   TEST1_D("max.d", f1, f2, f3, mem[1], mem[2]);
   TEST1_D("max.d", f2, f3, f4, mem[2], mem[3]);
   TEST1_D("max.d", f3, f4, f5, mem[3], mem[4]);
   TEST1_D("max.d", f4, f5, f6, mem[4], mem[5]);
   TEST1_D("max.d", f5, f6, f7, mem[5], mem[6]);
   TEST1_D("max.d", f6, f7, f8, mem[6], mem[7]);
   TEST1_D("max.d", f7, f8, f9, mem[7], mem[8]);
   TEST1_D("max.d", f8, f9, f10, mem[8], mem[9]);
   TEST1_D("max.d", f9, f10, f11, mem[9], mem[10]);
   TEST1_D("max.d", f10, f11, f12, mem[10], mem[11]);
   TEST1_D("max.d", f11, f12, f13, mem[11], mem[12]);
   TEST1_D("max.d", f12, f13, f14, mem[12], mem[13]);
   TEST1_D("max.d", f13, f14, f15, mem[13], mem[14]);
   TEST1_D("max.d", f14, f15, f16, mem[14], mem[15]);
   TEST1_D("max.d", f15, f16, f17, mem[15], mem[16]);
   TEST1_D("max.d", f16, f17, f18, mem[16], mem[17]);
   TEST1_D("max.d", f17, f18, f19, mem[17], mem[18]);
   TEST1_D("max.d", f18, f19, f20, mem[18], mem[19]);
   TEST1_D("max.d", f19, f20, f21, mem[19], mem[20]);
   TEST1_D("max.d", f20, f21, f22, mem[20], mem[21]);
   TEST1_D("max.d", f21, f22, f23, mem[21], mem[22]);
   TEST1_D("max.d", f22, f23, f24, mem[22], mem[23]);
   TEST1_D("max.d", f23, f24, f25, mem[23], mem[24]);
   TEST1_D("max.d", f24, f25, f26, mem[24], mem[25]);
   TEST1_D("max.d", f25, f26, f27, mem[25], mem[26]);
   TEST1_D("max.d", f26, f27, f28, mem[26], mem[27]);
   TEST1_D("max.d", f27, f28, f29, mem[27], mem[28]);
   TEST1_D("max.d", f28, f29, f30, mem[28], mem[29]);
   TEST1_D("max.d", f29, f30, f31, mem[29], mem[30]);

   printf("\nmaxa.d\n");
   TEST1_D("maxa.d", f0, f1, f2, mem[0], mem[1]);
   TEST1_D("maxa.d", f1, f2, f3, mem[1], mem[2]);
   TEST1_D("maxa.d", f2, f3, f4, mem[2], mem[3]);
   TEST1_D("maxa.d", f3, f4, f5, mem[3], mem[4]);
   TEST1_D("maxa.d", f4, f5, f6, mem[4], mem[5]);
   TEST1_D("maxa.d", f5, f6, f7, mem[5], mem[6]);
   TEST1_D("maxa.d", f6, f7, f8, mem[6], mem[7]);
   TEST1_D("maxa.d", f7, f8, f9, mem[7], mem[8]);
   TEST1_D("maxa.d", f8, f9, f10, mem[8], mem[9]);
   TEST1_D("maxa.d", f9, f10, f11, mem[9], mem[10]);
   TEST1_D("maxa.d", f10, f11, f12, mem[10], mem[11]);
   TEST1_D("maxa.d", f11, f12, f13, mem[11], mem[12]);
   TEST1_D("maxa.d", f12, f13, f14, mem[12], mem[13]);
   TEST1_D("maxa.d", f13, f14, f15, mem[13], mem[14]);
   TEST1_D("maxa.d", f14, f15, f16, mem[14], mem[15]);
   TEST1_D("maxa.d", f15, f16, f17, mem[15], mem[16]);
   TEST1_D("maxa.d", f16, f17, f18, mem[16], mem[17]);
   TEST1_D("maxa.d", f17, f18, f19, mem[17], mem[18]);
   TEST1_D("maxa.d", f18, f19, f20, mem[18], mem[19]);
   TEST1_D("maxa.d", f19, f20, f21, mem[19], mem[20]);
   TEST1_D("maxa.d", f20, f21, f22, mem[20], mem[21]);
   TEST1_D("maxa.d", f21, f22, f23, mem[21], mem[22]);
   TEST1_D("maxa.d", f22, f23, f24, mem[22], mem[23]);
   TEST1_D("maxa.d", f23, f24, f25, mem[23], mem[24]);
   TEST1_D("maxa.d", f24, f25, f26, mem[24], mem[25]);
   TEST1_D("maxa.d", f25, f26, f27, mem[25], mem[26]);
   TEST1_D("maxa.d", f26, f27, f28, mem[26], mem[27]);
   TEST1_D("maxa.d", f27, f28, f29, mem[27], mem[28]);
   TEST1_D("maxa.d", f28, f29, f30, mem[28], mem[29]);
   TEST1_D("maxa.d", f29, f30, f31, mem[29], mem[30]);

   printf("\nmin.d\n");
   TEST1_D("min.d", f0, f1, f2, mem[0], mem[1]);
   TEST1_D("min.d", f1, f2, f3, mem[1], mem[2]);
   TEST1_D("min.d", f2, f3, f4, mem[2], mem[3]);
   TEST1_D("min.d", f3, f4, f5, mem[3], mem[4]);
   TEST1_D("min.d", f4, f5, f6, mem[4], mem[5]);
   TEST1_D("min.d", f5, f6, f7, mem[5], mem[6]);
   TEST1_D("min.d", f6, f7, f8, mem[6], mem[7]);
   TEST1_D("min.d", f7, f8, f9, mem[7], mem[8]);
   TEST1_D("min.d", f8, f9, f10, mem[8], mem[9]);
   TEST1_D("min.d", f9, f10, f11, mem[9], mem[10]);
   TEST1_D("min.d", f10, f11, f12, mem[10], mem[11]);
   TEST1_D("min.d", f11, f12, f13, mem[11], mem[12]);
   TEST1_D("min.d", f12, f13, f14, mem[12], mem[13]);
   TEST1_D("min.d", f13, f14, f15, mem[13], mem[14]);
   TEST1_D("min.d", f14, f15, f16, mem[14], mem[15]);
   TEST1_D("min.d", f15, f16, f17, mem[15], mem[16]);
   TEST1_D("min.d", f16, f17, f18, mem[16], mem[17]);
   TEST1_D("min.d", f17, f18, f19, mem[17], mem[18]);
   TEST1_D("min.d", f18, f19, f20, mem[18], mem[19]);
   TEST1_D("min.d", f19, f20, f21, mem[19], mem[20]);
   TEST1_D("min.d", f20, f21, f22, mem[20], mem[21]);
   TEST1_D("min.d", f21, f22, f23, mem[21], mem[22]);
   TEST1_D("min.d", f22, f23, f24, mem[22], mem[23]);
   TEST1_D("min.d", f23, f24, f25, mem[23], mem[24]);
   TEST1_D("min.d", f24, f25, f26, mem[24], mem[25]);
   TEST1_D("min.d", f25, f26, f27, mem[25], mem[26]);
   TEST1_D("min.d", f26, f27, f28, mem[26], mem[27]);
   TEST1_D("min.d", f27, f28, f29, mem[27], mem[28]);
   TEST1_D("min.d", f28, f29, f30, mem[28], mem[29]);
   TEST1_D("min.d", f29, f30, f31, mem[29], mem[30]);

   printf("\nmina.d\n");
   TEST1_D("mina.d", f0, f1, f2, mem[0], mem[1]);
   TEST1_D("mina.d", f1, f2, f3, mem[1], mem[2]);
   TEST1_D("mina.d", f2, f3, f4, mem[2], mem[3]);
   TEST1_D("mina.d", f3, f4, f5, mem[3], mem[4]);
   TEST1_D("mina.d", f4, f5, f6, mem[4], mem[5]);
   TEST1_D("mina.d", f5, f6, f7, mem[5], mem[6]);
   TEST1_D("mina.d", f6, f7, f8, mem[6], mem[7]);
   TEST1_D("mina.d", f7, f8, f9, mem[7], mem[8]);
   TEST1_D("mina.d", f8, f9, f10, mem[8], mem[9]);
   TEST1_D("mina.d", f9, f10, f11, mem[9], mem[10]);
   TEST1_D("mina.d", f10, f11, f12, mem[10], mem[11]);
   TEST1_D("mina.d", f11, f12, f13, mem[11], mem[12]);
   TEST1_D("mina.d", f12, f13, f14, mem[12], mem[13]);
   TEST1_D("mina.d", f13, f14, f15, mem[13], mem[14]);
   TEST1_D("mina.d", f14, f15, f16, mem[14], mem[15]);
   TEST1_D("mina.d", f15, f16, f17, mem[15], mem[16]);
   TEST1_D("mina.d", f16, f17, f18, mem[16], mem[17]);
   TEST1_D("mina.d", f17, f18, f19, mem[17], mem[18]);
   TEST1_D("mina.d", f18, f19, f20, mem[18], mem[19]);
   TEST1_D("mina.d", f19, f20, f21, mem[19], mem[20]);
   TEST1_D("mina.d", f20, f21, f22, mem[20], mem[21]);
   TEST1_D("mina.d", f21, f22, f23, mem[21], mem[22]);
   TEST1_D("mina.d", f22, f23, f24, mem[22], mem[23]);
   TEST1_D("mina.d", f23, f24, f25, mem[23], mem[24]);
   TEST1_D("mina.d", f24, f25, f26, mem[24], mem[25]);
   TEST1_D("mina.d", f25, f26, f27, mem[25], mem[26]);
   TEST1_D("mina.d", f26, f27, f28, mem[26], mem[27]);
   TEST1_D("mina.d", f27, f28, f29, mem[27], mem[28]);
   TEST1_D("mina.d", f28, f29, f30, mem[28], mem[29]);
   TEST1_D("mina.d", f29, f30, f31, mem[29], mem[30]);

   for (rm = 0; rm < 4; rm++) {

      printf("\nmaddf.s\n");
      TEST2_S("maddf.s", f0, f1, f2, mem1[0], mem1[1], mem1[2]);
      TEST2_S("maddf.s", f1, f2, f3, mem1[1], mem1[2], mem1[3]);
      TEST2_S("maddf.s", f2, f3, f4, mem1[2], mem1[3], mem1[4]);
      TEST2_S("maddf.s", f3, f4, f5, mem1[3], mem1[4], mem1[5]);
      TEST2_S("maddf.s", f4, f5, f6, mem1[4], mem1[5], mem1[6]);
      TEST2_S("maddf.s", f5, f6, f7, mem1[5], mem1[6], mem1[7]);
      TEST2_S("maddf.s", f6, f7, f8, mem1[6], mem1[7], mem1[8]);
      TEST2_S("maddf.s", f7, f8, f9, mem1[7], mem1[8], mem1[9]);
      TEST2_S("maddf.s", f8, f9, f10, mem1[8], mem1[9], mem1[10]);
      TEST2_S("maddf.s", f9, f10, f11, mem1[9], mem1[10], mem1[11]);
      TEST2_S("maddf.s", f10, f11, f12, mem1[10], mem1[11], mem1[12]);
      TEST2_S("maddf.s", f11, f12, f13, mem1[11], mem1[12], mem1[13]);
      TEST2_S("maddf.s", f12, f13, f14, mem1[12], mem1[13], mem1[14]);
      TEST2_S("maddf.s", f13, f14, f15, mem1[13], mem1[14], mem1[15]);
      TEST2_S("maddf.s", f14, f15, f16, mem1[14], mem1[15], mem1[16]);
      TEST2_S("maddf.s", f15, f16, f17, mem1[15], mem1[16], mem1[17]);
      TEST2_S("maddf.s", f16, f17, f18, mem1[16], mem1[17], mem1[18]);
      TEST2_S("maddf.s", f17, f18, f19, mem1[17], mem1[18], mem1[19]);
      TEST2_S("maddf.s", f18, f19, f20, mem1[18], mem1[19], mem1[20]);
      TEST2_S("maddf.s", f19, f20, f21, mem1[19], mem1[20], mem1[21]);
      TEST2_S("maddf.s", f20, f21, f22, mem1[20], mem1[21], mem1[22]);
      TEST2_S("maddf.s", f21, f22, f23, mem1[21], mem1[22], mem1[23]);
      TEST2_S("maddf.s", f22, f23, f24, mem1[22], mem1[23], mem1[24]);
      TEST2_S("maddf.s", f23, f24, f25, mem1[23], mem1[24], mem1[25]);
      TEST2_S("maddf.s", f24, f25, f26, mem1[24], mem1[25], mem1[26]);
      TEST2_S("maddf.s", f25, f26, f27, mem1[25], mem1[26], mem1[27]);
      TEST2_S("maddf.s", f26, f27, f28, mem1[26], mem1[27], mem1[28]);
      TEST2_S("maddf.s", f27, f28, f29, mem1[27], mem1[28], mem1[29]);
      TEST2_S("maddf.s", f28, f29, f30, mem1[28], mem1[29], mem1[30]);
      TEST2_S("maddf.s", f29, f30, f31, mem1[29], mem1[30], mem1[0]);

      printf("\nmsubf.s\n");
      TEST2_S("msubf.s", f0, f1, f2, mem1[0], mem1[1], mem1[2]);
      TEST2_S("msubf.s", f1, f2, f3, mem1[1], mem1[2], mem1[3]);
      TEST2_S("msubf.s", f2, f3, f4, mem1[2], mem1[3], mem1[4]);
      TEST2_S("msubf.s", f3, f4, f5, mem1[3], mem1[4], mem1[5]);
      TEST2_S("msubf.s", f4, f5, f6, mem1[4], mem1[5], mem1[6]);
      TEST2_S("msubf.s", f5, f6, f7, mem1[5], mem1[6], mem1[7]);
      TEST2_S("msubf.s", f6, f7, f8, mem1[6], mem1[7], mem1[8]);
      TEST2_S("msubf.s", f7, f8, f9, mem1[7], mem1[8], mem1[9]);
      TEST2_S("msubf.s", f8, f9, f10, mem1[8], mem1[9], mem1[10]);
      TEST2_S("msubf.s", f9, f10, f11, mem1[9], mem1[10], mem1[11]);
      TEST2_S("msubf.s", f10, f11, f12, mem1[10], mem1[11], mem1[12]);
      TEST2_S("msubf.s", f11, f12, f13, mem1[11], mem1[12], mem1[13]);
      TEST2_S("msubf.s", f12, f13, f14, mem1[12], mem1[13], mem1[14]);
      TEST2_S("msubf.s", f13, f14, f15, mem1[13], mem1[14], mem1[15]);
      TEST2_S("msubf.s", f14, f15, f16, mem1[14], mem1[15], mem1[16]);
      TEST2_S("msubf.s", f15, f16, f17, mem1[15], mem1[16], mem1[17]);
      TEST2_S("msubf.s", f16, f17, f18, mem1[16], mem1[17], mem1[18]);
      TEST2_S("msubf.s", f17, f18, f19, mem1[17], mem1[18], mem1[19]);
      TEST2_S("msubf.s", f18, f19, f20, mem1[18], mem1[19], mem1[20]);
      TEST2_S("msubf.s", f19, f20, f21, mem1[19], mem1[20], mem1[21]);
      TEST2_S("msubf.s", f20, f21, f22, mem1[20], mem1[21], mem1[22]);
      TEST2_S("msubf.s", f21, f22, f23, mem1[21], mem1[22], mem1[23]);
      TEST2_S("msubf.s", f22, f23, f24, mem1[22], mem1[23], mem1[24]);
      TEST2_S("msubf.s", f23, f24, f25, mem1[23], mem1[24], mem1[25]);
      TEST2_S("msubf.s", f24, f25, f26, mem1[24], mem1[25], mem1[26]);
      TEST2_S("msubf.s", f25, f26, f27, mem1[25], mem1[26], mem1[27]);
      TEST2_S("msubf.s", f26, f27, f28, mem1[26], mem1[27], mem1[28]);
      TEST2_S("msubf.s", f27, f28, f29, mem1[27], mem1[28], mem1[29]);
      TEST2_S("msubf.s", f28, f29, f30, mem1[28], mem1[29], mem1[30]);
      TEST2_S("msubf.s", f29, f30, f31, mem1[29], mem1[30], mem1[0]);

      printf("\nmaddf.d\n");
      TEST2_D("maddf.d", f0, f1, f2, mem[0], mem[1], mem[2]);
      TEST2_D("maddf.d", f1, f2, f3, mem[1], mem[2], mem[3]);
      TEST2_D("maddf.d", f2, f3, f4, mem[2], mem[3], mem[4]);
      TEST2_D("maddf.d", f3, f4, f5, mem[3], mem[4], mem[5]);
      TEST2_D("maddf.d", f4, f5, f6, mem[4], mem[5], mem[6]);
      TEST2_D("maddf.d", f5, f6, f7, mem[5], mem[6], mem[7]);
      TEST2_D("maddf.d", f6, f7, f8, mem[6], mem[7], mem[8]);
      TEST2_D("maddf.d", f7, f8, f9, mem[7], mem[8], mem[9]);
      TEST2_D("maddf.d", f8, f9, f10, mem[8], mem[9], mem[10]);
      TEST2_D("maddf.d", f9, f10, f11, mem[9], mem[10], mem[11]);
      TEST2_D("maddf.d", f10, f11, f12, mem[10], mem[11], mem[12]);
      TEST2_D("maddf.d", f11, f12, f13, mem[11], mem[12], mem[13]);
      TEST2_D("maddf.d", f12, f13, f14, mem[12], mem[13], mem[14]);
      TEST2_D("maddf.d", f13, f14, f15, mem[13], mem[14], mem[15]);
      TEST2_D("maddf.d", f14, f15, f16, mem[14], mem[15], mem[16]);
      TEST2_D("maddf.d", f15, f16, f17, mem[15], mem[16], mem[17]);
      TEST2_D("maddf.d", f16, f17, f18, mem[16], mem[17], mem[18]);
      TEST2_D("maddf.d", f17, f18, f19, mem[17], mem[18], mem[19]);
      TEST2_D("maddf.d", f18, f19, f20, mem[18], mem[19], mem[20]);
      TEST2_D("maddf.d", f19, f20, f21, mem[19], mem[20], mem[21]);
      TEST2_D("maddf.d", f20, f21, f22, mem[20], mem[21], mem[22]);
      TEST2_D("maddf.d", f21, f22, f23, mem[21], mem[22], mem[23]);
      TEST2_D("maddf.d", f22, f23, f24, mem[22], mem[23], mem[24]);
      TEST2_D("maddf.d", f23, f24, f25, mem[23], mem[24], mem[25]);
      TEST2_D("maddf.d", f24, f25, f26, mem[24], mem[25], mem[26]);
      TEST2_D("maddf.d", f25, f26, f27, mem[25], mem[26], mem[27]);
      TEST2_D("maddf.d", f26, f27, f28, mem[26], mem[27], mem[28]);
      TEST2_D("maddf.d", f27, f28, f29, mem[27], mem[28], mem[29]);
      TEST2_D("maddf.d", f28, f29, f30, mem[28], mem[29], mem[30]);
      TEST2_D("maddf.d", f29, f30, f31, mem[29], mem[30], mem[0]);

      printf("\nmsubf.d\n");
      TEST2_D("msubf.d", f0, f1, f2, mem[0], mem[1], mem[2]);
      TEST2_D("msubf.d", f1, f2, f3, mem[1], mem[2], mem[3]);
      TEST2_D("msubf.d", f2, f3, f4, mem[2], mem[3], mem[4]);
      TEST2_D("msubf.d", f3, f4, f5, mem[3], mem[4], mem[5]);
      TEST2_D("msubf.d", f4, f5, f6, mem[4], mem[5], mem[6]);
      TEST2_D("msubf.d", f5, f6, f7, mem[5], mem[6], mem[7]);
      TEST2_D("msubf.d", f6, f7, f8, mem[6], mem[7], mem[8]);
      TEST2_D("msubf.d", f7, f8, f9, mem[7], mem[8], mem[9]);
      TEST2_D("msubf.d", f8, f9, f10, mem[8], mem[9], mem[10]);
      TEST2_D("msubf.d", f9, f10, f11, mem[9], mem[10], mem[11]);
      TEST2_D("msubf.d", f10, f11, f12, mem[10], mem[11], mem[12]);
      TEST2_D("msubf.d", f11, f12, f13, mem[11], mem[12], mem[13]);
      TEST2_D("msubf.d", f12, f13, f14, mem[12], mem[13], mem[14]);
      TEST2_D("msubf.d", f13, f14, f15, mem[13], mem[14], mem[15]);
      TEST2_D("msubf.d", f14, f15, f16, mem[14], mem[15], mem[16]);
      TEST2_D("msubf.d", f15, f16, f17, mem[15], mem[16], mem[17]);
      TEST2_D("msubf.d", f16, f17, f18, mem[16], mem[17], mem[18]);
      TEST2_D("msubf.d", f17, f18, f19, mem[17], mem[18], mem[19]);
      TEST2_D("msubf.d", f18, f19, f20, mem[18], mem[19], mem[20]);
      TEST2_D("msubf.d", f19, f20, f21, mem[19], mem[20], mem[21]);
      TEST2_D("msubf.d", f20, f21, f22, mem[20], mem[21], mem[22]);
      TEST2_D("msubf.d", f21, f22, f23, mem[21], mem[22], mem[23]);
      TEST2_D("msubf.d", f22, f23, f24, mem[22], mem[23], mem[24]);
      TEST2_D("msubf.d", f23, f24, f25, mem[23], mem[24], mem[25]);
      TEST2_D("msubf.d", f24, f25, f26, mem[24], mem[25], mem[26]);
      TEST2_D("msubf.d", f25, f26, f27, mem[25], mem[26], mem[27]);
      TEST2_D("msubf.d", f26, f27, f28, mem[26], mem[27], mem[28]);
      TEST2_D("msubf.d", f27, f28, f29, mem[27], mem[28], mem[29]);
      TEST2_D("msubf.d", f28, f29, f30, mem[28], mem[29], mem[30]);
      TEST2_D("msubf.d", f29, f30, f31, mem[29], mem[30], mem[0]);

      printf("\nrint.s\n");
      TEST4_S("rint.s", f0, f1, mem1[0]);
      TEST4_S("rint.s", f1, f2, mem1[1]);
      TEST4_S("rint.s", f2, f3, mem1[2]);
      TEST4_S("rint.s", f3, f4, mem1[3]);
      TEST4_S("rint.s", f4, f5, mem1[4]);
      TEST4_S("rint.s", f5, f6, mem1[5]);
      TEST4_S("rint.s", f6, f7, mem1[6]);
      TEST4_S("rint.s", f7, f8, mem1[7]);
      TEST4_S("rint.s", f8, f9, mem1[8]);
      TEST4_S("rint.s", f9, f10, mem1[9]);
      TEST4_S("rint.s", f10, f11, mem1[10]);
      TEST4_S("rint.s", f11, f12, mem1[11]);
      TEST4_S("rint.s", f12, f13, mem1[12]);
      TEST4_S("rint.s", f13, f14, mem1[13]);
      TEST4_S("rint.s", f14, f15, mem1[14]);
      TEST4_S("rint.s", f15, f16, mem1[15]);
      TEST4_S("rint.s", f16, f17, mem1[16]);
      TEST4_S("rint.s", f17, f18, mem1[17]);
      TEST4_S("rint.s", f18, f19, mem1[18]);
      TEST4_S("rint.s", f19, f20, mem1[19]);
      TEST4_S("rint.s", f20, f21, mem1[20]);
      TEST4_S("rint.s", f21, f22, mem1[21]);
      TEST4_S("rint.s", f22, f23, mem1[22]);
      TEST4_S("rint.s", f23, f24, mem1[23]);
      TEST4_S("rint.s", f24, f25, mem1[24]);
      TEST4_S("rint.s", f25, f26, mem1[25]);
      TEST4_S("rint.s", f26, f27, mem1[26]);
      TEST4_S("rint.s", f27, f28, mem1[27]);
      TEST4_S("rint.s", f28, f29, mem1[28]);
      TEST4_S("rint.s", f29, f30, mem1[29]);
      TEST4_S("rint.s", f30, f31, mem1[30]);

      printf("\nrint.d\n");
      TEST4_D("rint.d", f0, f1, mem[0]);
      TEST4_D("rint.d", f1, f2, mem[1]);
      TEST4_D("rint.d", f2, f3, mem[2]);
      TEST4_D("rint.d", f3, f4, mem[3]);
      TEST4_D("rint.d", f4, f5, mem[4]);
      TEST4_D("rint.d", f5, f6, mem[5]);
      TEST4_D("rint.d", f6, f7, mem[6]);
      TEST4_D("rint.d", f7, f8, mem[7]);
      TEST4_D("rint.d", f8, f9, mem[8]);
      TEST4_D("rint.d", f9, f10, mem[9]);
      TEST4_D("rint.d", f10, f11, mem[10]);
      TEST4_D("rint.d", f11, f12, mem[11]);
      TEST4_D("rint.d", f12, f13, mem[12]);
      TEST4_D("rint.d", f13, f14, mem[13]);
      TEST4_D("rint.d", f14, f15, mem[14]);
      TEST4_D("rint.d", f15, f16, mem[15]);
      TEST4_D("rint.d", f16, f17, mem[16]);
      TEST4_D("rint.d", f17, f18, mem[17]);
      TEST4_D("rint.d", f18, f19, mem[18]);
      TEST4_D("rint.d", f19, f20, mem[19]);
      TEST4_D("rint.d", f20, f21, mem[20]);
      TEST4_D("rint.d", f21, f22, mem[21]);
      TEST4_D("rint.d", f22, f23, mem[22]);
      TEST4_D("rint.d", f23, f24, mem[23]);
      TEST4_D("rint.d", f24, f25, mem[24]);
      TEST4_D("rint.d", f25, f26, mem[25]);
      TEST4_D("rint.d", f26, f27, mem[26]);
      TEST4_D("rint.d", f27, f28, mem[27]);
      TEST4_D("rint.d", f28, f29, mem[28]);
      TEST4_D("rint.d", f29, f30, mem[29]);
      TEST4_D("rint.d", f30, f31, mem[30]);
   }

   printf("\nsel.s\n");
   TEST3_S("sel.s", f0, f1, f2, mem1[0], mem1[1], condition1[0]);
   TEST3_S("sel.s", f1, f2, f3, mem1[1], mem1[2], condition1[1]);
   TEST3_S("sel.s", f2, f3, f4, mem1[2], mem1[3], condition1[2]);
   TEST3_S("sel.s", f3, f4, f5, mem1[3], mem1[4], condition1[3]);
   TEST3_S("sel.s", f4, f5, f6, mem1[4], mem1[5], condition1[4]);
   TEST3_S("sel.s", f5, f6, f7, mem1[5], mem1[6], condition1[5]);
   TEST3_S("sel.s", f6, f7, f8, mem1[6], mem1[7], condition1[6]);
   TEST3_S("sel.s", f7, f8, f9, mem1[7], mem1[8], condition1[7]);
   TEST3_S("sel.s", f8, f9, f10, mem1[8], mem1[9], condition1[8]);
   TEST3_S("sel.s", f9, f10, f11, mem1[9], mem1[10], condition1[9]);
   TEST3_S("sel.s", f10, f11, f12, mem1[10], mem1[11], condition1[10]);

   printf("\nsel.d\n");
   TEST3_D("sel.d", f0, f1, f2, mem[0], mem[1], condition[0]);
   TEST3_D("sel.d", f1, f2, f3, mem[1], mem[2], condition[1]);
   TEST3_D("sel.d", f2, f3, f4, mem[2], mem[3], condition[2]);
   TEST3_D("sel.d", f3, f4, f5, mem[3], mem[4], condition[3]);
   TEST3_D("sel.d", f4, f5, f6, mem[4], mem[5], condition[4]);
   TEST3_D("sel.d", f5, f6, f7, mem[5], mem[6], condition[5]);
   TEST3_D("sel.d", f6, f7, f8, mem[6], mem[7], condition[6]);
   TEST3_D("sel.d", f7, f8, f9, mem[7], mem[8], condition[7]);
   TEST3_D("sel.d", f8, f9, f10, mem[8], mem[9], condition[8]);
   TEST3_D("sel.d", f9, f10, f11, mem[9], mem[10], condition[9]);
   TEST3_D("sel.d", f10, f11, f12, mem[10], mem[11], condition[10]);

   printf("\nseleqz.s\n");
   TEST3_Sv2("seleqz.s", f0, f1, f2, mem1[0], condition1[0], mem1[1]);
   TEST3_Sv2("seleqz.s", f1, f2, f3, mem1[1], condition1[1], mem1[2]);
   TEST3_Sv2("seleqz.s", f2, f3, f4, mem1[2], condition1[2], mem1[3]);
   TEST3_Sv2("seleqz.s", f3, f4, f5, mem1[3], condition1[3], mem1[4]);
   TEST3_Sv2("seleqz.s", f4, f5, f6, mem1[4], condition1[4], mem1[5]);
   TEST3_Sv2("seleqz.s", f5, f6, f7, mem1[5], condition1[5], mem1[6]);
   TEST3_Sv2("seleqz.s", f6, f7, f8, mem1[6], condition1[6], mem1[7]);
   TEST3_Sv2("seleqz.s", f7, f8, f9, mem1[7], condition1[7], mem1[8]);
   TEST3_Sv2("seleqz.s", f8, f9, f10, mem1[8], condition1[8], mem1[9]);
   TEST3_Sv2("seleqz.s", f9, f10, f11, mem1[9], condition1[9], mem1[10]);

   printf("\nseleqz.d\n");
   TEST3_Dv2("seleqz.d", f0, f1, f2, mem[0], condition[0], mem[1]);
   TEST3_Dv2("seleqz.d", f1, f2, f3, mem[1], condition[1], mem[2]);
   TEST3_Dv2("seleqz.d", f2, f3, f4, mem[2], condition[2], mem[3]);
   TEST3_Dv2("seleqz.d", f3, f4, f5, mem[3], condition[3], mem[4]);
   TEST3_Dv2("seleqz.d", f4, f5, f6, mem[4], condition[4], mem[5]);
   TEST3_Dv2("seleqz.d", f5, f6, f7, mem[5], condition[5], mem[6]);
   TEST3_Dv2("seleqz.d", f6, f7, f8, mem[6], condition[6], mem[7]);
   TEST3_Dv2("seleqz.d", f7, f8, f9, mem[7], condition[7], mem[8]);
   TEST3_Dv2("seleqz.d", f8, f9, f10, mem[8], condition[8], mem[9]);
   TEST3_Dv2("seleqz.d", f9, f10, f11, mem[9], condition[9], mem[10]);

   printf("\nselnez.s\n");
   TEST3_Sv2("selnez.s", f0, f1, f2, mem1[0], condition1[0], mem1[1]);
   TEST3_Sv2("selnez.s", f1, f2, f3, mem1[1], condition1[1], mem1[2]);
   TEST3_Sv2("selnez.s", f2, f3, f4, mem1[2], condition1[2], mem1[3]);
   TEST3_Sv2("selnez.s", f3, f4, f5, mem1[3], condition1[3], mem1[4]);
   TEST3_Sv2("selnez.s", f4, f5, f6, mem1[4], condition1[4], mem1[5]);
   TEST3_Sv2("selnez.s", f5, f6, f7, mem1[5], condition1[5], mem1[6]);
   TEST3_Sv2("selnez.s", f6, f7, f8, mem1[6], condition1[6], mem1[7]);
   TEST3_Sv2("selnez.s", f7, f8, f9, mem1[7], condition1[7], mem1[8]);
   TEST3_Sv2("selnez.s", f8, f9, f10, mem1[8], condition1[8], mem1[9]);
   TEST3_Sv2("selnez.s", f9, f10, f11, mem1[9], condition1[9], mem1[10]);

   printf("\nselnez.d\n");
   TEST3_Dv2("selnez.d", f0, f1, f2, mem[0], condition[0], mem[1]);
   TEST3_Dv2("selnez.d", f1, f2, f3, mem[1], condition[1], mem[2]);
   TEST3_Dv2("selnez.d", f2, f3, f4, mem[2], condition[2], mem[3]);
   TEST3_Dv2("selnez.d", f3, f4, f5, mem[3], condition[3], mem[4]);
   TEST3_Dv2("selnez.d", f4, f5, f6, mem[4], condition[4], mem[5]);
   TEST3_Dv2("selnez.d", f5, f6, f7, mem[5], condition[5], mem[6]);
   TEST3_Dv2("selnez.d", f6, f7, f8, mem[6], condition[6], mem[7]);
   TEST3_Dv2("selnez.d", f7, f8, f9, mem[7], condition[7], mem[8]);
   TEST3_Dv2("selnez.d", f8, f9, f10, mem[8], condition[8], mem[9]);
   TEST3_Dv2("selnez.d", f9, f10, f11, mem[9], condition[9], mem[10]);

   printf("\nclass.s\n");
   TEST5_S("class.s", f0, f1, flt[0])
   TEST5_S("class.s", f1, f2, flt[1])
   TEST5_S("class.s", f2, f3, flt[2])
   TEST5_S("class.s", f3, f4, flt[3])
   TEST5_S("class.s", f4, f5, flt[4])
   TEST5_S("class.s", f5, f6, flt[5])
   TEST5_S("class.s", f6, f7, flt[6])
   TEST5_S("class.s", f7, f8, flt[7])
   TEST5_S("class.s", f8, f9, flt[8])
   TEST5_S("class.s", f9, f10, flt[9])

   printf("\nclass.d\n");
   TEST5_D("class.d", f0, f1, dbl[0])
   TEST5_D("class.d", f1, f2, dbl[1])
   TEST5_D("class.d", f2, f3, dbl[2])
   TEST5_D("class.d", f3, f4, dbl[3])
   TEST5_D("class.d", f4, f5, dbl[4])
   TEST5_D("class.d", f5, f6, dbl[5])
   TEST5_D("class.d", f6, f7, dbl[6])
   TEST5_D("class.d", f7, f8, dbl[7])
   TEST5_D("class.d", f8, f9, dbl[8])
   TEST5_D("class.d", f9, f10, dbl[9])

   printf("cmp.af.s\n");
   TEST_CMP_S("cmp.af.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.af.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.af.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.af.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.af.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.af.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.af.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.af.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.af.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.af.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.af.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.af.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.af.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.af.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.af.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.af.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.af.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.af.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.af.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.af.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.af.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.af.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.af.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.af.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.af.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.af.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.af.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.af.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.af.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.af.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.af.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.af.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.af.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.af.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.af.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.af.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.af.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.af.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.af.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.af.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.af.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.af.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.af.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.af.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.af.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.af.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.af.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.af.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.af.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.af.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.af.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.af.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.af.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.af.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.af.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.af.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.af.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.af.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.af.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.af.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.af.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.af.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.af.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.af.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.af.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.af.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.af.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.af.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.af.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.af.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.af.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.af.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.af.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.af.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.af.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.af.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.af.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.af.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.af.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.af.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.af.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.af.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.af.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.af.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.af.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.af.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.af.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.af.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.af.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.af.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.af.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.af.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.af.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.af.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.af.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.af.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.af.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.af.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.af.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.af.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.af.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.af.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.af.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.af.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.af.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.af.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.af.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.af.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.af.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.af.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.af.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.af.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.af.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.af.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.af.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.af.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.af.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.af.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.af.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.af.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.af.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.af.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.af.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.af.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.af.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.af.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.af.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.af.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.af.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.af.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.af.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.af.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.af.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.un.s\n");
   TEST_CMP_S("cmp.un.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.un.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.un.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.un.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.un.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.un.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.un.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.un.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.un.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.un.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.un.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.un.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.un.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.un.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.un.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.un.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.un.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.un.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.un.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.un.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.un.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.un.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.un.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.un.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.un.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.un.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.un.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.un.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.un.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.un.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.un.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.un.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.un.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.un.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.un.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.un.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.un.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.un.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.un.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.un.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.un.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.un.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.un.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.un.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.un.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.un.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.un.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.un.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.un.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.un.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.un.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.un.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.un.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.un.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.un.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.un.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.un.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.un.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.un.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.un.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.un.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.un.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.un.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.un.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.un.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.un.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.un.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.un.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.un.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.un.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.un.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.un.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.un.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.un.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.un.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.un.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.un.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.un.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.un.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.un.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.un.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.un.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.un.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.un.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.un.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.un.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.un.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.un.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.un.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.un.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.un.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.un.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.un.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.un.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.un.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.un.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.un.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.un.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.un.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.un.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.un.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.un.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.un.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.un.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.un.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.un.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.un.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.un.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.un.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.un.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.un.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.un.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.un.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.un.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.un.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.un.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.un.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.un.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.un.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.un.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.un.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.un.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.un.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.un.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.un.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.un.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.un.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.un.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.un.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.un.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.un.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.un.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.un.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.eq.s\n");
   TEST_CMP_S("cmp.eq.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.eq.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.eq.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.eq.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.eq.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.eq.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.eq.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.eq.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.eq.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.eq.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.eq.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.eq.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.eq.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.eq.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.eq.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.eq.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.eq.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.eq.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.eq.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.eq.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.eq.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.eq.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.eq.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.eq.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.eq.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.eq.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.eq.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.eq.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.eq.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.eq.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.eq.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.eq.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.eq.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.eq.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.eq.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.eq.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.eq.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.eq.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.eq.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.eq.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.eq.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.eq.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.eq.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.eq.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.eq.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.eq.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.eq.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.eq.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.eq.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.eq.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.eq.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.eq.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.eq.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.eq.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.eq.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.eq.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.eq.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.eq.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.eq.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.eq.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.eq.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.eq.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.eq.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.eq.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.eq.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.eq.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.eq.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.eq.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.eq.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.eq.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.eq.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.eq.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.eq.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.eq.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.eq.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.eq.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.eq.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.eq.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.eq.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.eq.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.eq.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.eq.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.eq.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.eq.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.eq.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.eq.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.eq.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.eq.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.eq.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.eq.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.eq.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.eq.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.eq.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.eq.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.eq.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.eq.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.eq.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.eq.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.eq.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.eq.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.eq.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.eq.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.eq.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.eq.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.eq.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.eq.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.eq.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.eq.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.eq.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.eq.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.eq.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.eq.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.eq.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.eq.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.eq.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.eq.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.eq.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.eq.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.eq.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.eq.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.eq.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.eq.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.eq.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.eq.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.eq.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.eq.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.eq.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.eq.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.eq.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.eq.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.eq.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.eq.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.eq.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.ueq.s\n");
   TEST_CMP_S("cmp.ueq.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.ueq.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.ueq.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.ueq.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.ueq.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.ueq.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.ueq.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.ueq.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.ueq.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.ueq.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.ueq.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.ueq.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.ueq.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.ueq.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.ueq.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.ueq.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.ueq.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.ueq.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.ueq.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.ueq.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.ueq.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.ueq.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.ueq.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.ueq.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.ueq.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.ueq.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.ueq.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.ueq.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.ueq.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.ueq.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.ueq.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.ueq.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.ueq.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.ueq.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.ueq.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.ueq.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.ueq.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.ueq.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.ueq.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.ueq.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.ueq.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.ueq.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.ueq.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.ueq.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.ueq.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.ueq.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.ueq.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.ueq.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.ueq.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.ueq.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.ueq.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.ueq.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.ueq.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.ueq.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.ueq.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.ueq.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.ueq.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.ueq.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.ueq.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.ueq.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.ueq.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.ueq.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.ueq.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.ueq.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.ueq.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.ueq.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.ueq.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.ueq.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.ueq.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.ueq.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.ueq.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.ueq.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.ueq.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.ueq.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.ueq.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.ueq.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.ueq.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.ueq.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.ueq.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.ueq.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.ueq.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.ueq.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.ueq.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.ueq.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.ueq.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.ueq.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.ueq.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.ueq.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.ueq.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.ueq.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.ueq.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.ueq.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.ueq.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.ueq.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.ueq.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.ueq.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.ueq.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.ueq.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.ueq.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.ueq.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.ueq.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.ueq.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.ueq.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.ueq.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.ueq.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.ueq.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.ueq.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.ueq.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.ueq.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.ueq.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.ueq.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.ueq.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.ueq.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.ueq.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.ueq.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.ueq.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.ueq.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.ueq.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.ueq.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.ueq.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.ueq.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.ueq.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.ueq.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.ueq.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.ueq.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.ueq.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.ueq.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.ueq.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.ueq.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.ueq.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.ueq.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.ueq.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.ueq.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.lt.s\n");
   TEST_CMP_S("cmp.lt.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.lt.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.lt.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.lt.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.lt.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.lt.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.lt.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.lt.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.lt.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.lt.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.lt.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.lt.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.lt.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.lt.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.lt.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.lt.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.lt.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.lt.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.lt.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.lt.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.lt.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.lt.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.lt.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.lt.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.lt.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.lt.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.lt.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.lt.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.lt.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.lt.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.lt.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.lt.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.lt.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.lt.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.lt.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.lt.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.lt.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.lt.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.lt.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.lt.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.lt.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.lt.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.lt.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.lt.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.lt.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.lt.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.lt.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.lt.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.lt.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.lt.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.lt.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.lt.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.lt.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.lt.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.lt.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.lt.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.lt.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.lt.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.lt.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.lt.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.lt.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.lt.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.lt.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.lt.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.lt.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.lt.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.lt.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.lt.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.lt.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.lt.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.lt.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.lt.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.lt.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.lt.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.lt.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.lt.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.lt.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.lt.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.lt.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.lt.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.lt.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.lt.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.lt.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.lt.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.lt.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.lt.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.lt.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.lt.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.lt.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.lt.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.lt.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.lt.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.lt.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.lt.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.lt.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.lt.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.lt.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.lt.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.lt.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.lt.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.lt.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.lt.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.lt.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.lt.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.lt.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.lt.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.lt.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.lt.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.lt.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.lt.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.lt.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.lt.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.lt.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.lt.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.lt.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.lt.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.lt.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.lt.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.lt.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.lt.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.lt.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.lt.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.lt.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.lt.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.lt.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.lt.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.lt.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.lt.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.lt.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.lt.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.lt.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.lt.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.lt.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.ult.s\n");
   TEST_CMP_S("cmp.ult.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.ult.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.ult.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.ult.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.ult.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.ult.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.ult.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.ult.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.ult.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.ult.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.ult.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.ult.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.ult.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.ult.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.ult.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.ult.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.ult.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.ult.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.ult.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.ult.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.ult.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.ult.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.ult.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.ult.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.ult.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.ult.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.ult.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.ult.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.ult.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.ult.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.ult.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.ult.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.ult.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.ult.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.ult.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.ult.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.ult.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.ult.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.ult.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.ult.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.ult.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.ult.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.ult.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.ult.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.ult.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.ult.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.ult.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.ult.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.ult.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.ult.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.ult.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.ult.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.ult.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.ult.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.ult.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.ult.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.ult.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.ult.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.ult.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.ult.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.ult.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.ult.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.ult.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.ult.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.ult.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.ult.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.ult.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.ult.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.ult.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.ult.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.ult.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.ult.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.ult.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.ult.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.ult.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.ult.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.ult.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.ult.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.ult.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.ult.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.ult.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.ult.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.ult.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.ult.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.ult.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.ult.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.ult.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.ult.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.ult.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.ult.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.ult.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.ult.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.ult.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.ult.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.ult.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.ult.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.ult.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.ult.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.ult.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.ult.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.ult.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.ult.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.ult.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.ult.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.ult.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.ult.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.ult.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.ult.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.ult.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.ult.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.ult.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.ult.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.ult.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.ult.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.ult.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.ult.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.ult.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.ult.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.ult.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.ult.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.ult.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.ult.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.ult.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.ult.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.ult.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.ult.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.ult.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.ult.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.ult.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.ult.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.ult.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.ult.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.ult.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.le.s\n");
   TEST_CMP_S("cmp.le.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.le.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.le.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.le.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.le.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.le.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.le.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.le.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.le.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.le.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.le.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.le.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.le.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.le.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.le.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.le.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.le.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.le.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.le.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.le.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.le.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.le.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.le.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.le.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.le.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.le.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.le.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.le.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.le.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.le.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.le.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.le.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.le.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.le.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.le.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.le.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.le.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.le.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.le.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.le.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.le.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.le.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.le.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.le.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.le.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.le.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.le.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.le.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.le.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.le.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.le.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.le.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.le.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.le.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.le.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.le.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.le.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.le.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.le.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.le.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.le.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.le.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.le.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.le.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.le.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.le.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.le.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.le.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.le.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.le.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.le.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.le.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.le.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.le.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.le.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.le.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.le.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.le.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.le.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.le.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.le.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.le.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.le.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.le.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.le.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.le.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.le.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.le.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.le.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.le.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.le.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.le.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.le.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.le.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.le.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.le.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.le.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.le.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.le.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.le.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.le.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.le.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.le.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.le.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.le.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.le.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.le.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.le.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.le.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.le.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.le.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.le.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.le.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.le.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.le.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.le.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.le.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.le.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.le.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.le.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.le.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.le.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.le.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.le.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.le.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.le.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.le.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.le.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.le.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.le.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.le.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.le.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.le.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.ule.s\n");
   TEST_CMP_S("cmp.ule.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.ule.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.ule.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.ule.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.ule.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.ule.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.ule.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.ule.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.ule.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.ule.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.ule.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.ule.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.ule.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.ule.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.ule.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.ule.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.ule.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.ule.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.ule.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.ule.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.ule.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.ule.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.ule.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.ule.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.ule.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.ule.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.ule.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.ule.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.ule.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.ule.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.ule.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.ule.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.ule.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.ule.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.ule.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.ule.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.ule.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.ule.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.ule.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.ule.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.ule.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.ule.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.ule.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.ule.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.ule.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.ule.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.ule.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.ule.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.ule.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.ule.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.ule.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.ule.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.ule.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.ule.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.ule.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.ule.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.ule.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.ule.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.ule.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.ule.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.ule.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.ule.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.ule.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.ule.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.ule.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.ule.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.ule.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.ule.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.ule.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.ule.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.ule.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.ule.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.ule.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.ule.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.ule.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.ule.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.ule.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.ule.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.ule.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.ule.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.ule.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.ule.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.ule.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.ule.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.ule.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.ule.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.ule.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.ule.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.ule.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.ule.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.ule.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.ule.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.ule.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.ule.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.ule.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.ule.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.ule.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.ule.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.ule.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.ule.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.ule.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.ule.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.ule.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.ule.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.ule.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.ule.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.ule.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.ule.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.ule.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.ule.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.ule.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.ule.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.ule.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.ule.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.ule.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.ule.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.ule.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.ule.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.ule.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.ule.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.ule.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.ule.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.ule.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.ule.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.ule.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.ule.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.ule.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.ule.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.ule.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.ule.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.ule.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.ule.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.ule.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.or.s\n");
   TEST_CMP_S("cmp.or.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.or.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.or.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.or.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.or.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.or.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.or.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.or.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.or.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.or.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.or.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.or.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.or.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.or.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.or.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.or.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.or.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.or.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.or.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.or.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.or.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.or.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.or.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.or.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.or.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.or.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.or.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.or.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.or.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.or.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.or.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.or.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.or.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.or.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.or.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.or.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.or.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.or.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.or.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.or.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.or.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.or.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.or.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.or.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.or.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.or.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.or.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.or.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.or.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.or.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.or.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.or.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.or.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.or.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.or.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.or.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.or.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.or.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.or.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.or.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.or.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.or.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.or.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.or.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.or.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.or.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.or.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.or.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.or.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.or.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.or.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.or.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.or.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.or.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.or.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.or.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.or.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.or.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.or.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.or.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.or.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.or.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.or.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.or.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.or.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.or.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.or.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.or.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.or.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.or.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.or.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.or.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.or.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.or.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.or.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.or.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.or.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.or.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.or.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.or.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.or.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.or.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.or.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.or.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.or.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.or.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.or.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.or.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.or.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.or.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.or.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.or.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.or.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.or.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.or.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.or.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.or.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.or.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.or.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.or.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.or.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.or.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.or.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.or.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.or.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.or.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.or.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.or.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.or.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.or.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.or.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.or.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.or.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.une.s\n");
   TEST_CMP_S("cmp.une.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.une.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.une.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.une.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.une.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.une.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.une.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.une.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.une.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.une.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.une.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.une.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.une.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.une.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.une.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.une.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.une.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.une.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.une.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.une.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.une.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.une.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.une.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.une.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.une.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.une.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.une.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.une.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.une.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.une.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.une.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.une.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.une.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.une.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.une.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.une.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.une.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.une.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.une.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.une.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.une.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.une.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.une.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.une.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.une.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.une.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.une.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.une.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.une.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.une.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.une.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.une.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.une.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.une.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.une.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.une.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.une.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.une.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.une.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.une.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.une.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.une.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.une.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.une.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.une.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.une.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.une.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.une.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.une.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.une.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.une.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.une.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.une.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.une.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.une.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.une.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.une.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.une.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.une.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.une.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.une.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.une.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.une.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.une.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.une.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.une.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.une.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.une.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.une.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.une.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.une.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.une.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.une.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.une.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.une.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.une.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.une.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.une.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.une.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.une.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.une.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.une.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.une.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.une.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.une.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.une.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.une.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.une.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.une.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.une.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.une.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.une.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.une.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.une.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.une.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.une.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.une.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.une.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.une.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.une.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.une.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.une.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.une.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.une.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.une.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.une.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.une.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.une.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.une.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.une.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.une.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.une.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.une.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.ne.s\n");
   TEST_CMP_S("cmp.ne.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.ne.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.ne.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.ne.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.ne.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.ne.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.ne.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.ne.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.ne.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.ne.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.ne.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.ne.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.ne.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.ne.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.ne.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.ne.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.ne.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.ne.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.ne.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.ne.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.ne.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.ne.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.ne.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.ne.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.ne.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.ne.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.ne.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.ne.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.ne.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.ne.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.ne.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.ne.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.ne.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.ne.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.ne.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.ne.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.ne.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.ne.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.ne.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.ne.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.ne.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.ne.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.ne.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.ne.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.ne.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.ne.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.ne.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.ne.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.ne.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.ne.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.ne.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.ne.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.ne.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.ne.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.ne.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.ne.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.ne.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.ne.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.ne.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.ne.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.ne.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.ne.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.ne.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.ne.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.ne.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.ne.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.ne.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.ne.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.ne.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.ne.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.ne.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.ne.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.ne.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.ne.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.ne.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.ne.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.ne.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.ne.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.ne.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.ne.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.ne.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.ne.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.ne.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.ne.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.ne.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.ne.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.ne.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.ne.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.ne.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.ne.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.ne.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.ne.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.ne.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.ne.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.ne.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.ne.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.ne.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.ne.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.ne.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.ne.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.ne.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.ne.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.ne.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.ne.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.ne.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.ne.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.ne.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.ne.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.ne.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.ne.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.ne.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.ne.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.ne.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.ne.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.ne.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.ne.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.ne.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.ne.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.ne.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.ne.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.ne.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.ne.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.ne.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.ne.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.ne.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.ne.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.ne.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.ne.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.ne.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.ne.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.ne.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.ne.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.ne.s", f22, f23, f24, flt[11], flt[11])


   printf("cmp.af.d\n");
   TEST_CMP_D("cmp.af.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.af.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.af.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.af.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.af.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.af.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.af.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.af.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.af.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.af.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.af.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.af.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.af.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.af.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.af.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.af.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.af.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.af.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.af.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.af.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.af.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.af.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.af.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.af.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.af.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.af.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.af.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.af.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.af.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.af.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.af.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.af.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.af.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.af.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.af.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.af.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.af.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.af.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.af.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.af.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.af.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.af.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.af.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.af.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.af.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.af.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.af.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.af.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.af.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.af.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.af.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.af.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.af.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.af.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.af.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.af.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.af.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.af.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.af.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.af.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.af.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.af.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.af.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.af.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.af.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.af.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.af.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.af.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.af.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.af.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.af.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.af.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.af.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.af.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.af.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.af.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.af.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.af.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.af.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.af.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.af.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.af.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.af.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.af.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.af.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.af.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.af.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.af.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.af.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.af.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.af.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.af.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.af.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.af.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.af.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.af.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.af.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.af.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.af.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.af.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.af.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.af.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.af.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.af.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.af.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.af.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.af.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.af.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.af.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.af.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.af.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.af.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.af.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.af.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.af.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.af.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.af.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.af.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.af.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.af.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.af.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.af.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.af.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.af.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.af.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.af.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.af.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.af.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.af.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.af.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.af.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.af.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.af.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.un.d\n");
   TEST_CMP_D("cmp.un.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.un.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.un.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.un.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.un.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.un.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.un.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.un.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.un.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.un.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.un.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.un.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.un.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.un.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.un.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.un.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.un.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.un.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.un.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.un.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.un.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.un.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.un.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.un.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.un.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.un.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.un.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.un.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.un.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.un.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.un.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.un.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.un.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.un.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.un.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.un.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.un.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.un.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.un.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.un.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.un.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.un.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.un.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.un.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.un.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.un.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.un.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.un.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.un.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.un.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.un.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.un.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.un.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.un.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.un.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.un.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.un.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.un.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.un.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.un.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.un.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.un.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.un.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.un.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.un.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.un.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.un.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.un.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.un.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.un.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.un.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.un.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.un.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.un.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.un.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.un.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.un.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.un.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.un.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.un.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.un.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.un.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.un.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.un.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.un.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.un.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.un.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.un.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.un.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.un.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.un.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.un.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.un.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.un.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.un.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.un.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.un.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.un.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.un.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.un.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.un.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.un.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.un.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.un.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.un.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.un.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.un.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.un.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.un.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.un.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.un.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.un.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.un.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.un.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.un.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.un.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.un.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.un.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.un.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.un.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.un.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.un.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.un.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.un.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.un.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.un.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.un.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.un.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.un.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.un.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.un.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.un.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.un.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.eq.d\n");
   TEST_CMP_D("cmp.eq.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.eq.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.eq.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.eq.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.eq.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.eq.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.eq.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.eq.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.eq.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.eq.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.eq.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.eq.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.eq.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.eq.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.eq.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.eq.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.eq.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.eq.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.eq.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.eq.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.eq.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.eq.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.eq.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.eq.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.eq.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.eq.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.eq.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.eq.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.eq.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.eq.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.eq.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.eq.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.eq.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.eq.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.eq.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.eq.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.eq.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.eq.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.eq.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.eq.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.eq.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.eq.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.eq.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.eq.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.eq.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.eq.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.eq.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.eq.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.eq.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.eq.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.eq.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.eq.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.eq.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.eq.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.eq.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.eq.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.eq.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.eq.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.eq.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.eq.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.eq.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.eq.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.eq.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.eq.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.eq.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.eq.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.eq.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.eq.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.eq.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.eq.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.eq.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.eq.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.eq.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.eq.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.eq.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.eq.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.eq.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.eq.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.eq.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.eq.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.eq.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.eq.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.eq.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.eq.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.eq.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.eq.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.eq.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.eq.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.eq.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.eq.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.eq.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.eq.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.eq.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.eq.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.eq.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.eq.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.eq.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.eq.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.eq.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.eq.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.eq.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.eq.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.eq.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.eq.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.eq.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.eq.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.eq.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.eq.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.eq.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.eq.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.eq.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.eq.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.eq.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.eq.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.eq.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.eq.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.eq.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.eq.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.eq.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.eq.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.eq.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.eq.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.eq.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.eq.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.eq.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.eq.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.eq.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.eq.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.eq.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.eq.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.eq.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.eq.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.eq.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.ueq.d\n");
   TEST_CMP_D("cmp.ueq.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.ueq.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.ueq.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.ueq.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.ueq.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.ueq.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.ueq.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.ueq.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.ueq.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.ueq.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.ueq.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.ueq.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.ueq.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.ueq.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.ueq.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.ueq.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.ueq.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.ueq.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.ueq.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.ueq.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.ueq.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.ueq.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.ueq.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.lt.d\n");
   TEST_CMP_D("cmp.lt.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.lt.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.lt.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.lt.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.lt.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.lt.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.lt.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.lt.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.lt.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.lt.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.lt.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.lt.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.lt.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.lt.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.lt.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.lt.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.lt.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.lt.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.lt.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.lt.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.lt.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.lt.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.lt.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.lt.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.lt.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.lt.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.lt.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.lt.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.lt.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.lt.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.lt.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.lt.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.lt.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.lt.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.lt.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.lt.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.lt.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.lt.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.lt.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.lt.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.lt.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.lt.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.lt.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.lt.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.lt.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.lt.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.lt.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.lt.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.lt.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.lt.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.lt.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.lt.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.lt.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.lt.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.lt.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.lt.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.lt.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.lt.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.lt.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.lt.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.lt.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.lt.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.lt.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.lt.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.lt.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.lt.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.lt.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.lt.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.lt.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.lt.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.lt.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.lt.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.lt.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.lt.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.lt.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.lt.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.lt.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.lt.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.lt.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.lt.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.lt.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.lt.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.lt.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.lt.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.lt.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.lt.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.lt.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.lt.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.lt.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.lt.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.lt.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.lt.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.lt.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.lt.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.lt.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.lt.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.lt.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.lt.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.lt.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.lt.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.lt.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.lt.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.lt.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.lt.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.lt.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.lt.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.lt.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.lt.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.lt.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.lt.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.lt.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.lt.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.lt.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.lt.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.lt.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.lt.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.lt.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.lt.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.lt.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.lt.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.lt.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.lt.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.lt.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.lt.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.lt.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.lt.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.lt.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.lt.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.lt.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.lt.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.lt.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.lt.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.lt.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.ult.d\n");
   TEST_CMP_D("cmp.ult.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.ult.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.ult.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.ult.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.ult.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.ult.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.ult.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.ult.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.ult.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.ult.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.ult.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.ult.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.ult.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.ult.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.ult.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.ult.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.ult.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.ult.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.ult.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.ult.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.ult.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.ult.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.ult.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.ult.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.ult.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.ult.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.ult.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.ult.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.ult.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.ult.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.ult.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.ult.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.ult.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.ult.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.ult.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.ult.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.ult.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.ult.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.ult.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.ult.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.ult.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.ult.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.ult.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.ult.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.ult.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.ult.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.ult.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.ult.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.ult.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.ult.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.ult.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.ult.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.ult.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.ult.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.ult.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.ult.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.ult.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.ult.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.ult.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.ult.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.ult.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.ult.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.ult.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.ult.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.ult.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.ult.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.ult.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.ult.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.ult.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.ult.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.ult.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.ult.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.ult.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.ult.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.ult.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.ult.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.ult.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.ult.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.ult.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.ult.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.ult.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.ult.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.ult.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.ult.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.ult.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.ult.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.ult.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.ult.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.ult.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.ult.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.ult.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.ult.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.ult.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.ult.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.ult.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.ult.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.ult.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.ult.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.ult.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.ult.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.ult.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.ult.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.ult.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.ult.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.ult.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.ult.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.ult.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.ult.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.ult.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.ult.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.ult.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.ult.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.ult.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.ult.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.ult.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.ult.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.ult.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.ult.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.ult.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.ult.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.ult.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.ult.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.ult.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.ult.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.ult.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.ult.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.ult.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.ult.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.ult.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.ult.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.ult.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.ult.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.ult.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.le.d\n");
   TEST_CMP_D("cmp.le.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.le.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.le.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.le.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.le.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.le.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.le.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.le.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.le.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.le.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.le.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.le.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.le.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.le.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.le.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.le.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.le.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.le.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.le.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.le.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.le.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.le.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.le.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.le.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.le.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.le.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.le.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.le.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.le.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.le.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.le.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.le.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.le.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.le.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.le.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.le.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.le.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.le.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.le.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.le.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.le.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.le.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.le.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.le.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.le.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.le.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.le.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.le.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.le.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.le.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.le.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.le.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.le.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.le.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.le.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.le.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.le.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.le.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.le.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.le.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.le.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.le.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.le.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.le.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.le.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.le.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.le.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.le.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.le.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.le.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.le.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.le.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.le.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.le.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.le.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.le.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.le.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.le.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.le.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.le.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.le.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.le.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.le.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.le.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.le.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.le.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.le.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.le.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.le.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.le.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.le.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.le.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.le.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.le.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.le.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.le.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.le.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.le.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.le.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.le.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.le.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.le.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.le.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.le.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.le.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.le.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.le.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.le.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.le.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.le.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.le.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.le.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.le.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.le.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.le.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.le.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.le.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.le.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.le.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.le.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.le.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.le.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.le.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.le.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.le.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.le.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.le.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.le.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.le.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.le.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.le.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.le.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.le.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.ule.d\n");
   TEST_CMP_D("cmp.ule.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.ule.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.ule.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.ule.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.ule.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.ule.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.ule.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.ule.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.ule.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.ule.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.ule.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.ule.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.ule.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.ule.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.ule.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.ule.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.ule.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.ule.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.ule.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.ule.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.ule.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.ule.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.ule.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.ule.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.ule.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.ule.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.ule.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.ule.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.ule.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.ule.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.ule.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.ule.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.ule.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.ule.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.ule.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.ule.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.ule.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.ule.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.ule.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.ule.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.ule.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.ule.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.ule.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.ule.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.ule.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.ule.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.ule.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.ule.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.ule.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.ule.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.ule.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.ule.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.ule.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.ule.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.ule.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.ule.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.ule.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.ule.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.ule.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.ule.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.ule.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.ule.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.ule.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.ule.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.ule.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.ule.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.ule.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.ule.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.ule.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.ule.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.ule.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.ule.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.ule.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.ule.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.ule.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.ule.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.ule.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.ule.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.ule.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.ule.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.ule.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.ule.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.ule.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.ule.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.ule.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.ule.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.ule.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.ule.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.ule.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.ule.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.ule.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.ule.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.ule.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.ule.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.ule.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.ule.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.ule.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.ule.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.ule.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.ule.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.ule.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.ule.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.ule.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.ule.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.ule.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.ule.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.ule.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.ule.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.ule.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.ule.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.ule.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.ule.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.ule.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.ule.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.ule.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.ule.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.ule.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.ule.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.ule.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.ule.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.ule.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.ule.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.ule.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.ule.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.ule.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.ule.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.ule.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.ule.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.ule.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.ule.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.ule.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.ule.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.ule.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.or.d\n");
   TEST_CMP_D("cmp.or.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.or.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.or.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.or.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.or.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.or.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.or.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.or.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.or.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.or.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.or.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.or.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.or.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.or.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.or.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.or.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.or.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.or.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.or.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.or.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.or.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.or.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.or.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.or.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.or.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.or.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.or.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.or.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.or.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.or.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.or.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.or.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.or.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.or.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.or.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.or.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.or.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.or.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.or.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.or.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.or.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.or.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.or.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.or.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.or.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.or.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.or.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.or.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.or.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.or.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.or.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.or.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.or.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.or.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.or.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.or.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.or.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.or.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.or.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.or.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.or.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.or.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.or.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.or.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.or.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.or.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.or.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.or.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.or.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.or.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.or.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.or.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.or.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.or.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.or.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.or.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.or.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.or.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.or.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.or.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.or.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.or.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.or.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.or.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.or.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.or.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.or.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.or.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.or.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.or.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.or.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.or.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.or.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.or.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.or.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.or.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.or.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.or.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.or.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.or.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.or.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.or.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.or.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.or.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.or.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.or.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.or.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.or.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.or.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.or.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.or.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.or.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.or.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.or.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.or.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.or.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.or.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.or.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.or.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.or.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.or.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.or.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.or.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.or.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.or.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.or.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.or.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.or.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.or.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.or.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.or.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.or.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.or.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.une.d\n");
   TEST_CMP_D("cmp.une.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.une.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.une.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.une.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.une.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.une.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.une.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.une.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.une.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.une.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.une.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.une.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.une.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.une.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.une.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.une.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.une.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.une.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.une.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.une.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.une.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.une.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.une.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.une.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.une.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.une.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.une.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.une.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.une.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.une.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.une.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.une.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.une.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.une.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.une.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.une.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.une.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.une.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.une.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.une.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.une.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.une.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.une.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.une.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.une.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.une.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.une.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.une.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.une.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.une.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.une.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.une.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.une.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.une.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.une.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.une.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.une.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.une.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.une.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.une.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.une.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.une.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.une.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.une.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.une.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.une.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.une.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.une.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.une.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.une.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.une.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.une.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.une.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.une.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.une.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.une.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.une.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.une.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.une.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.une.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.une.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.une.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.une.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.une.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.une.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.une.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.une.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.une.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.une.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.une.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.une.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.une.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.une.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.une.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.une.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.une.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.une.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.une.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.une.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.une.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.une.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.une.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.une.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.une.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.une.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.une.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.une.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.une.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.une.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.une.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.une.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.une.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.une.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.une.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.une.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.une.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.une.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.une.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.une.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.une.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.une.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.une.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.une.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.une.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.une.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.une.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.une.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.une.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.une.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.une.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.une.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.une.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.une.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.ne.d\n");
   TEST_CMP_D("cmp.ne.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.ne.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.ne.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.ne.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.ne.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.ne.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.ne.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.ne.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.ne.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.ne.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.ne.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.ne.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.ne.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.ne.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.ne.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.ne.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.ne.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.ne.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.ne.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.ne.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.ne.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.ne.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.ne.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.ne.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.ne.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.ne.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.ne.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.ne.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.ne.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.ne.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.ne.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.ne.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.ne.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.ne.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.ne.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.ne.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.ne.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.ne.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.ne.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.ne.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.ne.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.ne.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.ne.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.ne.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.ne.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.ne.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.ne.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.ne.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.ne.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.ne.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.ne.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.ne.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.ne.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.ne.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.ne.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.ne.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.ne.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.ne.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.ne.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.ne.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.ne.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.ne.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.ne.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.ne.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.ne.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.ne.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.ne.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.ne.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.ne.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.ne.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.ne.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.ne.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.ne.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.ne.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.ne.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.ne.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.ne.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.ne.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.ne.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.ne.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.ne.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.ne.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.ne.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.ne.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.ne.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.ne.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.ne.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.ne.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.ne.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.ne.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.ne.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.ne.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.ne.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.ne.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.ne.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.ne.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.ne.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.ne.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.ne.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.ne.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.ne.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.ne.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.ne.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.ne.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.ne.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.ne.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.ne.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.ne.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.ne.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.ne.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.ne.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.ne.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.ne.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.ne.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.ne.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.ne.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.ne.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.ne.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.ne.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.ne.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.ne.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.ne.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.ne.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.ne.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.ne.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.ne.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.ne.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.ne.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.ne.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.ne.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.ne.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.ne.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.ne.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.saf.s\n");
   TEST_CMP_S("cmp.saf.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.saf.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.saf.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.saf.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.saf.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.saf.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.saf.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.saf.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.saf.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.saf.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.saf.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.saf.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.saf.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.saf.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.saf.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.saf.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.saf.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.saf.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.saf.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.saf.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.saf.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.saf.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.saf.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.saf.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.saf.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.saf.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.saf.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.saf.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.saf.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.saf.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.saf.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.saf.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.saf.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.saf.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.saf.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.saf.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.saf.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.saf.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.saf.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.saf.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.saf.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.saf.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.saf.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.saf.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.saf.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.saf.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.saf.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.saf.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.saf.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.saf.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.saf.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.saf.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.saf.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.saf.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.saf.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.saf.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.saf.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.saf.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.saf.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.saf.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.saf.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.saf.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.saf.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.saf.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.saf.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.saf.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.saf.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.saf.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.saf.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.saf.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.saf.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.saf.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.saf.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.saf.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.saf.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.saf.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.saf.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.saf.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.saf.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.saf.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.saf.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.saf.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.saf.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.saf.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.saf.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.saf.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.saf.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.saf.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.saf.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.saf.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.saf.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.saf.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.saf.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.saf.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.saf.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.saf.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.saf.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.saf.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.saf.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.saf.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.saf.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.saf.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.saf.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.saf.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.saf.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.saf.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.saf.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.saf.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.saf.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.saf.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.saf.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.saf.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.saf.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.saf.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.saf.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.saf.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.saf.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.saf.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.saf.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.saf.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.saf.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.saf.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.saf.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.saf.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.saf.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.saf.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.saf.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.saf.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.saf.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.saf.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.saf.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.saf.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.saf.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.sun.s\n");
   TEST_CMP_S("cmp.sun.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.sun.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.sun.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.sun.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.sun.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.sun.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.sun.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.sun.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.sun.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.sun.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.sun.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.sun.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.sun.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.sun.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.sun.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.sun.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.sun.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.sun.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.sun.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.sun.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.sun.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.sun.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.sun.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.sun.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.sun.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.sun.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.sun.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.sun.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.sun.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.sun.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.sun.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.sun.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.sun.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.sun.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.sun.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.sun.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.sun.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.sun.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.sun.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.sun.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.sun.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.sun.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.sun.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.sun.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.sun.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.sun.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.sun.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.sun.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.sun.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.sun.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.sun.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.sun.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.sun.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.sun.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.sun.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.sun.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.sun.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.sun.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.sun.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.sun.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.sun.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.sun.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.sun.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.sun.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.sun.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.sun.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.sun.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.sun.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.sun.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.sun.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.sun.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.sun.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.sun.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.sun.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.sun.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.sun.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.sun.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.sun.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.sun.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.sun.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.sun.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.sun.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.sun.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.sun.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.sun.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.sun.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.sun.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.sun.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.sun.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.sun.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.sun.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.sun.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.sun.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.sun.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.sun.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.sun.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.sun.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.sun.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.sun.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.sun.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.sun.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.sun.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.sun.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.sun.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.sun.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.sun.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.sun.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.sun.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.sun.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.sun.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.sun.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.sun.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.sun.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.sun.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.sun.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.sun.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.sun.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.sun.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.sun.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.sun.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.sun.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.sun.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.sun.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.sun.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.sun.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.sun.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.sun.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.sun.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.sun.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.sun.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.sun.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.sun.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.sun.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.seq.s\n");
   TEST_CMP_S("cmp.seq.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.seq.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.seq.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.seq.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.seq.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.seq.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.seq.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.seq.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.seq.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.seq.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.seq.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.seq.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.seq.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.seq.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.seq.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.seq.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.seq.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.seq.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.seq.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.seq.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.seq.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.seq.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.seq.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.seq.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.seq.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.seq.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.seq.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.seq.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.seq.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.seq.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.seq.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.seq.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.seq.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.seq.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.seq.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.seq.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.seq.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.seq.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.seq.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.seq.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.seq.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.seq.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.seq.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.seq.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.seq.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.seq.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.seq.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.seq.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.seq.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.seq.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.seq.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.seq.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.seq.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.seq.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.seq.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.seq.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.seq.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.seq.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.seq.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.seq.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.seq.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.seq.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.seq.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.seq.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.seq.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.seq.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.seq.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.seq.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.seq.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.seq.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.seq.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.seq.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.seq.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.seq.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.seq.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.seq.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.seq.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.seq.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.seq.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.seq.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.seq.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.seq.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.seq.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.seq.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.seq.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.seq.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.seq.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.seq.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.seq.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.seq.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.seq.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.seq.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.seq.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.seq.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.seq.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.seq.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.seq.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.seq.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.seq.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.seq.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.seq.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.seq.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.seq.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.seq.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.seq.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.seq.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.seq.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.seq.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.seq.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.seq.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.seq.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.seq.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.seq.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.seq.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.seq.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.seq.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.seq.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.seq.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.seq.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.seq.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.seq.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.seq.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.seq.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.seq.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.seq.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.seq.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.seq.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.seq.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.seq.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.seq.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.seq.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.seq.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.seq.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.sueq.s\n");
   TEST_CMP_S("cmp.sueq.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.sueq.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.sueq.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.sueq.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.sueq.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.sueq.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.sueq.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.sueq.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.sueq.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.sueq.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.sueq.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.sueq.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.sueq.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.sueq.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.sueq.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.sueq.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.sueq.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.sueq.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.sueq.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.sueq.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.sueq.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.sueq.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.sueq.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.sueq.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.sueq.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.sueq.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.sueq.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.sueq.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.sueq.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.sueq.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.sueq.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.sueq.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.sueq.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.sueq.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.sueq.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.sueq.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.sueq.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.sueq.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.sueq.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.sueq.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.sueq.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.sueq.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.sueq.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.sueq.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.sueq.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.sueq.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.sueq.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.sueq.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.sueq.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.sueq.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.sueq.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.sueq.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.sueq.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.sueq.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.sueq.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.sueq.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.sueq.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.sueq.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.sueq.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.sueq.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.sueq.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.sueq.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.sueq.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.sueq.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.sueq.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.sueq.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.sueq.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.sueq.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.sueq.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.sueq.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.sueq.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.sueq.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.sueq.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.sueq.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.sueq.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.sueq.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.sueq.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.sueq.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.sueq.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.sueq.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.sueq.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.sueq.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.sueq.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.sueq.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.sueq.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.sueq.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.sueq.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.sueq.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.sueq.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.sueq.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.sueq.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.sueq.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.sueq.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.sueq.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.sueq.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.sueq.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.sueq.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.sueq.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.sueq.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.sueq.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.sueq.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.sueq.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.sueq.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.sueq.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.sueq.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.sueq.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.sueq.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.sueq.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.sueq.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.sueq.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.sueq.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.sueq.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.sueq.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.sueq.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.sueq.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.sueq.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.sueq.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.sueq.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.sueq.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.sueq.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.sueq.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.sueq.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.sueq.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.sueq.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.sueq.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.sueq.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.sueq.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.sueq.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.sueq.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.sueq.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.sueq.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.sueq.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.sueq.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.slt.s\n");
   TEST_CMP_S("cmp.slt.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.slt.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.slt.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.slt.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.slt.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.slt.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.slt.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.slt.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.slt.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.slt.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.slt.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.slt.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.slt.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.slt.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.slt.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.slt.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.slt.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.slt.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.slt.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.slt.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.slt.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.slt.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.slt.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.slt.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.slt.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.slt.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.slt.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.slt.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.slt.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.slt.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.slt.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.slt.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.slt.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.slt.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.slt.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.slt.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.slt.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.slt.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.slt.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.slt.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.slt.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.slt.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.slt.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.slt.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.slt.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.slt.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.slt.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.slt.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.slt.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.slt.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.slt.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.slt.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.slt.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.slt.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.slt.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.slt.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.slt.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.slt.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.slt.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.slt.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.slt.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.slt.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.slt.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.slt.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.slt.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.slt.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.slt.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.slt.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.slt.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.slt.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.slt.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.slt.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.slt.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.slt.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.slt.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.slt.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.slt.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.slt.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.slt.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.slt.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.slt.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.slt.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.slt.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.slt.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.slt.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.slt.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.slt.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.slt.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.slt.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.slt.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.slt.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.slt.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.slt.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.slt.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.slt.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.slt.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.slt.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.slt.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.slt.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.slt.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.slt.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.slt.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.slt.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.slt.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.slt.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.slt.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.slt.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.slt.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.slt.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.slt.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.slt.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.slt.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.slt.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.slt.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.slt.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.slt.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.slt.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.slt.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.slt.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.slt.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.slt.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.slt.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.slt.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.slt.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.slt.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.slt.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.slt.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.slt.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.slt.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.slt.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.slt.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.slt.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.slt.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.sult.s\n");
   TEST_CMP_S("cmp.sult.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.sult.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.sult.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.sult.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.sult.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.sult.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.sult.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.sult.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.sult.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.sult.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.sult.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.sult.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.sult.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.sult.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.sult.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.sult.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.sult.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.sult.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.sult.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.sult.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.sult.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.sult.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.sult.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.sult.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.sult.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.sult.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.sult.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.sult.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.sult.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.sult.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.sult.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.sult.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.sult.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.sult.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.sult.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.sult.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.sult.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.sult.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.sult.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.sult.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.sult.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.sult.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.sult.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.sult.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.sult.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.sult.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.sult.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.sult.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.sult.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.sult.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.sult.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.sult.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.sult.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.sult.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.sult.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.sult.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.sult.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.sult.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.sult.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.sult.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.sult.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.sult.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.sult.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.sult.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.sult.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.sult.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.sult.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.sult.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.sult.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.sult.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.sult.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.sult.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.sult.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.sult.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.sult.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.sult.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.sult.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.sult.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.sult.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.sult.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.sult.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.sult.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.sult.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.sult.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.sult.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.sult.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.sult.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.sult.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.sult.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.sult.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.sult.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.sult.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.sult.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.sult.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.sult.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.sult.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.sult.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.sult.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.sult.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.sult.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.sult.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.sult.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.sult.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.sult.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.sult.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.sult.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.sult.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.sult.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.sult.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.sult.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.sult.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.sult.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.sult.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.sult.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.sult.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.sult.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.sult.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.sult.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.sult.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.sult.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.sult.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.sult.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.sult.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.sult.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.sult.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.sult.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.sult.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.sult.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.sult.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.sult.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.sult.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.sult.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.sult.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.sle.s\n");
   TEST_CMP_S("cmp.sle.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.sle.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.sle.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.sle.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.sle.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.sle.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.sle.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.sle.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.sle.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.sle.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.sle.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.sle.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.sle.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.sle.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.sle.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.sle.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.sle.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.sle.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.sle.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.sle.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.sle.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.sle.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.sle.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.sle.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.sle.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.sle.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.sle.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.sle.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.sle.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.sle.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.sle.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.sle.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.sle.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.sle.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.sle.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.sle.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.sle.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.sle.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.sle.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.sle.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.sle.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.sle.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.sle.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.sle.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.sle.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.sle.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.sle.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.sle.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.sle.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.sle.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.sle.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.sle.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.sle.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.sle.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.sle.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.sle.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.sle.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.sle.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.sle.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.sle.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.sle.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.sle.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.sle.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.sle.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.sle.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.sle.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.sle.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.sle.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.sle.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.sle.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.sle.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.sle.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.sle.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.sle.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.sle.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.sle.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.sle.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.sle.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.sle.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.sle.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.sle.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.sle.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.sle.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.sle.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.sle.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.sle.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.sle.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.sle.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.sle.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.sle.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.sle.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.sle.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.sle.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.sle.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.sle.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.sle.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.sle.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.sle.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.sle.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.sle.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.sle.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.sle.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.sle.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.sle.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.sle.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.sle.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.sle.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.sle.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.sle.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.sle.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.sle.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.sle.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.sle.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.sle.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.sle.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.sle.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.sle.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.sle.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.sle.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.sle.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.sle.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.sle.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.sle.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.sle.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.sle.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.sle.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.sle.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.sle.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.sle.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.sle.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.sle.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.sle.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.sle.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.sule.s\n");
   TEST_CMP_S("cmp.sule.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.sule.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.sule.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.sule.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.sule.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.sule.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.sule.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.sule.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.sule.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.sule.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.sule.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.sule.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.sule.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.sule.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.sule.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.sule.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.sule.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.sule.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.sule.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.sule.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.sule.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.sule.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.sule.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.sule.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.sule.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.sule.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.sule.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.sule.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.sule.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.sule.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.sule.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.sule.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.sule.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.sule.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.sule.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.sule.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.sule.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.sule.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.sule.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.sule.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.sule.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.sule.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.sule.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.sule.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.sule.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.sule.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.sule.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.sule.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.sule.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.sule.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.sule.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.sule.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.sule.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.sule.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.sule.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.sule.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.sule.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.sule.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.sule.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.sule.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.sule.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.sule.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.sule.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.sule.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.sule.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.sule.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.sule.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.sule.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.sule.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.sule.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.sule.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.sule.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.sule.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.sule.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.sule.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.sule.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.sule.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.sule.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.sule.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.sule.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.sule.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.sule.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.sule.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.sule.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.sule.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.sule.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.sule.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.sule.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.sule.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.sule.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.sule.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.sule.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.sule.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.sule.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.sule.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.sule.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.sule.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.sule.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.sule.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.sule.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.sule.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.sule.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.sule.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.sule.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.sule.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.sule.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.sule.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.sule.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.sule.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.sule.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.sule.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.sule.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.sule.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.sule.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.sule.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.sule.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.sule.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.sule.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.sule.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.sule.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.sule.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.sule.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.sule.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.sule.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.sule.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.sule.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.sule.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.sule.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.sule.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.sule.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.sule.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.sule.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.sule.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.sor.s\n");
   TEST_CMP_S("cmp.sor.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.sor.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.sor.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.sor.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.sor.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.sor.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.sor.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.sor.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.sor.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.sor.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.sor.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.sor.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.sor.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.sor.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.sor.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.sor.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.sor.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.sor.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.sor.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.sor.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.sor.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.sor.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.sor.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.sor.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.sor.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.sor.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.sor.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.sor.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.sor.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.sor.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.sor.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.sor.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.sor.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.sor.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.sor.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.sor.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.sor.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.sor.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.sor.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.sor.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.sor.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.sor.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.sor.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.sor.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.sor.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.sor.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.sor.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.sor.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.sor.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.sor.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.sor.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.sor.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.sor.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.sor.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.sor.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.sor.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.sor.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.sor.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.sor.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.sor.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.sor.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.sor.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.sor.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.sor.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.sor.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.sor.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.sor.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.sor.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.sor.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.sor.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.sor.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.sor.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.sor.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.sor.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.sor.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.sor.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.sor.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.sor.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.sor.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.sor.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.sor.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.sor.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.sor.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.sor.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.sor.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.sor.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.sor.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.sor.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.sor.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.sor.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.sor.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.sor.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.sor.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.sor.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.sor.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.sor.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.sor.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.sor.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.sor.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.sor.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.sor.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.sor.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.sor.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.sor.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.sor.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.sor.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.sor.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.sor.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.sor.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.sor.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.sor.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.sor.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.sor.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.sor.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.sor.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.sor.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.sor.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.sor.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.sor.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.sor.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.sor.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.sor.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.sor.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.sor.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.sor.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.sor.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.sor.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.sor.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.sor.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.sor.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.sor.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.sor.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.sor.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.sune.s\n");
   TEST_CMP_S("cmp.sune.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.sune.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.sune.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.sune.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.sune.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.sune.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.sune.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.sune.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.sune.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.sune.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.sune.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.sune.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.sune.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.sune.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.sune.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.sune.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.sune.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.sune.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.sune.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.sune.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.sune.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.sune.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.sune.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.sune.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.sune.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.sune.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.sune.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.sune.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.sune.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.sune.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.sune.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.sune.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.sune.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.sune.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.sune.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.sune.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.sune.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.sune.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.sune.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.sune.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.sune.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.sune.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.sune.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.sune.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.sune.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.sune.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.sune.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.sune.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.sune.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.sune.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.sune.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.sune.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.sune.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.sune.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.sune.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.sune.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.sune.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.sune.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.sune.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.sune.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.sune.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.sune.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.sune.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.sune.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.sune.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.sune.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.sune.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.sune.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.sune.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.sune.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.sune.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.sune.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.sune.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.sune.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.sune.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.sune.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.sune.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.sune.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.sune.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.sune.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.sune.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.sune.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.sune.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.sune.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.sune.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.sune.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.sune.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.sune.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.sune.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.sune.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.sune.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.sune.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.sune.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.sune.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.sune.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.sune.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.sune.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.sune.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.sune.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.sune.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.sune.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.sune.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.sune.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.sune.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.sune.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.sune.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.sune.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.sune.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.sune.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.sune.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.sune.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.sune.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.sune.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.sune.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.sune.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.sune.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.sune.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.sune.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.sune.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.sune.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.sune.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.sune.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.sune.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.sune.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.sune.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.sune.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.sune.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.sune.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.sune.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.sune.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.sune.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.sune.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.sune.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.sne.s\n");
   TEST_CMP_S("cmp.sne.s", f0, f1, f2, flt[0], flt[0])
   TEST_CMP_S("cmp.sne.s", f1, f2, f3, flt[0], flt[1])
   TEST_CMP_S("cmp.sne.s", f2, f3, f4, flt[0], flt[2])
   TEST_CMP_S("cmp.sne.s", f3, f4, f5, flt[0], flt[3])
   TEST_CMP_S("cmp.sne.s", f4, f5, f6, flt[0], flt[4])
   TEST_CMP_S("cmp.sne.s", f5, f6, f7, flt[0], flt[5])
   TEST_CMP_S("cmp.sne.s", f6, f7, f8, flt[0], flt[6])
   TEST_CMP_S("cmp.sne.s", f7, f8, f9, flt[0], flt[7])
   TEST_CMP_S("cmp.sne.s", f8, f9, f10, flt[0], flt[8])
   TEST_CMP_S("cmp.sne.s", f9, f10, f11, flt[0], flt[9])
   TEST_CMP_S("cmp.sne.s", f10, f11, f12, flt[0], flt[10])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[0], flt[11])
   TEST_CMP_S("cmp.sne.s", f1, f2, f3, flt[1], flt[0])
   TEST_CMP_S("cmp.sne.s", f2, f3, f4, flt[1], flt[1])
   TEST_CMP_S("cmp.sne.s", f3, f4, f5, flt[1], flt[2])
   TEST_CMP_S("cmp.sne.s", f4, f5, f6, flt[1], flt[3])
   TEST_CMP_S("cmp.sne.s", f5, f6, f7, flt[1], flt[4])
   TEST_CMP_S("cmp.sne.s", f6, f7, f8, flt[1], flt[5])
   TEST_CMP_S("cmp.sne.s", f7, f8, f9, flt[1], flt[6])
   TEST_CMP_S("cmp.sne.s", f8, f9, f10, flt[1], flt[7])
   TEST_CMP_S("cmp.sne.s", f9, f10, f11, flt[1], flt[8])
   TEST_CMP_S("cmp.sne.s", f10, f11, f12, flt[1], flt[9])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[1], flt[10])
   TEST_CMP_S("cmp.sne.s", f12, f13, f14, flt[1], flt[11])
   TEST_CMP_S("cmp.sne.s", f2, f3, f4, flt[2], flt[0])
   TEST_CMP_S("cmp.sne.s", f3, f4, f5, flt[2], flt[1])
   TEST_CMP_S("cmp.sne.s", f4, f5, f6, flt[2], flt[2])
   TEST_CMP_S("cmp.sne.s", f5, f6, f7, flt[2], flt[3])
   TEST_CMP_S("cmp.sne.s", f6, f7, f8, flt[2], flt[4])
   TEST_CMP_S("cmp.sne.s", f7, f8, f9, flt[2], flt[5])
   TEST_CMP_S("cmp.sne.s", f8, f9, f10, flt[2], flt[6])
   TEST_CMP_S("cmp.sne.s", f9, f10, f11, flt[2], flt[7])
   TEST_CMP_S("cmp.sne.s", f10, f11, f12, flt[2], flt[8])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[2], flt[9])
   TEST_CMP_S("cmp.sne.s", f12, f13, f14, flt[2], flt[10])
   TEST_CMP_S("cmp.sne.s", f13, f14, f15, flt[2], flt[11])
   TEST_CMP_S("cmp.sne.s", f3, f4, f5, flt[3], flt[0])
   TEST_CMP_S("cmp.sne.s", f4, f5, f6, flt[3], flt[1])
   TEST_CMP_S("cmp.sne.s", f5, f6, f7, flt[3], flt[2])
   TEST_CMP_S("cmp.sne.s", f6, f7, f8, flt[3], flt[3])
   TEST_CMP_S("cmp.sne.s", f7, f8, f9, flt[3], flt[4])
   TEST_CMP_S("cmp.sne.s", f8, f9, f10, flt[3], flt[5])
   TEST_CMP_S("cmp.sne.s", f9, f10, f11, flt[3], flt[6])
   TEST_CMP_S("cmp.sne.s", f10, f11, f12, flt[3], flt[7])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[3], flt[8])
   TEST_CMP_S("cmp.sne.s", f12, f13, f14, flt[3], flt[9])
   TEST_CMP_S("cmp.sne.s", f13, f14, f15, flt[3], flt[10])
   TEST_CMP_S("cmp.sne.s", f14, f15, f16, flt[3], flt[11])
   TEST_CMP_S("cmp.sne.s", f4, f5, f6, flt[4], flt[0])
   TEST_CMP_S("cmp.sne.s", f5, f6, f7, flt[4], flt[1])
   TEST_CMP_S("cmp.sne.s", f6, f7, f8, flt[4], flt[2])
   TEST_CMP_S("cmp.sne.s", f7, f8, f9, flt[4], flt[3])
   TEST_CMP_S("cmp.sne.s", f8, f9, f10, flt[4], flt[4])
   TEST_CMP_S("cmp.sne.s", f9, f10, f11, flt[4], flt[5])
   TEST_CMP_S("cmp.sne.s", f10, f11, f12, flt[4], flt[6])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[4], flt[7])
   TEST_CMP_S("cmp.sne.s", f12, f13, f14, flt[4], flt[8])
   TEST_CMP_S("cmp.sne.s", f13, f14, f15, flt[4], flt[9])
   TEST_CMP_S("cmp.sne.s", f14, f15, f16, flt[4], flt[10])
   TEST_CMP_S("cmp.sne.s", f15, f16, f17, flt[4], flt[11])
   TEST_CMP_S("cmp.sne.s", f5, f6, f7, flt[5], flt[0])
   TEST_CMP_S("cmp.sne.s", f6, f7, f8, flt[5], flt[1])
   TEST_CMP_S("cmp.sne.s", f7, f8, f9, flt[5], flt[2])
   TEST_CMP_S("cmp.sne.s", f8, f9, f10, flt[5], flt[3])
   TEST_CMP_S("cmp.sne.s", f9, f10, f11, flt[5], flt[4])
   TEST_CMP_S("cmp.sne.s", f10, f11, f12, flt[5], flt[5])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[5], flt[6])
   TEST_CMP_S("cmp.sne.s", f12, f13, f14, flt[5], flt[7])
   TEST_CMP_S("cmp.sne.s", f13, f14, f15, flt[5], flt[8])
   TEST_CMP_S("cmp.sne.s", f14, f15, f16, flt[5], flt[9])
   TEST_CMP_S("cmp.sne.s", f15, f16, f17, flt[5], flt[10])
   TEST_CMP_S("cmp.sne.s", f16, f17, f18, flt[5], flt[11])
   TEST_CMP_S("cmp.sne.s", f6, f7, f8, flt[6], flt[0])
   TEST_CMP_S("cmp.sne.s", f7, f8, f9, flt[6], flt[1])
   TEST_CMP_S("cmp.sne.s", f8, f9, f10, flt[6], flt[2])
   TEST_CMP_S("cmp.sne.s", f9, f10, f11, flt[6], flt[3])
   TEST_CMP_S("cmp.sne.s", f10, f11, f12, flt[6], flt[4])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[6], flt[5])
   TEST_CMP_S("cmp.sne.s", f12, f13, f14, flt[6], flt[6])
   TEST_CMP_S("cmp.sne.s", f13, f14, f15, flt[6], flt[7])
   TEST_CMP_S("cmp.sne.s", f14, f15, f16, flt[6], flt[8])
   TEST_CMP_S("cmp.sne.s", f15, f16, f17, flt[6], flt[9])
   TEST_CMP_S("cmp.sne.s", f16, f17, f18, flt[6], flt[10])
   TEST_CMP_S("cmp.sne.s", f17, f18, f19, flt[6], flt[11])
   TEST_CMP_S("cmp.sne.s", f7, f8, f9, flt[7], flt[0])
   TEST_CMP_S("cmp.sne.s", f8, f9, f10, flt[7], flt[1])
   TEST_CMP_S("cmp.sne.s", f9, f10, f11, flt[7], flt[2])
   TEST_CMP_S("cmp.sne.s", f10, f11, f12, flt[7], flt[3])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[7], flt[4])
   TEST_CMP_S("cmp.sne.s", f12, f13, f14, flt[7], flt[5])
   TEST_CMP_S("cmp.sne.s", f13, f14, f15, flt[7], flt[6])
   TEST_CMP_S("cmp.sne.s", f14, f15, f16, flt[7], flt[7])
   TEST_CMP_S("cmp.sne.s", f15, f16, f17, flt[7], flt[8])
   TEST_CMP_S("cmp.sne.s", f16, f17, f18, flt[7], flt[9])
   TEST_CMP_S("cmp.sne.s", f17, f18, f19, flt[7], flt[10])
   TEST_CMP_S("cmp.sne.s", f18, f19, f20, flt[7], flt[11])
   TEST_CMP_S("cmp.sne.s", f8, f9, f10, flt[8], flt[0])
   TEST_CMP_S("cmp.sne.s", f9, f10, f11, flt[8], flt[1])
   TEST_CMP_S("cmp.sne.s", f10, f11, f12, flt[8], flt[2])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[8], flt[3])
   TEST_CMP_S("cmp.sne.s", f12, f13, f14, flt[8], flt[4])
   TEST_CMP_S("cmp.sne.s", f13, f14, f15, flt[8], flt[5])
   TEST_CMP_S("cmp.sne.s", f14, f15, f16, flt[8], flt[6])
   TEST_CMP_S("cmp.sne.s", f15, f16, f17, flt[8], flt[7])
   TEST_CMP_S("cmp.sne.s", f16, f17, f18, flt[8], flt[8])
   TEST_CMP_S("cmp.sne.s", f17, f18, f19, flt[8], flt[9])
   TEST_CMP_S("cmp.sne.s", f18, f19, f20, flt[8], flt[10])
   TEST_CMP_S("cmp.sne.s", f19, f20, f21, flt[8], flt[11])
   TEST_CMP_S("cmp.sne.s", f9, f10, f11, flt[9], flt[0])
   TEST_CMP_S("cmp.sne.s", f10, f11, f12, flt[9], flt[1])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[9], flt[2])
   TEST_CMP_S("cmp.sne.s", f12, f13, f14, flt[9], flt[3])
   TEST_CMP_S("cmp.sne.s", f13, f14, f15, flt[9], flt[4])
   TEST_CMP_S("cmp.sne.s", f14, f15, f16, flt[9], flt[5])
   TEST_CMP_S("cmp.sne.s", f15, f16, f17, flt[9], flt[6])
   TEST_CMP_S("cmp.sne.s", f16, f17, f18, flt[9], flt[7])
   TEST_CMP_S("cmp.sne.s", f17, f18, f19, flt[9], flt[8])
   TEST_CMP_S("cmp.sne.s", f18, f19, f20, flt[9], flt[9])
   TEST_CMP_S("cmp.sne.s", f19, f20, f21, flt[9], flt[10])
   TEST_CMP_S("cmp.sne.s", f20, f21, f22, flt[9], flt[11])
   TEST_CMP_S("cmp.sne.s", f10, f11, f12, flt[10], flt[0])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[10], flt[1])
   TEST_CMP_S("cmp.sne.s", f12, f13, f14, flt[10], flt[2])
   TEST_CMP_S("cmp.sne.s", f13, f14, f15, flt[10], flt[3])
   TEST_CMP_S("cmp.sne.s", f14, f15, f16, flt[10], flt[4])
   TEST_CMP_S("cmp.sne.s", f15, f16, f17, flt[10], flt[5])
   TEST_CMP_S("cmp.sne.s", f16, f17, f18, flt[10], flt[6])
   TEST_CMP_S("cmp.sne.s", f17, f18, f19, flt[10], flt[7])
   TEST_CMP_S("cmp.sne.s", f18, f19, f20, flt[10], flt[8])
   TEST_CMP_S("cmp.sne.s", f19, f20, f21, flt[10], flt[9])
   TEST_CMP_S("cmp.sne.s", f20, f21, f22, flt[10], flt[10])
   TEST_CMP_S("cmp.sne.s", f21, f22, f23, flt[10], flt[11])
   TEST_CMP_S("cmp.sne.s", f11, f12, f13, flt[11], flt[0])
   TEST_CMP_S("cmp.sne.s", f12, f13, f14, flt[11], flt[1])
   TEST_CMP_S("cmp.sne.s", f13, f14, f15, flt[11], flt[2])
   TEST_CMP_S("cmp.sne.s", f14, f15, f16, flt[11], flt[3])
   TEST_CMP_S("cmp.sne.s", f15, f16, f17, flt[11], flt[4])
   TEST_CMP_S("cmp.sne.s", f16, f17, f18, flt[11], flt[5])
   TEST_CMP_S("cmp.sne.s", f17, f18, f19, flt[11], flt[6])
   TEST_CMP_S("cmp.sne.s", f18, f19, f20, flt[11], flt[7])
   TEST_CMP_S("cmp.sne.s", f19, f20, f21, flt[11], flt[8])
   TEST_CMP_S("cmp.sne.s", f20, f21, f22, flt[11], flt[9])
   TEST_CMP_S("cmp.sne.s", f21, f22, f23, flt[11], flt[10])
   TEST_CMP_S("cmp.sne.s", f22, f23, f24, flt[11], flt[11])

   printf("cmp.saf.d\n");
   TEST_CMP_D("cmp.saf.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.saf.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.saf.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.saf.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.saf.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.saf.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.saf.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.saf.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.saf.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.saf.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.saf.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.saf.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.saf.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.saf.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.saf.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.saf.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.saf.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.saf.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.saf.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.saf.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.saf.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.saf.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.saf.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.saf.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.saf.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.saf.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.saf.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.saf.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.saf.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.saf.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.saf.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.saf.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.saf.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.saf.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.saf.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.saf.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.saf.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.saf.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.saf.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.saf.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.saf.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.saf.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.saf.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.saf.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.saf.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.saf.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.saf.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.saf.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.saf.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.saf.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.saf.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.saf.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.saf.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.saf.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.saf.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.saf.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.saf.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.saf.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.saf.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.saf.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.saf.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.saf.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.saf.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.saf.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.saf.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.saf.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.saf.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.saf.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.saf.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.saf.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.saf.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.saf.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.saf.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.saf.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.saf.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.saf.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.saf.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.saf.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.saf.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.saf.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.saf.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.saf.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.saf.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.saf.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.saf.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.saf.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.saf.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.saf.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.saf.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.saf.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.saf.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.saf.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.saf.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.saf.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.saf.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.saf.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.saf.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.saf.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.saf.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.saf.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.saf.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.saf.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.saf.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.saf.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.saf.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.saf.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.saf.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.saf.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.saf.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.saf.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.saf.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.saf.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.saf.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.saf.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.saf.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.saf.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.saf.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.saf.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.saf.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.saf.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.saf.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.saf.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.saf.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.saf.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.saf.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.saf.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.saf.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.saf.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.saf.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.saf.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.saf.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.saf.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.saf.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.sun.d\n");
   TEST_CMP_D("cmp.sun.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.sun.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.sun.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.sun.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.sun.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.sun.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.sun.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.sun.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.sun.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.sun.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.sun.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.sun.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.sun.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.sun.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.sun.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.sun.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.sun.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.sun.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.sun.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.sun.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.sun.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.sun.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.sun.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.sun.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.sun.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.sun.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.sun.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.sun.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.sun.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.sun.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.sun.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.sun.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.sun.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.sun.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.sun.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.sun.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.sun.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.sun.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.sun.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.sun.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.sun.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.sun.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.sun.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.sun.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.sun.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.sun.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.sun.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.sun.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.sun.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.sun.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.sun.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.sun.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.sun.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.sun.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.sun.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.sun.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.sun.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.sun.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.sun.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.sun.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.sun.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.sun.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.sun.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.sun.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.sun.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.sun.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.sun.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.sun.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.sun.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.sun.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.sun.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.sun.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.sun.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.sun.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.sun.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.sun.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.sun.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.sun.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.sun.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.sun.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.sun.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.sun.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.sun.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.sun.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.sun.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.sun.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.sun.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.sun.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.sun.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.sun.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.sun.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.sun.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.sun.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.sun.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.sun.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.sun.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.sun.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.sun.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.sun.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.sun.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.sun.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.sun.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.sun.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.sun.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.sun.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.sun.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.sun.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.sun.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.sun.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.sun.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.sun.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.sun.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.sun.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.sun.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.sun.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.sun.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.sun.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.sun.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.sun.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.sun.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.sun.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.sun.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.sun.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.sun.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.sun.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.sun.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.sun.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.sun.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.sun.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.sun.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.sun.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.sun.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.sun.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.seq.d\n");
   TEST_CMP_D("cmp.seq.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.seq.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.seq.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.seq.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.seq.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.seq.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.seq.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.seq.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.seq.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.seq.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.seq.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.seq.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.seq.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.seq.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.seq.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.seq.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.seq.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.seq.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.seq.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.seq.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.seq.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.seq.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.seq.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.seq.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.seq.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.seq.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.seq.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.seq.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.seq.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.seq.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.seq.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.seq.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.seq.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.seq.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.seq.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.seq.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.seq.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.seq.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.seq.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.seq.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.seq.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.seq.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.seq.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.seq.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.seq.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.seq.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.seq.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.seq.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.seq.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.seq.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.seq.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.seq.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.seq.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.seq.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.seq.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.seq.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.seq.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.seq.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.seq.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.seq.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.seq.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.seq.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.seq.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.seq.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.seq.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.seq.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.seq.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.seq.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.seq.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.seq.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.seq.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.seq.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.seq.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.seq.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.seq.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.seq.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.seq.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.seq.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.seq.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.seq.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.seq.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.seq.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.seq.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.seq.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.seq.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.seq.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.seq.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.seq.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.seq.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.seq.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.seq.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.seq.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.seq.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.seq.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.seq.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.seq.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.seq.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.seq.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.seq.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.seq.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.seq.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.seq.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.seq.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.seq.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.seq.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.seq.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.seq.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.seq.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.seq.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.seq.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.seq.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.seq.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.seq.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.seq.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.seq.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.seq.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.seq.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.seq.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.seq.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.seq.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.seq.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.seq.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.seq.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.seq.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.seq.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.seq.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.seq.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.seq.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.seq.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.seq.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.seq.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.seq.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.seq.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.sueq.d\n");
   TEST_CMP_D("cmp.sueq.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.sueq.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.sueq.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.sueq.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.sueq.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.sueq.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.sueq.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.sueq.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.sueq.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.sueq.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.sueq.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.sueq.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.sueq.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.sueq.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.sueq.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.sueq.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.sueq.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.sueq.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.sueq.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.sueq.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.sueq.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.sueq.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.sueq.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.slt.d\n");
   TEST_CMP_D("cmp.slt.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.slt.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.slt.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.slt.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.slt.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.slt.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.slt.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.slt.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.slt.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.slt.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.slt.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.slt.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.slt.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.slt.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.slt.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.slt.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.slt.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.slt.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.slt.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.slt.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.slt.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.slt.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.slt.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.slt.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.slt.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.slt.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.slt.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.slt.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.slt.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.slt.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.slt.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.slt.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.slt.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.slt.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.slt.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.slt.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.slt.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.slt.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.slt.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.slt.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.slt.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.slt.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.slt.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.slt.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.slt.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.slt.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.slt.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.slt.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.slt.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.slt.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.slt.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.slt.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.slt.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.slt.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.slt.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.slt.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.slt.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.slt.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.slt.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.slt.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.slt.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.slt.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.slt.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.slt.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.slt.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.slt.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.slt.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.slt.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.slt.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.slt.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.slt.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.slt.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.slt.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.slt.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.slt.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.slt.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.slt.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.slt.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.slt.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.slt.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.slt.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.slt.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.slt.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.slt.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.slt.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.slt.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.slt.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.slt.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.slt.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.slt.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.slt.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.slt.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.slt.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.slt.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.slt.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.slt.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.slt.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.slt.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.slt.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.slt.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.slt.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.slt.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.slt.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.slt.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.slt.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.slt.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.slt.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.slt.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.slt.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.slt.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.slt.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.slt.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.slt.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.slt.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.slt.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.slt.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.slt.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.slt.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.slt.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.slt.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.slt.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.slt.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.slt.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.slt.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.slt.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.slt.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.slt.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.slt.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.slt.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.slt.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.slt.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.slt.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.slt.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.sult.d\n");
   TEST_CMP_D("cmp.sult.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.sult.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.sult.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.sult.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.sult.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.sult.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.sult.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.sult.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.sult.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.sult.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.sult.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.sult.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.sult.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.sult.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.sult.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.sult.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.sult.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.sult.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.sult.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.sult.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.sult.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.sult.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.sult.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.sult.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.sult.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.sult.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.sult.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.sult.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.sult.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.sult.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.sult.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.sult.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.sult.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.sult.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.sult.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.sult.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.sult.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.sult.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.sult.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.sult.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.sult.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.sult.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.sult.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.sult.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.sult.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.sult.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.sult.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.sult.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.sult.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.sult.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.sult.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.sult.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.sult.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.sult.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.sult.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.sult.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.sult.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.sult.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.sult.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.sult.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.sult.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.sult.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.sult.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.sult.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.sult.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.sult.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.sult.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.sult.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.sult.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.sult.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.sult.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.sult.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.sult.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.sult.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.sult.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.sult.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.sult.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.sult.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.sult.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.sult.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.sult.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.sult.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.sult.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.sult.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.sult.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.sult.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.sult.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.sult.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.sult.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.sult.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.sult.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.sult.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.sult.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.sult.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.sult.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.sult.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.sult.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.sult.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.sult.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.sult.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.sult.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.sult.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.sult.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.sult.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.sult.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.sult.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.sult.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.sult.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.sult.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.sult.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.sult.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.sult.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.sult.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.sult.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.sult.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.sult.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.sult.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.sult.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.sult.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.sult.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.sult.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.sult.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.sult.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.sult.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.sult.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.sult.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.sult.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.sult.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.sult.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.sult.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.sult.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.sult.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.sult.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.sle.d\n");
   TEST_CMP_D("cmp.sle.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.sle.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.sle.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.sle.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.sle.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.sle.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.sle.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.sle.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.sle.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.sle.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.sle.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.sle.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.sle.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.sle.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.sle.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.sle.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.sle.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.sle.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.sle.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.sle.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.sle.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.sle.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.sle.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.sle.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.sle.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.sle.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.sle.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.sle.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.sle.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.sle.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.sle.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.sle.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.sle.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.sle.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.sle.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.sle.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.sle.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.sle.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.sle.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.sle.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.sle.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.sle.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.sle.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.sle.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.sle.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.sle.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.sle.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.sle.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.sle.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.sle.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.sle.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.sle.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.sle.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.sle.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.sle.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.sle.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.sle.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.sle.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.sle.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.sle.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.sle.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.sle.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.sle.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.sle.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.sle.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.sle.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.sle.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.sle.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.sle.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.sle.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.sle.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.sle.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.sle.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.sle.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.sle.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.sle.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.sle.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.sle.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.sle.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.sle.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.sle.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.sle.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.sle.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.sle.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.sle.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.sle.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.sle.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.sle.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.sle.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.sle.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.sle.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.sle.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.sle.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.sle.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.sle.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.sle.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.sle.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.sle.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.sle.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.sle.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.sle.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.sle.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.sle.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.sle.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.sle.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.sle.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.sle.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.sle.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.sle.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.sle.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.sle.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.sle.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.sle.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.sle.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.sle.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.sle.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.sle.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.sle.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.sle.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.sle.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.sle.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.sle.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.sle.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.sle.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.sle.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.sle.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.sle.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.sle.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.sle.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.sle.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.sle.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.sle.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.sle.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.sule.d\n");
   TEST_CMP_D("cmp.sule.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.sule.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.sule.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.sule.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.sule.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.sule.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.sule.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.sule.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.sule.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.sule.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.sule.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.sule.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.sule.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.sule.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.sule.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.sule.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.sule.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.sule.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.sule.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.sule.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.sule.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.sule.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.sule.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.sule.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.sule.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.sule.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.sule.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.sule.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.sule.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.sule.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.sule.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.sule.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.sule.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.sule.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.sule.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.sule.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.sule.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.sule.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.sule.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.sule.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.sule.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.sule.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.sule.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.sule.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.sule.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.sule.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.sule.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.sule.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.sule.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.sule.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.sule.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.sule.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.sule.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.sule.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.sule.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.sule.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.sule.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.sule.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.sule.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.sule.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.sule.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.sule.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.sule.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.sule.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.sule.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.sule.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.sule.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.sule.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.sule.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.sule.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.sule.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.sule.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.sule.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.sule.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.sule.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.sule.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.sule.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.sule.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.sule.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.sule.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.sule.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.sule.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.sule.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.sule.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.sule.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.sule.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.sule.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.sule.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.sule.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.sule.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.sule.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.sule.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.sule.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.sule.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.sule.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.sule.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.sule.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.sule.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.sule.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.sule.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.sule.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.sule.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.sule.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.sule.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.sule.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.sule.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.sule.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.sule.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.sule.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.sule.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.sule.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.sule.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.sule.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.sule.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.sule.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.sule.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.sule.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.sule.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.sule.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.sule.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.sule.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.sule.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.sule.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.sule.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.sule.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.sule.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.sule.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.sule.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.sule.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.sule.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.sule.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.sule.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.sule.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.sor.d\n");
   TEST_CMP_D("cmp.sor.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.sor.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.sor.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.sor.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.sor.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.sor.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.sor.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.sor.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.sor.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.sor.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.sor.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.sor.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.sor.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.sor.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.sor.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.sor.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.sor.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.sor.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.sor.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.sor.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.sor.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.sor.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.sor.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.sor.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.sor.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.sor.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.sor.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.sor.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.sor.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.sor.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.sor.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.sor.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.sor.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.sor.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.sor.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.sor.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.sor.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.sor.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.sor.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.sor.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.sor.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.sor.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.sor.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.sor.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.sor.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.sor.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.sor.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.sor.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.sor.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.sor.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.sor.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.sor.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.sor.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.sor.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.sor.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.sor.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.sor.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.sor.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.sor.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.sor.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.sor.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.sor.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.sor.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.sor.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.sor.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.sor.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.sor.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.sor.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.sor.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.sor.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.sor.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.sor.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.sor.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.sor.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.sor.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.sor.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.sor.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.sor.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.sor.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.sor.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.sor.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.sor.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.sor.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.sor.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.sor.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.sor.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.sor.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.sor.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.sor.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.sor.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.sor.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.sor.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.sor.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.sor.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.sor.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.sor.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.sor.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.sor.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.sor.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.sor.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.sor.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.sor.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.sor.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.sor.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.sor.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.sor.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.sor.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.sor.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.sor.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.sor.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.sor.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.sor.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.sor.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.sor.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.sor.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.sor.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.sor.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.sor.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.sor.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.sor.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.sor.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.sor.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.sor.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.sor.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.sor.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.sor.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.sor.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.sor.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.sor.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.sor.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.sor.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.sor.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.sor.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.sune.d\n");
   TEST_CMP_D("cmp.sune.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.sune.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.sune.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.sune.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.sune.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.sune.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.sune.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.sune.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.sune.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.sune.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.sune.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.sune.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.sune.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.sune.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.sune.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.sune.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.sune.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.sune.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.sune.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.sune.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.sune.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.sune.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.sune.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.sune.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.sune.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.sune.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.sune.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.sune.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.sune.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.sune.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.sune.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.sune.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.sune.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.sune.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.sune.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.sune.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.sune.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.sune.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.sune.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.sune.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.sune.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.sune.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.sune.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.sune.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.sune.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.sune.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.sune.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.sune.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.sune.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.sune.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.sune.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.sune.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.sune.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.sune.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.sune.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.sune.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.sune.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.sune.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.sune.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.sune.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.sune.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.sune.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.sune.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.sune.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.sune.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.sune.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.sune.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.sune.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.sune.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.sune.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.sune.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.sune.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.sune.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.sune.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.sune.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.sune.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.sune.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.sune.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.sune.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.sune.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.sune.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.sune.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.sune.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.sune.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.sune.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.sune.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.sune.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.sune.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.sune.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.sune.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.sune.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.sune.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.sune.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.sune.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.sune.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.sune.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.sune.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.sune.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.sune.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.sune.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.sune.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.sune.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.sune.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.sune.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.sune.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.sune.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.sune.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.sune.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.sune.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.sune.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.sune.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.sune.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.sune.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.sune.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.sune.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.sune.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.sune.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.sune.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.sune.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.sune.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.sune.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.sune.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.sune.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.sune.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.sune.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.sune.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.sune.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.sune.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.sune.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.sune.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.sune.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.sune.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.sune.d", f22, f23, f24, dbl[11], dbl[11])

   printf("cmp.sne.d\n");
   TEST_CMP_D("cmp.sne.d", f0, f1, f2, dbl[0], dbl[0])
   TEST_CMP_D("cmp.sne.d", f1, f2, f3, dbl[0], dbl[1])
   TEST_CMP_D("cmp.sne.d", f2, f3, f4, dbl[0], dbl[2])
   TEST_CMP_D("cmp.sne.d", f3, f4, f5, dbl[0], dbl[3])
   TEST_CMP_D("cmp.sne.d", f4, f5, f6, dbl[0], dbl[4])
   TEST_CMP_D("cmp.sne.d", f5, f6, f7, dbl[0], dbl[5])
   TEST_CMP_D("cmp.sne.d", f6, f7, f8, dbl[0], dbl[6])
   TEST_CMP_D("cmp.sne.d", f7, f8, f9, dbl[0], dbl[7])
   TEST_CMP_D("cmp.sne.d", f8, f9, f10, dbl[0], dbl[8])
   TEST_CMP_D("cmp.sne.d", f9, f10, f11, dbl[0], dbl[9])
   TEST_CMP_D("cmp.sne.d", f10, f11, f12, dbl[0], dbl[10])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[0], dbl[11])
   TEST_CMP_D("cmp.sne.d", f1, f2, f3, dbl[1], dbl[0])
   TEST_CMP_D("cmp.sne.d", f2, f3, f4, dbl[1], dbl[1])
   TEST_CMP_D("cmp.sne.d", f3, f4, f5, dbl[1], dbl[2])
   TEST_CMP_D("cmp.sne.d", f4, f5, f6, dbl[1], dbl[3])
   TEST_CMP_D("cmp.sne.d", f5, f6, f7, dbl[1], dbl[4])
   TEST_CMP_D("cmp.sne.d", f6, f7, f8, dbl[1], dbl[5])
   TEST_CMP_D("cmp.sne.d", f7, f8, f9, dbl[1], dbl[6])
   TEST_CMP_D("cmp.sne.d", f8, f9, f10, dbl[1], dbl[7])
   TEST_CMP_D("cmp.sne.d", f9, f10, f11, dbl[1], dbl[8])
   TEST_CMP_D("cmp.sne.d", f10, f11, f12, dbl[1], dbl[9])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[1], dbl[10])
   TEST_CMP_D("cmp.sne.d", f12, f13, f14, dbl[1], dbl[11])
   TEST_CMP_D("cmp.sne.d", f2, f3, f4, dbl[2], dbl[0])
   TEST_CMP_D("cmp.sne.d", f3, f4, f5, dbl[2], dbl[1])
   TEST_CMP_D("cmp.sne.d", f4, f5, f6, dbl[2], dbl[2])
   TEST_CMP_D("cmp.sne.d", f5, f6, f7, dbl[2], dbl[3])
   TEST_CMP_D("cmp.sne.d", f6, f7, f8, dbl[2], dbl[4])
   TEST_CMP_D("cmp.sne.d", f7, f8, f9, dbl[2], dbl[5])
   TEST_CMP_D("cmp.sne.d", f8, f9, f10, dbl[2], dbl[6])
   TEST_CMP_D("cmp.sne.d", f9, f10, f11, dbl[2], dbl[7])
   TEST_CMP_D("cmp.sne.d", f10, f11, f12, dbl[2], dbl[8])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[2], dbl[9])
   TEST_CMP_D("cmp.sne.d", f12, f13, f14, dbl[2], dbl[10])
   TEST_CMP_D("cmp.sne.d", f13, f14, f15, dbl[2], dbl[11])
   TEST_CMP_D("cmp.sne.d", f3, f4, f5, dbl[3], dbl[0])
   TEST_CMP_D("cmp.sne.d", f4, f5, f6, dbl[3], dbl[1])
   TEST_CMP_D("cmp.sne.d", f5, f6, f7, dbl[3], dbl[2])
   TEST_CMP_D("cmp.sne.d", f6, f7, f8, dbl[3], dbl[3])
   TEST_CMP_D("cmp.sne.d", f7, f8, f9, dbl[3], dbl[4])
   TEST_CMP_D("cmp.sne.d", f8, f9, f10, dbl[3], dbl[5])
   TEST_CMP_D("cmp.sne.d", f9, f10, f11, dbl[3], dbl[6])
   TEST_CMP_D("cmp.sne.d", f10, f11, f12, dbl[3], dbl[7])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[3], dbl[8])
   TEST_CMP_D("cmp.sne.d", f12, f13, f14, dbl[3], dbl[9])
   TEST_CMP_D("cmp.sne.d", f13, f14, f15, dbl[3], dbl[10])
   TEST_CMP_D("cmp.sne.d", f14, f15, f16, dbl[3], dbl[11])
   TEST_CMP_D("cmp.sne.d", f4, f5, f6, dbl[4], dbl[0])
   TEST_CMP_D("cmp.sne.d", f5, f6, f7, dbl[4], dbl[1])
   TEST_CMP_D("cmp.sne.d", f6, f7, f8, dbl[4], dbl[2])
   TEST_CMP_D("cmp.sne.d", f7, f8, f9, dbl[4], dbl[3])
   TEST_CMP_D("cmp.sne.d", f8, f9, f10, dbl[4], dbl[4])
   TEST_CMP_D("cmp.sne.d", f9, f10, f11, dbl[4], dbl[5])
   TEST_CMP_D("cmp.sne.d", f10, f11, f12, dbl[4], dbl[6])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[4], dbl[7])
   TEST_CMP_D("cmp.sne.d", f12, f13, f14, dbl[4], dbl[8])
   TEST_CMP_D("cmp.sne.d", f13, f14, f15, dbl[4], dbl[9])
   TEST_CMP_D("cmp.sne.d", f14, f15, f16, dbl[4], dbl[10])
   TEST_CMP_D("cmp.sne.d", f15, f16, f17, dbl[4], dbl[11])
   TEST_CMP_D("cmp.sne.d", f5, f6, f7, dbl[5], dbl[0])
   TEST_CMP_D("cmp.sne.d", f6, f7, f8, dbl[5], dbl[1])
   TEST_CMP_D("cmp.sne.d", f7, f8, f9, dbl[5], dbl[2])
   TEST_CMP_D("cmp.sne.d", f8, f9, f10, dbl[5], dbl[3])
   TEST_CMP_D("cmp.sne.d", f9, f10, f11, dbl[5], dbl[4])
   TEST_CMP_D("cmp.sne.d", f10, f11, f12, dbl[5], dbl[5])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[5], dbl[6])
   TEST_CMP_D("cmp.sne.d", f12, f13, f14, dbl[5], dbl[7])
   TEST_CMP_D("cmp.sne.d", f13, f14, f15, dbl[5], dbl[8])
   TEST_CMP_D("cmp.sne.d", f14, f15, f16, dbl[5], dbl[9])
   TEST_CMP_D("cmp.sne.d", f15, f16, f17, dbl[5], dbl[10])
   TEST_CMP_D("cmp.sne.d", f16, f17, f18, dbl[5], dbl[11])
   TEST_CMP_D("cmp.sne.d", f6, f7, f8, dbl[6], dbl[0])
   TEST_CMP_D("cmp.sne.d", f7, f8, f9, dbl[6], dbl[1])
   TEST_CMP_D("cmp.sne.d", f8, f9, f10, dbl[6], dbl[2])
   TEST_CMP_D("cmp.sne.d", f9, f10, f11, dbl[6], dbl[3])
   TEST_CMP_D("cmp.sne.d", f10, f11, f12, dbl[6], dbl[4])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[6], dbl[5])
   TEST_CMP_D("cmp.sne.d", f12, f13, f14, dbl[6], dbl[6])
   TEST_CMP_D("cmp.sne.d", f13, f14, f15, dbl[6], dbl[7])
   TEST_CMP_D("cmp.sne.d", f14, f15, f16, dbl[6], dbl[8])
   TEST_CMP_D("cmp.sne.d", f15, f16, f17, dbl[6], dbl[9])
   TEST_CMP_D("cmp.sne.d", f16, f17, f18, dbl[6], dbl[10])
   TEST_CMP_D("cmp.sne.d", f17, f18, f19, dbl[6], dbl[11])
   TEST_CMP_D("cmp.sne.d", f7, f8, f9, dbl[7], dbl[0])
   TEST_CMP_D("cmp.sne.d", f8, f9, f10, dbl[7], dbl[1])
   TEST_CMP_D("cmp.sne.d", f9, f10, f11, dbl[7], dbl[2])
   TEST_CMP_D("cmp.sne.d", f10, f11, f12, dbl[7], dbl[3])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[7], dbl[4])
   TEST_CMP_D("cmp.sne.d", f12, f13, f14, dbl[7], dbl[5])
   TEST_CMP_D("cmp.sne.d", f13, f14, f15, dbl[7], dbl[6])
   TEST_CMP_D("cmp.sne.d", f14, f15, f16, dbl[7], dbl[7])
   TEST_CMP_D("cmp.sne.d", f15, f16, f17, dbl[7], dbl[8])
   TEST_CMP_D("cmp.sne.d", f16, f17, f18, dbl[7], dbl[9])
   TEST_CMP_D("cmp.sne.d", f17, f18, f19, dbl[7], dbl[10])
   TEST_CMP_D("cmp.sne.d", f18, f19, f20, dbl[7], dbl[11])
   TEST_CMP_D("cmp.sne.d", f8, f9, f10, dbl[8], dbl[0])
   TEST_CMP_D("cmp.sne.d", f9, f10, f11, dbl[8], dbl[1])
   TEST_CMP_D("cmp.sne.d", f10, f11, f12, dbl[8], dbl[2])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[8], dbl[3])
   TEST_CMP_D("cmp.sne.d", f12, f13, f14, dbl[8], dbl[4])
   TEST_CMP_D("cmp.sne.d", f13, f14, f15, dbl[8], dbl[5])
   TEST_CMP_D("cmp.sne.d", f14, f15, f16, dbl[8], dbl[6])
   TEST_CMP_D("cmp.sne.d", f15, f16, f17, dbl[8], dbl[7])
   TEST_CMP_D("cmp.sne.d", f16, f17, f18, dbl[8], dbl[8])
   TEST_CMP_D("cmp.sne.d", f17, f18, f19, dbl[8], dbl[9])
   TEST_CMP_D("cmp.sne.d", f18, f19, f20, dbl[8], dbl[10])
   TEST_CMP_D("cmp.sne.d", f19, f20, f21, dbl[8], dbl[11])
   TEST_CMP_D("cmp.sne.d", f9, f10, f11, dbl[9], dbl[0])
   TEST_CMP_D("cmp.sne.d", f10, f11, f12, dbl[9], dbl[1])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[9], dbl[2])
   TEST_CMP_D("cmp.sne.d", f12, f13, f14, dbl[9], dbl[3])
   TEST_CMP_D("cmp.sne.d", f13, f14, f15, dbl[9], dbl[4])
   TEST_CMP_D("cmp.sne.d", f14, f15, f16, dbl[9], dbl[5])
   TEST_CMP_D("cmp.sne.d", f15, f16, f17, dbl[9], dbl[6])
   TEST_CMP_D("cmp.sne.d", f16, f17, f18, dbl[9], dbl[7])
   TEST_CMP_D("cmp.sne.d", f17, f18, f19, dbl[9], dbl[8])
   TEST_CMP_D("cmp.sne.d", f18, f19, f20, dbl[9], dbl[9])
   TEST_CMP_D("cmp.sne.d", f19, f20, f21, dbl[9], dbl[10])
   TEST_CMP_D("cmp.sne.d", f20, f21, f22, dbl[9], dbl[11])
   TEST_CMP_D("cmp.sne.d", f10, f11, f12, dbl[10], dbl[0])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[10], dbl[1])
   TEST_CMP_D("cmp.sne.d", f12, f13, f14, dbl[10], dbl[2])
   TEST_CMP_D("cmp.sne.d", f13, f14, f15, dbl[10], dbl[3])
   TEST_CMP_D("cmp.sne.d", f14, f15, f16, dbl[10], dbl[4])
   TEST_CMP_D("cmp.sne.d", f15, f16, f17, dbl[10], dbl[5])
   TEST_CMP_D("cmp.sne.d", f16, f17, f18, dbl[10], dbl[6])
   TEST_CMP_D("cmp.sne.d", f17, f18, f19, dbl[10], dbl[7])
   TEST_CMP_D("cmp.sne.d", f18, f19, f20, dbl[10], dbl[8])
   TEST_CMP_D("cmp.sne.d", f19, f20, f21, dbl[10], dbl[9])
   TEST_CMP_D("cmp.sne.d", f20, f21, f22, dbl[10], dbl[10])
   TEST_CMP_D("cmp.sne.d", f21, f22, f23, dbl[10], dbl[11])
   TEST_CMP_D("cmp.sne.d", f11, f12, f13, dbl[11], dbl[0])
   TEST_CMP_D("cmp.sne.d", f12, f13, f14, dbl[11], dbl[1])
   TEST_CMP_D("cmp.sne.d", f13, f14, f15, dbl[11], dbl[2])
   TEST_CMP_D("cmp.sne.d", f14, f15, f16, dbl[11], dbl[3])
   TEST_CMP_D("cmp.sne.d", f15, f16, f17, dbl[11], dbl[4])
   TEST_CMP_D("cmp.sne.d", f16, f17, f18, dbl[11], dbl[5])
   TEST_CMP_D("cmp.sne.d", f17, f18, f19, dbl[11], dbl[6])
   TEST_CMP_D("cmp.sne.d", f18, f19, f20, dbl[11], dbl[7])
   TEST_CMP_D("cmp.sne.d", f19, f20, f21, dbl[11], dbl[8])
   TEST_CMP_D("cmp.sne.d", f20, f21, f22, dbl[11], dbl[9])
   TEST_CMP_D("cmp.sne.d", f21, f22, f23, dbl[11], dbl[10])
   TEST_CMP_D("cmp.sne.d", f22, f23, f24, dbl[11], dbl[11])
#endif

   return 0;
}

