use super::*;
use std::io::Write;

impl Config<'_> {
    pub fn format(&self, tokens: &str) -> String {
        let preamble = if self.no_comment {
            String::new()
        } else {
            let version = std::env!("CARGO_PKG_VERSION");

            format!(
                r#"// Bindings generated by `windows-bindgen` {version}


"#
            )
        };

        let allow = if self.no_allow {
            ""
        } else {
            "#![allow(non_snake_case, non_upper_case_globals, non_camel_case_types, dead_code, clippy::all)]\n\n"
        };
        let tokens = format!("{preamble}{allow}{tokens}");

        let mut cmd = std::process::Command::new("rustfmt");
        cmd.stdin(std::process::Stdio::piped());
        cmd.stdout(std::process::Stdio::piped());
        cmd.stderr(std::process::Stdio::null());

        if !self.rustfmt.is_empty() {
            cmd.arg("--config");
            cmd.arg(self.rustfmt);
        }

        let Ok(mut child) = cmd.spawn() else {
            return tokens;
        };

        let Some(mut stdin) = child.stdin.take() else {
            return tokens;
        };

        if stdin.write_all(tokens.as_bytes()).is_err() {
            return tokens;
        }

        drop(stdin);

        let Ok(output) = child.wait_with_output() else {
            return tokens;
        };

        if !output.status.success() {
            return tokens;
        }

        if let Ok(result) = String::from_utf8(output.stdout) {
            result
        } else {
            tokens
        }
    }
}
