# 2025-03-25 Triage Log

A nearly noise-free week, which is exciting, with a number of fairly large
improvements landing for a cumulative average speed up 0.5%, possibly larger if
we ignore the likely to be fixed or reverted regressions from
[#138674](https://github.com/rust-lang/rust/pull/138674).

Triage done by **@simulacrum**.
Revision range: [493c38ba..4510e86a](https://perf.rust-lang.org/?start=493c38ba371929579fe136df26eccd9516347c7a&end=4510e86a41388733675465a8647d4235f3bf2023&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.4%  | [0.2%, 13.5%]  | 17    |
| Regressions ❌ <br /> (secondary)  | 2.2%  | [0.2%, 6.9%]   | 38    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-4.9%, -0.1%] | 135   |
| Improvements ✅ <br /> (secondary) | -1.4% | [-4.3%, -0.2%] | 118   |
| All ❌✅ (primary)                 | -0.5% | [-4.9%, 13.5%] | 152   |


3 Regressions, 4 Improvements, 2 Mixed; 3 of them in rollups
35 artifact comparisons made in total

#### Regressions

Rollup of 10 pull requests [#138693](https://github.com/rust-lang/rust/pull/138693) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c4b38a596767c9c6275c937cf3a2d4b9612b4875&end=a7fc463dd8fbeca800d4b3efc501069502cffe64&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 6.8% | [0.5%, 14.7%] | 10    |
| Regressions ❌ <br /> (secondary)  | 3.2% | [0.2%, 9.5%]  | 32    |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | 6.8% | [0.5%, 14.7%] | 10    |

Significant regression in query methods due to
https://github.com/rust-lang/rust/pull/138674, @oli-obk is bisecting which of
the changes actually caused it (it should have been a no-op PR).

expand: Leave traces when expanding `cfg_attr` attributes [#138515](https://github.com/rust-lang/rust/pull/138515) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d8e44b722a93e55cbc9a8188dfbfe3faf1226096&end=78948ac259253ce89effca1e8bb64d16f4684aa4&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.1%, 1.8%] | 29    |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.1%, 1.8%] | 29    |

Slight regressions are expected as we're preserving more information for later
in the compiler (see comment in https://github.com/rust-lang/rust/pull/138515#issuecomment-2726426176).

Only use the new node hashmap for anonymous nodes [#138629](https://github.com/rust-lang/rust/pull/138629) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=90f5eab952728ac6edcf529a171f7de5c25e5d49&end=4510e86a41388733675465a8647d4235f3bf2023&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 0.5%]   | 31    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 0.8%]   | 17    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.1%, 0.5%]   | 31    |

Perf turns on incremental-verify-ich, but this should have no effect on builds with that turned off.

#### Improvements

Rollup of 7 pull requests [#138630](https://github.com/rust-lang/rust/pull/138630) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=493c38ba371929579fe136df26eccd9516347c7a&end=259fdb521200c9abba547302fc2c826479ef26b2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.2%, -0.1%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.2%] | 4     |
| All ❌✅ (primary)                 | -0.1% | [-0.2%, -0.1%] | 5     |


Represent diagnostic side effects as dep nodes [#122156](https://github.com/rust-lang/rust/pull/122156) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a7fc463dd8fbeca800d4b3efc501069502cffe64&end=1aeb99d248e1b0069110cb03c6f1dcc7b36fd7f3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.4%, -0.2%] | 117   |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.6%, -0.0%] | 37    |
| All ❌✅ (primary)                 | -0.7% | [-1.4%, -0.2%] | 117   |


Rollup of 10 pull requests [#138873](https://github.com/rust-lang/rust/pull/138873) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7290b04b0a46de2118968aa556bfc0970aac6661&end=ae8ab87de4d8caab5d91a027bc19bb5d5e8a3691&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1%  | [0.1%, 0.1%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.2% | [-4.3%, -0.2%] | 20    |
| Improvements ✅ <br /> (secondary) | -1.3% | [-3.7%, -0.2%] | 98    |
| All ❌✅ (primary)                 | -2.1% | [-4.3%, 0.1%]  | 21    |


Optimize hash map operations in the query system [#115747](https://github.com/rust-lang/rust/pull/115747) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b95aac6a98e43ee9d47cd05cb2d476610c51dcb7&end=90f5eab952728ac6edcf529a171f7de5c25e5d49&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.4%, -0.1%] | 20    |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.1%] | 24    |
| All ❌✅ (primary)                 | -0.2% | [-0.4%, -0.1%] | 20    |


#### Mixed

Consider fields to be inhabited if they are unstable [#133889](https://github.com/rust-lang/rust/pull/133889) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=87e60a7d285f8ea560189024f85f2b194d1f168f&end=d8e44b722a93e55cbc9a8188dfbfe3faf1226096&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [0.3%, 1.9%]   | 11    |
| Improvements ✅ <br /> (primary)   | -0.0% | [-0.0%, -0.0%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.0%, 0.2%]  | 4     |

This is a soundness fix and the regression is limited to our stress test for this area of the code:

> The perf diff is in the match exhaustiveness stress-test. I don't think we're
> running any new code for this test, but it's always very sensitive to things
> like inlining decisions so I'm not surprised. Good to know, and ok to ignore.

(https://github.com/rust-lang/rust/pull/133889)

Reduce FormattingOptions to 64 bits [#136974](https://github.com/rust-lang/rust/pull/136974) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=db687889a5833381b8b02738a1af93a09a97ba16&end=0ce1369bde8ea61c0286f6e3e35e38fca569a50b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -1.5% | [-1.5%, -1.5%] | 1     |
| All ❌✅ (primary)                 | -0.4% | [-0.5%, -0.2%] | 7     |

Regressions are limited to the `coercions` secondary benchmark, which sometimes
has natural bimodality. It doesn't seem worth further investigation into this
regression given the limited regression.
