# 2022-02-08 Triage Log

A week with a number of correctness-related regressions, and a few small
cleanups yielding good performance results. Overall an improvement, particularly
for incremental benchmarks.

Triage done by **@simulacrum**.
Revision range: [1ea4851715893ee3f365a8ef09d47165e9a7864f..775e480722c7aba6ff4ff3ccec8c1f4639ae7889](https://perf.rust-lang.org/?start=1ea4851715893ee3f365a8ef09d47165e9a7864f&end=775e480722c7aba6ff4ff3ccec8c1f4639ae7889&absolute=false&stat=instructions%3Au)

4 Regressions, 2 Improvements, 5 Mixed; 1 of them in rollups
27 comparisons made in total

#### Regressions

debuginfo: Make sure that type names for closure and generator environments are unique in debuginfo. [#93154](https://github.com/rust-lang/rust/issues/93154)
- Average relevant regression: 1.6%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=250384edc5d78533e993f38c60d64e42b21684b2&end=dca1e7aa5a8ac05ddaea731f4eab20de91acb46b&stat=instructions:u): 2.9% on `incr-full` builds of `deeply-nested-closures debug`
- debuginfo generation made more complicated for correctness reasons; led to a
  regression. Left a comment asking if this is expected.

rustdoc: Collect traits in scope for foreign inherent impls [#93539](https://github.com/rust-lang/rust/issues/93539)
- Average relevant regression: 1.1%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=291bf94cfd6456602d67f0e3be109bcd8c125b1a&end=88fb06a1f331926bccb448acdb52966fd1ec8a92&stat=instructions:u): 1.7% on `full` builds of `projection-caching doc`
- Fixes a regression, and necessary for correctness due to rustdoc inlining
  impls on inherent types across crate boundaries.

Allow unwinding from OOM hooks [#92535](https://github.com/rust-lang/rust/issues/92535)
- Average relevant regression: 0.8%
- Average relevant improvement: -0.3%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=88fb06a1f331926bccb448acdb52966fd1ec8a92&end=719b04ca99be0c78e09a8ec5e2eda082a5d8ccae&stat=instructions:u): 1.9% on `incr-patched: println` builds of `regression-31157 opt`
- Expected, relatively minimal impact for a desired feature.

Lazy type-alias-impl-trait [#92007](https://github.com/rust-lang/rust/issues/92007)
- Average relevant regression: 1.2%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=734368a200904ef9c21db86c595dc04263c87be0&end=e7cc3bddbe0d0e374d05e7003e662bba1742dbae&stat=instructions:u): 1.7% on `full` builds of `match-stress-enum check`
- New errors in wg-grammar
- Errors and regression are being investigated, but were not expected. It is
  likely that we should get in the habit of pre-running perf on larger PRs like
  this, which have higher risk of causing problems.

Rollup of 13 pull requests [#93738](https://github.com/rust-lang/rust/issues/93738)
- Average relevant regression: 0.6%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c5e414843ebfe25674d8e18a5369d6249fdee741&end=f52c31840df7ec9c9350baff51a8964b20b5e1ba&stat=instructions:u): 0.8% on `full` builds of `deeply-nested doc`
- Regressions across many documentation benchmarks, though exact cause is
  unclear (in part due to the rollup). Likely related to [#93208], though, which
  is an expected regression source.

[#93208]: https://github.com/rust-lang/rust/issues/93208

Add more *-unwind ABI variants [#93561](https://github.com/rust-lang/rust/issues/93561)
- Average relevant regression: 0.5%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e7cc3bddbe0d0e374d05e7003e662bba1742dbae&end=2a8dbdb1e2d9f44e7971d9a70b41d4d86db0112f&stat=instructions:u): 1.2% on `full` builds of `ctfe-stress-4 check`
- Regression in enough benchmarks that this seems a genuine regression.

#### Improvements

Compress amount of hashed bytes for `isize` values in StableHasher [#93432](https://github.com/rust-lang/rust/issues/93432)
- Average relevant improvement: -1.4%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b3800860e123443ffada615538926beed6bc4f85&end=1be5c8f90912c446ecbdc405cbc4a89f9acd20fd&stat=instructions:u): -6.6% on `incr-full` builds of `clap-rs check`
- Restoring parts of a previously landed and reverted optimization.

use `fold_list` in `try_super_fold_with` for `SubstsRef` [#93643](https://github.com/rust-lang/rust/issues/93643)
- Average relevant improvement: -1.1%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=25b21a1d160013b2d58c98d0337c75a721317160&end=926e7843eaa1794f15948395588eddedfb74a0d8&stat=instructions:u): -2.7% on `full` builds of `keccak check`


#### Mixed

Make dead code check a query. [#93466](https://github.com/rust-lang/rust/issues/93466)
- Average relevant regression: 0.9%
- Average relevant improvement: -0.8%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1ea4851715893ee3f365a8ef09d47165e9a7864f&end=d5f9c40e6a9ecc62432e71e886cef83a4c2c9b98&stat=instructions:u): -3.1% on `incr-unchanged` builds of `match-stress-enum check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1ea4851715893ee3f365a8ef09d47165e9a7864f&end=d5f9c40e6a9ecc62432e71e886cef83a4c2c9b98&stat=instructions:u): 1.6% on `incr-patched: dummy fn` builds of `unused-warnings check`
- Majority of the improvement limited to incr-unchanged benchmark. Regressions
  are relatively small and predominantly in stress tests, though also in
  style-servo incremental patched test cases.

Return an indexmap in `all_local_trait_impls` query [#93312](https://github.com/rust-lang/rust/issues/93312)
- Average relevant regression: 0.6%
- Average relevant improvement: -0.9%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=dca1e7aa5a8ac05ddaea731f4eab20de91acb46b&end=7cd14d2f561a61e9838546f133afcf06038d761b&stat=instructions:u): -1.1% on `incr-unchanged` builds of `ctfe-stress-4 check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=dca1e7aa5a8ac05ddaea731f4eab20de91acb46b&end=7cd14d2f561a61e9838546f133afcf06038d761b&stat=instructions:u): 0.8% on `incr-unchanged` builds of `cranelift-codegen check`
- Largely performance-neutral, but change is motivated by (future) correctness
  around DefId not implementing Ord rather than performance.

Optimize `core::str::Chars::count` [#90414](https://github.com/rust-lang/rust/issues/90414)
- Average relevant regression: 0.4%
- Average relevant improvement: -0.9%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e069a711084b5617aecda7a5c8e88406ca12ed65&end=f624427f8771c00819684c783bb841bf72095704&stat=instructions:u): -1.4% on `incr-unchanged` builds of `encoding check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e069a711084b5617aecda7a5c8e88406ca12ed65&end=f624427f8771c00819684c783bb841bf72095704&stat=instructions:u): 0.5% on `incr-full` builds of `html5ever debug`
- Results do not suggest improvements or regressions are directly tied to this
  PR, so seems likely to be optimizer noise.

Fix invalid special casing of the unreachable! macro [#93179](https://github.com/rust-lang/rust/issues/93179)
- Average relevant improvement: -1.2%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7b43cfc9b25ac4a906bd56d32d3111085dd9e6a1&end=25b21a1d160013b2d58c98d0337c75a721317160&stat=instructions:u): -2.2% on `full` builds of `cranelift-codegen check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=7b43cfc9b25ac4a906bd56d32d3111085dd9e6a1&end=25b21a1d160013b2d58c98d0337c75a721317160&stat=instructions:u): 1.8% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo debug`
- Regression appears to be due to codegen unit reshuffling, not directly coupled
  to the changes in this PR.

Make io::Error use 64 bits on targets with 64 bit pointers. [#87869](https://github.com/rust-lang/rust/issues/87869)
- Average relevant regression: 3.4%
- Average relevant improvement: -1.1%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f52c31840df7ec9c9350baff51a8964b20b5e1ba&end=734368a200904ef9c21db86c595dc04263c87be0&stat=instructions:u): -4.3% on `full` builds of `piston-image opt`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f52c31840df7ec9c9350baff51a8964b20b5e1ba&end=734368a200904ef9c21db86c595dc04263c87be0&stat=instructions:u): 11.2% on `full` builds of `issue-46449 opt`
- As noted on the PR thread, likely limited to just one benchmark that is not
  checking for this performance specifically regardless.

#### Untriaged Pull Requests

- [#93466 Make dead code check a query.](https://github.com/rust-lang/rust/pull/93466)
- [#93312 Return an indexmap in `all_local_trait_impls` query](https://github.com/rust-lang/rust/pull/93312)
- [#93288 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/93288)
- [#93179 Fix invalid special casing of the unreachable! macro](https://github.com/rust-lang/rust/pull/93179)
- [#93154 debuginfo: Make sure that type names for closure and generator environments are unique in debuginfo.](https://github.com/rust-lang/rust/pull/93154)
- [#93138 Rollup of 17 pull requests](https://github.com/rust-lang/rust/pull/93138)
- [#93095 Store a `Symbol` instead of an `Ident` in `AssocItem`](https://github.com/rust-lang/rust/pull/93095)
- [#92896 Update some rustc dependencies to deduplicate them](https://github.com/rust-lang/rust/pull/92896)
- [#92844 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/92844)
- [#92816 Remove deprecated LLVM-style inline assembly](https://github.com/rust-lang/rust/pull/92816)
- [#92805 partially revertish `lazily "compute" anon const default substs`](https://github.com/rust-lang/rust/pull/92805)
- [#92535 Allow unwinding from OOM hooks](https://github.com/rust-lang/rust/pull/92535)
- [#92534 Hash `Ident` spans in all HIR structures](https://github.com/rust-lang/rust/pull/92534)
- [#92356 Add {Add,Sub,Mul,Div,Rem,BitXor,BitOr,BitAnd}{,Assign}<$t> to Saturat…](https://github.com/rust-lang/rust/pull/92356)
- [#92277 rustc_metadata: Stop passing `CrateMetadataRef` by reference (step 1)](https://github.com/rust-lang/rust/pull/92277)
- [#92252 Update pulldown-cmark version to 0.9](https://github.com/rust-lang/rust/pull/92252)
- [#92229 Do not display `~const Drop` in rustdoc](https://github.com/rust-lang/rust/pull/92229)
- [#92227 Rustdoc: use `is_doc_hidden` method on more places](https://github.com/rust-lang/rust/pull/92227)
- [#92149 Fix bad caching of `~const Drop` bounds](https://github.com/rust-lang/rust/pull/92149)
- [#92135 Add `#[inline]` modifier to `TypeId::of`](https://github.com/rust-lang/rust/pull/92135)
- [#92110 Backport LLVM changes to disable deferred inlining](https://github.com/rust-lang/rust/pull/92110)
- [#92106 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/92106)
- [#92088 intra-doc: Use an enum to represent URL fragments](https://github.com/rust-lang/rust/pull/92088)
- [#92064 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92064)
- [#92062 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92062)
- [#92041 Remove 'speculative evaluation' of predicates](https://github.com/rust-lang/rust/pull/92041)
- [#92007 Lazy type-alias-impl-trait](https://github.com/rust-lang/rust/pull/92007)
- [#92003 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92003)
- [#91996 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91996)
- [#91959 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91959)
