# 2022-01-18 Triage Log

Quiet week for regular rustc performance; incremental builds
(particularly ones with little recompilation to do) saw an average 1.5%
improvement. rustdoc also saw several notable optimizations land which improve
performance, particularly on larger benchmarks.

Triage done by **@simulacrum**.
Revision range: [72e74d7b9cf1a7901650227e74650f1fcc797600..7bc7be860f99f4a40d45b0f74e2d01b02e072357](https://perf.rust-lang.org/?start=72e74d7b9cf1a7901650227e74650f1fcc797600&end=7bc7be860f99f4a40d45b0f74e2d01b02e072357&absolute=false&stat=instructions%3Au)

3 Regressions, 5 Improvements, 2 Mixed; 2 of them in rollups
30 comparisons made in total

#### Regressions

Rollup of 9 pull requests [#92844](https://github.com/rust-lang/rust/issues/92844)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=22e491ac7ed454d34669151a8b6464cb643c9b41&end=f312a5e610d47601e9a3da828002f5e1ffeb272a&stat=instructions:u) (up to 8.2% on `full` builds of `keccak check`)
- Unknown cause, though suspected to be [#92006](https://github.com/rust-lang/rust/pull/92006).
  This may also be due to sensitivity in keccak and similar benchmarks to
  a particularly hot loop in the compiler, which sometimes is less nicely
  compiled by LLVM. (See [#92816 (comment)](https://github.com/rust-lang/rust/pull/92816#issuecomment-1014938273)
  for details).

Add {Add,Sub,Mul,Div,Rem,BitXor,BitOr,BitAnd}{,Assign}<$t> to Saturat… [#92356](https://github.com/rust-lang/rust/issues/92356)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a0984b4e4c908d714cebd0f0786c00645ea4d79a&end=26c06cf8e27e5fa06b4894f14588c187510bae47&stat=instructions:u) (up to 2.8% on `full` builds of `helloworld doc`)
- Expected regression in documentation builds; there's just more to document.

Rollup of 10 pull requests [#92970](https://github.com/rust-lang/rust/issues/92970)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=48e89b00caa94829a5f07e0f1ecb33bf37431244&end=bd3cb52565faab2755ff1bdb54d88bc91f47b4b9&stat=instructions:u) (up to 0.9% on `incr-unchanged` builds of `externs opt`)
- Unclear cause, but regression is relatively small and limited to just one
  benchmark.

#### Improvements

Migrate rustdoc from Tera to Askama [#92526](https://github.com/rust-lang/rust/issues/92526)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=124555a69e5f65173ec7840000eb8e953d046740&end=e916815d21e37af5cd85f9eb67cda155d7129fff&stat=instructions:u) (up to -30.7% on `full` builds of `externs doc`)
- Major improvement in instruction counts for rustdoc; a less significant win on
  wall time for most benchmarks, though particularly heavy ones (e.g., stm32f4)
  do see a sizeable improvement of around 10% less wall time.


Introduce new `TaskDepsRef` enum to track allow/ignore/forbid status [#92681](https://github.com/rust-lang/rust/issues/92681)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=86f7f78f05ff8295aad2ad2a31770ce4408cc849&end=02c9e73e6ca7e2bd444d39182f8dee7e2ba4a609&stat=instructions:u) (up to -1.4% on `incr-unchanged` builds of `externs debug`)
- Small, across the board improvement for incremental benchmarks.


rustdoc: avoid many `Symbol` to `String` conversions. [#91948](https://github.com/rust-lang/rust/issues/91948)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=ad46af24713115e7b9b258346e66b9b2d14eacfc&end=b0ec3e09a996f2cb35be7710fd1003c3c38f1667&stat=instructions:u) (up to -5.5% on `full` builds of `issue-46449 doc`)


Optimize `impl_read_unsigned_leb128` [#92604](https://github.com/rust-lang/rust/issues/92604)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=69d25fc58257637cedbfe0a046d90da1494bcb05&end=38c22af0153cf8f920c01ef04493e8878401fd18&stat=instructions:u) (up to -3.6% on `full` builds of `helloworld doc`)


Reduce use of LocalDefId <-> HirId maps [#90146](https://github.com/rust-lang/rust/issues/90146)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=ec4bcaac450279b029f3480b8b8f1b82ab36a5eb&end=f9d61cd2eda81b595862635914bd0224402a4a26&stat=instructions:u) (up to -2.4% on `incr-patched: minor change` builds of `tokio-webpush-simple debug`)

rustc_metadata: Switch all decoder methods from vectors to iterators [#92245](https://github.com/rust-lang/rust/issues/92245)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7be8693984d32d2f65ce9ded4f65b6b7340bddce&end=48e89b00caa94829a5f07e0f1ecb33bf37431244&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `cranelift-codegen check`)

#### Mixed

partially revertish `lazily "compute" anon const default substs` [#92805](https://github.com/rust-lang/rust/issues/92805)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=42852d7857d2955f19ec333bec1ed107964db200&end=7be8693984d32d2f65ce9ded4f65b6b7340bddce&stat=instructions:u) (up to -1.4% on `full` builds of `deeply-nested-async check`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=42852d7857d2955f19ec333bec1ed107964db200&end=7be8693984d32d2f65ce9ded4f65b6b7340bddce&stat=instructions:u) (up to 0.9% on `incr-unchanged` builds of `clap-rs check`)


Remove deprecated LLVM-style inline assembly [#92816](https://github.com/rust-lang/rust/issues/92816)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=128417f40f80ce585414bf5a017540447e6be775&end=a34c0797528172ede89480e3033f7a5e71ea4735&stat=instructions:u) (up to -7.5% on `full` builds of `keccak check`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=128417f40f80ce585414bf5a017540447e6be775&end=a34c0797528172ede89480e3033f7a5e71ea4735&stat=instructions:u) (up to 1.0% on `incr-unchanged` builds of `ctfe-stress-4 check`)
