#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum DecompositionType {
  Canonical, Compat, Circle, Final, Font, Fraction, Initial, Isolated, Medial,
  Narrow, Nobreak, Small, Square, Sub, Super, Vertical, Wide
}

pub static UCD_DECOMP_TYPE: &'static [((u8,u8,u8), (u8,u8,u8), DecompositionType)] = &[
  ((0,0,160),(0,0,160),DecompositionType::Nobreak),
  ((0,0,168),(0,0,168),DecompositionType::Compat),
  ((0,0,170),(0,0,170),DecompositionType::Super),
  ((0,0,175),(0,0,175),DecompositionType::Compat),
  ((0,0,178),(0,0,179),DecompositionType::Super),
  ((0,0,180),(0,0,181),DecompositionType::Compat),
  ((0,0,184),(0,0,184),DecompositionType::Compat),
  ((0,0,185),(0,0,186),DecompositionType::Super),
  ((0,0,188),(0,0,190),DecompositionType::Fraction),
  ((0,0,192),(0,0,197),DecompositionType::Canonical),
  ((0,0,199),(0,0,207),DecompositionType::Canonical),
  ((0,0,209),(0,0,214),DecompositionType::Canonical),
  ((0,0,217),(0,0,221),DecompositionType::Canonical),
  ((0,0,224),(0,0,229),DecompositionType::Canonical),
  ((0,0,231),(0,0,239),DecompositionType::Canonical),
  ((0,0,241),(0,0,246),DecompositionType::Canonical),
  ((0,0,249),(0,0,253),DecompositionType::Canonical),
  ((0,0,255),(0,1,15),DecompositionType::Canonical),
  ((0,1,18),(0,1,37),DecompositionType::Canonical),
  ((0,1,40),(0,1,48),DecompositionType::Canonical),
  ((0,1,50),(0,1,51),DecompositionType::Compat),
  ((0,1,52),(0,1,55),DecompositionType::Canonical),
  ((0,1,57),(0,1,62),DecompositionType::Canonical),
  ((0,1,63),(0,1,64),DecompositionType::Compat),
  ((0,1,67),(0,1,72),DecompositionType::Canonical),
  ((0,1,73),(0,1,73),DecompositionType::Compat),
  ((0,1,76),(0,1,81),DecompositionType::Canonical),
  ((0,1,84),(0,1,101),DecompositionType::Canonical),
  ((0,1,104),(0,1,126),DecompositionType::Canonical),
  ((0,1,127),(0,1,127),DecompositionType::Compat),
  ((0,1,160),(0,1,161),DecompositionType::Canonical),
  ((0,1,175),(0,1,176),DecompositionType::Canonical),
  ((0,1,196),(0,1,204),DecompositionType::Compat),
  ((0,1,205),(0,1,220),DecompositionType::Canonical),
  ((0,1,222),(0,1,227),DecompositionType::Canonical),
  ((0,1,230),(0,1,240),DecompositionType::Canonical),
  ((0,1,241),(0,1,243),DecompositionType::Compat),
  ((0,1,244),(0,1,245),DecompositionType::Canonical),
  ((0,1,248),(0,2,27),DecompositionType::Canonical),
  ((0,2,30),(0,2,31),DecompositionType::Canonical),
  ((0,2,38),(0,2,51),DecompositionType::Canonical),
  ((0,2,176),(0,2,184),DecompositionType::Super),
  ((0,2,216),(0,2,221),DecompositionType::Compat),
  ((0,2,224),(0,2,228),DecompositionType::Super),
  ((0,3,64),(0,3,65),DecompositionType::Canonical),
  ((0,3,67),(0,3,68),DecompositionType::Canonical),
  ((0,3,116),(0,3,116),DecompositionType::Canonical),
  ((0,3,122),(0,3,122),DecompositionType::Compat),
  ((0,3,126),(0,3,126),DecompositionType::Canonical),
  ((0,3,132),(0,3,132),DecompositionType::Compat),
  ((0,3,133),(0,3,138),DecompositionType::Canonical),
  ((0,3,140),(0,3,140),DecompositionType::Canonical),
  ((0,3,142),(0,3,144),DecompositionType::Canonical),
  ((0,3,170),(0,3,176),DecompositionType::Canonical),
  ((0,3,202),(0,3,206),DecompositionType::Canonical),
  ((0,3,208),(0,3,210),DecompositionType::Compat),
  ((0,3,211),(0,3,212),DecompositionType::Canonical),
  ((0,3,213),(0,3,214),DecompositionType::Compat),
  ((0,3,240),(0,3,242),DecompositionType::Compat),
  ((0,3,244),(0,3,245),DecompositionType::Compat),
  ((0,3,249),(0,3,249),DecompositionType::Compat),
  ((0,4,0),(0,4,1),DecompositionType::Canonical),
  ((0,4,3),(0,4,3),DecompositionType::Canonical),
  ((0,4,7),(0,4,7),DecompositionType::Canonical),
  ((0,4,12),(0,4,14),DecompositionType::Canonical),
  ((0,4,25),(0,4,25),DecompositionType::Canonical),
  ((0,4,57),(0,4,57),DecompositionType::Canonical),
  ((0,4,80),(0,4,81),DecompositionType::Canonical),
  ((0,4,83),(0,4,83),DecompositionType::Canonical),
  ((0,4,87),(0,4,87),DecompositionType::Canonical),
  ((0,4,92),(0,4,94),DecompositionType::Canonical),
  ((0,4,118),(0,4,119),DecompositionType::Canonical),
  ((0,4,193),(0,4,194),DecompositionType::Canonical),
  ((0,4,208),(0,4,211),DecompositionType::Canonical),
  ((0,4,214),(0,4,215),DecompositionType::Canonical),
  ((0,4,218),(0,4,223),DecompositionType::Canonical),
  ((0,4,226),(0,4,231),DecompositionType::Canonical),
  ((0,4,234),(0,4,245),DecompositionType::Canonical),
  ((0,4,248),(0,4,249),DecompositionType::Canonical),
  ((0,5,135),(0,5,135),DecompositionType::Compat),
  ((0,6,34),(0,6,38),DecompositionType::Canonical),
  ((0,6,117),(0,6,120),DecompositionType::Compat),
  ((0,6,192),(0,6,192),DecompositionType::Canonical),
  ((0,6,194),(0,6,194),DecompositionType::Canonical),
  ((0,6,211),(0,6,211),DecompositionType::Canonical),
  ((0,9,41),(0,9,41),DecompositionType::Canonical),
  ((0,9,49),(0,9,49),DecompositionType::Canonical),
  ((0,9,52),(0,9,52),DecompositionType::Canonical),
  ((0,9,88),(0,9,95),DecompositionType::Canonical),
  ((0,9,203),(0,9,204),DecompositionType::Canonical),
  ((0,9,220),(0,9,221),DecompositionType::Canonical),
  ((0,9,223),(0,9,223),DecompositionType::Canonical),
  ((0,10,51),(0,10,51),DecompositionType::Canonical),
  ((0,10,54),(0,10,54),DecompositionType::Canonical),
  ((0,10,89),(0,10,91),DecompositionType::Canonical),
  ((0,10,94),(0,10,94),DecompositionType::Canonical),
  ((0,11,72),(0,11,72),DecompositionType::Canonical),
  ((0,11,75),(0,11,76),DecompositionType::Canonical),
  ((0,11,92),(0,11,93),DecompositionType::Canonical),
  ((0,11,148),(0,11,148),DecompositionType::Canonical),
  ((0,11,202),(0,11,204),DecompositionType::Canonical),
  ((0,12,72),(0,12,72),DecompositionType::Canonical),
  ((0,12,192),(0,12,192),DecompositionType::Canonical),
  ((0,12,199),(0,12,200),DecompositionType::Canonical),
  ((0,12,202),(0,12,203),DecompositionType::Canonical),
  ((0,13,74),(0,13,76),DecompositionType::Canonical),
  ((0,13,218),(0,13,218),DecompositionType::Canonical),
  ((0,13,220),(0,13,222),DecompositionType::Canonical),
  ((0,14,51),(0,14,51),DecompositionType::Compat),
  ((0,14,179),(0,14,179),DecompositionType::Compat),
  ((0,14,220),(0,14,221),DecompositionType::Compat),
  ((0,15,12),(0,15,12),DecompositionType::Nobreak),
  ((0,15,67),(0,15,67),DecompositionType::Canonical),
  ((0,15,77),(0,15,77),DecompositionType::Canonical),
  ((0,15,82),(0,15,82),DecompositionType::Canonical),
  ((0,15,87),(0,15,87),DecompositionType::Canonical),
  ((0,15,92),(0,15,92),DecompositionType::Canonical),
  ((0,15,105),(0,15,105),DecompositionType::Canonical),
  ((0,15,115),(0,15,115),DecompositionType::Canonical),
  ((0,15,117),(0,15,118),DecompositionType::Canonical),
  ((0,15,119),(0,15,119),DecompositionType::Compat),
  ((0,15,120),(0,15,120),DecompositionType::Canonical),
  ((0,15,121),(0,15,121),DecompositionType::Compat),
  ((0,15,129),(0,15,129),DecompositionType::Canonical),
  ((0,15,147),(0,15,147),DecompositionType::Canonical),
  ((0,15,157),(0,15,157),DecompositionType::Canonical),
  ((0,15,162),(0,15,162),DecompositionType::Canonical),
  ((0,15,167),(0,15,167),DecompositionType::Canonical),
  ((0,15,172),(0,15,172),DecompositionType::Canonical),
  ((0,15,185),(0,15,185),DecompositionType::Canonical),
  ((0,16,38),(0,16,38),DecompositionType::Canonical),
  ((0,16,252),(0,16,252),DecompositionType::Super),
  ((0,27,6),(0,27,6),DecompositionType::Canonical),
  ((0,27,8),(0,27,8),DecompositionType::Canonical),
  ((0,27,10),(0,27,10),DecompositionType::Canonical),
  ((0,27,12),(0,27,12),DecompositionType::Canonical),
  ((0,27,14),(0,27,14),DecompositionType::Canonical),
  ((0,27,18),(0,27,18),DecompositionType::Canonical),
  ((0,27,59),(0,27,59),DecompositionType::Canonical),
  ((0,27,61),(0,27,61),DecompositionType::Canonical),
  ((0,27,64),(0,27,65),DecompositionType::Canonical),
  ((0,27,67),(0,27,67),DecompositionType::Canonical),
  ((0,29,44),(0,29,46),DecompositionType::Super),
  ((0,29,48),(0,29,58),DecompositionType::Super),
  ((0,29,60),(0,29,77),DecompositionType::Super),
  ((0,29,79),(0,29,97),DecompositionType::Super),
  ((0,29,98),(0,29,106),DecompositionType::Sub),
  ((0,29,120),(0,29,120),DecompositionType::Super),
  ((0,29,155),(0,29,191),DecompositionType::Super),
  ((0,30,0),(0,30,153),DecompositionType::Canonical),
  ((0,30,154),(0,30,154),DecompositionType::Compat),
  ((0,30,155),(0,30,155),DecompositionType::Canonical),
  ((0,30,160),(0,30,249),DecompositionType::Canonical),
  ((0,31,0),(0,31,21),DecompositionType::Canonical),
  ((0,31,24),(0,31,29),DecompositionType::Canonical),
  ((0,31,32),(0,31,69),DecompositionType::Canonical),
  ((0,31,72),(0,31,77),DecompositionType::Canonical),
  ((0,31,80),(0,31,87),DecompositionType::Canonical),
  ((0,31,89),(0,31,89),DecompositionType::Canonical),
  ((0,31,91),(0,31,91),DecompositionType::Canonical),
  ((0,31,93),(0,31,93),DecompositionType::Canonical),
  ((0,31,95),(0,31,125),DecompositionType::Canonical),
  ((0,31,128),(0,31,180),DecompositionType::Canonical),
  ((0,31,182),(0,31,188),DecompositionType::Canonical),
  ((0,31,189),(0,31,189),DecompositionType::Compat),
  ((0,31,190),(0,31,190),DecompositionType::Canonical),
  ((0,31,191),(0,31,192),DecompositionType::Compat),
  ((0,31,193),(0,31,196),DecompositionType::Canonical),
  ((0,31,198),(0,31,211),DecompositionType::Canonical),
  ((0,31,214),(0,31,219),DecompositionType::Canonical),
  ((0,31,221),(0,31,239),DecompositionType::Canonical),
  ((0,31,242),(0,31,244),DecompositionType::Canonical),
  ((0,31,246),(0,31,253),DecompositionType::Canonical),
  ((0,31,254),(0,31,254),DecompositionType::Compat),
  ((0,32,0),(0,32,1),DecompositionType::Canonical),
  ((0,32,2),(0,32,6),DecompositionType::Compat),
  ((0,32,7),(0,32,7),DecompositionType::Nobreak),
  ((0,32,8),(0,32,10),DecompositionType::Compat),
  ((0,32,17),(0,32,17),DecompositionType::Nobreak),
  ((0,32,23),(0,32,23),DecompositionType::Compat),
  ((0,32,36),(0,32,38),DecompositionType::Compat),
  ((0,32,47),(0,32,47),DecompositionType::Nobreak),
  ((0,32,51),(0,32,52),DecompositionType::Compat),
  ((0,32,54),(0,32,55),DecompositionType::Compat),
  ((0,32,60),(0,32,60),DecompositionType::Compat),
  ((0,32,62),(0,32,62),DecompositionType::Compat),
  ((0,32,71),(0,32,73),DecompositionType::Compat),
  ((0,32,87),(0,32,87),DecompositionType::Compat),
  ((0,32,95),(0,32,95),DecompositionType::Compat),
  ((0,32,112),(0,32,113),DecompositionType::Super),
  ((0,32,116),(0,32,127),DecompositionType::Super),
  ((0,32,128),(0,32,142),DecompositionType::Sub),
  ((0,32,144),(0,32,156),DecompositionType::Sub),
  ((0,32,168),(0,32,168),DecompositionType::Compat),
  ((0,33,0),(0,33,1),DecompositionType::Compat),
  ((0,33,2),(0,33,2),DecompositionType::Font),
  ((0,33,3),(0,33,3),DecompositionType::Compat),
  ((0,33,5),(0,33,7),DecompositionType::Compat),
  ((0,33,9),(0,33,9),DecompositionType::Compat),
  ((0,33,10),(0,33,19),DecompositionType::Font),
  ((0,33,21),(0,33,21),DecompositionType::Font),
  ((0,33,22),(0,33,22),DecompositionType::Compat),
  ((0,33,25),(0,33,29),DecompositionType::Font),
  ((0,33,32),(0,33,32),DecompositionType::Super),
  ((0,33,33),(0,33,33),DecompositionType::Compat),
  ((0,33,34),(0,33,34),DecompositionType::Super),
  ((0,33,36),(0,33,36),DecompositionType::Font),
  ((0,33,38),(0,33,38),DecompositionType::Canonical),
  ((0,33,40),(0,33,40),DecompositionType::Font),
  ((0,33,42),(0,33,43),DecompositionType::Canonical),
  ((0,33,44),(0,33,45),DecompositionType::Font),
  ((0,33,47),(0,33,49),DecompositionType::Font),
  ((0,33,51),(0,33,52),DecompositionType::Font),
  ((0,33,53),(0,33,56),DecompositionType::Compat),
  ((0,33,57),(0,33,57),DecompositionType::Font),
  ((0,33,59),(0,33,59),DecompositionType::Compat),
  ((0,33,60),(0,33,64),DecompositionType::Font),
  ((0,33,69),(0,33,73),DecompositionType::Font),
  ((0,33,80),(0,33,95),DecompositionType::Fraction),
  ((0,33,96),(0,33,127),DecompositionType::Compat),
  ((0,33,137),(0,33,137),DecompositionType::Fraction),
  ((0,33,154),(0,33,155),DecompositionType::Canonical),
  ((0,33,174),(0,33,174),DecompositionType::Canonical),
  ((0,33,205),(0,33,207),DecompositionType::Canonical),
  ((0,34,4),(0,34,4),DecompositionType::Canonical),
  ((0,34,9),(0,34,9),DecompositionType::Canonical),
  ((0,34,12),(0,34,12),DecompositionType::Canonical),
  ((0,34,36),(0,34,36),DecompositionType::Canonical),
  ((0,34,38),(0,34,38),DecompositionType::Canonical),
  ((0,34,44),(0,34,45),DecompositionType::Compat),
  ((0,34,47),(0,34,48),DecompositionType::Compat),
  ((0,34,65),(0,34,65),DecompositionType::Canonical),
  ((0,34,68),(0,34,68),DecompositionType::Canonical),
  ((0,34,71),(0,34,71),DecompositionType::Canonical),
  ((0,34,73),(0,34,73),DecompositionType::Canonical),
  ((0,34,96),(0,34,96),DecompositionType::Canonical),
  ((0,34,98),(0,34,98),DecompositionType::Canonical),
  ((0,34,109),(0,34,113),DecompositionType::Canonical),
  ((0,34,116),(0,34,117),DecompositionType::Canonical),
  ((0,34,120),(0,34,121),DecompositionType::Canonical),
  ((0,34,128),(0,34,129),DecompositionType::Canonical),
  ((0,34,132),(0,34,133),DecompositionType::Canonical),
  ((0,34,136),(0,34,137),DecompositionType::Canonical),
  ((0,34,172),(0,34,175),DecompositionType::Canonical),
  ((0,34,224),(0,34,227),DecompositionType::Canonical),
  ((0,34,234),(0,34,237),DecompositionType::Canonical),
  ((0,35,41),(0,35,42),DecompositionType::Canonical),
  ((0,36,96),(0,36,115),DecompositionType::Circle),
  ((0,36,116),(0,36,181),DecompositionType::Compat),
  ((0,36,182),(0,36,234),DecompositionType::Circle),
  ((0,42,12),(0,42,12),DecompositionType::Compat),
  ((0,42,116),(0,42,118),DecompositionType::Compat),
  ((0,42,220),(0,42,220),DecompositionType::Canonical),
  ((0,44,124),(0,44,124),DecompositionType::Sub),
  ((0,44,125),(0,44,125),DecompositionType::Super),
  ((0,45,111),(0,45,111),DecompositionType::Super),
  ((0,46,159),(0,46,159),DecompositionType::Compat),
  ((0,46,243),(0,46,243),DecompositionType::Compat),
  ((0,47,0),(0,47,213),DecompositionType::Compat),
  ((0,48,0),(0,48,0),DecompositionType::Wide),
  ((0,48,54),(0,48,54),DecompositionType::Compat),
  ((0,48,56),(0,48,58),DecompositionType::Compat),
  ((0,48,76),(0,48,76),DecompositionType::Canonical),
  ((0,48,78),(0,48,78),DecompositionType::Canonical),
  ((0,48,80),(0,48,80),DecompositionType::Canonical),
  ((0,48,82),(0,48,82),DecompositionType::Canonical),
  ((0,48,84),(0,48,84),DecompositionType::Canonical),
  ((0,48,86),(0,48,86),DecompositionType::Canonical),
  ((0,48,88),(0,48,88),DecompositionType::Canonical),
  ((0,48,90),(0,48,90),DecompositionType::Canonical),
  ((0,48,92),(0,48,92),DecompositionType::Canonical),
  ((0,48,94),(0,48,94),DecompositionType::Canonical),
  ((0,48,96),(0,48,96),DecompositionType::Canonical),
  ((0,48,98),(0,48,98),DecompositionType::Canonical),
  ((0,48,101),(0,48,101),DecompositionType::Canonical),
  ((0,48,103),(0,48,103),DecompositionType::Canonical),
  ((0,48,105),(0,48,105),DecompositionType::Canonical),
  ((0,48,112),(0,48,113),DecompositionType::Canonical),
  ((0,48,115),(0,48,116),DecompositionType::Canonical),
  ((0,48,118),(0,48,119),DecompositionType::Canonical),
  ((0,48,121),(0,48,122),DecompositionType::Canonical),
  ((0,48,124),(0,48,125),DecompositionType::Canonical),
  ((0,48,148),(0,48,148),DecompositionType::Canonical),
  ((0,48,155),(0,48,156),DecompositionType::Compat),
  ((0,48,158),(0,48,158),DecompositionType::Canonical),
  ((0,48,159),(0,48,159),DecompositionType::Vertical),
  ((0,48,172),(0,48,172),DecompositionType::Canonical),
  ((0,48,174),(0,48,174),DecompositionType::Canonical),
  ((0,48,176),(0,48,176),DecompositionType::Canonical),
  ((0,48,178),(0,48,178),DecompositionType::Canonical),
  ((0,48,180),(0,48,180),DecompositionType::Canonical),
  ((0,48,182),(0,48,182),DecompositionType::Canonical),
  ((0,48,184),(0,48,184),DecompositionType::Canonical),
  ((0,48,186),(0,48,186),DecompositionType::Canonical),
  ((0,48,188),(0,48,188),DecompositionType::Canonical),
  ((0,48,190),(0,48,190),DecompositionType::Canonical),
  ((0,48,192),(0,48,192),DecompositionType::Canonical),
  ((0,48,194),(0,48,194),DecompositionType::Canonical),
  ((0,48,197),(0,48,197),DecompositionType::Canonical),
  ((0,48,199),(0,48,199),DecompositionType::Canonical),
  ((0,48,201),(0,48,201),DecompositionType::Canonical),
  ((0,48,208),(0,48,209),DecompositionType::Canonical),
  ((0,48,211),(0,48,212),DecompositionType::Canonical),
  ((0,48,214),(0,48,215),DecompositionType::Canonical),
  ((0,48,217),(0,48,218),DecompositionType::Canonical),
  ((0,48,220),(0,48,221),DecompositionType::Canonical),
  ((0,48,244),(0,48,244),DecompositionType::Canonical),
  ((0,48,247),(0,48,250),DecompositionType::Canonical),
  ((0,48,254),(0,48,254),DecompositionType::Canonical),
  ((0,48,255),(0,48,255),DecompositionType::Vertical),
  ((0,49,49),(0,49,142),DecompositionType::Compat),
  ((0,49,146),(0,49,159),DecompositionType::Super),
  ((0,50,0),(0,50,30),DecompositionType::Compat),
  ((0,50,32),(0,50,67),DecompositionType::Compat),
  ((0,50,68),(0,50,71),DecompositionType::Circle),
  ((0,50,80),(0,50,80),DecompositionType::Square),
  ((0,50,81),(0,50,126),DecompositionType::Circle),
  ((0,50,128),(0,50,191),DecompositionType::Circle),
  ((0,50,192),(0,50,203),DecompositionType::Compat),
  ((0,50,204),(0,50,207),DecompositionType::Square),
  ((0,50,208),(0,50,254),DecompositionType::Circle),
  ((0,51,0),(0,51,87),DecompositionType::Square),
  ((0,51,88),(0,51,112),DecompositionType::Compat),
  ((0,51,113),(0,51,223),DecompositionType::Square),
  ((0,51,224),(0,51,254),DecompositionType::Compat),
  ((0,51,255),(0,51,255),DecompositionType::Square),
  ((0,166,156),(0,166,157),DecompositionType::Super),
  ((0,167,112),(0,167,112),DecompositionType::Super),
  ((0,167,248),(0,167,249),DecompositionType::Super),
  ((0,171,92),(0,171,95),DecompositionType::Super),
  ((0,172,0),(0,215,163),DecompositionType::Canonical),
  ((0,249,0),(0,250,13),DecompositionType::Canonical),
  ((0,250,16),(0,250,16),DecompositionType::Canonical),
  ((0,250,18),(0,250,18),DecompositionType::Canonical),
  ((0,250,21),(0,250,30),DecompositionType::Canonical),
  ((0,250,32),(0,250,32),DecompositionType::Canonical),
  ((0,250,34),(0,250,34),DecompositionType::Canonical),
  ((0,250,37),(0,250,38),DecompositionType::Canonical),
  ((0,250,42),(0,250,109),DecompositionType::Canonical),
  ((0,250,112),(0,250,217),DecompositionType::Canonical),
  ((0,251,0),(0,251,6),DecompositionType::Compat),
  ((0,251,19),(0,251,23),DecompositionType::Compat),
  ((0,251,29),(0,251,29),DecompositionType::Canonical),
  ((0,251,31),(0,251,31),DecompositionType::Canonical),
  ((0,251,32),(0,251,41),DecompositionType::Font),
  ((0,251,42),(0,251,54),DecompositionType::Canonical),
  ((0,251,56),(0,251,60),DecompositionType::Canonical),
  ((0,251,62),(0,251,62),DecompositionType::Canonical),
  ((0,251,64),(0,251,65),DecompositionType::Canonical),
  ((0,251,67),(0,251,68),DecompositionType::Canonical),
  ((0,251,70),(0,251,78),DecompositionType::Canonical),
  ((0,251,79),(0,251,79),DecompositionType::Compat),
  ((0,251,80),(0,251,80),DecompositionType::Isolated),
  ((0,251,81),(0,251,81),DecompositionType::Final),
  ((0,251,82),(0,251,82),DecompositionType::Isolated),
  ((0,251,83),(0,251,83),DecompositionType::Final),
  ((0,251,84),(0,251,84),DecompositionType::Initial),
  ((0,251,85),(0,251,85),DecompositionType::Medial),
  ((0,251,86),(0,251,86),DecompositionType::Isolated),
  ((0,251,87),(0,251,87),DecompositionType::Final),
  ((0,251,88),(0,251,88),DecompositionType::Initial),
  ((0,251,89),(0,251,89),DecompositionType::Medial),
  ((0,251,90),(0,251,90),DecompositionType::Isolated),
  ((0,251,91),(0,251,91),DecompositionType::Final),
  ((0,251,92),(0,251,92),DecompositionType::Initial),
  ((0,251,93),(0,251,93),DecompositionType::Medial),
  ((0,251,94),(0,251,94),DecompositionType::Isolated),
  ((0,251,95),(0,251,95),DecompositionType::Final),
  ((0,251,96),(0,251,96),DecompositionType::Initial),
  ((0,251,97),(0,251,97),DecompositionType::Medial),
  ((0,251,98),(0,251,98),DecompositionType::Isolated),
  ((0,251,99),(0,251,99),DecompositionType::Final),
  ((0,251,100),(0,251,100),DecompositionType::Initial),
  ((0,251,101),(0,251,101),DecompositionType::Medial),
  ((0,251,102),(0,251,102),DecompositionType::Isolated),
  ((0,251,103),(0,251,103),DecompositionType::Final),
  ((0,251,104),(0,251,104),DecompositionType::Initial),
  ((0,251,105),(0,251,105),DecompositionType::Medial),
  ((0,251,106),(0,251,106),DecompositionType::Isolated),
  ((0,251,107),(0,251,107),DecompositionType::Final),
  ((0,251,108),(0,251,108),DecompositionType::Initial),
  ((0,251,109),(0,251,109),DecompositionType::Medial),
  ((0,251,110),(0,251,110),DecompositionType::Isolated),
  ((0,251,111),(0,251,111),DecompositionType::Final),
  ((0,251,112),(0,251,112),DecompositionType::Initial),
  ((0,251,113),(0,251,113),DecompositionType::Medial),
  ((0,251,114),(0,251,114),DecompositionType::Isolated),
  ((0,251,115),(0,251,115),DecompositionType::Final),
  ((0,251,116),(0,251,116),DecompositionType::Initial),
  ((0,251,117),(0,251,117),DecompositionType::Medial),
  ((0,251,118),(0,251,118),DecompositionType::Isolated),
  ((0,251,119),(0,251,119),DecompositionType::Final),
  ((0,251,120),(0,251,120),DecompositionType::Initial),
  ((0,251,121),(0,251,121),DecompositionType::Medial),
  ((0,251,122),(0,251,122),DecompositionType::Isolated),
  ((0,251,123),(0,251,123),DecompositionType::Final),
  ((0,251,124),(0,251,124),DecompositionType::Initial),
  ((0,251,125),(0,251,125),DecompositionType::Medial),
  ((0,251,126),(0,251,126),DecompositionType::Isolated),
  ((0,251,127),(0,251,127),DecompositionType::Final),
  ((0,251,128),(0,251,128),DecompositionType::Initial),
  ((0,251,129),(0,251,129),DecompositionType::Medial),
  ((0,251,130),(0,251,130),DecompositionType::Isolated),
  ((0,251,131),(0,251,131),DecompositionType::Final),
  ((0,251,132),(0,251,132),DecompositionType::Isolated),
  ((0,251,133),(0,251,133),DecompositionType::Final),
  ((0,251,134),(0,251,134),DecompositionType::Isolated),
  ((0,251,135),(0,251,135),DecompositionType::Final),
  ((0,251,136),(0,251,136),DecompositionType::Isolated),
  ((0,251,137),(0,251,137),DecompositionType::Final),
  ((0,251,138),(0,251,138),DecompositionType::Isolated),
  ((0,251,139),(0,251,139),DecompositionType::Final),
  ((0,251,140),(0,251,140),DecompositionType::Isolated),
  ((0,251,141),(0,251,141),DecompositionType::Final),
  ((0,251,142),(0,251,142),DecompositionType::Isolated),
  ((0,251,143),(0,251,143),DecompositionType::Final),
  ((0,251,144),(0,251,144),DecompositionType::Initial),
  ((0,251,145),(0,251,145),DecompositionType::Medial),
  ((0,251,146),(0,251,146),DecompositionType::Isolated),
  ((0,251,147),(0,251,147),DecompositionType::Final),
  ((0,251,148),(0,251,148),DecompositionType::Initial),
  ((0,251,149),(0,251,149),DecompositionType::Medial),
  ((0,251,150),(0,251,150),DecompositionType::Isolated),
  ((0,251,151),(0,251,151),DecompositionType::Final),
  ((0,251,152),(0,251,152),DecompositionType::Initial),
  ((0,251,153),(0,251,153),DecompositionType::Medial),
  ((0,251,154),(0,251,154),DecompositionType::Isolated),
  ((0,251,155),(0,251,155),DecompositionType::Final),
  ((0,251,156),(0,251,156),DecompositionType::Initial),
  ((0,251,157),(0,251,157),DecompositionType::Medial),
  ((0,251,158),(0,251,158),DecompositionType::Isolated),
  ((0,251,159),(0,251,159),DecompositionType::Final),
  ((0,251,160),(0,251,160),DecompositionType::Isolated),
  ((0,251,161),(0,251,161),DecompositionType::Final),
  ((0,251,162),(0,251,162),DecompositionType::Initial),
  ((0,251,163),(0,251,163),DecompositionType::Medial),
  ((0,251,164),(0,251,164),DecompositionType::Isolated),
  ((0,251,165),(0,251,165),DecompositionType::Final),
  ((0,251,166),(0,251,166),DecompositionType::Isolated),
  ((0,251,167),(0,251,167),DecompositionType::Final),
  ((0,251,168),(0,251,168),DecompositionType::Initial),
  ((0,251,169),(0,251,169),DecompositionType::Medial),
  ((0,251,170),(0,251,170),DecompositionType::Isolated),
  ((0,251,171),(0,251,171),DecompositionType::Final),
  ((0,251,172),(0,251,172),DecompositionType::Initial),
  ((0,251,173),(0,251,173),DecompositionType::Medial),
  ((0,251,174),(0,251,174),DecompositionType::Isolated),
  ((0,251,175),(0,251,175),DecompositionType::Final),
  ((0,251,176),(0,251,176),DecompositionType::Isolated),
  ((0,251,177),(0,251,177),DecompositionType::Final),
  ((0,251,211),(0,251,211),DecompositionType::Isolated),
  ((0,251,212),(0,251,212),DecompositionType::Final),
  ((0,251,213),(0,251,213),DecompositionType::Initial),
  ((0,251,214),(0,251,214),DecompositionType::Medial),
  ((0,251,215),(0,251,215),DecompositionType::Isolated),
  ((0,251,216),(0,251,216),DecompositionType::Final),
  ((0,251,217),(0,251,217),DecompositionType::Isolated),
  ((0,251,218),(0,251,218),DecompositionType::Final),
  ((0,251,219),(0,251,219),DecompositionType::Isolated),
  ((0,251,220),(0,251,220),DecompositionType::Final),
  ((0,251,221),(0,251,222),DecompositionType::Isolated),
  ((0,251,223),(0,251,223),DecompositionType::Final),
  ((0,251,224),(0,251,224),DecompositionType::Isolated),
  ((0,251,225),(0,251,225),DecompositionType::Final),
  ((0,251,226),(0,251,226),DecompositionType::Isolated),
  ((0,251,227),(0,251,227),DecompositionType::Final),
  ((0,251,228),(0,251,228),DecompositionType::Isolated),
  ((0,251,229),(0,251,229),DecompositionType::Final),
  ((0,251,230),(0,251,230),DecompositionType::Initial),
  ((0,251,231),(0,251,231),DecompositionType::Medial),
  ((0,251,232),(0,251,232),DecompositionType::Initial),
  ((0,251,233),(0,251,233),DecompositionType::Medial),
  ((0,251,234),(0,251,234),DecompositionType::Isolated),
  ((0,251,235),(0,251,235),DecompositionType::Final),
  ((0,251,236),(0,251,236),DecompositionType::Isolated),
  ((0,251,237),(0,251,237),DecompositionType::Final),
  ((0,251,238),(0,251,238),DecompositionType::Isolated),
  ((0,251,239),(0,251,239),DecompositionType::Final),
  ((0,251,240),(0,251,240),DecompositionType::Isolated),
  ((0,251,241),(0,251,241),DecompositionType::Final),
  ((0,251,242),(0,251,242),DecompositionType::Isolated),
  ((0,251,243),(0,251,243),DecompositionType::Final),
  ((0,251,244),(0,251,244),DecompositionType::Isolated),
  ((0,251,245),(0,251,245),DecompositionType::Final),
  ((0,251,246),(0,251,246),DecompositionType::Isolated),
  ((0,251,247),(0,251,247),DecompositionType::Final),
  ((0,251,248),(0,251,248),DecompositionType::Initial),
  ((0,251,249),(0,251,249),DecompositionType::Isolated),
  ((0,251,250),(0,251,250),DecompositionType::Final),
  ((0,251,251),(0,251,251),DecompositionType::Initial),
  ((0,251,252),(0,251,252),DecompositionType::Isolated),
  ((0,251,253),(0,251,253),DecompositionType::Final),
  ((0,251,254),(0,251,254),DecompositionType::Initial),
  ((0,251,255),(0,251,255),DecompositionType::Medial),
  ((0,252,0),(0,252,99),DecompositionType::Isolated),
  ((0,252,100),(0,252,150),DecompositionType::Final),
  ((0,252,151),(0,252,222),DecompositionType::Initial),
  ((0,252,223),(0,252,244),DecompositionType::Medial),
  ((0,252,245),(0,253,16),DecompositionType::Isolated),
  ((0,253,17),(0,253,44),DecompositionType::Final),
  ((0,253,45),(0,253,51),DecompositionType::Initial),
  ((0,253,52),(0,253,59),DecompositionType::Medial),
  ((0,253,60),(0,253,60),DecompositionType::Final),
  ((0,253,61),(0,253,61),DecompositionType::Isolated),
  ((0,253,80),(0,253,80),DecompositionType::Initial),
  ((0,253,81),(0,253,81),DecompositionType::Final),
  ((0,253,82),(0,253,87),DecompositionType::Initial),
  ((0,253,88),(0,253,88),DecompositionType::Final),
  ((0,253,89),(0,253,89),DecompositionType::Initial),
  ((0,253,90),(0,253,91),DecompositionType::Final),
  ((0,253,92),(0,253,93),DecompositionType::Initial),
  ((0,253,94),(0,253,95),DecompositionType::Final),
  ((0,253,96),(0,253,97),DecompositionType::Initial),
  ((0,253,98),(0,253,98),DecompositionType::Final),
  ((0,253,99),(0,253,99),DecompositionType::Initial),
  ((0,253,100),(0,253,100),DecompositionType::Final),
  ((0,253,101),(0,253,101),DecompositionType::Initial),
  ((0,253,102),(0,253,103),DecompositionType::Final),
  ((0,253,104),(0,253,104),DecompositionType::Initial),
  ((0,253,105),(0,253,106),DecompositionType::Final),
  ((0,253,107),(0,253,107),DecompositionType::Initial),
  ((0,253,108),(0,253,108),DecompositionType::Final),
  ((0,253,109),(0,253,109),DecompositionType::Initial),
  ((0,253,110),(0,253,111),DecompositionType::Final),
  ((0,253,112),(0,253,112),DecompositionType::Initial),
  ((0,253,113),(0,253,113),DecompositionType::Final),
  ((0,253,114),(0,253,115),DecompositionType::Initial),
  ((0,253,116),(0,253,118),DecompositionType::Final),
  ((0,253,119),(0,253,119),DecompositionType::Initial),
  ((0,253,120),(0,253,124),DecompositionType::Final),
  ((0,253,125),(0,253,125),DecompositionType::Initial),
  ((0,253,126),(0,253,130),DecompositionType::Final),
  ((0,253,131),(0,253,131),DecompositionType::Initial),
  ((0,253,132),(0,253,133),DecompositionType::Final),
  ((0,253,134),(0,253,134),DecompositionType::Initial),
  ((0,253,135),(0,253,135),DecompositionType::Final),
  ((0,253,136),(0,253,138),DecompositionType::Initial),
  ((0,253,139),(0,253,139),DecompositionType::Final),
  ((0,253,140),(0,253,143),DecompositionType::Initial),
  ((0,253,146),(0,253,149),DecompositionType::Initial),
  ((0,253,150),(0,253,151),DecompositionType::Final),
  ((0,253,152),(0,253,152),DecompositionType::Initial),
  ((0,253,153),(0,253,156),DecompositionType::Final),
  ((0,253,157),(0,253,157),DecompositionType::Initial),
  ((0,253,158),(0,253,179),DecompositionType::Final),
  ((0,253,180),(0,253,181),DecompositionType::Initial),
  ((0,253,182),(0,253,183),DecompositionType::Final),
  ((0,253,184),(0,253,184),DecompositionType::Initial),
  ((0,253,185),(0,253,185),DecompositionType::Final),
  ((0,253,186),(0,253,186),DecompositionType::Initial),
  ((0,253,187),(0,253,194),DecompositionType::Final),
  ((0,253,195),(0,253,197),DecompositionType::Initial),
  ((0,253,198),(0,253,199),DecompositionType::Final),
  ((0,253,240),(0,253,252),DecompositionType::Isolated),
  ((0,254,16),(0,254,25),DecompositionType::Vertical),
  ((0,254,48),(0,254,68),DecompositionType::Vertical),
  ((0,254,71),(0,254,72),DecompositionType::Vertical),
  ((0,254,73),(0,254,79),DecompositionType::Compat),
  ((0,254,80),(0,254,82),DecompositionType::Small),
  ((0,254,84),(0,254,102),DecompositionType::Small),
  ((0,254,104),(0,254,107),DecompositionType::Small),
  ((0,254,112),(0,254,112),DecompositionType::Isolated),
  ((0,254,113),(0,254,113),DecompositionType::Medial),
  ((0,254,114),(0,254,114),DecompositionType::Isolated),
  ((0,254,116),(0,254,116),DecompositionType::Isolated),
  ((0,254,118),(0,254,118),DecompositionType::Isolated),
  ((0,254,119),(0,254,119),DecompositionType::Medial),
  ((0,254,120),(0,254,120),DecompositionType::Isolated),
  ((0,254,121),(0,254,121),DecompositionType::Medial),
  ((0,254,122),(0,254,122),DecompositionType::Isolated),
  ((0,254,123),(0,254,123),DecompositionType::Medial),
  ((0,254,124),(0,254,124),DecompositionType::Isolated),
  ((0,254,125),(0,254,125),DecompositionType::Medial),
  ((0,254,126),(0,254,126),DecompositionType::Isolated),
  ((0,254,127),(0,254,127),DecompositionType::Medial),
  ((0,254,128),(0,254,129),DecompositionType::Isolated),
  ((0,254,130),(0,254,130),DecompositionType::Final),
  ((0,254,131),(0,254,131),DecompositionType::Isolated),
  ((0,254,132),(0,254,132),DecompositionType::Final),
  ((0,254,133),(0,254,133),DecompositionType::Isolated),
  ((0,254,134),(0,254,134),DecompositionType::Final),
  ((0,254,135),(0,254,135),DecompositionType::Isolated),
  ((0,254,136),(0,254,136),DecompositionType::Final),
  ((0,254,137),(0,254,137),DecompositionType::Isolated),
  ((0,254,138),(0,254,138),DecompositionType::Final),
  ((0,254,139),(0,254,139),DecompositionType::Initial),
  ((0,254,140),(0,254,140),DecompositionType::Medial),
  ((0,254,141),(0,254,141),DecompositionType::Isolated),
  ((0,254,142),(0,254,142),DecompositionType::Final),
  ((0,254,143),(0,254,143),DecompositionType::Isolated),
  ((0,254,144),(0,254,144),DecompositionType::Final),
  ((0,254,145),(0,254,145),DecompositionType::Initial),
  ((0,254,146),(0,254,146),DecompositionType::Medial),
  ((0,254,147),(0,254,147),DecompositionType::Isolated),
  ((0,254,148),(0,254,148),DecompositionType::Final),
  ((0,254,149),(0,254,149),DecompositionType::Isolated),
  ((0,254,150),(0,254,150),DecompositionType::Final),
  ((0,254,151),(0,254,151),DecompositionType::Initial),
  ((0,254,152),(0,254,152),DecompositionType::Medial),
  ((0,254,153),(0,254,153),DecompositionType::Isolated),
  ((0,254,154),(0,254,154),DecompositionType::Final),
  ((0,254,155),(0,254,155),DecompositionType::Initial),
  ((0,254,156),(0,254,156),DecompositionType::Medial),
  ((0,254,157),(0,254,157),DecompositionType::Isolated),
  ((0,254,158),(0,254,158),DecompositionType::Final),
  ((0,254,159),(0,254,159),DecompositionType::Initial),
  ((0,254,160),(0,254,160),DecompositionType::Medial),
  ((0,254,161),(0,254,161),DecompositionType::Isolated),
  ((0,254,162),(0,254,162),DecompositionType::Final),
  ((0,254,163),(0,254,163),DecompositionType::Initial),
  ((0,254,164),(0,254,164),DecompositionType::Medial),
  ((0,254,165),(0,254,165),DecompositionType::Isolated),
  ((0,254,166),(0,254,166),DecompositionType::Final),
  ((0,254,167),(0,254,167),DecompositionType::Initial),
  ((0,254,168),(0,254,168),DecompositionType::Medial),
  ((0,254,169),(0,254,169),DecompositionType::Isolated),
  ((0,254,170),(0,254,170),DecompositionType::Final),
  ((0,254,171),(0,254,171),DecompositionType::Isolated),
  ((0,254,172),(0,254,172),DecompositionType::Final),
  ((0,254,173),(0,254,173),DecompositionType::Isolated),
  ((0,254,174),(0,254,174),DecompositionType::Final),
  ((0,254,175),(0,254,175),DecompositionType::Isolated),
  ((0,254,176),(0,254,176),DecompositionType::Final),
  ((0,254,177),(0,254,177),DecompositionType::Isolated),
  ((0,254,178),(0,254,178),DecompositionType::Final),
  ((0,254,179),(0,254,179),DecompositionType::Initial),
  ((0,254,180),(0,254,180),DecompositionType::Medial),
  ((0,254,181),(0,254,181),DecompositionType::Isolated),
  ((0,254,182),(0,254,182),DecompositionType::Final),
  ((0,254,183),(0,254,183),DecompositionType::Initial),
  ((0,254,184),(0,254,184),DecompositionType::Medial),
  ((0,254,185),(0,254,185),DecompositionType::Isolated),
  ((0,254,186),(0,254,186),DecompositionType::Final),
  ((0,254,187),(0,254,187),DecompositionType::Initial),
  ((0,254,188),(0,254,188),DecompositionType::Medial),
  ((0,254,189),(0,254,189),DecompositionType::Isolated),
  ((0,254,190),(0,254,190),DecompositionType::Final),
  ((0,254,191),(0,254,191),DecompositionType::Initial),
  ((0,254,192),(0,254,192),DecompositionType::Medial),
  ((0,254,193),(0,254,193),DecompositionType::Isolated),
  ((0,254,194),(0,254,194),DecompositionType::Final),
  ((0,254,195),(0,254,195),DecompositionType::Initial),
  ((0,254,196),(0,254,196),DecompositionType::Medial),
  ((0,254,197),(0,254,197),DecompositionType::Isolated),
  ((0,254,198),(0,254,198),DecompositionType::Final),
  ((0,254,199),(0,254,199),DecompositionType::Initial),
  ((0,254,200),(0,254,200),DecompositionType::Medial),
  ((0,254,201),(0,254,201),DecompositionType::Isolated),
  ((0,254,202),(0,254,202),DecompositionType::Final),
  ((0,254,203),(0,254,203),DecompositionType::Initial),
  ((0,254,204),(0,254,204),DecompositionType::Medial),
  ((0,254,205),(0,254,205),DecompositionType::Isolated),
  ((0,254,206),(0,254,206),DecompositionType::Final),
  ((0,254,207),(0,254,207),DecompositionType::Initial),
  ((0,254,208),(0,254,208),DecompositionType::Medial),
  ((0,254,209),(0,254,209),DecompositionType::Isolated),
  ((0,254,210),(0,254,210),DecompositionType::Final),
  ((0,254,211),(0,254,211),DecompositionType::Initial),
  ((0,254,212),(0,254,212),DecompositionType::Medial),
  ((0,254,213),(0,254,213),DecompositionType::Isolated),
  ((0,254,214),(0,254,214),DecompositionType::Final),
  ((0,254,215),(0,254,215),DecompositionType::Initial),
  ((0,254,216),(0,254,216),DecompositionType::Medial),
  ((0,254,217),(0,254,217),DecompositionType::Isolated),
  ((0,254,218),(0,254,218),DecompositionType::Final),
  ((0,254,219),(0,254,219),DecompositionType::Initial),
  ((0,254,220),(0,254,220),DecompositionType::Medial),
  ((0,254,221),(0,254,221),DecompositionType::Isolated),
  ((0,254,222),(0,254,222),DecompositionType::Final),
  ((0,254,223),(0,254,223),DecompositionType::Initial),
  ((0,254,224),(0,254,224),DecompositionType::Medial),
  ((0,254,225),(0,254,225),DecompositionType::Isolated),
  ((0,254,226),(0,254,226),DecompositionType::Final),
  ((0,254,227),(0,254,227),DecompositionType::Initial),
  ((0,254,228),(0,254,228),DecompositionType::Medial),
  ((0,254,229),(0,254,229),DecompositionType::Isolated),
  ((0,254,230),(0,254,230),DecompositionType::Final),
  ((0,254,231),(0,254,231),DecompositionType::Initial),
  ((0,254,232),(0,254,232),DecompositionType::Medial),
  ((0,254,233),(0,254,233),DecompositionType::Isolated),
  ((0,254,234),(0,254,234),DecompositionType::Final),
  ((0,254,235),(0,254,235),DecompositionType::Initial),
  ((0,254,236),(0,254,236),DecompositionType::Medial),
  ((0,254,237),(0,254,237),DecompositionType::Isolated),
  ((0,254,238),(0,254,238),DecompositionType::Final),
  ((0,254,239),(0,254,239),DecompositionType::Isolated),
  ((0,254,240),(0,254,240),DecompositionType::Final),
  ((0,254,241),(0,254,241),DecompositionType::Isolated),
  ((0,254,242),(0,254,242),DecompositionType::Final),
  ((0,254,243),(0,254,243),DecompositionType::Initial),
  ((0,254,244),(0,254,244),DecompositionType::Medial),
  ((0,254,245),(0,254,245),DecompositionType::Isolated),
  ((0,254,246),(0,254,246),DecompositionType::Final),
  ((0,254,247),(0,254,247),DecompositionType::Isolated),
  ((0,254,248),(0,254,248),DecompositionType::Final),
  ((0,254,249),(0,254,249),DecompositionType::Isolated),
  ((0,254,250),(0,254,250),DecompositionType::Final),
  ((0,254,251),(0,254,251),DecompositionType::Isolated),
  ((0,254,252),(0,254,252),DecompositionType::Final),
  ((0,255,1),(0,255,96),DecompositionType::Wide),
  ((0,255,97),(0,255,190),DecompositionType::Narrow),
  ((0,255,194),(0,255,199),DecompositionType::Narrow),
  ((0,255,202),(0,255,207),DecompositionType::Narrow),
  ((0,255,210),(0,255,215),DecompositionType::Narrow),
  ((0,255,218),(0,255,220),DecompositionType::Narrow),
  ((0,255,224),(0,255,230),DecompositionType::Wide),
  ((0,255,232),(0,255,238),DecompositionType::Narrow),
  ((1,16,154),(1,16,154),DecompositionType::Canonical),
  ((1,16,156),(1,16,156),DecompositionType::Canonical),
  ((1,16,171),(1,16,171),DecompositionType::Canonical),
  ((1,17,46),(1,17,47),DecompositionType::Canonical),
  ((1,19,75),(1,19,76),DecompositionType::Canonical),
  ((1,20,187),(1,20,188),DecompositionType::Canonical),
  ((1,20,190),(1,20,190),DecompositionType::Canonical),
  ((1,21,186),(1,21,187),DecompositionType::Canonical),
  ((1,209,94),(1,209,100),DecompositionType::Canonical),
  ((1,209,187),(1,209,192),DecompositionType::Canonical),
  ((1,212,0),(1,212,84),DecompositionType::Font),
  ((1,212,86),(1,212,156),DecompositionType::Font),
  ((1,212,158),(1,212,159),DecompositionType::Font),
  ((1,212,162),(1,212,162),DecompositionType::Font),
  ((1,212,165),(1,212,166),DecompositionType::Font),
  ((1,212,169),(1,212,172),DecompositionType::Font),
  ((1,212,174),(1,212,185),DecompositionType::Font),
  ((1,212,187),(1,212,187),DecompositionType::Font),
  ((1,212,189),(1,212,195),DecompositionType::Font),
  ((1,212,197),(1,213,5),DecompositionType::Font),
  ((1,213,7),(1,213,10),DecompositionType::Font),
  ((1,213,13),(1,213,20),DecompositionType::Font),
  ((1,213,22),(1,213,28),DecompositionType::Font),
  ((1,213,30),(1,213,57),DecompositionType::Font),
  ((1,213,59),(1,213,62),DecompositionType::Font),
  ((1,213,64),(1,213,68),DecompositionType::Font),
  ((1,213,70),(1,213,70),DecompositionType::Font),
  ((1,213,74),(1,213,80),DecompositionType::Font),
  ((1,213,82),(1,214,165),DecompositionType::Font),
  ((1,214,168),(1,215,203),DecompositionType::Font),
  ((1,215,206),(1,215,255),DecompositionType::Font),
  ((1,238,0),(1,238,3),DecompositionType::Font),
  ((1,238,5),(1,238,31),DecompositionType::Font),
  ((1,238,33),(1,238,34),DecompositionType::Font),
  ((1,238,36),(1,238,36),DecompositionType::Font),
  ((1,238,39),(1,238,39),DecompositionType::Font),
  ((1,238,41),(1,238,50),DecompositionType::Font),
  ((1,238,52),(1,238,55),DecompositionType::Font),
  ((1,238,57),(1,238,57),DecompositionType::Font),
  ((1,238,59),(1,238,59),DecompositionType::Font),
  ((1,238,66),(1,238,66),DecompositionType::Font),
  ((1,238,71),(1,238,71),DecompositionType::Font),
  ((1,238,73),(1,238,73),DecompositionType::Font),
  ((1,238,75),(1,238,75),DecompositionType::Font),
  ((1,238,77),(1,238,79),DecompositionType::Font),
  ((1,238,81),(1,238,82),DecompositionType::Font),
  ((1,238,84),(1,238,84),DecompositionType::Font),
  ((1,238,87),(1,238,87),DecompositionType::Font),
  ((1,238,89),(1,238,89),DecompositionType::Font),
  ((1,238,91),(1,238,91),DecompositionType::Font),
  ((1,238,93),(1,238,93),DecompositionType::Font),
  ((1,238,95),(1,238,95),DecompositionType::Font),
  ((1,238,97),(1,238,98),DecompositionType::Font),
  ((1,238,100),(1,238,100),DecompositionType::Font),
  ((1,238,103),(1,238,106),DecompositionType::Font),
  ((1,238,108),(1,238,114),DecompositionType::Font),
  ((1,238,116),(1,238,119),DecompositionType::Font),
  ((1,238,121),(1,238,124),DecompositionType::Font),
  ((1,238,126),(1,238,126),DecompositionType::Font),
  ((1,238,128),(1,238,137),DecompositionType::Font),
  ((1,238,139),(1,238,155),DecompositionType::Font),
  ((1,238,161),(1,238,163),DecompositionType::Font),
  ((1,238,165),(1,238,169),DecompositionType::Font),
  ((1,238,171),(1,238,187),DecompositionType::Font),
  ((1,241,0),(1,241,10),DecompositionType::Compat),
  ((1,241,16),(1,241,42),DecompositionType::Compat),
  ((1,241,43),(1,241,46),DecompositionType::Circle),
  ((1,241,48),(1,241,79),DecompositionType::Square),
  ((1,241,106),(1,241,107),DecompositionType::Super),
  ((1,241,144),(1,241,144),DecompositionType::Square),
  ((1,242,0),(1,242,2),DecompositionType::Square),
  ((1,242,16),(1,242,59),DecompositionType::Square),
  ((1,242,64),(1,242,72),DecompositionType::Compat),
  ((1,242,80),(1,242,81),DecompositionType::Circle),
  ((2,248,0),(2,250,29),DecompositionType::Canonical)
];

#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum GraphemeClusterBreak {
  Control, CarriageReturn, LineFeed, Extend, Prepend, EmojiModifier,
  EmojiModifierBase, EmojiModiferBaseAfterZWJ, GlueAfterZWJ, ZWJ, LeadingJamo,
  VowelJamo, TrailingJamo, LVHangulSyllable, LVTHangulSyllable,
  RegionalIndicator, SpacingMark, Other
}

pub static UCD_GCB: &'static [((u8,u8,u8), (u8,u8,u8), GraphemeClusterBreak)] = &[
  ((0,0,0),(0,0,9),GraphemeClusterBreak::Control),
  ((0,0,10),(0,0,10),GraphemeClusterBreak::LineFeed),
  ((0,0,11),(0,0,12),GraphemeClusterBreak::Control),
  ((0,0,13),(0,0,13),GraphemeClusterBreak::CarriageReturn),
  ((0,0,14),(0,0,31),GraphemeClusterBreak::Control),
  ((0,0,127),(0,0,159),GraphemeClusterBreak::Control),
  ((0,0,173),(0,0,173),GraphemeClusterBreak::Control),
  ((0,3,0),(0,3,111),GraphemeClusterBreak::Extend),
  ((0,4,131),(0,4,137),GraphemeClusterBreak::Extend),
  ((0,5,145),(0,5,189),GraphemeClusterBreak::Extend),
  ((0,5,191),(0,5,191),GraphemeClusterBreak::Extend),
  ((0,5,193),(0,5,194),GraphemeClusterBreak::Extend),
  ((0,5,196),(0,5,197),GraphemeClusterBreak::Extend),
  ((0,5,199),(0,5,199),GraphemeClusterBreak::Extend),
  ((0,6,0),(0,6,5),GraphemeClusterBreak::Prepend),
  ((0,6,16),(0,6,26),GraphemeClusterBreak::Extend),
  ((0,6,28),(0,6,28),GraphemeClusterBreak::Control),
  ((0,6,75),(0,6,95),GraphemeClusterBreak::Extend),
  ((0,6,112),(0,6,112),GraphemeClusterBreak::Extend),
  ((0,6,214),(0,6,220),GraphemeClusterBreak::Extend),
  ((0,6,221),(0,6,221),GraphemeClusterBreak::Prepend),
  ((0,6,223),(0,6,228),GraphemeClusterBreak::Extend),
  ((0,6,231),(0,6,232),GraphemeClusterBreak::Extend),
  ((0,6,234),(0,6,237),GraphemeClusterBreak::Extend),
  ((0,7,15),(0,7,15),GraphemeClusterBreak::Prepend),
  ((0,7,17),(0,7,17),GraphemeClusterBreak::Extend),
  ((0,7,48),(0,7,74),GraphemeClusterBreak::Extend),
  ((0,7,166),(0,7,176),GraphemeClusterBreak::Extend),
  ((0,7,235),(0,7,243),GraphemeClusterBreak::Extend),
  ((0,8,22),(0,8,25),GraphemeClusterBreak::Extend),
  ((0,8,27),(0,8,35),GraphemeClusterBreak::Extend),
  ((0,8,37),(0,8,39),GraphemeClusterBreak::Extend),
  ((0,8,41),(0,8,45),GraphemeClusterBreak::Extend),
  ((0,8,89),(0,8,91),GraphemeClusterBreak::Extend),
  ((0,8,212),(0,8,225),GraphemeClusterBreak::Extend),
  ((0,8,226),(0,8,226),GraphemeClusterBreak::Prepend),
  ((0,8,227),(0,9,2),GraphemeClusterBreak::Extend),
  ((0,9,3),(0,9,3),GraphemeClusterBreak::SpacingMark),
  ((0,9,58),(0,9,58),GraphemeClusterBreak::Extend),
  ((0,9,59),(0,9,59),GraphemeClusterBreak::SpacingMark),
  ((0,9,60),(0,9,60),GraphemeClusterBreak::Extend),
  ((0,9,62),(0,9,64),GraphemeClusterBreak::SpacingMark),
  ((0,9,65),(0,9,72),GraphemeClusterBreak::Extend),
  ((0,9,73),(0,9,76),GraphemeClusterBreak::SpacingMark),
  ((0,9,77),(0,9,77),GraphemeClusterBreak::Extend),
  ((0,9,78),(0,9,79),GraphemeClusterBreak::SpacingMark),
  ((0,9,81),(0,9,87),GraphemeClusterBreak::Extend),
  ((0,9,98),(0,9,99),GraphemeClusterBreak::Extend),
  ((0,9,129),(0,9,129),GraphemeClusterBreak::Extend),
  ((0,9,130),(0,9,131),GraphemeClusterBreak::SpacingMark),
  ((0,9,188),(0,9,188),GraphemeClusterBreak::Extend),
  ((0,9,190),(0,9,190),GraphemeClusterBreak::Extend),
  ((0,9,191),(0,9,192),GraphemeClusterBreak::SpacingMark),
  ((0,9,193),(0,9,196),GraphemeClusterBreak::Extend),
  ((0,9,199),(0,9,200),GraphemeClusterBreak::SpacingMark),
  ((0,9,203),(0,9,204),GraphemeClusterBreak::SpacingMark),
  ((0,9,205),(0,9,205),GraphemeClusterBreak::Extend),
  ((0,9,215),(0,9,215),GraphemeClusterBreak::Extend),
  ((0,9,226),(0,9,227),GraphemeClusterBreak::Extend),
  ((0,10,1),(0,10,2),GraphemeClusterBreak::Extend),
  ((0,10,3),(0,10,3),GraphemeClusterBreak::SpacingMark),
  ((0,10,60),(0,10,60),GraphemeClusterBreak::Extend),
  ((0,10,62),(0,10,64),GraphemeClusterBreak::SpacingMark),
  ((0,10,65),(0,10,66),GraphemeClusterBreak::Extend),
  ((0,10,71),(0,10,72),GraphemeClusterBreak::Extend),
  ((0,10,75),(0,10,77),GraphemeClusterBreak::Extend),
  ((0,10,81),(0,10,81),GraphemeClusterBreak::Extend),
  ((0,10,112),(0,10,113),GraphemeClusterBreak::Extend),
  ((0,10,117),(0,10,117),GraphemeClusterBreak::Extend),
  ((0,10,129),(0,10,130),GraphemeClusterBreak::Extend),
  ((0,10,131),(0,10,131),GraphemeClusterBreak::SpacingMark),
  ((0,10,188),(0,10,188),GraphemeClusterBreak::Extend),
  ((0,10,190),(0,10,192),GraphemeClusterBreak::SpacingMark),
  ((0,10,193),(0,10,197),GraphemeClusterBreak::Extend),
  ((0,10,199),(0,10,200),GraphemeClusterBreak::Extend),
  ((0,10,201),(0,10,201),GraphemeClusterBreak::SpacingMark),
  ((0,10,203),(0,10,204),GraphemeClusterBreak::SpacingMark),
  ((0,10,205),(0,10,205),GraphemeClusterBreak::Extend),
  ((0,10,226),(0,10,227),GraphemeClusterBreak::Extend),
  ((0,11,1),(0,11,1),GraphemeClusterBreak::Extend),
  ((0,11,2),(0,11,3),GraphemeClusterBreak::SpacingMark),
  ((0,11,60),(0,11,60),GraphemeClusterBreak::Extend),
  ((0,11,62),(0,11,63),GraphemeClusterBreak::Extend),
  ((0,11,64),(0,11,64),GraphemeClusterBreak::SpacingMark),
  ((0,11,65),(0,11,68),GraphemeClusterBreak::Extend),
  ((0,11,71),(0,11,72),GraphemeClusterBreak::SpacingMark),
  ((0,11,75),(0,11,76),GraphemeClusterBreak::SpacingMark),
  ((0,11,77),(0,11,77),GraphemeClusterBreak::Extend),
  ((0,11,86),(0,11,87),GraphemeClusterBreak::Extend),
  ((0,11,98),(0,11,99),GraphemeClusterBreak::Extend),
  ((0,11,130),(0,11,130),GraphemeClusterBreak::Extend),
  ((0,11,190),(0,11,190),GraphemeClusterBreak::Extend),
  ((0,11,191),(0,11,191),GraphemeClusterBreak::SpacingMark),
  ((0,11,192),(0,11,192),GraphemeClusterBreak::Extend),
  ((0,11,193),(0,11,194),GraphemeClusterBreak::SpacingMark),
  ((0,11,198),(0,11,200),GraphemeClusterBreak::SpacingMark),
  ((0,11,202),(0,11,204),GraphemeClusterBreak::SpacingMark),
  ((0,11,205),(0,11,205),GraphemeClusterBreak::Extend),
  ((0,11,215),(0,11,215),GraphemeClusterBreak::Extend),
  ((0,12,0),(0,12,0),GraphemeClusterBreak::Extend),
  ((0,12,1),(0,12,3),GraphemeClusterBreak::SpacingMark),
  ((0,12,62),(0,12,64),GraphemeClusterBreak::Extend),
  ((0,12,65),(0,12,68),GraphemeClusterBreak::SpacingMark),
  ((0,12,70),(0,12,72),GraphemeClusterBreak::Extend),
  ((0,12,74),(0,12,77),GraphemeClusterBreak::Extend),
  ((0,12,85),(0,12,86),GraphemeClusterBreak::Extend),
  ((0,12,98),(0,12,99),GraphemeClusterBreak::Extend),
  ((0,12,129),(0,12,129),GraphemeClusterBreak::Extend),
  ((0,12,130),(0,12,131),GraphemeClusterBreak::SpacingMark),
  ((0,12,188),(0,12,188),GraphemeClusterBreak::Extend),
  ((0,12,190),(0,12,190),GraphemeClusterBreak::SpacingMark),
  ((0,12,191),(0,12,191),GraphemeClusterBreak::Extend),
  ((0,12,192),(0,12,193),GraphemeClusterBreak::SpacingMark),
  ((0,12,194),(0,12,194),GraphemeClusterBreak::Extend),
  ((0,12,195),(0,12,196),GraphemeClusterBreak::SpacingMark),
  ((0,12,198),(0,12,198),GraphemeClusterBreak::Extend),
  ((0,12,199),(0,12,200),GraphemeClusterBreak::SpacingMark),
  ((0,12,202),(0,12,203),GraphemeClusterBreak::SpacingMark),
  ((0,12,204),(0,12,205),GraphemeClusterBreak::Extend),
  ((0,12,213),(0,12,214),GraphemeClusterBreak::Extend),
  ((0,12,226),(0,12,227),GraphemeClusterBreak::Extend),
  ((0,13,1),(0,13,1),GraphemeClusterBreak::Extend),
  ((0,13,2),(0,13,3),GraphemeClusterBreak::SpacingMark),
  ((0,13,62),(0,13,62),GraphemeClusterBreak::Extend),
  ((0,13,63),(0,13,64),GraphemeClusterBreak::SpacingMark),
  ((0,13,65),(0,13,68),GraphemeClusterBreak::Extend),
  ((0,13,70),(0,13,72),GraphemeClusterBreak::SpacingMark),
  ((0,13,74),(0,13,76),GraphemeClusterBreak::SpacingMark),
  ((0,13,77),(0,13,77),GraphemeClusterBreak::Extend),
  ((0,13,78),(0,13,78),GraphemeClusterBreak::Prepend),
  ((0,13,87),(0,13,87),GraphemeClusterBreak::Extend),
  ((0,13,98),(0,13,99),GraphemeClusterBreak::Extend),
  ((0,13,130),(0,13,131),GraphemeClusterBreak::SpacingMark),
  ((0,13,202),(0,13,202),GraphemeClusterBreak::Extend),
  ((0,13,207),(0,13,207),GraphemeClusterBreak::Extend),
  ((0,13,208),(0,13,209),GraphemeClusterBreak::SpacingMark),
  ((0,13,210),(0,13,212),GraphemeClusterBreak::Extend),
  ((0,13,214),(0,13,214),GraphemeClusterBreak::Extend),
  ((0,13,216),(0,13,222),GraphemeClusterBreak::SpacingMark),
  ((0,13,223),(0,13,223),GraphemeClusterBreak::Extend),
  ((0,13,242),(0,13,243),GraphemeClusterBreak::SpacingMark),
  ((0,14,49),(0,14,49),GraphemeClusterBreak::Extend),
  ((0,14,51),(0,14,51),GraphemeClusterBreak::SpacingMark),
  ((0,14,52),(0,14,58),GraphemeClusterBreak::Extend),
  ((0,14,71),(0,14,78),GraphemeClusterBreak::Extend),
  ((0,14,177),(0,14,177),GraphemeClusterBreak::Extend),
  ((0,14,179),(0,14,179),GraphemeClusterBreak::SpacingMark),
  ((0,14,180),(0,14,185),GraphemeClusterBreak::Extend),
  ((0,14,187),(0,14,188),GraphemeClusterBreak::Extend),
  ((0,14,200),(0,14,205),GraphemeClusterBreak::Extend),
  ((0,15,24),(0,15,25),GraphemeClusterBreak::Extend),
  ((0,15,53),(0,15,53),GraphemeClusterBreak::Extend),
  ((0,15,55),(0,15,55),GraphemeClusterBreak::Extend),
  ((0,15,57),(0,15,57),GraphemeClusterBreak::Extend),
  ((0,15,62),(0,15,63),GraphemeClusterBreak::SpacingMark),
  ((0,15,113),(0,15,126),GraphemeClusterBreak::Extend),
  ((0,15,127),(0,15,127),GraphemeClusterBreak::SpacingMark),
  ((0,15,128),(0,15,132),GraphemeClusterBreak::Extend),
  ((0,15,134),(0,15,135),GraphemeClusterBreak::Extend),
  ((0,15,141),(0,15,151),GraphemeClusterBreak::Extend),
  ((0,15,153),(0,15,188),GraphemeClusterBreak::Extend),
  ((0,15,198),(0,15,198),GraphemeClusterBreak::Extend),
  ((0,16,45),(0,16,48),GraphemeClusterBreak::Extend),
  ((0,16,49),(0,16,49),GraphemeClusterBreak::SpacingMark),
  ((0,16,50),(0,16,55),GraphemeClusterBreak::Extend),
  ((0,16,57),(0,16,58),GraphemeClusterBreak::Extend),
  ((0,16,59),(0,16,60),GraphemeClusterBreak::SpacingMark),
  ((0,16,61),(0,16,62),GraphemeClusterBreak::Extend),
  ((0,16,86),(0,16,87),GraphemeClusterBreak::SpacingMark),
  ((0,16,88),(0,16,89),GraphemeClusterBreak::Extend),
  ((0,16,94),(0,16,96),GraphemeClusterBreak::Extend),
  ((0,16,113),(0,16,116),GraphemeClusterBreak::Extend),
  ((0,16,130),(0,16,130),GraphemeClusterBreak::Extend),
  ((0,16,132),(0,16,132),GraphemeClusterBreak::SpacingMark),
  ((0,16,133),(0,16,134),GraphemeClusterBreak::Extend),
  ((0,16,141),(0,16,141),GraphemeClusterBreak::Extend),
  ((0,16,157),(0,16,157),GraphemeClusterBreak::Extend),
  ((0,19,93),(0,19,95),GraphemeClusterBreak::Extend),
  ((0,23,18),(0,23,20),GraphemeClusterBreak::Extend),
  ((0,23,50),(0,23,52),GraphemeClusterBreak::Extend),
  ((0,23,82),(0,23,83),GraphemeClusterBreak::Extend),
  ((0,23,114),(0,23,115),GraphemeClusterBreak::Extend),
  ((0,23,180),(0,23,181),GraphemeClusterBreak::Extend),
  ((0,23,182),(0,23,182),GraphemeClusterBreak::SpacingMark),
  ((0,23,183),(0,23,189),GraphemeClusterBreak::Extend),
  ((0,23,190),(0,23,197),GraphemeClusterBreak::SpacingMark),
  ((0,23,198),(0,23,198),GraphemeClusterBreak::Extend),
  ((0,23,199),(0,23,200),GraphemeClusterBreak::SpacingMark),
  ((0,23,201),(0,23,211),GraphemeClusterBreak::Extend),
  ((0,23,221),(0,23,221),GraphemeClusterBreak::Extend),
  ((0,24,11),(0,24,13),GraphemeClusterBreak::Extend),
  ((0,24,14),(0,24,14),GraphemeClusterBreak::Control),
  ((0,24,133),(0,24,134),GraphemeClusterBreak::Extend),
  ((0,24,169),(0,24,169),GraphemeClusterBreak::Extend),
  ((0,25,32),(0,25,34),GraphemeClusterBreak::Extend),
  ((0,25,35),(0,25,38),GraphemeClusterBreak::SpacingMark),
  ((0,25,39),(0,25,40),GraphemeClusterBreak::Extend),
  ((0,25,41),(0,25,43),GraphemeClusterBreak::SpacingMark),
  ((0,25,48),(0,25,49),GraphemeClusterBreak::SpacingMark),
  ((0,25,50),(0,25,50),GraphemeClusterBreak::Extend),
  ((0,25,51),(0,25,56),GraphemeClusterBreak::SpacingMark),
  ((0,25,57),(0,25,59),GraphemeClusterBreak::Extend),
  ((0,26,23),(0,26,24),GraphemeClusterBreak::Extend),
  ((0,26,25),(0,26,26),GraphemeClusterBreak::SpacingMark),
  ((0,26,27),(0,26,27),GraphemeClusterBreak::Extend),
  ((0,26,85),(0,26,85),GraphemeClusterBreak::SpacingMark),
  ((0,26,86),(0,26,86),GraphemeClusterBreak::Extend),
  ((0,26,87),(0,26,87),GraphemeClusterBreak::SpacingMark),
  ((0,26,88),(0,26,94),GraphemeClusterBreak::Extend),
  ((0,26,96),(0,26,96),GraphemeClusterBreak::Extend),
  ((0,26,98),(0,26,98),GraphemeClusterBreak::Extend),
  ((0,26,101),(0,26,108),GraphemeClusterBreak::Extend),
  ((0,26,109),(0,26,114),GraphemeClusterBreak::SpacingMark),
  ((0,26,115),(0,26,124),GraphemeClusterBreak::Extend),
  ((0,26,127),(0,26,127),GraphemeClusterBreak::Extend),
  ((0,26,176),(0,26,190),GraphemeClusterBreak::Extend),
  ((0,27,0),(0,27,3),GraphemeClusterBreak::Extend),
  ((0,27,4),(0,27,4),GraphemeClusterBreak::SpacingMark),
  ((0,27,52),(0,27,52),GraphemeClusterBreak::Extend),
  ((0,27,53),(0,27,53),GraphemeClusterBreak::SpacingMark),
  ((0,27,54),(0,27,58),GraphemeClusterBreak::Extend),
  ((0,27,59),(0,27,59),GraphemeClusterBreak::SpacingMark),
  ((0,27,60),(0,27,60),GraphemeClusterBreak::Extend),
  ((0,27,61),(0,27,65),GraphemeClusterBreak::SpacingMark),
  ((0,27,66),(0,27,66),GraphemeClusterBreak::Extend),
  ((0,27,67),(0,27,68),GraphemeClusterBreak::SpacingMark),
  ((0,27,107),(0,27,115),GraphemeClusterBreak::Extend),
  ((0,27,128),(0,27,129),GraphemeClusterBreak::Extend),
  ((0,27,130),(0,27,130),GraphemeClusterBreak::SpacingMark),
  ((0,27,161),(0,27,161),GraphemeClusterBreak::SpacingMark),
  ((0,27,162),(0,27,165),GraphemeClusterBreak::Extend),
  ((0,27,166),(0,27,167),GraphemeClusterBreak::SpacingMark),
  ((0,27,168),(0,27,169),GraphemeClusterBreak::Extend),
  ((0,27,170),(0,27,170),GraphemeClusterBreak::SpacingMark),
  ((0,27,171),(0,27,173),GraphemeClusterBreak::Extend),
  ((0,27,230),(0,27,230),GraphemeClusterBreak::Extend),
  ((0,27,231),(0,27,231),GraphemeClusterBreak::SpacingMark),
  ((0,27,232),(0,27,233),GraphemeClusterBreak::Extend),
  ((0,27,234),(0,27,236),GraphemeClusterBreak::SpacingMark),
  ((0,27,237),(0,27,237),GraphemeClusterBreak::Extend),
  ((0,27,238),(0,27,238),GraphemeClusterBreak::SpacingMark),
  ((0,27,239),(0,27,241),GraphemeClusterBreak::Extend),
  ((0,27,242),(0,27,243),GraphemeClusterBreak::SpacingMark),
  ((0,28,36),(0,28,43),GraphemeClusterBreak::SpacingMark),
  ((0,28,44),(0,28,51),GraphemeClusterBreak::Extend),
  ((0,28,52),(0,28,53),GraphemeClusterBreak::SpacingMark),
  ((0,28,54),(0,28,55),GraphemeClusterBreak::Extend),
  ((0,28,208),(0,28,210),GraphemeClusterBreak::Extend),
  ((0,28,212),(0,28,224),GraphemeClusterBreak::Extend),
  ((0,28,225),(0,28,225),GraphemeClusterBreak::SpacingMark),
  ((0,28,226),(0,28,232),GraphemeClusterBreak::Extend),
  ((0,28,237),(0,28,237),GraphemeClusterBreak::Extend),
  ((0,28,242),(0,28,243),GraphemeClusterBreak::SpacingMark),
  ((0,28,244),(0,28,244),GraphemeClusterBreak::Extend),
  ((0,28,248),(0,28,249),GraphemeClusterBreak::Extend),
  ((0,29,192),(0,29,245),GraphemeClusterBreak::Extend),
  ((0,29,251),(0,29,255),GraphemeClusterBreak::Extend),
  ((0,32,11),(0,32,11),GraphemeClusterBreak::Control),
  ((0,32,12),(0,32,12),GraphemeClusterBreak::Extend),
  ((0,32,13),(0,32,13),GraphemeClusterBreak::ZWJ),
  ((0,32,14),(0,32,15),GraphemeClusterBreak::Control),
  ((0,32,40),(0,32,46),GraphemeClusterBreak::Control),
  ((0,32,96),(0,32,111),GraphemeClusterBreak::Control),
  ((0,32,208),(0,32,240),GraphemeClusterBreak::Extend),
  ((0,38,29),(0,38,29),GraphemeClusterBreak::EmojiModifierBase),
  ((0,38,249),(0,38,249),GraphemeClusterBreak::EmojiModifierBase),
  ((0,39,10),(0,39,13),GraphemeClusterBreak::EmojiModifierBase),
  ((0,39,100),(0,39,100),GraphemeClusterBreak::GlueAfterZWJ),
  ((0,44,239),(0,44,241),GraphemeClusterBreak::Extend),
  ((0,45,127),(0,45,127),GraphemeClusterBreak::Extend),
  ((0,45,224),(0,45,255),GraphemeClusterBreak::Extend),
  ((0,48,42),(0,48,47),GraphemeClusterBreak::Extend),
  ((0,48,153),(0,48,154),GraphemeClusterBreak::Extend),
  ((0,166,111),(0,166,114),GraphemeClusterBreak::Extend),
  ((0,166,116),(0,166,125),GraphemeClusterBreak::Extend),
  ((0,166,158),(0,166,159),GraphemeClusterBreak::Extend),
  ((0,166,240),(0,166,241),GraphemeClusterBreak::Extend),
  ((0,168,2),(0,168,2),GraphemeClusterBreak::Extend),
  ((0,168,6),(0,168,6),GraphemeClusterBreak::Extend),
  ((0,168,11),(0,168,11),GraphemeClusterBreak::Extend),
  ((0,168,35),(0,168,36),GraphemeClusterBreak::SpacingMark),
  ((0,168,37),(0,168,38),GraphemeClusterBreak::Extend),
  ((0,168,39),(0,168,39),GraphemeClusterBreak::SpacingMark),
  ((0,168,128),(0,168,129),GraphemeClusterBreak::SpacingMark),
  ((0,168,180),(0,168,195),GraphemeClusterBreak::SpacingMark),
  ((0,168,196),(0,168,197),GraphemeClusterBreak::Extend),
  ((0,168,224),(0,168,241),GraphemeClusterBreak::Extend),
  ((0,169,38),(0,169,45),GraphemeClusterBreak::Extend),
  ((0,169,71),(0,169,81),GraphemeClusterBreak::Extend),
  ((0,169,82),(0,169,83),GraphemeClusterBreak::SpacingMark),
  ((0,169,128),(0,169,130),GraphemeClusterBreak::Extend),
  ((0,169,131),(0,169,131),GraphemeClusterBreak::SpacingMark),
  ((0,169,179),(0,169,179),GraphemeClusterBreak::Extend),
  ((0,169,180),(0,169,181),GraphemeClusterBreak::SpacingMark),
  ((0,169,182),(0,169,185),GraphemeClusterBreak::Extend),
  ((0,169,186),(0,169,187),GraphemeClusterBreak::SpacingMark),
  ((0,169,188),(0,169,188),GraphemeClusterBreak::Extend),
  ((0,169,189),(0,169,192),GraphemeClusterBreak::SpacingMark),
  ((0,169,229),(0,169,229),GraphemeClusterBreak::Extend),
  ((0,170,41),(0,170,46),GraphemeClusterBreak::Extend),
  ((0,170,47),(0,170,48),GraphemeClusterBreak::SpacingMark),
  ((0,170,49),(0,170,50),GraphemeClusterBreak::Extend),
  ((0,170,51),(0,170,52),GraphemeClusterBreak::SpacingMark),
  ((0,170,53),(0,170,54),GraphemeClusterBreak::Extend),
  ((0,170,67),(0,170,67),GraphemeClusterBreak::Extend),
  ((0,170,76),(0,170,76),GraphemeClusterBreak::Extend),
  ((0,170,77),(0,170,77),GraphemeClusterBreak::SpacingMark),
  ((0,170,124),(0,170,124),GraphemeClusterBreak::Extend),
  ((0,170,176),(0,170,176),GraphemeClusterBreak::Extend),
  ((0,170,178),(0,170,180),GraphemeClusterBreak::Extend),
  ((0,170,183),(0,170,184),GraphemeClusterBreak::Extend),
  ((0,170,190),(0,170,191),GraphemeClusterBreak::Extend),
  ((0,170,193),(0,170,193),GraphemeClusterBreak::Extend),
  ((0,170,235),(0,170,235),GraphemeClusterBreak::SpacingMark),
  ((0,170,236),(0,170,237),GraphemeClusterBreak::Extend),
  ((0,170,238),(0,170,239),GraphemeClusterBreak::SpacingMark),
  ((0,170,245),(0,170,245),GraphemeClusterBreak::SpacingMark),
  ((0,170,246),(0,170,246),GraphemeClusterBreak::Extend),
  ((0,171,227),(0,171,228),GraphemeClusterBreak::SpacingMark),
  ((0,171,229),(0,171,229),GraphemeClusterBreak::Extend),
  ((0,171,230),(0,171,231),GraphemeClusterBreak::SpacingMark),
  ((0,171,232),(0,171,232),GraphemeClusterBreak::Extend),
  ((0,171,233),(0,171,234),GraphemeClusterBreak::SpacingMark),
  ((0,171,236),(0,171,236),GraphemeClusterBreak::SpacingMark),
  ((0,171,237),(0,171,237),GraphemeClusterBreak::Extend),
  ((0,216,0),(0,223,255),GraphemeClusterBreak::Control),
  ((0,251,30),(0,251,30),GraphemeClusterBreak::Extend),
  ((0,254,0),(0,254,15),GraphemeClusterBreak::Extend),
  ((0,254,32),(0,254,47),GraphemeClusterBreak::Extend),
  ((0,254,255),(0,254,255),GraphemeClusterBreak::Control),
  ((0,255,158),(0,255,159),GraphemeClusterBreak::Extend),
  ((0,255,240),(0,255,251),GraphemeClusterBreak::Control),
  ((1,1,253),(1,1,253),GraphemeClusterBreak::Extend),
  ((1,2,224),(1,2,224),GraphemeClusterBreak::Extend),
  ((1,3,118),(1,3,122),GraphemeClusterBreak::Extend),
  ((1,10,1),(1,10,3),GraphemeClusterBreak::Extend),
  ((1,10,5),(1,10,6),GraphemeClusterBreak::Extend),
  ((1,10,12),(1,10,15),GraphemeClusterBreak::Extend),
  ((1,10,56),(1,10,58),GraphemeClusterBreak::Extend),
  ((1,10,63),(1,10,63),GraphemeClusterBreak::Extend),
  ((1,10,229),(1,10,230),GraphemeClusterBreak::Extend),
  ((1,16,0),(1,16,0),GraphemeClusterBreak::SpacingMark),
  ((1,16,1),(1,16,1),GraphemeClusterBreak::Extend),
  ((1,16,2),(1,16,2),GraphemeClusterBreak::SpacingMark),
  ((1,16,56),(1,16,70),GraphemeClusterBreak::Extend),
  ((1,16,127),(1,16,129),GraphemeClusterBreak::Extend),
  ((1,16,130),(1,16,130),GraphemeClusterBreak::SpacingMark),
  ((1,16,176),(1,16,178),GraphemeClusterBreak::SpacingMark),
  ((1,16,179),(1,16,182),GraphemeClusterBreak::Extend),
  ((1,16,183),(1,16,184),GraphemeClusterBreak::SpacingMark),
  ((1,16,185),(1,16,186),GraphemeClusterBreak::Extend),
  ((1,16,189),(1,16,189),GraphemeClusterBreak::Prepend),
  ((1,17,0),(1,17,2),GraphemeClusterBreak::Extend),
  ((1,17,39),(1,17,43),GraphemeClusterBreak::Extend),
  ((1,17,44),(1,17,44),GraphemeClusterBreak::SpacingMark),
  ((1,17,45),(1,17,52),GraphemeClusterBreak::Extend),
  ((1,17,115),(1,17,115),GraphemeClusterBreak::Extend),
  ((1,17,128),(1,17,129),GraphemeClusterBreak::Extend),
  ((1,17,130),(1,17,130),GraphemeClusterBreak::SpacingMark),
  ((1,17,179),(1,17,181),GraphemeClusterBreak::SpacingMark),
  ((1,17,182),(1,17,190),GraphemeClusterBreak::Extend),
  ((1,17,191),(1,17,192),GraphemeClusterBreak::SpacingMark),
  ((1,17,194),(1,17,195),GraphemeClusterBreak::Prepend),
  ((1,17,202),(1,17,204),GraphemeClusterBreak::Extend),
  ((1,18,44),(1,18,46),GraphemeClusterBreak::SpacingMark),
  ((1,18,47),(1,18,49),GraphemeClusterBreak::Extend),
  ((1,18,50),(1,18,51),GraphemeClusterBreak::SpacingMark),
  ((1,18,52),(1,18,52),GraphemeClusterBreak::Extend),
  ((1,18,53),(1,18,53),GraphemeClusterBreak::SpacingMark),
  ((1,18,54),(1,18,55),GraphemeClusterBreak::Extend),
  ((1,18,62),(1,18,62),GraphemeClusterBreak::Extend),
  ((1,18,223),(1,18,223),GraphemeClusterBreak::Extend),
  ((1,18,224),(1,18,226),GraphemeClusterBreak::SpacingMark),
  ((1,18,227),(1,18,234),GraphemeClusterBreak::Extend),
  ((1,19,0),(1,19,1),GraphemeClusterBreak::Extend),
  ((1,19,2),(1,19,3),GraphemeClusterBreak::SpacingMark),
  ((1,19,60),(1,19,60),GraphemeClusterBreak::Extend),
  ((1,19,62),(1,19,62),GraphemeClusterBreak::Extend),
  ((1,19,63),(1,19,63),GraphemeClusterBreak::SpacingMark),
  ((1,19,64),(1,19,64),GraphemeClusterBreak::Extend),
  ((1,19,65),(1,19,68),GraphemeClusterBreak::SpacingMark),
  ((1,19,71),(1,19,72),GraphemeClusterBreak::SpacingMark),
  ((1,19,75),(1,19,77),GraphemeClusterBreak::SpacingMark),
  ((1,19,87),(1,19,87),GraphemeClusterBreak::Extend),
  ((1,19,98),(1,19,99),GraphemeClusterBreak::SpacingMark),
  ((1,19,102),(1,19,108),GraphemeClusterBreak::Extend),
  ((1,19,112),(1,19,116),GraphemeClusterBreak::Extend),
  ((1,20,53),(1,20,55),GraphemeClusterBreak::SpacingMark),
  ((1,20,56),(1,20,63),GraphemeClusterBreak::Extend),
  ((1,20,64),(1,20,65),GraphemeClusterBreak::SpacingMark),
  ((1,20,66),(1,20,68),GraphemeClusterBreak::Extend),
  ((1,20,69),(1,20,69),GraphemeClusterBreak::SpacingMark),
  ((1,20,70),(1,20,70),GraphemeClusterBreak::Extend),
  ((1,20,176),(1,20,176),GraphemeClusterBreak::Extend),
  ((1,20,177),(1,20,178),GraphemeClusterBreak::SpacingMark),
  ((1,20,179),(1,20,184),GraphemeClusterBreak::Extend),
  ((1,20,185),(1,20,185),GraphemeClusterBreak::SpacingMark),
  ((1,20,186),(1,20,186),GraphemeClusterBreak::Extend),
  ((1,20,187),(1,20,188),GraphemeClusterBreak::SpacingMark),
  ((1,20,189),(1,20,189),GraphemeClusterBreak::Extend),
  ((1,20,190),(1,20,190),GraphemeClusterBreak::SpacingMark),
  ((1,20,191),(1,20,192),GraphemeClusterBreak::Extend),
  ((1,20,193),(1,20,193),GraphemeClusterBreak::SpacingMark),
  ((1,20,194),(1,20,195),GraphemeClusterBreak::Extend),
  ((1,21,175),(1,21,175),GraphemeClusterBreak::Extend),
  ((1,21,176),(1,21,177),GraphemeClusterBreak::SpacingMark),
  ((1,21,178),(1,21,181),GraphemeClusterBreak::Extend),
  ((1,21,184),(1,21,187),GraphemeClusterBreak::SpacingMark),
  ((1,21,188),(1,21,189),GraphemeClusterBreak::Extend),
  ((1,21,190),(1,21,190),GraphemeClusterBreak::SpacingMark),
  ((1,21,191),(1,21,192),GraphemeClusterBreak::Extend),
  ((1,21,220),(1,21,221),GraphemeClusterBreak::Extend),
  ((1,22,48),(1,22,50),GraphemeClusterBreak::SpacingMark),
  ((1,22,51),(1,22,58),GraphemeClusterBreak::Extend),
  ((1,22,59),(1,22,60),GraphemeClusterBreak::SpacingMark),
  ((1,22,61),(1,22,61),GraphemeClusterBreak::Extend),
  ((1,22,62),(1,22,62),GraphemeClusterBreak::SpacingMark),
  ((1,22,63),(1,22,64),GraphemeClusterBreak::Extend),
  ((1,22,171),(1,22,171),GraphemeClusterBreak::Extend),
  ((1,22,172),(1,22,172),GraphemeClusterBreak::SpacingMark),
  ((1,22,173),(1,22,173),GraphemeClusterBreak::Extend),
  ((1,22,174),(1,22,175),GraphemeClusterBreak::SpacingMark),
  ((1,22,176),(1,22,181),GraphemeClusterBreak::Extend),
  ((1,22,182),(1,22,182),GraphemeClusterBreak::SpacingMark),
  ((1,22,183),(1,22,183),GraphemeClusterBreak::Extend),
  ((1,23,29),(1,23,31),GraphemeClusterBreak::Extend),
  ((1,23,32),(1,23,33),GraphemeClusterBreak::SpacingMark),
  ((1,23,34),(1,23,37),GraphemeClusterBreak::Extend),
  ((1,23,38),(1,23,38),GraphemeClusterBreak::SpacingMark),
  ((1,23,39),(1,23,43),GraphemeClusterBreak::Extend),
  ((1,28,47),(1,28,47),GraphemeClusterBreak::SpacingMark),
  ((1,28,48),(1,28,54),GraphemeClusterBreak::Extend),
  ((1,28,56),(1,28,61),GraphemeClusterBreak::Extend),
  ((1,28,62),(1,28,62),GraphemeClusterBreak::SpacingMark),
  ((1,28,63),(1,28,63),GraphemeClusterBreak::Extend),
  ((1,28,146),(1,28,167),GraphemeClusterBreak::Extend),
  ((1,28,169),(1,28,169),GraphemeClusterBreak::SpacingMark),
  ((1,28,170),(1,28,176),GraphemeClusterBreak::Extend),
  ((1,28,177),(1,28,177),GraphemeClusterBreak::SpacingMark),
  ((1,28,178),(1,28,179),GraphemeClusterBreak::Extend),
  ((1,28,180),(1,28,180),GraphemeClusterBreak::SpacingMark),
  ((1,28,181),(1,28,182),GraphemeClusterBreak::Extend),
  ((1,106,240),(1,106,244),GraphemeClusterBreak::Extend),
  ((1,107,48),(1,107,54),GraphemeClusterBreak::Extend),
  ((1,111,81),(1,111,126),GraphemeClusterBreak::SpacingMark),
  ((1,111,143),(1,111,146),GraphemeClusterBreak::Extend),
  ((1,188,157),(1,188,158),GraphemeClusterBreak::Extend),
  ((1,188,160),(1,188,163),GraphemeClusterBreak::Control),
  ((1,209,101),(1,209,101),GraphemeClusterBreak::Extend),
  ((1,209,102),(1,209,102),GraphemeClusterBreak::SpacingMark),
  ((1,209,103),(1,209,105),GraphemeClusterBreak::Extend),
  ((1,209,109),(1,209,109),GraphemeClusterBreak::SpacingMark),
  ((1,209,110),(1,209,114),GraphemeClusterBreak::Extend),
  ((1,209,115),(1,209,122),GraphemeClusterBreak::Control),
  ((1,209,123),(1,209,130),GraphemeClusterBreak::Extend),
  ((1,209,133),(1,209,139),GraphemeClusterBreak::Extend),
  ((1,209,170),(1,209,173),GraphemeClusterBreak::Extend),
  ((1,210,66),(1,210,68),GraphemeClusterBreak::Extend),
  ((1,218,0),(1,218,54),GraphemeClusterBreak::Extend),
  ((1,218,59),(1,218,108),GraphemeClusterBreak::Extend),
  ((1,218,117),(1,218,117),GraphemeClusterBreak::Extend),
  ((1,218,132),(1,218,132),GraphemeClusterBreak::Extend),
  ((1,218,155),(1,218,159),GraphemeClusterBreak::Extend),
  ((1,218,161),(1,218,175),GraphemeClusterBreak::Extend),
  ((1,224,0),(1,224,6),GraphemeClusterBreak::Extend),
  ((1,224,8),(1,224,24),GraphemeClusterBreak::Extend),
  ((1,224,27),(1,224,33),GraphemeClusterBreak::Extend),
  ((1,224,35),(1,224,36),GraphemeClusterBreak::Extend),
  ((1,224,38),(1,224,42),GraphemeClusterBreak::Extend),
  ((1,232,208),(1,232,214),GraphemeClusterBreak::Extend),
  ((1,233,68),(1,233,74),GraphemeClusterBreak::Extend),
  ((1,241,230),(1,241,255),GraphemeClusterBreak::RegionalIndicator),
  ((1,243,133),(1,243,133),GraphemeClusterBreak::EmojiModifierBase),
  ((1,243,195),(1,243,196),GraphemeClusterBreak::EmojiModifierBase),
  ((1,243,202),(1,243,203),GraphemeClusterBreak::EmojiModifierBase),
  ((1,243,251),(1,243,255),GraphemeClusterBreak::EmojiModifier),
  ((1,244,66),(1,244,67),GraphemeClusterBreak::EmojiModifierBase),
  ((1,244,70),(1,244,80),GraphemeClusterBreak::EmojiModifierBase),
  ((1,244,102),(1,244,105),GraphemeClusterBreak::EmojiModiferBaseAfterZWJ),
  ((1,244,110),(1,244,110),GraphemeClusterBreak::EmojiModifierBase),
  ((1,244,112),(1,244,120),GraphemeClusterBreak::EmojiModifierBase),
  ((1,244,124),(1,244,124),GraphemeClusterBreak::EmojiModifierBase),
  ((1,244,129),(1,244,131),GraphemeClusterBreak::EmojiModifierBase),
  ((1,244,133),(1,244,135),GraphemeClusterBreak::EmojiModifierBase),
  ((1,244,139),(1,244,139),GraphemeClusterBreak::GlueAfterZWJ),
  ((1,244,170),(1,244,170),GraphemeClusterBreak::EmojiModifierBase),
  ((1,245,117),(1,245,117),GraphemeClusterBreak::EmojiModifierBase),
  ((1,245,122),(1,245,122),GraphemeClusterBreak::EmojiModifierBase),
  ((1,245,144),(1,245,144),GraphemeClusterBreak::EmojiModifierBase),
  ((1,245,149),(1,245,150),GraphemeClusterBreak::EmojiModifierBase),
  ((1,245,232),(1,245,232),GraphemeClusterBreak::GlueAfterZWJ),
  ((1,246,69),(1,246,71),GraphemeClusterBreak::EmojiModifierBase),
  ((1,246,75),(1,246,79),GraphemeClusterBreak::EmojiModifierBase),
  ((1,246,163),(1,246,163),GraphemeClusterBreak::EmojiModifierBase),
  ((1,246,180),(1,246,182),GraphemeClusterBreak::EmojiModifierBase),
  ((1,246,192),(1,246,192),GraphemeClusterBreak::EmojiModifierBase),
  ((1,249,24),(1,249,30),GraphemeClusterBreak::EmojiModifierBase),
  ((1,249,38),(1,249,38),GraphemeClusterBreak::EmojiModifierBase),
  ((1,249,48),(1,249,48),GraphemeClusterBreak::EmojiModifierBase),
  ((1,249,51),(1,249,57),GraphemeClusterBreak::EmojiModifierBase),
  ((1,249,60),(1,249,62),GraphemeClusterBreak::EmojiModifierBase),
  ((14,0,0),(14,0,31),GraphemeClusterBreak::Control),
  ((14,0,32),(14,0,127),GraphemeClusterBreak::Extend),
  ((14,0,128),(14,0,255),GraphemeClusterBreak::Control),
  ((14,1,0),(14,1,239),GraphemeClusterBreak::Extend),
  ((14,1,240),(14,15,255),GraphemeClusterBreak::Control)
];

#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum WordBreak {
  CarriageReturn, DoubleQuote, EmojiModifier, EmojiModifierBase,
  EmojiModifierBaseAfterZWJ, ExtendNumLet, Extend, Format, GlueAfterZWJ,
  HebrewLetter, Katakana, ALetter, LineFeed, MidNumericLetter, MidLetter,
  MidNumeric, Newline, Numeric, RegionalIndicator, SingleQuote, Other,
  ZeroWidthJoiner
}

pub static UCD_WBRK: &'static [((u8,u8,u8), (u8,u8,u8), WordBreak)] = &[
  ((0,0,10),(0,0,10),WordBreak::LineFeed),
  ((0,0,11),(0,0,12),WordBreak::Newline),
  ((0,0,13),(0,0,13),WordBreak::CarriageReturn),
  ((0,0,34),(0,0,34),WordBreak::DoubleQuote),
  ((0,0,39),(0,0,39),WordBreak::SingleQuote),
  ((0,0,44),(0,0,44),WordBreak::MidNumeric),
  ((0,0,46),(0,0,46),WordBreak::MidNumericLetter),
  ((0,0,48),(0,0,57),WordBreak::Numeric),
  ((0,0,58),(0,0,58),WordBreak::MidLetter),
  ((0,0,59),(0,0,59),WordBreak::MidNumeric),
  ((0,0,65),(0,0,90),WordBreak::ALetter),
  ((0,0,95),(0,0,95),WordBreak::ExtendNumLet),
  ((0,0,97),(0,0,122),WordBreak::ALetter),
  ((0,0,133),(0,0,133),WordBreak::Newline),
  ((0,0,170),(0,0,170),WordBreak::ALetter),
  ((0,0,173),(0,0,173),WordBreak::Format),
  ((0,0,181),(0,0,181),WordBreak::ALetter),
  ((0,0,183),(0,0,183),WordBreak::MidLetter),
  ((0,0,186),(0,0,186),WordBreak::ALetter),
  ((0,0,192),(0,0,214),WordBreak::ALetter),
  ((0,0,216),(0,0,246),WordBreak::ALetter),
  ((0,0,248),(0,2,193),WordBreak::ALetter),
  ((0,2,198),(0,2,209),WordBreak::ALetter),
  ((0,2,215),(0,2,215),WordBreak::MidLetter),
  ((0,2,224),(0,2,228),WordBreak::ALetter),
  ((0,2,236),(0,2,236),WordBreak::ALetter),
  ((0,2,238),(0,2,238),WordBreak::ALetter),
  ((0,3,0),(0,3,111),WordBreak::Extend),
  ((0,3,112),(0,3,116),WordBreak::ALetter),
  ((0,3,118),(0,3,119),WordBreak::ALetter),
  ((0,3,122),(0,3,125),WordBreak::ALetter),
  ((0,3,126),(0,3,126),WordBreak::MidNumeric),
  ((0,3,127),(0,3,127),WordBreak::ALetter),
  ((0,3,134),(0,3,134),WordBreak::ALetter),
  ((0,3,135),(0,3,135),WordBreak::MidLetter),
  ((0,3,136),(0,3,138),WordBreak::ALetter),
  ((0,3,140),(0,3,140),WordBreak::ALetter),
  ((0,3,142),(0,3,161),WordBreak::ALetter),
  ((0,3,163),(0,3,245),WordBreak::ALetter),
  ((0,3,247),(0,4,129),WordBreak::ALetter),
  ((0,4,131),(0,4,137),WordBreak::Extend),
  ((0,4,138),(0,5,47),WordBreak::ALetter),
  ((0,5,49),(0,5,86),WordBreak::ALetter),
  ((0,5,89),(0,5,89),WordBreak::ALetter),
  ((0,5,97),(0,5,135),WordBreak::ALetter),
  ((0,5,137),(0,5,137),WordBreak::MidNumeric),
  ((0,5,145),(0,5,189),WordBreak::Extend),
  ((0,5,191),(0,5,191),WordBreak::Extend),
  ((0,5,193),(0,5,194),WordBreak::Extend),
  ((0,5,196),(0,5,197),WordBreak::Extend),
  ((0,5,199),(0,5,199),WordBreak::Extend),
  ((0,5,208),(0,5,234),WordBreak::HebrewLetter),
  ((0,5,240),(0,5,242),WordBreak::HebrewLetter),
  ((0,5,243),(0,5,243),WordBreak::ALetter),
  ((0,5,244),(0,5,244),WordBreak::MidLetter),
  ((0,6,0),(0,6,5),WordBreak::Format),
  ((0,6,12),(0,6,13),WordBreak::MidNumeric),
  ((0,6,16),(0,6,26),WordBreak::Extend), ((0,6,28),(0,6,28),WordBreak::Format),
  ((0,6,32),(0,6,74),WordBreak::ALetter), ((0,6,75),(0,6,95),WordBreak::Extend),
  ((0,6,96),(0,6,105),WordBreak::Numeric),
  ((0,6,107),(0,6,107),WordBreak::Numeric),
  ((0,6,108),(0,6,108),WordBreak::MidNumeric),
  ((0,6,110),(0,6,111),WordBreak::ALetter),
  ((0,6,112),(0,6,112),WordBreak::Extend),
  ((0,6,113),(0,6,211),WordBreak::ALetter),
  ((0,6,213),(0,6,213),WordBreak::ALetter),
  ((0,6,214),(0,6,220),WordBreak::Extend),
  ((0,6,221),(0,6,221),WordBreak::Format),
  ((0,6,223),(0,6,228),WordBreak::Extend),
  ((0,6,229),(0,6,230),WordBreak::ALetter),
  ((0,6,231),(0,6,232),WordBreak::Extend),
  ((0,6,234),(0,6,237),WordBreak::Extend),
  ((0,6,238),(0,6,239),WordBreak::ALetter),
  ((0,6,240),(0,6,249),WordBreak::Numeric),
  ((0,6,250),(0,6,252),WordBreak::ALetter),
  ((0,6,255),(0,6,255),WordBreak::ALetter),
  ((0,7,15),(0,7,15),WordBreak::Format), ((0,7,16),(0,7,16),WordBreak::ALetter),
  ((0,7,17),(0,7,17),WordBreak::Extend), ((0,7,18),(0,7,47),WordBreak::ALetter),
  ((0,7,48),(0,7,74),WordBreak::Extend),
  ((0,7,77),(0,7,165),WordBreak::ALetter),
  ((0,7,166),(0,7,176),WordBreak::Extend),
  ((0,7,177),(0,7,177),WordBreak::ALetter),
  ((0,7,192),(0,7,201),WordBreak::Numeric),
  ((0,7,202),(0,7,234),WordBreak::ALetter),
  ((0,7,235),(0,7,243),WordBreak::Extend),
  ((0,7,244),(0,7,245),WordBreak::ALetter),
  ((0,7,248),(0,7,248),WordBreak::MidNumeric),
  ((0,7,250),(0,7,250),WordBreak::ALetter),
  ((0,8,0),(0,8,21),WordBreak::ALetter), ((0,8,22),(0,8,25),WordBreak::Extend),
  ((0,8,26),(0,8,26),WordBreak::ALetter), ((0,8,27),(0,8,35),WordBreak::Extend),
  ((0,8,36),(0,8,36),WordBreak::ALetter), ((0,8,37),(0,8,39),WordBreak::Extend),
  ((0,8,40),(0,8,40),WordBreak::ALetter), ((0,8,41),(0,8,45),WordBreak::Extend),
  ((0,8,64),(0,8,88),WordBreak::ALetter), ((0,8,89),(0,8,91),WordBreak::Extend),
  ((0,8,160),(0,8,180),WordBreak::ALetter),
  ((0,8,182),(0,8,189),WordBreak::ALetter),
  ((0,8,212),(0,8,225),WordBreak::Extend),
  ((0,8,226),(0,8,226),WordBreak::Format),
  ((0,8,227),(0,9,3),WordBreak::Extend), ((0,9,4),(0,9,57),WordBreak::ALetter),
  ((0,9,58),(0,9,60),WordBreak::Extend), ((0,9,61),(0,9,61),WordBreak::ALetter),
  ((0,9,62),(0,9,79),WordBreak::Extend), ((0,9,80),(0,9,80),WordBreak::ALetter),
  ((0,9,81),(0,9,87),WordBreak::Extend), ((0,9,88),(0,9,97),WordBreak::ALetter),
  ((0,9,98),(0,9,99),WordBreak::Extend),
  ((0,9,102),(0,9,111),WordBreak::Numeric),
  ((0,9,113),(0,9,128),WordBreak::ALetter),
  ((0,9,129),(0,9,131),WordBreak::Extend),
  ((0,9,133),(0,9,140),WordBreak::ALetter),
  ((0,9,143),(0,9,144),WordBreak::ALetter),
  ((0,9,147),(0,9,168),WordBreak::ALetter),
  ((0,9,170),(0,9,176),WordBreak::ALetter),
  ((0,9,178),(0,9,178),WordBreak::ALetter),
  ((0,9,182),(0,9,185),WordBreak::ALetter),
  ((0,9,188),(0,9,188),WordBreak::Extend),
  ((0,9,189),(0,9,189),WordBreak::ALetter),
  ((0,9,190),(0,9,196),WordBreak::Extend),
  ((0,9,199),(0,9,200),WordBreak::Extend),
  ((0,9,203),(0,9,205),WordBreak::Extend),
  ((0,9,206),(0,9,206),WordBreak::ALetter),
  ((0,9,215),(0,9,215),WordBreak::Extend),
  ((0,9,220),(0,9,221),WordBreak::ALetter),
  ((0,9,223),(0,9,225),WordBreak::ALetter),
  ((0,9,226),(0,9,227),WordBreak::Extend),
  ((0,9,230),(0,9,239),WordBreak::Numeric),
  ((0,9,240),(0,9,241),WordBreak::ALetter),
  ((0,10,1),(0,10,3),WordBreak::Extend),
  ((0,10,5),(0,10,10),WordBreak::ALetter),
  ((0,10,15),(0,10,16),WordBreak::ALetter),
  ((0,10,19),(0,10,40),WordBreak::ALetter),
  ((0,10,42),(0,10,48),WordBreak::ALetter),
  ((0,10,50),(0,10,51),WordBreak::ALetter),
  ((0,10,53),(0,10,54),WordBreak::ALetter),
  ((0,10,56),(0,10,57),WordBreak::ALetter),
  ((0,10,60),(0,10,60),WordBreak::Extend),
  ((0,10,62),(0,10,66),WordBreak::Extend),
  ((0,10,71),(0,10,72),WordBreak::Extend),
  ((0,10,75),(0,10,77),WordBreak::Extend),
  ((0,10,81),(0,10,81),WordBreak::Extend),
  ((0,10,89),(0,10,92),WordBreak::ALetter),
  ((0,10,94),(0,10,94),WordBreak::ALetter),
  ((0,10,102),(0,10,111),WordBreak::Numeric),
  ((0,10,112),(0,10,113),WordBreak::Extend),
  ((0,10,114),(0,10,116),WordBreak::ALetter),
  ((0,10,117),(0,10,117),WordBreak::Extend),
  ((0,10,129),(0,10,131),WordBreak::Extend),
  ((0,10,133),(0,10,141),WordBreak::ALetter),
  ((0,10,143),(0,10,145),WordBreak::ALetter),
  ((0,10,147),(0,10,168),WordBreak::ALetter),
  ((0,10,170),(0,10,176),WordBreak::ALetter),
  ((0,10,178),(0,10,179),WordBreak::ALetter),
  ((0,10,181),(0,10,185),WordBreak::ALetter),
  ((0,10,188),(0,10,188),WordBreak::Extend),
  ((0,10,189),(0,10,189),WordBreak::ALetter),
  ((0,10,190),(0,10,197),WordBreak::Extend),
  ((0,10,199),(0,10,201),WordBreak::Extend),
  ((0,10,203),(0,10,205),WordBreak::Extend),
  ((0,10,208),(0,10,208),WordBreak::ALetter),
  ((0,10,224),(0,10,225),WordBreak::ALetter),
  ((0,10,226),(0,10,227),WordBreak::Extend),
  ((0,10,230),(0,10,239),WordBreak::Numeric),
  ((0,10,249),(0,10,249),WordBreak::ALetter),
  ((0,11,1),(0,11,3),WordBreak::Extend),
  ((0,11,5),(0,11,12),WordBreak::ALetter),
  ((0,11,15),(0,11,16),WordBreak::ALetter),
  ((0,11,19),(0,11,40),WordBreak::ALetter),
  ((0,11,42),(0,11,48),WordBreak::ALetter),
  ((0,11,50),(0,11,51),WordBreak::ALetter),
  ((0,11,53),(0,11,57),WordBreak::ALetter),
  ((0,11,60),(0,11,60),WordBreak::Extend),
  ((0,11,61),(0,11,61),WordBreak::ALetter),
  ((0,11,62),(0,11,68),WordBreak::Extend),
  ((0,11,71),(0,11,72),WordBreak::Extend),
  ((0,11,75),(0,11,77),WordBreak::Extend),
  ((0,11,86),(0,11,87),WordBreak::Extend),
  ((0,11,92),(0,11,93),WordBreak::ALetter),
  ((0,11,95),(0,11,97),WordBreak::ALetter),
  ((0,11,98),(0,11,99),WordBreak::Extend),
  ((0,11,102),(0,11,111),WordBreak::Numeric),
  ((0,11,113),(0,11,113),WordBreak::ALetter),
  ((0,11,130),(0,11,130),WordBreak::Extend),
  ((0,11,131),(0,11,131),WordBreak::ALetter),
  ((0,11,133),(0,11,138),WordBreak::ALetter),
  ((0,11,142),(0,11,144),WordBreak::ALetter),
  ((0,11,146),(0,11,149),WordBreak::ALetter),
  ((0,11,153),(0,11,154),WordBreak::ALetter),
  ((0,11,156),(0,11,156),WordBreak::ALetter),
  ((0,11,158),(0,11,159),WordBreak::ALetter),
  ((0,11,163),(0,11,164),WordBreak::ALetter),
  ((0,11,168),(0,11,170),WordBreak::ALetter),
  ((0,11,174),(0,11,185),WordBreak::ALetter),
  ((0,11,190),(0,11,194),WordBreak::Extend),
  ((0,11,198),(0,11,200),WordBreak::Extend),
  ((0,11,202),(0,11,205),WordBreak::Extend),
  ((0,11,208),(0,11,208),WordBreak::ALetter),
  ((0,11,215),(0,11,215),WordBreak::Extend),
  ((0,11,230),(0,11,239),WordBreak::Numeric),
  ((0,12,0),(0,12,3),WordBreak::Extend),
  ((0,12,5),(0,12,12),WordBreak::ALetter),
  ((0,12,14),(0,12,16),WordBreak::ALetter),
  ((0,12,18),(0,12,40),WordBreak::ALetter),
  ((0,12,42),(0,12,57),WordBreak::ALetter),
  ((0,12,61),(0,12,61),WordBreak::ALetter),
  ((0,12,62),(0,12,68),WordBreak::Extend),
  ((0,12,70),(0,12,72),WordBreak::Extend),
  ((0,12,74),(0,12,77),WordBreak::Extend),
  ((0,12,85),(0,12,86),WordBreak::Extend),
  ((0,12,88),(0,12,90),WordBreak::ALetter),
  ((0,12,96),(0,12,97),WordBreak::ALetter),
  ((0,12,98),(0,12,99),WordBreak::Extend),
  ((0,12,102),(0,12,111),WordBreak::Numeric),
  ((0,12,128),(0,12,128),WordBreak::ALetter),
  ((0,12,129),(0,12,131),WordBreak::Extend),
  ((0,12,133),(0,12,140),WordBreak::ALetter),
  ((0,12,142),(0,12,144),WordBreak::ALetter),
  ((0,12,146),(0,12,168),WordBreak::ALetter),
  ((0,12,170),(0,12,179),WordBreak::ALetter),
  ((0,12,181),(0,12,185),WordBreak::ALetter),
  ((0,12,188),(0,12,188),WordBreak::Extend),
  ((0,12,189),(0,12,189),WordBreak::ALetter),
  ((0,12,190),(0,12,196),WordBreak::Extend),
  ((0,12,198),(0,12,200),WordBreak::Extend),
  ((0,12,202),(0,12,205),WordBreak::Extend),
  ((0,12,213),(0,12,214),WordBreak::Extend),
  ((0,12,222),(0,12,222),WordBreak::ALetter),
  ((0,12,224),(0,12,225),WordBreak::ALetter),
  ((0,12,226),(0,12,227),WordBreak::Extend),
  ((0,12,230),(0,12,239),WordBreak::Numeric),
  ((0,12,241),(0,12,242),WordBreak::ALetter),
  ((0,13,1),(0,13,3),WordBreak::Extend),
  ((0,13,5),(0,13,12),WordBreak::ALetter),
  ((0,13,14),(0,13,16),WordBreak::ALetter),
  ((0,13,18),(0,13,58),WordBreak::ALetter),
  ((0,13,61),(0,13,61),WordBreak::ALetter),
  ((0,13,62),(0,13,68),WordBreak::Extend),
  ((0,13,70),(0,13,72),WordBreak::Extend),
  ((0,13,74),(0,13,77),WordBreak::Extend),
  ((0,13,78),(0,13,78),WordBreak::ALetter),
  ((0,13,84),(0,13,86),WordBreak::ALetter),
  ((0,13,87),(0,13,87),WordBreak::Extend),
  ((0,13,95),(0,13,97),WordBreak::ALetter),
  ((0,13,98),(0,13,99),WordBreak::Extend),
  ((0,13,102),(0,13,111),WordBreak::Numeric),
  ((0,13,122),(0,13,127),WordBreak::ALetter),
  ((0,13,130),(0,13,131),WordBreak::Extend),
  ((0,13,133),(0,13,150),WordBreak::ALetter),
  ((0,13,154),(0,13,177),WordBreak::ALetter),
  ((0,13,179),(0,13,187),WordBreak::ALetter),
  ((0,13,189),(0,13,189),WordBreak::ALetter),
  ((0,13,192),(0,13,198),WordBreak::ALetter),
  ((0,13,202),(0,13,202),WordBreak::Extend),
  ((0,13,207),(0,13,212),WordBreak::Extend),
  ((0,13,214),(0,13,214),WordBreak::Extend),
  ((0,13,216),(0,13,223),WordBreak::Extend),
  ((0,13,230),(0,13,239),WordBreak::Numeric),
  ((0,13,242),(0,13,243),WordBreak::Extend),
  ((0,14,49),(0,14,49),WordBreak::Extend),
  ((0,14,52),(0,14,58),WordBreak::Extend),
  ((0,14,71),(0,14,78),WordBreak::Extend),
  ((0,14,80),(0,14,89),WordBreak::Numeric),
  ((0,14,177),(0,14,177),WordBreak::Extend),
  ((0,14,180),(0,14,185),WordBreak::Extend),
  ((0,14,187),(0,14,188),WordBreak::Extend),
  ((0,14,200),(0,14,205),WordBreak::Extend),
  ((0,14,208),(0,14,217),WordBreak::Numeric),
  ((0,15,0),(0,15,0),WordBreak::ALetter),
  ((0,15,24),(0,15,25),WordBreak::Extend),
  ((0,15,32),(0,15,41),WordBreak::Numeric),
  ((0,15,53),(0,15,53),WordBreak::Extend),
  ((0,15,55),(0,15,55),WordBreak::Extend),
  ((0,15,57),(0,15,57),WordBreak::Extend),
  ((0,15,62),(0,15,63),WordBreak::Extend),
  ((0,15,64),(0,15,71),WordBreak::ALetter),
  ((0,15,73),(0,15,108),WordBreak::ALetter),
  ((0,15,113),(0,15,132),WordBreak::Extend),
  ((0,15,134),(0,15,135),WordBreak::Extend),
  ((0,15,136),(0,15,140),WordBreak::ALetter),
  ((0,15,141),(0,15,151),WordBreak::Extend),
  ((0,15,153),(0,15,188),WordBreak::Extend),
  ((0,15,198),(0,15,198),WordBreak::Extend),
  ((0,16,43),(0,16,62),WordBreak::Extend),
  ((0,16,64),(0,16,73),WordBreak::Numeric),
  ((0,16,86),(0,16,89),WordBreak::Extend),
  ((0,16,94),(0,16,96),WordBreak::Extend),
  ((0,16,98),(0,16,100),WordBreak::Extend),
  ((0,16,103),(0,16,109),WordBreak::Extend),
  ((0,16,113),(0,16,116),WordBreak::Extend),
  ((0,16,130),(0,16,141),WordBreak::Extend),
  ((0,16,143),(0,16,143),WordBreak::Extend),
  ((0,16,144),(0,16,153),WordBreak::Numeric),
  ((0,16,154),(0,16,157),WordBreak::Extend),
  ((0,16,160),(0,16,197),WordBreak::ALetter),
  ((0,16,199),(0,16,199),WordBreak::ALetter),
  ((0,16,205),(0,16,205),WordBreak::ALetter),
  ((0,16,208),(0,16,250),WordBreak::ALetter),
  ((0,16,252),(0,18,72),WordBreak::ALetter),
  ((0,18,74),(0,18,77),WordBreak::ALetter),
  ((0,18,80),(0,18,86),WordBreak::ALetter),
  ((0,18,88),(0,18,88),WordBreak::ALetter),
  ((0,18,90),(0,18,93),WordBreak::ALetter),
  ((0,18,96),(0,18,136),WordBreak::ALetter),
  ((0,18,138),(0,18,141),WordBreak::ALetter),
  ((0,18,144),(0,18,176),WordBreak::ALetter),
  ((0,18,178),(0,18,181),WordBreak::ALetter),
  ((0,18,184),(0,18,190),WordBreak::ALetter),
  ((0,18,192),(0,18,192),WordBreak::ALetter),
  ((0,18,194),(0,18,197),WordBreak::ALetter),
  ((0,18,200),(0,18,214),WordBreak::ALetter),
  ((0,18,216),(0,19,16),WordBreak::ALetter),
  ((0,19,18),(0,19,21),WordBreak::ALetter),
  ((0,19,24),(0,19,90),WordBreak::ALetter),
  ((0,19,93),(0,19,95),WordBreak::Extend),
  ((0,19,128),(0,19,143),WordBreak::ALetter),
  ((0,19,160),(0,19,245),WordBreak::ALetter),
  ((0,19,248),(0,19,253),WordBreak::ALetter),
  ((0,20,1),(0,22,108),WordBreak::ALetter),
  ((0,22,111),(0,22,127),WordBreak::ALetter),
  ((0,22,129),(0,22,154),WordBreak::ALetter),
  ((0,22,160),(0,22,234),WordBreak::ALetter),
  ((0,22,238),(0,22,248),WordBreak::ALetter),
  ((0,23,0),(0,23,12),WordBreak::ALetter),
  ((0,23,14),(0,23,17),WordBreak::ALetter),
  ((0,23,18),(0,23,20),WordBreak::Extend),
  ((0,23,32),(0,23,49),WordBreak::ALetter),
  ((0,23,50),(0,23,52),WordBreak::Extend),
  ((0,23,64),(0,23,81),WordBreak::ALetter),
  ((0,23,82),(0,23,83),WordBreak::Extend),
  ((0,23,96),(0,23,108),WordBreak::ALetter),
  ((0,23,110),(0,23,112),WordBreak::ALetter),
  ((0,23,114),(0,23,115),WordBreak::Extend),
  ((0,23,180),(0,23,211),WordBreak::Extend),
  ((0,23,221),(0,23,221),WordBreak::Extend),
  ((0,23,224),(0,23,233),WordBreak::Numeric),
  ((0,24,11),(0,24,13),WordBreak::Extend),
  ((0,24,14),(0,24,14),WordBreak::Format),
  ((0,24,16),(0,24,25),WordBreak::Numeric),
  ((0,24,32),(0,24,119),WordBreak::ALetter),
  ((0,24,128),(0,24,132),WordBreak::ALetter),
  ((0,24,133),(0,24,134),WordBreak::Extend),
  ((0,24,135),(0,24,168),WordBreak::ALetter),
  ((0,24,169),(0,24,169),WordBreak::Extend),
  ((0,24,170),(0,24,170),WordBreak::ALetter),
  ((0,24,176),(0,24,245),WordBreak::ALetter),
  ((0,25,0),(0,25,30),WordBreak::ALetter),
  ((0,25,32),(0,25,43),WordBreak::Extend),
  ((0,25,48),(0,25,59),WordBreak::Extend),
  ((0,25,70),(0,25,79),WordBreak::Numeric),
  ((0,25,208),(0,25,217),WordBreak::Numeric),
  ((0,26,0),(0,26,22),WordBreak::ALetter),
  ((0,26,23),(0,26,27),WordBreak::Extend),
  ((0,26,85),(0,26,94),WordBreak::Extend),
  ((0,26,96),(0,26,124),WordBreak::Extend),
  ((0,26,127),(0,26,127),WordBreak::Extend),
  ((0,26,128),(0,26,137),WordBreak::Numeric),
  ((0,26,144),(0,26,153),WordBreak::Numeric),
  ((0,26,176),(0,26,190),WordBreak::Extend),
  ((0,27,0),(0,27,4),WordBreak::Extend),
  ((0,27,5),(0,27,51),WordBreak::ALetter),
  ((0,27,52),(0,27,68),WordBreak::Extend),
  ((0,27,69),(0,27,75),WordBreak::ALetter),
  ((0,27,80),(0,27,89),WordBreak::Numeric),
  ((0,27,107),(0,27,115),WordBreak::Extend),
  ((0,27,128),(0,27,130),WordBreak::Extend),
  ((0,27,131),(0,27,160),WordBreak::ALetter),
  ((0,27,161),(0,27,173),WordBreak::Extend),
  ((0,27,174),(0,27,175),WordBreak::ALetter),
  ((0,27,176),(0,27,185),WordBreak::Numeric),
  ((0,27,186),(0,27,229),WordBreak::ALetter),
  ((0,27,230),(0,27,243),WordBreak::Extend),
  ((0,28,0),(0,28,35),WordBreak::ALetter),
  ((0,28,36),(0,28,55),WordBreak::Extend),
  ((0,28,64),(0,28,73),WordBreak::Numeric),
  ((0,28,77),(0,28,79),WordBreak::ALetter),
  ((0,28,80),(0,28,89),WordBreak::Numeric),
  ((0,28,90),(0,28,125),WordBreak::ALetter),
  ((0,28,128),(0,28,136),WordBreak::ALetter),
  ((0,28,208),(0,28,210),WordBreak::Extend),
  ((0,28,212),(0,28,232),WordBreak::Extend),
  ((0,28,233),(0,28,236),WordBreak::ALetter),
  ((0,28,237),(0,28,237),WordBreak::Extend),
  ((0,28,238),(0,28,241),WordBreak::ALetter),
  ((0,28,242),(0,28,244),WordBreak::Extend),
  ((0,28,245),(0,28,246),WordBreak::ALetter),
  ((0,28,248),(0,28,249),WordBreak::Extend),
  ((0,29,0),(0,29,191),WordBreak::ALetter),
  ((0,29,192),(0,29,245),WordBreak::Extend),
  ((0,29,251),(0,29,255),WordBreak::Extend),
  ((0,30,0),(0,31,21),WordBreak::ALetter),
  ((0,31,24),(0,31,29),WordBreak::ALetter),
  ((0,31,32),(0,31,69),WordBreak::ALetter),
  ((0,31,72),(0,31,77),WordBreak::ALetter),
  ((0,31,80),(0,31,87),WordBreak::ALetter),
  ((0,31,89),(0,31,89),WordBreak::ALetter),
  ((0,31,91),(0,31,91),WordBreak::ALetter),
  ((0,31,93),(0,31,93),WordBreak::ALetter),
  ((0,31,95),(0,31,125),WordBreak::ALetter),
  ((0,31,128),(0,31,180),WordBreak::ALetter),
  ((0,31,182),(0,31,188),WordBreak::ALetter),
  ((0,31,190),(0,31,190),WordBreak::ALetter),
  ((0,31,194),(0,31,196),WordBreak::ALetter),
  ((0,31,198),(0,31,204),WordBreak::ALetter),
  ((0,31,208),(0,31,211),WordBreak::ALetter),
  ((0,31,214),(0,31,219),WordBreak::ALetter),
  ((0,31,224),(0,31,236),WordBreak::ALetter),
  ((0,31,242),(0,31,244),WordBreak::ALetter),
  ((0,31,246),(0,31,252),WordBreak::ALetter),
  ((0,32,12),(0,32,12),WordBreak::Extend),
  ((0,32,13),(0,32,13),WordBreak::ZeroWidthJoiner),
  ((0,32,14),(0,32,15),WordBreak::Format),
  ((0,32,24),(0,32,25),WordBreak::MidNumericLetter),
  ((0,32,36),(0,32,36),WordBreak::MidNumericLetter),
  ((0,32,39),(0,32,39),WordBreak::MidLetter),
  ((0,32,40),(0,32,41),WordBreak::Newline),
  ((0,32,42),(0,32,46),WordBreak::Format),
  ((0,32,47),(0,32,47),WordBreak::ExtendNumLet),
  ((0,32,63),(0,32,64),WordBreak::ExtendNumLet),
  ((0,32,68),(0,32,68),WordBreak::MidNumeric),
  ((0,32,84),(0,32,84),WordBreak::ExtendNumLet),
  ((0,32,96),(0,32,100),WordBreak::Format),
  ((0,32,102),(0,32,111),WordBreak::Format),
  ((0,32,113),(0,32,113),WordBreak::ALetter),
  ((0,32,127),(0,32,127),WordBreak::ALetter),
  ((0,32,144),(0,32,156),WordBreak::ALetter),
  ((0,32,208),(0,32,240),WordBreak::Extend),
  ((0,33,2),(0,33,2),WordBreak::ALetter),
  ((0,33,7),(0,33,7),WordBreak::ALetter),
  ((0,33,10),(0,33,19),WordBreak::ALetter),
  ((0,33,21),(0,33,21),WordBreak::ALetter),
  ((0,33,25),(0,33,29),WordBreak::ALetter),
  ((0,33,36),(0,33,36),WordBreak::ALetter),
  ((0,33,38),(0,33,38),WordBreak::ALetter),
  ((0,33,40),(0,33,40),WordBreak::ALetter),
  ((0,33,42),(0,33,45),WordBreak::ALetter),
  ((0,33,47),(0,33,57),WordBreak::ALetter),
  ((0,33,60),(0,33,63),WordBreak::ALetter),
  ((0,33,69),(0,33,73),WordBreak::ALetter),
  ((0,33,78),(0,33,78),WordBreak::ALetter),
  ((0,33,96),(0,33,136),WordBreak::ALetter),
  ((0,36,182),(0,36,233),WordBreak::ALetter),
  ((0,38,29),(0,38,29),WordBreak::EmojiModifierBase),
  ((0,38,249),(0,38,249),WordBreak::EmojiModifierBase),
  ((0,39,10),(0,39,13),WordBreak::EmojiModifierBase),
  ((0,39,100),(0,39,100),WordBreak::GlueAfterZWJ),
  ((0,44,0),(0,44,46),WordBreak::ALetter),
  ((0,44,48),(0,44,94),WordBreak::ALetter),
  ((0,44,96),(0,44,228),WordBreak::ALetter),
  ((0,44,235),(0,44,238),WordBreak::ALetter),
  ((0,44,239),(0,44,241),WordBreak::Extend),
  ((0,44,242),(0,44,243),WordBreak::ALetter),
  ((0,45,0),(0,45,37),WordBreak::ALetter),
  ((0,45,39),(0,45,39),WordBreak::ALetter),
  ((0,45,45),(0,45,45),WordBreak::ALetter),
  ((0,45,48),(0,45,103),WordBreak::ALetter),
  ((0,45,111),(0,45,111),WordBreak::ALetter),
  ((0,45,127),(0,45,127),WordBreak::Extend),
  ((0,45,128),(0,45,150),WordBreak::ALetter),
  ((0,45,160),(0,45,166),WordBreak::ALetter),
  ((0,45,168),(0,45,174),WordBreak::ALetter),
  ((0,45,176),(0,45,182),WordBreak::ALetter),
  ((0,45,184),(0,45,190),WordBreak::ALetter),
  ((0,45,192),(0,45,198),WordBreak::ALetter),
  ((0,45,200),(0,45,206),WordBreak::ALetter),
  ((0,45,208),(0,45,214),WordBreak::ALetter),
  ((0,45,216),(0,45,222),WordBreak::ALetter),
  ((0,45,224),(0,45,255),WordBreak::Extend),
  ((0,46,47),(0,46,47),WordBreak::ALetter),
  ((0,48,5),(0,48,5),WordBreak::ALetter),
  ((0,48,42),(0,48,47),WordBreak::Extend),
  ((0,48,49),(0,48,53),WordBreak::Katakana),
  ((0,48,59),(0,48,60),WordBreak::ALetter),
  ((0,48,153),(0,48,154),WordBreak::Extend),
  ((0,48,155),(0,48,156),WordBreak::Katakana),
  ((0,48,160),(0,48,250),WordBreak::Katakana),
  ((0,48,252),(0,48,255),WordBreak::Katakana),
  ((0,49,5),(0,49,45),WordBreak::ALetter),
  ((0,49,49),(0,49,142),WordBreak::ALetter),
  ((0,49,160),(0,49,186),WordBreak::ALetter),
  ((0,49,240),(0,49,255),WordBreak::Katakana),
  ((0,50,208),(0,50,254),WordBreak::Katakana),
  ((0,51,0),(0,51,87),WordBreak::Katakana),
  ((0,160,0),(0,164,140),WordBreak::ALetter),
  ((0,164,208),(0,164,253),WordBreak::ALetter),
  ((0,165,0),(0,166,12),WordBreak::ALetter),
  ((0,166,16),(0,166,31),WordBreak::ALetter),
  ((0,166,32),(0,166,41),WordBreak::Numeric),
  ((0,166,42),(0,166,43),WordBreak::ALetter),
  ((0,166,64),(0,166,110),WordBreak::ALetter),
  ((0,166,111),(0,166,114),WordBreak::Extend),
  ((0,166,116),(0,166,125),WordBreak::Extend),
  ((0,166,127),(0,166,157),WordBreak::ALetter),
  ((0,166,158),(0,166,159),WordBreak::Extend),
  ((0,166,160),(0,166,239),WordBreak::ALetter),
  ((0,166,240),(0,166,241),WordBreak::Extend),
  ((0,167,23),(0,167,31),WordBreak::ALetter),
  ((0,167,34),(0,167,136),WordBreak::ALetter),
  ((0,167,139),(0,167,174),WordBreak::ALetter),
  ((0,167,176),(0,167,183),WordBreak::ALetter),
  ((0,167,247),(0,168,1),WordBreak::ALetter),
  ((0,168,2),(0,168,2),WordBreak::Extend),
  ((0,168,3),(0,168,5),WordBreak::ALetter),
  ((0,168,6),(0,168,6),WordBreak::Extend),
  ((0,168,7),(0,168,10),WordBreak::ALetter),
  ((0,168,11),(0,168,11),WordBreak::Extend),
  ((0,168,12),(0,168,34),WordBreak::ALetter),
  ((0,168,35),(0,168,39),WordBreak::Extend),
  ((0,168,64),(0,168,115),WordBreak::ALetter),
  ((0,168,128),(0,168,129),WordBreak::Extend),
  ((0,168,130),(0,168,179),WordBreak::ALetter),
  ((0,168,180),(0,168,197),WordBreak::Extend),
  ((0,168,208),(0,168,217),WordBreak::Numeric),
  ((0,168,224),(0,168,241),WordBreak::Extend),
  ((0,168,242),(0,168,247),WordBreak::ALetter),
  ((0,168,251),(0,168,251),WordBreak::ALetter),
  ((0,168,253),(0,168,253),WordBreak::ALetter),
  ((0,169,0),(0,169,9),WordBreak::Numeric),
  ((0,169,10),(0,169,37),WordBreak::ALetter),
  ((0,169,38),(0,169,45),WordBreak::Extend),
  ((0,169,48),(0,169,70),WordBreak::ALetter),
  ((0,169,71),(0,169,83),WordBreak::Extend),
  ((0,169,96),(0,169,124),WordBreak::ALetter),
  ((0,169,128),(0,169,131),WordBreak::Extend),
  ((0,169,132),(0,169,178),WordBreak::ALetter),
  ((0,169,179),(0,169,192),WordBreak::Extend),
  ((0,169,207),(0,169,207),WordBreak::ALetter),
  ((0,169,208),(0,169,217),WordBreak::Numeric),
  ((0,169,229),(0,169,229),WordBreak::Extend),
  ((0,169,240),(0,169,249),WordBreak::Numeric),
  ((0,170,0),(0,170,40),WordBreak::ALetter),
  ((0,170,41),(0,170,54),WordBreak::Extend),
  ((0,170,64),(0,170,66),WordBreak::ALetter),
  ((0,170,67),(0,170,67),WordBreak::Extend),
  ((0,170,68),(0,170,75),WordBreak::ALetter),
  ((0,170,76),(0,170,77),WordBreak::Extend),
  ((0,170,80),(0,170,89),WordBreak::Numeric),
  ((0,170,123),(0,170,125),WordBreak::Extend),
  ((0,170,176),(0,170,176),WordBreak::Extend),
  ((0,170,178),(0,170,180),WordBreak::Extend),
  ((0,170,183),(0,170,184),WordBreak::Extend),
  ((0,170,190),(0,170,191),WordBreak::Extend),
  ((0,170,193),(0,170,193),WordBreak::Extend),
  ((0,170,224),(0,170,234),WordBreak::ALetter),
  ((0,170,235),(0,170,239),WordBreak::Extend),
  ((0,170,242),(0,170,244),WordBreak::ALetter),
  ((0,170,245),(0,170,246),WordBreak::Extend),
  ((0,171,1),(0,171,6),WordBreak::ALetter),
  ((0,171,9),(0,171,14),WordBreak::ALetter),
  ((0,171,17),(0,171,22),WordBreak::ALetter),
  ((0,171,32),(0,171,38),WordBreak::ALetter),
  ((0,171,40),(0,171,46),WordBreak::ALetter),
  ((0,171,48),(0,171,90),WordBreak::ALetter),
  ((0,171,92),(0,171,101),WordBreak::ALetter),
  ((0,171,112),(0,171,226),WordBreak::ALetter),
  ((0,171,227),(0,171,234),WordBreak::Extend),
  ((0,171,236),(0,171,237),WordBreak::Extend),
  ((0,171,240),(0,171,249),WordBreak::Numeric),
  ((0,172,0),(0,215,163),WordBreak::ALetter),
  ((0,215,176),(0,215,198),WordBreak::ALetter),
  ((0,215,203),(0,215,251),WordBreak::ALetter),
  ((0,251,0),(0,251,6),WordBreak::ALetter),
  ((0,251,19),(0,251,23),WordBreak::ALetter),
  ((0,251,29),(0,251,29),WordBreak::HebrewLetter),
  ((0,251,30),(0,251,30),WordBreak::Extend),
  ((0,251,31),(0,251,40),WordBreak::HebrewLetter),
  ((0,251,42),(0,251,54),WordBreak::HebrewLetter),
  ((0,251,56),(0,251,60),WordBreak::HebrewLetter),
  ((0,251,62),(0,251,62),WordBreak::HebrewLetter),
  ((0,251,64),(0,251,65),WordBreak::HebrewLetter),
  ((0,251,67),(0,251,68),WordBreak::HebrewLetter),
  ((0,251,70),(0,251,79),WordBreak::HebrewLetter),
  ((0,251,80),(0,251,177),WordBreak::ALetter),
  ((0,251,211),(0,253,61),WordBreak::ALetter),
  ((0,253,80),(0,253,143),WordBreak::ALetter),
  ((0,253,146),(0,253,199),WordBreak::ALetter),
  ((0,253,240),(0,253,251),WordBreak::ALetter),
  ((0,254,0),(0,254,15),WordBreak::Extend),
  ((0,254,16),(0,254,16),WordBreak::MidNumeric),
  ((0,254,19),(0,254,19),WordBreak::MidLetter),
  ((0,254,20),(0,254,20),WordBreak::MidNumeric),
  ((0,254,32),(0,254,47),WordBreak::Extend),
  ((0,254,51),(0,254,52),WordBreak::ExtendNumLet),
  ((0,254,77),(0,254,79),WordBreak::ExtendNumLet),
  ((0,254,80),(0,254,80),WordBreak::MidNumeric),
  ((0,254,82),(0,254,82),WordBreak::MidNumericLetter),
  ((0,254,84),(0,254,84),WordBreak::MidNumeric),
  ((0,254,85),(0,254,85),WordBreak::MidLetter),
  ((0,254,112),(0,254,116),WordBreak::ALetter),
  ((0,254,118),(0,254,252),WordBreak::ALetter),
  ((0,254,255),(0,254,255),WordBreak::Format),
  ((0,255,7),(0,255,7),WordBreak::MidNumericLetter),
  ((0,255,12),(0,255,12),WordBreak::MidNumeric),
  ((0,255,14),(0,255,14),WordBreak::MidNumericLetter),
  ((0,255,26),(0,255,26),WordBreak::MidLetter),
  ((0,255,27),(0,255,27),WordBreak::MidNumeric),
  ((0,255,33),(0,255,58),WordBreak::ALetter),
  ((0,255,63),(0,255,63),WordBreak::ExtendNumLet),
  ((0,255,65),(0,255,90),WordBreak::ALetter),
  ((0,255,102),(0,255,157),WordBreak::Katakana),
  ((0,255,158),(0,255,159),WordBreak::Extend),
  ((0,255,160),(0,255,190),WordBreak::ALetter),
  ((0,255,194),(0,255,199),WordBreak::ALetter),
  ((0,255,202),(0,255,207),WordBreak::ALetter),
  ((0,255,210),(0,255,215),WordBreak::ALetter),
  ((0,255,218),(0,255,220),WordBreak::ALetter),
  ((0,255,249),(0,255,251),WordBreak::Format),
  ((1,0,0),(1,0,11),WordBreak::ALetter), ((1,0,13),(1,0,38),WordBreak::ALetter),
  ((1,0,40),(1,0,58),WordBreak::ALetter),
  ((1,0,60),(1,0,61),WordBreak::ALetter),
  ((1,0,63),(1,0,77),WordBreak::ALetter),
  ((1,0,80),(1,0,93),WordBreak::ALetter),
  ((1,0,128),(1,0,250),WordBreak::ALetter),
  ((1,1,64),(1,1,116),WordBreak::ALetter),
  ((1,1,253),(1,1,253),WordBreak::Extend),
  ((1,2,128),(1,2,156),WordBreak::ALetter),
  ((1,2,160),(1,2,208),WordBreak::ALetter),
  ((1,2,224),(1,2,224),WordBreak::Extend),
  ((1,3,0),(1,3,31),WordBreak::ALetter), ((1,3,48),(1,3,74),WordBreak::ALetter),
  ((1,3,80),(1,3,117),WordBreak::ALetter),
  ((1,3,118),(1,3,122),WordBreak::Extend),
  ((1,3,128),(1,3,157),WordBreak::ALetter),
  ((1,3,160),(1,3,195),WordBreak::ALetter),
  ((1,3,200),(1,3,207),WordBreak::ALetter),
  ((1,3,209),(1,3,213),WordBreak::ALetter),
  ((1,4,0),(1,4,157),WordBreak::ALetter),
  ((1,4,160),(1,4,169),WordBreak::Numeric),
  ((1,4,176),(1,4,211),WordBreak::ALetter),
  ((1,4,216),(1,4,251),WordBreak::ALetter),
  ((1,5,0),(1,5,39),WordBreak::ALetter), ((1,5,48),(1,5,99),WordBreak::ALetter),
  ((1,6,0),(1,7,54),WordBreak::ALetter), ((1,7,64),(1,7,85),WordBreak::ALetter),
  ((1,7,96),(1,7,103),WordBreak::ALetter), ((1,8,0),(1,8,5),WordBreak::ALetter),
  ((1,8,8),(1,8,8),WordBreak::ALetter), ((1,8,10),(1,8,53),WordBreak::ALetter),
  ((1,8,55),(1,8,56),WordBreak::ALetter),
  ((1,8,60),(1,8,60),WordBreak::ALetter),
  ((1,8,63),(1,8,85),WordBreak::ALetter),
  ((1,8,96),(1,8,118),WordBreak::ALetter),
  ((1,8,128),(1,8,158),WordBreak::ALetter),
  ((1,8,224),(1,8,242),WordBreak::ALetter),
  ((1,8,244),(1,8,245),WordBreak::ALetter),
  ((1,9,0),(1,9,21),WordBreak::ALetter), ((1,9,32),(1,9,57),WordBreak::ALetter),
  ((1,9,128),(1,9,183),WordBreak::ALetter),
  ((1,9,190),(1,9,191),WordBreak::ALetter),
  ((1,10,0),(1,10,0),WordBreak::ALetter), ((1,10,1),(1,10,3),WordBreak::Extend),
  ((1,10,5),(1,10,6),WordBreak::Extend),
  ((1,10,12),(1,10,15),WordBreak::Extend),
  ((1,10,16),(1,10,19),WordBreak::ALetter),
  ((1,10,21),(1,10,23),WordBreak::ALetter),
  ((1,10,25),(1,10,51),WordBreak::ALetter),
  ((1,10,56),(1,10,58),WordBreak::Extend),
  ((1,10,63),(1,10,63),WordBreak::Extend),
  ((1,10,96),(1,10,124),WordBreak::ALetter),
  ((1,10,128),(1,10,156),WordBreak::ALetter),
  ((1,10,192),(1,10,199),WordBreak::ALetter),
  ((1,10,201),(1,10,228),WordBreak::ALetter),
  ((1,10,229),(1,10,230),WordBreak::Extend),
  ((1,11,0),(1,11,53),WordBreak::ALetter),
  ((1,11,64),(1,11,85),WordBreak::ALetter),
  ((1,11,96),(1,11,114),WordBreak::ALetter),
  ((1,11,128),(1,11,145),WordBreak::ALetter),
  ((1,12,0),(1,12,72),WordBreak::ALetter),
  ((1,12,128),(1,12,178),WordBreak::ALetter),
  ((1,12,192),(1,12,242),WordBreak::ALetter),
  ((1,16,0),(1,16,2),WordBreak::Extend),
  ((1,16,3),(1,16,55),WordBreak::ALetter),
  ((1,16,56),(1,16,70),WordBreak::Extend),
  ((1,16,102),(1,16,111),WordBreak::Numeric),
  ((1,16,127),(1,16,130),WordBreak::Extend),
  ((1,16,131),(1,16,175),WordBreak::ALetter),
  ((1,16,176),(1,16,186),WordBreak::Extend),
  ((1,16,189),(1,16,189),WordBreak::Format),
  ((1,16,208),(1,16,232),WordBreak::ALetter),
  ((1,16,240),(1,16,249),WordBreak::Numeric),
  ((1,17,0),(1,17,2),WordBreak::Extend),
  ((1,17,3),(1,17,38),WordBreak::ALetter),
  ((1,17,39),(1,17,52),WordBreak::Extend),
  ((1,17,54),(1,17,63),WordBreak::Numeric),
  ((1,17,80),(1,17,114),WordBreak::ALetter),
  ((1,17,115),(1,17,115),WordBreak::Extend),
  ((1,17,118),(1,17,118),WordBreak::ALetter),
  ((1,17,128),(1,17,130),WordBreak::Extend),
  ((1,17,131),(1,17,178),WordBreak::ALetter),
  ((1,17,179),(1,17,192),WordBreak::Extend),
  ((1,17,193),(1,17,196),WordBreak::ALetter),
  ((1,17,202),(1,17,204),WordBreak::Extend),
  ((1,17,208),(1,17,217),WordBreak::Numeric),
  ((1,17,218),(1,17,218),WordBreak::ALetter),
  ((1,17,220),(1,17,220),WordBreak::ALetter),
  ((1,18,0),(1,18,17),WordBreak::ALetter),
  ((1,18,19),(1,18,43),WordBreak::ALetter),
  ((1,18,44),(1,18,55),WordBreak::Extend),
  ((1,18,62),(1,18,62),WordBreak::Extend),
  ((1,18,128),(1,18,134),WordBreak::ALetter),
  ((1,18,136),(1,18,136),WordBreak::ALetter),
  ((1,18,138),(1,18,141),WordBreak::ALetter),
  ((1,18,143),(1,18,157),WordBreak::ALetter),
  ((1,18,159),(1,18,168),WordBreak::ALetter),
  ((1,18,176),(1,18,222),WordBreak::ALetter),
  ((1,18,223),(1,18,234),WordBreak::Extend),
  ((1,18,240),(1,18,249),WordBreak::Numeric),
  ((1,19,0),(1,19,3),WordBreak::Extend),
  ((1,19,5),(1,19,12),WordBreak::ALetter),
  ((1,19,15),(1,19,16),WordBreak::ALetter),
  ((1,19,19),(1,19,40),WordBreak::ALetter),
  ((1,19,42),(1,19,48),WordBreak::ALetter),
  ((1,19,50),(1,19,51),WordBreak::ALetter),
  ((1,19,53),(1,19,57),WordBreak::ALetter),
  ((1,19,60),(1,19,60),WordBreak::Extend),
  ((1,19,61),(1,19,61),WordBreak::ALetter),
  ((1,19,62),(1,19,68),WordBreak::Extend),
  ((1,19,71),(1,19,72),WordBreak::Extend),
  ((1,19,75),(1,19,77),WordBreak::Extend),
  ((1,19,80),(1,19,80),WordBreak::ALetter),
  ((1,19,87),(1,19,87),WordBreak::Extend),
  ((1,19,93),(1,19,97),WordBreak::ALetter),
  ((1,19,98),(1,19,99),WordBreak::Extend),
  ((1,19,102),(1,19,108),WordBreak::Extend),
  ((1,19,112),(1,19,116),WordBreak::Extend),
  ((1,20,0),(1,20,52),WordBreak::ALetter),
  ((1,20,53),(1,20,70),WordBreak::Extend),
  ((1,20,71),(1,20,74),WordBreak::ALetter),
  ((1,20,80),(1,20,89),WordBreak::Numeric),
  ((1,20,128),(1,20,175),WordBreak::ALetter),
  ((1,20,176),(1,20,195),WordBreak::Extend),
  ((1,20,196),(1,20,197),WordBreak::ALetter),
  ((1,20,199),(1,20,199),WordBreak::ALetter),
  ((1,20,208),(1,20,217),WordBreak::Numeric),
  ((1,21,128),(1,21,174),WordBreak::ALetter),
  ((1,21,175),(1,21,181),WordBreak::Extend),
  ((1,21,184),(1,21,192),WordBreak::Extend),
  ((1,21,216),(1,21,219),WordBreak::ALetter),
  ((1,21,220),(1,21,221),WordBreak::Extend),
  ((1,22,0),(1,22,47),WordBreak::ALetter),
  ((1,22,48),(1,22,64),WordBreak::Extend),
  ((1,22,68),(1,22,68),WordBreak::ALetter),
  ((1,22,80),(1,22,89),WordBreak::Numeric),
  ((1,22,128),(1,22,170),WordBreak::ALetter),
  ((1,22,171),(1,22,183),WordBreak::Extend),
  ((1,22,192),(1,22,201),WordBreak::Numeric),
  ((1,23,29),(1,23,43),WordBreak::Extend),
  ((1,23,48),(1,23,57),WordBreak::Numeric),
  ((1,24,160),(1,24,223),WordBreak::ALetter),
  ((1,24,224),(1,24,233),WordBreak::Numeric),
  ((1,24,255),(1,24,255),WordBreak::ALetter),
  ((1,26,192),(1,26,248),WordBreak::ALetter),
  ((1,28,0),(1,28,8),WordBreak::ALetter),
  ((1,28,10),(1,28,46),WordBreak::ALetter),
  ((1,28,47),(1,28,54),WordBreak::Extend),
  ((1,28,56),(1,28,63),WordBreak::Extend),
  ((1,28,64),(1,28,64),WordBreak::ALetter),
  ((1,28,80),(1,28,89),WordBreak::Numeric),
  ((1,28,114),(1,28,143),WordBreak::ALetter),
  ((1,28,146),(1,28,167),WordBreak::Extend),
  ((1,28,169),(1,28,182),WordBreak::Extend),
  ((1,32,0),(1,35,153),WordBreak::ALetter),
  ((1,36,0),(1,36,110),WordBreak::ALetter),
  ((1,36,128),(1,37,67),WordBreak::ALetter),
  ((1,48,0),(1,52,46),WordBreak::ALetter),
  ((1,68,0),(1,70,70),WordBreak::ALetter),
  ((1,104,0),(1,106,56),WordBreak::ALetter),
  ((1,106,64),(1,106,94),WordBreak::ALetter),
  ((1,106,96),(1,106,105),WordBreak::Numeric),
  ((1,106,208),(1,106,237),WordBreak::ALetter),
  ((1,106,240),(1,106,244),WordBreak::Extend),
  ((1,107,0),(1,107,47),WordBreak::ALetter),
  ((1,107,48),(1,107,54),WordBreak::Extend),
  ((1,107,64),(1,107,67),WordBreak::ALetter),
  ((1,107,80),(1,107,89),WordBreak::Numeric),
  ((1,107,99),(1,107,119),WordBreak::ALetter),
  ((1,107,125),(1,107,143),WordBreak::ALetter),
  ((1,111,0),(1,111,68),WordBreak::ALetter),
  ((1,111,80),(1,111,80),WordBreak::ALetter),
  ((1,111,81),(1,111,126),WordBreak::Extend),
  ((1,111,143),(1,111,146),WordBreak::Extend),
  ((1,111,147),(1,111,159),WordBreak::ALetter),
  ((1,111,224),(1,111,224),WordBreak::ALetter),
  ((1,176,0),(1,176,0),WordBreak::Katakana),
  ((1,188,0),(1,188,106),WordBreak::ALetter),
  ((1,188,112),(1,188,124),WordBreak::ALetter),
  ((1,188,128),(1,188,136),WordBreak::ALetter),
  ((1,188,144),(1,188,153),WordBreak::ALetter),
  ((1,188,157),(1,188,158),WordBreak::Extend),
  ((1,188,160),(1,188,163),WordBreak::Format),
  ((1,209,101),(1,209,105),WordBreak::Extend),
  ((1,209,109),(1,209,114),WordBreak::Extend),
  ((1,209,115),(1,209,122),WordBreak::Format),
  ((1,209,123),(1,209,130),WordBreak::Extend),
  ((1,209,133),(1,209,139),WordBreak::Extend),
  ((1,209,170),(1,209,173),WordBreak::Extend),
  ((1,210,66),(1,210,68),WordBreak::Extend),
  ((1,212,0),(1,212,84),WordBreak::ALetter),
  ((1,212,86),(1,212,156),WordBreak::ALetter),
  ((1,212,158),(1,212,159),WordBreak::ALetter),
  ((1,212,162),(1,212,162),WordBreak::ALetter),
  ((1,212,165),(1,212,166),WordBreak::ALetter),
  ((1,212,169),(1,212,172),WordBreak::ALetter),
  ((1,212,174),(1,212,185),WordBreak::ALetter),
  ((1,212,187),(1,212,187),WordBreak::ALetter),
  ((1,212,189),(1,212,195),WordBreak::ALetter),
  ((1,212,197),(1,213,5),WordBreak::ALetter),
  ((1,213,7),(1,213,10),WordBreak::ALetter),
  ((1,213,13),(1,213,20),WordBreak::ALetter),
  ((1,213,22),(1,213,28),WordBreak::ALetter),
  ((1,213,30),(1,213,57),WordBreak::ALetter),
  ((1,213,59),(1,213,62),WordBreak::ALetter),
  ((1,213,64),(1,213,68),WordBreak::ALetter),
  ((1,213,70),(1,213,70),WordBreak::ALetter),
  ((1,213,74),(1,213,80),WordBreak::ALetter),
  ((1,213,82),(1,214,165),WordBreak::ALetter),
  ((1,214,168),(1,214,192),WordBreak::ALetter),
  ((1,214,194),(1,214,218),WordBreak::ALetter),
  ((1,214,220),(1,214,250),WordBreak::ALetter),
  ((1,214,252),(1,215,20),WordBreak::ALetter),
  ((1,215,22),(1,215,52),WordBreak::ALetter),
  ((1,215,54),(1,215,78),WordBreak::ALetter),
  ((1,215,80),(1,215,110),WordBreak::ALetter),
  ((1,215,112),(1,215,136),WordBreak::ALetter),
  ((1,215,138),(1,215,168),WordBreak::ALetter),
  ((1,215,170),(1,215,194),WordBreak::ALetter),
  ((1,215,196),(1,215,203),WordBreak::ALetter),
  ((1,215,206),(1,215,255),WordBreak::Numeric),
  ((1,218,0),(1,218,54),WordBreak::Extend),
  ((1,218,59),(1,218,108),WordBreak::Extend),
  ((1,218,117),(1,218,117),WordBreak::Extend),
  ((1,218,132),(1,218,132),WordBreak::Extend),
  ((1,218,155),(1,218,159),WordBreak::Extend),
  ((1,218,161),(1,218,175),WordBreak::Extend),
  ((1,224,0),(1,224,6),WordBreak::Extend),
  ((1,224,8),(1,224,24),WordBreak::Extend),
  ((1,224,27),(1,224,33),WordBreak::Extend),
  ((1,224,35),(1,224,36),WordBreak::Extend),
  ((1,224,38),(1,224,42),WordBreak::Extend),
  ((1,232,0),(1,232,196),WordBreak::ALetter),
  ((1,232,208),(1,232,214),WordBreak::Extend),
  ((1,233,0),(1,233,67),WordBreak::ALetter),
  ((1,233,68),(1,233,74),WordBreak::Extend),
  ((1,233,80),(1,233,89),WordBreak::Numeric),
  ((1,238,0),(1,238,3),WordBreak::ALetter),
  ((1,238,5),(1,238,31),WordBreak::ALetter),
  ((1,238,33),(1,238,34),WordBreak::ALetter),
  ((1,238,36),(1,238,36),WordBreak::ALetter),
  ((1,238,39),(1,238,39),WordBreak::ALetter),
  ((1,238,41),(1,238,50),WordBreak::ALetter),
  ((1,238,52),(1,238,55),WordBreak::ALetter),
  ((1,238,57),(1,238,57),WordBreak::ALetter),
  ((1,238,59),(1,238,59),WordBreak::ALetter),
  ((1,238,66),(1,238,66),WordBreak::ALetter),
  ((1,238,71),(1,238,71),WordBreak::ALetter),
  ((1,238,73),(1,238,73),WordBreak::ALetter),
  ((1,238,75),(1,238,75),WordBreak::ALetter),
  ((1,238,77),(1,238,79),WordBreak::ALetter),
  ((1,238,81),(1,238,82),WordBreak::ALetter),
  ((1,238,84),(1,238,84),WordBreak::ALetter),
  ((1,238,87),(1,238,87),WordBreak::ALetter),
  ((1,238,89),(1,238,89),WordBreak::ALetter),
  ((1,238,91),(1,238,91),WordBreak::ALetter),
  ((1,238,93),(1,238,93),WordBreak::ALetter),
  ((1,238,95),(1,238,95),WordBreak::ALetter),
  ((1,238,97),(1,238,98),WordBreak::ALetter),
  ((1,238,100),(1,238,100),WordBreak::ALetter),
  ((1,238,103),(1,238,106),WordBreak::ALetter),
  ((1,238,108),(1,238,114),WordBreak::ALetter),
  ((1,238,116),(1,238,119),WordBreak::ALetter),
  ((1,238,121),(1,238,124),WordBreak::ALetter),
  ((1,238,126),(1,238,126),WordBreak::ALetter),
  ((1,238,128),(1,238,137),WordBreak::ALetter),
  ((1,238,139),(1,238,155),WordBreak::ALetter),
  ((1,238,161),(1,238,163),WordBreak::ALetter),
  ((1,238,165),(1,238,169),WordBreak::ALetter),
  ((1,238,171),(1,238,187),WordBreak::ALetter),
  ((1,241,48),(1,241,73),WordBreak::ALetter),
  ((1,241,80),(1,241,105),WordBreak::ALetter),
  ((1,241,112),(1,241,137),WordBreak::ALetter),
  ((1,241,230),(1,241,255),WordBreak::RegionalIndicator),
  ((1,243,133),(1,243,133),WordBreak::EmojiModifierBase),
  ((1,243,195),(1,243,196),WordBreak::EmojiModifierBase),
  ((1,243,202),(1,243,203),WordBreak::EmojiModifierBase),
  ((1,243,251),(1,243,255),WordBreak::EmojiModifier),
  ((1,244,66),(1,244,67),WordBreak::EmojiModifierBase),
  ((1,244,70),(1,244,80),WordBreak::EmojiModifierBase),
  ((1,244,102),(1,244,105),WordBreak::EmojiModifierBaseAfterZWJ),
  ((1,244,110),(1,244,110),WordBreak::EmojiModifierBase),
  ((1,244,112),(1,244,120),WordBreak::EmojiModifierBase),
  ((1,244,124),(1,244,124),WordBreak::EmojiModifierBase),
  ((1,244,129),(1,244,131),WordBreak::EmojiModifierBase),
  ((1,244,133),(1,244,135),WordBreak::EmojiModifierBase),
  ((1,244,139),(1,244,139),WordBreak::GlueAfterZWJ),
  ((1,244,170),(1,244,170),WordBreak::EmojiModifierBase),
  ((1,245,117),(1,245,117),WordBreak::EmojiModifierBase),
  ((1,245,122),(1,245,122),WordBreak::EmojiModifierBase),
  ((1,245,144),(1,245,144),WordBreak::EmojiModifierBase),
  ((1,245,149),(1,245,150),WordBreak::EmojiModifierBase),
  ((1,245,232),(1,245,232),WordBreak::GlueAfterZWJ),
  ((1,246,69),(1,246,71),WordBreak::EmojiModifierBase),
  ((1,246,75),(1,246,79),WordBreak::EmojiModifierBase),
  ((1,246,163),(1,246,163),WordBreak::EmojiModifierBase),
  ((1,246,180),(1,246,182),WordBreak::EmojiModifierBase),
  ((1,246,192),(1,246,192),WordBreak::EmojiModifierBase),
  ((1,249,24),(1,249,30),WordBreak::EmojiModifierBase),
  ((1,249,38),(1,249,38),WordBreak::EmojiModifierBase),
  ((1,249,48),(1,249,48),WordBreak::EmojiModifierBase),
  ((1,249,51),(1,249,57),WordBreak::EmojiModifierBase),
  ((1,249,60),(1,249,62),WordBreak::EmojiModifierBase),
  ((14,0,1),(14,0,1),WordBreak::Format),
  ((14,0,32),(14,0,127),WordBreak::Extend),
  ((14,1,0),(14,1,239),WordBreak::Extend)
];

#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum SentenceBreak {
  ATerm, Close, CarriageReturn, Extend, Format, OLetter, LineFeed, Lowercase,
  Numeric, SentenceContinue, Separator, Space, SentenceTerminal, Uppercase,
  Other
}

pub static UCD_SBRK: &'static [((u8,u8,u8), (u8,u8,u8), SentenceBreak)] = &[
  ((0,0,9),(0,0,9),SentenceBreak::Space),
  ((0,0,10),(0,0,10),SentenceBreak::LineFeed),
  ((0,0,11),(0,0,12),SentenceBreak::Space),
  ((0,0,13),(0,0,13),SentenceBreak::CarriageReturn),
  ((0,0,32),(0,0,32),SentenceBreak::Space),
  ((0,0,33),(0,0,33),SentenceBreak::SentenceTerminal),
  ((0,0,34),(0,0,34),SentenceBreak::Close),
  ((0,0,39),(0,0,41),SentenceBreak::Close),
  ((0,0,44),(0,0,45),SentenceBreak::SentenceContinue),
  ((0,0,46),(0,0,46),SentenceBreak::ATerm),
  ((0,0,48),(0,0,57),SentenceBreak::Numeric),
  ((0,0,58),(0,0,58),SentenceBreak::SentenceContinue),
  ((0,0,63),(0,0,63),SentenceBreak::SentenceTerminal),
  ((0,0,65),(0,0,90),SentenceBreak::Uppercase),
  ((0,0,91),(0,0,91),SentenceBreak::Close),
  ((0,0,93),(0,0,93),SentenceBreak::Close),
  ((0,0,97),(0,0,122),SentenceBreak::Lowercase),
  ((0,0,123),(0,0,123),SentenceBreak::Close),
  ((0,0,125),(0,0,125),SentenceBreak::Close),
  ((0,0,133),(0,0,133),SentenceBreak::Separator),
  ((0,0,160),(0,0,160),SentenceBreak::Space),
  ((0,0,170),(0,0,170),SentenceBreak::Lowercase),
  ((0,0,171),(0,0,171),SentenceBreak::Close),
  ((0,0,173),(0,0,173),SentenceBreak::Format),
  ((0,0,181),(0,0,181),SentenceBreak::Lowercase),
  ((0,0,186),(0,0,186),SentenceBreak::Lowercase),
  ((0,0,187),(0,0,187),SentenceBreak::Close),
  ((0,0,192),(0,0,214),SentenceBreak::Uppercase),
  ((0,0,216),(0,0,222),SentenceBreak::Uppercase),
  ((0,0,223),(0,0,246),SentenceBreak::Lowercase),
  ((0,0,248),(0,0,255),SentenceBreak::Lowercase),
  ((0,1,0),(0,1,0),SentenceBreak::Uppercase),
  ((0,1,1),(0,1,1),SentenceBreak::Lowercase),
  ((0,1,2),(0,1,2),SentenceBreak::Uppercase),
  ((0,1,3),(0,1,3),SentenceBreak::Lowercase),
  ((0,1,4),(0,1,4),SentenceBreak::Uppercase),
  ((0,1,5),(0,1,5),SentenceBreak::Lowercase),
  ((0,1,6),(0,1,6),SentenceBreak::Uppercase),
  ((0,1,7),(0,1,7),SentenceBreak::Lowercase),
  ((0,1,8),(0,1,8),SentenceBreak::Uppercase),
  ((0,1,9),(0,1,9),SentenceBreak::Lowercase),
  ((0,1,10),(0,1,10),SentenceBreak::Uppercase),
  ((0,1,11),(0,1,11),SentenceBreak::Lowercase),
  ((0,1,12),(0,1,12),SentenceBreak::Uppercase),
  ((0,1,13),(0,1,13),SentenceBreak::Lowercase),
  ((0,1,14),(0,1,14),SentenceBreak::Uppercase),
  ((0,1,15),(0,1,15),SentenceBreak::Lowercase),
  ((0,1,16),(0,1,16),SentenceBreak::Uppercase),
  ((0,1,17),(0,1,17),SentenceBreak::Lowercase),
  ((0,1,18),(0,1,18),SentenceBreak::Uppercase),
  ((0,1,19),(0,1,19),SentenceBreak::Lowercase),
  ((0,1,20),(0,1,20),SentenceBreak::Uppercase),
  ((0,1,21),(0,1,21),SentenceBreak::Lowercase),
  ((0,1,22),(0,1,22),SentenceBreak::Uppercase),
  ((0,1,23),(0,1,23),SentenceBreak::Lowercase),
  ((0,1,24),(0,1,24),SentenceBreak::Uppercase),
  ((0,1,25),(0,1,25),SentenceBreak::Lowercase),
  ((0,1,26),(0,1,26),SentenceBreak::Uppercase),
  ((0,1,27),(0,1,27),SentenceBreak::Lowercase),
  ((0,1,28),(0,1,28),SentenceBreak::Uppercase),
  ((0,1,29),(0,1,29),SentenceBreak::Lowercase),
  ((0,1,30),(0,1,30),SentenceBreak::Uppercase),
  ((0,1,31),(0,1,31),SentenceBreak::Lowercase),
  ((0,1,32),(0,1,32),SentenceBreak::Uppercase),
  ((0,1,33),(0,1,33),SentenceBreak::Lowercase),
  ((0,1,34),(0,1,34),SentenceBreak::Uppercase),
  ((0,1,35),(0,1,35),SentenceBreak::Lowercase),
  ((0,1,36),(0,1,36),SentenceBreak::Uppercase),
  ((0,1,37),(0,1,37),SentenceBreak::Lowercase),
  ((0,1,38),(0,1,38),SentenceBreak::Uppercase),
  ((0,1,39),(0,1,39),SentenceBreak::Lowercase),
  ((0,1,40),(0,1,40),SentenceBreak::Uppercase),
  ((0,1,41),(0,1,41),SentenceBreak::Lowercase),
  ((0,1,42),(0,1,42),SentenceBreak::Uppercase),
  ((0,1,43),(0,1,43),SentenceBreak::Lowercase),
  ((0,1,44),(0,1,44),SentenceBreak::Uppercase),
  ((0,1,45),(0,1,45),SentenceBreak::Lowercase),
  ((0,1,46),(0,1,46),SentenceBreak::Uppercase),
  ((0,1,47),(0,1,47),SentenceBreak::Lowercase),
  ((0,1,48),(0,1,48),SentenceBreak::Uppercase),
  ((0,1,49),(0,1,49),SentenceBreak::Lowercase),
  ((0,1,50),(0,1,50),SentenceBreak::Uppercase),
  ((0,1,51),(0,1,51),SentenceBreak::Lowercase),
  ((0,1,52),(0,1,52),SentenceBreak::Uppercase),
  ((0,1,53),(0,1,53),SentenceBreak::Lowercase),
  ((0,1,54),(0,1,54),SentenceBreak::Uppercase),
  ((0,1,55),(0,1,56),SentenceBreak::Lowercase),
  ((0,1,57),(0,1,57),SentenceBreak::Uppercase),
  ((0,1,58),(0,1,58),SentenceBreak::Lowercase),
  ((0,1,59),(0,1,59),SentenceBreak::Uppercase),
  ((0,1,60),(0,1,60),SentenceBreak::Lowercase),
  ((0,1,61),(0,1,61),SentenceBreak::Uppercase),
  ((0,1,62),(0,1,62),SentenceBreak::Lowercase),
  ((0,1,63),(0,1,63),SentenceBreak::Uppercase),
  ((0,1,64),(0,1,64),SentenceBreak::Lowercase),
  ((0,1,65),(0,1,65),SentenceBreak::Uppercase),
  ((0,1,66),(0,1,66),SentenceBreak::Lowercase),
  ((0,1,67),(0,1,67),SentenceBreak::Uppercase),
  ((0,1,68),(0,1,68),SentenceBreak::Lowercase),
  ((0,1,69),(0,1,69),SentenceBreak::Uppercase),
  ((0,1,70),(0,1,70),SentenceBreak::Lowercase),
  ((0,1,71),(0,1,71),SentenceBreak::Uppercase),
  ((0,1,72),(0,1,73),SentenceBreak::Lowercase),
  ((0,1,74),(0,1,74),SentenceBreak::Uppercase),
  ((0,1,75),(0,1,75),SentenceBreak::Lowercase),
  ((0,1,76),(0,1,76),SentenceBreak::Uppercase),
  ((0,1,77),(0,1,77),SentenceBreak::Lowercase),
  ((0,1,78),(0,1,78),SentenceBreak::Uppercase),
  ((0,1,79),(0,1,79),SentenceBreak::Lowercase),
  ((0,1,80),(0,1,80),SentenceBreak::Uppercase),
  ((0,1,81),(0,1,81),SentenceBreak::Lowercase),
  ((0,1,82),(0,1,82),SentenceBreak::Uppercase),
  ((0,1,83),(0,1,83),SentenceBreak::Lowercase),
  ((0,1,84),(0,1,84),SentenceBreak::Uppercase),
  ((0,1,85),(0,1,85),SentenceBreak::Lowercase),
  ((0,1,86),(0,1,86),SentenceBreak::Uppercase),
  ((0,1,87),(0,1,87),SentenceBreak::Lowercase),
  ((0,1,88),(0,1,88),SentenceBreak::Uppercase),
  ((0,1,89),(0,1,89),SentenceBreak::Lowercase),
  ((0,1,90),(0,1,90),SentenceBreak::Uppercase),
  ((0,1,91),(0,1,91),SentenceBreak::Lowercase),
  ((0,1,92),(0,1,92),SentenceBreak::Uppercase),
  ((0,1,93),(0,1,93),SentenceBreak::Lowercase),
  ((0,1,94),(0,1,94),SentenceBreak::Uppercase),
  ((0,1,95),(0,1,95),SentenceBreak::Lowercase),
  ((0,1,96),(0,1,96),SentenceBreak::Uppercase),
  ((0,1,97),(0,1,97),SentenceBreak::Lowercase),
  ((0,1,98),(0,1,98),SentenceBreak::Uppercase),
  ((0,1,99),(0,1,99),SentenceBreak::Lowercase),
  ((0,1,100),(0,1,100),SentenceBreak::Uppercase),
  ((0,1,101),(0,1,101),SentenceBreak::Lowercase),
  ((0,1,102),(0,1,102),SentenceBreak::Uppercase),
  ((0,1,103),(0,1,103),SentenceBreak::Lowercase),
  ((0,1,104),(0,1,104),SentenceBreak::Uppercase),
  ((0,1,105),(0,1,105),SentenceBreak::Lowercase),
  ((0,1,106),(0,1,106),SentenceBreak::Uppercase),
  ((0,1,107),(0,1,107),SentenceBreak::Lowercase),
  ((0,1,108),(0,1,108),SentenceBreak::Uppercase),
  ((0,1,109),(0,1,109),SentenceBreak::Lowercase),
  ((0,1,110),(0,1,110),SentenceBreak::Uppercase),
  ((0,1,111),(0,1,111),SentenceBreak::Lowercase),
  ((0,1,112),(0,1,112),SentenceBreak::Uppercase),
  ((0,1,113),(0,1,113),SentenceBreak::Lowercase),
  ((0,1,114),(0,1,114),SentenceBreak::Uppercase),
  ((0,1,115),(0,1,115),SentenceBreak::Lowercase),
  ((0,1,116),(0,1,116),SentenceBreak::Uppercase),
  ((0,1,117),(0,1,117),SentenceBreak::Lowercase),
  ((0,1,118),(0,1,118),SentenceBreak::Uppercase),
  ((0,1,119),(0,1,119),SentenceBreak::Lowercase),
  ((0,1,120),(0,1,121),SentenceBreak::Uppercase),
  ((0,1,122),(0,1,122),SentenceBreak::Lowercase),
  ((0,1,123),(0,1,123),SentenceBreak::Uppercase),
  ((0,1,124),(0,1,124),SentenceBreak::Lowercase),
  ((0,1,125),(0,1,125),SentenceBreak::Uppercase),
  ((0,1,126),(0,1,128),SentenceBreak::Lowercase),
  ((0,1,129),(0,1,130),SentenceBreak::Uppercase),
  ((0,1,131),(0,1,131),SentenceBreak::Lowercase),
  ((0,1,132),(0,1,132),SentenceBreak::Uppercase),
  ((0,1,133),(0,1,133),SentenceBreak::Lowercase),
  ((0,1,134),(0,1,135),SentenceBreak::Uppercase),
  ((0,1,136),(0,1,136),SentenceBreak::Lowercase),
  ((0,1,137),(0,1,139),SentenceBreak::Uppercase),
  ((0,1,140),(0,1,141),SentenceBreak::Lowercase),
  ((0,1,142),(0,1,145),SentenceBreak::Uppercase),
  ((0,1,146),(0,1,146),SentenceBreak::Lowercase),
  ((0,1,147),(0,1,148),SentenceBreak::Uppercase),
  ((0,1,149),(0,1,149),SentenceBreak::Lowercase),
  ((0,1,150),(0,1,152),SentenceBreak::Uppercase),
  ((0,1,153),(0,1,155),SentenceBreak::Lowercase),
  ((0,1,156),(0,1,157),SentenceBreak::Uppercase),
  ((0,1,158),(0,1,158),SentenceBreak::Lowercase),
  ((0,1,159),(0,1,160),SentenceBreak::Uppercase),
  ((0,1,161),(0,1,161),SentenceBreak::Lowercase),
  ((0,1,162),(0,1,162),SentenceBreak::Uppercase),
  ((0,1,163),(0,1,163),SentenceBreak::Lowercase),
  ((0,1,164),(0,1,164),SentenceBreak::Uppercase),
  ((0,1,165),(0,1,165),SentenceBreak::Lowercase),
  ((0,1,166),(0,1,167),SentenceBreak::Uppercase),
  ((0,1,168),(0,1,168),SentenceBreak::Lowercase),
  ((0,1,169),(0,1,169),SentenceBreak::Uppercase),
  ((0,1,170),(0,1,171),SentenceBreak::Lowercase),
  ((0,1,172),(0,1,172),SentenceBreak::Uppercase),
  ((0,1,173),(0,1,173),SentenceBreak::Lowercase),
  ((0,1,174),(0,1,175),SentenceBreak::Uppercase),
  ((0,1,176),(0,1,176),SentenceBreak::Lowercase),
  ((0,1,177),(0,1,179),SentenceBreak::Uppercase),
  ((0,1,180),(0,1,180),SentenceBreak::Lowercase),
  ((0,1,181),(0,1,181),SentenceBreak::Uppercase),
  ((0,1,182),(0,1,182),SentenceBreak::Lowercase),
  ((0,1,183),(0,1,184),SentenceBreak::Uppercase),
  ((0,1,185),(0,1,186),SentenceBreak::Lowercase),
  ((0,1,187),(0,1,187),SentenceBreak::OLetter),
  ((0,1,188),(0,1,188),SentenceBreak::Uppercase),
  ((0,1,189),(0,1,191),SentenceBreak::Lowercase),
  ((0,1,192),(0,1,195),SentenceBreak::OLetter),
  ((0,1,196),(0,1,197),SentenceBreak::Uppercase),
  ((0,1,198),(0,1,198),SentenceBreak::Lowercase),
  ((0,1,199),(0,1,200),SentenceBreak::Uppercase),
  ((0,1,201),(0,1,201),SentenceBreak::Lowercase),
  ((0,1,202),(0,1,203),SentenceBreak::Uppercase),
  ((0,1,204),(0,1,204),SentenceBreak::Lowercase),
  ((0,1,205),(0,1,205),SentenceBreak::Uppercase),
  ((0,1,206),(0,1,206),SentenceBreak::Lowercase),
  ((0,1,207),(0,1,207),SentenceBreak::Uppercase),
  ((0,1,208),(0,1,208),SentenceBreak::Lowercase),
  ((0,1,209),(0,1,209),SentenceBreak::Uppercase),
  ((0,1,210),(0,1,210),SentenceBreak::Lowercase),
  ((0,1,211),(0,1,211),SentenceBreak::Uppercase),
  ((0,1,212),(0,1,212),SentenceBreak::Lowercase),
  ((0,1,213),(0,1,213),SentenceBreak::Uppercase),
  ((0,1,214),(0,1,214),SentenceBreak::Lowercase),
  ((0,1,215),(0,1,215),SentenceBreak::Uppercase),
  ((0,1,216),(0,1,216),SentenceBreak::Lowercase),
  ((0,1,217),(0,1,217),SentenceBreak::Uppercase),
  ((0,1,218),(0,1,218),SentenceBreak::Lowercase),
  ((0,1,219),(0,1,219),SentenceBreak::Uppercase),
  ((0,1,220),(0,1,221),SentenceBreak::Lowercase),
  ((0,1,222),(0,1,222),SentenceBreak::Uppercase),
  ((0,1,223),(0,1,223),SentenceBreak::Lowercase),
  ((0,1,224),(0,1,224),SentenceBreak::Uppercase),
  ((0,1,225),(0,1,225),SentenceBreak::Lowercase),
  ((0,1,226),(0,1,226),SentenceBreak::Uppercase),
  ((0,1,227),(0,1,227),SentenceBreak::Lowercase),
  ((0,1,228),(0,1,228),SentenceBreak::Uppercase),
  ((0,1,229),(0,1,229),SentenceBreak::Lowercase),
  ((0,1,230),(0,1,230),SentenceBreak::Uppercase),
  ((0,1,231),(0,1,231),SentenceBreak::Lowercase),
  ((0,1,232),(0,1,232),SentenceBreak::Uppercase),
  ((0,1,233),(0,1,233),SentenceBreak::Lowercase),
  ((0,1,234),(0,1,234),SentenceBreak::Uppercase),
  ((0,1,235),(0,1,235),SentenceBreak::Lowercase),
  ((0,1,236),(0,1,236),SentenceBreak::Uppercase),
  ((0,1,237),(0,1,237),SentenceBreak::Lowercase),
  ((0,1,238),(0,1,238),SentenceBreak::Uppercase),
  ((0,1,239),(0,1,240),SentenceBreak::Lowercase),
  ((0,1,241),(0,1,242),SentenceBreak::Uppercase),
  ((0,1,243),(0,1,243),SentenceBreak::Lowercase),
  ((0,1,244),(0,1,244),SentenceBreak::Uppercase),
  ((0,1,245),(0,1,245),SentenceBreak::Lowercase),
  ((0,1,246),(0,1,248),SentenceBreak::Uppercase),
  ((0,1,249),(0,1,249),SentenceBreak::Lowercase),
  ((0,1,250),(0,1,250),SentenceBreak::Uppercase),
  ((0,1,251),(0,1,251),SentenceBreak::Lowercase),
  ((0,1,252),(0,1,252),SentenceBreak::Uppercase),
  ((0,1,253),(0,1,253),SentenceBreak::Lowercase),
  ((0,1,254),(0,1,254),SentenceBreak::Uppercase),
  ((0,1,255),(0,1,255),SentenceBreak::Lowercase),
  ((0,2,0),(0,2,0),SentenceBreak::Uppercase),
  ((0,2,1),(0,2,1),SentenceBreak::Lowercase),
  ((0,2,2),(0,2,2),SentenceBreak::Uppercase),
  ((0,2,3),(0,2,3),SentenceBreak::Lowercase),
  ((0,2,4),(0,2,4),SentenceBreak::Uppercase),
  ((0,2,5),(0,2,5),SentenceBreak::Lowercase),
  ((0,2,6),(0,2,6),SentenceBreak::Uppercase),
  ((0,2,7),(0,2,7),SentenceBreak::Lowercase),
  ((0,2,8),(0,2,8),SentenceBreak::Uppercase),
  ((0,2,9),(0,2,9),SentenceBreak::Lowercase),
  ((0,2,10),(0,2,10),SentenceBreak::Uppercase),
  ((0,2,11),(0,2,11),SentenceBreak::Lowercase),
  ((0,2,12),(0,2,12),SentenceBreak::Uppercase),
  ((0,2,13),(0,2,13),SentenceBreak::Lowercase),
  ((0,2,14),(0,2,14),SentenceBreak::Uppercase),
  ((0,2,15),(0,2,15),SentenceBreak::Lowercase),
  ((0,2,16),(0,2,16),SentenceBreak::Uppercase),
  ((0,2,17),(0,2,17),SentenceBreak::Lowercase),
  ((0,2,18),(0,2,18),SentenceBreak::Uppercase),
  ((0,2,19),(0,2,19),SentenceBreak::Lowercase),
  ((0,2,20),(0,2,20),SentenceBreak::Uppercase),
  ((0,2,21),(0,2,21),SentenceBreak::Lowercase),
  ((0,2,22),(0,2,22),SentenceBreak::Uppercase),
  ((0,2,23),(0,2,23),SentenceBreak::Lowercase),
  ((0,2,24),(0,2,24),SentenceBreak::Uppercase),
  ((0,2,25),(0,2,25),SentenceBreak::Lowercase),
  ((0,2,26),(0,2,26),SentenceBreak::Uppercase),
  ((0,2,27),(0,2,27),SentenceBreak::Lowercase),
  ((0,2,28),(0,2,28),SentenceBreak::Uppercase),
  ((0,2,29),(0,2,29),SentenceBreak::Lowercase),
  ((0,2,30),(0,2,30),SentenceBreak::Uppercase),
  ((0,2,31),(0,2,31),SentenceBreak::Lowercase),
  ((0,2,32),(0,2,32),SentenceBreak::Uppercase),
  ((0,2,33),(0,2,33),SentenceBreak::Lowercase),
  ((0,2,34),(0,2,34),SentenceBreak::Uppercase),
  ((0,2,35),(0,2,35),SentenceBreak::Lowercase),
  ((0,2,36),(0,2,36),SentenceBreak::Uppercase),
  ((0,2,37),(0,2,37),SentenceBreak::Lowercase),
  ((0,2,38),(0,2,38),SentenceBreak::Uppercase),
  ((0,2,39),(0,2,39),SentenceBreak::Lowercase),
  ((0,2,40),(0,2,40),SentenceBreak::Uppercase),
  ((0,2,41),(0,2,41),SentenceBreak::Lowercase),
  ((0,2,42),(0,2,42),SentenceBreak::Uppercase),
  ((0,2,43),(0,2,43),SentenceBreak::Lowercase),
  ((0,2,44),(0,2,44),SentenceBreak::Uppercase),
  ((0,2,45),(0,2,45),SentenceBreak::Lowercase),
  ((0,2,46),(0,2,46),SentenceBreak::Uppercase),
  ((0,2,47),(0,2,47),SentenceBreak::Lowercase),
  ((0,2,48),(0,2,48),SentenceBreak::Uppercase),
  ((0,2,49),(0,2,49),SentenceBreak::Lowercase),
  ((0,2,50),(0,2,50),SentenceBreak::Uppercase),
  ((0,2,51),(0,2,57),SentenceBreak::Lowercase),
  ((0,2,58),(0,2,59),SentenceBreak::Uppercase),
  ((0,2,60),(0,2,60),SentenceBreak::Lowercase),
  ((0,2,61),(0,2,62),SentenceBreak::Uppercase),
  ((0,2,63),(0,2,64),SentenceBreak::Lowercase),
  ((0,2,65),(0,2,65),SentenceBreak::Uppercase),
  ((0,2,66),(0,2,66),SentenceBreak::Lowercase),
  ((0,2,67),(0,2,70),SentenceBreak::Uppercase),
  ((0,2,71),(0,2,71),SentenceBreak::Lowercase),
  ((0,2,72),(0,2,72),SentenceBreak::Uppercase),
  ((0,2,73),(0,2,73),SentenceBreak::Lowercase),
  ((0,2,74),(0,2,74),SentenceBreak::Uppercase),
  ((0,2,75),(0,2,75),SentenceBreak::Lowercase),
  ((0,2,76),(0,2,76),SentenceBreak::Uppercase),
  ((0,2,77),(0,2,77),SentenceBreak::Lowercase),
  ((0,2,78),(0,2,78),SentenceBreak::Uppercase),
  ((0,2,79),(0,2,147),SentenceBreak::Lowercase),
  ((0,2,148),(0,2,148),SentenceBreak::OLetter),
  ((0,2,149),(0,2,184),SentenceBreak::Lowercase),
  ((0,2,185),(0,2,191),SentenceBreak::OLetter),
  ((0,2,192),(0,2,193),SentenceBreak::Lowercase),
  ((0,2,198),(0,2,209),SentenceBreak::OLetter),
  ((0,2,224),(0,2,228),SentenceBreak::Lowercase),
  ((0,2,236),(0,2,236),SentenceBreak::OLetter),
  ((0,2,238),(0,2,238),SentenceBreak::OLetter),
  ((0,3,0),(0,3,111),SentenceBreak::Extend),
  ((0,3,112),(0,3,112),SentenceBreak::Uppercase),
  ((0,3,113),(0,3,113),SentenceBreak::Lowercase),
  ((0,3,114),(0,3,114),SentenceBreak::Uppercase),
  ((0,3,115),(0,3,115),SentenceBreak::Lowercase),
  ((0,3,116),(0,3,116),SentenceBreak::OLetter),
  ((0,3,118),(0,3,118),SentenceBreak::Uppercase),
  ((0,3,119),(0,3,119),SentenceBreak::Lowercase),
  ((0,3,122),(0,3,125),SentenceBreak::Lowercase),
  ((0,3,127),(0,3,127),SentenceBreak::Uppercase),
  ((0,3,134),(0,3,134),SentenceBreak::Uppercase),
  ((0,3,136),(0,3,138),SentenceBreak::Uppercase),
  ((0,3,140),(0,3,140),SentenceBreak::Uppercase),
  ((0,3,142),(0,3,143),SentenceBreak::Uppercase),
  ((0,3,144),(0,3,144),SentenceBreak::Lowercase),
  ((0,3,145),(0,3,161),SentenceBreak::Uppercase),
  ((0,3,163),(0,3,171),SentenceBreak::Uppercase),
  ((0,3,172),(0,3,206),SentenceBreak::Lowercase),
  ((0,3,207),(0,3,207),SentenceBreak::Uppercase),
  ((0,3,208),(0,3,209),SentenceBreak::Lowercase),
  ((0,3,210),(0,3,212),SentenceBreak::Uppercase),
  ((0,3,213),(0,3,215),SentenceBreak::Lowercase),
  ((0,3,216),(0,3,216),SentenceBreak::Uppercase),
  ((0,3,217),(0,3,217),SentenceBreak::Lowercase),
  ((0,3,218),(0,3,218),SentenceBreak::Uppercase),
  ((0,3,219),(0,3,219),SentenceBreak::Lowercase),
  ((0,3,220),(0,3,220),SentenceBreak::Uppercase),
  ((0,3,221),(0,3,221),SentenceBreak::Lowercase),
  ((0,3,222),(0,3,222),SentenceBreak::Uppercase),
  ((0,3,223),(0,3,223),SentenceBreak::Lowercase),
  ((0,3,224),(0,3,224),SentenceBreak::Uppercase),
  ((0,3,225),(0,3,225),SentenceBreak::Lowercase),
  ((0,3,226),(0,3,226),SentenceBreak::Uppercase),
  ((0,3,227),(0,3,227),SentenceBreak::Lowercase),
  ((0,3,228),(0,3,228),SentenceBreak::Uppercase),
  ((0,3,229),(0,3,229),SentenceBreak::Lowercase),
  ((0,3,230),(0,3,230),SentenceBreak::Uppercase),
  ((0,3,231),(0,3,231),SentenceBreak::Lowercase),
  ((0,3,232),(0,3,232),SentenceBreak::Uppercase),
  ((0,3,233),(0,3,233),SentenceBreak::Lowercase),
  ((0,3,234),(0,3,234),SentenceBreak::Uppercase),
  ((0,3,235),(0,3,235),SentenceBreak::Lowercase),
  ((0,3,236),(0,3,236),SentenceBreak::Uppercase),
  ((0,3,237),(0,3,237),SentenceBreak::Lowercase),
  ((0,3,238),(0,3,238),SentenceBreak::Uppercase),
  ((0,3,239),(0,3,243),SentenceBreak::Lowercase),
  ((0,3,244),(0,3,244),SentenceBreak::Uppercase),
  ((0,3,245),(0,3,245),SentenceBreak::Lowercase),
  ((0,3,247),(0,3,247),SentenceBreak::Uppercase),
  ((0,3,248),(0,3,248),SentenceBreak::Lowercase),
  ((0,3,249),(0,3,250),SentenceBreak::Uppercase),
  ((0,3,251),(0,3,252),SentenceBreak::Lowercase),
  ((0,3,253),(0,4,47),SentenceBreak::Uppercase),
  ((0,4,48),(0,4,95),SentenceBreak::Lowercase),
  ((0,4,96),(0,4,96),SentenceBreak::Uppercase),
  ((0,4,97),(0,4,97),SentenceBreak::Lowercase),
  ((0,4,98),(0,4,98),SentenceBreak::Uppercase),
  ((0,4,99),(0,4,99),SentenceBreak::Lowercase),
  ((0,4,100),(0,4,100),SentenceBreak::Uppercase),
  ((0,4,101),(0,4,101),SentenceBreak::Lowercase),
  ((0,4,102),(0,4,102),SentenceBreak::Uppercase),
  ((0,4,103),(0,4,103),SentenceBreak::Lowercase),
  ((0,4,104),(0,4,104),SentenceBreak::Uppercase),
  ((0,4,105),(0,4,105),SentenceBreak::Lowercase),
  ((0,4,106),(0,4,106),SentenceBreak::Uppercase),
  ((0,4,107),(0,4,107),SentenceBreak::Lowercase),
  ((0,4,108),(0,4,108),SentenceBreak::Uppercase),
  ((0,4,109),(0,4,109),SentenceBreak::Lowercase),
  ((0,4,110),(0,4,110),SentenceBreak::Uppercase),
  ((0,4,111),(0,4,111),SentenceBreak::Lowercase),
  ((0,4,112),(0,4,112),SentenceBreak::Uppercase),
  ((0,4,113),(0,4,113),SentenceBreak::Lowercase),
  ((0,4,114),(0,4,114),SentenceBreak::Uppercase),
  ((0,4,115),(0,4,115),SentenceBreak::Lowercase),
  ((0,4,116),(0,4,116),SentenceBreak::Uppercase),
  ((0,4,117),(0,4,117),SentenceBreak::Lowercase),
  ((0,4,118),(0,4,118),SentenceBreak::Uppercase),
  ((0,4,119),(0,4,119),SentenceBreak::Lowercase),
  ((0,4,120),(0,4,120),SentenceBreak::Uppercase),
  ((0,4,121),(0,4,121),SentenceBreak::Lowercase),
  ((0,4,122),(0,4,122),SentenceBreak::Uppercase),
  ((0,4,123),(0,4,123),SentenceBreak::Lowercase),
  ((0,4,124),(0,4,124),SentenceBreak::Uppercase),
  ((0,4,125),(0,4,125),SentenceBreak::Lowercase),
  ((0,4,126),(0,4,126),SentenceBreak::Uppercase),
  ((0,4,127),(0,4,127),SentenceBreak::Lowercase),
  ((0,4,128),(0,4,128),SentenceBreak::Uppercase),
  ((0,4,129),(0,4,129),SentenceBreak::Lowercase),
  ((0,4,131),(0,4,137),SentenceBreak::Extend),
  ((0,4,138),(0,4,138),SentenceBreak::Uppercase),
  ((0,4,139),(0,4,139),SentenceBreak::Lowercase),
  ((0,4,140),(0,4,140),SentenceBreak::Uppercase),
  ((0,4,141),(0,4,141),SentenceBreak::Lowercase),
  ((0,4,142),(0,4,142),SentenceBreak::Uppercase),
  ((0,4,143),(0,4,143),SentenceBreak::Lowercase),
  ((0,4,144),(0,4,144),SentenceBreak::Uppercase),
  ((0,4,145),(0,4,145),SentenceBreak::Lowercase),
  ((0,4,146),(0,4,146),SentenceBreak::Uppercase),
  ((0,4,147),(0,4,147),SentenceBreak::Lowercase),
  ((0,4,148),(0,4,148),SentenceBreak::Uppercase),
  ((0,4,149),(0,4,149),SentenceBreak::Lowercase),
  ((0,4,150),(0,4,150),SentenceBreak::Uppercase),
  ((0,4,151),(0,4,151),SentenceBreak::Lowercase),
  ((0,4,152),(0,4,152),SentenceBreak::Uppercase),
  ((0,4,153),(0,4,153),SentenceBreak::Lowercase),
  ((0,4,154),(0,4,154),SentenceBreak::Uppercase),
  ((0,4,155),(0,4,155),SentenceBreak::Lowercase),
  ((0,4,156),(0,4,156),SentenceBreak::Uppercase),
  ((0,4,157),(0,4,157),SentenceBreak::Lowercase),
  ((0,4,158),(0,4,158),SentenceBreak::Uppercase),
  ((0,4,159),(0,4,159),SentenceBreak::Lowercase),
  ((0,4,160),(0,4,160),SentenceBreak::Uppercase),
  ((0,4,161),(0,4,161),SentenceBreak::Lowercase),
  ((0,4,162),(0,4,162),SentenceBreak::Uppercase),
  ((0,4,163),(0,4,163),SentenceBreak::Lowercase),
  ((0,4,164),(0,4,164),SentenceBreak::Uppercase),
  ((0,4,165),(0,4,165),SentenceBreak::Lowercase),
  ((0,4,166),(0,4,166),SentenceBreak::Uppercase),
  ((0,4,167),(0,4,167),SentenceBreak::Lowercase),
  ((0,4,168),(0,4,168),SentenceBreak::Uppercase),
  ((0,4,169),(0,4,169),SentenceBreak::Lowercase),
  ((0,4,170),(0,4,170),SentenceBreak::Uppercase),
  ((0,4,171),(0,4,171),SentenceBreak::Lowercase),
  ((0,4,172),(0,4,172),SentenceBreak::Uppercase),
  ((0,4,173),(0,4,173),SentenceBreak::Lowercase),
  ((0,4,174),(0,4,174),SentenceBreak::Uppercase),
  ((0,4,175),(0,4,175),SentenceBreak::Lowercase),
  ((0,4,176),(0,4,176),SentenceBreak::Uppercase),
  ((0,4,177),(0,4,177),SentenceBreak::Lowercase),
  ((0,4,178),(0,4,178),SentenceBreak::Uppercase),
  ((0,4,179),(0,4,179),SentenceBreak::Lowercase),
  ((0,4,180),(0,4,180),SentenceBreak::Uppercase),
  ((0,4,181),(0,4,181),SentenceBreak::Lowercase),
  ((0,4,182),(0,4,182),SentenceBreak::Uppercase),
  ((0,4,183),(0,4,183),SentenceBreak::Lowercase),
  ((0,4,184),(0,4,184),SentenceBreak::Uppercase),
  ((0,4,185),(0,4,185),SentenceBreak::Lowercase),
  ((0,4,186),(0,4,186),SentenceBreak::Uppercase),
  ((0,4,187),(0,4,187),SentenceBreak::Lowercase),
  ((0,4,188),(0,4,188),SentenceBreak::Uppercase),
  ((0,4,189),(0,4,189),SentenceBreak::Lowercase),
  ((0,4,190),(0,4,190),SentenceBreak::Uppercase),
  ((0,4,191),(0,4,191),SentenceBreak::Lowercase),
  ((0,4,192),(0,4,193),SentenceBreak::Uppercase),
  ((0,4,194),(0,4,194),SentenceBreak::Lowercase),
  ((0,4,195),(0,4,195),SentenceBreak::Uppercase),
  ((0,4,196),(0,4,196),SentenceBreak::Lowercase),
  ((0,4,197),(0,4,197),SentenceBreak::Uppercase),
  ((0,4,198),(0,4,198),SentenceBreak::Lowercase),
  ((0,4,199),(0,4,199),SentenceBreak::Uppercase),
  ((0,4,200),(0,4,200),SentenceBreak::Lowercase),
  ((0,4,201),(0,4,201),SentenceBreak::Uppercase),
  ((0,4,202),(0,4,202),SentenceBreak::Lowercase),
  ((0,4,203),(0,4,203),SentenceBreak::Uppercase),
  ((0,4,204),(0,4,204),SentenceBreak::Lowercase),
  ((0,4,205),(0,4,205),SentenceBreak::Uppercase),
  ((0,4,206),(0,4,207),SentenceBreak::Lowercase),
  ((0,4,208),(0,4,208),SentenceBreak::Uppercase),
  ((0,4,209),(0,4,209),SentenceBreak::Lowercase),
  ((0,4,210),(0,4,210),SentenceBreak::Uppercase),
  ((0,4,211),(0,4,211),SentenceBreak::Lowercase),
  ((0,4,212),(0,4,212),SentenceBreak::Uppercase),
  ((0,4,213),(0,4,213),SentenceBreak::Lowercase),
  ((0,4,214),(0,4,214),SentenceBreak::Uppercase),
  ((0,4,215),(0,4,215),SentenceBreak::Lowercase),
  ((0,4,216),(0,4,216),SentenceBreak::Uppercase),
  ((0,4,217),(0,4,217),SentenceBreak::Lowercase),
  ((0,4,218),(0,4,218),SentenceBreak::Uppercase),
  ((0,4,219),(0,4,219),SentenceBreak::Lowercase),
  ((0,4,220),(0,4,220),SentenceBreak::Uppercase),
  ((0,4,221),(0,4,221),SentenceBreak::Lowercase),
  ((0,4,222),(0,4,222),SentenceBreak::Uppercase),
  ((0,4,223),(0,4,223),SentenceBreak::Lowercase),
  ((0,4,224),(0,4,224),SentenceBreak::Uppercase),
  ((0,4,225),(0,4,225),SentenceBreak::Lowercase),
  ((0,4,226),(0,4,226),SentenceBreak::Uppercase),
  ((0,4,227),(0,4,227),SentenceBreak::Lowercase),
  ((0,4,228),(0,4,228),SentenceBreak::Uppercase),
  ((0,4,229),(0,4,229),SentenceBreak::Lowercase),
  ((0,4,230),(0,4,230),SentenceBreak::Uppercase),
  ((0,4,231),(0,4,231),SentenceBreak::Lowercase),
  ((0,4,232),(0,4,232),SentenceBreak::Uppercase),
  ((0,4,233),(0,4,233),SentenceBreak::Lowercase),
  ((0,4,234),(0,4,234),SentenceBreak::Uppercase),
  ((0,4,235),(0,4,235),SentenceBreak::Lowercase),
  ((0,4,236),(0,4,236),SentenceBreak::Uppercase),
  ((0,4,237),(0,4,237),SentenceBreak::Lowercase),
  ((0,4,238),(0,4,238),SentenceBreak::Uppercase),
  ((0,4,239),(0,4,239),SentenceBreak::Lowercase),
  ((0,4,240),(0,4,240),SentenceBreak::Uppercase),
  ((0,4,241),(0,4,241),SentenceBreak::Lowercase),
  ((0,4,242),(0,4,242),SentenceBreak::Uppercase),
  ((0,4,243),(0,4,243),SentenceBreak::Lowercase),
  ((0,4,244),(0,4,244),SentenceBreak::Uppercase),
  ((0,4,245),(0,4,245),SentenceBreak::Lowercase),
  ((0,4,246),(0,4,246),SentenceBreak::Uppercase),
  ((0,4,247),(0,4,247),SentenceBreak::Lowercase),
  ((0,4,248),(0,4,248),SentenceBreak::Uppercase),
  ((0,4,249),(0,4,249),SentenceBreak::Lowercase),
  ((0,4,250),(0,4,250),SentenceBreak::Uppercase),
  ((0,4,251),(0,4,251),SentenceBreak::Lowercase),
  ((0,4,252),(0,4,252),SentenceBreak::Uppercase),
  ((0,4,253),(0,4,253),SentenceBreak::Lowercase),
  ((0,4,254),(0,4,254),SentenceBreak::Uppercase),
  ((0,4,255),(0,4,255),SentenceBreak::Lowercase),
  ((0,5,0),(0,5,0),SentenceBreak::Uppercase),
  ((0,5,1),(0,5,1),SentenceBreak::Lowercase),
  ((0,5,2),(0,5,2),SentenceBreak::Uppercase),
  ((0,5,3),(0,5,3),SentenceBreak::Lowercase),
  ((0,5,4),(0,5,4),SentenceBreak::Uppercase),
  ((0,5,5),(0,5,5),SentenceBreak::Lowercase),
  ((0,5,6),(0,5,6),SentenceBreak::Uppercase),
  ((0,5,7),(0,5,7),SentenceBreak::Lowercase),
  ((0,5,8),(0,5,8),SentenceBreak::Uppercase),
  ((0,5,9),(0,5,9),SentenceBreak::Lowercase),
  ((0,5,10),(0,5,10),SentenceBreak::Uppercase),
  ((0,5,11),(0,5,11),SentenceBreak::Lowercase),
  ((0,5,12),(0,5,12),SentenceBreak::Uppercase),
  ((0,5,13),(0,5,13),SentenceBreak::Lowercase),
  ((0,5,14),(0,5,14),SentenceBreak::Uppercase),
  ((0,5,15),(0,5,15),SentenceBreak::Lowercase),
  ((0,5,16),(0,5,16),SentenceBreak::Uppercase),
  ((0,5,17),(0,5,17),SentenceBreak::Lowercase),
  ((0,5,18),(0,5,18),SentenceBreak::Uppercase),
  ((0,5,19),(0,5,19),SentenceBreak::Lowercase),
  ((0,5,20),(0,5,20),SentenceBreak::Uppercase),
  ((0,5,21),(0,5,21),SentenceBreak::Lowercase),
  ((0,5,22),(0,5,22),SentenceBreak::Uppercase),
  ((0,5,23),(0,5,23),SentenceBreak::Lowercase),
  ((0,5,24),(0,5,24),SentenceBreak::Uppercase),
  ((0,5,25),(0,5,25),SentenceBreak::Lowercase),
  ((0,5,26),(0,5,26),SentenceBreak::Uppercase),
  ((0,5,27),(0,5,27),SentenceBreak::Lowercase),
  ((0,5,28),(0,5,28),SentenceBreak::Uppercase),
  ((0,5,29),(0,5,29),SentenceBreak::Lowercase),
  ((0,5,30),(0,5,30),SentenceBreak::Uppercase),
  ((0,5,31),(0,5,31),SentenceBreak::Lowercase),
  ((0,5,32),(0,5,32),SentenceBreak::Uppercase),
  ((0,5,33),(0,5,33),SentenceBreak::Lowercase),
  ((0,5,34),(0,5,34),SentenceBreak::Uppercase),
  ((0,5,35),(0,5,35),SentenceBreak::Lowercase),
  ((0,5,36),(0,5,36),SentenceBreak::Uppercase),
  ((0,5,37),(0,5,37),SentenceBreak::Lowercase),
  ((0,5,38),(0,5,38),SentenceBreak::Uppercase),
  ((0,5,39),(0,5,39),SentenceBreak::Lowercase),
  ((0,5,40),(0,5,40),SentenceBreak::Uppercase),
  ((0,5,41),(0,5,41),SentenceBreak::Lowercase),
  ((0,5,42),(0,5,42),SentenceBreak::Uppercase),
  ((0,5,43),(0,5,43),SentenceBreak::Lowercase),
  ((0,5,44),(0,5,44),SentenceBreak::Uppercase),
  ((0,5,45),(0,5,45),SentenceBreak::Lowercase),
  ((0,5,46),(0,5,46),SentenceBreak::Uppercase),
  ((0,5,47),(0,5,47),SentenceBreak::Lowercase),
  ((0,5,49),(0,5,86),SentenceBreak::Uppercase),
  ((0,5,89),(0,5,89),SentenceBreak::OLetter),
  ((0,5,93),(0,5,93),SentenceBreak::SentenceContinue),
  ((0,5,97),(0,5,135),SentenceBreak::Lowercase),
  ((0,5,137),(0,5,137),SentenceBreak::SentenceTerminal),
  ((0,5,145),(0,5,189),SentenceBreak::Extend),
  ((0,5,191),(0,5,191),SentenceBreak::Extend),
  ((0,5,193),(0,5,194),SentenceBreak::Extend),
  ((0,5,196),(0,5,197),SentenceBreak::Extend),
  ((0,5,199),(0,5,199),SentenceBreak::Extend),
  ((0,5,208),(0,5,234),SentenceBreak::OLetter),
  ((0,5,240),(0,5,243),SentenceBreak::OLetter),
  ((0,6,0),(0,6,5),SentenceBreak::Format),
  ((0,6,12),(0,6,13),SentenceBreak::SentenceContinue),
  ((0,6,16),(0,6,26),SentenceBreak::Extend),
  ((0,6,28),(0,6,28),SentenceBreak::Format),
  ((0,6,31),(0,6,31),SentenceBreak::SentenceTerminal),
  ((0,6,32),(0,6,74),SentenceBreak::OLetter),
  ((0,6,75),(0,6,95),SentenceBreak::Extend),
  ((0,6,96),(0,6,105),SentenceBreak::Numeric),
  ((0,6,107),(0,6,108),SentenceBreak::Numeric),
  ((0,6,110),(0,6,111),SentenceBreak::OLetter),
  ((0,6,112),(0,6,112),SentenceBreak::Extend),
  ((0,6,113),(0,6,211),SentenceBreak::OLetter),
  ((0,6,212),(0,6,212),SentenceBreak::SentenceTerminal),
  ((0,6,213),(0,6,213),SentenceBreak::OLetter),
  ((0,6,214),(0,6,220),SentenceBreak::Extend),
  ((0,6,221),(0,6,221),SentenceBreak::Format),
  ((0,6,223),(0,6,228),SentenceBreak::Extend),
  ((0,6,229),(0,6,230),SentenceBreak::OLetter),
  ((0,6,231),(0,6,232),SentenceBreak::Extend),
  ((0,6,234),(0,6,237),SentenceBreak::Extend),
  ((0,6,238),(0,6,239),SentenceBreak::OLetter),
  ((0,6,240),(0,6,249),SentenceBreak::Numeric),
  ((0,6,250),(0,6,252),SentenceBreak::OLetter),
  ((0,6,255),(0,6,255),SentenceBreak::OLetter),
  ((0,7,0),(0,7,2),SentenceBreak::SentenceTerminal),
  ((0,7,15),(0,7,15),SentenceBreak::Format),
  ((0,7,16),(0,7,16),SentenceBreak::OLetter),
  ((0,7,17),(0,7,17),SentenceBreak::Extend),
  ((0,7,18),(0,7,47),SentenceBreak::OLetter),
  ((0,7,48),(0,7,74),SentenceBreak::Extend),
  ((0,7,77),(0,7,165),SentenceBreak::OLetter),
  ((0,7,166),(0,7,176),SentenceBreak::Extend),
  ((0,7,177),(0,7,177),SentenceBreak::OLetter),
  ((0,7,192),(0,7,201),SentenceBreak::Numeric),
  ((0,7,202),(0,7,234),SentenceBreak::OLetter),
  ((0,7,235),(0,7,243),SentenceBreak::Extend),
  ((0,7,244),(0,7,245),SentenceBreak::OLetter),
  ((0,7,248),(0,7,248),SentenceBreak::SentenceContinue),
  ((0,7,249),(0,7,249),SentenceBreak::SentenceTerminal),
  ((0,7,250),(0,7,250),SentenceBreak::OLetter),
  ((0,8,0),(0,8,21),SentenceBreak::OLetter),
  ((0,8,22),(0,8,25),SentenceBreak::Extend),
  ((0,8,26),(0,8,26),SentenceBreak::OLetter),
  ((0,8,27),(0,8,35),SentenceBreak::Extend),
  ((0,8,36),(0,8,36),SentenceBreak::OLetter),
  ((0,8,37),(0,8,39),SentenceBreak::Extend),
  ((0,8,40),(0,8,40),SentenceBreak::OLetter),
  ((0,8,41),(0,8,45),SentenceBreak::Extend),
  ((0,8,64),(0,8,88),SentenceBreak::OLetter),
  ((0,8,89),(0,8,91),SentenceBreak::Extend),
  ((0,8,160),(0,8,180),SentenceBreak::OLetter),
  ((0,8,182),(0,8,189),SentenceBreak::OLetter),
  ((0,8,212),(0,8,225),SentenceBreak::Extend),
  ((0,8,226),(0,8,226),SentenceBreak::Format),
  ((0,8,227),(0,9,3),SentenceBreak::Extend),
  ((0,9,4),(0,9,57),SentenceBreak::OLetter),
  ((0,9,58),(0,9,60),SentenceBreak::Extend),
  ((0,9,61),(0,9,61),SentenceBreak::OLetter),
  ((0,9,62),(0,9,79),SentenceBreak::Extend),
  ((0,9,80),(0,9,80),SentenceBreak::OLetter),
  ((0,9,81),(0,9,87),SentenceBreak::Extend),
  ((0,9,88),(0,9,97),SentenceBreak::OLetter),
  ((0,9,98),(0,9,99),SentenceBreak::Extend),
  ((0,9,100),(0,9,101),SentenceBreak::SentenceTerminal),
  ((0,9,102),(0,9,111),SentenceBreak::Numeric),
  ((0,9,113),(0,9,128),SentenceBreak::OLetter),
  ((0,9,129),(0,9,131),SentenceBreak::Extend),
  ((0,9,133),(0,9,140),SentenceBreak::OLetter),
  ((0,9,143),(0,9,144),SentenceBreak::OLetter),
  ((0,9,147),(0,9,168),SentenceBreak::OLetter),
  ((0,9,170),(0,9,176),SentenceBreak::OLetter),
  ((0,9,178),(0,9,178),SentenceBreak::OLetter),
  ((0,9,182),(0,9,185),SentenceBreak::OLetter),
  ((0,9,188),(0,9,188),SentenceBreak::Extend),
  ((0,9,189),(0,9,189),SentenceBreak::OLetter),
  ((0,9,190),(0,9,196),SentenceBreak::Extend),
  ((0,9,199),(0,9,200),SentenceBreak::Extend),
  ((0,9,203),(0,9,205),SentenceBreak::Extend),
  ((0,9,206),(0,9,206),SentenceBreak::OLetter),
  ((0,9,215),(0,9,215),SentenceBreak::Extend),
  ((0,9,220),(0,9,221),SentenceBreak::OLetter),
  ((0,9,223),(0,9,225),SentenceBreak::OLetter),
  ((0,9,226),(0,9,227),SentenceBreak::Extend),
  ((0,9,230),(0,9,239),SentenceBreak::Numeric),
  ((0,9,240),(0,9,241),SentenceBreak::OLetter),
  ((0,10,1),(0,10,3),SentenceBreak::Extend),
  ((0,10,5),(0,10,10),SentenceBreak::OLetter),
  ((0,10,15),(0,10,16),SentenceBreak::OLetter),
  ((0,10,19),(0,10,40),SentenceBreak::OLetter),
  ((0,10,42),(0,10,48),SentenceBreak::OLetter),
  ((0,10,50),(0,10,51),SentenceBreak::OLetter),
  ((0,10,53),(0,10,54),SentenceBreak::OLetter),
  ((0,10,56),(0,10,57),SentenceBreak::OLetter),
  ((0,10,60),(0,10,60),SentenceBreak::Extend),
  ((0,10,62),(0,10,66),SentenceBreak::Extend),
  ((0,10,71),(0,10,72),SentenceBreak::Extend),
  ((0,10,75),(0,10,77),SentenceBreak::Extend),
  ((0,10,81),(0,10,81),SentenceBreak::Extend),
  ((0,10,89),(0,10,92),SentenceBreak::OLetter),
  ((0,10,94),(0,10,94),SentenceBreak::OLetter),
  ((0,10,102),(0,10,111),SentenceBreak::Numeric),
  ((0,10,112),(0,10,113),SentenceBreak::Extend),
  ((0,10,114),(0,10,116),SentenceBreak::OLetter),
  ((0,10,117),(0,10,117),SentenceBreak::Extend),
  ((0,10,129),(0,10,131),SentenceBreak::Extend),
  ((0,10,133),(0,10,141),SentenceBreak::OLetter),
  ((0,10,143),(0,10,145),SentenceBreak::OLetter),
  ((0,10,147),(0,10,168),SentenceBreak::OLetter),
  ((0,10,170),(0,10,176),SentenceBreak::OLetter),
  ((0,10,178),(0,10,179),SentenceBreak::OLetter),
  ((0,10,181),(0,10,185),SentenceBreak::OLetter),
  ((0,10,188),(0,10,188),SentenceBreak::Extend),
  ((0,10,189),(0,10,189),SentenceBreak::OLetter),
  ((0,10,190),(0,10,197),SentenceBreak::Extend),
  ((0,10,199),(0,10,201),SentenceBreak::Extend),
  ((0,10,203),(0,10,205),SentenceBreak::Extend),
  ((0,10,208),(0,10,208),SentenceBreak::OLetter),
  ((0,10,224),(0,10,225),SentenceBreak::OLetter),
  ((0,10,226),(0,10,227),SentenceBreak::Extend),
  ((0,10,230),(0,10,239),SentenceBreak::Numeric),
  ((0,10,249),(0,10,249),SentenceBreak::OLetter),
  ((0,11,1),(0,11,3),SentenceBreak::Extend),
  ((0,11,5),(0,11,12),SentenceBreak::OLetter),
  ((0,11,15),(0,11,16),SentenceBreak::OLetter),
  ((0,11,19),(0,11,40),SentenceBreak::OLetter),
  ((0,11,42),(0,11,48),SentenceBreak::OLetter),
  ((0,11,50),(0,11,51),SentenceBreak::OLetter),
  ((0,11,53),(0,11,57),SentenceBreak::OLetter),
  ((0,11,60),(0,11,60),SentenceBreak::Extend),
  ((0,11,61),(0,11,61),SentenceBreak::OLetter),
  ((0,11,62),(0,11,68),SentenceBreak::Extend),
  ((0,11,71),(0,11,72),SentenceBreak::Extend),
  ((0,11,75),(0,11,77),SentenceBreak::Extend),
  ((0,11,86),(0,11,87),SentenceBreak::Extend),
  ((0,11,92),(0,11,93),SentenceBreak::OLetter),
  ((0,11,95),(0,11,97),SentenceBreak::OLetter),
  ((0,11,98),(0,11,99),SentenceBreak::Extend),
  ((0,11,102),(0,11,111),SentenceBreak::Numeric),
  ((0,11,113),(0,11,113),SentenceBreak::OLetter),
  ((0,11,130),(0,11,130),SentenceBreak::Extend),
  ((0,11,131),(0,11,131),SentenceBreak::OLetter),
  ((0,11,133),(0,11,138),SentenceBreak::OLetter),
  ((0,11,142),(0,11,144),SentenceBreak::OLetter),
  ((0,11,146),(0,11,149),SentenceBreak::OLetter),
  ((0,11,153),(0,11,154),SentenceBreak::OLetter),
  ((0,11,156),(0,11,156),SentenceBreak::OLetter),
  ((0,11,158),(0,11,159),SentenceBreak::OLetter),
  ((0,11,163),(0,11,164),SentenceBreak::OLetter),
  ((0,11,168),(0,11,170),SentenceBreak::OLetter),
  ((0,11,174),(0,11,185),SentenceBreak::OLetter),
  ((0,11,190),(0,11,194),SentenceBreak::Extend),
  ((0,11,198),(0,11,200),SentenceBreak::Extend),
  ((0,11,202),(0,11,205),SentenceBreak::Extend),
  ((0,11,208),(0,11,208),SentenceBreak::OLetter),
  ((0,11,215),(0,11,215),SentenceBreak::Extend),
  ((0,11,230),(0,11,239),SentenceBreak::Numeric),
  ((0,12,0),(0,12,3),SentenceBreak::Extend),
  ((0,12,5),(0,12,12),SentenceBreak::OLetter),
  ((0,12,14),(0,12,16),SentenceBreak::OLetter),
  ((0,12,18),(0,12,40),SentenceBreak::OLetter),
  ((0,12,42),(0,12,57),SentenceBreak::OLetter),
  ((0,12,61),(0,12,61),SentenceBreak::OLetter),
  ((0,12,62),(0,12,68),SentenceBreak::Extend),
  ((0,12,70),(0,12,72),SentenceBreak::Extend),
  ((0,12,74),(0,12,77),SentenceBreak::Extend),
  ((0,12,85),(0,12,86),SentenceBreak::Extend),
  ((0,12,88),(0,12,90),SentenceBreak::OLetter),
  ((0,12,96),(0,12,97),SentenceBreak::OLetter),
  ((0,12,98),(0,12,99),SentenceBreak::Extend),
  ((0,12,102),(0,12,111),SentenceBreak::Numeric),
  ((0,12,128),(0,12,128),SentenceBreak::OLetter),
  ((0,12,129),(0,12,131),SentenceBreak::Extend),
  ((0,12,133),(0,12,140),SentenceBreak::OLetter),
  ((0,12,142),(0,12,144),SentenceBreak::OLetter),
  ((0,12,146),(0,12,168),SentenceBreak::OLetter),
  ((0,12,170),(0,12,179),SentenceBreak::OLetter),
  ((0,12,181),(0,12,185),SentenceBreak::OLetter),
  ((0,12,188),(0,12,188),SentenceBreak::Extend),
  ((0,12,189),(0,12,189),SentenceBreak::OLetter),
  ((0,12,190),(0,12,196),SentenceBreak::Extend),
  ((0,12,198),(0,12,200),SentenceBreak::Extend),
  ((0,12,202),(0,12,205),SentenceBreak::Extend),
  ((0,12,213),(0,12,214),SentenceBreak::Extend),
  ((0,12,222),(0,12,222),SentenceBreak::OLetter),
  ((0,12,224),(0,12,225),SentenceBreak::OLetter),
  ((0,12,226),(0,12,227),SentenceBreak::Extend),
  ((0,12,230),(0,12,239),SentenceBreak::Numeric),
  ((0,12,241),(0,12,242),SentenceBreak::OLetter),
  ((0,13,1),(0,13,3),SentenceBreak::Extend),
  ((0,13,5),(0,13,12),SentenceBreak::OLetter),
  ((0,13,14),(0,13,16),SentenceBreak::OLetter),
  ((0,13,18),(0,13,58),SentenceBreak::OLetter),
  ((0,13,61),(0,13,61),SentenceBreak::OLetter),
  ((0,13,62),(0,13,68),SentenceBreak::Extend),
  ((0,13,70),(0,13,72),SentenceBreak::Extend),
  ((0,13,74),(0,13,77),SentenceBreak::Extend),
  ((0,13,78),(0,13,78),SentenceBreak::OLetter),
  ((0,13,84),(0,13,86),SentenceBreak::OLetter),
  ((0,13,87),(0,13,87),SentenceBreak::Extend),
  ((0,13,95),(0,13,97),SentenceBreak::OLetter),
  ((0,13,98),(0,13,99),SentenceBreak::Extend),
  ((0,13,102),(0,13,111),SentenceBreak::Numeric),
  ((0,13,122),(0,13,127),SentenceBreak::OLetter),
  ((0,13,130),(0,13,131),SentenceBreak::Extend),
  ((0,13,133),(0,13,150),SentenceBreak::OLetter),
  ((0,13,154),(0,13,177),SentenceBreak::OLetter),
  ((0,13,179),(0,13,187),SentenceBreak::OLetter),
  ((0,13,189),(0,13,189),SentenceBreak::OLetter),
  ((0,13,192),(0,13,198),SentenceBreak::OLetter),
  ((0,13,202),(0,13,202),SentenceBreak::Extend),
  ((0,13,207),(0,13,212),SentenceBreak::Extend),
  ((0,13,214),(0,13,214),SentenceBreak::Extend),
  ((0,13,216),(0,13,223),SentenceBreak::Extend),
  ((0,13,230),(0,13,239),SentenceBreak::Numeric),
  ((0,13,242),(0,13,243),SentenceBreak::Extend),
  ((0,14,1),(0,14,48),SentenceBreak::OLetter),
  ((0,14,49),(0,14,49),SentenceBreak::Extend),
  ((0,14,50),(0,14,51),SentenceBreak::OLetter),
  ((0,14,52),(0,14,58),SentenceBreak::Extend),
  ((0,14,64),(0,14,70),SentenceBreak::OLetter),
  ((0,14,71),(0,14,78),SentenceBreak::Extend),
  ((0,14,80),(0,14,89),SentenceBreak::Numeric),
  ((0,14,129),(0,14,130),SentenceBreak::OLetter),
  ((0,14,132),(0,14,132),SentenceBreak::OLetter),
  ((0,14,135),(0,14,136),SentenceBreak::OLetter),
  ((0,14,138),(0,14,138),SentenceBreak::OLetter),
  ((0,14,141),(0,14,141),SentenceBreak::OLetter),
  ((0,14,148),(0,14,151),SentenceBreak::OLetter),
  ((0,14,153),(0,14,159),SentenceBreak::OLetter),
  ((0,14,161),(0,14,163),SentenceBreak::OLetter),
  ((0,14,165),(0,14,165),SentenceBreak::OLetter),
  ((0,14,167),(0,14,167),SentenceBreak::OLetter),
  ((0,14,170),(0,14,171),SentenceBreak::OLetter),
  ((0,14,173),(0,14,176),SentenceBreak::OLetter),
  ((0,14,177),(0,14,177),SentenceBreak::Extend),
  ((0,14,178),(0,14,179),SentenceBreak::OLetter),
  ((0,14,180),(0,14,185),SentenceBreak::Extend),
  ((0,14,187),(0,14,188),SentenceBreak::Extend),
  ((0,14,189),(0,14,189),SentenceBreak::OLetter),
  ((0,14,192),(0,14,196),SentenceBreak::OLetter),
  ((0,14,198),(0,14,198),SentenceBreak::OLetter),
  ((0,14,200),(0,14,205),SentenceBreak::Extend),
  ((0,14,208),(0,14,217),SentenceBreak::Numeric),
  ((0,14,220),(0,14,223),SentenceBreak::OLetter),
  ((0,15,0),(0,15,0),SentenceBreak::OLetter),
  ((0,15,24),(0,15,25),SentenceBreak::Extend),
  ((0,15,32),(0,15,41),SentenceBreak::Numeric),
  ((0,15,53),(0,15,53),SentenceBreak::Extend),
  ((0,15,55),(0,15,55),SentenceBreak::Extend),
  ((0,15,57),(0,15,57),SentenceBreak::Extend),
  ((0,15,58),(0,15,61),SentenceBreak::Close),
  ((0,15,62),(0,15,63),SentenceBreak::Extend),
  ((0,15,64),(0,15,71),SentenceBreak::OLetter),
  ((0,15,73),(0,15,108),SentenceBreak::OLetter),
  ((0,15,113),(0,15,132),SentenceBreak::Extend),
  ((0,15,134),(0,15,135),SentenceBreak::Extend),
  ((0,15,136),(0,15,140),SentenceBreak::OLetter),
  ((0,15,141),(0,15,151),SentenceBreak::Extend),
  ((0,15,153),(0,15,188),SentenceBreak::Extend),
  ((0,15,198),(0,15,198),SentenceBreak::Extend),
  ((0,16,0),(0,16,42),SentenceBreak::OLetter),
  ((0,16,43),(0,16,62),SentenceBreak::Extend),
  ((0,16,63),(0,16,63),SentenceBreak::OLetter),
  ((0,16,64),(0,16,73),SentenceBreak::Numeric),
  ((0,16,74),(0,16,75),SentenceBreak::SentenceTerminal),
  ((0,16,80),(0,16,85),SentenceBreak::OLetter),
  ((0,16,86),(0,16,89),SentenceBreak::Extend),
  ((0,16,90),(0,16,93),SentenceBreak::OLetter),
  ((0,16,94),(0,16,96),SentenceBreak::Extend),
  ((0,16,97),(0,16,97),SentenceBreak::OLetter),
  ((0,16,98),(0,16,100),SentenceBreak::Extend),
  ((0,16,101),(0,16,102),SentenceBreak::OLetter),
  ((0,16,103),(0,16,109),SentenceBreak::Extend),
  ((0,16,110),(0,16,112),SentenceBreak::OLetter),
  ((0,16,113),(0,16,116),SentenceBreak::Extend),
  ((0,16,117),(0,16,129),SentenceBreak::OLetter),
  ((0,16,130),(0,16,141),SentenceBreak::Extend),
  ((0,16,142),(0,16,142),SentenceBreak::OLetter),
  ((0,16,143),(0,16,143),SentenceBreak::Extend),
  ((0,16,144),(0,16,153),SentenceBreak::Numeric),
  ((0,16,154),(0,16,157),SentenceBreak::Extend),
  ((0,16,160),(0,16,197),SentenceBreak::Uppercase),
  ((0,16,199),(0,16,199),SentenceBreak::Uppercase),
  ((0,16,205),(0,16,205),SentenceBreak::Uppercase),
  ((0,16,208),(0,16,250),SentenceBreak::OLetter),
  ((0,16,252),(0,18,72),SentenceBreak::OLetter),
  ((0,18,74),(0,18,77),SentenceBreak::OLetter),
  ((0,18,80),(0,18,86),SentenceBreak::OLetter),
  ((0,18,88),(0,18,88),SentenceBreak::OLetter),
  ((0,18,90),(0,18,93),SentenceBreak::OLetter),
  ((0,18,96),(0,18,136),SentenceBreak::OLetter),
  ((0,18,138),(0,18,141),SentenceBreak::OLetter),
  ((0,18,144),(0,18,176),SentenceBreak::OLetter),
  ((0,18,178),(0,18,181),SentenceBreak::OLetter),
  ((0,18,184),(0,18,190),SentenceBreak::OLetter),
  ((0,18,192),(0,18,192),SentenceBreak::OLetter),
  ((0,18,194),(0,18,197),SentenceBreak::OLetter),
  ((0,18,200),(0,18,214),SentenceBreak::OLetter),
  ((0,18,216),(0,19,16),SentenceBreak::OLetter),
  ((0,19,18),(0,19,21),SentenceBreak::OLetter),
  ((0,19,24),(0,19,90),SentenceBreak::OLetter),
  ((0,19,93),(0,19,95),SentenceBreak::Extend),
  ((0,19,98),(0,19,98),SentenceBreak::SentenceTerminal),
  ((0,19,103),(0,19,104),SentenceBreak::SentenceTerminal),
  ((0,19,128),(0,19,143),SentenceBreak::OLetter),
  ((0,19,160),(0,19,245),SentenceBreak::Uppercase),
  ((0,19,248),(0,19,253),SentenceBreak::Lowercase),
  ((0,20,1),(0,22,108),SentenceBreak::OLetter),
  ((0,22,110),(0,22,110),SentenceBreak::SentenceTerminal),
  ((0,22,111),(0,22,127),SentenceBreak::OLetter),
  ((0,22,128),(0,22,128),SentenceBreak::Space),
  ((0,22,129),(0,22,154),SentenceBreak::OLetter),
  ((0,22,155),(0,22,156),SentenceBreak::Close),
  ((0,22,160),(0,22,234),SentenceBreak::OLetter),
  ((0,22,238),(0,22,248),SentenceBreak::OLetter),
  ((0,23,0),(0,23,12),SentenceBreak::OLetter),
  ((0,23,14),(0,23,17),SentenceBreak::OLetter),
  ((0,23,18),(0,23,20),SentenceBreak::Extend),
  ((0,23,32),(0,23,49),SentenceBreak::OLetter),
  ((0,23,50),(0,23,52),SentenceBreak::Extend),
  ((0,23,53),(0,23,54),SentenceBreak::SentenceTerminal),
  ((0,23,64),(0,23,81),SentenceBreak::OLetter),
  ((0,23,82),(0,23,83),SentenceBreak::Extend),
  ((0,23,96),(0,23,108),SentenceBreak::OLetter),
  ((0,23,110),(0,23,112),SentenceBreak::OLetter),
  ((0,23,114),(0,23,115),SentenceBreak::Extend),
  ((0,23,128),(0,23,179),SentenceBreak::OLetter),
  ((0,23,180),(0,23,211),SentenceBreak::Extend),
  ((0,23,215),(0,23,215),SentenceBreak::OLetter),
  ((0,23,220),(0,23,220),SentenceBreak::OLetter),
  ((0,23,221),(0,23,221),SentenceBreak::Extend),
  ((0,23,224),(0,23,233),SentenceBreak::Numeric),
  ((0,24,2),(0,24,2),SentenceBreak::SentenceContinue),
  ((0,24,3),(0,24,3),SentenceBreak::SentenceTerminal),
  ((0,24,8),(0,24,8),SentenceBreak::SentenceContinue),
  ((0,24,9),(0,24,9),SentenceBreak::SentenceTerminal),
  ((0,24,11),(0,24,13),SentenceBreak::Extend),
  ((0,24,14),(0,24,14),SentenceBreak::Format),
  ((0,24,16),(0,24,25),SentenceBreak::Numeric),
  ((0,24,32),(0,24,119),SentenceBreak::OLetter),
  ((0,24,128),(0,24,132),SentenceBreak::OLetter),
  ((0,24,133),(0,24,134),SentenceBreak::Extend),
  ((0,24,135),(0,24,168),SentenceBreak::OLetter),
  ((0,24,169),(0,24,169),SentenceBreak::Extend),
  ((0,24,170),(0,24,170),SentenceBreak::OLetter),
  ((0,24,176),(0,24,245),SentenceBreak::OLetter),
  ((0,25,0),(0,25,30),SentenceBreak::OLetter),
  ((0,25,32),(0,25,43),SentenceBreak::Extend),
  ((0,25,48),(0,25,59),SentenceBreak::Extend),
  ((0,25,68),(0,25,69),SentenceBreak::SentenceTerminal),
  ((0,25,70),(0,25,79),SentenceBreak::Numeric),
  ((0,25,80),(0,25,109),SentenceBreak::OLetter),
  ((0,25,112),(0,25,116),SentenceBreak::OLetter),
  ((0,25,128),(0,25,171),SentenceBreak::OLetter),
  ((0,25,176),(0,25,201),SentenceBreak::OLetter),
  ((0,25,208),(0,25,217),SentenceBreak::Numeric),
  ((0,26,0),(0,26,22),SentenceBreak::OLetter),
  ((0,26,23),(0,26,27),SentenceBreak::Extend),
  ((0,26,32),(0,26,84),SentenceBreak::OLetter),
  ((0,26,85),(0,26,94),SentenceBreak::Extend),
  ((0,26,96),(0,26,124),SentenceBreak::Extend),
  ((0,26,127),(0,26,127),SentenceBreak::Extend),
  ((0,26,128),(0,26,137),SentenceBreak::Numeric),
  ((0,26,144),(0,26,153),SentenceBreak::Numeric),
  ((0,26,167),(0,26,167),SentenceBreak::OLetter),
  ((0,26,168),(0,26,171),SentenceBreak::SentenceTerminal),
  ((0,26,176),(0,26,190),SentenceBreak::Extend),
  ((0,27,0),(0,27,4),SentenceBreak::Extend),
  ((0,27,5),(0,27,51),SentenceBreak::OLetter),
  ((0,27,52),(0,27,68),SentenceBreak::Extend),
  ((0,27,69),(0,27,75),SentenceBreak::OLetter),
  ((0,27,80),(0,27,89),SentenceBreak::Numeric),
  ((0,27,90),(0,27,91),SentenceBreak::SentenceTerminal),
  ((0,27,94),(0,27,95),SentenceBreak::SentenceTerminal),
  ((0,27,107),(0,27,115),SentenceBreak::Extend),
  ((0,27,128),(0,27,130),SentenceBreak::Extend),
  ((0,27,131),(0,27,160),SentenceBreak::OLetter),
  ((0,27,161),(0,27,173),SentenceBreak::Extend),
  ((0,27,174),(0,27,175),SentenceBreak::OLetter),
  ((0,27,176),(0,27,185),SentenceBreak::Numeric),
  ((0,27,186),(0,27,229),SentenceBreak::OLetter),
  ((0,27,230),(0,27,243),SentenceBreak::Extend),
  ((0,28,0),(0,28,35),SentenceBreak::OLetter),
  ((0,28,36),(0,28,55),SentenceBreak::Extend),
  ((0,28,59),(0,28,60),SentenceBreak::SentenceTerminal),
  ((0,28,64),(0,28,73),SentenceBreak::Numeric),
  ((0,28,77),(0,28,79),SentenceBreak::OLetter),
  ((0,28,80),(0,28,89),SentenceBreak::Numeric),
  ((0,28,90),(0,28,125),SentenceBreak::OLetter),
  ((0,28,126),(0,28,127),SentenceBreak::SentenceTerminal),
  ((0,28,128),(0,28,136),SentenceBreak::Lowercase),
  ((0,28,208),(0,28,210),SentenceBreak::Extend),
  ((0,28,212),(0,28,232),SentenceBreak::Extend),
  ((0,28,233),(0,28,236),SentenceBreak::OLetter),
  ((0,28,237),(0,28,237),SentenceBreak::Extend),
  ((0,28,238),(0,28,241),SentenceBreak::OLetter),
  ((0,28,242),(0,28,244),SentenceBreak::Extend),
  ((0,28,245),(0,28,246),SentenceBreak::OLetter),
  ((0,28,248),(0,28,249),SentenceBreak::Extend),
  ((0,29,0),(0,29,191),SentenceBreak::Lowercase),
  ((0,29,192),(0,29,245),SentenceBreak::Extend),
  ((0,29,251),(0,29,255),SentenceBreak::Extend),
  ((0,30,0),(0,30,0),SentenceBreak::Uppercase),
  ((0,30,1),(0,30,1),SentenceBreak::Lowercase),
  ((0,30,2),(0,30,2),SentenceBreak::Uppercase),
  ((0,30,3),(0,30,3),SentenceBreak::Lowercase),
  ((0,30,4),(0,30,4),SentenceBreak::Uppercase),
  ((0,30,5),(0,30,5),SentenceBreak::Lowercase),
  ((0,30,6),(0,30,6),SentenceBreak::Uppercase),
  ((0,30,7),(0,30,7),SentenceBreak::Lowercase),
  ((0,30,8),(0,30,8),SentenceBreak::Uppercase),
  ((0,30,9),(0,30,9),SentenceBreak::Lowercase),
  ((0,30,10),(0,30,10),SentenceBreak::Uppercase),
  ((0,30,11),(0,30,11),SentenceBreak::Lowercase),
  ((0,30,12),(0,30,12),SentenceBreak::Uppercase),
  ((0,30,13),(0,30,13),SentenceBreak::Lowercase),
  ((0,30,14),(0,30,14),SentenceBreak::Uppercase),
  ((0,30,15),(0,30,15),SentenceBreak::Lowercase),
  ((0,30,16),(0,30,16),SentenceBreak::Uppercase),
  ((0,30,17),(0,30,17),SentenceBreak::Lowercase),
  ((0,30,18),(0,30,18),SentenceBreak::Uppercase),
  ((0,30,19),(0,30,19),SentenceBreak::Lowercase),
  ((0,30,20),(0,30,20),SentenceBreak::Uppercase),
  ((0,30,21),(0,30,21),SentenceBreak::Lowercase),
  ((0,30,22),(0,30,22),SentenceBreak::Uppercase),
  ((0,30,23),(0,30,23),SentenceBreak::Lowercase),
  ((0,30,24),(0,30,24),SentenceBreak::Uppercase),
  ((0,30,25),(0,30,25),SentenceBreak::Lowercase),
  ((0,30,26),(0,30,26),SentenceBreak::Uppercase),
  ((0,30,27),(0,30,27),SentenceBreak::Lowercase),
  ((0,30,28),(0,30,28),SentenceBreak::Uppercase),
  ((0,30,29),(0,30,29),SentenceBreak::Lowercase),
  ((0,30,30),(0,30,30),SentenceBreak::Uppercase),
  ((0,30,31),(0,30,31),SentenceBreak::Lowercase),
  ((0,30,32),(0,30,32),SentenceBreak::Uppercase),
  ((0,30,33),(0,30,33),SentenceBreak::Lowercase),
  ((0,30,34),(0,30,34),SentenceBreak::Uppercase),
  ((0,30,35),(0,30,35),SentenceBreak::Lowercase),
  ((0,30,36),(0,30,36),SentenceBreak::Uppercase),
  ((0,30,37),(0,30,37),SentenceBreak::Lowercase),
  ((0,30,38),(0,30,38),SentenceBreak::Uppercase),
  ((0,30,39),(0,30,39),SentenceBreak::Lowercase),
  ((0,30,40),(0,30,40),SentenceBreak::Uppercase),
  ((0,30,41),(0,30,41),SentenceBreak::Lowercase),
  ((0,30,42),(0,30,42),SentenceBreak::Uppercase),
  ((0,30,43),(0,30,43),SentenceBreak::Lowercase),
  ((0,30,44),(0,30,44),SentenceBreak::Uppercase),
  ((0,30,45),(0,30,45),SentenceBreak::Lowercase),
  ((0,30,46),(0,30,46),SentenceBreak::Uppercase),
  ((0,30,47),(0,30,47),SentenceBreak::Lowercase),
  ((0,30,48),(0,30,48),SentenceBreak::Uppercase),
  ((0,30,49),(0,30,49),SentenceBreak::Lowercase),
  ((0,30,50),(0,30,50),SentenceBreak::Uppercase),
  ((0,30,51),(0,30,51),SentenceBreak::Lowercase),
  ((0,30,52),(0,30,52),SentenceBreak::Uppercase),
  ((0,30,53),(0,30,53),SentenceBreak::Lowercase),
  ((0,30,54),(0,30,54),SentenceBreak::Uppercase),
  ((0,30,55),(0,30,55),SentenceBreak::Lowercase),
  ((0,30,56),(0,30,56),SentenceBreak::Uppercase),
  ((0,30,57),(0,30,57),SentenceBreak::Lowercase),
  ((0,30,58),(0,30,58),SentenceBreak::Uppercase),
  ((0,30,59),(0,30,59),SentenceBreak::Lowercase),
  ((0,30,60),(0,30,60),SentenceBreak::Uppercase),
  ((0,30,61),(0,30,61),SentenceBreak::Lowercase),
  ((0,30,62),(0,30,62),SentenceBreak::Uppercase),
  ((0,30,63),(0,30,63),SentenceBreak::Lowercase),
  ((0,30,64),(0,30,64),SentenceBreak::Uppercase),
  ((0,30,65),(0,30,65),SentenceBreak::Lowercase),
  ((0,30,66),(0,30,66),SentenceBreak::Uppercase),
  ((0,30,67),(0,30,67),SentenceBreak::Lowercase),
  ((0,30,68),(0,30,68),SentenceBreak::Uppercase),
  ((0,30,69),(0,30,69),SentenceBreak::Lowercase),
  ((0,30,70),(0,30,70),SentenceBreak::Uppercase),
  ((0,30,71),(0,30,71),SentenceBreak::Lowercase),
  ((0,30,72),(0,30,72),SentenceBreak::Uppercase),
  ((0,30,73),(0,30,73),SentenceBreak::Lowercase),
  ((0,30,74),(0,30,74),SentenceBreak::Uppercase),
  ((0,30,75),(0,30,75),SentenceBreak::Lowercase),
  ((0,30,76),(0,30,76),SentenceBreak::Uppercase),
  ((0,30,77),(0,30,77),SentenceBreak::Lowercase),
  ((0,30,78),(0,30,78),SentenceBreak::Uppercase),
  ((0,30,79),(0,30,79),SentenceBreak::Lowercase),
  ((0,30,80),(0,30,80),SentenceBreak::Uppercase),
  ((0,30,81),(0,30,81),SentenceBreak::Lowercase),
  ((0,30,82),(0,30,82),SentenceBreak::Uppercase),
  ((0,30,83),(0,30,83),SentenceBreak::Lowercase),
  ((0,30,84),(0,30,84),SentenceBreak::Uppercase),
  ((0,30,85),(0,30,85),SentenceBreak::Lowercase),
  ((0,30,86),(0,30,86),SentenceBreak::Uppercase),
  ((0,30,87),(0,30,87),SentenceBreak::Lowercase),
  ((0,30,88),(0,30,88),SentenceBreak::Uppercase),
  ((0,30,89),(0,30,89),SentenceBreak::Lowercase),
  ((0,30,90),(0,30,90),SentenceBreak::Uppercase),
  ((0,30,91),(0,30,91),SentenceBreak::Lowercase),
  ((0,30,92),(0,30,92),SentenceBreak::Uppercase),
  ((0,30,93),(0,30,93),SentenceBreak::Lowercase),
  ((0,30,94),(0,30,94),SentenceBreak::Uppercase),
  ((0,30,95),(0,30,95),SentenceBreak::Lowercase),
  ((0,30,96),(0,30,96),SentenceBreak::Uppercase),
  ((0,30,97),(0,30,97),SentenceBreak::Lowercase),
  ((0,30,98),(0,30,98),SentenceBreak::Uppercase),
  ((0,30,99),(0,30,99),SentenceBreak::Lowercase),
  ((0,30,100),(0,30,100),SentenceBreak::Uppercase),
  ((0,30,101),(0,30,101),SentenceBreak::Lowercase),
  ((0,30,102),(0,30,102),SentenceBreak::Uppercase),
  ((0,30,103),(0,30,103),SentenceBreak::Lowercase),
  ((0,30,104),(0,30,104),SentenceBreak::Uppercase),
  ((0,30,105),(0,30,105),SentenceBreak::Lowercase),
  ((0,30,106),(0,30,106),SentenceBreak::Uppercase),
  ((0,30,107),(0,30,107),SentenceBreak::Lowercase),
  ((0,30,108),(0,30,108),SentenceBreak::Uppercase),
  ((0,30,109),(0,30,109),SentenceBreak::Lowercase),
  ((0,30,110),(0,30,110),SentenceBreak::Uppercase),
  ((0,30,111),(0,30,111),SentenceBreak::Lowercase),
  ((0,30,112),(0,30,112),SentenceBreak::Uppercase),
  ((0,30,113),(0,30,113),SentenceBreak::Lowercase),
  ((0,30,114),(0,30,114),SentenceBreak::Uppercase),
  ((0,30,115),(0,30,115),SentenceBreak::Lowercase),
  ((0,30,116),(0,30,116),SentenceBreak::Uppercase),
  ((0,30,117),(0,30,117),SentenceBreak::Lowercase),
  ((0,30,118),(0,30,118),SentenceBreak::Uppercase),
  ((0,30,119),(0,30,119),SentenceBreak::Lowercase),
  ((0,30,120),(0,30,120),SentenceBreak::Uppercase),
  ((0,30,121),(0,30,121),SentenceBreak::Lowercase),
  ((0,30,122),(0,30,122),SentenceBreak::Uppercase),
  ((0,30,123),(0,30,123),SentenceBreak::Lowercase),
  ((0,30,124),(0,30,124),SentenceBreak::Uppercase),
  ((0,30,125),(0,30,125),SentenceBreak::Lowercase),
  ((0,30,126),(0,30,126),SentenceBreak::Uppercase),
  ((0,30,127),(0,30,127),SentenceBreak::Lowercase),
  ((0,30,128),(0,30,128),SentenceBreak::Uppercase),
  ((0,30,129),(0,30,129),SentenceBreak::Lowercase),
  ((0,30,130),(0,30,130),SentenceBreak::Uppercase),
  ((0,30,131),(0,30,131),SentenceBreak::Lowercase),
  ((0,30,132),(0,30,132),SentenceBreak::Uppercase),
  ((0,30,133),(0,30,133),SentenceBreak::Lowercase),
  ((0,30,134),(0,30,134),SentenceBreak::Uppercase),
  ((0,30,135),(0,30,135),SentenceBreak::Lowercase),
  ((0,30,136),(0,30,136),SentenceBreak::Uppercase),
  ((0,30,137),(0,30,137),SentenceBreak::Lowercase),
  ((0,30,138),(0,30,138),SentenceBreak::Uppercase),
  ((0,30,139),(0,30,139),SentenceBreak::Lowercase),
  ((0,30,140),(0,30,140),SentenceBreak::Uppercase),
  ((0,30,141),(0,30,141),SentenceBreak::Lowercase),
  ((0,30,142),(0,30,142),SentenceBreak::Uppercase),
  ((0,30,143),(0,30,143),SentenceBreak::Lowercase),
  ((0,30,144),(0,30,144),SentenceBreak::Uppercase),
  ((0,30,145),(0,30,145),SentenceBreak::Lowercase),
  ((0,30,146),(0,30,146),SentenceBreak::Uppercase),
  ((0,30,147),(0,30,147),SentenceBreak::Lowercase),
  ((0,30,148),(0,30,148),SentenceBreak::Uppercase),
  ((0,30,149),(0,30,157),SentenceBreak::Lowercase),
  ((0,30,158),(0,30,158),SentenceBreak::Uppercase),
  ((0,30,159),(0,30,159),SentenceBreak::Lowercase),
  ((0,30,160),(0,30,160),SentenceBreak::Uppercase),
  ((0,30,161),(0,30,161),SentenceBreak::Lowercase),
  ((0,30,162),(0,30,162),SentenceBreak::Uppercase),
  ((0,30,163),(0,30,163),SentenceBreak::Lowercase),
  ((0,30,164),(0,30,164),SentenceBreak::Uppercase),
  ((0,30,165),(0,30,165),SentenceBreak::Lowercase),
  ((0,30,166),(0,30,166),SentenceBreak::Uppercase),
  ((0,30,167),(0,30,167),SentenceBreak::Lowercase),
  ((0,30,168),(0,30,168),SentenceBreak::Uppercase),
  ((0,30,169),(0,30,169),SentenceBreak::Lowercase),
  ((0,30,170),(0,30,170),SentenceBreak::Uppercase),
  ((0,30,171),(0,30,171),SentenceBreak::Lowercase),
  ((0,30,172),(0,30,172),SentenceBreak::Uppercase),
  ((0,30,173),(0,30,173),SentenceBreak::Lowercase),
  ((0,30,174),(0,30,174),SentenceBreak::Uppercase),
  ((0,30,175),(0,30,175),SentenceBreak::Lowercase),
  ((0,30,176),(0,30,176),SentenceBreak::Uppercase),
  ((0,30,177),(0,30,177),SentenceBreak::Lowercase),
  ((0,30,178),(0,30,178),SentenceBreak::Uppercase),
  ((0,30,179),(0,30,179),SentenceBreak::Lowercase),
  ((0,30,180),(0,30,180),SentenceBreak::Uppercase),
  ((0,30,181),(0,30,181),SentenceBreak::Lowercase),
  ((0,30,182),(0,30,182),SentenceBreak::Uppercase),
  ((0,30,183),(0,30,183),SentenceBreak::Lowercase),
  ((0,30,184),(0,30,184),SentenceBreak::Uppercase),
  ((0,30,185),(0,30,185),SentenceBreak::Lowercase),
  ((0,30,186),(0,30,186),SentenceBreak::Uppercase),
  ((0,30,187),(0,30,187),SentenceBreak::Lowercase),
  ((0,30,188),(0,30,188),SentenceBreak::Uppercase),
  ((0,30,189),(0,30,189),SentenceBreak::Lowercase),
  ((0,30,190),(0,30,190),SentenceBreak::Uppercase),
  ((0,30,191),(0,30,191),SentenceBreak::Lowercase),
  ((0,30,192),(0,30,192),SentenceBreak::Uppercase),
  ((0,30,193),(0,30,193),SentenceBreak::Lowercase),
  ((0,30,194),(0,30,194),SentenceBreak::Uppercase),
  ((0,30,195),(0,30,195),SentenceBreak::Lowercase),
  ((0,30,196),(0,30,196),SentenceBreak::Uppercase),
  ((0,30,197),(0,30,197),SentenceBreak::Lowercase),
  ((0,30,198),(0,30,198),SentenceBreak::Uppercase),
  ((0,30,199),(0,30,199),SentenceBreak::Lowercase),
  ((0,30,200),(0,30,200),SentenceBreak::Uppercase),
  ((0,30,201),(0,30,201),SentenceBreak::Lowercase),
  ((0,30,202),(0,30,202),SentenceBreak::Uppercase),
  ((0,30,203),(0,30,203),SentenceBreak::Lowercase),
  ((0,30,204),(0,30,204),SentenceBreak::Uppercase),
  ((0,30,205),(0,30,205),SentenceBreak::Lowercase),
  ((0,30,206),(0,30,206),SentenceBreak::Uppercase),
  ((0,30,207),(0,30,207),SentenceBreak::Lowercase),
  ((0,30,208),(0,30,208),SentenceBreak::Uppercase),
  ((0,30,209),(0,30,209),SentenceBreak::Lowercase),
  ((0,30,210),(0,30,210),SentenceBreak::Uppercase),
  ((0,30,211),(0,30,211),SentenceBreak::Lowercase),
  ((0,30,212),(0,30,212),SentenceBreak::Uppercase),
  ((0,30,213),(0,30,213),SentenceBreak::Lowercase),
  ((0,30,214),(0,30,214),SentenceBreak::Uppercase),
  ((0,30,215),(0,30,215),SentenceBreak::Lowercase),
  ((0,30,216),(0,30,216),SentenceBreak::Uppercase),
  ((0,30,217),(0,30,217),SentenceBreak::Lowercase),
  ((0,30,218),(0,30,218),SentenceBreak::Uppercase),
  ((0,30,219),(0,30,219),SentenceBreak::Lowercase),
  ((0,30,220),(0,30,220),SentenceBreak::Uppercase),
  ((0,30,221),(0,30,221),SentenceBreak::Lowercase),
  ((0,30,222),(0,30,222),SentenceBreak::Uppercase),
  ((0,30,223),(0,30,223),SentenceBreak::Lowercase),
  ((0,30,224),(0,30,224),SentenceBreak::Uppercase),
  ((0,30,225),(0,30,225),SentenceBreak::Lowercase),
  ((0,30,226),(0,30,226),SentenceBreak::Uppercase),
  ((0,30,227),(0,30,227),SentenceBreak::Lowercase),
  ((0,30,228),(0,30,228),SentenceBreak::Uppercase),
  ((0,30,229),(0,30,229),SentenceBreak::Lowercase),
  ((0,30,230),(0,30,230),SentenceBreak::Uppercase),
  ((0,30,231),(0,30,231),SentenceBreak::Lowercase),
  ((0,30,232),(0,30,232),SentenceBreak::Uppercase),
  ((0,30,233),(0,30,233),SentenceBreak::Lowercase),
  ((0,30,234),(0,30,234),SentenceBreak::Uppercase),
  ((0,30,235),(0,30,235),SentenceBreak::Lowercase),
  ((0,30,236),(0,30,236),SentenceBreak::Uppercase),
  ((0,30,237),(0,30,237),SentenceBreak::Lowercase),
  ((0,30,238),(0,30,238),SentenceBreak::Uppercase),
  ((0,30,239),(0,30,239),SentenceBreak::Lowercase),
  ((0,30,240),(0,30,240),SentenceBreak::Uppercase),
  ((0,30,241),(0,30,241),SentenceBreak::Lowercase),
  ((0,30,242),(0,30,242),SentenceBreak::Uppercase),
  ((0,30,243),(0,30,243),SentenceBreak::Lowercase),
  ((0,30,244),(0,30,244),SentenceBreak::Uppercase),
  ((0,30,245),(0,30,245),SentenceBreak::Lowercase),
  ((0,30,246),(0,30,246),SentenceBreak::Uppercase),
  ((0,30,247),(0,30,247),SentenceBreak::Lowercase),
  ((0,30,248),(0,30,248),SentenceBreak::Uppercase),
  ((0,30,249),(0,30,249),SentenceBreak::Lowercase),
  ((0,30,250),(0,30,250),SentenceBreak::Uppercase),
  ((0,30,251),(0,30,251),SentenceBreak::Lowercase),
  ((0,30,252),(0,30,252),SentenceBreak::Uppercase),
  ((0,30,253),(0,30,253),SentenceBreak::Lowercase),
  ((0,30,254),(0,30,254),SentenceBreak::Uppercase),
  ((0,30,255),(0,31,7),SentenceBreak::Lowercase),
  ((0,31,8),(0,31,15),SentenceBreak::Uppercase),
  ((0,31,16),(0,31,21),SentenceBreak::Lowercase),
  ((0,31,24),(0,31,29),SentenceBreak::Uppercase),
  ((0,31,32),(0,31,39),SentenceBreak::Lowercase),
  ((0,31,40),(0,31,47),SentenceBreak::Uppercase),
  ((0,31,48),(0,31,55),SentenceBreak::Lowercase),
  ((0,31,56),(0,31,63),SentenceBreak::Uppercase),
  ((0,31,64),(0,31,69),SentenceBreak::Lowercase),
  ((0,31,72),(0,31,77),SentenceBreak::Uppercase),
  ((0,31,80),(0,31,87),SentenceBreak::Lowercase),
  ((0,31,89),(0,31,89),SentenceBreak::Uppercase),
  ((0,31,91),(0,31,91),SentenceBreak::Uppercase),
  ((0,31,93),(0,31,93),SentenceBreak::Uppercase),
  ((0,31,95),(0,31,95),SentenceBreak::Uppercase),
  ((0,31,96),(0,31,103),SentenceBreak::Lowercase),
  ((0,31,104),(0,31,111),SentenceBreak::Uppercase),
  ((0,31,112),(0,31,125),SentenceBreak::Lowercase),
  ((0,31,128),(0,31,135),SentenceBreak::Lowercase),
  ((0,31,136),(0,31,143),SentenceBreak::Uppercase),
  ((0,31,144),(0,31,151),SentenceBreak::Lowercase),
  ((0,31,152),(0,31,159),SentenceBreak::Uppercase),
  ((0,31,160),(0,31,167),SentenceBreak::Lowercase),
  ((0,31,168),(0,31,175),SentenceBreak::Uppercase),
  ((0,31,176),(0,31,180),SentenceBreak::Lowercase),
  ((0,31,182),(0,31,183),SentenceBreak::Lowercase),
  ((0,31,184),(0,31,188),SentenceBreak::Uppercase),
  ((0,31,190),(0,31,190),SentenceBreak::Lowercase),
  ((0,31,194),(0,31,196),SentenceBreak::Lowercase),
  ((0,31,198),(0,31,199),SentenceBreak::Lowercase),
  ((0,31,200),(0,31,204),SentenceBreak::Uppercase),
  ((0,31,208),(0,31,211),SentenceBreak::Lowercase),
  ((0,31,214),(0,31,215),SentenceBreak::Lowercase),
  ((0,31,216),(0,31,219),SentenceBreak::Uppercase),
  ((0,31,224),(0,31,231),SentenceBreak::Lowercase),
  ((0,31,232),(0,31,236),SentenceBreak::Uppercase),
  ((0,31,242),(0,31,244),SentenceBreak::Lowercase),
  ((0,31,246),(0,31,247),SentenceBreak::Lowercase),
  ((0,31,248),(0,31,252),SentenceBreak::Uppercase),
  ((0,32,0),(0,32,10),SentenceBreak::Space),
  ((0,32,11),(0,32,11),SentenceBreak::Format),
  ((0,32,12),(0,32,13),SentenceBreak::Extend),
  ((0,32,14),(0,32,15),SentenceBreak::Format),
  ((0,32,19),(0,32,20),SentenceBreak::SentenceContinue),
  ((0,32,24),(0,32,31),SentenceBreak::Close),
  ((0,32,36),(0,32,36),SentenceBreak::ATerm),
  ((0,32,40),(0,32,41),SentenceBreak::Separator),
  ((0,32,42),(0,32,46),SentenceBreak::Format),
  ((0,32,47),(0,32,47),SentenceBreak::Space),
  ((0,32,57),(0,32,58),SentenceBreak::Close),
  ((0,32,60),(0,32,61),SentenceBreak::SentenceTerminal),
  ((0,32,69),(0,32,70),SentenceBreak::Close),
  ((0,32,71),(0,32,73),SentenceBreak::SentenceTerminal),
  ((0,32,95),(0,32,95),SentenceBreak::Space),
  ((0,32,96),(0,32,100),SentenceBreak::Format),
  ((0,32,102),(0,32,111),SentenceBreak::Format),
  ((0,32,113),(0,32,113),SentenceBreak::Lowercase),
  ((0,32,125),(0,32,126),SentenceBreak::Close),
  ((0,32,127),(0,32,127),SentenceBreak::Lowercase),
  ((0,32,141),(0,32,142),SentenceBreak::Close),
  ((0,32,144),(0,32,156),SentenceBreak::Lowercase),
  ((0,32,208),(0,32,240),SentenceBreak::Extend),
  ((0,33,2),(0,33,2),SentenceBreak::Uppercase),
  ((0,33,7),(0,33,7),SentenceBreak::Uppercase),
  ((0,33,10),(0,33,10),SentenceBreak::Lowercase),
  ((0,33,11),(0,33,13),SentenceBreak::Uppercase),
  ((0,33,14),(0,33,15),SentenceBreak::Lowercase),
  ((0,33,16),(0,33,18),SentenceBreak::Uppercase),
  ((0,33,19),(0,33,19),SentenceBreak::Lowercase),
  ((0,33,21),(0,33,21),SentenceBreak::Uppercase),
  ((0,33,25),(0,33,29),SentenceBreak::Uppercase),
  ((0,33,36),(0,33,36),SentenceBreak::Uppercase),
  ((0,33,38),(0,33,38),SentenceBreak::Uppercase),
  ((0,33,40),(0,33,40),SentenceBreak::Uppercase),
  ((0,33,42),(0,33,45),SentenceBreak::Uppercase),
  ((0,33,47),(0,33,47),SentenceBreak::Lowercase),
  ((0,33,48),(0,33,51),SentenceBreak::Uppercase),
  ((0,33,52),(0,33,52),SentenceBreak::Lowercase),
  ((0,33,53),(0,33,56),SentenceBreak::OLetter),
  ((0,33,57),(0,33,57),SentenceBreak::Lowercase),
  ((0,33,60),(0,33,61),SentenceBreak::Lowercase),
  ((0,33,62),(0,33,63),SentenceBreak::Uppercase),
  ((0,33,69),(0,33,69),SentenceBreak::Uppercase),
  ((0,33,70),(0,33,73),SentenceBreak::Lowercase),
  ((0,33,78),(0,33,78),SentenceBreak::Lowercase),
  ((0,33,96),(0,33,111),SentenceBreak::Uppercase),
  ((0,33,112),(0,33,127),SentenceBreak::Lowercase),
  ((0,33,128),(0,33,130),SentenceBreak::OLetter),
  ((0,33,131),(0,33,131),SentenceBreak::Uppercase),
  ((0,33,132),(0,33,132),SentenceBreak::Lowercase),
  ((0,33,133),(0,33,136),SentenceBreak::OLetter),
  ((0,35,8),(0,35,11),SentenceBreak::Close),
  ((0,35,41),(0,35,42),SentenceBreak::Close),
  ((0,36,182),(0,36,207),SentenceBreak::Uppercase),
  ((0,36,208),(0,36,233),SentenceBreak::Lowercase),
  ((0,39,91),(0,39,96),SentenceBreak::Close),
  ((0,39,104),(0,39,117),SentenceBreak::Close),
  ((0,39,197),(0,39,198),SentenceBreak::Close),
  ((0,39,230),(0,39,239),SentenceBreak::Close),
  ((0,41,131),(0,41,152),SentenceBreak::Close),
  ((0,41,216),(0,41,219),SentenceBreak::Close),
  ((0,41,252),(0,41,253),SentenceBreak::Close),
  ((0,44,0),(0,44,46),SentenceBreak::Uppercase),
  ((0,44,48),(0,44,94),SentenceBreak::Lowercase),
  ((0,44,96),(0,44,96),SentenceBreak::Uppercase),
  ((0,44,97),(0,44,97),SentenceBreak::Lowercase),
  ((0,44,98),(0,44,100),SentenceBreak::Uppercase),
  ((0,44,101),(0,44,102),SentenceBreak::Lowercase),
  ((0,44,103),(0,44,103),SentenceBreak::Uppercase),
  ((0,44,104),(0,44,104),SentenceBreak::Lowercase),
  ((0,44,105),(0,44,105),SentenceBreak::Uppercase),
  ((0,44,106),(0,44,106),SentenceBreak::Lowercase),
  ((0,44,107),(0,44,107),SentenceBreak::Uppercase),
  ((0,44,108),(0,44,108),SentenceBreak::Lowercase),
  ((0,44,109),(0,44,112),SentenceBreak::Uppercase),
  ((0,44,113),(0,44,113),SentenceBreak::Lowercase),
  ((0,44,114),(0,44,114),SentenceBreak::Uppercase),
  ((0,44,115),(0,44,116),SentenceBreak::Lowercase),
  ((0,44,117),(0,44,117),SentenceBreak::Uppercase),
  ((0,44,118),(0,44,125),SentenceBreak::Lowercase),
  ((0,44,126),(0,44,128),SentenceBreak::Uppercase),
  ((0,44,129),(0,44,129),SentenceBreak::Lowercase),
  ((0,44,130),(0,44,130),SentenceBreak::Uppercase),
  ((0,44,131),(0,44,131),SentenceBreak::Lowercase),
  ((0,44,132),(0,44,132),SentenceBreak::Uppercase),
  ((0,44,133),(0,44,133),SentenceBreak::Lowercase),
  ((0,44,134),(0,44,134),SentenceBreak::Uppercase),
  ((0,44,135),(0,44,135),SentenceBreak::Lowercase),
  ((0,44,136),(0,44,136),SentenceBreak::Uppercase),
  ((0,44,137),(0,44,137),SentenceBreak::Lowercase),
  ((0,44,138),(0,44,138),SentenceBreak::Uppercase),
  ((0,44,139),(0,44,139),SentenceBreak::Lowercase),
  ((0,44,140),(0,44,140),SentenceBreak::Uppercase),
  ((0,44,141),(0,44,141),SentenceBreak::Lowercase),
  ((0,44,142),(0,44,142),SentenceBreak::Uppercase),
  ((0,44,143),(0,44,143),SentenceBreak::Lowercase),
  ((0,44,144),(0,44,144),SentenceBreak::Uppercase),
  ((0,44,145),(0,44,145),SentenceBreak::Lowercase),
  ((0,44,146),(0,44,146),SentenceBreak::Uppercase),
  ((0,44,147),(0,44,147),SentenceBreak::Lowercase),
  ((0,44,148),(0,44,148),SentenceBreak::Uppercase),
  ((0,44,149),(0,44,149),SentenceBreak::Lowercase),
  ((0,44,150),(0,44,150),SentenceBreak::Uppercase),
  ((0,44,151),(0,44,151),SentenceBreak::Lowercase),
  ((0,44,152),(0,44,152),SentenceBreak::Uppercase),
  ((0,44,153),(0,44,153),SentenceBreak::Lowercase),
  ((0,44,154),(0,44,154),SentenceBreak::Uppercase),
  ((0,44,155),(0,44,155),SentenceBreak::Lowercase),
  ((0,44,156),(0,44,156),SentenceBreak::Uppercase),
  ((0,44,157),(0,44,157),SentenceBreak::Lowercase),
  ((0,44,158),(0,44,158),SentenceBreak::Uppercase),
  ((0,44,159),(0,44,159),SentenceBreak::Lowercase),
  ((0,44,160),(0,44,160),SentenceBreak::Uppercase),
  ((0,44,161),(0,44,161),SentenceBreak::Lowercase),
  ((0,44,162),(0,44,162),SentenceBreak::Uppercase),
  ((0,44,163),(0,44,163),SentenceBreak::Lowercase),
  ((0,44,164),(0,44,164),SentenceBreak::Uppercase),
  ((0,44,165),(0,44,165),SentenceBreak::Lowercase),
  ((0,44,166),(0,44,166),SentenceBreak::Uppercase),
  ((0,44,167),(0,44,167),SentenceBreak::Lowercase),
  ((0,44,168),(0,44,168),SentenceBreak::Uppercase),
  ((0,44,169),(0,44,169),SentenceBreak::Lowercase),
  ((0,44,170),(0,44,170),SentenceBreak::Uppercase),
  ((0,44,171),(0,44,171),SentenceBreak::Lowercase),
  ((0,44,172),(0,44,172),SentenceBreak::Uppercase),
  ((0,44,173),(0,44,173),SentenceBreak::Lowercase),
  ((0,44,174),(0,44,174),SentenceBreak::Uppercase),
  ((0,44,175),(0,44,175),SentenceBreak::Lowercase),
  ((0,44,176),(0,44,176),SentenceBreak::Uppercase),
  ((0,44,177),(0,44,177),SentenceBreak::Lowercase),
  ((0,44,178),(0,44,178),SentenceBreak::Uppercase),
  ((0,44,179),(0,44,179),SentenceBreak::Lowercase),
  ((0,44,180),(0,44,180),SentenceBreak::Uppercase),
  ((0,44,181),(0,44,181),SentenceBreak::Lowercase),
  ((0,44,182),(0,44,182),SentenceBreak::Uppercase),
  ((0,44,183),(0,44,183),SentenceBreak::Lowercase),
  ((0,44,184),(0,44,184),SentenceBreak::Uppercase),
  ((0,44,185),(0,44,185),SentenceBreak::Lowercase),
  ((0,44,186),(0,44,186),SentenceBreak::Uppercase),
  ((0,44,187),(0,44,187),SentenceBreak::Lowercase),
  ((0,44,188),(0,44,188),SentenceBreak::Uppercase),
  ((0,44,189),(0,44,189),SentenceBreak::Lowercase),
  ((0,44,190),(0,44,190),SentenceBreak::Uppercase),
  ((0,44,191),(0,44,191),SentenceBreak::Lowercase),
  ((0,44,192),(0,44,192),SentenceBreak::Uppercase),
  ((0,44,193),(0,44,193),SentenceBreak::Lowercase),
  ((0,44,194),(0,44,194),SentenceBreak::Uppercase),
  ((0,44,195),(0,44,195),SentenceBreak::Lowercase),
  ((0,44,196),(0,44,196),SentenceBreak::Uppercase),
  ((0,44,197),(0,44,197),SentenceBreak::Lowercase),
  ((0,44,198),(0,44,198),SentenceBreak::Uppercase),
  ((0,44,199),(0,44,199),SentenceBreak::Lowercase),
  ((0,44,200),(0,44,200),SentenceBreak::Uppercase),
  ((0,44,201),(0,44,201),SentenceBreak::Lowercase),
  ((0,44,202),(0,44,202),SentenceBreak::Uppercase),
  ((0,44,203),(0,44,203),SentenceBreak::Lowercase),
  ((0,44,204),(0,44,204),SentenceBreak::Uppercase),
  ((0,44,205),(0,44,205),SentenceBreak::Lowercase),
  ((0,44,206),(0,44,206),SentenceBreak::Uppercase),
  ((0,44,207),(0,44,207),SentenceBreak::Lowercase),
  ((0,44,208),(0,44,208),SentenceBreak::Uppercase),
  ((0,44,209),(0,44,209),SentenceBreak::Lowercase),
  ((0,44,210),(0,44,210),SentenceBreak::Uppercase),
  ((0,44,211),(0,44,211),SentenceBreak::Lowercase),
  ((0,44,212),(0,44,212),SentenceBreak::Uppercase),
  ((0,44,213),(0,44,213),SentenceBreak::Lowercase),
  ((0,44,214),(0,44,214),SentenceBreak::Uppercase),
  ((0,44,215),(0,44,215),SentenceBreak::Lowercase),
  ((0,44,216),(0,44,216),SentenceBreak::Uppercase),
  ((0,44,217),(0,44,217),SentenceBreak::Lowercase),
  ((0,44,218),(0,44,218),SentenceBreak::Uppercase),
  ((0,44,219),(0,44,219),SentenceBreak::Lowercase),
  ((0,44,220),(0,44,220),SentenceBreak::Uppercase),
  ((0,44,221),(0,44,221),SentenceBreak::Lowercase),
  ((0,44,222),(0,44,222),SentenceBreak::Uppercase),
  ((0,44,223),(0,44,223),SentenceBreak::Lowercase),
  ((0,44,224),(0,44,224),SentenceBreak::Uppercase),
  ((0,44,225),(0,44,225),SentenceBreak::Lowercase),
  ((0,44,226),(0,44,226),SentenceBreak::Uppercase),
  ((0,44,227),(0,44,228),SentenceBreak::Lowercase),
  ((0,44,235),(0,44,235),SentenceBreak::Uppercase),
  ((0,44,236),(0,44,236),SentenceBreak::Lowercase),
  ((0,44,237),(0,44,237),SentenceBreak::Uppercase),
  ((0,44,238),(0,44,238),SentenceBreak::Lowercase),
  ((0,44,239),(0,44,241),SentenceBreak::Extend),
  ((0,44,242),(0,44,242),SentenceBreak::Uppercase),
  ((0,44,243),(0,44,243),SentenceBreak::Lowercase),
  ((0,45,0),(0,45,37),SentenceBreak::Lowercase),
  ((0,45,39),(0,45,39),SentenceBreak::Lowercase),
  ((0,45,45),(0,45,45),SentenceBreak::Lowercase),
  ((0,45,48),(0,45,103),SentenceBreak::OLetter),
  ((0,45,111),(0,45,111),SentenceBreak::OLetter),
  ((0,45,127),(0,45,127),SentenceBreak::Extend),
  ((0,45,128),(0,45,150),SentenceBreak::OLetter),
  ((0,45,160),(0,45,166),SentenceBreak::OLetter),
  ((0,45,168),(0,45,174),SentenceBreak::OLetter),
  ((0,45,176),(0,45,182),SentenceBreak::OLetter),
  ((0,45,184),(0,45,190),SentenceBreak::OLetter),
  ((0,45,192),(0,45,198),SentenceBreak::OLetter),
  ((0,45,200),(0,45,206),SentenceBreak::OLetter),
  ((0,45,208),(0,45,214),SentenceBreak::OLetter),
  ((0,45,216),(0,45,222),SentenceBreak::OLetter),
  ((0,45,224),(0,45,255),SentenceBreak::Extend),
  ((0,46,0),(0,46,13),SentenceBreak::Close),
  ((0,46,28),(0,46,29),SentenceBreak::Close),
  ((0,46,32),(0,46,41),SentenceBreak::Close),
  ((0,46,46),(0,46,46),SentenceBreak::SentenceTerminal),
  ((0,46,47),(0,46,47),SentenceBreak::OLetter),
  ((0,46,60),(0,46,60),SentenceBreak::SentenceTerminal),
  ((0,46,66),(0,46,66),SentenceBreak::Close),
  ((0,48,0),(0,48,0),SentenceBreak::Space),
  ((0,48,1),(0,48,1),SentenceBreak::SentenceContinue),
  ((0,48,2),(0,48,2),SentenceBreak::SentenceTerminal),
  ((0,48,5),(0,48,7),SentenceBreak::OLetter),
  ((0,48,8),(0,48,17),SentenceBreak::Close),
  ((0,48,20),(0,48,27),SentenceBreak::Close),
  ((0,48,29),(0,48,31),SentenceBreak::Close),
  ((0,48,33),(0,48,41),SentenceBreak::OLetter),
  ((0,48,42),(0,48,47),SentenceBreak::Extend),
  ((0,48,49),(0,48,53),SentenceBreak::OLetter),
  ((0,48,56),(0,48,60),SentenceBreak::OLetter),
  ((0,48,65),(0,48,150),SentenceBreak::OLetter),
  ((0,48,153),(0,48,154),SentenceBreak::Extend),
  ((0,48,157),(0,48,159),SentenceBreak::OLetter),
  ((0,48,161),(0,48,250),SentenceBreak::OLetter),
  ((0,48,252),(0,48,255),SentenceBreak::OLetter),
  ((0,49,5),(0,49,45),SentenceBreak::OLetter),
  ((0,49,49),(0,49,142),SentenceBreak::OLetter),
  ((0,49,160),(0,49,186),SentenceBreak::OLetter),
  ((0,49,240),(0,49,255),SentenceBreak::OLetter),
  ((0,52,0),(0,77,181),SentenceBreak::OLetter),
  ((0,78,0),(0,159,213),SentenceBreak::OLetter),
  ((0,160,0),(0,164,140),SentenceBreak::OLetter),
  ((0,164,208),(0,164,253),SentenceBreak::OLetter),
  ((0,164,255),(0,164,255),SentenceBreak::SentenceTerminal),
  ((0,165,0),(0,166,12),SentenceBreak::OLetter),
  ((0,166,14),(0,166,15),SentenceBreak::SentenceTerminal),
  ((0,166,16),(0,166,31),SentenceBreak::OLetter),
  ((0,166,32),(0,166,41),SentenceBreak::Numeric),
  ((0,166,42),(0,166,43),SentenceBreak::OLetter),
  ((0,166,64),(0,166,64),SentenceBreak::Uppercase),
  ((0,166,65),(0,166,65),SentenceBreak::Lowercase),
  ((0,166,66),(0,166,66),SentenceBreak::Uppercase),
  ((0,166,67),(0,166,67),SentenceBreak::Lowercase),
  ((0,166,68),(0,166,68),SentenceBreak::Uppercase),
  ((0,166,69),(0,166,69),SentenceBreak::Lowercase),
  ((0,166,70),(0,166,70),SentenceBreak::Uppercase),
  ((0,166,71),(0,166,71),SentenceBreak::Lowercase),
  ((0,166,72),(0,166,72),SentenceBreak::Uppercase),
  ((0,166,73),(0,166,73),SentenceBreak::Lowercase),
  ((0,166,74),(0,166,74),SentenceBreak::Uppercase),
  ((0,166,75),(0,166,75),SentenceBreak::Lowercase),
  ((0,166,76),(0,166,76),SentenceBreak::Uppercase),
  ((0,166,77),(0,166,77),SentenceBreak::Lowercase),
  ((0,166,78),(0,166,78),SentenceBreak::Uppercase),
  ((0,166,79),(0,166,79),SentenceBreak::Lowercase),
  ((0,166,80),(0,166,80),SentenceBreak::Uppercase),
  ((0,166,81),(0,166,81),SentenceBreak::Lowercase),
  ((0,166,82),(0,166,82),SentenceBreak::Uppercase),
  ((0,166,83),(0,166,83),SentenceBreak::Lowercase),
  ((0,166,84),(0,166,84),SentenceBreak::Uppercase),
  ((0,166,85),(0,166,85),SentenceBreak::Lowercase),
  ((0,166,86),(0,166,86),SentenceBreak::Uppercase),
  ((0,166,87),(0,166,87),SentenceBreak::Lowercase),
  ((0,166,88),(0,166,88),SentenceBreak::Uppercase),
  ((0,166,89),(0,166,89),SentenceBreak::Lowercase),
  ((0,166,90),(0,166,90),SentenceBreak::Uppercase),
  ((0,166,91),(0,166,91),SentenceBreak::Lowercase),
  ((0,166,92),(0,166,92),SentenceBreak::Uppercase),
  ((0,166,93),(0,166,93),SentenceBreak::Lowercase),
  ((0,166,94),(0,166,94),SentenceBreak::Uppercase),
  ((0,166,95),(0,166,95),SentenceBreak::Lowercase),
  ((0,166,96),(0,166,96),SentenceBreak::Uppercase),
  ((0,166,97),(0,166,97),SentenceBreak::Lowercase),
  ((0,166,98),(0,166,98),SentenceBreak::Uppercase),
  ((0,166,99),(0,166,99),SentenceBreak::Lowercase),
  ((0,166,100),(0,166,100),SentenceBreak::Uppercase),
  ((0,166,101),(0,166,101),SentenceBreak::Lowercase),
  ((0,166,102),(0,166,102),SentenceBreak::Uppercase),
  ((0,166,103),(0,166,103),SentenceBreak::Lowercase),
  ((0,166,104),(0,166,104),SentenceBreak::Uppercase),
  ((0,166,105),(0,166,105),SentenceBreak::Lowercase),
  ((0,166,106),(0,166,106),SentenceBreak::Uppercase),
  ((0,166,107),(0,166,107),SentenceBreak::Lowercase),
  ((0,166,108),(0,166,108),SentenceBreak::Uppercase),
  ((0,166,109),(0,166,109),SentenceBreak::Lowercase),
  ((0,166,110),(0,166,110),SentenceBreak::OLetter),
  ((0,166,111),(0,166,114),SentenceBreak::Extend),
  ((0,166,116),(0,166,125),SentenceBreak::Extend),
  ((0,166,127),(0,166,127),SentenceBreak::OLetter),
  ((0,166,128),(0,166,128),SentenceBreak::Uppercase),
  ((0,166,129),(0,166,129),SentenceBreak::Lowercase),
  ((0,166,130),(0,166,130),SentenceBreak::Uppercase),
  ((0,166,131),(0,166,131),SentenceBreak::Lowercase),
  ((0,166,132),(0,166,132),SentenceBreak::Uppercase),
  ((0,166,133),(0,166,133),SentenceBreak::Lowercase),
  ((0,166,134),(0,166,134),SentenceBreak::Uppercase),
  ((0,166,135),(0,166,135),SentenceBreak::Lowercase),
  ((0,166,136),(0,166,136),SentenceBreak::Uppercase),
  ((0,166,137),(0,166,137),SentenceBreak::Lowercase),
  ((0,166,138),(0,166,138),SentenceBreak::Uppercase),
  ((0,166,139),(0,166,139),SentenceBreak::Lowercase),
  ((0,166,140),(0,166,140),SentenceBreak::Uppercase),
  ((0,166,141),(0,166,141),SentenceBreak::Lowercase),
  ((0,166,142),(0,166,142),SentenceBreak::Uppercase),
  ((0,166,143),(0,166,143),SentenceBreak::Lowercase),
  ((0,166,144),(0,166,144),SentenceBreak::Uppercase),
  ((0,166,145),(0,166,145),SentenceBreak::Lowercase),
  ((0,166,146),(0,166,146),SentenceBreak::Uppercase),
  ((0,166,147),(0,166,147),SentenceBreak::Lowercase),
  ((0,166,148),(0,166,148),SentenceBreak::Uppercase),
  ((0,166,149),(0,166,149),SentenceBreak::Lowercase),
  ((0,166,150),(0,166,150),SentenceBreak::Uppercase),
  ((0,166,151),(0,166,151),SentenceBreak::Lowercase),
  ((0,166,152),(0,166,152),SentenceBreak::Uppercase),
  ((0,166,153),(0,166,153),SentenceBreak::Lowercase),
  ((0,166,154),(0,166,154),SentenceBreak::Uppercase),
  ((0,166,155),(0,166,157),SentenceBreak::Lowercase),
  ((0,166,158),(0,166,159),SentenceBreak::Extend),
  ((0,166,160),(0,166,239),SentenceBreak::OLetter),
  ((0,166,240),(0,166,241),SentenceBreak::Extend),
  ((0,166,243),(0,166,243),SentenceBreak::SentenceTerminal),
  ((0,166,247),(0,166,247),SentenceBreak::SentenceTerminal),
  ((0,167,23),(0,167,31),SentenceBreak::OLetter),
  ((0,167,34),(0,167,34),SentenceBreak::Uppercase),
  ((0,167,35),(0,167,35),SentenceBreak::Lowercase),
  ((0,167,36),(0,167,36),SentenceBreak::Uppercase),
  ((0,167,37),(0,167,37),SentenceBreak::Lowercase),
  ((0,167,38),(0,167,38),SentenceBreak::Uppercase),
  ((0,167,39),(0,167,39),SentenceBreak::Lowercase),
  ((0,167,40),(0,167,40),SentenceBreak::Uppercase),
  ((0,167,41),(0,167,41),SentenceBreak::Lowercase),
  ((0,167,42),(0,167,42),SentenceBreak::Uppercase),
  ((0,167,43),(0,167,43),SentenceBreak::Lowercase),
  ((0,167,44),(0,167,44),SentenceBreak::Uppercase),
  ((0,167,45),(0,167,45),SentenceBreak::Lowercase),
  ((0,167,46),(0,167,46),SentenceBreak::Uppercase),
  ((0,167,47),(0,167,49),SentenceBreak::Lowercase),
  ((0,167,50),(0,167,50),SentenceBreak::Uppercase),
  ((0,167,51),(0,167,51),SentenceBreak::Lowercase),
  ((0,167,52),(0,167,52),SentenceBreak::Uppercase),
  ((0,167,53),(0,167,53),SentenceBreak::Lowercase),
  ((0,167,54),(0,167,54),SentenceBreak::Uppercase),
  ((0,167,55),(0,167,55),SentenceBreak::Lowercase),
  ((0,167,56),(0,167,56),SentenceBreak::Uppercase),
  ((0,167,57),(0,167,57),SentenceBreak::Lowercase),
  ((0,167,58),(0,167,58),SentenceBreak::Uppercase),
  ((0,167,59),(0,167,59),SentenceBreak::Lowercase),
  ((0,167,60),(0,167,60),SentenceBreak::Uppercase),
  ((0,167,61),(0,167,61),SentenceBreak::Lowercase),
  ((0,167,62),(0,167,62),SentenceBreak::Uppercase),
  ((0,167,63),(0,167,63),SentenceBreak::Lowercase),
  ((0,167,64),(0,167,64),SentenceBreak::Uppercase),
  ((0,167,65),(0,167,65),SentenceBreak::Lowercase),
  ((0,167,66),(0,167,66),SentenceBreak::Uppercase),
  ((0,167,67),(0,167,67),SentenceBreak::Lowercase),
  ((0,167,68),(0,167,68),SentenceBreak::Uppercase),
  ((0,167,69),(0,167,69),SentenceBreak::Lowercase),
  ((0,167,70),(0,167,70),SentenceBreak::Uppercase),
  ((0,167,71),(0,167,71),SentenceBreak::Lowercase),
  ((0,167,72),(0,167,72),SentenceBreak::Uppercase),
  ((0,167,73),(0,167,73),SentenceBreak::Lowercase),
  ((0,167,74),(0,167,74),SentenceBreak::Uppercase),
  ((0,167,75),(0,167,75),SentenceBreak::Lowercase),
  ((0,167,76),(0,167,76),SentenceBreak::Uppercase),
  ((0,167,77),(0,167,77),SentenceBreak::Lowercase),
  ((0,167,78),(0,167,78),SentenceBreak::Uppercase),
  ((0,167,79),(0,167,79),SentenceBreak::Lowercase),
  ((0,167,80),(0,167,80),SentenceBreak::Uppercase),
  ((0,167,81),(0,167,81),SentenceBreak::Lowercase),
  ((0,167,82),(0,167,82),SentenceBreak::Uppercase),
  ((0,167,83),(0,167,83),SentenceBreak::Lowercase),
  ((0,167,84),(0,167,84),SentenceBreak::Uppercase),
  ((0,167,85),(0,167,85),SentenceBreak::Lowercase),
  ((0,167,86),(0,167,86),SentenceBreak::Uppercase),
  ((0,167,87),(0,167,87),SentenceBreak::Lowercase),
  ((0,167,88),(0,167,88),SentenceBreak::Uppercase),
  ((0,167,89),(0,167,89),SentenceBreak::Lowercase),
  ((0,167,90),(0,167,90),SentenceBreak::Uppercase),
  ((0,167,91),(0,167,91),SentenceBreak::Lowercase),
  ((0,167,92),(0,167,92),SentenceBreak::Uppercase),
  ((0,167,93),(0,167,93),SentenceBreak::Lowercase),
  ((0,167,94),(0,167,94),SentenceBreak::Uppercase),
  ((0,167,95),(0,167,95),SentenceBreak::Lowercase),
  ((0,167,96),(0,167,96),SentenceBreak::Uppercase),
  ((0,167,97),(0,167,97),SentenceBreak::Lowercase),
  ((0,167,98),(0,167,98),SentenceBreak::Uppercase),
  ((0,167,99),(0,167,99),SentenceBreak::Lowercase),
  ((0,167,100),(0,167,100),SentenceBreak::Uppercase),
  ((0,167,101),(0,167,101),SentenceBreak::Lowercase),
  ((0,167,102),(0,167,102),SentenceBreak::Uppercase),
  ((0,167,103),(0,167,103),SentenceBreak::Lowercase),
  ((0,167,104),(0,167,104),SentenceBreak::Uppercase),
  ((0,167,105),(0,167,105),SentenceBreak::Lowercase),
  ((0,167,106),(0,167,106),SentenceBreak::Uppercase),
  ((0,167,107),(0,167,107),SentenceBreak::Lowercase),
  ((0,167,108),(0,167,108),SentenceBreak::Uppercase),
  ((0,167,109),(0,167,109),SentenceBreak::Lowercase),
  ((0,167,110),(0,167,110),SentenceBreak::Uppercase),
  ((0,167,111),(0,167,120),SentenceBreak::Lowercase),
  ((0,167,121),(0,167,121),SentenceBreak::Uppercase),
  ((0,167,122),(0,167,122),SentenceBreak::Lowercase),
  ((0,167,123),(0,167,123),SentenceBreak::Uppercase),
  ((0,167,124),(0,167,124),SentenceBreak::Lowercase),
  ((0,167,125),(0,167,126),SentenceBreak::Uppercase),
  ((0,167,127),(0,167,127),SentenceBreak::Lowercase),
  ((0,167,128),(0,167,128),SentenceBreak::Uppercase),
  ((0,167,129),(0,167,129),SentenceBreak::Lowercase),
  ((0,167,130),(0,167,130),SentenceBreak::Uppercase),
  ((0,167,131),(0,167,131),SentenceBreak::Lowercase),
  ((0,167,132),(0,167,132),SentenceBreak::Uppercase),
  ((0,167,133),(0,167,133),SentenceBreak::Lowercase),
  ((0,167,134),(0,167,134),SentenceBreak::Uppercase),
  ((0,167,135),(0,167,135),SentenceBreak::Lowercase),
  ((0,167,136),(0,167,136),SentenceBreak::OLetter),
  ((0,167,139),(0,167,139),SentenceBreak::Uppercase),
  ((0,167,140),(0,167,140),SentenceBreak::Lowercase),
  ((0,167,141),(0,167,141),SentenceBreak::Uppercase),
  ((0,167,142),(0,167,142),SentenceBreak::Lowercase),
  ((0,167,143),(0,167,143),SentenceBreak::OLetter),
  ((0,167,144),(0,167,144),SentenceBreak::Uppercase),
  ((0,167,145),(0,167,145),SentenceBreak::Lowercase),
  ((0,167,146),(0,167,146),SentenceBreak::Uppercase),
  ((0,167,147),(0,167,149),SentenceBreak::Lowercase),
  ((0,167,150),(0,167,150),SentenceBreak::Uppercase),
  ((0,167,151),(0,167,151),SentenceBreak::Lowercase),
  ((0,167,152),(0,167,152),SentenceBreak::Uppercase),
  ((0,167,153),(0,167,153),SentenceBreak::Lowercase),
  ((0,167,154),(0,167,154),SentenceBreak::Uppercase),
  ((0,167,155),(0,167,155),SentenceBreak::Lowercase),
  ((0,167,156),(0,167,156),SentenceBreak::Uppercase),
  ((0,167,157),(0,167,157),SentenceBreak::Lowercase),
  ((0,167,158),(0,167,158),SentenceBreak::Uppercase),
  ((0,167,159),(0,167,159),SentenceBreak::Lowercase),
  ((0,167,160),(0,167,160),SentenceBreak::Uppercase),
  ((0,167,161),(0,167,161),SentenceBreak::Lowercase),
  ((0,167,162),(0,167,162),SentenceBreak::Uppercase),
  ((0,167,163),(0,167,163),SentenceBreak::Lowercase),
  ((0,167,164),(0,167,164),SentenceBreak::Uppercase),
  ((0,167,165),(0,167,165),SentenceBreak::Lowercase),
  ((0,167,166),(0,167,166),SentenceBreak::Uppercase),
  ((0,167,167),(0,167,167),SentenceBreak::Lowercase),
  ((0,167,168),(0,167,168),SentenceBreak::Uppercase),
  ((0,167,169),(0,167,169),SentenceBreak::Lowercase),
  ((0,167,170),(0,167,174),SentenceBreak::Uppercase),
  ((0,167,176),(0,167,180),SentenceBreak::Uppercase),
  ((0,167,181),(0,167,181),SentenceBreak::Lowercase),
  ((0,167,182),(0,167,182),SentenceBreak::Uppercase),
  ((0,167,183),(0,167,183),SentenceBreak::Lowercase),
  ((0,167,247),(0,167,247),SentenceBreak::OLetter),
  ((0,167,248),(0,167,250),SentenceBreak::Lowercase),
  ((0,167,251),(0,168,1),SentenceBreak::OLetter),
  ((0,168,2),(0,168,2),SentenceBreak::Extend),
  ((0,168,3),(0,168,5),SentenceBreak::OLetter),
  ((0,168,6),(0,168,6),SentenceBreak::Extend),
  ((0,168,7),(0,168,10),SentenceBreak::OLetter),
  ((0,168,11),(0,168,11),SentenceBreak::Extend),
  ((0,168,12),(0,168,34),SentenceBreak::OLetter),
  ((0,168,35),(0,168,39),SentenceBreak::Extend),
  ((0,168,64),(0,168,115),SentenceBreak::OLetter),
  ((0,168,118),(0,168,119),SentenceBreak::SentenceTerminal),
  ((0,168,128),(0,168,129),SentenceBreak::Extend),
  ((0,168,130),(0,168,179),SentenceBreak::OLetter),
  ((0,168,180),(0,168,197),SentenceBreak::Extend),
  ((0,168,206),(0,168,207),SentenceBreak::SentenceTerminal),
  ((0,168,208),(0,168,217),SentenceBreak::Numeric),
  ((0,168,224),(0,168,241),SentenceBreak::Extend),
  ((0,168,242),(0,168,247),SentenceBreak::OLetter),
  ((0,168,251),(0,168,251),SentenceBreak::OLetter),
  ((0,168,253),(0,168,253),SentenceBreak::OLetter),
  ((0,169,0),(0,169,9),SentenceBreak::Numeric),
  ((0,169,10),(0,169,37),SentenceBreak::OLetter),
  ((0,169,38),(0,169,45),SentenceBreak::Extend),
  ((0,169,47),(0,169,47),SentenceBreak::SentenceTerminal),
  ((0,169,48),(0,169,70),SentenceBreak::OLetter),
  ((0,169,71),(0,169,83),SentenceBreak::Extend),
  ((0,169,96),(0,169,124),SentenceBreak::OLetter),
  ((0,169,128),(0,169,131),SentenceBreak::Extend),
  ((0,169,132),(0,169,178),SentenceBreak::OLetter),
  ((0,169,179),(0,169,192),SentenceBreak::Extend),
  ((0,169,200),(0,169,201),SentenceBreak::SentenceTerminal),
  ((0,169,207),(0,169,207),SentenceBreak::OLetter),
  ((0,169,208),(0,169,217),SentenceBreak::Numeric),
  ((0,169,224),(0,169,228),SentenceBreak::OLetter),
  ((0,169,229),(0,169,229),SentenceBreak::Extend),
  ((0,169,230),(0,169,239),SentenceBreak::OLetter),
  ((0,169,240),(0,169,249),SentenceBreak::Numeric),
  ((0,169,250),(0,169,254),SentenceBreak::OLetter),
  ((0,170,0),(0,170,40),SentenceBreak::OLetter),
  ((0,170,41),(0,170,54),SentenceBreak::Extend),
  ((0,170,64),(0,170,66),SentenceBreak::OLetter),
  ((0,170,67),(0,170,67),SentenceBreak::Extend),
  ((0,170,68),(0,170,75),SentenceBreak::OLetter),
  ((0,170,76),(0,170,77),SentenceBreak::Extend),
  ((0,170,80),(0,170,89),SentenceBreak::Numeric),
  ((0,170,93),(0,170,95),SentenceBreak::SentenceTerminal),
  ((0,170,96),(0,170,118),SentenceBreak::OLetter),
  ((0,170,122),(0,170,122),SentenceBreak::OLetter),
  ((0,170,123),(0,170,125),SentenceBreak::Extend),
  ((0,170,126),(0,170,175),SentenceBreak::OLetter),
  ((0,170,176),(0,170,176),SentenceBreak::Extend),
  ((0,170,177),(0,170,177),SentenceBreak::OLetter),
  ((0,170,178),(0,170,180),SentenceBreak::Extend),
  ((0,170,181),(0,170,182),SentenceBreak::OLetter),
  ((0,170,183),(0,170,184),SentenceBreak::Extend),
  ((0,170,185),(0,170,189),SentenceBreak::OLetter),
  ((0,170,190),(0,170,191),SentenceBreak::Extend),
  ((0,170,192),(0,170,192),SentenceBreak::OLetter),
  ((0,170,193),(0,170,193),SentenceBreak::Extend),
  ((0,170,194),(0,170,194),SentenceBreak::OLetter),
  ((0,170,219),(0,170,221),SentenceBreak::OLetter),
  ((0,170,224),(0,170,234),SentenceBreak::OLetter),
  ((0,170,235),(0,170,239),SentenceBreak::Extend),
  ((0,170,240),(0,170,241),SentenceBreak::SentenceTerminal),
  ((0,170,242),(0,170,244),SentenceBreak::OLetter),
  ((0,170,245),(0,170,246),SentenceBreak::Extend),
  ((0,171,1),(0,171,6),SentenceBreak::OLetter),
  ((0,171,9),(0,171,14),SentenceBreak::OLetter),
  ((0,171,17),(0,171,22),SentenceBreak::OLetter),
  ((0,171,32),(0,171,38),SentenceBreak::OLetter),
  ((0,171,40),(0,171,46),SentenceBreak::OLetter),
  ((0,171,48),(0,171,90),SentenceBreak::Lowercase),
  ((0,171,92),(0,171,101),SentenceBreak::Lowercase),
  ((0,171,112),(0,171,191),SentenceBreak::Lowercase),
  ((0,171,192),(0,171,226),SentenceBreak::OLetter),
  ((0,171,227),(0,171,234),SentenceBreak::Extend),
  ((0,171,235),(0,171,235),SentenceBreak::SentenceTerminal),
  ((0,171,236),(0,171,237),SentenceBreak::Extend),
  ((0,171,240),(0,171,249),SentenceBreak::Numeric),
  ((0,172,0),(0,215,163),SentenceBreak::OLetter),
  ((0,215,176),(0,215,198),SentenceBreak::OLetter),
  ((0,215,203),(0,215,251),SentenceBreak::OLetter),
  ((0,249,0),(0,250,109),SentenceBreak::OLetter),
  ((0,250,112),(0,250,217),SentenceBreak::OLetter),
  ((0,251,0),(0,251,6),SentenceBreak::Lowercase),
  ((0,251,19),(0,251,23),SentenceBreak::Lowercase),
  ((0,251,29),(0,251,29),SentenceBreak::OLetter),
  ((0,251,30),(0,251,30),SentenceBreak::Extend),
  ((0,251,31),(0,251,40),SentenceBreak::OLetter),
  ((0,251,42),(0,251,54),SentenceBreak::OLetter),
  ((0,251,56),(0,251,60),SentenceBreak::OLetter),
  ((0,251,62),(0,251,62),SentenceBreak::OLetter),
  ((0,251,64),(0,251,65),SentenceBreak::OLetter),
  ((0,251,67),(0,251,68),SentenceBreak::OLetter),
  ((0,251,70),(0,251,177),SentenceBreak::OLetter),
  ((0,251,211),(0,253,61),SentenceBreak::OLetter),
  ((0,253,62),(0,253,63),SentenceBreak::Close),
  ((0,253,80),(0,253,143),SentenceBreak::OLetter),
  ((0,253,146),(0,253,199),SentenceBreak::OLetter),
  ((0,253,240),(0,253,251),SentenceBreak::OLetter),
  ((0,254,0),(0,254,15),SentenceBreak::Extend),
  ((0,254,16),(0,254,17),SentenceBreak::SentenceContinue),
  ((0,254,19),(0,254,19),SentenceBreak::SentenceContinue),
  ((0,254,23),(0,254,24),SentenceBreak::Close),
  ((0,254,32),(0,254,47),SentenceBreak::Extend),
  ((0,254,49),(0,254,50),SentenceBreak::SentenceContinue),
  ((0,254,53),(0,254,68),SentenceBreak::Close),
  ((0,254,71),(0,254,72),SentenceBreak::Close),
  ((0,254,80),(0,254,81),SentenceBreak::SentenceContinue),
  ((0,254,82),(0,254,82),SentenceBreak::ATerm),
  ((0,254,85),(0,254,85),SentenceBreak::SentenceContinue),
  ((0,254,86),(0,254,87),SentenceBreak::SentenceTerminal),
  ((0,254,88),(0,254,88),SentenceBreak::SentenceContinue),
  ((0,254,89),(0,254,94),SentenceBreak::Close),
  ((0,254,99),(0,254,99),SentenceBreak::SentenceContinue),
  ((0,254,112),(0,254,116),SentenceBreak::OLetter),
  ((0,254,118),(0,254,252),SentenceBreak::OLetter),
  ((0,254,255),(0,254,255),SentenceBreak::Format),
  ((0,255,1),(0,255,1),SentenceBreak::SentenceTerminal),
  ((0,255,8),(0,255,9),SentenceBreak::Close),
  ((0,255,12),(0,255,13),SentenceBreak::SentenceContinue),
  ((0,255,14),(0,255,14),SentenceBreak::ATerm),
  ((0,255,26),(0,255,26),SentenceBreak::SentenceContinue),
  ((0,255,31),(0,255,31),SentenceBreak::SentenceTerminal),
  ((0,255,33),(0,255,58),SentenceBreak::Uppercase),
  ((0,255,59),(0,255,59),SentenceBreak::Close),
  ((0,255,61),(0,255,61),SentenceBreak::Close),
  ((0,255,65),(0,255,90),SentenceBreak::Lowercase),
  ((0,255,91),(0,255,91),SentenceBreak::Close),
  ((0,255,93),(0,255,93),SentenceBreak::Close),
  ((0,255,95),(0,255,96),SentenceBreak::Close),
  ((0,255,97),(0,255,97),SentenceBreak::SentenceTerminal),
  ((0,255,98),(0,255,99),SentenceBreak::Close),
  ((0,255,100),(0,255,100),SentenceBreak::SentenceContinue),
  ((0,255,102),(0,255,157),SentenceBreak::OLetter),
  ((0,255,158),(0,255,159),SentenceBreak::Extend),
  ((0,255,160),(0,255,190),SentenceBreak::OLetter),
  ((0,255,194),(0,255,199),SentenceBreak::OLetter),
  ((0,255,202),(0,255,207),SentenceBreak::OLetter),
  ((0,255,210),(0,255,215),SentenceBreak::OLetter),
  ((0,255,218),(0,255,220),SentenceBreak::OLetter),
  ((0,255,249),(0,255,251),SentenceBreak::Format),
  ((1,0,0),(1,0,11),SentenceBreak::OLetter),
  ((1,0,13),(1,0,38),SentenceBreak::OLetter),
  ((1,0,40),(1,0,58),SentenceBreak::OLetter),
  ((1,0,60),(1,0,61),SentenceBreak::OLetter),
  ((1,0,63),(1,0,77),SentenceBreak::OLetter),
  ((1,0,80),(1,0,93),SentenceBreak::OLetter),
  ((1,0,128),(1,0,250),SentenceBreak::OLetter),
  ((1,1,64),(1,1,116),SentenceBreak::OLetter),
  ((1,1,253),(1,1,253),SentenceBreak::Extend),
  ((1,2,128),(1,2,156),SentenceBreak::OLetter),
  ((1,2,160),(1,2,208),SentenceBreak::OLetter),
  ((1,2,224),(1,2,224),SentenceBreak::Extend),
  ((1,3,0),(1,3,31),SentenceBreak::OLetter),
  ((1,3,48),(1,3,74),SentenceBreak::OLetter),
  ((1,3,80),(1,3,117),SentenceBreak::OLetter),
  ((1,3,118),(1,3,122),SentenceBreak::Extend),
  ((1,3,128),(1,3,157),SentenceBreak::OLetter),
  ((1,3,160),(1,3,195),SentenceBreak::OLetter),
  ((1,3,200),(1,3,207),SentenceBreak::OLetter),
  ((1,3,209),(1,3,213),SentenceBreak::OLetter),
  ((1,4,0),(1,4,39),SentenceBreak::Uppercase),
  ((1,4,40),(1,4,79),SentenceBreak::Lowercase),
  ((1,4,80),(1,4,157),SentenceBreak::OLetter),
  ((1,4,160),(1,4,169),SentenceBreak::Numeric),
  ((1,4,176),(1,4,211),SentenceBreak::Uppercase),
  ((1,4,216),(1,4,251),SentenceBreak::Lowercase),
  ((1,5,0),(1,5,39),SentenceBreak::OLetter),
  ((1,5,48),(1,5,99),SentenceBreak::OLetter),
  ((1,6,0),(1,7,54),SentenceBreak::OLetter),
  ((1,7,64),(1,7,85),SentenceBreak::OLetter),
  ((1,7,96),(1,7,103),SentenceBreak::OLetter),
  ((1,8,0),(1,8,5),SentenceBreak::OLetter),
  ((1,8,8),(1,8,8),SentenceBreak::OLetter),
  ((1,8,10),(1,8,53),SentenceBreak::OLetter),
  ((1,8,55),(1,8,56),SentenceBreak::OLetter),
  ((1,8,60),(1,8,60),SentenceBreak::OLetter),
  ((1,8,63),(1,8,85),SentenceBreak::OLetter),
  ((1,8,96),(1,8,118),SentenceBreak::OLetter),
  ((1,8,128),(1,8,158),SentenceBreak::OLetter),
  ((1,8,224),(1,8,242),SentenceBreak::OLetter),
  ((1,8,244),(1,8,245),SentenceBreak::OLetter),
  ((1,9,0),(1,9,21),SentenceBreak::OLetter),
  ((1,9,32),(1,9,57),SentenceBreak::OLetter),
  ((1,9,128),(1,9,183),SentenceBreak::OLetter),
  ((1,9,190),(1,9,191),SentenceBreak::OLetter),
  ((1,10,0),(1,10,0),SentenceBreak::OLetter),
  ((1,10,1),(1,10,3),SentenceBreak::Extend),
  ((1,10,5),(1,10,6),SentenceBreak::Extend),
  ((1,10,12),(1,10,15),SentenceBreak::Extend),
  ((1,10,16),(1,10,19),SentenceBreak::OLetter),
  ((1,10,21),(1,10,23),SentenceBreak::OLetter),
  ((1,10,25),(1,10,51),SentenceBreak::OLetter),
  ((1,10,56),(1,10,58),SentenceBreak::Extend),
  ((1,10,63),(1,10,63),SentenceBreak::Extend),
  ((1,10,86),(1,10,87),SentenceBreak::SentenceTerminal),
  ((1,10,96),(1,10,124),SentenceBreak::OLetter),
  ((1,10,128),(1,10,156),SentenceBreak::OLetter),
  ((1,10,192),(1,10,199),SentenceBreak::OLetter),
  ((1,10,201),(1,10,228),SentenceBreak::OLetter),
  ((1,10,229),(1,10,230),SentenceBreak::Extend),
  ((1,11,0),(1,11,53),SentenceBreak::OLetter),
  ((1,11,64),(1,11,85),SentenceBreak::OLetter),
  ((1,11,96),(1,11,114),SentenceBreak::OLetter),
  ((1,11,128),(1,11,145),SentenceBreak::OLetter),
  ((1,12,0),(1,12,72),SentenceBreak::OLetter),
  ((1,12,128),(1,12,178),SentenceBreak::Uppercase),
  ((1,12,192),(1,12,242),SentenceBreak::Lowercase),
  ((1,16,0),(1,16,2),SentenceBreak::Extend),
  ((1,16,3),(1,16,55),SentenceBreak::OLetter),
  ((1,16,56),(1,16,70),SentenceBreak::Extend),
  ((1,16,71),(1,16,72),SentenceBreak::SentenceTerminal),
  ((1,16,102),(1,16,111),SentenceBreak::Numeric),
  ((1,16,127),(1,16,130),SentenceBreak::Extend),
  ((1,16,131),(1,16,175),SentenceBreak::OLetter),
  ((1,16,176),(1,16,186),SentenceBreak::Extend),
  ((1,16,189),(1,16,189),SentenceBreak::Format),
  ((1,16,190),(1,16,193),SentenceBreak::SentenceTerminal),
  ((1,16,208),(1,16,232),SentenceBreak::OLetter),
  ((1,16,240),(1,16,249),SentenceBreak::Numeric),
  ((1,17,0),(1,17,2),SentenceBreak::Extend),
  ((1,17,3),(1,17,38),SentenceBreak::OLetter),
  ((1,17,39),(1,17,52),SentenceBreak::Extend),
  ((1,17,54),(1,17,63),SentenceBreak::Numeric),
  ((1,17,65),(1,17,67),SentenceBreak::SentenceTerminal),
  ((1,17,80),(1,17,114),SentenceBreak::OLetter),
  ((1,17,115),(1,17,115),SentenceBreak::Extend),
  ((1,17,118),(1,17,118),SentenceBreak::OLetter),
  ((1,17,128),(1,17,130),SentenceBreak::Extend),
  ((1,17,131),(1,17,178),SentenceBreak::OLetter),
  ((1,17,179),(1,17,192),SentenceBreak::Extend),
  ((1,17,193),(1,17,196),SentenceBreak::OLetter),
  ((1,17,197),(1,17,198),SentenceBreak::SentenceTerminal),
  ((1,17,202),(1,17,204),SentenceBreak::Extend),
  ((1,17,205),(1,17,205),SentenceBreak::SentenceTerminal),
  ((1,17,208),(1,17,217),SentenceBreak::Numeric),
  ((1,17,218),(1,17,218),SentenceBreak::OLetter),
  ((1,17,220),(1,17,220),SentenceBreak::OLetter),
  ((1,17,222),(1,17,223),SentenceBreak::SentenceTerminal),
  ((1,18,0),(1,18,17),SentenceBreak::OLetter),
  ((1,18,19),(1,18,43),SentenceBreak::OLetter),
  ((1,18,44),(1,18,55),SentenceBreak::Extend),
  ((1,18,56),(1,18,57),SentenceBreak::SentenceTerminal),
  ((1,18,59),(1,18,60),SentenceBreak::SentenceTerminal),
  ((1,18,62),(1,18,62),SentenceBreak::Extend),
  ((1,18,128),(1,18,134),SentenceBreak::OLetter),
  ((1,18,136),(1,18,136),SentenceBreak::OLetter),
  ((1,18,138),(1,18,141),SentenceBreak::OLetter),
  ((1,18,143),(1,18,157),SentenceBreak::OLetter),
  ((1,18,159),(1,18,168),SentenceBreak::OLetter),
  ((1,18,169),(1,18,169),SentenceBreak::SentenceTerminal),
  ((1,18,176),(1,18,222),SentenceBreak::OLetter),
  ((1,18,223),(1,18,234),SentenceBreak::Extend),
  ((1,18,240),(1,18,249),SentenceBreak::Numeric),
  ((1,19,0),(1,19,3),SentenceBreak::Extend),
  ((1,19,5),(1,19,12),SentenceBreak::OLetter),
  ((1,19,15),(1,19,16),SentenceBreak::OLetter),
  ((1,19,19),(1,19,40),SentenceBreak::OLetter),
  ((1,19,42),(1,19,48),SentenceBreak::OLetter),
  ((1,19,50),(1,19,51),SentenceBreak::OLetter),
  ((1,19,53),(1,19,57),SentenceBreak::OLetter),
  ((1,19,60),(1,19,60),SentenceBreak::Extend),
  ((1,19,61),(1,19,61),SentenceBreak::OLetter),
  ((1,19,62),(1,19,68),SentenceBreak::Extend),
  ((1,19,71),(1,19,72),SentenceBreak::Extend),
  ((1,19,75),(1,19,77),SentenceBreak::Extend),
  ((1,19,80),(1,19,80),SentenceBreak::OLetter),
  ((1,19,87),(1,19,87),SentenceBreak::Extend),
  ((1,19,93),(1,19,97),SentenceBreak::OLetter),
  ((1,19,98),(1,19,99),SentenceBreak::Extend),
  ((1,19,102),(1,19,108),SentenceBreak::Extend),
  ((1,19,112),(1,19,116),SentenceBreak::Extend),
  ((1,20,0),(1,20,52),SentenceBreak::OLetter),
  ((1,20,53),(1,20,70),SentenceBreak::Extend),
  ((1,20,71),(1,20,74),SentenceBreak::OLetter),
  ((1,20,75),(1,20,76),SentenceBreak::SentenceTerminal),
  ((1,20,80),(1,20,89),SentenceBreak::Numeric),
  ((1,20,128),(1,20,175),SentenceBreak::OLetter),
  ((1,20,176),(1,20,195),SentenceBreak::Extend),
  ((1,20,196),(1,20,197),SentenceBreak::OLetter),
  ((1,20,199),(1,20,199),SentenceBreak::OLetter),
  ((1,20,208),(1,20,217),SentenceBreak::Numeric),
  ((1,21,128),(1,21,174),SentenceBreak::OLetter),
  ((1,21,175),(1,21,181),SentenceBreak::Extend),
  ((1,21,184),(1,21,192),SentenceBreak::Extend),
  ((1,21,194),(1,21,195),SentenceBreak::SentenceTerminal),
  ((1,21,201),(1,21,215),SentenceBreak::SentenceTerminal),
  ((1,21,216),(1,21,219),SentenceBreak::OLetter),
  ((1,21,220),(1,21,221),SentenceBreak::Extend),
  ((1,22,0),(1,22,47),SentenceBreak::OLetter),
  ((1,22,48),(1,22,64),SentenceBreak::Extend),
  ((1,22,65),(1,22,66),SentenceBreak::SentenceTerminal),
  ((1,22,68),(1,22,68),SentenceBreak::OLetter),
  ((1,22,80),(1,22,89),SentenceBreak::Numeric),
  ((1,22,128),(1,22,170),SentenceBreak::OLetter),
  ((1,22,171),(1,22,183),SentenceBreak::Extend),
  ((1,22,192),(1,22,201),SentenceBreak::Numeric),
  ((1,23,0),(1,23,25),SentenceBreak::OLetter),
  ((1,23,29),(1,23,43),SentenceBreak::Extend),
  ((1,23,48),(1,23,57),SentenceBreak::Numeric),
  ((1,23,60),(1,23,62),SentenceBreak::SentenceTerminal),
  ((1,24,160),(1,24,191),SentenceBreak::Uppercase),
  ((1,24,192),(1,24,223),SentenceBreak::Lowercase),
  ((1,24,224),(1,24,233),SentenceBreak::Numeric),
  ((1,24,255),(1,24,255),SentenceBreak::OLetter),
  ((1,26,192),(1,26,248),SentenceBreak::OLetter),
  ((1,28,0),(1,28,8),SentenceBreak::OLetter),
  ((1,28,10),(1,28,46),SentenceBreak::OLetter),
  ((1,28,47),(1,28,54),SentenceBreak::Extend),
  ((1,28,56),(1,28,63),SentenceBreak::Extend),
  ((1,28,64),(1,28,64),SentenceBreak::OLetter),
  ((1,28,65),(1,28,66),SentenceBreak::SentenceTerminal),
  ((1,28,80),(1,28,89),SentenceBreak::Numeric),
  ((1,28,114),(1,28,143),SentenceBreak::OLetter),
  ((1,28,146),(1,28,167),SentenceBreak::Extend),
  ((1,28,169),(1,28,182),SentenceBreak::Extend),
  ((1,32,0),(1,35,153),SentenceBreak::OLetter),
  ((1,36,0),(1,36,110),SentenceBreak::OLetter),
  ((1,36,128),(1,37,67),SentenceBreak::OLetter),
  ((1,48,0),(1,52,46),SentenceBreak::OLetter),
  ((1,68,0),(1,70,70),SentenceBreak::OLetter),
  ((1,104,0),(1,106,56),SentenceBreak::OLetter),
  ((1,106,64),(1,106,94),SentenceBreak::OLetter),
  ((1,106,96),(1,106,105),SentenceBreak::Numeric),
  ((1,106,110),(1,106,111),SentenceBreak::SentenceTerminal),
  ((1,106,208),(1,106,237),SentenceBreak::OLetter),
  ((1,106,240),(1,106,244),SentenceBreak::Extend),
  ((1,106,245),(1,106,245),SentenceBreak::SentenceTerminal),
  ((1,107,0),(1,107,47),SentenceBreak::OLetter),
  ((1,107,48),(1,107,54),SentenceBreak::Extend),
  ((1,107,55),(1,107,56),SentenceBreak::SentenceTerminal),
  ((1,107,64),(1,107,67),SentenceBreak::OLetter),
  ((1,107,68),(1,107,68),SentenceBreak::SentenceTerminal),
  ((1,107,80),(1,107,89),SentenceBreak::Numeric),
  ((1,107,99),(1,107,119),SentenceBreak::OLetter),
  ((1,107,125),(1,107,143),SentenceBreak::OLetter),
  ((1,111,0),(1,111,68),SentenceBreak::OLetter),
  ((1,111,80),(1,111,80),SentenceBreak::OLetter),
  ((1,111,81),(1,111,126),SentenceBreak::Extend),
  ((1,111,143),(1,111,146),SentenceBreak::Extend),
  ((1,111,147),(1,111,159),SentenceBreak::OLetter),
  ((1,111,224),(1,111,224),SentenceBreak::OLetter),
  ((1,112,0),(1,135,236),SentenceBreak::OLetter),
  ((1,136,0),(1,138,242),SentenceBreak::OLetter),
  ((1,176,0),(1,176,1),SentenceBreak::OLetter),
  ((1,188,0),(1,188,106),SentenceBreak::OLetter),
  ((1,188,112),(1,188,124),SentenceBreak::OLetter),
  ((1,188,128),(1,188,136),SentenceBreak::OLetter),
  ((1,188,144),(1,188,153),SentenceBreak::OLetter),
  ((1,188,157),(1,188,158),SentenceBreak::Extend),
  ((1,188,159),(1,188,159),SentenceBreak::SentenceTerminal),
  ((1,188,160),(1,188,163),SentenceBreak::Format),
  ((1,209,101),(1,209,105),SentenceBreak::Extend),
  ((1,209,109),(1,209,114),SentenceBreak::Extend),
  ((1,209,115),(1,209,122),SentenceBreak::Format),
  ((1,209,123),(1,209,130),SentenceBreak::Extend),
  ((1,209,133),(1,209,139),SentenceBreak::Extend),
  ((1,209,170),(1,209,173),SentenceBreak::Extend),
  ((1,210,66),(1,210,68),SentenceBreak::Extend),
  ((1,212,0),(1,212,25),SentenceBreak::Uppercase),
  ((1,212,26),(1,212,51),SentenceBreak::Lowercase),
  ((1,212,52),(1,212,77),SentenceBreak::Uppercase),
  ((1,212,78),(1,212,84),SentenceBreak::Lowercase),
  ((1,212,86),(1,212,103),SentenceBreak::Lowercase),
  ((1,212,104),(1,212,129),SentenceBreak::Uppercase),
  ((1,212,130),(1,212,155),SentenceBreak::Lowercase),
  ((1,212,156),(1,212,156),SentenceBreak::Uppercase),
  ((1,212,158),(1,212,159),SentenceBreak::Uppercase),
  ((1,212,162),(1,212,162),SentenceBreak::Uppercase),
  ((1,212,165),(1,212,166),SentenceBreak::Uppercase),
  ((1,212,169),(1,212,172),SentenceBreak::Uppercase),
  ((1,212,174),(1,212,181),SentenceBreak::Uppercase),
  ((1,212,182),(1,212,185),SentenceBreak::Lowercase),
  ((1,212,187),(1,212,187),SentenceBreak::Lowercase),
  ((1,212,189),(1,212,195),SentenceBreak::Lowercase),
  ((1,212,197),(1,212,207),SentenceBreak::Lowercase),
  ((1,212,208),(1,212,233),SentenceBreak::Uppercase),
  ((1,212,234),(1,213,3),SentenceBreak::Lowercase),
  ((1,213,4),(1,213,5),SentenceBreak::Uppercase),
  ((1,213,7),(1,213,10),SentenceBreak::Uppercase),
  ((1,213,13),(1,213,20),SentenceBreak::Uppercase),
  ((1,213,22),(1,213,28),SentenceBreak::Uppercase),
  ((1,213,30),(1,213,55),SentenceBreak::Lowercase),
  ((1,213,56),(1,213,57),SentenceBreak::Uppercase),
  ((1,213,59),(1,213,62),SentenceBreak::Uppercase),
  ((1,213,64),(1,213,68),SentenceBreak::Uppercase),
  ((1,213,70),(1,213,70),SentenceBreak::Uppercase),
  ((1,213,74),(1,213,80),SentenceBreak::Uppercase),
  ((1,213,82),(1,213,107),SentenceBreak::Lowercase),
  ((1,213,108),(1,213,133),SentenceBreak::Uppercase),
  ((1,213,134),(1,213,159),SentenceBreak::Lowercase),
  ((1,213,160),(1,213,185),SentenceBreak::Uppercase),
  ((1,213,186),(1,213,211),SentenceBreak::Lowercase),
  ((1,213,212),(1,213,237),SentenceBreak::Uppercase),
  ((1,213,238),(1,214,7),SentenceBreak::Lowercase),
  ((1,214,8),(1,214,33),SentenceBreak::Uppercase),
  ((1,214,34),(1,214,59),SentenceBreak::Lowercase),
  ((1,214,60),(1,214,85),SentenceBreak::Uppercase),
  ((1,214,86),(1,214,111),SentenceBreak::Lowercase),
  ((1,214,112),(1,214,137),SentenceBreak::Uppercase),
  ((1,214,138),(1,214,165),SentenceBreak::Lowercase),
  ((1,214,168),(1,214,192),SentenceBreak::Uppercase),
  ((1,214,194),(1,214,218),SentenceBreak::Lowercase),
  ((1,214,220),(1,214,225),SentenceBreak::Lowercase),
  ((1,214,226),(1,214,250),SentenceBreak::Uppercase),
  ((1,214,252),(1,215,20),SentenceBreak::Lowercase),
  ((1,215,22),(1,215,27),SentenceBreak::Lowercase),
  ((1,215,28),(1,215,52),SentenceBreak::Uppercase),
  ((1,215,54),(1,215,78),SentenceBreak::Lowercase),
  ((1,215,80),(1,215,85),SentenceBreak::Lowercase),
  ((1,215,86),(1,215,110),SentenceBreak::Uppercase),
  ((1,215,112),(1,215,136),SentenceBreak::Lowercase),
  ((1,215,138),(1,215,143),SentenceBreak::Lowercase),
  ((1,215,144),(1,215,168),SentenceBreak::Uppercase),
  ((1,215,170),(1,215,194),SentenceBreak::Lowercase),
  ((1,215,196),(1,215,201),SentenceBreak::Lowercase),
  ((1,215,202),(1,215,202),SentenceBreak::Uppercase),
  ((1,215,203),(1,215,203),SentenceBreak::Lowercase),
  ((1,215,206),(1,215,255),SentenceBreak::Numeric),
  ((1,218,0),(1,218,54),SentenceBreak::Extend),
  ((1,218,59),(1,218,108),SentenceBreak::Extend),
  ((1,218,117),(1,218,117),SentenceBreak::Extend),
  ((1,218,132),(1,218,132),SentenceBreak::Extend),
  ((1,218,136),(1,218,136),SentenceBreak::SentenceTerminal),
  ((1,218,155),(1,218,159),SentenceBreak::Extend),
  ((1,218,161),(1,218,175),SentenceBreak::Extend),
  ((1,224,0),(1,224,6),SentenceBreak::Extend),
  ((1,224,8),(1,224,24),SentenceBreak::Extend),
  ((1,224,27),(1,224,33),SentenceBreak::Extend),
  ((1,224,35),(1,224,36),SentenceBreak::Extend),
  ((1,224,38),(1,224,42),SentenceBreak::Extend),
  ((1,232,0),(1,232,196),SentenceBreak::OLetter),
  ((1,232,208),(1,232,214),SentenceBreak::Extend),
  ((1,233,0),(1,233,33),SentenceBreak::Uppercase),
  ((1,233,34),(1,233,67),SentenceBreak::Lowercase),
  ((1,233,68),(1,233,74),SentenceBreak::Extend),
  ((1,233,80),(1,233,89),SentenceBreak::Numeric),
  ((1,238,0),(1,238,3),SentenceBreak::OLetter),
  ((1,238,5),(1,238,31),SentenceBreak::OLetter),
  ((1,238,33),(1,238,34),SentenceBreak::OLetter),
  ((1,238,36),(1,238,36),SentenceBreak::OLetter),
  ((1,238,39),(1,238,39),SentenceBreak::OLetter),
  ((1,238,41),(1,238,50),SentenceBreak::OLetter),
  ((1,238,52),(1,238,55),SentenceBreak::OLetter),
  ((1,238,57),(1,238,57),SentenceBreak::OLetter),
  ((1,238,59),(1,238,59),SentenceBreak::OLetter),
  ((1,238,66),(1,238,66),SentenceBreak::OLetter),
  ((1,238,71),(1,238,71),SentenceBreak::OLetter),
  ((1,238,73),(1,238,73),SentenceBreak::OLetter),
  ((1,238,75),(1,238,75),SentenceBreak::OLetter),
  ((1,238,77),(1,238,79),SentenceBreak::OLetter),
  ((1,238,81),(1,238,82),SentenceBreak::OLetter),
  ((1,238,84),(1,238,84),SentenceBreak::OLetter),
  ((1,238,87),(1,238,87),SentenceBreak::OLetter),
  ((1,238,89),(1,238,89),SentenceBreak::OLetter),
  ((1,238,91),(1,238,91),SentenceBreak::OLetter),
  ((1,238,93),(1,238,93),SentenceBreak::OLetter),
  ((1,238,95),(1,238,95),SentenceBreak::OLetter),
  ((1,238,97),(1,238,98),SentenceBreak::OLetter),
  ((1,238,100),(1,238,100),SentenceBreak::OLetter),
  ((1,238,103),(1,238,106),SentenceBreak::OLetter),
  ((1,238,108),(1,238,114),SentenceBreak::OLetter),
  ((1,238,116),(1,238,119),SentenceBreak::OLetter),
  ((1,238,121),(1,238,124),SentenceBreak::OLetter),
  ((1,238,126),(1,238,126),SentenceBreak::OLetter),
  ((1,238,128),(1,238,137),SentenceBreak::OLetter),
  ((1,238,139),(1,238,155),SentenceBreak::OLetter),
  ((1,238,161),(1,238,163),SentenceBreak::OLetter),
  ((1,238,165),(1,238,169),SentenceBreak::OLetter),
  ((1,238,171),(1,238,187),SentenceBreak::OLetter),
  ((1,241,48),(1,241,73),SentenceBreak::Uppercase),
  ((1,241,80),(1,241,105),SentenceBreak::Uppercase),
  ((1,241,112),(1,241,137),SentenceBreak::Uppercase),
  ((1,246,118),(1,246,120),SentenceBreak::Close),
  ((2,0,0),(2,166,214),SentenceBreak::OLetter),
  ((2,167,0),(2,183,52),SentenceBreak::OLetter),
  ((2,183,64),(2,184,29),SentenceBreak::OLetter),
  ((2,184,32),(2,206,161),SentenceBreak::OLetter),
  ((2,248,0),(2,250,29),SentenceBreak::OLetter),
  ((14,0,1),(14,0,1),SentenceBreak::Format),
  ((14,0,32),(14,0,127),SentenceBreak::Extend),
  ((14,1,0),(14,1,239),SentenceBreak::Extend)
];

pub static UCD_DECOMP_MAP: &'static [((u8,u8,u8),&'static [(u8,u8,u8)])] = &[
  ((0,0,160), &[(0,0,32)]), ((0,0,168), &[(0,0,32), (0,3,8)]), ((0,0,170),
  &[(0,0,97)]), ((0,0,175), &[(0,0,32), (0,3,4)]), ((0,0,178), &[(0,0,50)]),
  ((0,0,179), &[(0,0,51)]), ((0,0,180), &[(0,0,32), (0,3,1)]), ((0,0,181),
  &[(0,3,188)]), ((0,0,184), &[(0,0,32), (0,3,39)]), ((0,0,185), &[(0,0,49)]),
  ((0,0,186), &[(0,0,111)]), ((0,0,188), &[(0,0,49), (0,32,68), (0,0,52)]),
  ((0,0,189), &[(0,0,49), (0,32,68), (0,0,50)]), ((0,0,190), &[(0,0,51),
  (0,32,68), (0,0,52)]), ((0,0,192), &[(0,0,65), (0,3,0)]), ((0,0,193),
  &[(0,0,65), (0,3,1)]), ((0,0,194), &[(0,0,65), (0,3,2)]), ((0,0,195),
  &[(0,0,65), (0,3,3)]), ((0,0,196), &[(0,0,65), (0,3,8)]), ((0,0,197),
  &[(0,0,65), (0,3,10)]), ((0,0,199), &[(0,0,67), (0,3,39)]), ((0,0,200),
  &[(0,0,69), (0,3,0)]), ((0,0,201), &[(0,0,69), (0,3,1)]), ((0,0,202),
  &[(0,0,69), (0,3,2)]), ((0,0,203), &[(0,0,69), (0,3,8)]), ((0,0,204),
  &[(0,0,73), (0,3,0)]), ((0,0,205), &[(0,0,73), (0,3,1)]), ((0,0,206),
  &[(0,0,73), (0,3,2)]), ((0,0,207), &[(0,0,73), (0,3,8)]), ((0,0,209),
  &[(0,0,78), (0,3,3)]), ((0,0,210), &[(0,0,79), (0,3,0)]), ((0,0,211),
  &[(0,0,79), (0,3,1)]), ((0,0,212), &[(0,0,79), (0,3,2)]), ((0,0,213),
  &[(0,0,79), (0,3,3)]), ((0,0,214), &[(0,0,79), (0,3,8)]), ((0,0,217),
  &[(0,0,85), (0,3,0)]), ((0,0,218), &[(0,0,85), (0,3,1)]), ((0,0,219),
  &[(0,0,85), (0,3,2)]), ((0,0,220), &[(0,0,85), (0,3,8)]), ((0,0,221),
  &[(0,0,89), (0,3,1)]), ((0,0,224), &[(0,0,97), (0,3,0)]), ((0,0,225),
  &[(0,0,97), (0,3,1)]), ((0,0,226), &[(0,0,97), (0,3,2)]), ((0,0,227),
  &[(0,0,97), (0,3,3)]), ((0,0,228), &[(0,0,97), (0,3,8)]), ((0,0,229),
  &[(0,0,97), (0,3,10)]), ((0,0,231), &[(0,0,99), (0,3,39)]), ((0,0,232),
  &[(0,0,101), (0,3,0)]), ((0,0,233), &[(0,0,101), (0,3,1)]), ((0,0,234),
  &[(0,0,101), (0,3,2)]), ((0,0,235), &[(0,0,101), (0,3,8)]), ((0,0,236),
  &[(0,0,105), (0,3,0)]), ((0,0,237), &[(0,0,105), (0,3,1)]), ((0,0,238),
  &[(0,0,105), (0,3,2)]), ((0,0,239), &[(0,0,105), (0,3,8)]), ((0,0,241),
  &[(0,0,110), (0,3,3)]), ((0,0,242), &[(0,0,111), (0,3,0)]), ((0,0,243),
  &[(0,0,111), (0,3,1)]), ((0,0,244), &[(0,0,111), (0,3,2)]), ((0,0,245),
  &[(0,0,111), (0,3,3)]), ((0,0,246), &[(0,0,111), (0,3,8)]), ((0,0,249),
  &[(0,0,117), (0,3,0)]), ((0,0,250), &[(0,0,117), (0,3,1)]), ((0,0,251),
  &[(0,0,117), (0,3,2)]), ((0,0,252), &[(0,0,117), (0,3,8)]), ((0,0,253),
  &[(0,0,121), (0,3,1)]), ((0,0,255), &[(0,0,121), (0,3,8)]), ((0,1,0),
  &[(0,0,65), (0,3,4)]), ((0,1,1), &[(0,0,97), (0,3,4)]), ((0,1,2), &[(0,0,65),
  (0,3,6)]), ((0,1,3), &[(0,0,97), (0,3,6)]), ((0,1,4), &[(0,0,65), (0,3,40)]),
  ((0,1,5), &[(0,0,97), (0,3,40)]), ((0,1,6), &[(0,0,67), (0,3,1)]), ((0,1,7),
  &[(0,0,99), (0,3,1)]), ((0,1,8), &[(0,0,67), (0,3,2)]), ((0,1,9), &[(0,0,99),
  (0,3,2)]), ((0,1,10), &[(0,0,67), (0,3,7)]), ((0,1,11), &[(0,0,99), (0,3,7)]),
  ((0,1,12), &[(0,0,67), (0,3,12)]), ((0,1,13), &[(0,0,99), (0,3,12)]),
  ((0,1,14), &[(0,0,68), (0,3,12)]), ((0,1,15), &[(0,0,100), (0,3,12)]),
  ((0,1,18), &[(0,0,69), (0,3,4)]), ((0,1,19), &[(0,0,101), (0,3,4)]),
  ((0,1,20), &[(0,0,69), (0,3,6)]), ((0,1,21), &[(0,0,101), (0,3,6)]),
  ((0,1,22), &[(0,0,69), (0,3,7)]), ((0,1,23), &[(0,0,101), (0,3,7)]),
  ((0,1,24), &[(0,0,69), (0,3,40)]), ((0,1,25), &[(0,0,101), (0,3,40)]),
  ((0,1,26), &[(0,0,69), (0,3,12)]), ((0,1,27), &[(0,0,101), (0,3,12)]),
  ((0,1,28), &[(0,0,71), (0,3,2)]), ((0,1,29), &[(0,0,103), (0,3,2)]),
  ((0,1,30), &[(0,0,71), (0,3,6)]), ((0,1,31), &[(0,0,103), (0,3,6)]),
  ((0,1,32), &[(0,0,71), (0,3,7)]), ((0,1,33), &[(0,0,103), (0,3,7)]),
  ((0,1,34), &[(0,0,71), (0,3,39)]), ((0,1,35), &[(0,0,103), (0,3,39)]),
  ((0,1,36), &[(0,0,72), (0,3,2)]), ((0,1,37), &[(0,0,104), (0,3,2)]),
  ((0,1,40), &[(0,0,73), (0,3,3)]), ((0,1,41), &[(0,0,105), (0,3,3)]),
  ((0,1,42), &[(0,0,73), (0,3,4)]), ((0,1,43), &[(0,0,105), (0,3,4)]),
  ((0,1,44), &[(0,0,73), (0,3,6)]), ((0,1,45), &[(0,0,105), (0,3,6)]),
  ((0,1,46), &[(0,0,73), (0,3,40)]), ((0,1,47), &[(0,0,105), (0,3,40)]),
  ((0,1,48), &[(0,0,73), (0,3,7)]), ((0,1,50), &[(0,0,73), (0,0,74)]),
  ((0,1,51), &[(0,0,105), (0,0,106)]), ((0,1,52), &[(0,0,74), (0,3,2)]),
  ((0,1,53), &[(0,0,106), (0,3,2)]), ((0,1,54), &[(0,0,75), (0,3,39)]),
  ((0,1,55), &[(0,0,107), (0,3,39)]), ((0,1,57), &[(0,0,76), (0,3,1)]),
  ((0,1,58), &[(0,0,108), (0,3,1)]), ((0,1,59), &[(0,0,76), (0,3,39)]),
  ((0,1,60), &[(0,0,108), (0,3,39)]), ((0,1,61), &[(0,0,76), (0,3,12)]),
  ((0,1,62), &[(0,0,108), (0,3,12)]), ((0,1,63), &[(0,0,76), (0,0,183)]),
  ((0,1,64), &[(0,0,108), (0,0,183)]), ((0,1,67), &[(0,0,78), (0,3,1)]),
  ((0,1,68), &[(0,0,110), (0,3,1)]), ((0,1,69), &[(0,0,78), (0,3,39)]),
  ((0,1,70), &[(0,0,110), (0,3,39)]), ((0,1,71), &[(0,0,78), (0,3,12)]),
  ((0,1,72), &[(0,0,110), (0,3,12)]), ((0,1,73), &[(0,2,188), (0,0,110)]),
  ((0,1,76), &[(0,0,79), (0,3,4)]), ((0,1,77), &[(0,0,111), (0,3,4)]),
  ((0,1,78), &[(0,0,79), (0,3,6)]), ((0,1,79), &[(0,0,111), (0,3,6)]),
  ((0,1,80), &[(0,0,79), (0,3,11)]), ((0,1,81), &[(0,0,111), (0,3,11)]),
  ((0,1,84), &[(0,0,82), (0,3,1)]), ((0,1,85), &[(0,0,114), (0,3,1)]),
  ((0,1,86), &[(0,0,82), (0,3,39)]), ((0,1,87), &[(0,0,114), (0,3,39)]),
  ((0,1,88), &[(0,0,82), (0,3,12)]), ((0,1,89), &[(0,0,114), (0,3,12)]),
  ((0,1,90), &[(0,0,83), (0,3,1)]), ((0,1,91), &[(0,0,115), (0,3,1)]),
  ((0,1,92), &[(0,0,83), (0,3,2)]), ((0,1,93), &[(0,0,115), (0,3,2)]),
  ((0,1,94), &[(0,0,83), (0,3,39)]), ((0,1,95), &[(0,0,115), (0,3,39)]),
  ((0,1,96), &[(0,0,83), (0,3,12)]), ((0,1,97), &[(0,0,115), (0,3,12)]),
  ((0,1,98), &[(0,0,84), (0,3,39)]), ((0,1,99), &[(0,0,116), (0,3,39)]),
  ((0,1,100), &[(0,0,84), (0,3,12)]), ((0,1,101), &[(0,0,116), (0,3,12)]),
  ((0,1,104), &[(0,0,85), (0,3,3)]), ((0,1,105), &[(0,0,117), (0,3,3)]),
  ((0,1,106), &[(0,0,85), (0,3,4)]), ((0,1,107), &[(0,0,117), (0,3,4)]),
  ((0,1,108), &[(0,0,85), (0,3,6)]), ((0,1,109), &[(0,0,117), (0,3,6)]),
  ((0,1,110), &[(0,0,85), (0,3,10)]), ((0,1,111), &[(0,0,117), (0,3,10)]),
  ((0,1,112), &[(0,0,85), (0,3,11)]), ((0,1,113), &[(0,0,117), (0,3,11)]),
  ((0,1,114), &[(0,0,85), (0,3,40)]), ((0,1,115), &[(0,0,117), (0,3,40)]),
  ((0,1,116), &[(0,0,87), (0,3,2)]), ((0,1,117), &[(0,0,119), (0,3,2)]),
  ((0,1,118), &[(0,0,89), (0,3,2)]), ((0,1,119), &[(0,0,121), (0,3,2)]),
  ((0,1,120), &[(0,0,89), (0,3,8)]), ((0,1,121), &[(0,0,90), (0,3,1)]),
  ((0,1,122), &[(0,0,122), (0,3,1)]), ((0,1,123), &[(0,0,90), (0,3,7)]),
  ((0,1,124), &[(0,0,122), (0,3,7)]), ((0,1,125), &[(0,0,90), (0,3,12)]),
  ((0,1,126), &[(0,0,122), (0,3,12)]), ((0,1,127), &[(0,0,115)]), ((0,1,160),
  &[(0,0,79), (0,3,27)]), ((0,1,161), &[(0,0,111), (0,3,27)]), ((0,1,175),
  &[(0,0,85), (0,3,27)]), ((0,1,176), &[(0,0,117), (0,3,27)]), ((0,1,196),
  &[(0,0,68), (0,1,125)]), ((0,1,197), &[(0,0,68), (0,1,126)]), ((0,1,198),
  &[(0,0,100), (0,1,126)]), ((0,1,199), &[(0,0,76), (0,0,74)]), ((0,1,200),
  &[(0,0,76), (0,0,106)]), ((0,1,201), &[(0,0,108), (0,0,106)]), ((0,1,202),
  &[(0,0,78), (0,0,74)]), ((0,1,203), &[(0,0,78), (0,0,106)]), ((0,1,204),
  &[(0,0,110), (0,0,106)]), ((0,1,205), &[(0,0,65), (0,3,12)]), ((0,1,206),
  &[(0,0,97), (0,3,12)]), ((0,1,207), &[(0,0,73), (0,3,12)]), ((0,1,208),
  &[(0,0,105), (0,3,12)]), ((0,1,209), &[(0,0,79), (0,3,12)]), ((0,1,210),
  &[(0,0,111), (0,3,12)]), ((0,1,211), &[(0,0,85), (0,3,12)]), ((0,1,212),
  &[(0,0,117), (0,3,12)]), ((0,1,213), &[(0,0,220), (0,3,4)]), ((0,1,214),
  &[(0,0,252), (0,3,4)]), ((0,1,215), &[(0,0,220), (0,3,1)]), ((0,1,216),
  &[(0,0,252), (0,3,1)]), ((0,1,217), &[(0,0,220), (0,3,12)]), ((0,1,218),
  &[(0,0,252), (0,3,12)]), ((0,1,219), &[(0,0,220), (0,3,0)]), ((0,1,220),
  &[(0,0,252), (0,3,0)]), ((0,1,222), &[(0,0,196), (0,3,4)]), ((0,1,223),
  &[(0,0,228), (0,3,4)]), ((0,1,224), &[(0,2,38), (0,3,4)]), ((0,1,225),
  &[(0,2,39), (0,3,4)]), ((0,1,226), &[(0,0,198), (0,3,4)]), ((0,1,227),
  &[(0,0,230), (0,3,4)]), ((0,1,230), &[(0,0,71), (0,3,12)]), ((0,1,231),
  &[(0,0,103), (0,3,12)]), ((0,1,232), &[(0,0,75), (0,3,12)]), ((0,1,233),
  &[(0,0,107), (0,3,12)]), ((0,1,234), &[(0,0,79), (0,3,40)]), ((0,1,235),
  &[(0,0,111), (0,3,40)]), ((0,1,236), &[(0,1,234), (0,3,4)]), ((0,1,237),
  &[(0,1,235), (0,3,4)]), ((0,1,238), &[(0,1,183), (0,3,12)]), ((0,1,239),
  &[(0,2,146), (0,3,12)]), ((0,1,240), &[(0,0,106), (0,3,12)]), ((0,1,241),
  &[(0,0,68), (0,0,90)]), ((0,1,242), &[(0,0,68), (0,0,122)]), ((0,1,243),
  &[(0,0,100), (0,0,122)]), ((0,1,244), &[(0,0,71), (0,3,1)]), ((0,1,245),
  &[(0,0,103), (0,3,1)]), ((0,1,248), &[(0,0,78), (0,3,0)]), ((0,1,249),
  &[(0,0,110), (0,3,0)]), ((0,1,250), &[(0,0,197), (0,3,1)]), ((0,1,251),
  &[(0,0,229), (0,3,1)]), ((0,1,252), &[(0,0,198), (0,3,1)]), ((0,1,253),
  &[(0,0,230), (0,3,1)]), ((0,1,254), &[(0,0,216), (0,3,1)]), ((0,1,255),
  &[(0,0,248), (0,3,1)]), ((0,2,0), &[(0,0,65), (0,3,15)]), ((0,2,1),
  &[(0,0,97), (0,3,15)]), ((0,2,2), &[(0,0,65), (0,3,17)]), ((0,2,3),
  &[(0,0,97), (0,3,17)]), ((0,2,4), &[(0,0,69), (0,3,15)]), ((0,2,5),
  &[(0,0,101), (0,3,15)]), ((0,2,6), &[(0,0,69), (0,3,17)]), ((0,2,7),
  &[(0,0,101), (0,3,17)]), ((0,2,8), &[(0,0,73), (0,3,15)]), ((0,2,9),
  &[(0,0,105), (0,3,15)]), ((0,2,10), &[(0,0,73), (0,3,17)]), ((0,2,11),
  &[(0,0,105), (0,3,17)]), ((0,2,12), &[(0,0,79), (0,3,15)]), ((0,2,13),
  &[(0,0,111), (0,3,15)]), ((0,2,14), &[(0,0,79), (0,3,17)]), ((0,2,15),
  &[(0,0,111), (0,3,17)]), ((0,2,16), &[(0,0,82), (0,3,15)]), ((0,2,17),
  &[(0,0,114), (0,3,15)]), ((0,2,18), &[(0,0,82), (0,3,17)]), ((0,2,19),
  &[(0,0,114), (0,3,17)]), ((0,2,20), &[(0,0,85), (0,3,15)]), ((0,2,21),
  &[(0,0,117), (0,3,15)]), ((0,2,22), &[(0,0,85), (0,3,17)]), ((0,2,23),
  &[(0,0,117), (0,3,17)]), ((0,2,24), &[(0,0,83), (0,3,38)]), ((0,2,25),
  &[(0,0,115), (0,3,38)]), ((0,2,26), &[(0,0,84), (0,3,38)]), ((0,2,27),
  &[(0,0,116), (0,3,38)]), ((0,2,30), &[(0,0,72), (0,3,12)]), ((0,2,31),
  &[(0,0,104), (0,3,12)]), ((0,2,38), &[(0,0,65), (0,3,7)]), ((0,2,39),
  &[(0,0,97), (0,3,7)]), ((0,2,40), &[(0,0,69), (0,3,39)]), ((0,2,41),
  &[(0,0,101), (0,3,39)]), ((0,2,42), &[(0,0,214), (0,3,4)]), ((0,2,43),
  &[(0,0,246), (0,3,4)]), ((0,2,44), &[(0,0,213), (0,3,4)]), ((0,2,45),
  &[(0,0,245), (0,3,4)]), ((0,2,46), &[(0,0,79), (0,3,7)]), ((0,2,47),
  &[(0,0,111), (0,3,7)]), ((0,2,48), &[(0,2,46), (0,3,4)]), ((0,2,49),
  &[(0,2,47), (0,3,4)]), ((0,2,50), &[(0,0,89), (0,3,4)]), ((0,2,51),
  &[(0,0,121), (0,3,4)]), ((0,2,176), &[(0,0,104)]), ((0,2,177), &[(0,2,102)]),
  ((0,2,178), &[(0,0,106)]), ((0,2,179), &[(0,0,114)]), ((0,2,180),
  &[(0,2,121)]), ((0,2,181), &[(0,2,123)]), ((0,2,182), &[(0,2,129)]),
  ((0,2,183), &[(0,0,119)]), ((0,2,184), &[(0,0,121)]), ((0,2,216), &[(0,0,32),
  (0,3,6)]), ((0,2,217), &[(0,0,32), (0,3,7)]), ((0,2,218), &[(0,0,32),
  (0,3,10)]), ((0,2,219), &[(0,0,32), (0,3,40)]), ((0,2,220), &[(0,0,32),
  (0,3,3)]), ((0,2,221), &[(0,0,32), (0,3,11)]), ((0,2,224), &[(0,2,99)]),
  ((0,2,225), &[(0,0,108)]), ((0,2,226), &[(0,0,115)]), ((0,2,227),
  &[(0,0,120)]), ((0,2,228), &[(0,2,149)]), ((0,3,64), &[(0,3,0)]), ((0,3,65),
  &[(0,3,1)]), ((0,3,67), &[(0,3,19)]), ((0,3,68), &[(0,3,8), (0,3,1)]),
  ((0,3,116), &[(0,2,185)]), ((0,3,122), &[(0,0,32), (0,3,69)]), ((0,3,126),
  &[(0,0,59)]), ((0,3,132), &[(0,0,32), (0,3,1)]), ((0,3,133), &[(0,0,168),
  (0,3,1)]), ((0,3,134), &[(0,3,145), (0,3,1)]), ((0,3,135), &[(0,0,183)]),
  ((0,3,136), &[(0,3,149), (0,3,1)]), ((0,3,137), &[(0,3,151), (0,3,1)]),
  ((0,3,138), &[(0,3,153), (0,3,1)]), ((0,3,140), &[(0,3,159), (0,3,1)]),
  ((0,3,142), &[(0,3,165), (0,3,1)]), ((0,3,143), &[(0,3,169), (0,3,1)]),
  ((0,3,144), &[(0,3,202), (0,3,1)]), ((0,3,170), &[(0,3,153), (0,3,8)]),
  ((0,3,171), &[(0,3,165), (0,3,8)]), ((0,3,172), &[(0,3,177), (0,3,1)]),
  ((0,3,173), &[(0,3,181), (0,3,1)]), ((0,3,174), &[(0,3,183), (0,3,1)]),
  ((0,3,175), &[(0,3,185), (0,3,1)]), ((0,3,176), &[(0,3,203), (0,3,1)]),
  ((0,3,202), &[(0,3,185), (0,3,8)]), ((0,3,203), &[(0,3,197), (0,3,8)]),
  ((0,3,204), &[(0,3,191), (0,3,1)]), ((0,3,205), &[(0,3,197), (0,3,1)]),
  ((0,3,206), &[(0,3,201), (0,3,1)]), ((0,3,208), &[(0,3,178)]), ((0,3,209),
  &[(0,3,184)]), ((0,3,210), &[(0,3,165)]), ((0,3,211), &[(0,3,210), (0,3,1)]),
  ((0,3,212), &[(0,3,210), (0,3,8)]), ((0,3,213), &[(0,3,198)]), ((0,3,214),
  &[(0,3,192)]), ((0,3,240), &[(0,3,186)]), ((0,3,241), &[(0,3,193)]),
  ((0,3,242), &[(0,3,194)]), ((0,3,244), &[(0,3,152)]), ((0,3,245),
  &[(0,3,181)]), ((0,3,249), &[(0,3,163)]), ((0,4,0), &[(0,4,21), (0,3,0)]),
  ((0,4,1), &[(0,4,21), (0,3,8)]), ((0,4,3), &[(0,4,19), (0,3,1)]), ((0,4,7),
  &[(0,4,6), (0,3,8)]), ((0,4,12), &[(0,4,26), (0,3,1)]), ((0,4,13), &[(0,4,24),
  (0,3,0)]), ((0,4,14), &[(0,4,35), (0,3,6)]), ((0,4,25), &[(0,4,24), (0,3,6)]),
  ((0,4,57), &[(0,4,56), (0,3,6)]), ((0,4,80), &[(0,4,53), (0,3,0)]), ((0,4,81),
  &[(0,4,53), (0,3,8)]), ((0,4,83), &[(0,4,51), (0,3,1)]), ((0,4,87),
  &[(0,4,86), (0,3,8)]), ((0,4,92), &[(0,4,58), (0,3,1)]), ((0,4,93),
  &[(0,4,56), (0,3,0)]), ((0,4,94), &[(0,4,67), (0,3,6)]), ((0,4,118),
  &[(0,4,116), (0,3,15)]), ((0,4,119), &[(0,4,117), (0,3,15)]), ((0,4,193),
  &[(0,4,22), (0,3,6)]), ((0,4,194), &[(0,4,54), (0,3,6)]), ((0,4,208),
  &[(0,4,16), (0,3,6)]), ((0,4,209), &[(0,4,48), (0,3,6)]), ((0,4,210),
  &[(0,4,16), (0,3,8)]), ((0,4,211), &[(0,4,48), (0,3,8)]), ((0,4,214),
  &[(0,4,21), (0,3,6)]), ((0,4,215), &[(0,4,53), (0,3,6)]), ((0,4,218),
  &[(0,4,216), (0,3,8)]), ((0,4,219), &[(0,4,217), (0,3,8)]), ((0,4,220),
  &[(0,4,22), (0,3,8)]), ((0,4,221), &[(0,4,54), (0,3,8)]), ((0,4,222),
  &[(0,4,23), (0,3,8)]), ((0,4,223), &[(0,4,55), (0,3,8)]), ((0,4,226),
  &[(0,4,24), (0,3,4)]), ((0,4,227), &[(0,4,56), (0,3,4)]), ((0,4,228),
  &[(0,4,24), (0,3,8)]), ((0,4,229), &[(0,4,56), (0,3,8)]), ((0,4,230),
  &[(0,4,30), (0,3,8)]), ((0,4,231), &[(0,4,62), (0,3,8)]), ((0,4,234),
  &[(0,4,232), (0,3,8)]), ((0,4,235), &[(0,4,233), (0,3,8)]), ((0,4,236),
  &[(0,4,45), (0,3,8)]), ((0,4,237), &[(0,4,77), (0,3,8)]), ((0,4,238),
  &[(0,4,35), (0,3,4)]), ((0,4,239), &[(0,4,67), (0,3,4)]), ((0,4,240),
  &[(0,4,35), (0,3,8)]), ((0,4,241), &[(0,4,67), (0,3,8)]), ((0,4,242),
  &[(0,4,35), (0,3,11)]), ((0,4,243), &[(0,4,67), (0,3,11)]), ((0,4,244),
  &[(0,4,39), (0,3,8)]), ((0,4,245), &[(0,4,71), (0,3,8)]), ((0,4,248),
  &[(0,4,43), (0,3,8)]), ((0,4,249), &[(0,4,75), (0,3,8)]), ((0,5,135),
  &[(0,5,101), (0,5,130)]), ((0,6,34), &[(0,6,39), (0,6,83)]), ((0,6,35),
  &[(0,6,39), (0,6,84)]), ((0,6,36), &[(0,6,72), (0,6,84)]), ((0,6,37),
  &[(0,6,39), (0,6,85)]), ((0,6,38), &[(0,6,74), (0,6,84)]), ((0,6,117),
  &[(0,6,39), (0,6,116)]), ((0,6,118), &[(0,6,72), (0,6,116)]), ((0,6,119),
  &[(0,6,199), (0,6,116)]), ((0,6,120), &[(0,6,74), (0,6,116)]), ((0,6,192),
  &[(0,6,213), (0,6,84)]), ((0,6,194), &[(0,6,193), (0,6,84)]), ((0,6,211),
  &[(0,6,210), (0,6,84)]), ((0,9,41), &[(0,9,40), (0,9,60)]), ((0,9,49),
  &[(0,9,48), (0,9,60)]), ((0,9,52), &[(0,9,51), (0,9,60)]), ((0,9,88),
  &[(0,9,21), (0,9,60)]), ((0,9,89), &[(0,9,22), (0,9,60)]), ((0,9,90),
  &[(0,9,23), (0,9,60)]), ((0,9,91), &[(0,9,28), (0,9,60)]), ((0,9,92),
  &[(0,9,33), (0,9,60)]), ((0,9,93), &[(0,9,34), (0,9,60)]), ((0,9,94),
  &[(0,9,43), (0,9,60)]), ((0,9,95), &[(0,9,47), (0,9,60)]), ((0,9,203),
  &[(0,9,199), (0,9,190)]), ((0,9,204), &[(0,9,199), (0,9,215)]), ((0,9,220),
  &[(0,9,161), (0,9,188)]), ((0,9,221), &[(0,9,162), (0,9,188)]), ((0,9,223),
  &[(0,9,175), (0,9,188)]), ((0,10,51), &[(0,10,50), (0,10,60)]), ((0,10,54),
  &[(0,10,56), (0,10,60)]), ((0,10,89), &[(0,10,22), (0,10,60)]), ((0,10,90),
  &[(0,10,23), (0,10,60)]), ((0,10,91), &[(0,10,28), (0,10,60)]), ((0,10,94),
  &[(0,10,43), (0,10,60)]), ((0,11,72), &[(0,11,71), (0,11,86)]), ((0,11,75),
  &[(0,11,71), (0,11,62)]), ((0,11,76), &[(0,11,71), (0,11,87)]), ((0,11,92),
  &[(0,11,33), (0,11,60)]), ((0,11,93), &[(0,11,34), (0,11,60)]), ((0,11,148),
  &[(0,11,146), (0,11,215)]), ((0,11,202), &[(0,11,198), (0,11,190)]),
  ((0,11,203), &[(0,11,199), (0,11,190)]), ((0,11,204), &[(0,11,198),
  (0,11,215)]), ((0,12,72), &[(0,12,70), (0,12,86)]), ((0,12,192), &[(0,12,191),
  (0,12,213)]), ((0,12,199), &[(0,12,198), (0,12,213)]), ((0,12,200),
  &[(0,12,198), (0,12,214)]), ((0,12,202), &[(0,12,198), (0,12,194)]),
  ((0,12,203), &[(0,12,202), (0,12,213)]), ((0,13,74), &[(0,13,70), (0,13,62)]),
  ((0,13,75), &[(0,13,71), (0,13,62)]), ((0,13,76), &[(0,13,70), (0,13,87)]),
  ((0,13,218), &[(0,13,217), (0,13,202)]), ((0,13,220), &[(0,13,217),
  (0,13,207)]), ((0,13,221), &[(0,13,220), (0,13,202)]), ((0,13,222),
  &[(0,13,217), (0,13,223)]), ((0,14,51), &[(0,14,77), (0,14,50)]), ((0,14,179),
  &[(0,14,205), (0,14,178)]), ((0,14,220), &[(0,14,171), (0,14,153)]),
  ((0,14,221), &[(0,14,171), (0,14,161)]), ((0,15,12), &[(0,15,11)]),
  ((0,15,67), &[(0,15,66), (0,15,183)]), ((0,15,77), &[(0,15,76), (0,15,183)]),
  ((0,15,82), &[(0,15,81), (0,15,183)]), ((0,15,87), &[(0,15,86), (0,15,183)]),
  ((0,15,92), &[(0,15,91), (0,15,183)]), ((0,15,105), &[(0,15,64), (0,15,181)]),
  ((0,15,115), &[(0,15,113), (0,15,114)]), ((0,15,117), &[(0,15,113),
  (0,15,116)]), ((0,15,118), &[(0,15,178), (0,15,128)]), ((0,15,119),
  &[(0,15,178), (0,15,129)]), ((0,15,120), &[(0,15,179), (0,15,128)]),
  ((0,15,121), &[(0,15,179), (0,15,129)]), ((0,15,129), &[(0,15,113),
  (0,15,128)]), ((0,15,147), &[(0,15,146), (0,15,183)]), ((0,15,157),
  &[(0,15,156), (0,15,183)]), ((0,15,162), &[(0,15,161), (0,15,183)]),
  ((0,15,167), &[(0,15,166), (0,15,183)]), ((0,15,172), &[(0,15,171),
  (0,15,183)]), ((0,15,185), &[(0,15,144), (0,15,181)]), ((0,16,38),
  &[(0,16,37), (0,16,46)]), ((0,16,252), &[(0,16,220)]), ((0,27,6), &[(0,27,5),
  (0,27,53)]), ((0,27,8), &[(0,27,7), (0,27,53)]), ((0,27,10), &[(0,27,9),
  (0,27,53)]), ((0,27,12), &[(0,27,11), (0,27,53)]), ((0,27,14), &[(0,27,13),
  (0,27,53)]), ((0,27,18), &[(0,27,17), (0,27,53)]), ((0,27,59), &[(0,27,58),
  (0,27,53)]), ((0,27,61), &[(0,27,60), (0,27,53)]), ((0,27,64), &[(0,27,62),
  (0,27,53)]), ((0,27,65), &[(0,27,63), (0,27,53)]), ((0,27,67), &[(0,27,66),
  (0,27,53)]), ((0,29,44), &[(0,0,65)]), ((0,29,45), &[(0,0,198)]), ((0,29,46),
  &[(0,0,66)]), ((0,29,48), &[(0,0,68)]), ((0,29,49), &[(0,0,69)]), ((0,29,50),
  &[(0,1,142)]), ((0,29,51), &[(0,0,71)]), ((0,29,52), &[(0,0,72)]), ((0,29,53),
  &[(0,0,73)]), ((0,29,54), &[(0,0,74)]), ((0,29,55), &[(0,0,75)]), ((0,29,56),
  &[(0,0,76)]), ((0,29,57), &[(0,0,77)]), ((0,29,58), &[(0,0,78)]), ((0,29,60),
  &[(0,0,79)]), ((0,29,61), &[(0,2,34)]), ((0,29,62), &[(0,0,80)]), ((0,29,63),
  &[(0,0,82)]), ((0,29,64), &[(0,0,84)]), ((0,29,65), &[(0,0,85)]), ((0,29,66),
  &[(0,0,87)]), ((0,29,67), &[(0,0,97)]), ((0,29,68), &[(0,2,80)]), ((0,29,69),
  &[(0,2,81)]), ((0,29,70), &[(0,29,2)]), ((0,29,71), &[(0,0,98)]), ((0,29,72),
  &[(0,0,100)]), ((0,29,73), &[(0,0,101)]), ((0,29,74), &[(0,2,89)]),
  ((0,29,75), &[(0,2,91)]), ((0,29,76), &[(0,2,92)]), ((0,29,77), &[(0,0,103)]),
  ((0,29,79), &[(0,0,107)]), ((0,29,80), &[(0,0,109)]), ((0,29,81),
  &[(0,1,75)]), ((0,29,82), &[(0,0,111)]), ((0,29,83), &[(0,2,84)]), ((0,29,84),
  &[(0,29,22)]), ((0,29,85), &[(0,29,23)]), ((0,29,86), &[(0,0,112)]),
  ((0,29,87), &[(0,0,116)]), ((0,29,88), &[(0,0,117)]), ((0,29,89),
  &[(0,29,29)]), ((0,29,90), &[(0,2,111)]), ((0,29,91), &[(0,0,118)]),
  ((0,29,92), &[(0,29,37)]), ((0,29,93), &[(0,3,178)]), ((0,29,94),
  &[(0,3,179)]), ((0,29,95), &[(0,3,180)]), ((0,29,96), &[(0,3,198)]),
  ((0,29,97), &[(0,3,199)]), ((0,29,98), &[(0,0,105)]), ((0,29,99),
  &[(0,0,114)]), ((0,29,100), &[(0,0,117)]), ((0,29,101), &[(0,0,118)]),
  ((0,29,102), &[(0,3,178)]), ((0,29,103), &[(0,3,179)]), ((0,29,104),
  &[(0,3,193)]), ((0,29,105), &[(0,3,198)]), ((0,29,106), &[(0,3,199)]),
  ((0,29,120), &[(0,4,61)]), ((0,29,155), &[(0,2,82)]), ((0,29,156),
  &[(0,0,99)]), ((0,29,157), &[(0,2,85)]), ((0,29,158), &[(0,0,240)]),
  ((0,29,159), &[(0,2,92)]), ((0,29,160), &[(0,0,102)]), ((0,29,161),
  &[(0,2,95)]), ((0,29,162), &[(0,2,97)]), ((0,29,163), &[(0,2,101)]),
  ((0,29,164), &[(0,2,104)]), ((0,29,165), &[(0,2,105)]), ((0,29,166),
  &[(0,2,106)]), ((0,29,167), &[(0,29,123)]), ((0,29,168), &[(0,2,157)]),
  ((0,29,169), &[(0,2,109)]), ((0,29,170), &[(0,29,133)]), ((0,29,171),
  &[(0,2,159)]), ((0,29,172), &[(0,2,113)]), ((0,29,173), &[(0,2,112)]),
  ((0,29,174), &[(0,2,114)]), ((0,29,175), &[(0,2,115)]), ((0,29,176),
  &[(0,2,116)]), ((0,29,177), &[(0,2,117)]), ((0,29,178), &[(0,2,120)]),
  ((0,29,179), &[(0,2,130)]), ((0,29,180), &[(0,2,131)]), ((0,29,181),
  &[(0,1,171)]), ((0,29,182), &[(0,2,137)]), ((0,29,183), &[(0,2,138)]),
  ((0,29,184), &[(0,29,28)]), ((0,29,185), &[(0,2,139)]), ((0,29,186),
  &[(0,2,140)]), ((0,29,187), &[(0,0,122)]), ((0,29,188), &[(0,2,144)]),
  ((0,29,189), &[(0,2,145)]), ((0,29,190), &[(0,2,146)]), ((0,29,191),
  &[(0,3,184)]), ((0,30,0), &[(0,0,65), (0,3,37)]), ((0,30,1), &[(0,0,97),
  (0,3,37)]), ((0,30,2), &[(0,0,66), (0,3,7)]), ((0,30,3), &[(0,0,98),
  (0,3,7)]), ((0,30,4), &[(0,0,66), (0,3,35)]), ((0,30,5), &[(0,0,98),
  (0,3,35)]), ((0,30,6), &[(0,0,66), (0,3,49)]), ((0,30,7), &[(0,0,98),
  (0,3,49)]), ((0,30,8), &[(0,0,199), (0,3,1)]), ((0,30,9), &[(0,0,231),
  (0,3,1)]), ((0,30,10), &[(0,0,68), (0,3,7)]), ((0,30,11), &[(0,0,100),
  (0,3,7)]), ((0,30,12), &[(0,0,68), (0,3,35)]), ((0,30,13), &[(0,0,100),
  (0,3,35)]), ((0,30,14), &[(0,0,68), (0,3,49)]), ((0,30,15), &[(0,0,100),
  (0,3,49)]), ((0,30,16), &[(0,0,68), (0,3,39)]), ((0,30,17), &[(0,0,100),
  (0,3,39)]), ((0,30,18), &[(0,0,68), (0,3,45)]), ((0,30,19), &[(0,0,100),
  (0,3,45)]), ((0,30,20), &[(0,1,18), (0,3,0)]), ((0,30,21), &[(0,1,19),
  (0,3,0)]), ((0,30,22), &[(0,1,18), (0,3,1)]), ((0,30,23), &[(0,1,19),
  (0,3,1)]), ((0,30,24), &[(0,0,69), (0,3,45)]), ((0,30,25), &[(0,0,101),
  (0,3,45)]), ((0,30,26), &[(0,0,69), (0,3,48)]), ((0,30,27), &[(0,0,101),
  (0,3,48)]), ((0,30,28), &[(0,2,40), (0,3,6)]), ((0,30,29), &[(0,2,41),
  (0,3,6)]), ((0,30,30), &[(0,0,70), (0,3,7)]), ((0,30,31), &[(0,0,102),
  (0,3,7)]), ((0,30,32), &[(0,0,71), (0,3,4)]), ((0,30,33), &[(0,0,103),
  (0,3,4)]), ((0,30,34), &[(0,0,72), (0,3,7)]), ((0,30,35), &[(0,0,104),
  (0,3,7)]), ((0,30,36), &[(0,0,72), (0,3,35)]), ((0,30,37), &[(0,0,104),
  (0,3,35)]), ((0,30,38), &[(0,0,72), (0,3,8)]), ((0,30,39), &[(0,0,104),
  (0,3,8)]), ((0,30,40), &[(0,0,72), (0,3,39)]), ((0,30,41), &[(0,0,104),
  (0,3,39)]), ((0,30,42), &[(0,0,72), (0,3,46)]), ((0,30,43), &[(0,0,104),
  (0,3,46)]), ((0,30,44), &[(0,0,73), (0,3,48)]), ((0,30,45), &[(0,0,105),
  (0,3,48)]), ((0,30,46), &[(0,0,207), (0,3,1)]), ((0,30,47), &[(0,0,239),
  (0,3,1)]), ((0,30,48), &[(0,0,75), (0,3,1)]), ((0,30,49), &[(0,0,107),
  (0,3,1)]), ((0,30,50), &[(0,0,75), (0,3,35)]), ((0,30,51), &[(0,0,107),
  (0,3,35)]), ((0,30,52), &[(0,0,75), (0,3,49)]), ((0,30,53), &[(0,0,107),
  (0,3,49)]), ((0,30,54), &[(0,0,76), (0,3,35)]), ((0,30,55), &[(0,0,108),
  (0,3,35)]), ((0,30,56), &[(0,30,54), (0,3,4)]), ((0,30,57), &[(0,30,55),
  (0,3,4)]), ((0,30,58), &[(0,0,76), (0,3,49)]), ((0,30,59), &[(0,0,108),
  (0,3,49)]), ((0,30,60), &[(0,0,76), (0,3,45)]), ((0,30,61), &[(0,0,108),
  (0,3,45)]), ((0,30,62), &[(0,0,77), (0,3,1)]), ((0,30,63), &[(0,0,109),
  (0,3,1)]), ((0,30,64), &[(0,0,77), (0,3,7)]), ((0,30,65), &[(0,0,109),
  (0,3,7)]), ((0,30,66), &[(0,0,77), (0,3,35)]), ((0,30,67), &[(0,0,109),
  (0,3,35)]), ((0,30,68), &[(0,0,78), (0,3,7)]), ((0,30,69), &[(0,0,110),
  (0,3,7)]), ((0,30,70), &[(0,0,78), (0,3,35)]), ((0,30,71), &[(0,0,110),
  (0,3,35)]), ((0,30,72), &[(0,0,78), (0,3,49)]), ((0,30,73), &[(0,0,110),
  (0,3,49)]), ((0,30,74), &[(0,0,78), (0,3,45)]), ((0,30,75), &[(0,0,110),
  (0,3,45)]), ((0,30,76), &[(0,0,213), (0,3,1)]), ((0,30,77), &[(0,0,245),
  (0,3,1)]), ((0,30,78), &[(0,0,213), (0,3,8)]), ((0,30,79), &[(0,0,245),
  (0,3,8)]), ((0,30,80), &[(0,1,76), (0,3,0)]), ((0,30,81), &[(0,1,77),
  (0,3,0)]), ((0,30,82), &[(0,1,76), (0,3,1)]), ((0,30,83), &[(0,1,77),
  (0,3,1)]), ((0,30,84), &[(0,0,80), (0,3,1)]), ((0,30,85), &[(0,0,112),
  (0,3,1)]), ((0,30,86), &[(0,0,80), (0,3,7)]), ((0,30,87), &[(0,0,112),
  (0,3,7)]), ((0,30,88), &[(0,0,82), (0,3,7)]), ((0,30,89), &[(0,0,114),
  (0,3,7)]), ((0,30,90), &[(0,0,82), (0,3,35)]), ((0,30,91), &[(0,0,114),
  (0,3,35)]), ((0,30,92), &[(0,30,90), (0,3,4)]), ((0,30,93), &[(0,30,91),
  (0,3,4)]), ((0,30,94), &[(0,0,82), (0,3,49)]), ((0,30,95), &[(0,0,114),
  (0,3,49)]), ((0,30,96), &[(0,0,83), (0,3,7)]), ((0,30,97), &[(0,0,115),
  (0,3,7)]), ((0,30,98), &[(0,0,83), (0,3,35)]), ((0,30,99), &[(0,0,115),
  (0,3,35)]), ((0,30,100), &[(0,1,90), (0,3,7)]), ((0,30,101), &[(0,1,91),
  (0,3,7)]), ((0,30,102), &[(0,1,96), (0,3,7)]), ((0,30,103), &[(0,1,97),
  (0,3,7)]), ((0,30,104), &[(0,30,98), (0,3,7)]), ((0,30,105), &[(0,30,99),
  (0,3,7)]), ((0,30,106), &[(0,0,84), (0,3,7)]), ((0,30,107), &[(0,0,116),
  (0,3,7)]), ((0,30,108), &[(0,0,84), (0,3,35)]), ((0,30,109), &[(0,0,116),
  (0,3,35)]), ((0,30,110), &[(0,0,84), (0,3,49)]), ((0,30,111), &[(0,0,116),
  (0,3,49)]), ((0,30,112), &[(0,0,84), (0,3,45)]), ((0,30,113), &[(0,0,116),
  (0,3,45)]), ((0,30,114), &[(0,0,85), (0,3,36)]), ((0,30,115), &[(0,0,117),
  (0,3,36)]), ((0,30,116), &[(0,0,85), (0,3,48)]), ((0,30,117), &[(0,0,117),
  (0,3,48)]), ((0,30,118), &[(0,0,85), (0,3,45)]), ((0,30,119), &[(0,0,117),
  (0,3,45)]), ((0,30,120), &[(0,1,104), (0,3,1)]), ((0,30,121), &[(0,1,105),
  (0,3,1)]), ((0,30,122), &[(0,1,106), (0,3,8)]), ((0,30,123), &[(0,1,107),
  (0,3,8)]), ((0,30,124), &[(0,0,86), (0,3,3)]), ((0,30,125), &[(0,0,118),
  (0,3,3)]), ((0,30,126), &[(0,0,86), (0,3,35)]), ((0,30,127), &[(0,0,118),
  (0,3,35)]), ((0,30,128), &[(0,0,87), (0,3,0)]), ((0,30,129), &[(0,0,119),
  (0,3,0)]), ((0,30,130), &[(0,0,87), (0,3,1)]), ((0,30,131), &[(0,0,119),
  (0,3,1)]), ((0,30,132), &[(0,0,87), (0,3,8)]), ((0,30,133), &[(0,0,119),
  (0,3,8)]), ((0,30,134), &[(0,0,87), (0,3,7)]), ((0,30,135), &[(0,0,119),
  (0,3,7)]), ((0,30,136), &[(0,0,87), (0,3,35)]), ((0,30,137), &[(0,0,119),
  (0,3,35)]), ((0,30,138), &[(0,0,88), (0,3,7)]), ((0,30,139), &[(0,0,120),
  (0,3,7)]), ((0,30,140), &[(0,0,88), (0,3,8)]), ((0,30,141), &[(0,0,120),
  (0,3,8)]), ((0,30,142), &[(0,0,89), (0,3,7)]), ((0,30,143), &[(0,0,121),
  (0,3,7)]), ((0,30,144), &[(0,0,90), (0,3,2)]), ((0,30,145), &[(0,0,122),
  (0,3,2)]), ((0,30,146), &[(0,0,90), (0,3,35)]), ((0,30,147), &[(0,0,122),
  (0,3,35)]), ((0,30,148), &[(0,0,90), (0,3,49)]), ((0,30,149), &[(0,0,122),
  (0,3,49)]), ((0,30,150), &[(0,0,104), (0,3,49)]), ((0,30,151), &[(0,0,116),
  (0,3,8)]), ((0,30,152), &[(0,0,119), (0,3,10)]), ((0,30,153), &[(0,0,121),
  (0,3,10)]), ((0,30,154), &[(0,0,97), (0,2,190)]), ((0,30,155), &[(0,1,127),
  (0,3,7)]), ((0,30,160), &[(0,0,65), (0,3,35)]), ((0,30,161), &[(0,0,97),
  (0,3,35)]), ((0,30,162), &[(0,0,65), (0,3,9)]), ((0,30,163), &[(0,0,97),
  (0,3,9)]), ((0,30,164), &[(0,0,194), (0,3,1)]), ((0,30,165), &[(0,0,226),
  (0,3,1)]), ((0,30,166), &[(0,0,194), (0,3,0)]), ((0,30,167), &[(0,0,226),
  (0,3,0)]), ((0,30,168), &[(0,0,194), (0,3,9)]), ((0,30,169), &[(0,0,226),
  (0,3,9)]), ((0,30,170), &[(0,0,194), (0,3,3)]), ((0,30,171), &[(0,0,226),
  (0,3,3)]), ((0,30,172), &[(0,30,160), (0,3,2)]), ((0,30,173), &[(0,30,161),
  (0,3,2)]), ((0,30,174), &[(0,1,2), (0,3,1)]), ((0,30,175), &[(0,1,3),
  (0,3,1)]), ((0,30,176), &[(0,1,2), (0,3,0)]), ((0,30,177), &[(0,1,3),
  (0,3,0)]), ((0,30,178), &[(0,1,2), (0,3,9)]), ((0,30,179), &[(0,1,3),
  (0,3,9)]), ((0,30,180), &[(0,1,2), (0,3,3)]), ((0,30,181), &[(0,1,3),
  (0,3,3)]), ((0,30,182), &[(0,30,160), (0,3,6)]), ((0,30,183), &[(0,30,161),
  (0,3,6)]), ((0,30,184), &[(0,0,69), (0,3,35)]), ((0,30,185), &[(0,0,101),
  (0,3,35)]), ((0,30,186), &[(0,0,69), (0,3,9)]), ((0,30,187), &[(0,0,101),
  (0,3,9)]), ((0,30,188), &[(0,0,69), (0,3,3)]), ((0,30,189), &[(0,0,101),
  (0,3,3)]), ((0,30,190), &[(0,0,202), (0,3,1)]), ((0,30,191), &[(0,0,234),
  (0,3,1)]), ((0,30,192), &[(0,0,202), (0,3,0)]), ((0,30,193), &[(0,0,234),
  (0,3,0)]), ((0,30,194), &[(0,0,202), (0,3,9)]), ((0,30,195), &[(0,0,234),
  (0,3,9)]), ((0,30,196), &[(0,0,202), (0,3,3)]), ((0,30,197), &[(0,0,234),
  (0,3,3)]), ((0,30,198), &[(0,30,184), (0,3,2)]), ((0,30,199), &[(0,30,185),
  (0,3,2)]), ((0,30,200), &[(0,0,73), (0,3,9)]), ((0,30,201), &[(0,0,105),
  (0,3,9)]), ((0,30,202), &[(0,0,73), (0,3,35)]), ((0,30,203), &[(0,0,105),
  (0,3,35)]), ((0,30,204), &[(0,0,79), (0,3,35)]), ((0,30,205), &[(0,0,111),
  (0,3,35)]), ((0,30,206), &[(0,0,79), (0,3,9)]), ((0,30,207), &[(0,0,111),
  (0,3,9)]), ((0,30,208), &[(0,0,212), (0,3,1)]), ((0,30,209), &[(0,0,244),
  (0,3,1)]), ((0,30,210), &[(0,0,212), (0,3,0)]), ((0,30,211), &[(0,0,244),
  (0,3,0)]), ((0,30,212), &[(0,0,212), (0,3,9)]), ((0,30,213), &[(0,0,244),
  (0,3,9)]), ((0,30,214), &[(0,0,212), (0,3,3)]), ((0,30,215), &[(0,0,244),
  (0,3,3)]), ((0,30,216), &[(0,30,204), (0,3,2)]), ((0,30,217), &[(0,30,205),
  (0,3,2)]), ((0,30,218), &[(0,1,160), (0,3,1)]), ((0,30,219), &[(0,1,161),
  (0,3,1)]), ((0,30,220), &[(0,1,160), (0,3,0)]), ((0,30,221), &[(0,1,161),
  (0,3,0)]), ((0,30,222), &[(0,1,160), (0,3,9)]), ((0,30,223), &[(0,1,161),
  (0,3,9)]), ((0,30,224), &[(0,1,160), (0,3,3)]), ((0,30,225), &[(0,1,161),
  (0,3,3)]), ((0,30,226), &[(0,1,160), (0,3,35)]), ((0,30,227), &[(0,1,161),
  (0,3,35)]), ((0,30,228), &[(0,0,85), (0,3,35)]), ((0,30,229), &[(0,0,117),
  (0,3,35)]), ((0,30,230), &[(0,0,85), (0,3,9)]), ((0,30,231), &[(0,0,117),
  (0,3,9)]), ((0,30,232), &[(0,1,175), (0,3,1)]), ((0,30,233), &[(0,1,176),
  (0,3,1)]), ((0,30,234), &[(0,1,175), (0,3,0)]), ((0,30,235), &[(0,1,176),
  (0,3,0)]), ((0,30,236), &[(0,1,175), (0,3,9)]), ((0,30,237), &[(0,1,176),
  (0,3,9)]), ((0,30,238), &[(0,1,175), (0,3,3)]), ((0,30,239), &[(0,1,176),
  (0,3,3)]), ((0,30,240), &[(0,1,175), (0,3,35)]), ((0,30,241), &[(0,1,176),
  (0,3,35)]), ((0,30,242), &[(0,0,89), (0,3,0)]), ((0,30,243), &[(0,0,121),
  (0,3,0)]), ((0,30,244), &[(0,0,89), (0,3,35)]), ((0,30,245), &[(0,0,121),
  (0,3,35)]), ((0,30,246), &[(0,0,89), (0,3,9)]), ((0,30,247), &[(0,0,121),
  (0,3,9)]), ((0,30,248), &[(0,0,89), (0,3,3)]), ((0,30,249), &[(0,0,121),
  (0,3,3)]), ((0,31,0), &[(0,3,177), (0,3,19)]), ((0,31,1), &[(0,3,177),
  (0,3,20)]), ((0,31,2), &[(0,31,0), (0,3,0)]), ((0,31,3), &[(0,31,1),
  (0,3,0)]), ((0,31,4), &[(0,31,0), (0,3,1)]), ((0,31,5), &[(0,31,1), (0,3,1)]),
  ((0,31,6), &[(0,31,0), (0,3,66)]), ((0,31,7), &[(0,31,1), (0,3,66)]),
  ((0,31,8), &[(0,3,145), (0,3,19)]), ((0,31,9), &[(0,3,145), (0,3,20)]),
  ((0,31,10), &[(0,31,8), (0,3,0)]), ((0,31,11), &[(0,31,9), (0,3,0)]),
  ((0,31,12), &[(0,31,8), (0,3,1)]), ((0,31,13), &[(0,31,9), (0,3,1)]),
  ((0,31,14), &[(0,31,8), (0,3,66)]), ((0,31,15), &[(0,31,9), (0,3,66)]),
  ((0,31,16), &[(0,3,181), (0,3,19)]), ((0,31,17), &[(0,3,181), (0,3,20)]),
  ((0,31,18), &[(0,31,16), (0,3,0)]), ((0,31,19), &[(0,31,17), (0,3,0)]),
  ((0,31,20), &[(0,31,16), (0,3,1)]), ((0,31,21), &[(0,31,17), (0,3,1)]),
  ((0,31,24), &[(0,3,149), (0,3,19)]), ((0,31,25), &[(0,3,149), (0,3,20)]),
  ((0,31,26), &[(0,31,24), (0,3,0)]), ((0,31,27), &[(0,31,25), (0,3,0)]),
  ((0,31,28), &[(0,31,24), (0,3,1)]), ((0,31,29), &[(0,31,25), (0,3,1)]),
  ((0,31,32), &[(0,3,183), (0,3,19)]), ((0,31,33), &[(0,3,183), (0,3,20)]),
  ((0,31,34), &[(0,31,32), (0,3,0)]), ((0,31,35), &[(0,31,33), (0,3,0)]),
  ((0,31,36), &[(0,31,32), (0,3,1)]), ((0,31,37), &[(0,31,33), (0,3,1)]),
  ((0,31,38), &[(0,31,32), (0,3,66)]), ((0,31,39), &[(0,31,33), (0,3,66)]),
  ((0,31,40), &[(0,3,151), (0,3,19)]), ((0,31,41), &[(0,3,151), (0,3,20)]),
  ((0,31,42), &[(0,31,40), (0,3,0)]), ((0,31,43), &[(0,31,41), (0,3,0)]),
  ((0,31,44), &[(0,31,40), (0,3,1)]), ((0,31,45), &[(0,31,41), (0,3,1)]),
  ((0,31,46), &[(0,31,40), (0,3,66)]), ((0,31,47), &[(0,31,41), (0,3,66)]),
  ((0,31,48), &[(0,3,185), (0,3,19)]), ((0,31,49), &[(0,3,185), (0,3,20)]),
  ((0,31,50), &[(0,31,48), (0,3,0)]), ((0,31,51), &[(0,31,49), (0,3,0)]),
  ((0,31,52), &[(0,31,48), (0,3,1)]), ((0,31,53), &[(0,31,49), (0,3,1)]),
  ((0,31,54), &[(0,31,48), (0,3,66)]), ((0,31,55), &[(0,31,49), (0,3,66)]),
  ((0,31,56), &[(0,3,153), (0,3,19)]), ((0,31,57), &[(0,3,153), (0,3,20)]),
  ((0,31,58), &[(0,31,56), (0,3,0)]), ((0,31,59), &[(0,31,57), (0,3,0)]),
  ((0,31,60), &[(0,31,56), (0,3,1)]), ((0,31,61), &[(0,31,57), (0,3,1)]),
  ((0,31,62), &[(0,31,56), (0,3,66)]), ((0,31,63), &[(0,31,57), (0,3,66)]),
  ((0,31,64), &[(0,3,191), (0,3,19)]), ((0,31,65), &[(0,3,191), (0,3,20)]),
  ((0,31,66), &[(0,31,64), (0,3,0)]), ((0,31,67), &[(0,31,65), (0,3,0)]),
  ((0,31,68), &[(0,31,64), (0,3,1)]), ((0,31,69), &[(0,31,65), (0,3,1)]),
  ((0,31,72), &[(0,3,159), (0,3,19)]), ((0,31,73), &[(0,3,159), (0,3,20)]),
  ((0,31,74), &[(0,31,72), (0,3,0)]), ((0,31,75), &[(0,31,73), (0,3,0)]),
  ((0,31,76), &[(0,31,72), (0,3,1)]), ((0,31,77), &[(0,31,73), (0,3,1)]),
  ((0,31,80), &[(0,3,197), (0,3,19)]), ((0,31,81), &[(0,3,197), (0,3,20)]),
  ((0,31,82), &[(0,31,80), (0,3,0)]), ((0,31,83), &[(0,31,81), (0,3,0)]),
  ((0,31,84), &[(0,31,80), (0,3,1)]), ((0,31,85), &[(0,31,81), (0,3,1)]),
  ((0,31,86), &[(0,31,80), (0,3,66)]), ((0,31,87), &[(0,31,81), (0,3,66)]),
  ((0,31,89), &[(0,3,165), (0,3,20)]), ((0,31,91), &[(0,31,89), (0,3,0)]),
  ((0,31,93), &[(0,31,89), (0,3,1)]), ((0,31,95), &[(0,31,89), (0,3,66)]),
  ((0,31,96), &[(0,3,201), (0,3,19)]), ((0,31,97), &[(0,3,201), (0,3,20)]),
  ((0,31,98), &[(0,31,96), (0,3,0)]), ((0,31,99), &[(0,31,97), (0,3,0)]),
  ((0,31,100), &[(0,31,96), (0,3,1)]), ((0,31,101), &[(0,31,97), (0,3,1)]),
  ((0,31,102), &[(0,31,96), (0,3,66)]), ((0,31,103), &[(0,31,97), (0,3,66)]),
  ((0,31,104), &[(0,3,169), (0,3,19)]), ((0,31,105), &[(0,3,169), (0,3,20)]),
  ((0,31,106), &[(0,31,104), (0,3,0)]), ((0,31,107), &[(0,31,105), (0,3,0)]),
  ((0,31,108), &[(0,31,104), (0,3,1)]), ((0,31,109), &[(0,31,105), (0,3,1)]),
  ((0,31,110), &[(0,31,104), (0,3,66)]), ((0,31,111), &[(0,31,105), (0,3,66)]),
  ((0,31,112), &[(0,3,177), (0,3,0)]), ((0,31,113), &[(0,3,172)]), ((0,31,114),
  &[(0,3,181), (0,3,0)]), ((0,31,115), &[(0,3,173)]), ((0,31,116), &[(0,3,183),
  (0,3,0)]), ((0,31,117), &[(0,3,174)]), ((0,31,118), &[(0,3,185), (0,3,0)]),
  ((0,31,119), &[(0,3,175)]), ((0,31,120), &[(0,3,191), (0,3,0)]), ((0,31,121),
  &[(0,3,204)]), ((0,31,122), &[(0,3,197), (0,3,0)]), ((0,31,123),
  &[(0,3,205)]), ((0,31,124), &[(0,3,201), (0,3,0)]), ((0,31,125),
  &[(0,3,206)]), ((0,31,128), &[(0,31,0), (0,3,69)]), ((0,31,129), &[(0,31,1),
  (0,3,69)]), ((0,31,130), &[(0,31,2), (0,3,69)]), ((0,31,131), &[(0,31,3),
  (0,3,69)]), ((0,31,132), &[(0,31,4), (0,3,69)]), ((0,31,133), &[(0,31,5),
  (0,3,69)]), ((0,31,134), &[(0,31,6), (0,3,69)]), ((0,31,135), &[(0,31,7),
  (0,3,69)]), ((0,31,136), &[(0,31,8), (0,3,69)]), ((0,31,137), &[(0,31,9),
  (0,3,69)]), ((0,31,138), &[(0,31,10), (0,3,69)]), ((0,31,139), &[(0,31,11),
  (0,3,69)]), ((0,31,140), &[(0,31,12), (0,3,69)]), ((0,31,141), &[(0,31,13),
  (0,3,69)]), ((0,31,142), &[(0,31,14), (0,3,69)]), ((0,31,143), &[(0,31,15),
  (0,3,69)]), ((0,31,144), &[(0,31,32), (0,3,69)]), ((0,31,145), &[(0,31,33),
  (0,3,69)]), ((0,31,146), &[(0,31,34), (0,3,69)]), ((0,31,147), &[(0,31,35),
  (0,3,69)]), ((0,31,148), &[(0,31,36), (0,3,69)]), ((0,31,149), &[(0,31,37),
  (0,3,69)]), ((0,31,150), &[(0,31,38), (0,3,69)]), ((0,31,151), &[(0,31,39),
  (0,3,69)]), ((0,31,152), &[(0,31,40), (0,3,69)]), ((0,31,153), &[(0,31,41),
  (0,3,69)]), ((0,31,154), &[(0,31,42), (0,3,69)]), ((0,31,155), &[(0,31,43),
  (0,3,69)]), ((0,31,156), &[(0,31,44), (0,3,69)]), ((0,31,157), &[(0,31,45),
  (0,3,69)]), ((0,31,158), &[(0,31,46), (0,3,69)]), ((0,31,159), &[(0,31,47),
  (0,3,69)]), ((0,31,160), &[(0,31,96), (0,3,69)]), ((0,31,161), &[(0,31,97),
  (0,3,69)]), ((0,31,162), &[(0,31,98), (0,3,69)]), ((0,31,163), &[(0,31,99),
  (0,3,69)]), ((0,31,164), &[(0,31,100), (0,3,69)]), ((0,31,165), &[(0,31,101),
  (0,3,69)]), ((0,31,166), &[(0,31,102), (0,3,69)]), ((0,31,167), &[(0,31,103),
  (0,3,69)]), ((0,31,168), &[(0,31,104), (0,3,69)]), ((0,31,169), &[(0,31,105),
  (0,3,69)]), ((0,31,170), &[(0,31,106), (0,3,69)]), ((0,31,171), &[(0,31,107),
  (0,3,69)]), ((0,31,172), &[(0,31,108), (0,3,69)]), ((0,31,173), &[(0,31,109),
  (0,3,69)]), ((0,31,174), &[(0,31,110), (0,3,69)]), ((0,31,175), &[(0,31,111),
  (0,3,69)]), ((0,31,176), &[(0,3,177), (0,3,6)]), ((0,31,177), &[(0,3,177),
  (0,3,4)]), ((0,31,178), &[(0,31,112), (0,3,69)]), ((0,31,179), &[(0,3,177),
  (0,3,69)]), ((0,31,180), &[(0,3,172), (0,3,69)]), ((0,31,182), &[(0,3,177),
  (0,3,66)]), ((0,31,183), &[(0,31,182), (0,3,69)]), ((0,31,184), &[(0,3,145),
  (0,3,6)]), ((0,31,185), &[(0,3,145), (0,3,4)]), ((0,31,186), &[(0,3,145),
  (0,3,0)]), ((0,31,187), &[(0,3,134)]), ((0,31,188), &[(0,3,145), (0,3,69)]),
  ((0,31,189), &[(0,0,32), (0,3,19)]), ((0,31,190), &[(0,3,185)]), ((0,31,191),
  &[(0,0,32), (0,3,19)]), ((0,31,192), &[(0,0,32), (0,3,66)]), ((0,31,193),
  &[(0,0,168), (0,3,66)]), ((0,31,194), &[(0,31,116), (0,3,69)]), ((0,31,195),
  &[(0,3,183), (0,3,69)]), ((0,31,196), &[(0,3,174), (0,3,69)]), ((0,31,198),
  &[(0,3,183), (0,3,66)]), ((0,31,199), &[(0,31,198), (0,3,69)]), ((0,31,200),
  &[(0,3,149), (0,3,0)]), ((0,31,201), &[(0,3,136)]), ((0,31,202), &[(0,3,151),
  (0,3,0)]), ((0,31,203), &[(0,3,137)]), ((0,31,204), &[(0,3,151), (0,3,69)]),
  ((0,31,205), &[(0,31,191), (0,3,0)]), ((0,31,206), &[(0,31,191), (0,3,1)]),
  ((0,31,207), &[(0,31,191), (0,3,66)]), ((0,31,208), &[(0,3,185), (0,3,6)]),
  ((0,31,209), &[(0,3,185), (0,3,4)]), ((0,31,210), &[(0,3,202), (0,3,0)]),
  ((0,31,211), &[(0,3,144)]), ((0,31,214), &[(0,3,185), (0,3,66)]), ((0,31,215),
  &[(0,3,202), (0,3,66)]), ((0,31,216), &[(0,3,153), (0,3,6)]), ((0,31,217),
  &[(0,3,153), (0,3,4)]), ((0,31,218), &[(0,3,153), (0,3,0)]), ((0,31,219),
  &[(0,3,138)]), ((0,31,221), &[(0,31,254), (0,3,0)]), ((0,31,222),
  &[(0,31,254), (0,3,1)]), ((0,31,223), &[(0,31,254), (0,3,66)]), ((0,31,224),
  &[(0,3,197), (0,3,6)]), ((0,31,225), &[(0,3,197), (0,3,4)]), ((0,31,226),
  &[(0,3,203), (0,3,0)]), ((0,31,227), &[(0,3,176)]), ((0,31,228), &[(0,3,193),
  (0,3,19)]), ((0,31,229), &[(0,3,193), (0,3,20)]), ((0,31,230), &[(0,3,197),
  (0,3,66)]), ((0,31,231), &[(0,3,203), (0,3,66)]), ((0,31,232), &[(0,3,165),
  (0,3,6)]), ((0,31,233), &[(0,3,165), (0,3,4)]), ((0,31,234), &[(0,3,165),
  (0,3,0)]), ((0,31,235), &[(0,3,142)]), ((0,31,236), &[(0,3,161), (0,3,20)]),
  ((0,31,237), &[(0,0,168), (0,3,0)]), ((0,31,238), &[(0,3,133)]), ((0,31,239),
  &[(0,0,96)]), ((0,31,242), &[(0,31,124), (0,3,69)]), ((0,31,243), &[(0,3,201),
  (0,3,69)]), ((0,31,244), &[(0,3,206), (0,3,69)]), ((0,31,246), &[(0,3,201),
  (0,3,66)]), ((0,31,247), &[(0,31,246), (0,3,69)]), ((0,31,248), &[(0,3,159),
  (0,3,0)]), ((0,31,249), &[(0,3,140)]), ((0,31,250), &[(0,3,169), (0,3,0)]),
  ((0,31,251), &[(0,3,143)]), ((0,31,252), &[(0,3,169), (0,3,69)]), ((0,31,253),
  &[(0,0,180)]), ((0,31,254), &[(0,0,32), (0,3,20)]), ((0,32,0), &[(0,32,2)]),
  ((0,32,1), &[(0,32,3)]), ((0,32,2), &[(0,0,32)]), ((0,32,3), &[(0,0,32)]),
  ((0,32,4), &[(0,0,32)]), ((0,32,5), &[(0,0,32)]), ((0,32,6), &[(0,0,32)]),
  ((0,32,7), &[(0,0,32)]), ((0,32,8), &[(0,0,32)]), ((0,32,9), &[(0,0,32)]),
  ((0,32,10), &[(0,0,32)]), ((0,32,17), &[(0,32,16)]), ((0,32,23), &[(0,0,32),
  (0,3,51)]), ((0,32,36), &[(0,0,46)]), ((0,32,37), &[(0,0,46), (0,0,46)]),
  ((0,32,38), &[(0,0,46), (0,0,46), (0,0,46)]), ((0,32,47), &[(0,0,32)]),
  ((0,32,51), &[(0,32,50), (0,32,50)]), ((0,32,52), &[(0,32,50), (0,32,50),
  (0,32,50)]), ((0,32,54), &[(0,32,53), (0,32,53)]), ((0,32,55), &[(0,32,53),
  (0,32,53), (0,32,53)]), ((0,32,60), &[(0,0,33), (0,0,33)]), ((0,32,62),
  &[(0,0,32), (0,3,5)]), ((0,32,71), &[(0,0,63), (0,0,63)]), ((0,32,72),
  &[(0,0,63), (0,0,33)]), ((0,32,73), &[(0,0,33), (0,0,63)]), ((0,32,87),
  &[(0,32,50), (0,32,50), (0,32,50), (0,32,50)]), ((0,32,95), &[(0,0,32)]),
  ((0,32,112), &[(0,0,48)]), ((0,32,113), &[(0,0,105)]), ((0,32,116),
  &[(0,0,52)]), ((0,32,117), &[(0,0,53)]), ((0,32,118), &[(0,0,54)]),
  ((0,32,119), &[(0,0,55)]), ((0,32,120), &[(0,0,56)]), ((0,32,121),
  &[(0,0,57)]), ((0,32,122), &[(0,0,43)]), ((0,32,123), &[(0,34,18)]),
  ((0,32,124), &[(0,0,61)]), ((0,32,125), &[(0,0,40)]), ((0,32,126),
  &[(0,0,41)]), ((0,32,127), &[(0,0,110)]), ((0,32,128), &[(0,0,48)]),
  ((0,32,129), &[(0,0,49)]), ((0,32,130), &[(0,0,50)]), ((0,32,131),
  &[(0,0,51)]), ((0,32,132), &[(0,0,52)]), ((0,32,133), &[(0,0,53)]),
  ((0,32,134), &[(0,0,54)]), ((0,32,135), &[(0,0,55)]), ((0,32,136),
  &[(0,0,56)]), ((0,32,137), &[(0,0,57)]), ((0,32,138), &[(0,0,43)]),
  ((0,32,139), &[(0,34,18)]), ((0,32,140), &[(0,0,61)]), ((0,32,141),
  &[(0,0,40)]), ((0,32,142), &[(0,0,41)]), ((0,32,144), &[(0,0,97)]),
  ((0,32,145), &[(0,0,101)]), ((0,32,146), &[(0,0,111)]), ((0,32,147),
  &[(0,0,120)]), ((0,32,148), &[(0,2,89)]), ((0,32,149), &[(0,0,104)]),
  ((0,32,150), &[(0,0,107)]), ((0,32,151), &[(0,0,108)]), ((0,32,152),
  &[(0,0,109)]), ((0,32,153), &[(0,0,110)]), ((0,32,154), &[(0,0,112)]),
  ((0,32,155), &[(0,0,115)]), ((0,32,156), &[(0,0,116)]), ((0,32,168),
  &[(0,0,82), (0,0,115)]), ((0,33,0), &[(0,0,97), (0,0,47), (0,0,99)]),
  ((0,33,1), &[(0,0,97), (0,0,47), (0,0,115)]), ((0,33,2), &[(0,0,67)]),
  ((0,33,3), &[(0,0,176), (0,0,67)]), ((0,33,5), &[(0,0,99), (0,0,47),
  (0,0,111)]), ((0,33,6), &[(0,0,99), (0,0,47), (0,0,117)]), ((0,33,7),
  &[(0,1,144)]), ((0,33,9), &[(0,0,176), (0,0,70)]), ((0,33,10), &[(0,0,103)]),
  ((0,33,11), &[(0,0,72)]), ((0,33,12), &[(0,0,72)]), ((0,33,13), &[(0,0,72)]),
  ((0,33,14), &[(0,0,104)]), ((0,33,15), &[(0,1,39)]), ((0,33,16), &[(0,0,73)]),
  ((0,33,17), &[(0,0,73)]), ((0,33,18), &[(0,0,76)]), ((0,33,19), &[(0,0,108)]),
  ((0,33,21), &[(0,0,78)]), ((0,33,22), &[(0,0,78), (0,0,111)]), ((0,33,25),
  &[(0,0,80)]), ((0,33,26), &[(0,0,81)]), ((0,33,27), &[(0,0,82)]), ((0,33,28),
  &[(0,0,82)]), ((0,33,29), &[(0,0,82)]), ((0,33,32), &[(0,0,83), (0,0,77)]),
  ((0,33,33), &[(0,0,84), (0,0,69), (0,0,76)]), ((0,33,34), &[(0,0,84),
  (0,0,77)]), ((0,33,36), &[(0,0,90)]), ((0,33,38), &[(0,3,169)]), ((0,33,40),
  &[(0,0,90)]), ((0,33,42), &[(0,0,75)]), ((0,33,43), &[(0,0,197)]), ((0,33,44),
  &[(0,0,66)]), ((0,33,45), &[(0,0,67)]), ((0,33,47), &[(0,0,101)]), ((0,33,48),
  &[(0,0,69)]), ((0,33,49), &[(0,0,70)]), ((0,33,51), &[(0,0,77)]), ((0,33,52),
  &[(0,0,111)]), ((0,33,53), &[(0,5,208)]), ((0,33,54), &[(0,5,209)]),
  ((0,33,55), &[(0,5,210)]), ((0,33,56), &[(0,5,211)]), ((0,33,57),
  &[(0,0,105)]), ((0,33,59), &[(0,0,70), (0,0,65), (0,0,88)]), ((0,33,60),
  &[(0,3,192)]), ((0,33,61), &[(0,3,179)]), ((0,33,62), &[(0,3,147)]),
  ((0,33,63), &[(0,3,160)]), ((0,33,64), &[(0,34,17)]), ((0,33,69),
  &[(0,0,68)]), ((0,33,70), &[(0,0,100)]), ((0,33,71), &[(0,0,101)]),
  ((0,33,72), &[(0,0,105)]), ((0,33,73), &[(0,0,106)]), ((0,33,80), &[(0,0,49),
  (0,32,68), (0,0,55)]), ((0,33,81), &[(0,0,49), (0,32,68), (0,0,57)]),
  ((0,33,82), &[(0,0,49), (0,32,68), (0,0,49), (0,0,48)]), ((0,33,83),
  &[(0,0,49), (0,32,68), (0,0,51)]), ((0,33,84), &[(0,0,50), (0,32,68),
  (0,0,51)]), ((0,33,85), &[(0,0,49), (0,32,68), (0,0,53)]), ((0,33,86),
  &[(0,0,50), (0,32,68), (0,0,53)]), ((0,33,87), &[(0,0,51), (0,32,68),
  (0,0,53)]), ((0,33,88), &[(0,0,52), (0,32,68), (0,0,53)]), ((0,33,89),
  &[(0,0,49), (0,32,68), (0,0,54)]), ((0,33,90), &[(0,0,53), (0,32,68),
  (0,0,54)]), ((0,33,91), &[(0,0,49), (0,32,68), (0,0,56)]), ((0,33,92),
  &[(0,0,51), (0,32,68), (0,0,56)]), ((0,33,93), &[(0,0,53), (0,32,68),
  (0,0,56)]), ((0,33,94), &[(0,0,55), (0,32,68), (0,0,56)]), ((0,33,95),
  &[(0,0,49), (0,32,68)]), ((0,33,96), &[(0,0,73)]), ((0,33,97), &[(0,0,73),
  (0,0,73)]), ((0,33,98), &[(0,0,73), (0,0,73), (0,0,73)]), ((0,33,99),
  &[(0,0,73), (0,0,86)]), ((0,33,100), &[(0,0,86)]), ((0,33,101), &[(0,0,86),
  (0,0,73)]), ((0,33,102), &[(0,0,86), (0,0,73), (0,0,73)]), ((0,33,103),
  &[(0,0,86), (0,0,73), (0,0,73), (0,0,73)]), ((0,33,104), &[(0,0,73),
  (0,0,88)]), ((0,33,105), &[(0,0,88)]), ((0,33,106), &[(0,0,88), (0,0,73)]),
  ((0,33,107), &[(0,0,88), (0,0,73), (0,0,73)]), ((0,33,108), &[(0,0,76)]),
  ((0,33,109), &[(0,0,67)]), ((0,33,110), &[(0,0,68)]), ((0,33,111),
  &[(0,0,77)]), ((0,33,112), &[(0,0,105)]), ((0,33,113), &[(0,0,105),
  (0,0,105)]), ((0,33,114), &[(0,0,105), (0,0,105), (0,0,105)]), ((0,33,115),
  &[(0,0,105), (0,0,118)]), ((0,33,116), &[(0,0,118)]), ((0,33,117),
  &[(0,0,118), (0,0,105)]), ((0,33,118), &[(0,0,118), (0,0,105), (0,0,105)]),
  ((0,33,119), &[(0,0,118), (0,0,105), (0,0,105), (0,0,105)]), ((0,33,120),
  &[(0,0,105), (0,0,120)]), ((0,33,121), &[(0,0,120)]), ((0,33,122),
  &[(0,0,120), (0,0,105)]), ((0,33,123), &[(0,0,120), (0,0,105), (0,0,105)]),
  ((0,33,124), &[(0,0,108)]), ((0,33,125), &[(0,0,99)]), ((0,33,126),
  &[(0,0,100)]), ((0,33,127), &[(0,0,109)]), ((0,33,137), &[(0,0,48), (0,32,68),
  (0,0,51)]), ((0,33,154), &[(0,33,144), (0,3,56)]), ((0,33,155), &[(0,33,146),
  (0,3,56)]), ((0,33,174), &[(0,33,148), (0,3,56)]), ((0,33,205), &[(0,33,208),
  (0,3,56)]), ((0,33,206), &[(0,33,212), (0,3,56)]), ((0,33,207), &[(0,33,210),
  (0,3,56)]), ((0,34,4), &[(0,34,3), (0,3,56)]), ((0,34,9), &[(0,34,8),
  (0,3,56)]), ((0,34,12), &[(0,34,11), (0,3,56)]), ((0,34,36), &[(0,34,35),
  (0,3,56)]), ((0,34,38), &[(0,34,37), (0,3,56)]), ((0,34,44), &[(0,34,43),
  (0,34,43)]), ((0,34,45), &[(0,34,43), (0,34,43), (0,34,43)]), ((0,34,47),
  &[(0,34,46), (0,34,46)]), ((0,34,48), &[(0,34,46), (0,34,46), (0,34,46)]),
  ((0,34,65), &[(0,34,60), (0,3,56)]), ((0,34,68), &[(0,34,67), (0,3,56)]),
  ((0,34,71), &[(0,34,69), (0,3,56)]), ((0,34,73), &[(0,34,72), (0,3,56)]),
  ((0,34,96), &[(0,0,61), (0,3,56)]), ((0,34,98), &[(0,34,97), (0,3,56)]),
  ((0,34,109), &[(0,34,77), (0,3,56)]), ((0,34,110), &[(0,0,60), (0,3,56)]),
  ((0,34,111), &[(0,0,62), (0,3,56)]), ((0,34,112), &[(0,34,100), (0,3,56)]),
  ((0,34,113), &[(0,34,101), (0,3,56)]), ((0,34,116), &[(0,34,114), (0,3,56)]),
  ((0,34,117), &[(0,34,115), (0,3,56)]), ((0,34,120), &[(0,34,118), (0,3,56)]),
  ((0,34,121), &[(0,34,119), (0,3,56)]), ((0,34,128), &[(0,34,122), (0,3,56)]),
  ((0,34,129), &[(0,34,123), (0,3,56)]), ((0,34,132), &[(0,34,130), (0,3,56)]),
  ((0,34,133), &[(0,34,131), (0,3,56)]), ((0,34,136), &[(0,34,134), (0,3,56)]),
  ((0,34,137), &[(0,34,135), (0,3,56)]), ((0,34,172), &[(0,34,162), (0,3,56)]),
  ((0,34,173), &[(0,34,168), (0,3,56)]), ((0,34,174), &[(0,34,169), (0,3,56)]),
  ((0,34,175), &[(0,34,171), (0,3,56)]), ((0,34,224), &[(0,34,124), (0,3,56)]),
  ((0,34,225), &[(0,34,125), (0,3,56)]), ((0,34,226), &[(0,34,145), (0,3,56)]),
  ((0,34,227), &[(0,34,146), (0,3,56)]), ((0,34,234), &[(0,34,178), (0,3,56)]),
  ((0,34,235), &[(0,34,179), (0,3,56)]), ((0,34,236), &[(0,34,180), (0,3,56)]),
  ((0,34,237), &[(0,34,181), (0,3,56)]), ((0,35,41), &[(0,48,8)]), ((0,35,42),
  &[(0,48,9)]), ((0,36,96), &[(0,0,49)]), ((0,36,97), &[(0,0,50)]), ((0,36,98),
  &[(0,0,51)]), ((0,36,99), &[(0,0,52)]), ((0,36,100), &[(0,0,53)]),
  ((0,36,101), &[(0,0,54)]), ((0,36,102), &[(0,0,55)]), ((0,36,103),
  &[(0,0,56)]), ((0,36,104), &[(0,0,57)]), ((0,36,105), &[(0,0,49), (0,0,48)]),
  ((0,36,106), &[(0,0,49), (0,0,49)]), ((0,36,107), &[(0,0,49), (0,0,50)]),
  ((0,36,108), &[(0,0,49), (0,0,51)]), ((0,36,109), &[(0,0,49), (0,0,52)]),
  ((0,36,110), &[(0,0,49), (0,0,53)]), ((0,36,111), &[(0,0,49), (0,0,54)]),
  ((0,36,112), &[(0,0,49), (0,0,55)]), ((0,36,113), &[(0,0,49), (0,0,56)]),
  ((0,36,114), &[(0,0,49), (0,0,57)]), ((0,36,115), &[(0,0,50), (0,0,48)]),
  ((0,36,116), &[(0,0,40), (0,0,49), (0,0,41)]), ((0,36,117), &[(0,0,40),
  (0,0,50), (0,0,41)]), ((0,36,118), &[(0,0,40), (0,0,51), (0,0,41)]),
  ((0,36,119), &[(0,0,40), (0,0,52), (0,0,41)]), ((0,36,120), &[(0,0,40),
  (0,0,53), (0,0,41)]), ((0,36,121), &[(0,0,40), (0,0,54), (0,0,41)]),
  ((0,36,122), &[(0,0,40), (0,0,55), (0,0,41)]), ((0,36,123), &[(0,0,40),
  (0,0,56), (0,0,41)]), ((0,36,124), &[(0,0,40), (0,0,57), (0,0,41)]),
  ((0,36,125), &[(0,0,40), (0,0,49), (0,0,48), (0,0,41)]), ((0,36,126),
  &[(0,0,40), (0,0,49), (0,0,49), (0,0,41)]), ((0,36,127), &[(0,0,40), (0,0,49),
  (0,0,50), (0,0,41)]), ((0,36,128), &[(0,0,40), (0,0,49), (0,0,51), (0,0,41)]),
  ((0,36,129), &[(0,0,40), (0,0,49), (0,0,52), (0,0,41)]), ((0,36,130),
  &[(0,0,40), (0,0,49), (0,0,53), (0,0,41)]), ((0,36,131), &[(0,0,40), (0,0,49),
  (0,0,54), (0,0,41)]), ((0,36,132), &[(0,0,40), (0,0,49), (0,0,55), (0,0,41)]),
  ((0,36,133), &[(0,0,40), (0,0,49), (0,0,56), (0,0,41)]), ((0,36,134),
  &[(0,0,40), (0,0,49), (0,0,57), (0,0,41)]), ((0,36,135), &[(0,0,40), (0,0,50),
  (0,0,48), (0,0,41)]), ((0,36,136), &[(0,0,49), (0,0,46)]), ((0,36,137),
  &[(0,0,50), (0,0,46)]), ((0,36,138), &[(0,0,51), (0,0,46)]), ((0,36,139),
  &[(0,0,52), (0,0,46)]), ((0,36,140), &[(0,0,53), (0,0,46)]), ((0,36,141),
  &[(0,0,54), (0,0,46)]), ((0,36,142), &[(0,0,55), (0,0,46)]), ((0,36,143),
  &[(0,0,56), (0,0,46)]), ((0,36,144), &[(0,0,57), (0,0,46)]), ((0,36,145),
  &[(0,0,49), (0,0,48), (0,0,46)]), ((0,36,146), &[(0,0,49), (0,0,49),
  (0,0,46)]), ((0,36,147), &[(0,0,49), (0,0,50), (0,0,46)]), ((0,36,148),
  &[(0,0,49), (0,0,51), (0,0,46)]), ((0,36,149), &[(0,0,49), (0,0,52),
  (0,0,46)]), ((0,36,150), &[(0,0,49), (0,0,53), (0,0,46)]), ((0,36,151),
  &[(0,0,49), (0,0,54), (0,0,46)]), ((0,36,152), &[(0,0,49), (0,0,55),
  (0,0,46)]), ((0,36,153), &[(0,0,49), (0,0,56), (0,0,46)]), ((0,36,154),
  &[(0,0,49), (0,0,57), (0,0,46)]), ((0,36,155), &[(0,0,50), (0,0,48),
  (0,0,46)]), ((0,36,156), &[(0,0,40), (0,0,97), (0,0,41)]), ((0,36,157),
  &[(0,0,40), (0,0,98), (0,0,41)]), ((0,36,158), &[(0,0,40), (0,0,99),
  (0,0,41)]), ((0,36,159), &[(0,0,40), (0,0,100), (0,0,41)]), ((0,36,160),
  &[(0,0,40), (0,0,101), (0,0,41)]), ((0,36,161), &[(0,0,40), (0,0,102),
  (0,0,41)]), ((0,36,162), &[(0,0,40), (0,0,103), (0,0,41)]), ((0,36,163),
  &[(0,0,40), (0,0,104), (0,0,41)]), ((0,36,164), &[(0,0,40), (0,0,105),
  (0,0,41)]), ((0,36,165), &[(0,0,40), (0,0,106), (0,0,41)]), ((0,36,166),
  &[(0,0,40), (0,0,107), (0,0,41)]), ((0,36,167), &[(0,0,40), (0,0,108),
  (0,0,41)]), ((0,36,168), &[(0,0,40), (0,0,109), (0,0,41)]), ((0,36,169),
  &[(0,0,40), (0,0,110), (0,0,41)]), ((0,36,170), &[(0,0,40), (0,0,111),
  (0,0,41)]), ((0,36,171), &[(0,0,40), (0,0,112), (0,0,41)]), ((0,36,172),
  &[(0,0,40), (0,0,113), (0,0,41)]), ((0,36,173), &[(0,0,40), (0,0,114),
  (0,0,41)]), ((0,36,174), &[(0,0,40), (0,0,115), (0,0,41)]), ((0,36,175),
  &[(0,0,40), (0,0,116), (0,0,41)]), ((0,36,176), &[(0,0,40), (0,0,117),
  (0,0,41)]), ((0,36,177), &[(0,0,40), (0,0,118), (0,0,41)]), ((0,36,178),
  &[(0,0,40), (0,0,119), (0,0,41)]), ((0,36,179), &[(0,0,40), (0,0,120),
  (0,0,41)]), ((0,36,180), &[(0,0,40), (0,0,121), (0,0,41)]), ((0,36,181),
  &[(0,0,40), (0,0,122), (0,0,41)]), ((0,36,182), &[(0,0,65)]), ((0,36,183),
  &[(0,0,66)]), ((0,36,184), &[(0,0,67)]), ((0,36,185), &[(0,0,68)]),
  ((0,36,186), &[(0,0,69)]), ((0,36,187), &[(0,0,70)]), ((0,36,188),
  &[(0,0,71)]), ((0,36,189), &[(0,0,72)]), ((0,36,190), &[(0,0,73)]),
  ((0,36,191), &[(0,0,74)]), ((0,36,192), &[(0,0,75)]), ((0,36,193),
  &[(0,0,76)]), ((0,36,194), &[(0,0,77)]), ((0,36,195), &[(0,0,78)]),
  ((0,36,196), &[(0,0,79)]), ((0,36,197), &[(0,0,80)]), ((0,36,198),
  &[(0,0,81)]), ((0,36,199), &[(0,0,82)]), ((0,36,200), &[(0,0,83)]),
  ((0,36,201), &[(0,0,84)]), ((0,36,202), &[(0,0,85)]), ((0,36,203),
  &[(0,0,86)]), ((0,36,204), &[(0,0,87)]), ((0,36,205), &[(0,0,88)]),
  ((0,36,206), &[(0,0,89)]), ((0,36,207), &[(0,0,90)]), ((0,36,208),
  &[(0,0,97)]), ((0,36,209), &[(0,0,98)]), ((0,36,210), &[(0,0,99)]),
  ((0,36,211), &[(0,0,100)]), ((0,36,212), &[(0,0,101)]), ((0,36,213),
  &[(0,0,102)]), ((0,36,214), &[(0,0,103)]), ((0,36,215), &[(0,0,104)]),
  ((0,36,216), &[(0,0,105)]), ((0,36,217), &[(0,0,106)]), ((0,36,218),
  &[(0,0,107)]), ((0,36,219), &[(0,0,108)]), ((0,36,220), &[(0,0,109)]),
  ((0,36,221), &[(0,0,110)]), ((0,36,222), &[(0,0,111)]), ((0,36,223),
  &[(0,0,112)]), ((0,36,224), &[(0,0,113)]), ((0,36,225), &[(0,0,114)]),
  ((0,36,226), &[(0,0,115)]), ((0,36,227), &[(0,0,116)]), ((0,36,228),
  &[(0,0,117)]), ((0,36,229), &[(0,0,118)]), ((0,36,230), &[(0,0,119)]),
  ((0,36,231), &[(0,0,120)]), ((0,36,232), &[(0,0,121)]), ((0,36,233),
  &[(0,0,122)]), ((0,36,234), &[(0,0,48)]), ((0,42,12), &[(0,34,43), (0,34,43),
  (0,34,43), (0,34,43)]), ((0,42,116), &[(0,0,58), (0,0,58), (0,0,61)]),
  ((0,42,117), &[(0,0,61), (0,0,61)]), ((0,42,118), &[(0,0,61), (0,0,61),
  (0,0,61)]), ((0,42,220), &[(0,42,221), (0,3,56)]), ((0,44,124), &[(0,0,106)]),
  ((0,44,125), &[(0,0,86)]), ((0,45,111), &[(0,45,97)]), ((0,46,159),
  &[(0,107,205)]), ((0,46,243), &[(0,159,159)]), ((0,47,0), &[(0,78,0)]),
  ((0,47,1), &[(0,78,40)]), ((0,47,2), &[(0,78,54)]), ((0,47,3), &[(0,78,63)]),
  ((0,47,4), &[(0,78,89)]), ((0,47,5), &[(0,78,133)]), ((0,47,6),
  &[(0,78,140)]), ((0,47,7), &[(0,78,160)]), ((0,47,8), &[(0,78,186)]),
  ((0,47,9), &[(0,81,63)]), ((0,47,10), &[(0,81,101)]), ((0,47,11),
  &[(0,81,107)]), ((0,47,12), &[(0,81,130)]), ((0,47,13), &[(0,81,150)]),
  ((0,47,14), &[(0,81,171)]), ((0,47,15), &[(0,81,224)]), ((0,47,16),
  &[(0,81,245)]), ((0,47,17), &[(0,82,0)]), ((0,47,18), &[(0,82,155)]),
  ((0,47,19), &[(0,82,249)]), ((0,47,20), &[(0,83,21)]), ((0,47,21),
  &[(0,83,26)]), ((0,47,22), &[(0,83,56)]), ((0,47,23), &[(0,83,65)]),
  ((0,47,24), &[(0,83,92)]), ((0,47,25), &[(0,83,105)]), ((0,47,26),
  &[(0,83,130)]), ((0,47,27), &[(0,83,182)]), ((0,47,28), &[(0,83,200)]),
  ((0,47,29), &[(0,83,227)]), ((0,47,30), &[(0,86,215)]), ((0,47,31),
  &[(0,87,31)]), ((0,47,32), &[(0,88,235)]), ((0,47,33), &[(0,89,2)]),
  ((0,47,34), &[(0,89,10)]), ((0,47,35), &[(0,89,21)]), ((0,47,36),
  &[(0,89,39)]), ((0,47,37), &[(0,89,115)]), ((0,47,38), &[(0,91,80)]),
  ((0,47,39), &[(0,91,128)]), ((0,47,40), &[(0,91,248)]), ((0,47,41),
  &[(0,92,15)]), ((0,47,42), &[(0,92,34)]), ((0,47,43), &[(0,92,56)]),
  ((0,47,44), &[(0,92,110)]), ((0,47,45), &[(0,92,113)]), ((0,47,46),
  &[(0,93,219)]), ((0,47,47), &[(0,93,229)]), ((0,47,48), &[(0,93,241)]),
  ((0,47,49), &[(0,93,254)]), ((0,47,50), &[(0,94,114)]), ((0,47,51),
  &[(0,94,122)]), ((0,47,52), &[(0,94,127)]), ((0,47,53), &[(0,94,244)]),
  ((0,47,54), &[(0,94,254)]), ((0,47,55), &[(0,95,11)]), ((0,47,56),
  &[(0,95,19)]), ((0,47,57), &[(0,95,80)]), ((0,47,58), &[(0,95,97)]),
  ((0,47,59), &[(0,95,115)]), ((0,47,60), &[(0,95,195)]), ((0,47,61),
  &[(0,98,8)]), ((0,47,62), &[(0,98,54)]), ((0,47,63), &[(0,98,75)]),
  ((0,47,64), &[(0,101,47)]), ((0,47,65), &[(0,101,52)]), ((0,47,66),
  &[(0,101,135)]), ((0,47,67), &[(0,101,151)]), ((0,47,68), &[(0,101,164)]),
  ((0,47,69), &[(0,101,185)]), ((0,47,70), &[(0,101,224)]), ((0,47,71),
  &[(0,101,229)]), ((0,47,72), &[(0,102,240)]), ((0,47,73), &[(0,103,8)]),
  ((0,47,74), &[(0,103,40)]), ((0,47,75), &[(0,107,32)]), ((0,47,76),
  &[(0,107,98)]), ((0,47,77), &[(0,107,121)]), ((0,47,78), &[(0,107,179)]),
  ((0,47,79), &[(0,107,203)]), ((0,47,80), &[(0,107,212)]), ((0,47,81),
  &[(0,107,219)]), ((0,47,82), &[(0,108,15)]), ((0,47,83), &[(0,108,20)]),
  ((0,47,84), &[(0,108,52)]), ((0,47,85), &[(0,112,107)]), ((0,47,86),
  &[(0,114,42)]), ((0,47,87), &[(0,114,54)]), ((0,47,88), &[(0,114,59)]),
  ((0,47,89), &[(0,114,63)]), ((0,47,90), &[(0,114,71)]), ((0,47,91),
  &[(0,114,89)]), ((0,47,92), &[(0,114,91)]), ((0,47,93), &[(0,114,172)]),
  ((0,47,94), &[(0,115,132)]), ((0,47,95), &[(0,115,137)]), ((0,47,96),
  &[(0,116,220)]), ((0,47,97), &[(0,116,230)]), ((0,47,98), &[(0,117,24)]),
  ((0,47,99), &[(0,117,31)]), ((0,47,100), &[(0,117,40)]), ((0,47,101),
  &[(0,117,48)]), ((0,47,102), &[(0,117,139)]), ((0,47,103), &[(0,117,146)]),
  ((0,47,104), &[(0,118,118)]), ((0,47,105), &[(0,118,125)]), ((0,47,106),
  &[(0,118,174)]), ((0,47,107), &[(0,118,191)]), ((0,47,108), &[(0,118,238)]),
  ((0,47,109), &[(0,119,219)]), ((0,47,110), &[(0,119,226)]), ((0,47,111),
  &[(0,119,243)]), ((0,47,112), &[(0,121,58)]), ((0,47,113), &[(0,121,184)]),
  ((0,47,114), &[(0,121,190)]), ((0,47,115), &[(0,122,116)]), ((0,47,116),
  &[(0,122,203)]), ((0,47,117), &[(0,122,249)]), ((0,47,118), &[(0,124,115)]),
  ((0,47,119), &[(0,124,248)]), ((0,47,120), &[(0,127,54)]), ((0,47,121),
  &[(0,127,81)]), ((0,47,122), &[(0,127,138)]), ((0,47,123), &[(0,127,189)]),
  ((0,47,124), &[(0,128,1)]), ((0,47,125), &[(0,128,12)]), ((0,47,126),
  &[(0,128,18)]), ((0,47,127), &[(0,128,51)]), ((0,47,128), &[(0,128,127)]),
  ((0,47,129), &[(0,128,137)]), ((0,47,130), &[(0,129,227)]), ((0,47,131),
  &[(0,129,234)]), ((0,47,132), &[(0,129,243)]), ((0,47,133), &[(0,129,252)]),
  ((0,47,134), &[(0,130,12)]), ((0,47,135), &[(0,130,27)]), ((0,47,136),
  &[(0,130,31)]), ((0,47,137), &[(0,130,110)]), ((0,47,138), &[(0,130,114)]),
  ((0,47,139), &[(0,130,120)]), ((0,47,140), &[(0,134,77)]), ((0,47,141),
  &[(0,134,107)]), ((0,47,142), &[(0,136,64)]), ((0,47,143), &[(0,136,76)]),
  ((0,47,144), &[(0,136,99)]), ((0,47,145), &[(0,137,126)]), ((0,47,146),
  &[(0,137,139)]), ((0,47,147), &[(0,137,210)]), ((0,47,148), &[(0,138,0)]),
  ((0,47,149), &[(0,140,55)]), ((0,47,150), &[(0,140,70)]), ((0,47,151),
  &[(0,140,85)]), ((0,47,152), &[(0,140,120)]), ((0,47,153), &[(0,140,157)]),
  ((0,47,154), &[(0,141,100)]), ((0,47,155), &[(0,141,112)]), ((0,47,156),
  &[(0,141,179)]), ((0,47,157), &[(0,142,171)]), ((0,47,158), &[(0,142,202)]),
  ((0,47,159), &[(0,143,155)]), ((0,47,160), &[(0,143,176)]), ((0,47,161),
  &[(0,143,181)]), ((0,47,162), &[(0,144,145)]), ((0,47,163), &[(0,145,73)]),
  ((0,47,164), &[(0,145,198)]), ((0,47,165), &[(0,145,204)]), ((0,47,166),
  &[(0,145,209)]), ((0,47,167), &[(0,149,119)]), ((0,47,168), &[(0,149,128)]),
  ((0,47,169), &[(0,150,28)]), ((0,47,170), &[(0,150,182)]), ((0,47,171),
  &[(0,150,185)]), ((0,47,172), &[(0,150,232)]), ((0,47,173), &[(0,151,81)]),
  ((0,47,174), &[(0,151,94)]), ((0,47,175), &[(0,151,98)]), ((0,47,176),
  &[(0,151,105)]), ((0,47,177), &[(0,151,203)]), ((0,47,178), &[(0,151,237)]),
  ((0,47,179), &[(0,151,243)]), ((0,47,180), &[(0,152,1)]), ((0,47,181),
  &[(0,152,168)]), ((0,47,182), &[(0,152,219)]), ((0,47,183), &[(0,152,223)]),
  ((0,47,184), &[(0,153,150)]), ((0,47,185), &[(0,153,153)]), ((0,47,186),
  &[(0,153,172)]), ((0,47,187), &[(0,154,168)]), ((0,47,188), &[(0,154,216)]),
  ((0,47,189), &[(0,154,223)]), ((0,47,190), &[(0,155,37)]), ((0,47,191),
  &[(0,155,47)]), ((0,47,192), &[(0,155,50)]), ((0,47,193), &[(0,155,60)]),
  ((0,47,194), &[(0,155,90)]), ((0,47,195), &[(0,156,229)]), ((0,47,196),
  &[(0,158,117)]), ((0,47,197), &[(0,158,127)]), ((0,47,198), &[(0,158,165)]),
  ((0,47,199), &[(0,158,187)]), ((0,47,200), &[(0,158,195)]), ((0,47,201),
  &[(0,158,205)]), ((0,47,202), &[(0,158,209)]), ((0,47,203), &[(0,158,249)]),
  ((0,47,204), &[(0,158,253)]), ((0,47,205), &[(0,159,14)]), ((0,47,206),
  &[(0,159,19)]), ((0,47,207), &[(0,159,32)]), ((0,47,208), &[(0,159,59)]),
  ((0,47,209), &[(0,159,74)]), ((0,47,210), &[(0,159,82)]), ((0,47,211),
  &[(0,159,141)]), ((0,47,212), &[(0,159,156)]), ((0,47,213), &[(0,159,160)]),
  ((0,48,0), &[(0,0,32)]), ((0,48,54), &[(0,48,18)]), ((0,48,56), &[(0,83,65)]),
  ((0,48,57), &[(0,83,68)]), ((0,48,58), &[(0,83,69)]), ((0,48,76), &[(0,48,75),
  (0,48,153)]), ((0,48,78), &[(0,48,77), (0,48,153)]), ((0,48,80), &[(0,48,79),
  (0,48,153)]), ((0,48,82), &[(0,48,81), (0,48,153)]), ((0,48,84), &[(0,48,83),
  (0,48,153)]), ((0,48,86), &[(0,48,85), (0,48,153)]), ((0,48,88), &[(0,48,87),
  (0,48,153)]), ((0,48,90), &[(0,48,89), (0,48,153)]), ((0,48,92), &[(0,48,91),
  (0,48,153)]), ((0,48,94), &[(0,48,93), (0,48,153)]), ((0,48,96), &[(0,48,95),
  (0,48,153)]), ((0,48,98), &[(0,48,97), (0,48,153)]), ((0,48,101),
  &[(0,48,100), (0,48,153)]), ((0,48,103), &[(0,48,102), (0,48,153)]),
  ((0,48,105), &[(0,48,104), (0,48,153)]), ((0,48,112), &[(0,48,111),
  (0,48,153)]), ((0,48,113), &[(0,48,111), (0,48,154)]), ((0,48,115),
  &[(0,48,114), (0,48,153)]), ((0,48,116), &[(0,48,114), (0,48,154)]),
  ((0,48,118), &[(0,48,117), (0,48,153)]), ((0,48,119), &[(0,48,117),
  (0,48,154)]), ((0,48,121), &[(0,48,120), (0,48,153)]), ((0,48,122),
  &[(0,48,120), (0,48,154)]), ((0,48,124), &[(0,48,123), (0,48,153)]),
  ((0,48,125), &[(0,48,123), (0,48,154)]), ((0,48,148), &[(0,48,70),
  (0,48,153)]), ((0,48,155), &[(0,0,32), (0,48,153)]), ((0,48,156), &[(0,0,32),
  (0,48,154)]), ((0,48,158), &[(0,48,157), (0,48,153)]), ((0,48,159),
  &[(0,48,136), (0,48,138)]), ((0,48,172), &[(0,48,171), (0,48,153)]),
  ((0,48,174), &[(0,48,173), (0,48,153)]), ((0,48,176), &[(0,48,175),
  (0,48,153)]), ((0,48,178), &[(0,48,177), (0,48,153)]), ((0,48,180),
  &[(0,48,179), (0,48,153)]), ((0,48,182), &[(0,48,181), (0,48,153)]),
  ((0,48,184), &[(0,48,183), (0,48,153)]), ((0,48,186), &[(0,48,185),
  (0,48,153)]), ((0,48,188), &[(0,48,187), (0,48,153)]), ((0,48,190),
  &[(0,48,189), (0,48,153)]), ((0,48,192), &[(0,48,191), (0,48,153)]),
  ((0,48,194), &[(0,48,193), (0,48,153)]), ((0,48,197), &[(0,48,196),
  (0,48,153)]), ((0,48,199), &[(0,48,198), (0,48,153)]), ((0,48,201),
  &[(0,48,200), (0,48,153)]), ((0,48,208), &[(0,48,207), (0,48,153)]),
  ((0,48,209), &[(0,48,207), (0,48,154)]), ((0,48,211), &[(0,48,210),
  (0,48,153)]), ((0,48,212), &[(0,48,210), (0,48,154)]), ((0,48,214),
  &[(0,48,213), (0,48,153)]), ((0,48,215), &[(0,48,213), (0,48,154)]),
  ((0,48,217), &[(0,48,216), (0,48,153)]), ((0,48,218), &[(0,48,216),
  (0,48,154)]), ((0,48,220), &[(0,48,219), (0,48,153)]), ((0,48,221),
  &[(0,48,219), (0,48,154)]), ((0,48,244), &[(0,48,166), (0,48,153)]),
  ((0,48,247), &[(0,48,239), (0,48,153)]), ((0,48,248), &[(0,48,240),
  (0,48,153)]), ((0,48,249), &[(0,48,241), (0,48,153)]), ((0,48,250),
  &[(0,48,242), (0,48,153)]), ((0,48,254), &[(0,48,253), (0,48,153)]),
  ((0,48,255), &[(0,48,179), (0,48,200)]), ((0,49,49), &[(0,17,0)]), ((0,49,50),
  &[(0,17,1)]), ((0,49,51), &[(0,17,170)]), ((0,49,52), &[(0,17,2)]),
  ((0,49,53), &[(0,17,172)]), ((0,49,54), &[(0,17,173)]), ((0,49,55),
  &[(0,17,3)]), ((0,49,56), &[(0,17,4)]), ((0,49,57), &[(0,17,5)]), ((0,49,58),
  &[(0,17,176)]), ((0,49,59), &[(0,17,177)]), ((0,49,60), &[(0,17,178)]),
  ((0,49,61), &[(0,17,179)]), ((0,49,62), &[(0,17,180)]), ((0,49,63),
  &[(0,17,181)]), ((0,49,64), &[(0,17,26)]), ((0,49,65), &[(0,17,6)]),
  ((0,49,66), &[(0,17,7)]), ((0,49,67), &[(0,17,8)]), ((0,49,68), &[(0,17,33)]),
  ((0,49,69), &[(0,17,9)]), ((0,49,70), &[(0,17,10)]), ((0,49,71),
  &[(0,17,11)]), ((0,49,72), &[(0,17,12)]), ((0,49,73), &[(0,17,13)]),
  ((0,49,74), &[(0,17,14)]), ((0,49,75), &[(0,17,15)]), ((0,49,76),
  &[(0,17,16)]), ((0,49,77), &[(0,17,17)]), ((0,49,78), &[(0,17,18)]),
  ((0,49,79), &[(0,17,97)]), ((0,49,80), &[(0,17,98)]), ((0,49,81),
  &[(0,17,99)]), ((0,49,82), &[(0,17,100)]), ((0,49,83), &[(0,17,101)]),
  ((0,49,84), &[(0,17,102)]), ((0,49,85), &[(0,17,103)]), ((0,49,86),
  &[(0,17,104)]), ((0,49,87), &[(0,17,105)]), ((0,49,88), &[(0,17,106)]),
  ((0,49,89), &[(0,17,107)]), ((0,49,90), &[(0,17,108)]), ((0,49,91),
  &[(0,17,109)]), ((0,49,92), &[(0,17,110)]), ((0,49,93), &[(0,17,111)]),
  ((0,49,94), &[(0,17,112)]), ((0,49,95), &[(0,17,113)]), ((0,49,96),
  &[(0,17,114)]), ((0,49,97), &[(0,17,115)]), ((0,49,98), &[(0,17,116)]),
  ((0,49,99), &[(0,17,117)]), ((0,49,100), &[(0,17,96)]), ((0,49,101),
  &[(0,17,20)]), ((0,49,102), &[(0,17,21)]), ((0,49,103), &[(0,17,199)]),
  ((0,49,104), &[(0,17,200)]), ((0,49,105), &[(0,17,204)]), ((0,49,106),
  &[(0,17,206)]), ((0,49,107), &[(0,17,211)]), ((0,49,108), &[(0,17,215)]),
  ((0,49,109), &[(0,17,217)]), ((0,49,110), &[(0,17,28)]), ((0,49,111),
  &[(0,17,221)]), ((0,49,112), &[(0,17,223)]), ((0,49,113), &[(0,17,29)]),
  ((0,49,114), &[(0,17,30)]), ((0,49,115), &[(0,17,32)]), ((0,49,116),
  &[(0,17,34)]), ((0,49,117), &[(0,17,35)]), ((0,49,118), &[(0,17,39)]),
  ((0,49,119), &[(0,17,41)]), ((0,49,120), &[(0,17,43)]), ((0,49,121),
  &[(0,17,44)]), ((0,49,122), &[(0,17,45)]), ((0,49,123), &[(0,17,46)]),
  ((0,49,124), &[(0,17,47)]), ((0,49,125), &[(0,17,50)]), ((0,49,126),
  &[(0,17,54)]), ((0,49,127), &[(0,17,64)]), ((0,49,128), &[(0,17,71)]),
  ((0,49,129), &[(0,17,76)]), ((0,49,130), &[(0,17,241)]), ((0,49,131),
  &[(0,17,242)]), ((0,49,132), &[(0,17,87)]), ((0,49,133), &[(0,17,88)]),
  ((0,49,134), &[(0,17,89)]), ((0,49,135), &[(0,17,132)]), ((0,49,136),
  &[(0,17,133)]), ((0,49,137), &[(0,17,136)]), ((0,49,138), &[(0,17,145)]),
  ((0,49,139), &[(0,17,146)]), ((0,49,140), &[(0,17,148)]), ((0,49,141),
  &[(0,17,158)]), ((0,49,142), &[(0,17,161)]), ((0,49,146), &[(0,78,0)]),
  ((0,49,147), &[(0,78,140)]), ((0,49,148), &[(0,78,9)]), ((0,49,149),
  &[(0,86,219)]), ((0,49,150), &[(0,78,10)]), ((0,49,151), &[(0,78,45)]),
  ((0,49,152), &[(0,78,11)]), ((0,49,153), &[(0,117,50)]), ((0,49,154),
  &[(0,78,89)]), ((0,49,155), &[(0,78,25)]), ((0,49,156), &[(0,78,1)]),
  ((0,49,157), &[(0,89,41)]), ((0,49,158), &[(0,87,48)]), ((0,49,159),
  &[(0,78,186)]), ((0,50,0), &[(0,0,40), (0,17,0), (0,0,41)]), ((0,50,1),
  &[(0,0,40), (0,17,2), (0,0,41)]), ((0,50,2), &[(0,0,40), (0,17,3), (0,0,41)]),
  ((0,50,3), &[(0,0,40), (0,17,5), (0,0,41)]), ((0,50,4), &[(0,0,40), (0,17,6),
  (0,0,41)]), ((0,50,5), &[(0,0,40), (0,17,7), (0,0,41)]), ((0,50,6),
  &[(0,0,40), (0,17,9), (0,0,41)]), ((0,50,7), &[(0,0,40), (0,17,11),
  (0,0,41)]), ((0,50,8), &[(0,0,40), (0,17,12), (0,0,41)]), ((0,50,9),
  &[(0,0,40), (0,17,14), (0,0,41)]), ((0,50,10), &[(0,0,40), (0,17,15),
  (0,0,41)]), ((0,50,11), &[(0,0,40), (0,17,16), (0,0,41)]), ((0,50,12),
  &[(0,0,40), (0,17,17), (0,0,41)]), ((0,50,13), &[(0,0,40), (0,17,18),
  (0,0,41)]), ((0,50,14), &[(0,0,40), (0,17,0), (0,17,97), (0,0,41)]),
  ((0,50,15), &[(0,0,40), (0,17,2), (0,17,97), (0,0,41)]), ((0,50,16),
  &[(0,0,40), (0,17,3), (0,17,97), (0,0,41)]), ((0,50,17), &[(0,0,40), (0,17,5),
  (0,17,97), (0,0,41)]), ((0,50,18), &[(0,0,40), (0,17,6), (0,17,97),
  (0,0,41)]), ((0,50,19), &[(0,0,40), (0,17,7), (0,17,97), (0,0,41)]),
  ((0,50,20), &[(0,0,40), (0,17,9), (0,17,97), (0,0,41)]), ((0,50,21),
  &[(0,0,40), (0,17,11), (0,17,97), (0,0,41)]), ((0,50,22), &[(0,0,40),
  (0,17,12), (0,17,97), (0,0,41)]), ((0,50,23), &[(0,0,40), (0,17,14),
  (0,17,97), (0,0,41)]), ((0,50,24), &[(0,0,40), (0,17,15), (0,17,97),
  (0,0,41)]), ((0,50,25), &[(0,0,40), (0,17,16), (0,17,97), (0,0,41)]),
  ((0,50,26), &[(0,0,40), (0,17,17), (0,17,97), (0,0,41)]), ((0,50,27),
  &[(0,0,40), (0,17,18), (0,17,97), (0,0,41)]), ((0,50,28), &[(0,0,40),
  (0,17,12), (0,17,110), (0,0,41)]), ((0,50,29), &[(0,0,40), (0,17,11),
  (0,17,105), (0,17,12), (0,17,101), (0,17,171), (0,0,41)]), ((0,50,30),
  &[(0,0,40), (0,17,11), (0,17,105), (0,17,18), (0,17,110), (0,0,41)]),
  ((0,50,32), &[(0,0,40), (0,78,0), (0,0,41)]), ((0,50,33), &[(0,0,40),
  (0,78,140), (0,0,41)]), ((0,50,34), &[(0,0,40), (0,78,9), (0,0,41)]),
  ((0,50,35), &[(0,0,40), (0,86,219), (0,0,41)]), ((0,50,36), &[(0,0,40),
  (0,78,148), (0,0,41)]), ((0,50,37), &[(0,0,40), (0,81,109), (0,0,41)]),
  ((0,50,38), &[(0,0,40), (0,78,3), (0,0,41)]), ((0,50,39), &[(0,0,40),
  (0,81,107), (0,0,41)]), ((0,50,40), &[(0,0,40), (0,78,93), (0,0,41)]),
  ((0,50,41), &[(0,0,40), (0,83,65), (0,0,41)]), ((0,50,42), &[(0,0,40),
  (0,103,8), (0,0,41)]), ((0,50,43), &[(0,0,40), (0,112,107), (0,0,41)]),
  ((0,50,44), &[(0,0,40), (0,108,52), (0,0,41)]), ((0,50,45), &[(0,0,40),
  (0,103,40), (0,0,41)]), ((0,50,46), &[(0,0,40), (0,145,209), (0,0,41)]),
  ((0,50,47), &[(0,0,40), (0,87,31), (0,0,41)]), ((0,50,48), &[(0,0,40),
  (0,101,229), (0,0,41)]), ((0,50,49), &[(0,0,40), (0,104,42), (0,0,41)]),
  ((0,50,50), &[(0,0,40), (0,103,9), (0,0,41)]), ((0,50,51), &[(0,0,40),
  (0,121,62), (0,0,41)]), ((0,50,52), &[(0,0,40), (0,84,13), (0,0,41)]),
  ((0,50,53), &[(0,0,40), (0,114,121), (0,0,41)]), ((0,50,54), &[(0,0,40),
  (0,140,161), (0,0,41)]), ((0,50,55), &[(0,0,40), (0,121,93), (0,0,41)]),
  ((0,50,56), &[(0,0,40), (0,82,180), (0,0,41)]), ((0,50,57), &[(0,0,40),
  (0,78,227), (0,0,41)]), ((0,50,58), &[(0,0,40), (0,84,124), (0,0,41)]),
  ((0,50,59), &[(0,0,40), (0,91,102), (0,0,41)]), ((0,50,60), &[(0,0,40),
  (0,118,227), (0,0,41)]), ((0,50,61), &[(0,0,40), (0,79,1), (0,0,41)]),
  ((0,50,62), &[(0,0,40), (0,140,199), (0,0,41)]), ((0,50,63), &[(0,0,40),
  (0,83,84), (0,0,41)]), ((0,50,64), &[(0,0,40), (0,121,109), (0,0,41)]),
  ((0,50,65), &[(0,0,40), (0,79,17), (0,0,41)]), ((0,50,66), &[(0,0,40),
  (0,129,234), (0,0,41)]), ((0,50,67), &[(0,0,40), (0,129,243), (0,0,41)]),
  ((0,50,68), &[(0,85,79)]), ((0,50,69), &[(0,94,124)]), ((0,50,70),
  &[(0,101,135)]), ((0,50,71), &[(0,123,143)]), ((0,50,80), &[(0,0,80),
  (0,0,84), (0,0,69)]), ((0,50,81), &[(0,0,50), (0,0,49)]), ((0,50,82),
  &[(0,0,50), (0,0,50)]), ((0,50,83), &[(0,0,50), (0,0,51)]), ((0,50,84),
  &[(0,0,50), (0,0,52)]), ((0,50,85), &[(0,0,50), (0,0,53)]), ((0,50,86),
  &[(0,0,50), (0,0,54)]), ((0,50,87), &[(0,0,50), (0,0,55)]), ((0,50,88),
  &[(0,0,50), (0,0,56)]), ((0,50,89), &[(0,0,50), (0,0,57)]), ((0,50,90),
  &[(0,0,51), (0,0,48)]), ((0,50,91), &[(0,0,51), (0,0,49)]), ((0,50,92),
  &[(0,0,51), (0,0,50)]), ((0,50,93), &[(0,0,51), (0,0,51)]), ((0,50,94),
  &[(0,0,51), (0,0,52)]), ((0,50,95), &[(0,0,51), (0,0,53)]), ((0,50,96),
  &[(0,17,0)]), ((0,50,97), &[(0,17,2)]), ((0,50,98), &[(0,17,3)]), ((0,50,99),
  &[(0,17,5)]), ((0,50,100), &[(0,17,6)]), ((0,50,101), &[(0,17,7)]),
  ((0,50,102), &[(0,17,9)]), ((0,50,103), &[(0,17,11)]), ((0,50,104),
  &[(0,17,12)]), ((0,50,105), &[(0,17,14)]), ((0,50,106), &[(0,17,15)]),
  ((0,50,107), &[(0,17,16)]), ((0,50,108), &[(0,17,17)]), ((0,50,109),
  &[(0,17,18)]), ((0,50,110), &[(0,17,0), (0,17,97)]), ((0,50,111), &[(0,17,2),
  (0,17,97)]), ((0,50,112), &[(0,17,3), (0,17,97)]), ((0,50,113), &[(0,17,5),
  (0,17,97)]), ((0,50,114), &[(0,17,6), (0,17,97)]), ((0,50,115), &[(0,17,7),
  (0,17,97)]), ((0,50,116), &[(0,17,9), (0,17,97)]), ((0,50,117), &[(0,17,11),
  (0,17,97)]), ((0,50,118), &[(0,17,12), (0,17,97)]), ((0,50,119), &[(0,17,14),
  (0,17,97)]), ((0,50,120), &[(0,17,15), (0,17,97)]), ((0,50,121), &[(0,17,16),
  (0,17,97)]), ((0,50,122), &[(0,17,17), (0,17,97)]), ((0,50,123), &[(0,17,18),
  (0,17,97)]), ((0,50,124), &[(0,17,14), (0,17,97), (0,17,183), (0,17,0),
  (0,17,105)]), ((0,50,125), &[(0,17,12), (0,17,110), (0,17,11), (0,17,116)]),
  ((0,50,126), &[(0,17,11), (0,17,110)]), ((0,50,128), &[(0,78,0)]),
  ((0,50,129), &[(0,78,140)]), ((0,50,130), &[(0,78,9)]), ((0,50,131),
  &[(0,86,219)]), ((0,50,132), &[(0,78,148)]), ((0,50,133), &[(0,81,109)]),
  ((0,50,134), &[(0,78,3)]), ((0,50,135), &[(0,81,107)]), ((0,50,136),
  &[(0,78,93)]), ((0,50,137), &[(0,83,65)]), ((0,50,138), &[(0,103,8)]),
  ((0,50,139), &[(0,112,107)]), ((0,50,140), &[(0,108,52)]), ((0,50,141),
  &[(0,103,40)]), ((0,50,142), &[(0,145,209)]), ((0,50,143), &[(0,87,31)]),
  ((0,50,144), &[(0,101,229)]), ((0,50,145), &[(0,104,42)]), ((0,50,146),
  &[(0,103,9)]), ((0,50,147), &[(0,121,62)]), ((0,50,148), &[(0,84,13)]),
  ((0,50,149), &[(0,114,121)]), ((0,50,150), &[(0,140,161)]), ((0,50,151),
  &[(0,121,93)]), ((0,50,152), &[(0,82,180)]), ((0,50,153), &[(0,121,216)]),
  ((0,50,154), &[(0,117,55)]), ((0,50,155), &[(0,89,115)]), ((0,50,156),
  &[(0,144,105)]), ((0,50,157), &[(0,81,42)]), ((0,50,158), &[(0,83,112)]),
  ((0,50,159), &[(0,108,232)]), ((0,50,160), &[(0,152,5)]), ((0,50,161),
  &[(0,79,17)]), ((0,50,162), &[(0,81,153)]), ((0,50,163), &[(0,107,99)]),
  ((0,50,164), &[(0,78,10)]), ((0,50,165), &[(0,78,45)]), ((0,50,166),
  &[(0,78,11)]), ((0,50,167), &[(0,93,230)]), ((0,50,168), &[(0,83,243)]),
  ((0,50,169), &[(0,83,59)]), ((0,50,170), &[(0,91,151)]), ((0,50,171),
  &[(0,91,102)]), ((0,50,172), &[(0,118,227)]), ((0,50,173), &[(0,79,1)]),
  ((0,50,174), &[(0,140,199)]), ((0,50,175), &[(0,83,84)]), ((0,50,176),
  &[(0,89,28)]), ((0,50,177), &[(0,0,51), (0,0,54)]), ((0,50,178), &[(0,0,51),
  (0,0,55)]), ((0,50,179), &[(0,0,51), (0,0,56)]), ((0,50,180), &[(0,0,51),
  (0,0,57)]), ((0,50,181), &[(0,0,52), (0,0,48)]), ((0,50,182), &[(0,0,52),
  (0,0,49)]), ((0,50,183), &[(0,0,52), (0,0,50)]), ((0,50,184), &[(0,0,52),
  (0,0,51)]), ((0,50,185), &[(0,0,52), (0,0,52)]), ((0,50,186), &[(0,0,52),
  (0,0,53)]), ((0,50,187), &[(0,0,52), (0,0,54)]), ((0,50,188), &[(0,0,52),
  (0,0,55)]), ((0,50,189), &[(0,0,52), (0,0,56)]), ((0,50,190), &[(0,0,52),
  (0,0,57)]), ((0,50,191), &[(0,0,53), (0,0,48)]), ((0,50,192), &[(0,0,49),
  (0,103,8)]), ((0,50,193), &[(0,0,50), (0,103,8)]), ((0,50,194), &[(0,0,51),
  (0,103,8)]), ((0,50,195), &[(0,0,52), (0,103,8)]), ((0,50,196), &[(0,0,53),
  (0,103,8)]), ((0,50,197), &[(0,0,54), (0,103,8)]), ((0,50,198), &[(0,0,55),
  (0,103,8)]), ((0,50,199), &[(0,0,56), (0,103,8)]), ((0,50,200), &[(0,0,57),
  (0,103,8)]), ((0,50,201), &[(0,0,49), (0,0,48), (0,103,8)]), ((0,50,202),
  &[(0,0,49), (0,0,49), (0,103,8)]), ((0,50,203), &[(0,0,49), (0,0,50),
  (0,103,8)]), ((0,50,204), &[(0,0,72), (0,0,103)]), ((0,50,205), &[(0,0,101),
  (0,0,114), (0,0,103)]), ((0,50,206), &[(0,0,101), (0,0,86)]), ((0,50,207),
  &[(0,0,76), (0,0,84), (0,0,68)]), ((0,50,208), &[(0,48,162)]), ((0,50,209),
  &[(0,48,164)]), ((0,50,210), &[(0,48,166)]), ((0,50,211), &[(0,48,168)]),
  ((0,50,212), &[(0,48,170)]), ((0,50,213), &[(0,48,171)]), ((0,50,214),
  &[(0,48,173)]), ((0,50,215), &[(0,48,175)]), ((0,50,216), &[(0,48,177)]),
  ((0,50,217), &[(0,48,179)]), ((0,50,218), &[(0,48,181)]), ((0,50,219),
  &[(0,48,183)]), ((0,50,220), &[(0,48,185)]), ((0,50,221), &[(0,48,187)]),
  ((0,50,222), &[(0,48,189)]), ((0,50,223), &[(0,48,191)]), ((0,50,224),
  &[(0,48,193)]), ((0,50,225), &[(0,48,196)]), ((0,50,226), &[(0,48,198)]),
  ((0,50,227), &[(0,48,200)]), ((0,50,228), &[(0,48,202)]), ((0,50,229),
  &[(0,48,203)]), ((0,50,230), &[(0,48,204)]), ((0,50,231), &[(0,48,205)]),
  ((0,50,232), &[(0,48,206)]), ((0,50,233), &[(0,48,207)]), ((0,50,234),
  &[(0,48,210)]), ((0,50,235), &[(0,48,213)]), ((0,50,236), &[(0,48,216)]),
  ((0,50,237), &[(0,48,219)]), ((0,50,238), &[(0,48,222)]), ((0,50,239),
  &[(0,48,223)]), ((0,50,240), &[(0,48,224)]), ((0,50,241), &[(0,48,225)]),
  ((0,50,242), &[(0,48,226)]), ((0,50,243), &[(0,48,228)]), ((0,50,244),
  &[(0,48,230)]), ((0,50,245), &[(0,48,232)]), ((0,50,246), &[(0,48,233)]),
  ((0,50,247), &[(0,48,234)]), ((0,50,248), &[(0,48,235)]), ((0,50,249),
  &[(0,48,236)]), ((0,50,250), &[(0,48,237)]), ((0,50,251), &[(0,48,239)]),
  ((0,50,252), &[(0,48,240)]), ((0,50,253), &[(0,48,241)]), ((0,50,254),
  &[(0,48,242)]), ((0,51,0), &[(0,48,162), (0,48,209), (0,48,252), (0,48,200)]),
  ((0,51,1), &[(0,48,162), (0,48,235), (0,48,213), (0,48,161)]), ((0,51,2),
  &[(0,48,162), (0,48,243), (0,48,218), (0,48,162)]), ((0,51,3), &[(0,48,162),
  (0,48,252), (0,48,235)]), ((0,51,4), &[(0,48,164), (0,48,203), (0,48,243),
  (0,48,176)]), ((0,51,5), &[(0,48,164), (0,48,243), (0,48,193)]), ((0,51,6),
  &[(0,48,166), (0,48,169), (0,48,243)]), ((0,51,7), &[(0,48,168), (0,48,185),
  (0,48,175), (0,48,252), (0,48,201)]), ((0,51,8), &[(0,48,168), (0,48,252),
  (0,48,171), (0,48,252)]), ((0,51,9), &[(0,48,170), (0,48,243), (0,48,185)]),
  ((0,51,10), &[(0,48,170), (0,48,252), (0,48,224)]), ((0,51,11), &[(0,48,171),
  (0,48,164), (0,48,234)]), ((0,51,12), &[(0,48,171), (0,48,233), (0,48,195),
  (0,48,200)]), ((0,51,13), &[(0,48,171), (0,48,237), (0,48,234), (0,48,252)]),
  ((0,51,14), &[(0,48,172), (0,48,237), (0,48,243)]), ((0,51,15), &[(0,48,172),
  (0,48,243), (0,48,222)]), ((0,51,16), &[(0,48,174), (0,48,172)]), ((0,51,17),
  &[(0,48,174), (0,48,203), (0,48,252)]), ((0,51,18), &[(0,48,173), (0,48,229),
  (0,48,234), (0,48,252)]), ((0,51,19), &[(0,48,174), (0,48,235), (0,48,192),
  (0,48,252)]), ((0,51,20), &[(0,48,173), (0,48,237)]), ((0,51,21),
  &[(0,48,173), (0,48,237), (0,48,176), (0,48,233), (0,48,224)]), ((0,51,22),
  &[(0,48,173), (0,48,237), (0,48,225), (0,48,252), (0,48,200), (0,48,235)]),
  ((0,51,23), &[(0,48,173), (0,48,237), (0,48,239), (0,48,195), (0,48,200)]),
  ((0,51,24), &[(0,48,176), (0,48,233), (0,48,224)]), ((0,51,25), &[(0,48,176),
  (0,48,233), (0,48,224), (0,48,200), (0,48,243)]), ((0,51,26), &[(0,48,175),
  (0,48,235), (0,48,188), (0,48,164), (0,48,237)]), ((0,51,27), &[(0,48,175),
  (0,48,237), (0,48,252), (0,48,205)]), ((0,51,28), &[(0,48,177), (0,48,252),
  (0,48,185)]), ((0,51,29), &[(0,48,179), (0,48,235), (0,48,202)]), ((0,51,30),
  &[(0,48,179), (0,48,252), (0,48,221)]), ((0,51,31), &[(0,48,181), (0,48,164),
  (0,48,175), (0,48,235)]), ((0,51,32), &[(0,48,181), (0,48,243), (0,48,193),
  (0,48,252), (0,48,224)]), ((0,51,33), &[(0,48,183), (0,48,234), (0,48,243),
  (0,48,176)]), ((0,51,34), &[(0,48,187), (0,48,243), (0,48,193)]), ((0,51,35),
  &[(0,48,187), (0,48,243), (0,48,200)]), ((0,51,36), &[(0,48,192), (0,48,252),
  (0,48,185)]), ((0,51,37), &[(0,48,199), (0,48,183)]), ((0,51,38),
  &[(0,48,201), (0,48,235)]), ((0,51,39), &[(0,48,200), (0,48,243)]),
  ((0,51,40), &[(0,48,202), (0,48,206)]), ((0,51,41), &[(0,48,206), (0,48,195),
  (0,48,200)]), ((0,51,42), &[(0,48,207), (0,48,164), (0,48,196)]), ((0,51,43),
  &[(0,48,209), (0,48,252), (0,48,187), (0,48,243), (0,48,200)]), ((0,51,44),
  &[(0,48,209), (0,48,252), (0,48,196)]), ((0,51,45), &[(0,48,208), (0,48,252),
  (0,48,236), (0,48,235)]), ((0,51,46), &[(0,48,212), (0,48,162), (0,48,185),
  (0,48,200), (0,48,235)]), ((0,51,47), &[(0,48,212), (0,48,175), (0,48,235)]),
  ((0,51,48), &[(0,48,212), (0,48,179)]), ((0,51,49), &[(0,48,211),
  (0,48,235)]), ((0,51,50), &[(0,48,213), (0,48,161), (0,48,233), (0,48,195),
  (0,48,201)]), ((0,51,51), &[(0,48,213), (0,48,163), (0,48,252), (0,48,200)]),
  ((0,51,52), &[(0,48,214), (0,48,195), (0,48,183), (0,48,167), (0,48,235)]),
  ((0,51,53), &[(0,48,213), (0,48,233), (0,48,243)]), ((0,51,54), &[(0,48,216),
  (0,48,175), (0,48,191), (0,48,252), (0,48,235)]), ((0,51,55), &[(0,48,218),
  (0,48,189)]), ((0,51,56), &[(0,48,218), (0,48,203), (0,48,210)]), ((0,51,57),
  &[(0,48,216), (0,48,235), (0,48,196)]), ((0,51,58), &[(0,48,218), (0,48,243),
  (0,48,185)]), ((0,51,59), &[(0,48,218), (0,48,252), (0,48,184)]), ((0,51,60),
  &[(0,48,217), (0,48,252), (0,48,191)]), ((0,51,61), &[(0,48,221), (0,48,164),
  (0,48,243), (0,48,200)]), ((0,51,62), &[(0,48,220), (0,48,235), (0,48,200)]),
  ((0,51,63), &[(0,48,219), (0,48,243)]), ((0,51,64), &[(0,48,221), (0,48,243),
  (0,48,201)]), ((0,51,65), &[(0,48,219), (0,48,252), (0,48,235)]), ((0,51,66),
  &[(0,48,219), (0,48,252), (0,48,243)]), ((0,51,67), &[(0,48,222), (0,48,164),
  (0,48,175), (0,48,237)]), ((0,51,68), &[(0,48,222), (0,48,164), (0,48,235)]),
  ((0,51,69), &[(0,48,222), (0,48,195), (0,48,207)]), ((0,51,70), &[(0,48,222),
  (0,48,235), (0,48,175)]), ((0,51,71), &[(0,48,222), (0,48,243), (0,48,183),
  (0,48,231), (0,48,243)]), ((0,51,72), &[(0,48,223), (0,48,175), (0,48,237),
  (0,48,243)]), ((0,51,73), &[(0,48,223), (0,48,234)]), ((0,51,74),
  &[(0,48,223), (0,48,234), (0,48,208), (0,48,252), (0,48,235)]), ((0,51,75),
  &[(0,48,225), (0,48,172)]), ((0,51,76), &[(0,48,225), (0,48,172), (0,48,200),
  (0,48,243)]), ((0,51,77), &[(0,48,225), (0,48,252), (0,48,200), (0,48,235)]),
  ((0,51,78), &[(0,48,228), (0,48,252), (0,48,201)]), ((0,51,79), &[(0,48,228),
  (0,48,252), (0,48,235)]), ((0,51,80), &[(0,48,230), (0,48,162), (0,48,243)]),
  ((0,51,81), &[(0,48,234), (0,48,195), (0,48,200), (0,48,235)]), ((0,51,82),
  &[(0,48,234), (0,48,233)]), ((0,51,83), &[(0,48,235), (0,48,212),
  (0,48,252)]), ((0,51,84), &[(0,48,235), (0,48,252), (0,48,214), (0,48,235)]),
  ((0,51,85), &[(0,48,236), (0,48,224)]), ((0,51,86), &[(0,48,236), (0,48,243),
  (0,48,200), (0,48,178), (0,48,243)]), ((0,51,87), &[(0,48,239), (0,48,195),
  (0,48,200)]), ((0,51,88), &[(0,0,48), (0,112,185)]), ((0,51,89), &[(0,0,49),
  (0,112,185)]), ((0,51,90), &[(0,0,50), (0,112,185)]), ((0,51,91), &[(0,0,51),
  (0,112,185)]), ((0,51,92), &[(0,0,52), (0,112,185)]), ((0,51,93), &[(0,0,53),
  (0,112,185)]), ((0,51,94), &[(0,0,54), (0,112,185)]), ((0,51,95), &[(0,0,55),
  (0,112,185)]), ((0,51,96), &[(0,0,56), (0,112,185)]), ((0,51,97), &[(0,0,57),
  (0,112,185)]), ((0,51,98), &[(0,0,49), (0,0,48), (0,112,185)]), ((0,51,99),
  &[(0,0,49), (0,0,49), (0,112,185)]), ((0,51,100), &[(0,0,49), (0,0,50),
  (0,112,185)]), ((0,51,101), &[(0,0,49), (0,0,51), (0,112,185)]), ((0,51,102),
  &[(0,0,49), (0,0,52), (0,112,185)]), ((0,51,103), &[(0,0,49), (0,0,53),
  (0,112,185)]), ((0,51,104), &[(0,0,49), (0,0,54), (0,112,185)]), ((0,51,105),
  &[(0,0,49), (0,0,55), (0,112,185)]), ((0,51,106), &[(0,0,49), (0,0,56),
  (0,112,185)]), ((0,51,107), &[(0,0,49), (0,0,57), (0,112,185)]), ((0,51,108),
  &[(0,0,50), (0,0,48), (0,112,185)]), ((0,51,109), &[(0,0,50), (0,0,49),
  (0,112,185)]), ((0,51,110), &[(0,0,50), (0,0,50), (0,112,185)]), ((0,51,111),
  &[(0,0,50), (0,0,51), (0,112,185)]), ((0,51,112), &[(0,0,50), (0,0,52),
  (0,112,185)]), ((0,51,113), &[(0,0,104), (0,0,80), (0,0,97)]), ((0,51,114),
  &[(0,0,100), (0,0,97)]), ((0,51,115), &[(0,0,65), (0,0,85)]), ((0,51,116),
  &[(0,0,98), (0,0,97), (0,0,114)]), ((0,51,117), &[(0,0,111), (0,0,86)]),
  ((0,51,118), &[(0,0,112), (0,0,99)]), ((0,51,119), &[(0,0,100), (0,0,109)]),
  ((0,51,120), &[(0,0,100), (0,0,109), (0,0,178)]), ((0,51,121), &[(0,0,100),
  (0,0,109), (0,0,179)]), ((0,51,122), &[(0,0,73), (0,0,85)]), ((0,51,123),
  &[(0,94,115), (0,98,16)]), ((0,51,124), &[(0,102,45), (0,84,140)]),
  ((0,51,125), &[(0,89,39), (0,107,99)]), ((0,51,126), &[(0,102,14),
  (0,108,187)]), ((0,51,127), &[(0,104,42), (0,95,15), (0,79,26), (0,121,62)]),
  ((0,51,128), &[(0,0,112), (0,0,65)]), ((0,51,129), &[(0,0,110), (0,0,65)]),
  ((0,51,130), &[(0,3,188), (0,0,65)]), ((0,51,131), &[(0,0,109), (0,0,65)]),
  ((0,51,132), &[(0,0,107), (0,0,65)]), ((0,51,133), &[(0,0,75), (0,0,66)]),
  ((0,51,134), &[(0,0,77), (0,0,66)]), ((0,51,135), &[(0,0,71), (0,0,66)]),
  ((0,51,136), &[(0,0,99), (0,0,97), (0,0,108)]), ((0,51,137), &[(0,0,107),
  (0,0,99), (0,0,97), (0,0,108)]), ((0,51,138), &[(0,0,112), (0,0,70)]),
  ((0,51,139), &[(0,0,110), (0,0,70)]), ((0,51,140), &[(0,3,188), (0,0,70)]),
  ((0,51,141), &[(0,3,188), (0,0,103)]), ((0,51,142), &[(0,0,109), (0,0,103)]),
  ((0,51,143), &[(0,0,107), (0,0,103)]), ((0,51,144), &[(0,0,72), (0,0,122)]),
  ((0,51,145), &[(0,0,107), (0,0,72), (0,0,122)]), ((0,51,146), &[(0,0,77),
  (0,0,72), (0,0,122)]), ((0,51,147), &[(0,0,71), (0,0,72), (0,0,122)]),
  ((0,51,148), &[(0,0,84), (0,0,72), (0,0,122)]), ((0,51,149), &[(0,3,188),
  (0,33,19)]), ((0,51,150), &[(0,0,109), (0,33,19)]), ((0,51,151), &[(0,0,100),
  (0,33,19)]), ((0,51,152), &[(0,0,107), (0,33,19)]), ((0,51,153), &[(0,0,102),
  (0,0,109)]), ((0,51,154), &[(0,0,110), (0,0,109)]), ((0,51,155), &[(0,3,188),
  (0,0,109)]), ((0,51,156), &[(0,0,109), (0,0,109)]), ((0,51,157), &[(0,0,99),
  (0,0,109)]), ((0,51,158), &[(0,0,107), (0,0,109)]), ((0,51,159), &[(0,0,109),
  (0,0,109), (0,0,178)]), ((0,51,160), &[(0,0,99), (0,0,109), (0,0,178)]),
  ((0,51,161), &[(0,0,109), (0,0,178)]), ((0,51,162), &[(0,0,107), (0,0,109),
  (0,0,178)]), ((0,51,163), &[(0,0,109), (0,0,109), (0,0,179)]), ((0,51,164),
  &[(0,0,99), (0,0,109), (0,0,179)]), ((0,51,165), &[(0,0,109), (0,0,179)]),
  ((0,51,166), &[(0,0,107), (0,0,109), (0,0,179)]), ((0,51,167), &[(0,0,109),
  (0,34,21), (0,0,115)]), ((0,51,168), &[(0,0,109), (0,34,21), (0,0,115),
  (0,0,178)]), ((0,51,169), &[(0,0,80), (0,0,97)]), ((0,51,170), &[(0,0,107),
  (0,0,80), (0,0,97)]), ((0,51,171), &[(0,0,77), (0,0,80), (0,0,97)]),
  ((0,51,172), &[(0,0,71), (0,0,80), (0,0,97)]), ((0,51,173), &[(0,0,114),
  (0,0,97), (0,0,100)]), ((0,51,174), &[(0,0,114), (0,0,97), (0,0,100),
  (0,34,21), (0,0,115)]), ((0,51,175), &[(0,0,114), (0,0,97), (0,0,100),
  (0,34,21), (0,0,115), (0,0,178)]), ((0,51,176), &[(0,0,112), (0,0,115)]),
  ((0,51,177), &[(0,0,110), (0,0,115)]), ((0,51,178), &[(0,3,188), (0,0,115)]),
  ((0,51,179), &[(0,0,109), (0,0,115)]), ((0,51,180), &[(0,0,112), (0,0,86)]),
  ((0,51,181), &[(0,0,110), (0,0,86)]), ((0,51,182), &[(0,3,188), (0,0,86)]),
  ((0,51,183), &[(0,0,109), (0,0,86)]), ((0,51,184), &[(0,0,107), (0,0,86)]),
  ((0,51,185), &[(0,0,77), (0,0,86)]), ((0,51,186), &[(0,0,112), (0,0,87)]),
  ((0,51,187), &[(0,0,110), (0,0,87)]), ((0,51,188), &[(0,3,188), (0,0,87)]),
  ((0,51,189), &[(0,0,109), (0,0,87)]), ((0,51,190), &[(0,0,107), (0,0,87)]),
  ((0,51,191), &[(0,0,77), (0,0,87)]), ((0,51,192), &[(0,0,107), (0,3,169)]),
  ((0,51,193), &[(0,0,77), (0,3,169)]), ((0,51,194), &[(0,0,97), (0,0,46),
  (0,0,109), (0,0,46)]), ((0,51,195), &[(0,0,66), (0,0,113)]), ((0,51,196),
  &[(0,0,99), (0,0,99)]), ((0,51,197), &[(0,0,99), (0,0,100)]), ((0,51,198),
  &[(0,0,67), (0,34,21), (0,0,107), (0,0,103)]), ((0,51,199), &[(0,0,67),
  (0,0,111), (0,0,46)]), ((0,51,200), &[(0,0,100), (0,0,66)]), ((0,51,201),
  &[(0,0,71), (0,0,121)]), ((0,51,202), &[(0,0,104), (0,0,97)]), ((0,51,203),
  &[(0,0,72), (0,0,80)]), ((0,51,204), &[(0,0,105), (0,0,110)]), ((0,51,205),
  &[(0,0,75), (0,0,75)]), ((0,51,206), &[(0,0,75), (0,0,77)]), ((0,51,207),
  &[(0,0,107), (0,0,116)]), ((0,51,208), &[(0,0,108), (0,0,109)]), ((0,51,209),
  &[(0,0,108), (0,0,110)]), ((0,51,210), &[(0,0,108), (0,0,111), (0,0,103)]),
  ((0,51,211), &[(0,0,108), (0,0,120)]), ((0,51,212), &[(0,0,109), (0,0,98)]),
  ((0,51,213), &[(0,0,109), (0,0,105), (0,0,108)]), ((0,51,214), &[(0,0,109),
  (0,0,111), (0,0,108)]), ((0,51,215), &[(0,0,80), (0,0,72)]), ((0,51,216),
  &[(0,0,112), (0,0,46), (0,0,109), (0,0,46)]), ((0,51,217), &[(0,0,80),
  (0,0,80), (0,0,77)]), ((0,51,218), &[(0,0,80), (0,0,82)]), ((0,51,219),
  &[(0,0,115), (0,0,114)]), ((0,51,220), &[(0,0,83), (0,0,118)]), ((0,51,221),
  &[(0,0,87), (0,0,98)]), ((0,51,222), &[(0,0,86), (0,34,21), (0,0,109)]),
  ((0,51,223), &[(0,0,65), (0,34,21), (0,0,109)]), ((0,51,224), &[(0,0,49),
  (0,101,229)]), ((0,51,225), &[(0,0,50), (0,101,229)]), ((0,51,226),
  &[(0,0,51), (0,101,229)]), ((0,51,227), &[(0,0,52), (0,101,229)]),
  ((0,51,228), &[(0,0,53), (0,101,229)]), ((0,51,229), &[(0,0,54),
  (0,101,229)]), ((0,51,230), &[(0,0,55), (0,101,229)]), ((0,51,231),
  &[(0,0,56), (0,101,229)]), ((0,51,232), &[(0,0,57), (0,101,229)]),
  ((0,51,233), &[(0,0,49), (0,0,48), (0,101,229)]), ((0,51,234), &[(0,0,49),
  (0,0,49), (0,101,229)]), ((0,51,235), &[(0,0,49), (0,0,50), (0,101,229)]),
  ((0,51,236), &[(0,0,49), (0,0,51), (0,101,229)]), ((0,51,237), &[(0,0,49),
  (0,0,52), (0,101,229)]), ((0,51,238), &[(0,0,49), (0,0,53), (0,101,229)]),
  ((0,51,239), &[(0,0,49), (0,0,54), (0,101,229)]), ((0,51,240), &[(0,0,49),
  (0,0,55), (0,101,229)]), ((0,51,241), &[(0,0,49), (0,0,56), (0,101,229)]),
  ((0,51,242), &[(0,0,49), (0,0,57), (0,101,229)]), ((0,51,243), &[(0,0,50),
  (0,0,48), (0,101,229)]), ((0,51,244), &[(0,0,50), (0,0,49), (0,101,229)]),
  ((0,51,245), &[(0,0,50), (0,0,50), (0,101,229)]), ((0,51,246), &[(0,0,50),
  (0,0,51), (0,101,229)]), ((0,51,247), &[(0,0,50), (0,0,52), (0,101,229)]),
  ((0,51,248), &[(0,0,50), (0,0,53), (0,101,229)]), ((0,51,249), &[(0,0,50),
  (0,0,54), (0,101,229)]), ((0,51,250), &[(0,0,50), (0,0,55), (0,101,229)]),
  ((0,51,251), &[(0,0,50), (0,0,56), (0,101,229)]), ((0,51,252), &[(0,0,50),
  (0,0,57), (0,101,229)]), ((0,51,253), &[(0,0,51), (0,0,48), (0,101,229)]),
  ((0,51,254), &[(0,0,51), (0,0,49), (0,101,229)]), ((0,51,255), &[(0,0,103),
  (0,0,97), (0,0,108)]), ((0,166,156), &[(0,4,74)]), ((0,166,157), &[(0,4,76)]),
  ((0,167,112), &[(0,167,111)]), ((0,167,248), &[(0,1,38)]), ((0,167,249),
  &[(0,1,83)]), ((0,171,92), &[(0,167,39)]), ((0,171,93), &[(0,171,55)]),
  ((0,171,94), &[(0,2,107)]), ((0,171,95), &[(0,171,82)]), ((0,249,0),
  &[(0,140,72)]), ((0,249,1), &[(0,102,244)]), ((0,249,2), &[(0,142,202)]),
  ((0,249,3), &[(0,140,200)]), ((0,249,4), &[(0,110,209)]), ((0,249,5),
  &[(0,78,50)]), ((0,249,6), &[(0,83,229)]), ((0,249,7), &[(0,159,156)]),
  ((0,249,8), &[(0,159,156)]), ((0,249,9), &[(0,89,81)]), ((0,249,10),
  &[(0,145,209)]), ((0,249,11), &[(0,85,135)]), ((0,249,12), &[(0,89,72)]),
  ((0,249,13), &[(0,97,246)]), ((0,249,14), &[(0,118,105)]), ((0,249,15),
  &[(0,127,133)]), ((0,249,16), &[(0,134,63)]), ((0,249,17), &[(0,135,186)]),
  ((0,249,18), &[(0,136,248)]), ((0,249,19), &[(0,144,143)]), ((0,249,20),
  &[(0,106,2)]), ((0,249,21), &[(0,109,27)]), ((0,249,22), &[(0,112,217)]),
  ((0,249,23), &[(0,115,222)]), ((0,249,24), &[(0,132,61)]), ((0,249,25),
  &[(0,145,106)]), ((0,249,26), &[(0,153,241)]), ((0,249,27), &[(0,78,130)]),
  ((0,249,28), &[(0,83,117)]), ((0,249,29), &[(0,107,4)]), ((0,249,30),
  &[(0,114,27)]), ((0,249,31), &[(0,134,45)]), ((0,249,32), &[(0,158,30)]),
  ((0,249,33), &[(0,93,80)]), ((0,249,34), &[(0,111,235)]), ((0,249,35),
  &[(0,133,205)]), ((0,249,36), &[(0,137,100)]), ((0,249,37), &[(0,98,201)]),
  ((0,249,38), &[(0,129,216)]), ((0,249,39), &[(0,136,31)]), ((0,249,40),
  &[(0,94,202)]), ((0,249,41), &[(0,103,23)]), ((0,249,42), &[(0,109,106)]),
  ((0,249,43), &[(0,114,252)]), ((0,249,44), &[(0,144,206)]), ((0,249,45),
  &[(0,79,134)]), ((0,249,46), &[(0,81,183)]), ((0,249,47), &[(0,82,222)]),
  ((0,249,48), &[(0,100,196)]), ((0,249,49), &[(0,106,211)]), ((0,249,50),
  &[(0,114,16)]), ((0,249,51), &[(0,118,231)]), ((0,249,52), &[(0,128,1)]),
  ((0,249,53), &[(0,134,6)]), ((0,249,54), &[(0,134,92)]), ((0,249,55),
  &[(0,141,239)]), ((0,249,56), &[(0,151,50)]), ((0,249,57), &[(0,155,111)]),
  ((0,249,58), &[(0,157,250)]), ((0,249,59), &[(0,120,140)]), ((0,249,60),
  &[(0,121,127)]), ((0,249,61), &[(0,125,160)]), ((0,249,62), &[(0,131,201)]),
  ((0,249,63), &[(0,147,4)]), ((0,249,64), &[(0,158,127)]), ((0,249,65),
  &[(0,138,214)]), ((0,249,66), &[(0,88,223)]), ((0,249,67), &[(0,95,4)]),
  ((0,249,68), &[(0,124,96)]), ((0,249,69), &[(0,128,126)]), ((0,249,70),
  &[(0,114,98)]), ((0,249,71), &[(0,120,202)]), ((0,249,72), &[(0,140,194)]),
  ((0,249,73), &[(0,150,247)]), ((0,249,74), &[(0,88,216)]), ((0,249,75),
  &[(0,92,98)]), ((0,249,76), &[(0,106,19)]), ((0,249,77), &[(0,109,218)]),
  ((0,249,78), &[(0,111,15)]), ((0,249,79), &[(0,125,47)]), ((0,249,80),
  &[(0,126,55)]), ((0,249,81), &[(0,150,75)]), ((0,249,82), &[(0,82,210)]),
  ((0,249,83), &[(0,128,139)]), ((0,249,84), &[(0,81,220)]), ((0,249,85),
  &[(0,81,204)]), ((0,249,86), &[(0,122,28)]), ((0,249,87), &[(0,125,190)]),
  ((0,249,88), &[(0,131,241)]), ((0,249,89), &[(0,150,117)]), ((0,249,90),
  &[(0,139,128)]), ((0,249,91), &[(0,98,207)]), ((0,249,92), &[(0,106,2)]),
  ((0,249,93), &[(0,138,254)]), ((0,249,94), &[(0,78,57)]), ((0,249,95),
  &[(0,91,231)]), ((0,249,96), &[(0,96,18)]), ((0,249,97), &[(0,115,135)]),
  ((0,249,98), &[(0,117,112)]), ((0,249,99), &[(0,83,23)]), ((0,249,100),
  &[(0,120,251)]), ((0,249,101), &[(0,79,191)]), ((0,249,102), &[(0,95,169)]),
  ((0,249,103), &[(0,78,13)]), ((0,249,104), &[(0,108,204)]), ((0,249,105),
  &[(0,101,120)]), ((0,249,106), &[(0,125,34)]), ((0,249,107), &[(0,83,195)]),
  ((0,249,108), &[(0,88,94)]), ((0,249,109), &[(0,119,1)]), ((0,249,110),
  &[(0,132,73)]), ((0,249,111), &[(0,138,170)]), ((0,249,112), &[(0,107,186)]),
  ((0,249,113), &[(0,143,176)]), ((0,249,114), &[(0,108,136)]), ((0,249,115),
  &[(0,98,254)]), ((0,249,116), &[(0,130,229)]), ((0,249,117), &[(0,99,160)]),
  ((0,249,118), &[(0,117,101)]), ((0,249,119), &[(0,78,174)]), ((0,249,120),
  &[(0,81,105)]), ((0,249,121), &[(0,81,201)]), ((0,249,122), &[(0,104,129)]),
  ((0,249,123), &[(0,124,231)]), ((0,249,124), &[(0,130,111)]), ((0,249,125),
  &[(0,138,210)]), ((0,249,126), &[(0,145,207)]), ((0,249,127), &[(0,82,245)]),
  ((0,249,128), &[(0,84,66)]), ((0,249,129), &[(0,89,115)]), ((0,249,130),
  &[(0,94,236)]), ((0,249,131), &[(0,101,197)]), ((0,249,132), &[(0,111,254)]),
  ((0,249,133), &[(0,121,42)]), ((0,249,134), &[(0,149,173)]), ((0,249,135),
  &[(0,154,106)]), ((0,249,136), &[(0,158,151)]), ((0,249,137), &[(0,158,206)]),
  ((0,249,138), &[(0,82,155)]), ((0,249,139), &[(0,102,198)]), ((0,249,140),
  &[(0,107,119)]), ((0,249,141), &[(0,143,98)]), ((0,249,142), &[(0,94,116)]),
  ((0,249,143), &[(0,97,144)]), ((0,249,144), &[(0,98,0)]), ((0,249,145),
  &[(0,100,154)]), ((0,249,146), &[(0,111,35)]), ((0,249,147), &[(0,113,73)]),
  ((0,249,148), &[(0,116,137)]), ((0,249,149), &[(0,121,202)]), ((0,249,150),
  &[(0,125,244)]), ((0,249,151), &[(0,128,111)]), ((0,249,152), &[(0,143,38)]),
  ((0,249,153), &[(0,132,238)]), ((0,249,154), &[(0,144,35)]), ((0,249,155),
  &[(0,147,74)]), ((0,249,156), &[(0,82,23)]), ((0,249,157), &[(0,82,163)]),
  ((0,249,158), &[(0,84,189)]), ((0,249,159), &[(0,112,200)]), ((0,249,160),
  &[(0,136,194)]), ((0,249,161), &[(0,138,170)]), ((0,249,162), &[(0,94,201)]),
  ((0,249,163), &[(0,95,245)]), ((0,249,164), &[(0,99,123)]), ((0,249,165),
  &[(0,107,174)]), ((0,249,166), &[(0,124,62)]), ((0,249,167), &[(0,115,117)]),
  ((0,249,168), &[(0,78,228)]), ((0,249,169), &[(0,86,249)]), ((0,249,170),
  &[(0,91,231)]), ((0,249,171), &[(0,93,186)]), ((0,249,172), &[(0,96,28)]),
  ((0,249,173), &[(0,115,178)]), ((0,249,174), &[(0,116,105)]), ((0,249,175),
  &[(0,127,154)]), ((0,249,176), &[(0,128,70)]), ((0,249,177), &[(0,146,52)]),
  ((0,249,178), &[(0,150,246)]), ((0,249,179), &[(0,151,72)]), ((0,249,180),
  &[(0,152,24)]), ((0,249,181), &[(0,79,139)]), ((0,249,182), &[(0,121,174)]),
  ((0,249,183), &[(0,145,180)]), ((0,249,184), &[(0,150,184)]), ((0,249,185),
  &[(0,96,225)]), ((0,249,186), &[(0,78,134)]), ((0,249,187), &[(0,80,218)]),
  ((0,249,188), &[(0,91,238)]), ((0,249,189), &[(0,92,63)]), ((0,249,190),
  &[(0,101,153)]), ((0,249,191), &[(0,106,2)]), ((0,249,192), &[(0,113,206)]),
  ((0,249,193), &[(0,118,66)]), ((0,249,194), &[(0,132,252)]), ((0,249,195),
  &[(0,144,124)]), ((0,249,196), &[(0,159,141)]), ((0,249,197), &[(0,102,136)]),
  ((0,249,198), &[(0,150,46)]), ((0,249,199), &[(0,82,137)]), ((0,249,200),
  &[(0,103,123)]), ((0,249,201), &[(0,103,243)]), ((0,249,202), &[(0,109,65)]),
  ((0,249,203), &[(0,110,156)]), ((0,249,204), &[(0,116,9)]), ((0,249,205),
  &[(0,117,89)]), ((0,249,206), &[(0,120,107)]), ((0,249,207), &[(0,125,16)]),
  ((0,249,208), &[(0,152,94)]), ((0,249,209), &[(0,81,109)]), ((0,249,210),
  &[(0,98,46)]), ((0,249,211), &[(0,150,120)]), ((0,249,212), &[(0,80,43)]),
  ((0,249,213), &[(0,93,25)]), ((0,249,214), &[(0,109,234)]), ((0,249,215),
  &[(0,143,42)]), ((0,249,216), &[(0,95,139)]), ((0,249,217), &[(0,97,68)]),
  ((0,249,218), &[(0,104,23)]), ((0,249,219), &[(0,115,135)]), ((0,249,220),
  &[(0,150,134)]), ((0,249,221), &[(0,82,41)]), ((0,249,222), &[(0,84,15)]),
  ((0,249,223), &[(0,92,101)]), ((0,249,224), &[(0,102,19)]), ((0,249,225),
  &[(0,103,78)]), ((0,249,226), &[(0,104,168)]), ((0,249,227), &[(0,108,229)]),
  ((0,249,228), &[(0,116,6)]), ((0,249,229), &[(0,117,226)]), ((0,249,230),
  &[(0,127,121)]), ((0,249,231), &[(0,136,207)]), ((0,249,232), &[(0,136,225)]),
  ((0,249,233), &[(0,145,204)]), ((0,249,234), &[(0,150,226)]), ((0,249,235),
  &[(0,83,63)]), ((0,249,236), &[(0,110,186)]), ((0,249,237), &[(0,84,29)]),
  ((0,249,238), &[(0,113,208)]), ((0,249,239), &[(0,116,152)]), ((0,249,240),
  &[(0,133,250)]), ((0,249,241), &[(0,150,163)]), ((0,249,242), &[(0,156,87)]),
  ((0,249,243), &[(0,158,159)]), ((0,249,244), &[(0,103,151)]), ((0,249,245),
  &[(0,109,203)]), ((0,249,246), &[(0,129,232)]), ((0,249,247), &[(0,122,203)]),
  ((0,249,248), &[(0,123,32)]), ((0,249,249), &[(0,124,146)]), ((0,249,250),
  &[(0,114,192)]), ((0,249,251), &[(0,112,153)]), ((0,249,252), &[(0,139,88)]),
  ((0,249,253), &[(0,78,192)]), ((0,249,254), &[(0,131,54)]), ((0,249,255),
  &[(0,82,58)]), ((0,250,0), &[(0,82,7)]), ((0,250,1), &[(0,94,166)]),
  ((0,250,2), &[(0,98,211)]), ((0,250,3), &[(0,124,214)]), ((0,250,4),
  &[(0,91,133)]), ((0,250,5), &[(0,109,30)]), ((0,250,6), &[(0,102,180)]),
  ((0,250,7), &[(0,143,59)]), ((0,250,8), &[(0,136,76)]), ((0,250,9),
  &[(0,150,77)]), ((0,250,10), &[(0,137,139)]), ((0,250,11), &[(0,94,211)]),
  ((0,250,12), &[(0,81,64)]), ((0,250,13), &[(0,85,192)]), ((0,250,16),
  &[(0,88,90)]), ((0,250,18), &[(0,102,116)]), ((0,250,21), &[(0,81,222)]),
  ((0,250,22), &[(0,115,42)]), ((0,250,23), &[(0,118,202)]), ((0,250,24),
  &[(0,121,60)]), ((0,250,25), &[(0,121,94)]), ((0,250,26), &[(0,121,101)]),
  ((0,250,27), &[(0,121,143)]), ((0,250,28), &[(0,151,86)]), ((0,250,29),
  &[(0,124,190)]), ((0,250,30), &[(0,127,189)]), ((0,250,32), &[(0,134,18)]),
  ((0,250,34), &[(0,138,248)]), ((0,250,37), &[(0,144,56)]), ((0,250,38),
  &[(0,144,253)]), ((0,250,42), &[(0,152,239)]), ((0,250,43), &[(0,152,252)]),
  ((0,250,44), &[(0,153,40)]), ((0,250,45), &[(0,157,180)]), ((0,250,46),
  &[(0,144,222)]), ((0,250,47), &[(0,150,183)]), ((0,250,48), &[(0,79,174)]),
  ((0,250,49), &[(0,80,231)]), ((0,250,50), &[(0,81,77)]), ((0,250,51),
  &[(0,82,201)]), ((0,250,52), &[(0,82,228)]), ((0,250,53), &[(0,83,81)]),
  ((0,250,54), &[(0,85,157)]), ((0,250,55), &[(0,86,6)]), ((0,250,56),
  &[(0,86,104)]), ((0,250,57), &[(0,88,64)]), ((0,250,58), &[(0,88,168)]),
  ((0,250,59), &[(0,92,100)]), ((0,250,60), &[(0,92,110)]), ((0,250,61),
  &[(0,96,148)]), ((0,250,62), &[(0,97,104)]), ((0,250,63), &[(0,97,142)]),
  ((0,250,64), &[(0,97,242)]), ((0,250,65), &[(0,101,79)]), ((0,250,66),
  &[(0,101,226)]), ((0,250,67), &[(0,102,145)]), ((0,250,68), &[(0,104,133)]),
  ((0,250,69), &[(0,109,119)]), ((0,250,70), &[(0,110,26)]), ((0,250,71),
  &[(0,111,34)]), ((0,250,72), &[(0,113,110)]), ((0,250,73), &[(0,114,43)]),
  ((0,250,74), &[(0,116,34)]), ((0,250,75), &[(0,120,145)]), ((0,250,76),
  &[(0,121,62)]), ((0,250,77), &[(0,121,73)]), ((0,250,78), &[(0,121,72)]),
  ((0,250,79), &[(0,121,80)]), ((0,250,80), &[(0,121,86)]), ((0,250,81),
  &[(0,121,93)]), ((0,250,82), &[(0,121,141)]), ((0,250,83), &[(0,121,142)]),
  ((0,250,84), &[(0,122,64)]), ((0,250,85), &[(0,122,129)]), ((0,250,86),
  &[(0,123,192)]), ((0,250,87), &[(0,125,244)]), ((0,250,88), &[(0,126,9)]),
  ((0,250,89), &[(0,126,65)]), ((0,250,90), &[(0,127,114)]), ((0,250,91),
  &[(0,128,5)]), ((0,250,92), &[(0,129,237)]), ((0,250,93), &[(0,130,121)]),
  ((0,250,94), &[(0,130,121)]), ((0,250,95), &[(0,132,87)]), ((0,250,96),
  &[(0,137,16)]), ((0,250,97), &[(0,137,150)]), ((0,250,98), &[(0,139,1)]),
  ((0,250,99), &[(0,139,57)]), ((0,250,100), &[(0,140,211)]), ((0,250,101),
  &[(0,141,8)]), ((0,250,102), &[(0,143,182)]), ((0,250,103), &[(0,144,56)]),
  ((0,250,104), &[(0,150,227)]), ((0,250,105), &[(0,151,255)]), ((0,250,106),
  &[(0,152,59)]), ((0,250,107), &[(0,96,117)]), ((0,250,108), &[(2,66,238)]),
  ((0,250,109), &[(0,130,24)]), ((0,250,112), &[(0,78,38)]), ((0,250,113),
  &[(0,81,181)]), ((0,250,114), &[(0,81,104)]), ((0,250,115), &[(0,79,128)]),
  ((0,250,116), &[(0,81,69)]), ((0,250,117), &[(0,81,128)]), ((0,250,118),
  &[(0,82,199)]), ((0,250,119), &[(0,82,250)]), ((0,250,120), &[(0,85,157)]),
  ((0,250,121), &[(0,85,85)]), ((0,250,122), &[(0,85,153)]), ((0,250,123),
  &[(0,85,226)]), ((0,250,124), &[(0,88,90)]), ((0,250,125), &[(0,88,179)]),
  ((0,250,126), &[(0,89,68)]), ((0,250,127), &[(0,89,84)]), ((0,250,128),
  &[(0,90,98)]), ((0,250,129), &[(0,91,40)]), ((0,250,130), &[(0,94,210)]),
  ((0,250,131), &[(0,94,217)]), ((0,250,132), &[(0,95,105)]), ((0,250,133),
  &[(0,95,173)]), ((0,250,134), &[(0,96,216)]), ((0,250,135), &[(0,97,78)]),
  ((0,250,136), &[(0,97,8)]), ((0,250,137), &[(0,97,142)]), ((0,250,138),
  &[(0,97,96)]), ((0,250,139), &[(0,97,242)]), ((0,250,140), &[(0,98,52)]),
  ((0,250,141), &[(0,99,196)]), ((0,250,142), &[(0,100,28)]), ((0,250,143),
  &[(0,100,82)]), ((0,250,144), &[(0,101,86)]), ((0,250,145), &[(0,102,116)]),
  ((0,250,146), &[(0,103,23)]), ((0,250,147), &[(0,103,27)]), ((0,250,148),
  &[(0,103,86)]), ((0,250,149), &[(0,107,121)]), ((0,250,150), &[(0,107,186)]),
  ((0,250,151), &[(0,109,65)]), ((0,250,152), &[(0,110,219)]), ((0,250,153),
  &[(0,110,203)]), ((0,250,154), &[(0,111,34)]), ((0,250,155), &[(0,112,30)]),
  ((0,250,156), &[(0,113,110)]), ((0,250,157), &[(0,119,167)]), ((0,250,158),
  &[(0,114,53)]), ((0,250,159), &[(0,114,175)]), ((0,250,160), &[(0,115,42)]),
  ((0,250,161), &[(0,116,113)]), ((0,250,162), &[(0,117,6)]), ((0,250,163),
  &[(0,117,59)]), ((0,250,164), &[(0,118,29)]), ((0,250,165), &[(0,118,31)]),
  ((0,250,166), &[(0,118,202)]), ((0,250,167), &[(0,118,219)]), ((0,250,168),
  &[(0,118,244)]), ((0,250,169), &[(0,119,74)]), ((0,250,170), &[(0,119,64)]),
  ((0,250,171), &[(0,120,204)]), ((0,250,172), &[(0,122,177)]), ((0,250,173),
  &[(0,123,192)]), ((0,250,174), &[(0,124,123)]), ((0,250,175), &[(0,125,91)]),
  ((0,250,176), &[(0,125,244)]), ((0,250,177), &[(0,127,62)]), ((0,250,178),
  &[(0,128,5)]), ((0,250,179), &[(0,131,82)]), ((0,250,180), &[(0,131,239)]),
  ((0,250,181), &[(0,135,121)]), ((0,250,182), &[(0,137,65)]), ((0,250,183),
  &[(0,137,134)]), ((0,250,184), &[(0,137,150)]), ((0,250,185), &[(0,138,191)]),
  ((0,250,186), &[(0,138,248)]), ((0,250,187), &[(0,138,203)]), ((0,250,188),
  &[(0,139,1)]), ((0,250,189), &[(0,138,254)]), ((0,250,190), &[(0,138,237)]),
  ((0,250,191), &[(0,139,57)]), ((0,250,192), &[(0,139,138)]), ((0,250,193),
  &[(0,141,8)]), ((0,250,194), &[(0,143,56)]), ((0,250,195), &[(0,144,114)]),
  ((0,250,196), &[(0,145,153)]), ((0,250,197), &[(0,146,118)]), ((0,250,198),
  &[(0,150,124)]), ((0,250,199), &[(0,150,227)]), ((0,250,200), &[(0,151,86)]),
  ((0,250,201), &[(0,151,219)]), ((0,250,202), &[(0,151,255)]), ((0,250,203),
  &[(0,152,11)]), ((0,250,204), &[(0,152,59)]), ((0,250,205), &[(0,155,18)]),
  ((0,250,206), &[(0,159,156)]), ((0,250,207), &[(2,40,74)]), ((0,250,208),
  &[(2,40,68)]), ((0,250,209), &[(2,51,213)]), ((0,250,210), &[(0,59,157)]),
  ((0,250,211), &[(0,64,24)]), ((0,250,212), &[(0,64,57)]), ((0,250,213),
  &[(2,82,73)]), ((0,250,214), &[(2,92,208)]), ((0,250,215), &[(2,126,211)]),
  ((0,250,216), &[(0,159,67)]), ((0,250,217), &[(0,159,142)]), ((0,251,0),
  &[(0,0,102), (0,0,102)]), ((0,251,1), &[(0,0,102), (0,0,105)]), ((0,251,2),
  &[(0,0,102), (0,0,108)]), ((0,251,3), &[(0,0,102), (0,0,102), (0,0,105)]),
  ((0,251,4), &[(0,0,102), (0,0,102), (0,0,108)]), ((0,251,5), &[(0,1,127),
  (0,0,116)]), ((0,251,6), &[(0,0,115), (0,0,116)]), ((0,251,19), &[(0,5,116),
  (0,5,118)]), ((0,251,20), &[(0,5,116), (0,5,101)]), ((0,251,21), &[(0,5,116),
  (0,5,107)]), ((0,251,22), &[(0,5,126), (0,5,118)]), ((0,251,23), &[(0,5,116),
  (0,5,109)]), ((0,251,29), &[(0,5,217), (0,5,180)]), ((0,251,31), &[(0,5,242),
  (0,5,183)]), ((0,251,32), &[(0,5,226)]), ((0,251,33), &[(0,5,208)]),
  ((0,251,34), &[(0,5,211)]), ((0,251,35), &[(0,5,212)]), ((0,251,36),
  &[(0,5,219)]), ((0,251,37), &[(0,5,220)]), ((0,251,38), &[(0,5,221)]),
  ((0,251,39), &[(0,5,232)]), ((0,251,40), &[(0,5,234)]), ((0,251,41),
  &[(0,0,43)]), ((0,251,42), &[(0,5,233), (0,5,193)]), ((0,251,43), &[(0,5,233),
  (0,5,194)]), ((0,251,44), &[(0,251,73), (0,5,193)]), ((0,251,45),
  &[(0,251,73), (0,5,194)]), ((0,251,46), &[(0,5,208), (0,5,183)]), ((0,251,47),
  &[(0,5,208), (0,5,184)]), ((0,251,48), &[(0,5,208), (0,5,188)]), ((0,251,49),
  &[(0,5,209), (0,5,188)]), ((0,251,50), &[(0,5,210), (0,5,188)]), ((0,251,51),
  &[(0,5,211), (0,5,188)]), ((0,251,52), &[(0,5,212), (0,5,188)]), ((0,251,53),
  &[(0,5,213), (0,5,188)]), ((0,251,54), &[(0,5,214), (0,5,188)]), ((0,251,56),
  &[(0,5,216), (0,5,188)]), ((0,251,57), &[(0,5,217), (0,5,188)]), ((0,251,58),
  &[(0,5,218), (0,5,188)]), ((0,251,59), &[(0,5,219), (0,5,188)]), ((0,251,60),
  &[(0,5,220), (0,5,188)]), ((0,251,62), &[(0,5,222), (0,5,188)]), ((0,251,64),
  &[(0,5,224), (0,5,188)]), ((0,251,65), &[(0,5,225), (0,5,188)]), ((0,251,67),
  &[(0,5,227), (0,5,188)]), ((0,251,68), &[(0,5,228), (0,5,188)]), ((0,251,70),
  &[(0,5,230), (0,5,188)]), ((0,251,71), &[(0,5,231), (0,5,188)]), ((0,251,72),
  &[(0,5,232), (0,5,188)]), ((0,251,73), &[(0,5,233), (0,5,188)]), ((0,251,74),
  &[(0,5,234), (0,5,188)]), ((0,251,75), &[(0,5,213), (0,5,185)]), ((0,251,76),
  &[(0,5,209), (0,5,191)]), ((0,251,77), &[(0,5,219), (0,5,191)]), ((0,251,78),
  &[(0,5,228), (0,5,191)]), ((0,251,79), &[(0,5,208), (0,5,220)]), ((0,251,80),
  &[(0,6,113)]), ((0,251,81), &[(0,6,113)]), ((0,251,82), &[(0,6,123)]),
  ((0,251,83), &[(0,6,123)]), ((0,251,84), &[(0,6,123)]), ((0,251,85),
  &[(0,6,123)]), ((0,251,86), &[(0,6,126)]), ((0,251,87), &[(0,6,126)]),
  ((0,251,88), &[(0,6,126)]), ((0,251,89), &[(0,6,126)]), ((0,251,90),
  &[(0,6,128)]), ((0,251,91), &[(0,6,128)]), ((0,251,92), &[(0,6,128)]),
  ((0,251,93), &[(0,6,128)]), ((0,251,94), &[(0,6,122)]), ((0,251,95),
  &[(0,6,122)]), ((0,251,96), &[(0,6,122)]), ((0,251,97), &[(0,6,122)]),
  ((0,251,98), &[(0,6,127)]), ((0,251,99), &[(0,6,127)]), ((0,251,100),
  &[(0,6,127)]), ((0,251,101), &[(0,6,127)]), ((0,251,102), &[(0,6,121)]),
  ((0,251,103), &[(0,6,121)]), ((0,251,104), &[(0,6,121)]), ((0,251,105),
  &[(0,6,121)]), ((0,251,106), &[(0,6,164)]), ((0,251,107), &[(0,6,164)]),
  ((0,251,108), &[(0,6,164)]), ((0,251,109), &[(0,6,164)]), ((0,251,110),
  &[(0,6,166)]), ((0,251,111), &[(0,6,166)]), ((0,251,112), &[(0,6,166)]),
  ((0,251,113), &[(0,6,166)]), ((0,251,114), &[(0,6,132)]), ((0,251,115),
  &[(0,6,132)]), ((0,251,116), &[(0,6,132)]), ((0,251,117), &[(0,6,132)]),
  ((0,251,118), &[(0,6,131)]), ((0,251,119), &[(0,6,131)]), ((0,251,120),
  &[(0,6,131)]), ((0,251,121), &[(0,6,131)]), ((0,251,122), &[(0,6,134)]),
  ((0,251,123), &[(0,6,134)]), ((0,251,124), &[(0,6,134)]), ((0,251,125),
  &[(0,6,134)]), ((0,251,126), &[(0,6,135)]), ((0,251,127), &[(0,6,135)]),
  ((0,251,128), &[(0,6,135)]), ((0,251,129), &[(0,6,135)]), ((0,251,130),
  &[(0,6,141)]), ((0,251,131), &[(0,6,141)]), ((0,251,132), &[(0,6,140)]),
  ((0,251,133), &[(0,6,140)]), ((0,251,134), &[(0,6,142)]), ((0,251,135),
  &[(0,6,142)]), ((0,251,136), &[(0,6,136)]), ((0,251,137), &[(0,6,136)]),
  ((0,251,138), &[(0,6,152)]), ((0,251,139), &[(0,6,152)]), ((0,251,140),
  &[(0,6,145)]), ((0,251,141), &[(0,6,145)]), ((0,251,142), &[(0,6,169)]),
  ((0,251,143), &[(0,6,169)]), ((0,251,144), &[(0,6,169)]), ((0,251,145),
  &[(0,6,169)]), ((0,251,146), &[(0,6,175)]), ((0,251,147), &[(0,6,175)]),
  ((0,251,148), &[(0,6,175)]), ((0,251,149), &[(0,6,175)]), ((0,251,150),
  &[(0,6,179)]), ((0,251,151), &[(0,6,179)]), ((0,251,152), &[(0,6,179)]),
  ((0,251,153), &[(0,6,179)]), ((0,251,154), &[(0,6,177)]), ((0,251,155),
  &[(0,6,177)]), ((0,251,156), &[(0,6,177)]), ((0,251,157), &[(0,6,177)]),
  ((0,251,158), &[(0,6,186)]), ((0,251,159), &[(0,6,186)]), ((0,251,160),
  &[(0,6,187)]), ((0,251,161), &[(0,6,187)]), ((0,251,162), &[(0,6,187)]),
  ((0,251,163), &[(0,6,187)]), ((0,251,164), &[(0,6,192)]), ((0,251,165),
  &[(0,6,192)]), ((0,251,166), &[(0,6,193)]), ((0,251,167), &[(0,6,193)]),
  ((0,251,168), &[(0,6,193)]), ((0,251,169), &[(0,6,193)]), ((0,251,170),
  &[(0,6,190)]), ((0,251,171), &[(0,6,190)]), ((0,251,172), &[(0,6,190)]),
  ((0,251,173), &[(0,6,190)]), ((0,251,174), &[(0,6,210)]), ((0,251,175),
  &[(0,6,210)]), ((0,251,176), &[(0,6,211)]), ((0,251,177), &[(0,6,211)]),
  ((0,251,211), &[(0,6,173)]), ((0,251,212), &[(0,6,173)]), ((0,251,213),
  &[(0,6,173)]), ((0,251,214), &[(0,6,173)]), ((0,251,215), &[(0,6,199)]),
  ((0,251,216), &[(0,6,199)]), ((0,251,217), &[(0,6,198)]), ((0,251,218),
  &[(0,6,198)]), ((0,251,219), &[(0,6,200)]), ((0,251,220), &[(0,6,200)]),
  ((0,251,221), &[(0,6,119)]), ((0,251,222), &[(0,6,203)]), ((0,251,223),
  &[(0,6,203)]), ((0,251,224), &[(0,6,197)]), ((0,251,225), &[(0,6,197)]),
  ((0,251,226), &[(0,6,201)]), ((0,251,227), &[(0,6,201)]), ((0,251,228),
  &[(0,6,208)]), ((0,251,229), &[(0,6,208)]), ((0,251,230), &[(0,6,208)]),
  ((0,251,231), &[(0,6,208)]), ((0,251,232), &[(0,6,73)]), ((0,251,233),
  &[(0,6,73)]), ((0,251,234), &[(0,6,38), (0,6,39)]), ((0,251,235), &[(0,6,38),
  (0,6,39)]), ((0,251,236), &[(0,6,38), (0,6,213)]), ((0,251,237), &[(0,6,38),
  (0,6,213)]), ((0,251,238), &[(0,6,38), (0,6,72)]), ((0,251,239), &[(0,6,38),
  (0,6,72)]), ((0,251,240), &[(0,6,38), (0,6,199)]), ((0,251,241), &[(0,6,38),
  (0,6,199)]), ((0,251,242), &[(0,6,38), (0,6,198)]), ((0,251,243), &[(0,6,38),
  (0,6,198)]), ((0,251,244), &[(0,6,38), (0,6,200)]), ((0,251,245), &[(0,6,38),
  (0,6,200)]), ((0,251,246), &[(0,6,38), (0,6,208)]), ((0,251,247), &[(0,6,38),
  (0,6,208)]), ((0,251,248), &[(0,6,38), (0,6,208)]), ((0,251,249), &[(0,6,38),
  (0,6,73)]), ((0,251,250), &[(0,6,38), (0,6,73)]), ((0,251,251), &[(0,6,38),
  (0,6,73)]), ((0,251,252), &[(0,6,204)]), ((0,251,253), &[(0,6,204)]),
  ((0,251,254), &[(0,6,204)]), ((0,251,255), &[(0,6,204)]), ((0,252,0),
  &[(0,6,38), (0,6,44)]), ((0,252,1), &[(0,6,38), (0,6,45)]), ((0,252,2),
  &[(0,6,38), (0,6,69)]), ((0,252,3), &[(0,6,38), (0,6,73)]), ((0,252,4),
  &[(0,6,38), (0,6,74)]), ((0,252,5), &[(0,6,40), (0,6,44)]), ((0,252,6),
  &[(0,6,40), (0,6,45)]), ((0,252,7), &[(0,6,40), (0,6,46)]), ((0,252,8),
  &[(0,6,40), (0,6,69)]), ((0,252,9), &[(0,6,40), (0,6,73)]), ((0,252,10),
  &[(0,6,40), (0,6,74)]), ((0,252,11), &[(0,6,42), (0,6,44)]), ((0,252,12),
  &[(0,6,42), (0,6,45)]), ((0,252,13), &[(0,6,42), (0,6,46)]), ((0,252,14),
  &[(0,6,42), (0,6,69)]), ((0,252,15), &[(0,6,42), (0,6,73)]), ((0,252,16),
  &[(0,6,42), (0,6,74)]), ((0,252,17), &[(0,6,43), (0,6,44)]), ((0,252,18),
  &[(0,6,43), (0,6,69)]), ((0,252,19), &[(0,6,43), (0,6,73)]), ((0,252,20),
  &[(0,6,43), (0,6,74)]), ((0,252,21), &[(0,6,44), (0,6,45)]), ((0,252,22),
  &[(0,6,44), (0,6,69)]), ((0,252,23), &[(0,6,45), (0,6,44)]), ((0,252,24),
  &[(0,6,45), (0,6,69)]), ((0,252,25), &[(0,6,46), (0,6,44)]), ((0,252,26),
  &[(0,6,46), (0,6,45)]), ((0,252,27), &[(0,6,46), (0,6,69)]), ((0,252,28),
  &[(0,6,51), (0,6,44)]), ((0,252,29), &[(0,6,51), (0,6,45)]), ((0,252,30),
  &[(0,6,51), (0,6,46)]), ((0,252,31), &[(0,6,51), (0,6,69)]), ((0,252,32),
  &[(0,6,53), (0,6,45)]), ((0,252,33), &[(0,6,53), (0,6,69)]), ((0,252,34),
  &[(0,6,54), (0,6,44)]), ((0,252,35), &[(0,6,54), (0,6,45)]), ((0,252,36),
  &[(0,6,54), (0,6,46)]), ((0,252,37), &[(0,6,54), (0,6,69)]), ((0,252,38),
  &[(0,6,55), (0,6,45)]), ((0,252,39), &[(0,6,55), (0,6,69)]), ((0,252,40),
  &[(0,6,56), (0,6,69)]), ((0,252,41), &[(0,6,57), (0,6,44)]), ((0,252,42),
  &[(0,6,57), (0,6,69)]), ((0,252,43), &[(0,6,58), (0,6,44)]), ((0,252,44),
  &[(0,6,58), (0,6,69)]), ((0,252,45), &[(0,6,65), (0,6,44)]), ((0,252,46),
  &[(0,6,65), (0,6,45)]), ((0,252,47), &[(0,6,65), (0,6,46)]), ((0,252,48),
  &[(0,6,65), (0,6,69)]), ((0,252,49), &[(0,6,65), (0,6,73)]), ((0,252,50),
  &[(0,6,65), (0,6,74)]), ((0,252,51), &[(0,6,66), (0,6,45)]), ((0,252,52),
  &[(0,6,66), (0,6,69)]), ((0,252,53), &[(0,6,66), (0,6,73)]), ((0,252,54),
  &[(0,6,66), (0,6,74)]), ((0,252,55), &[(0,6,67), (0,6,39)]), ((0,252,56),
  &[(0,6,67), (0,6,44)]), ((0,252,57), &[(0,6,67), (0,6,45)]), ((0,252,58),
  &[(0,6,67), (0,6,46)]), ((0,252,59), &[(0,6,67), (0,6,68)]), ((0,252,60),
  &[(0,6,67), (0,6,69)]), ((0,252,61), &[(0,6,67), (0,6,73)]), ((0,252,62),
  &[(0,6,67), (0,6,74)]), ((0,252,63), &[(0,6,68), (0,6,44)]), ((0,252,64),
  &[(0,6,68), (0,6,45)]), ((0,252,65), &[(0,6,68), (0,6,46)]), ((0,252,66),
  &[(0,6,68), (0,6,69)]), ((0,252,67), &[(0,6,68), (0,6,73)]), ((0,252,68),
  &[(0,6,68), (0,6,74)]), ((0,252,69), &[(0,6,69), (0,6,44)]), ((0,252,70),
  &[(0,6,69), (0,6,45)]), ((0,252,71), &[(0,6,69), (0,6,46)]), ((0,252,72),
  &[(0,6,69), (0,6,69)]), ((0,252,73), &[(0,6,69), (0,6,73)]), ((0,252,74),
  &[(0,6,69), (0,6,74)]), ((0,252,75), &[(0,6,70), (0,6,44)]), ((0,252,76),
  &[(0,6,70), (0,6,45)]), ((0,252,77), &[(0,6,70), (0,6,46)]), ((0,252,78),
  &[(0,6,70), (0,6,69)]), ((0,252,79), &[(0,6,70), (0,6,73)]), ((0,252,80),
  &[(0,6,70), (0,6,74)]), ((0,252,81), &[(0,6,71), (0,6,44)]), ((0,252,82),
  &[(0,6,71), (0,6,69)]), ((0,252,83), &[(0,6,71), (0,6,73)]), ((0,252,84),
  &[(0,6,71), (0,6,74)]), ((0,252,85), &[(0,6,74), (0,6,44)]), ((0,252,86),
  &[(0,6,74), (0,6,45)]), ((0,252,87), &[(0,6,74), (0,6,46)]), ((0,252,88),
  &[(0,6,74), (0,6,69)]), ((0,252,89), &[(0,6,74), (0,6,73)]), ((0,252,90),
  &[(0,6,74), (0,6,74)]), ((0,252,91), &[(0,6,48), (0,6,112)]), ((0,252,92),
  &[(0,6,49), (0,6,112)]), ((0,252,93), &[(0,6,73), (0,6,112)]), ((0,252,94),
  &[(0,0,32), (0,6,76), (0,6,81)]), ((0,252,95), &[(0,0,32), (0,6,77),
  (0,6,81)]), ((0,252,96), &[(0,0,32), (0,6,78), (0,6,81)]), ((0,252,97),
  &[(0,0,32), (0,6,79), (0,6,81)]), ((0,252,98), &[(0,0,32), (0,6,80),
  (0,6,81)]), ((0,252,99), &[(0,0,32), (0,6,81), (0,6,112)]), ((0,252,100),
  &[(0,6,38), (0,6,49)]), ((0,252,101), &[(0,6,38), (0,6,50)]), ((0,252,102),
  &[(0,6,38), (0,6,69)]), ((0,252,103), &[(0,6,38), (0,6,70)]), ((0,252,104),
  &[(0,6,38), (0,6,73)]), ((0,252,105), &[(0,6,38), (0,6,74)]), ((0,252,106),
  &[(0,6,40), (0,6,49)]), ((0,252,107), &[(0,6,40), (0,6,50)]), ((0,252,108),
  &[(0,6,40), (0,6,69)]), ((0,252,109), &[(0,6,40), (0,6,70)]), ((0,252,110),
  &[(0,6,40), (0,6,73)]), ((0,252,111), &[(0,6,40), (0,6,74)]), ((0,252,112),
  &[(0,6,42), (0,6,49)]), ((0,252,113), &[(0,6,42), (0,6,50)]), ((0,252,114),
  &[(0,6,42), (0,6,69)]), ((0,252,115), &[(0,6,42), (0,6,70)]), ((0,252,116),
  &[(0,6,42), (0,6,73)]), ((0,252,117), &[(0,6,42), (0,6,74)]), ((0,252,118),
  &[(0,6,43), (0,6,49)]), ((0,252,119), &[(0,6,43), (0,6,50)]), ((0,252,120),
  &[(0,6,43), (0,6,69)]), ((0,252,121), &[(0,6,43), (0,6,70)]), ((0,252,122),
  &[(0,6,43), (0,6,73)]), ((0,252,123), &[(0,6,43), (0,6,74)]), ((0,252,124),
  &[(0,6,65), (0,6,73)]), ((0,252,125), &[(0,6,65), (0,6,74)]), ((0,252,126),
  &[(0,6,66), (0,6,73)]), ((0,252,127), &[(0,6,66), (0,6,74)]), ((0,252,128),
  &[(0,6,67), (0,6,39)]), ((0,252,129), &[(0,6,67), (0,6,68)]), ((0,252,130),
  &[(0,6,67), (0,6,69)]), ((0,252,131), &[(0,6,67), (0,6,73)]), ((0,252,132),
  &[(0,6,67), (0,6,74)]), ((0,252,133), &[(0,6,68), (0,6,69)]), ((0,252,134),
  &[(0,6,68), (0,6,73)]), ((0,252,135), &[(0,6,68), (0,6,74)]), ((0,252,136),
  &[(0,6,69), (0,6,39)]), ((0,252,137), &[(0,6,69), (0,6,69)]), ((0,252,138),
  &[(0,6,70), (0,6,49)]), ((0,252,139), &[(0,6,70), (0,6,50)]), ((0,252,140),
  &[(0,6,70), (0,6,69)]), ((0,252,141), &[(0,6,70), (0,6,70)]), ((0,252,142),
  &[(0,6,70), (0,6,73)]), ((0,252,143), &[(0,6,70), (0,6,74)]), ((0,252,144),
  &[(0,6,73), (0,6,112)]), ((0,252,145), &[(0,6,74), (0,6,49)]), ((0,252,146),
  &[(0,6,74), (0,6,50)]), ((0,252,147), &[(0,6,74), (0,6,69)]), ((0,252,148),
  &[(0,6,74), (0,6,70)]), ((0,252,149), &[(0,6,74), (0,6,73)]), ((0,252,150),
  &[(0,6,74), (0,6,74)]), ((0,252,151), &[(0,6,38), (0,6,44)]), ((0,252,152),
  &[(0,6,38), (0,6,45)]), ((0,252,153), &[(0,6,38), (0,6,46)]), ((0,252,154),
  &[(0,6,38), (0,6,69)]), ((0,252,155), &[(0,6,38), (0,6,71)]), ((0,252,156),
  &[(0,6,40), (0,6,44)]), ((0,252,157), &[(0,6,40), (0,6,45)]), ((0,252,158),
  &[(0,6,40), (0,6,46)]), ((0,252,159), &[(0,6,40), (0,6,69)]), ((0,252,160),
  &[(0,6,40), (0,6,71)]), ((0,252,161), &[(0,6,42), (0,6,44)]), ((0,252,162),
  &[(0,6,42), (0,6,45)]), ((0,252,163), &[(0,6,42), (0,6,46)]), ((0,252,164),
  &[(0,6,42), (0,6,69)]), ((0,252,165), &[(0,6,42), (0,6,71)]), ((0,252,166),
  &[(0,6,43), (0,6,69)]), ((0,252,167), &[(0,6,44), (0,6,45)]), ((0,252,168),
  &[(0,6,44), (0,6,69)]), ((0,252,169), &[(0,6,45), (0,6,44)]), ((0,252,170),
  &[(0,6,45), (0,6,69)]), ((0,252,171), &[(0,6,46), (0,6,44)]), ((0,252,172),
  &[(0,6,46), (0,6,69)]), ((0,252,173), &[(0,6,51), (0,6,44)]), ((0,252,174),
  &[(0,6,51), (0,6,45)]), ((0,252,175), &[(0,6,51), (0,6,46)]), ((0,252,176),
  &[(0,6,51), (0,6,69)]), ((0,252,177), &[(0,6,53), (0,6,45)]), ((0,252,178),
  &[(0,6,53), (0,6,46)]), ((0,252,179), &[(0,6,53), (0,6,69)]), ((0,252,180),
  &[(0,6,54), (0,6,44)]), ((0,252,181), &[(0,6,54), (0,6,45)]), ((0,252,182),
  &[(0,6,54), (0,6,46)]), ((0,252,183), &[(0,6,54), (0,6,69)]), ((0,252,184),
  &[(0,6,55), (0,6,45)]), ((0,252,185), &[(0,6,56), (0,6,69)]), ((0,252,186),
  &[(0,6,57), (0,6,44)]), ((0,252,187), &[(0,6,57), (0,6,69)]), ((0,252,188),
  &[(0,6,58), (0,6,44)]), ((0,252,189), &[(0,6,58), (0,6,69)]), ((0,252,190),
  &[(0,6,65), (0,6,44)]), ((0,252,191), &[(0,6,65), (0,6,45)]), ((0,252,192),
  &[(0,6,65), (0,6,46)]), ((0,252,193), &[(0,6,65), (0,6,69)]), ((0,252,194),
  &[(0,6,66), (0,6,45)]), ((0,252,195), &[(0,6,66), (0,6,69)]), ((0,252,196),
  &[(0,6,67), (0,6,44)]), ((0,252,197), &[(0,6,67), (0,6,45)]), ((0,252,198),
  &[(0,6,67), (0,6,46)]), ((0,252,199), &[(0,6,67), (0,6,68)]), ((0,252,200),
  &[(0,6,67), (0,6,69)]), ((0,252,201), &[(0,6,68), (0,6,44)]), ((0,252,202),
  &[(0,6,68), (0,6,45)]), ((0,252,203), &[(0,6,68), (0,6,46)]), ((0,252,204),
  &[(0,6,68), (0,6,69)]), ((0,252,205), &[(0,6,68), (0,6,71)]), ((0,252,206),
  &[(0,6,69), (0,6,44)]), ((0,252,207), &[(0,6,69), (0,6,45)]), ((0,252,208),
  &[(0,6,69), (0,6,46)]), ((0,252,209), &[(0,6,69), (0,6,69)]), ((0,252,210),
  &[(0,6,70), (0,6,44)]), ((0,252,211), &[(0,6,70), (0,6,45)]), ((0,252,212),
  &[(0,6,70), (0,6,46)]), ((0,252,213), &[(0,6,70), (0,6,69)]), ((0,252,214),
  &[(0,6,70), (0,6,71)]), ((0,252,215), &[(0,6,71), (0,6,44)]), ((0,252,216),
  &[(0,6,71), (0,6,69)]), ((0,252,217), &[(0,6,71), (0,6,112)]), ((0,252,218),
  &[(0,6,74), (0,6,44)]), ((0,252,219), &[(0,6,74), (0,6,45)]), ((0,252,220),
  &[(0,6,74), (0,6,46)]), ((0,252,221), &[(0,6,74), (0,6,69)]), ((0,252,222),
  &[(0,6,74), (0,6,71)]), ((0,252,223), &[(0,6,38), (0,6,69)]), ((0,252,224),
  &[(0,6,38), (0,6,71)]), ((0,252,225), &[(0,6,40), (0,6,69)]), ((0,252,226),
  &[(0,6,40), (0,6,71)]), ((0,252,227), &[(0,6,42), (0,6,69)]), ((0,252,228),
  &[(0,6,42), (0,6,71)]), ((0,252,229), &[(0,6,43), (0,6,69)]), ((0,252,230),
  &[(0,6,43), (0,6,71)]), ((0,252,231), &[(0,6,51), (0,6,69)]), ((0,252,232),
  &[(0,6,51), (0,6,71)]), ((0,252,233), &[(0,6,52), (0,6,69)]), ((0,252,234),
  &[(0,6,52), (0,6,71)]), ((0,252,235), &[(0,6,67), (0,6,68)]), ((0,252,236),
  &[(0,6,67), (0,6,69)]), ((0,252,237), &[(0,6,68), (0,6,69)]), ((0,252,238),
  &[(0,6,70), (0,6,69)]), ((0,252,239), &[(0,6,70), (0,6,71)]), ((0,252,240),
  &[(0,6,74), (0,6,69)]), ((0,252,241), &[(0,6,74), (0,6,71)]), ((0,252,242),
  &[(0,6,64), (0,6,78), (0,6,81)]), ((0,252,243), &[(0,6,64), (0,6,79),
  (0,6,81)]), ((0,252,244), &[(0,6,64), (0,6,80), (0,6,81)]), ((0,252,245),
  &[(0,6,55), (0,6,73)]), ((0,252,246), &[(0,6,55), (0,6,74)]), ((0,252,247),
  &[(0,6,57), (0,6,73)]), ((0,252,248), &[(0,6,57), (0,6,74)]), ((0,252,249),
  &[(0,6,58), (0,6,73)]), ((0,252,250), &[(0,6,58), (0,6,74)]), ((0,252,251),
  &[(0,6,51), (0,6,73)]), ((0,252,252), &[(0,6,51), (0,6,74)]), ((0,252,253),
  &[(0,6,52), (0,6,73)]), ((0,252,254), &[(0,6,52), (0,6,74)]), ((0,252,255),
  &[(0,6,45), (0,6,73)]), ((0,253,0), &[(0,6,45), (0,6,74)]), ((0,253,1),
  &[(0,6,44), (0,6,73)]), ((0,253,2), &[(0,6,44), (0,6,74)]), ((0,253,3),
  &[(0,6,46), (0,6,73)]), ((0,253,4), &[(0,6,46), (0,6,74)]), ((0,253,5),
  &[(0,6,53), (0,6,73)]), ((0,253,6), &[(0,6,53), (0,6,74)]), ((0,253,7),
  &[(0,6,54), (0,6,73)]), ((0,253,8), &[(0,6,54), (0,6,74)]), ((0,253,9),
  &[(0,6,52), (0,6,44)]), ((0,253,10), &[(0,6,52), (0,6,45)]), ((0,253,11),
  &[(0,6,52), (0,6,46)]), ((0,253,12), &[(0,6,52), (0,6,69)]), ((0,253,13),
  &[(0,6,52), (0,6,49)]), ((0,253,14), &[(0,6,51), (0,6,49)]), ((0,253,15),
  &[(0,6,53), (0,6,49)]), ((0,253,16), &[(0,6,54), (0,6,49)]), ((0,253,17),
  &[(0,6,55), (0,6,73)]), ((0,253,18), &[(0,6,55), (0,6,74)]), ((0,253,19),
  &[(0,6,57), (0,6,73)]), ((0,253,20), &[(0,6,57), (0,6,74)]), ((0,253,21),
  &[(0,6,58), (0,6,73)]), ((0,253,22), &[(0,6,58), (0,6,74)]), ((0,253,23),
  &[(0,6,51), (0,6,73)]), ((0,253,24), &[(0,6,51), (0,6,74)]), ((0,253,25),
  &[(0,6,52), (0,6,73)]), ((0,253,26), &[(0,6,52), (0,6,74)]), ((0,253,27),
  &[(0,6,45), (0,6,73)]), ((0,253,28), &[(0,6,45), (0,6,74)]), ((0,253,29),
  &[(0,6,44), (0,6,73)]), ((0,253,30), &[(0,6,44), (0,6,74)]), ((0,253,31),
  &[(0,6,46), (0,6,73)]), ((0,253,32), &[(0,6,46), (0,6,74)]), ((0,253,33),
  &[(0,6,53), (0,6,73)]), ((0,253,34), &[(0,6,53), (0,6,74)]), ((0,253,35),
  &[(0,6,54), (0,6,73)]), ((0,253,36), &[(0,6,54), (0,6,74)]), ((0,253,37),
  &[(0,6,52), (0,6,44)]), ((0,253,38), &[(0,6,52), (0,6,45)]), ((0,253,39),
  &[(0,6,52), (0,6,46)]), ((0,253,40), &[(0,6,52), (0,6,69)]), ((0,253,41),
  &[(0,6,52), (0,6,49)]), ((0,253,42), &[(0,6,51), (0,6,49)]), ((0,253,43),
  &[(0,6,53), (0,6,49)]), ((0,253,44), &[(0,6,54), (0,6,49)]), ((0,253,45),
  &[(0,6,52), (0,6,44)]), ((0,253,46), &[(0,6,52), (0,6,45)]), ((0,253,47),
  &[(0,6,52), (0,6,46)]), ((0,253,48), &[(0,6,52), (0,6,69)]), ((0,253,49),
  &[(0,6,51), (0,6,71)]), ((0,253,50), &[(0,6,52), (0,6,71)]), ((0,253,51),
  &[(0,6,55), (0,6,69)]), ((0,253,52), &[(0,6,51), (0,6,44)]), ((0,253,53),
  &[(0,6,51), (0,6,45)]), ((0,253,54), &[(0,6,51), (0,6,46)]), ((0,253,55),
  &[(0,6,52), (0,6,44)]), ((0,253,56), &[(0,6,52), (0,6,45)]), ((0,253,57),
  &[(0,6,52), (0,6,46)]), ((0,253,58), &[(0,6,55), (0,6,69)]), ((0,253,59),
  &[(0,6,56), (0,6,69)]), ((0,253,60), &[(0,6,39), (0,6,75)]), ((0,253,61),
  &[(0,6,39), (0,6,75)]), ((0,253,80), &[(0,6,42), (0,6,44), (0,6,69)]),
  ((0,253,81), &[(0,6,42), (0,6,45), (0,6,44)]), ((0,253,82), &[(0,6,42),
  (0,6,45), (0,6,44)]), ((0,253,83), &[(0,6,42), (0,6,45), (0,6,69)]),
  ((0,253,84), &[(0,6,42), (0,6,46), (0,6,69)]), ((0,253,85), &[(0,6,42),
  (0,6,69), (0,6,44)]), ((0,253,86), &[(0,6,42), (0,6,69), (0,6,45)]),
  ((0,253,87), &[(0,6,42), (0,6,69), (0,6,46)]), ((0,253,88), &[(0,6,44),
  (0,6,69), (0,6,45)]), ((0,253,89), &[(0,6,44), (0,6,69), (0,6,45)]),
  ((0,253,90), &[(0,6,45), (0,6,69), (0,6,74)]), ((0,253,91), &[(0,6,45),
  (0,6,69), (0,6,73)]), ((0,253,92), &[(0,6,51), (0,6,45), (0,6,44)]),
  ((0,253,93), &[(0,6,51), (0,6,44), (0,6,45)]), ((0,253,94), &[(0,6,51),
  (0,6,44), (0,6,73)]), ((0,253,95), &[(0,6,51), (0,6,69), (0,6,45)]),
  ((0,253,96), &[(0,6,51), (0,6,69), (0,6,45)]), ((0,253,97), &[(0,6,51),
  (0,6,69), (0,6,44)]), ((0,253,98), &[(0,6,51), (0,6,69), (0,6,69)]),
  ((0,253,99), &[(0,6,51), (0,6,69), (0,6,69)]), ((0,253,100), &[(0,6,53),
  (0,6,45), (0,6,45)]), ((0,253,101), &[(0,6,53), (0,6,45), (0,6,45)]),
  ((0,253,102), &[(0,6,53), (0,6,69), (0,6,69)]), ((0,253,103), &[(0,6,52),
  (0,6,45), (0,6,69)]), ((0,253,104), &[(0,6,52), (0,6,45), (0,6,69)]),
  ((0,253,105), &[(0,6,52), (0,6,44), (0,6,74)]), ((0,253,106), &[(0,6,52),
  (0,6,69), (0,6,46)]), ((0,253,107), &[(0,6,52), (0,6,69), (0,6,46)]),
  ((0,253,108), &[(0,6,52), (0,6,69), (0,6,69)]), ((0,253,109), &[(0,6,52),
  (0,6,69), (0,6,69)]), ((0,253,110), &[(0,6,54), (0,6,45), (0,6,73)]),
  ((0,253,111), &[(0,6,54), (0,6,46), (0,6,69)]), ((0,253,112), &[(0,6,54),
  (0,6,46), (0,6,69)]), ((0,253,113), &[(0,6,55), (0,6,69), (0,6,45)]),
  ((0,253,114), &[(0,6,55), (0,6,69), (0,6,45)]), ((0,253,115), &[(0,6,55),
  (0,6,69), (0,6,69)]), ((0,253,116), &[(0,6,55), (0,6,69), (0,6,74)]),
  ((0,253,117), &[(0,6,57), (0,6,44), (0,6,69)]), ((0,253,118), &[(0,6,57),
  (0,6,69), (0,6,69)]), ((0,253,119), &[(0,6,57), (0,6,69), (0,6,69)]),
  ((0,253,120), &[(0,6,57), (0,6,69), (0,6,73)]), ((0,253,121), &[(0,6,58),
  (0,6,69), (0,6,69)]), ((0,253,122), &[(0,6,58), (0,6,69), (0,6,74)]),
  ((0,253,123), &[(0,6,58), (0,6,69), (0,6,73)]), ((0,253,124), &[(0,6,65),
  (0,6,46), (0,6,69)]), ((0,253,125), &[(0,6,65), (0,6,46), (0,6,69)]),
  ((0,253,126), &[(0,6,66), (0,6,69), (0,6,45)]), ((0,253,127), &[(0,6,66),
  (0,6,69), (0,6,69)]), ((0,253,128), &[(0,6,68), (0,6,45), (0,6,69)]),
  ((0,253,129), &[(0,6,68), (0,6,45), (0,6,74)]), ((0,253,130), &[(0,6,68),
  (0,6,45), (0,6,73)]), ((0,253,131), &[(0,6,68), (0,6,44), (0,6,44)]),
  ((0,253,132), &[(0,6,68), (0,6,44), (0,6,44)]), ((0,253,133), &[(0,6,68),
  (0,6,46), (0,6,69)]), ((0,253,134), &[(0,6,68), (0,6,46), (0,6,69)]),
  ((0,253,135), &[(0,6,68), (0,6,69), (0,6,45)]), ((0,253,136), &[(0,6,68),
  (0,6,69), (0,6,45)]), ((0,253,137), &[(0,6,69), (0,6,45), (0,6,44)]),
  ((0,253,138), &[(0,6,69), (0,6,45), (0,6,69)]), ((0,253,139), &[(0,6,69),
  (0,6,45), (0,6,74)]), ((0,253,140), &[(0,6,69), (0,6,44), (0,6,45)]),
  ((0,253,141), &[(0,6,69), (0,6,44), (0,6,69)]), ((0,253,142), &[(0,6,69),
  (0,6,46), (0,6,44)]), ((0,253,143), &[(0,6,69), (0,6,46), (0,6,69)]),
  ((0,253,146), &[(0,6,69), (0,6,44), (0,6,46)]), ((0,253,147), &[(0,6,71),
  (0,6,69), (0,6,44)]), ((0,253,148), &[(0,6,71), (0,6,69), (0,6,69)]),
  ((0,253,149), &[(0,6,70), (0,6,45), (0,6,69)]), ((0,253,150), &[(0,6,70),
  (0,6,45), (0,6,73)]), ((0,253,151), &[(0,6,70), (0,6,44), (0,6,69)]),
  ((0,253,152), &[(0,6,70), (0,6,44), (0,6,69)]), ((0,253,153), &[(0,6,70),
  (0,6,44), (0,6,73)]), ((0,253,154), &[(0,6,70), (0,6,69), (0,6,74)]),
  ((0,253,155), &[(0,6,70), (0,6,69), (0,6,73)]), ((0,253,156), &[(0,6,74),
  (0,6,69), (0,6,69)]), ((0,253,157), &[(0,6,74), (0,6,69), (0,6,69)]),
  ((0,253,158), &[(0,6,40), (0,6,46), (0,6,74)]), ((0,253,159), &[(0,6,42),
  (0,6,44), (0,6,74)]), ((0,253,160), &[(0,6,42), (0,6,44), (0,6,73)]),
  ((0,253,161), &[(0,6,42), (0,6,46), (0,6,74)]), ((0,253,162), &[(0,6,42),
  (0,6,46), (0,6,73)]), ((0,253,163), &[(0,6,42), (0,6,69), (0,6,74)]),
  ((0,253,164), &[(0,6,42), (0,6,69), (0,6,73)]), ((0,253,165), &[(0,6,44),
  (0,6,69), (0,6,74)]), ((0,253,166), &[(0,6,44), (0,6,45), (0,6,73)]),
  ((0,253,167), &[(0,6,44), (0,6,69), (0,6,73)]), ((0,253,168), &[(0,6,51),
  (0,6,46), (0,6,73)]), ((0,253,169), &[(0,6,53), (0,6,45), (0,6,74)]),
  ((0,253,170), &[(0,6,52), (0,6,45), (0,6,74)]), ((0,253,171), &[(0,6,54),
  (0,6,45), (0,6,74)]), ((0,253,172), &[(0,6,68), (0,6,44), (0,6,74)]),
  ((0,253,173), &[(0,6,68), (0,6,69), (0,6,74)]), ((0,253,174), &[(0,6,74),
  (0,6,45), (0,6,74)]), ((0,253,175), &[(0,6,74), (0,6,44), (0,6,74)]),
  ((0,253,176), &[(0,6,74), (0,6,69), (0,6,74)]), ((0,253,177), &[(0,6,69),
  (0,6,69), (0,6,74)]), ((0,253,178), &[(0,6,66), (0,6,69), (0,6,74)]),
  ((0,253,179), &[(0,6,70), (0,6,45), (0,6,74)]), ((0,253,180), &[(0,6,66),
  (0,6,69), (0,6,45)]), ((0,253,181), &[(0,6,68), (0,6,45), (0,6,69)]),
  ((0,253,182), &[(0,6,57), (0,6,69), (0,6,74)]), ((0,253,183), &[(0,6,67),
  (0,6,69), (0,6,74)]), ((0,253,184), &[(0,6,70), (0,6,44), (0,6,45)]),
  ((0,253,185), &[(0,6,69), (0,6,46), (0,6,74)]), ((0,253,186), &[(0,6,68),
  (0,6,44), (0,6,69)]), ((0,253,187), &[(0,6,67), (0,6,69), (0,6,69)]),
  ((0,253,188), &[(0,6,68), (0,6,44), (0,6,69)]), ((0,253,189), &[(0,6,70),
  (0,6,44), (0,6,45)]), ((0,253,190), &[(0,6,44), (0,6,45), (0,6,74)]),
  ((0,253,191), &[(0,6,45), (0,6,44), (0,6,74)]), ((0,253,192), &[(0,6,69),
  (0,6,44), (0,6,74)]), ((0,253,193), &[(0,6,65), (0,6,69), (0,6,74)]),
  ((0,253,194), &[(0,6,40), (0,6,45), (0,6,74)]), ((0,253,195), &[(0,6,67),
  (0,6,69), (0,6,69)]), ((0,253,196), &[(0,6,57), (0,6,44), (0,6,69)]),
  ((0,253,197), &[(0,6,53), (0,6,69), (0,6,69)]), ((0,253,198), &[(0,6,51),
  (0,6,46), (0,6,74)]), ((0,253,199), &[(0,6,70), (0,6,44), (0,6,74)]),
  ((0,253,240), &[(0,6,53), (0,6,68), (0,6,210)]), ((0,253,241), &[(0,6,66),
  (0,6,68), (0,6,210)]), ((0,253,242), &[(0,6,39), (0,6,68), (0,6,68),
  (0,6,71)]), ((0,253,243), &[(0,6,39), (0,6,67), (0,6,40), (0,6,49)]),
  ((0,253,244), &[(0,6,69), (0,6,45), (0,6,69), (0,6,47)]), ((0,253,245),
  &[(0,6,53), (0,6,68), (0,6,57), (0,6,69)]), ((0,253,246), &[(0,6,49),
  (0,6,51), (0,6,72), (0,6,68)]), ((0,253,247), &[(0,6,57), (0,6,68), (0,6,74),
  (0,6,71)]), ((0,253,248), &[(0,6,72), (0,6,51), (0,6,68), (0,6,69)]),
  ((0,253,249), &[(0,6,53), (0,6,68), (0,6,73)]), ((0,253,250), &[(0,6,53),
  (0,6,68), (0,6,73), (0,0,32), (0,6,39), (0,6,68), (0,6,68), (0,6,71),
  (0,0,32), (0,6,57), (0,6,68), (0,6,74), (0,6,71), (0,0,32), (0,6,72),
  (0,6,51), (0,6,68), (0,6,69)]), ((0,253,251), &[(0,6,44), (0,6,68), (0,0,32),
  (0,6,44), (0,6,68), (0,6,39), (0,6,68), (0,6,71)]), ((0,253,252), &[(0,6,49),
  (0,6,204), (0,6,39), (0,6,68)]), ((0,254,16), &[(0,0,44)]), ((0,254,17),
  &[(0,48,1)]), ((0,254,18), &[(0,48,2)]), ((0,254,19), &[(0,0,58)]),
  ((0,254,20), &[(0,0,59)]), ((0,254,21), &[(0,0,33)]), ((0,254,22),
  &[(0,0,63)]), ((0,254,23), &[(0,48,22)]), ((0,254,24), &[(0,48,23)]),
  ((0,254,25), &[(0,32,38)]), ((0,254,48), &[(0,32,37)]), ((0,254,49),
  &[(0,32,20)]), ((0,254,50), &[(0,32,19)]), ((0,254,51), &[(0,0,95)]),
  ((0,254,52), &[(0,0,95)]), ((0,254,53), &[(0,0,40)]), ((0,254,54),
  &[(0,0,41)]), ((0,254,55), &[(0,0,123)]), ((0,254,56), &[(0,0,125)]),
  ((0,254,57), &[(0,48,20)]), ((0,254,58), &[(0,48,21)]), ((0,254,59),
  &[(0,48,16)]), ((0,254,60), &[(0,48,17)]), ((0,254,61), &[(0,48,10)]),
  ((0,254,62), &[(0,48,11)]), ((0,254,63), &[(0,48,8)]), ((0,254,64),
  &[(0,48,9)]), ((0,254,65), &[(0,48,12)]), ((0,254,66), &[(0,48,13)]),
  ((0,254,67), &[(0,48,14)]), ((0,254,68), &[(0,48,15)]), ((0,254,71),
  &[(0,0,91)]), ((0,254,72), &[(0,0,93)]), ((0,254,73), &[(0,32,62)]),
  ((0,254,74), &[(0,32,62)]), ((0,254,75), &[(0,32,62)]), ((0,254,76),
  &[(0,32,62)]), ((0,254,77), &[(0,0,95)]), ((0,254,78), &[(0,0,95)]),
  ((0,254,79), &[(0,0,95)]), ((0,254,80), &[(0,0,44)]), ((0,254,81),
  &[(0,48,1)]), ((0,254,82), &[(0,0,46)]), ((0,254,84), &[(0,0,59)]),
  ((0,254,85), &[(0,0,58)]), ((0,254,86), &[(0,0,63)]), ((0,254,87),
  &[(0,0,33)]), ((0,254,88), &[(0,32,20)]), ((0,254,89), &[(0,0,40)]),
  ((0,254,90), &[(0,0,41)]), ((0,254,91), &[(0,0,123)]), ((0,254,92),
  &[(0,0,125)]), ((0,254,93), &[(0,48,20)]), ((0,254,94), &[(0,48,21)]),
  ((0,254,95), &[(0,0,35)]), ((0,254,96), &[(0,0,38)]), ((0,254,97),
  &[(0,0,42)]), ((0,254,98), &[(0,0,43)]), ((0,254,99), &[(0,0,45)]),
  ((0,254,100), &[(0,0,60)]), ((0,254,101), &[(0,0,62)]), ((0,254,102),
  &[(0,0,61)]), ((0,254,104), &[(0,0,92)]), ((0,254,105), &[(0,0,36)]),
  ((0,254,106), &[(0,0,37)]), ((0,254,107), &[(0,0,64)]), ((0,254,112),
  &[(0,0,32), (0,6,75)]), ((0,254,113), &[(0,6,64), (0,6,75)]), ((0,254,114),
  &[(0,0,32), (0,6,76)]), ((0,254,116), &[(0,0,32), (0,6,77)]), ((0,254,118),
  &[(0,0,32), (0,6,78)]), ((0,254,119), &[(0,6,64), (0,6,78)]), ((0,254,120),
  &[(0,0,32), (0,6,79)]), ((0,254,121), &[(0,6,64), (0,6,79)]), ((0,254,122),
  &[(0,0,32), (0,6,80)]), ((0,254,123), &[(0,6,64), (0,6,80)]), ((0,254,124),
  &[(0,0,32), (0,6,81)]), ((0,254,125), &[(0,6,64), (0,6,81)]), ((0,254,126),
  &[(0,0,32), (0,6,82)]), ((0,254,127), &[(0,6,64), (0,6,82)]), ((0,254,128),
  &[(0,6,33)]), ((0,254,129), &[(0,6,34)]), ((0,254,130), &[(0,6,34)]),
  ((0,254,131), &[(0,6,35)]), ((0,254,132), &[(0,6,35)]), ((0,254,133),
  &[(0,6,36)]), ((0,254,134), &[(0,6,36)]), ((0,254,135), &[(0,6,37)]),
  ((0,254,136), &[(0,6,37)]), ((0,254,137), &[(0,6,38)]), ((0,254,138),
  &[(0,6,38)]), ((0,254,139), &[(0,6,38)]), ((0,254,140), &[(0,6,38)]),
  ((0,254,141), &[(0,6,39)]), ((0,254,142), &[(0,6,39)]), ((0,254,143),
  &[(0,6,40)]), ((0,254,144), &[(0,6,40)]), ((0,254,145), &[(0,6,40)]),
  ((0,254,146), &[(0,6,40)]), ((0,254,147), &[(0,6,41)]), ((0,254,148),
  &[(0,6,41)]), ((0,254,149), &[(0,6,42)]), ((0,254,150), &[(0,6,42)]),
  ((0,254,151), &[(0,6,42)]), ((0,254,152), &[(0,6,42)]), ((0,254,153),
  &[(0,6,43)]), ((0,254,154), &[(0,6,43)]), ((0,254,155), &[(0,6,43)]),
  ((0,254,156), &[(0,6,43)]), ((0,254,157), &[(0,6,44)]), ((0,254,158),
  &[(0,6,44)]), ((0,254,159), &[(0,6,44)]), ((0,254,160), &[(0,6,44)]),
  ((0,254,161), &[(0,6,45)]), ((0,254,162), &[(0,6,45)]), ((0,254,163),
  &[(0,6,45)]), ((0,254,164), &[(0,6,45)]), ((0,254,165), &[(0,6,46)]),
  ((0,254,166), &[(0,6,46)]), ((0,254,167), &[(0,6,46)]), ((0,254,168),
  &[(0,6,46)]), ((0,254,169), &[(0,6,47)]), ((0,254,170), &[(0,6,47)]),
  ((0,254,171), &[(0,6,48)]), ((0,254,172), &[(0,6,48)]), ((0,254,173),
  &[(0,6,49)]), ((0,254,174), &[(0,6,49)]), ((0,254,175), &[(0,6,50)]),
  ((0,254,176), &[(0,6,50)]), ((0,254,177), &[(0,6,51)]), ((0,254,178),
  &[(0,6,51)]), ((0,254,179), &[(0,6,51)]), ((0,254,180), &[(0,6,51)]),
  ((0,254,181), &[(0,6,52)]), ((0,254,182), &[(0,6,52)]), ((0,254,183),
  &[(0,6,52)]), ((0,254,184), &[(0,6,52)]), ((0,254,185), &[(0,6,53)]),
  ((0,254,186), &[(0,6,53)]), ((0,254,187), &[(0,6,53)]), ((0,254,188),
  &[(0,6,53)]), ((0,254,189), &[(0,6,54)]), ((0,254,190), &[(0,6,54)]),
  ((0,254,191), &[(0,6,54)]), ((0,254,192), &[(0,6,54)]), ((0,254,193),
  &[(0,6,55)]), ((0,254,194), &[(0,6,55)]), ((0,254,195), &[(0,6,55)]),
  ((0,254,196), &[(0,6,55)]), ((0,254,197), &[(0,6,56)]), ((0,254,198),
  &[(0,6,56)]), ((0,254,199), &[(0,6,56)]), ((0,254,200), &[(0,6,56)]),
  ((0,254,201), &[(0,6,57)]), ((0,254,202), &[(0,6,57)]), ((0,254,203),
  &[(0,6,57)]), ((0,254,204), &[(0,6,57)]), ((0,254,205), &[(0,6,58)]),
  ((0,254,206), &[(0,6,58)]), ((0,254,207), &[(0,6,58)]), ((0,254,208),
  &[(0,6,58)]), ((0,254,209), &[(0,6,65)]), ((0,254,210), &[(0,6,65)]),
  ((0,254,211), &[(0,6,65)]), ((0,254,212), &[(0,6,65)]), ((0,254,213),
  &[(0,6,66)]), ((0,254,214), &[(0,6,66)]), ((0,254,215), &[(0,6,66)]),
  ((0,254,216), &[(0,6,66)]), ((0,254,217), &[(0,6,67)]), ((0,254,218),
  &[(0,6,67)]), ((0,254,219), &[(0,6,67)]), ((0,254,220), &[(0,6,67)]),
  ((0,254,221), &[(0,6,68)]), ((0,254,222), &[(0,6,68)]), ((0,254,223),
  &[(0,6,68)]), ((0,254,224), &[(0,6,68)]), ((0,254,225), &[(0,6,69)]),
  ((0,254,226), &[(0,6,69)]), ((0,254,227), &[(0,6,69)]), ((0,254,228),
  &[(0,6,69)]), ((0,254,229), &[(0,6,70)]), ((0,254,230), &[(0,6,70)]),
  ((0,254,231), &[(0,6,70)]), ((0,254,232), &[(0,6,70)]), ((0,254,233),
  &[(0,6,71)]), ((0,254,234), &[(0,6,71)]), ((0,254,235), &[(0,6,71)]),
  ((0,254,236), &[(0,6,71)]), ((0,254,237), &[(0,6,72)]), ((0,254,238),
  &[(0,6,72)]), ((0,254,239), &[(0,6,73)]), ((0,254,240), &[(0,6,73)]),
  ((0,254,241), &[(0,6,74)]), ((0,254,242), &[(0,6,74)]), ((0,254,243),
  &[(0,6,74)]), ((0,254,244), &[(0,6,74)]), ((0,254,245), &[(0,6,68),
  (0,6,34)]), ((0,254,246), &[(0,6,68), (0,6,34)]), ((0,254,247), &[(0,6,68),
  (0,6,35)]), ((0,254,248), &[(0,6,68), (0,6,35)]), ((0,254,249), &[(0,6,68),
  (0,6,37)]), ((0,254,250), &[(0,6,68), (0,6,37)]), ((0,254,251), &[(0,6,68),
  (0,6,39)]), ((0,254,252), &[(0,6,68), (0,6,39)]), ((0,255,1), &[(0,0,33)]),
  ((0,255,2), &[(0,0,34)]), ((0,255,3), &[(0,0,35)]), ((0,255,4), &[(0,0,36)]),
  ((0,255,5), &[(0,0,37)]), ((0,255,6), &[(0,0,38)]), ((0,255,7), &[(0,0,39)]),
  ((0,255,8), &[(0,0,40)]), ((0,255,9), &[(0,0,41)]), ((0,255,10), &[(0,0,42)]),
  ((0,255,11), &[(0,0,43)]), ((0,255,12), &[(0,0,44)]), ((0,255,13),
  &[(0,0,45)]), ((0,255,14), &[(0,0,46)]), ((0,255,15), &[(0,0,47)]),
  ((0,255,16), &[(0,0,48)]), ((0,255,17), &[(0,0,49)]), ((0,255,18),
  &[(0,0,50)]), ((0,255,19), &[(0,0,51)]), ((0,255,20), &[(0,0,52)]),
  ((0,255,21), &[(0,0,53)]), ((0,255,22), &[(0,0,54)]), ((0,255,23),
  &[(0,0,55)]), ((0,255,24), &[(0,0,56)]), ((0,255,25), &[(0,0,57)]),
  ((0,255,26), &[(0,0,58)]), ((0,255,27), &[(0,0,59)]), ((0,255,28),
  &[(0,0,60)]), ((0,255,29), &[(0,0,61)]), ((0,255,30), &[(0,0,62)]),
  ((0,255,31), &[(0,0,63)]), ((0,255,32), &[(0,0,64)]), ((0,255,33),
  &[(0,0,65)]), ((0,255,34), &[(0,0,66)]), ((0,255,35), &[(0,0,67)]),
  ((0,255,36), &[(0,0,68)]), ((0,255,37), &[(0,0,69)]), ((0,255,38),
  &[(0,0,70)]), ((0,255,39), &[(0,0,71)]), ((0,255,40), &[(0,0,72)]),
  ((0,255,41), &[(0,0,73)]), ((0,255,42), &[(0,0,74)]), ((0,255,43),
  &[(0,0,75)]), ((0,255,44), &[(0,0,76)]), ((0,255,45), &[(0,0,77)]),
  ((0,255,46), &[(0,0,78)]), ((0,255,47), &[(0,0,79)]), ((0,255,48),
  &[(0,0,80)]), ((0,255,49), &[(0,0,81)]), ((0,255,50), &[(0,0,82)]),
  ((0,255,51), &[(0,0,83)]), ((0,255,52), &[(0,0,84)]), ((0,255,53),
  &[(0,0,85)]), ((0,255,54), &[(0,0,86)]), ((0,255,55), &[(0,0,87)]),
  ((0,255,56), &[(0,0,88)]), ((0,255,57), &[(0,0,89)]), ((0,255,58),
  &[(0,0,90)]), ((0,255,59), &[(0,0,91)]), ((0,255,60), &[(0,0,92)]),
  ((0,255,61), &[(0,0,93)]), ((0,255,62), &[(0,0,94)]), ((0,255,63),
  &[(0,0,95)]), ((0,255,64), &[(0,0,96)]), ((0,255,65), &[(0,0,97)]),
  ((0,255,66), &[(0,0,98)]), ((0,255,67), &[(0,0,99)]), ((0,255,68),
  &[(0,0,100)]), ((0,255,69), &[(0,0,101)]), ((0,255,70), &[(0,0,102)]),
  ((0,255,71), &[(0,0,103)]), ((0,255,72), &[(0,0,104)]), ((0,255,73),
  &[(0,0,105)]), ((0,255,74), &[(0,0,106)]), ((0,255,75), &[(0,0,107)]),
  ((0,255,76), &[(0,0,108)]), ((0,255,77), &[(0,0,109)]), ((0,255,78),
  &[(0,0,110)]), ((0,255,79), &[(0,0,111)]), ((0,255,80), &[(0,0,112)]),
  ((0,255,81), &[(0,0,113)]), ((0,255,82), &[(0,0,114)]), ((0,255,83),
  &[(0,0,115)]), ((0,255,84), &[(0,0,116)]), ((0,255,85), &[(0,0,117)]),
  ((0,255,86), &[(0,0,118)]), ((0,255,87), &[(0,0,119)]), ((0,255,88),
  &[(0,0,120)]), ((0,255,89), &[(0,0,121)]), ((0,255,90), &[(0,0,122)]),
  ((0,255,91), &[(0,0,123)]), ((0,255,92), &[(0,0,124)]), ((0,255,93),
  &[(0,0,125)]), ((0,255,94), &[(0,0,126)]), ((0,255,95), &[(0,41,133)]),
  ((0,255,96), &[(0,41,134)]), ((0,255,97), &[(0,48,2)]), ((0,255,98),
  &[(0,48,12)]), ((0,255,99), &[(0,48,13)]), ((0,255,100), &[(0,48,1)]),
  ((0,255,101), &[(0,48,251)]), ((0,255,102), &[(0,48,242)]), ((0,255,103),
  &[(0,48,161)]), ((0,255,104), &[(0,48,163)]), ((0,255,105), &[(0,48,165)]),
  ((0,255,106), &[(0,48,167)]), ((0,255,107), &[(0,48,169)]), ((0,255,108),
  &[(0,48,227)]), ((0,255,109), &[(0,48,229)]), ((0,255,110), &[(0,48,231)]),
  ((0,255,111), &[(0,48,195)]), ((0,255,112), &[(0,48,252)]), ((0,255,113),
  &[(0,48,162)]), ((0,255,114), &[(0,48,164)]), ((0,255,115), &[(0,48,166)]),
  ((0,255,116), &[(0,48,168)]), ((0,255,117), &[(0,48,170)]), ((0,255,118),
  &[(0,48,171)]), ((0,255,119), &[(0,48,173)]), ((0,255,120), &[(0,48,175)]),
  ((0,255,121), &[(0,48,177)]), ((0,255,122), &[(0,48,179)]), ((0,255,123),
  &[(0,48,181)]), ((0,255,124), &[(0,48,183)]), ((0,255,125), &[(0,48,185)]),
  ((0,255,126), &[(0,48,187)]), ((0,255,127), &[(0,48,189)]), ((0,255,128),
  &[(0,48,191)]), ((0,255,129), &[(0,48,193)]), ((0,255,130), &[(0,48,196)]),
  ((0,255,131), &[(0,48,198)]), ((0,255,132), &[(0,48,200)]), ((0,255,133),
  &[(0,48,202)]), ((0,255,134), &[(0,48,203)]), ((0,255,135), &[(0,48,204)]),
  ((0,255,136), &[(0,48,205)]), ((0,255,137), &[(0,48,206)]), ((0,255,138),
  &[(0,48,207)]), ((0,255,139), &[(0,48,210)]), ((0,255,140), &[(0,48,213)]),
  ((0,255,141), &[(0,48,216)]), ((0,255,142), &[(0,48,219)]), ((0,255,143),
  &[(0,48,222)]), ((0,255,144), &[(0,48,223)]), ((0,255,145), &[(0,48,224)]),
  ((0,255,146), &[(0,48,225)]), ((0,255,147), &[(0,48,226)]), ((0,255,148),
  &[(0,48,228)]), ((0,255,149), &[(0,48,230)]), ((0,255,150), &[(0,48,232)]),
  ((0,255,151), &[(0,48,233)]), ((0,255,152), &[(0,48,234)]), ((0,255,153),
  &[(0,48,235)]), ((0,255,154), &[(0,48,236)]), ((0,255,155), &[(0,48,237)]),
  ((0,255,156), &[(0,48,239)]), ((0,255,157), &[(0,48,243)]), ((0,255,158),
  &[(0,48,153)]), ((0,255,159), &[(0,48,154)]), ((0,255,160), &[(0,49,100)]),
  ((0,255,161), &[(0,49,49)]), ((0,255,162), &[(0,49,50)]), ((0,255,163),
  &[(0,49,51)]), ((0,255,164), &[(0,49,52)]), ((0,255,165), &[(0,49,53)]),
  ((0,255,166), &[(0,49,54)]), ((0,255,167), &[(0,49,55)]), ((0,255,168),
  &[(0,49,56)]), ((0,255,169), &[(0,49,57)]), ((0,255,170), &[(0,49,58)]),
  ((0,255,171), &[(0,49,59)]), ((0,255,172), &[(0,49,60)]), ((0,255,173),
  &[(0,49,61)]), ((0,255,174), &[(0,49,62)]), ((0,255,175), &[(0,49,63)]),
  ((0,255,176), &[(0,49,64)]), ((0,255,177), &[(0,49,65)]), ((0,255,178),
  &[(0,49,66)]), ((0,255,179), &[(0,49,67)]), ((0,255,180), &[(0,49,68)]),
  ((0,255,181), &[(0,49,69)]), ((0,255,182), &[(0,49,70)]), ((0,255,183),
  &[(0,49,71)]), ((0,255,184), &[(0,49,72)]), ((0,255,185), &[(0,49,73)]),
  ((0,255,186), &[(0,49,74)]), ((0,255,187), &[(0,49,75)]), ((0,255,188),
  &[(0,49,76)]), ((0,255,189), &[(0,49,77)]), ((0,255,190), &[(0,49,78)]),
  ((0,255,194), &[(0,49,79)]), ((0,255,195), &[(0,49,80)]), ((0,255,196),
  &[(0,49,81)]), ((0,255,197), &[(0,49,82)]), ((0,255,198), &[(0,49,83)]),
  ((0,255,199), &[(0,49,84)]), ((0,255,202), &[(0,49,85)]), ((0,255,203),
  &[(0,49,86)]), ((0,255,204), &[(0,49,87)]), ((0,255,205), &[(0,49,88)]),
  ((0,255,206), &[(0,49,89)]), ((0,255,207), &[(0,49,90)]), ((0,255,210),
  &[(0,49,91)]), ((0,255,211), &[(0,49,92)]), ((0,255,212), &[(0,49,93)]),
  ((0,255,213), &[(0,49,94)]), ((0,255,214), &[(0,49,95)]), ((0,255,215),
  &[(0,49,96)]), ((0,255,218), &[(0,49,97)]), ((0,255,219), &[(0,49,98)]),
  ((0,255,220), &[(0,49,99)]), ((0,255,224), &[(0,0,162)]), ((0,255,225),
  &[(0,0,163)]), ((0,255,226), &[(0,0,172)]), ((0,255,227), &[(0,0,175)]),
  ((0,255,228), &[(0,0,166)]), ((0,255,229), &[(0,0,165)]), ((0,255,230),
  &[(0,32,169)]), ((0,255,232), &[(0,37,2)]), ((0,255,233), &[(0,33,144)]),
  ((0,255,234), &[(0,33,145)]), ((0,255,235), &[(0,33,146)]), ((0,255,236),
  &[(0,33,147)]), ((0,255,237), &[(0,37,160)]), ((0,255,238), &[(0,37,203)]),
  ((1,16,154), &[(1,16,153), (1,16,186)]), ((1,16,156), &[(1,16,155),
  (1,16,186)]), ((1,16,171), &[(1,16,165), (1,16,186)]), ((1,17,46),
  &[(1,17,49), (1,17,39)]), ((1,17,47), &[(1,17,50), (1,17,39)]), ((1,19,75),
  &[(1,19,71), (1,19,62)]), ((1,19,76), &[(1,19,71), (1,19,87)]), ((1,20,187),
  &[(1,20,185), (1,20,186)]), ((1,20,188), &[(1,20,185), (1,20,176)]),
  ((1,20,190), &[(1,20,185), (1,20,189)]), ((1,21,186), &[(1,21,184),
  (1,21,175)]), ((1,21,187), &[(1,21,185), (1,21,175)]), ((1,209,94),
  &[(1,209,87), (1,209,101)]), ((1,209,95), &[(1,209,88), (1,209,101)]),
  ((1,209,96), &[(1,209,95), (1,209,110)]), ((1,209,97), &[(1,209,95),
  (1,209,111)]), ((1,209,98), &[(1,209,95), (1,209,112)]), ((1,209,99),
  &[(1,209,95), (1,209,113)]), ((1,209,100), &[(1,209,95), (1,209,114)]),
  ((1,209,187), &[(1,209,185), (1,209,101)]), ((1,209,188), &[(1,209,186),
  (1,209,101)]), ((1,209,189), &[(1,209,187), (1,209,110)]), ((1,209,190),
  &[(1,209,188), (1,209,110)]), ((1,209,191), &[(1,209,187), (1,209,111)]),
  ((1,209,192), &[(1,209,188), (1,209,111)]), ((1,212,0), &[(0,0,65)]),
  ((1,212,1), &[(0,0,66)]), ((1,212,2), &[(0,0,67)]), ((1,212,3), &[(0,0,68)]),
  ((1,212,4), &[(0,0,69)]), ((1,212,5), &[(0,0,70)]), ((1,212,6), &[(0,0,71)]),
  ((1,212,7), &[(0,0,72)]), ((1,212,8), &[(0,0,73)]), ((1,212,9), &[(0,0,74)]),
  ((1,212,10), &[(0,0,75)]), ((1,212,11), &[(0,0,76)]), ((1,212,12),
  &[(0,0,77)]), ((1,212,13), &[(0,0,78)]), ((1,212,14), &[(0,0,79)]),
  ((1,212,15), &[(0,0,80)]), ((1,212,16), &[(0,0,81)]), ((1,212,17),
  &[(0,0,82)]), ((1,212,18), &[(0,0,83)]), ((1,212,19), &[(0,0,84)]),
  ((1,212,20), &[(0,0,85)]), ((1,212,21), &[(0,0,86)]), ((1,212,22),
  &[(0,0,87)]), ((1,212,23), &[(0,0,88)]), ((1,212,24), &[(0,0,89)]),
  ((1,212,25), &[(0,0,90)]), ((1,212,26), &[(0,0,97)]), ((1,212,27),
  &[(0,0,98)]), ((1,212,28), &[(0,0,99)]), ((1,212,29), &[(0,0,100)]),
  ((1,212,30), &[(0,0,101)]), ((1,212,31), &[(0,0,102)]), ((1,212,32),
  &[(0,0,103)]), ((1,212,33), &[(0,0,104)]), ((1,212,34), &[(0,0,105)]),
  ((1,212,35), &[(0,0,106)]), ((1,212,36), &[(0,0,107)]), ((1,212,37),
  &[(0,0,108)]), ((1,212,38), &[(0,0,109)]), ((1,212,39), &[(0,0,110)]),
  ((1,212,40), &[(0,0,111)]), ((1,212,41), &[(0,0,112)]), ((1,212,42),
  &[(0,0,113)]), ((1,212,43), &[(0,0,114)]), ((1,212,44), &[(0,0,115)]),
  ((1,212,45), &[(0,0,116)]), ((1,212,46), &[(0,0,117)]), ((1,212,47),
  &[(0,0,118)]), ((1,212,48), &[(0,0,119)]), ((1,212,49), &[(0,0,120)]),
  ((1,212,50), &[(0,0,121)]), ((1,212,51), &[(0,0,122)]), ((1,212,52),
  &[(0,0,65)]), ((1,212,53), &[(0,0,66)]), ((1,212,54), &[(0,0,67)]),
  ((1,212,55), &[(0,0,68)]), ((1,212,56), &[(0,0,69)]), ((1,212,57),
  &[(0,0,70)]), ((1,212,58), &[(0,0,71)]), ((1,212,59), &[(0,0,72)]),
  ((1,212,60), &[(0,0,73)]), ((1,212,61), &[(0,0,74)]), ((1,212,62),
  &[(0,0,75)]), ((1,212,63), &[(0,0,76)]), ((1,212,64), &[(0,0,77)]),
  ((1,212,65), &[(0,0,78)]), ((1,212,66), &[(0,0,79)]), ((1,212,67),
  &[(0,0,80)]), ((1,212,68), &[(0,0,81)]), ((1,212,69), &[(0,0,82)]),
  ((1,212,70), &[(0,0,83)]), ((1,212,71), &[(0,0,84)]), ((1,212,72),
  &[(0,0,85)]), ((1,212,73), &[(0,0,86)]), ((1,212,74), &[(0,0,87)]),
  ((1,212,75), &[(0,0,88)]), ((1,212,76), &[(0,0,89)]), ((1,212,77),
  &[(0,0,90)]), ((1,212,78), &[(0,0,97)]), ((1,212,79), &[(0,0,98)]),
  ((1,212,80), &[(0,0,99)]), ((1,212,81), &[(0,0,100)]), ((1,212,82),
  &[(0,0,101)]), ((1,212,83), &[(0,0,102)]), ((1,212,84), &[(0,0,103)]),
  ((1,212,86), &[(0,0,105)]), ((1,212,87), &[(0,0,106)]), ((1,212,88),
  &[(0,0,107)]), ((1,212,89), &[(0,0,108)]), ((1,212,90), &[(0,0,109)]),
  ((1,212,91), &[(0,0,110)]), ((1,212,92), &[(0,0,111)]), ((1,212,93),
  &[(0,0,112)]), ((1,212,94), &[(0,0,113)]), ((1,212,95), &[(0,0,114)]),
  ((1,212,96), &[(0,0,115)]), ((1,212,97), &[(0,0,116)]), ((1,212,98),
  &[(0,0,117)]), ((1,212,99), &[(0,0,118)]), ((1,212,100), &[(0,0,119)]),
  ((1,212,101), &[(0,0,120)]), ((1,212,102), &[(0,0,121)]), ((1,212,103),
  &[(0,0,122)]), ((1,212,104), &[(0,0,65)]), ((1,212,105), &[(0,0,66)]),
  ((1,212,106), &[(0,0,67)]), ((1,212,107), &[(0,0,68)]), ((1,212,108),
  &[(0,0,69)]), ((1,212,109), &[(0,0,70)]), ((1,212,110), &[(0,0,71)]),
  ((1,212,111), &[(0,0,72)]), ((1,212,112), &[(0,0,73)]), ((1,212,113),
  &[(0,0,74)]), ((1,212,114), &[(0,0,75)]), ((1,212,115), &[(0,0,76)]),
  ((1,212,116), &[(0,0,77)]), ((1,212,117), &[(0,0,78)]), ((1,212,118),
  &[(0,0,79)]), ((1,212,119), &[(0,0,80)]), ((1,212,120), &[(0,0,81)]),
  ((1,212,121), &[(0,0,82)]), ((1,212,122), &[(0,0,83)]), ((1,212,123),
  &[(0,0,84)]), ((1,212,124), &[(0,0,85)]), ((1,212,125), &[(0,0,86)]),
  ((1,212,126), &[(0,0,87)]), ((1,212,127), &[(0,0,88)]), ((1,212,128),
  &[(0,0,89)]), ((1,212,129), &[(0,0,90)]), ((1,212,130), &[(0,0,97)]),
  ((1,212,131), &[(0,0,98)]), ((1,212,132), &[(0,0,99)]), ((1,212,133),
  &[(0,0,100)]), ((1,212,134), &[(0,0,101)]), ((1,212,135), &[(0,0,102)]),
  ((1,212,136), &[(0,0,103)]), ((1,212,137), &[(0,0,104)]), ((1,212,138),
  &[(0,0,105)]), ((1,212,139), &[(0,0,106)]), ((1,212,140), &[(0,0,107)]),
  ((1,212,141), &[(0,0,108)]), ((1,212,142), &[(0,0,109)]), ((1,212,143),
  &[(0,0,110)]), ((1,212,144), &[(0,0,111)]), ((1,212,145), &[(0,0,112)]),
  ((1,212,146), &[(0,0,113)]), ((1,212,147), &[(0,0,114)]), ((1,212,148),
  &[(0,0,115)]), ((1,212,149), &[(0,0,116)]), ((1,212,150), &[(0,0,117)]),
  ((1,212,151), &[(0,0,118)]), ((1,212,152), &[(0,0,119)]), ((1,212,153),
  &[(0,0,120)]), ((1,212,154), &[(0,0,121)]), ((1,212,155), &[(0,0,122)]),
  ((1,212,156), &[(0,0,65)]), ((1,212,158), &[(0,0,67)]), ((1,212,159),
  &[(0,0,68)]), ((1,212,162), &[(0,0,71)]), ((1,212,165), &[(0,0,74)]),
  ((1,212,166), &[(0,0,75)]), ((1,212,169), &[(0,0,78)]), ((1,212,170),
  &[(0,0,79)]), ((1,212,171), &[(0,0,80)]), ((1,212,172), &[(0,0,81)]),
  ((1,212,174), &[(0,0,83)]), ((1,212,175), &[(0,0,84)]), ((1,212,176),
  &[(0,0,85)]), ((1,212,177), &[(0,0,86)]), ((1,212,178), &[(0,0,87)]),
  ((1,212,179), &[(0,0,88)]), ((1,212,180), &[(0,0,89)]), ((1,212,181),
  &[(0,0,90)]), ((1,212,182), &[(0,0,97)]), ((1,212,183), &[(0,0,98)]),
  ((1,212,184), &[(0,0,99)]), ((1,212,185), &[(0,0,100)]), ((1,212,187),
  &[(0,0,102)]), ((1,212,189), &[(0,0,104)]), ((1,212,190), &[(0,0,105)]),
  ((1,212,191), &[(0,0,106)]), ((1,212,192), &[(0,0,107)]), ((1,212,193),
  &[(0,0,108)]), ((1,212,194), &[(0,0,109)]), ((1,212,195), &[(0,0,110)]),
  ((1,212,197), &[(0,0,112)]), ((1,212,198), &[(0,0,113)]), ((1,212,199),
  &[(0,0,114)]), ((1,212,200), &[(0,0,115)]), ((1,212,201), &[(0,0,116)]),
  ((1,212,202), &[(0,0,117)]), ((1,212,203), &[(0,0,118)]), ((1,212,204),
  &[(0,0,119)]), ((1,212,205), &[(0,0,120)]), ((1,212,206), &[(0,0,121)]),
  ((1,212,207), &[(0,0,122)]), ((1,212,208), &[(0,0,65)]), ((1,212,209),
  &[(0,0,66)]), ((1,212,210), &[(0,0,67)]), ((1,212,211), &[(0,0,68)]),
  ((1,212,212), &[(0,0,69)]), ((1,212,213), &[(0,0,70)]), ((1,212,214),
  &[(0,0,71)]), ((1,212,215), &[(0,0,72)]), ((1,212,216), &[(0,0,73)]),
  ((1,212,217), &[(0,0,74)]), ((1,212,218), &[(0,0,75)]), ((1,212,219),
  &[(0,0,76)]), ((1,212,220), &[(0,0,77)]), ((1,212,221), &[(0,0,78)]),
  ((1,212,222), &[(0,0,79)]), ((1,212,223), &[(0,0,80)]), ((1,212,224),
  &[(0,0,81)]), ((1,212,225), &[(0,0,82)]), ((1,212,226), &[(0,0,83)]),
  ((1,212,227), &[(0,0,84)]), ((1,212,228), &[(0,0,85)]), ((1,212,229),
  &[(0,0,86)]), ((1,212,230), &[(0,0,87)]), ((1,212,231), &[(0,0,88)]),
  ((1,212,232), &[(0,0,89)]), ((1,212,233), &[(0,0,90)]), ((1,212,234),
  &[(0,0,97)]), ((1,212,235), &[(0,0,98)]), ((1,212,236), &[(0,0,99)]),
  ((1,212,237), &[(0,0,100)]), ((1,212,238), &[(0,0,101)]), ((1,212,239),
  &[(0,0,102)]), ((1,212,240), &[(0,0,103)]), ((1,212,241), &[(0,0,104)]),
  ((1,212,242), &[(0,0,105)]), ((1,212,243), &[(0,0,106)]), ((1,212,244),
  &[(0,0,107)]), ((1,212,245), &[(0,0,108)]), ((1,212,246), &[(0,0,109)]),
  ((1,212,247), &[(0,0,110)]), ((1,212,248), &[(0,0,111)]), ((1,212,249),
  &[(0,0,112)]), ((1,212,250), &[(0,0,113)]), ((1,212,251), &[(0,0,114)]),
  ((1,212,252), &[(0,0,115)]), ((1,212,253), &[(0,0,116)]), ((1,212,254),
  &[(0,0,117)]), ((1,212,255), &[(0,0,118)]), ((1,213,0), &[(0,0,119)]),
  ((1,213,1), &[(0,0,120)]), ((1,213,2), &[(0,0,121)]), ((1,213,3),
  &[(0,0,122)]), ((1,213,4), &[(0,0,65)]), ((1,213,5), &[(0,0,66)]), ((1,213,7),
  &[(0,0,68)]), ((1,213,8), &[(0,0,69)]), ((1,213,9), &[(0,0,70)]), ((1,213,10),
  &[(0,0,71)]), ((1,213,13), &[(0,0,74)]), ((1,213,14), &[(0,0,75)]),
  ((1,213,15), &[(0,0,76)]), ((1,213,16), &[(0,0,77)]), ((1,213,17),
  &[(0,0,78)]), ((1,213,18), &[(0,0,79)]), ((1,213,19), &[(0,0,80)]),
  ((1,213,20), &[(0,0,81)]), ((1,213,22), &[(0,0,83)]), ((1,213,23),
  &[(0,0,84)]), ((1,213,24), &[(0,0,85)]), ((1,213,25), &[(0,0,86)]),
  ((1,213,26), &[(0,0,87)]), ((1,213,27), &[(0,0,88)]), ((1,213,28),
  &[(0,0,89)]), ((1,213,30), &[(0,0,97)]), ((1,213,31), &[(0,0,98)]),
  ((1,213,32), &[(0,0,99)]), ((1,213,33), &[(0,0,100)]), ((1,213,34),
  &[(0,0,101)]), ((1,213,35), &[(0,0,102)]), ((1,213,36), &[(0,0,103)]),
  ((1,213,37), &[(0,0,104)]), ((1,213,38), &[(0,0,105)]), ((1,213,39),
  &[(0,0,106)]), ((1,213,40), &[(0,0,107)]), ((1,213,41), &[(0,0,108)]),
  ((1,213,42), &[(0,0,109)]), ((1,213,43), &[(0,0,110)]), ((1,213,44),
  &[(0,0,111)]), ((1,213,45), &[(0,0,112)]), ((1,213,46), &[(0,0,113)]),
  ((1,213,47), &[(0,0,114)]), ((1,213,48), &[(0,0,115)]), ((1,213,49),
  &[(0,0,116)]), ((1,213,50), &[(0,0,117)]), ((1,213,51), &[(0,0,118)]),
  ((1,213,52), &[(0,0,119)]), ((1,213,53), &[(0,0,120)]), ((1,213,54),
  &[(0,0,121)]), ((1,213,55), &[(0,0,122)]), ((1,213,56), &[(0,0,65)]),
  ((1,213,57), &[(0,0,66)]), ((1,213,59), &[(0,0,68)]), ((1,213,60),
  &[(0,0,69)]), ((1,213,61), &[(0,0,70)]), ((1,213,62), &[(0,0,71)]),
  ((1,213,64), &[(0,0,73)]), ((1,213,65), &[(0,0,74)]), ((1,213,66),
  &[(0,0,75)]), ((1,213,67), &[(0,0,76)]), ((1,213,68), &[(0,0,77)]),
  ((1,213,70), &[(0,0,79)]), ((1,213,74), &[(0,0,83)]), ((1,213,75),
  &[(0,0,84)]), ((1,213,76), &[(0,0,85)]), ((1,213,77), &[(0,0,86)]),
  ((1,213,78), &[(0,0,87)]), ((1,213,79), &[(0,0,88)]), ((1,213,80),
  &[(0,0,89)]), ((1,213,82), &[(0,0,97)]), ((1,213,83), &[(0,0,98)]),
  ((1,213,84), &[(0,0,99)]), ((1,213,85), &[(0,0,100)]), ((1,213,86),
  &[(0,0,101)]), ((1,213,87), &[(0,0,102)]), ((1,213,88), &[(0,0,103)]),
  ((1,213,89), &[(0,0,104)]), ((1,213,90), &[(0,0,105)]), ((1,213,91),
  &[(0,0,106)]), ((1,213,92), &[(0,0,107)]), ((1,213,93), &[(0,0,108)]),
  ((1,213,94), &[(0,0,109)]), ((1,213,95), &[(0,0,110)]), ((1,213,96),
  &[(0,0,111)]), ((1,213,97), &[(0,0,112)]), ((1,213,98), &[(0,0,113)]),
  ((1,213,99), &[(0,0,114)]), ((1,213,100), &[(0,0,115)]), ((1,213,101),
  &[(0,0,116)]), ((1,213,102), &[(0,0,117)]), ((1,213,103), &[(0,0,118)]),
  ((1,213,104), &[(0,0,119)]), ((1,213,105), &[(0,0,120)]), ((1,213,106),
  &[(0,0,121)]), ((1,213,107), &[(0,0,122)]), ((1,213,108), &[(0,0,65)]),
  ((1,213,109), &[(0,0,66)]), ((1,213,110), &[(0,0,67)]), ((1,213,111),
  &[(0,0,68)]), ((1,213,112), &[(0,0,69)]), ((1,213,113), &[(0,0,70)]),
  ((1,213,114), &[(0,0,71)]), ((1,213,115), &[(0,0,72)]), ((1,213,116),
  &[(0,0,73)]), ((1,213,117), &[(0,0,74)]), ((1,213,118), &[(0,0,75)]),
  ((1,213,119), &[(0,0,76)]), ((1,213,120), &[(0,0,77)]), ((1,213,121),
  &[(0,0,78)]), ((1,213,122), &[(0,0,79)]), ((1,213,123), &[(0,0,80)]),
  ((1,213,124), &[(0,0,81)]), ((1,213,125), &[(0,0,82)]), ((1,213,126),
  &[(0,0,83)]), ((1,213,127), &[(0,0,84)]), ((1,213,128), &[(0,0,85)]),
  ((1,213,129), &[(0,0,86)]), ((1,213,130), &[(0,0,87)]), ((1,213,131),
  &[(0,0,88)]), ((1,213,132), &[(0,0,89)]), ((1,213,133), &[(0,0,90)]),
  ((1,213,134), &[(0,0,97)]), ((1,213,135), &[(0,0,98)]), ((1,213,136),
  &[(0,0,99)]), ((1,213,137), &[(0,0,100)]), ((1,213,138), &[(0,0,101)]),
  ((1,213,139), &[(0,0,102)]), ((1,213,140), &[(0,0,103)]), ((1,213,141),
  &[(0,0,104)]), ((1,213,142), &[(0,0,105)]), ((1,213,143), &[(0,0,106)]),
  ((1,213,144), &[(0,0,107)]), ((1,213,145), &[(0,0,108)]), ((1,213,146),
  &[(0,0,109)]), ((1,213,147), &[(0,0,110)]), ((1,213,148), &[(0,0,111)]),
  ((1,213,149), &[(0,0,112)]), ((1,213,150), &[(0,0,113)]), ((1,213,151),
  &[(0,0,114)]), ((1,213,152), &[(0,0,115)]), ((1,213,153), &[(0,0,116)]),
  ((1,213,154), &[(0,0,117)]), ((1,213,155), &[(0,0,118)]), ((1,213,156),
  &[(0,0,119)]), ((1,213,157), &[(0,0,120)]), ((1,213,158), &[(0,0,121)]),
  ((1,213,159), &[(0,0,122)]), ((1,213,160), &[(0,0,65)]), ((1,213,161),
  &[(0,0,66)]), ((1,213,162), &[(0,0,67)]), ((1,213,163), &[(0,0,68)]),
  ((1,213,164), &[(0,0,69)]), ((1,213,165), &[(0,0,70)]), ((1,213,166),
  &[(0,0,71)]), ((1,213,167), &[(0,0,72)]), ((1,213,168), &[(0,0,73)]),
  ((1,213,169), &[(0,0,74)]), ((1,213,170), &[(0,0,75)]), ((1,213,171),
  &[(0,0,76)]), ((1,213,172), &[(0,0,77)]), ((1,213,173), &[(0,0,78)]),
  ((1,213,174), &[(0,0,79)]), ((1,213,175), &[(0,0,80)]), ((1,213,176),
  &[(0,0,81)]), ((1,213,177), &[(0,0,82)]), ((1,213,178), &[(0,0,83)]),
  ((1,213,179), &[(0,0,84)]), ((1,213,180), &[(0,0,85)]), ((1,213,181),
  &[(0,0,86)]), ((1,213,182), &[(0,0,87)]), ((1,213,183), &[(0,0,88)]),
  ((1,213,184), &[(0,0,89)]), ((1,213,185), &[(0,0,90)]), ((1,213,186),
  &[(0,0,97)]), ((1,213,187), &[(0,0,98)]), ((1,213,188), &[(0,0,99)]),
  ((1,213,189), &[(0,0,100)]), ((1,213,190), &[(0,0,101)]), ((1,213,191),
  &[(0,0,102)]), ((1,213,192), &[(0,0,103)]), ((1,213,193), &[(0,0,104)]),
  ((1,213,194), &[(0,0,105)]), ((1,213,195), &[(0,0,106)]), ((1,213,196),
  &[(0,0,107)]), ((1,213,197), &[(0,0,108)]), ((1,213,198), &[(0,0,109)]),
  ((1,213,199), &[(0,0,110)]), ((1,213,200), &[(0,0,111)]), ((1,213,201),
  &[(0,0,112)]), ((1,213,202), &[(0,0,113)]), ((1,213,203), &[(0,0,114)]),
  ((1,213,204), &[(0,0,115)]), ((1,213,205), &[(0,0,116)]), ((1,213,206),
  &[(0,0,117)]), ((1,213,207), &[(0,0,118)]), ((1,213,208), &[(0,0,119)]),
  ((1,213,209), &[(0,0,120)]), ((1,213,210), &[(0,0,121)]), ((1,213,211),
  &[(0,0,122)]), ((1,213,212), &[(0,0,65)]), ((1,213,213), &[(0,0,66)]),
  ((1,213,214), &[(0,0,67)]), ((1,213,215), &[(0,0,68)]), ((1,213,216),
  &[(0,0,69)]), ((1,213,217), &[(0,0,70)]), ((1,213,218), &[(0,0,71)]),
  ((1,213,219), &[(0,0,72)]), ((1,213,220), &[(0,0,73)]), ((1,213,221),
  &[(0,0,74)]), ((1,213,222), &[(0,0,75)]), ((1,213,223), &[(0,0,76)]),
  ((1,213,224), &[(0,0,77)]), ((1,213,225), &[(0,0,78)]), ((1,213,226),
  &[(0,0,79)]), ((1,213,227), &[(0,0,80)]), ((1,213,228), &[(0,0,81)]),
  ((1,213,229), &[(0,0,82)]), ((1,213,230), &[(0,0,83)]), ((1,213,231),
  &[(0,0,84)]), ((1,213,232), &[(0,0,85)]), ((1,213,233), &[(0,0,86)]),
  ((1,213,234), &[(0,0,87)]), ((1,213,235), &[(0,0,88)]), ((1,213,236),
  &[(0,0,89)]), ((1,213,237), &[(0,0,90)]), ((1,213,238), &[(0,0,97)]),
  ((1,213,239), &[(0,0,98)]), ((1,213,240), &[(0,0,99)]), ((1,213,241),
  &[(0,0,100)]), ((1,213,242), &[(0,0,101)]), ((1,213,243), &[(0,0,102)]),
  ((1,213,244), &[(0,0,103)]), ((1,213,245), &[(0,0,104)]), ((1,213,246),
  &[(0,0,105)]), ((1,213,247), &[(0,0,106)]), ((1,213,248), &[(0,0,107)]),
  ((1,213,249), &[(0,0,108)]), ((1,213,250), &[(0,0,109)]), ((1,213,251),
  &[(0,0,110)]), ((1,213,252), &[(0,0,111)]), ((1,213,253), &[(0,0,112)]),
  ((1,213,254), &[(0,0,113)]), ((1,213,255), &[(0,0,114)]), ((1,214,0),
  &[(0,0,115)]), ((1,214,1), &[(0,0,116)]), ((1,214,2), &[(0,0,117)]),
  ((1,214,3), &[(0,0,118)]), ((1,214,4), &[(0,0,119)]), ((1,214,5),
  &[(0,0,120)]), ((1,214,6), &[(0,0,121)]), ((1,214,7), &[(0,0,122)]),
  ((1,214,8), &[(0,0,65)]), ((1,214,9), &[(0,0,66)]), ((1,214,10), &[(0,0,67)]),
  ((1,214,11), &[(0,0,68)]), ((1,214,12), &[(0,0,69)]), ((1,214,13),
  &[(0,0,70)]), ((1,214,14), &[(0,0,71)]), ((1,214,15), &[(0,0,72)]),
  ((1,214,16), &[(0,0,73)]), ((1,214,17), &[(0,0,74)]), ((1,214,18),
  &[(0,0,75)]), ((1,214,19), &[(0,0,76)]), ((1,214,20), &[(0,0,77)]),
  ((1,214,21), &[(0,0,78)]), ((1,214,22), &[(0,0,79)]), ((1,214,23),
  &[(0,0,80)]), ((1,214,24), &[(0,0,81)]), ((1,214,25), &[(0,0,82)]),
  ((1,214,26), &[(0,0,83)]), ((1,214,27), &[(0,0,84)]), ((1,214,28),
  &[(0,0,85)]), ((1,214,29), &[(0,0,86)]), ((1,214,30), &[(0,0,87)]),
  ((1,214,31), &[(0,0,88)]), ((1,214,32), &[(0,0,89)]), ((1,214,33),
  &[(0,0,90)]), ((1,214,34), &[(0,0,97)]), ((1,214,35), &[(0,0,98)]),
  ((1,214,36), &[(0,0,99)]), ((1,214,37), &[(0,0,100)]), ((1,214,38),
  &[(0,0,101)]), ((1,214,39), &[(0,0,102)]), ((1,214,40), &[(0,0,103)]),
  ((1,214,41), &[(0,0,104)]), ((1,214,42), &[(0,0,105)]), ((1,214,43),
  &[(0,0,106)]), ((1,214,44), &[(0,0,107)]), ((1,214,45), &[(0,0,108)]),
  ((1,214,46), &[(0,0,109)]), ((1,214,47), &[(0,0,110)]), ((1,214,48),
  &[(0,0,111)]), ((1,214,49), &[(0,0,112)]), ((1,214,50), &[(0,0,113)]),
  ((1,214,51), &[(0,0,114)]), ((1,214,52), &[(0,0,115)]), ((1,214,53),
  &[(0,0,116)]), ((1,214,54), &[(0,0,117)]), ((1,214,55), &[(0,0,118)]),
  ((1,214,56), &[(0,0,119)]), ((1,214,57), &[(0,0,120)]), ((1,214,58),
  &[(0,0,121)]), ((1,214,59), &[(0,0,122)]), ((1,214,60), &[(0,0,65)]),
  ((1,214,61), &[(0,0,66)]), ((1,214,62), &[(0,0,67)]), ((1,214,63),
  &[(0,0,68)]), ((1,214,64), &[(0,0,69)]), ((1,214,65), &[(0,0,70)]),
  ((1,214,66), &[(0,0,71)]), ((1,214,67), &[(0,0,72)]), ((1,214,68),
  &[(0,0,73)]), ((1,214,69), &[(0,0,74)]), ((1,214,70), &[(0,0,75)]),
  ((1,214,71), &[(0,0,76)]), ((1,214,72), &[(0,0,77)]), ((1,214,73),
  &[(0,0,78)]), ((1,214,74), &[(0,0,79)]), ((1,214,75), &[(0,0,80)]),
  ((1,214,76), &[(0,0,81)]), ((1,214,77), &[(0,0,82)]), ((1,214,78),
  &[(0,0,83)]), ((1,214,79), &[(0,0,84)]), ((1,214,80), &[(0,0,85)]),
  ((1,214,81), &[(0,0,86)]), ((1,214,82), &[(0,0,87)]), ((1,214,83),
  &[(0,0,88)]), ((1,214,84), &[(0,0,89)]), ((1,214,85), &[(0,0,90)]),
  ((1,214,86), &[(0,0,97)]), ((1,214,87), &[(0,0,98)]), ((1,214,88),
  &[(0,0,99)]), ((1,214,89), &[(0,0,100)]), ((1,214,90), &[(0,0,101)]),
  ((1,214,91), &[(0,0,102)]), ((1,214,92), &[(0,0,103)]), ((1,214,93),
  &[(0,0,104)]), ((1,214,94), &[(0,0,105)]), ((1,214,95), &[(0,0,106)]),
  ((1,214,96), &[(0,0,107)]), ((1,214,97), &[(0,0,108)]), ((1,214,98),
  &[(0,0,109)]), ((1,214,99), &[(0,0,110)]), ((1,214,100), &[(0,0,111)]),
  ((1,214,101), &[(0,0,112)]), ((1,214,102), &[(0,0,113)]), ((1,214,103),
  &[(0,0,114)]), ((1,214,104), &[(0,0,115)]), ((1,214,105), &[(0,0,116)]),
  ((1,214,106), &[(0,0,117)]), ((1,214,107), &[(0,0,118)]), ((1,214,108),
  &[(0,0,119)]), ((1,214,109), &[(0,0,120)]), ((1,214,110), &[(0,0,121)]),
  ((1,214,111), &[(0,0,122)]), ((1,214,112), &[(0,0,65)]), ((1,214,113),
  &[(0,0,66)]), ((1,214,114), &[(0,0,67)]), ((1,214,115), &[(0,0,68)]),
  ((1,214,116), &[(0,0,69)]), ((1,214,117), &[(0,0,70)]), ((1,214,118),
  &[(0,0,71)]), ((1,214,119), &[(0,0,72)]), ((1,214,120), &[(0,0,73)]),
  ((1,214,121), &[(0,0,74)]), ((1,214,122), &[(0,0,75)]), ((1,214,123),
  &[(0,0,76)]), ((1,214,124), &[(0,0,77)]), ((1,214,125), &[(0,0,78)]),
  ((1,214,126), &[(0,0,79)]), ((1,214,127), &[(0,0,80)]), ((1,214,128),
  &[(0,0,81)]), ((1,214,129), &[(0,0,82)]), ((1,214,130), &[(0,0,83)]),
  ((1,214,131), &[(0,0,84)]), ((1,214,132), &[(0,0,85)]), ((1,214,133),
  &[(0,0,86)]), ((1,214,134), &[(0,0,87)]), ((1,214,135), &[(0,0,88)]),
  ((1,214,136), &[(0,0,89)]), ((1,214,137), &[(0,0,90)]), ((1,214,138),
  &[(0,0,97)]), ((1,214,139), &[(0,0,98)]), ((1,214,140), &[(0,0,99)]),
  ((1,214,141), &[(0,0,100)]), ((1,214,142), &[(0,0,101)]), ((1,214,143),
  &[(0,0,102)]), ((1,214,144), &[(0,0,103)]), ((1,214,145), &[(0,0,104)]),
  ((1,214,146), &[(0,0,105)]), ((1,214,147), &[(0,0,106)]), ((1,214,148),
  &[(0,0,107)]), ((1,214,149), &[(0,0,108)]), ((1,214,150), &[(0,0,109)]),
  ((1,214,151), &[(0,0,110)]), ((1,214,152), &[(0,0,111)]), ((1,214,153),
  &[(0,0,112)]), ((1,214,154), &[(0,0,113)]), ((1,214,155), &[(0,0,114)]),
  ((1,214,156), &[(0,0,115)]), ((1,214,157), &[(0,0,116)]), ((1,214,158),
  &[(0,0,117)]), ((1,214,159), &[(0,0,118)]), ((1,214,160), &[(0,0,119)]),
  ((1,214,161), &[(0,0,120)]), ((1,214,162), &[(0,0,121)]), ((1,214,163),
  &[(0,0,122)]), ((1,214,164), &[(0,1,49)]), ((1,214,165), &[(0,2,55)]),
  ((1,214,168), &[(0,3,145)]), ((1,214,169), &[(0,3,146)]), ((1,214,170),
  &[(0,3,147)]), ((1,214,171), &[(0,3,148)]), ((1,214,172), &[(0,3,149)]),
  ((1,214,173), &[(0,3,150)]), ((1,214,174), &[(0,3,151)]), ((1,214,175),
  &[(0,3,152)]), ((1,214,176), &[(0,3,153)]), ((1,214,177), &[(0,3,154)]),
  ((1,214,178), &[(0,3,155)]), ((1,214,179), &[(0,3,156)]), ((1,214,180),
  &[(0,3,157)]), ((1,214,181), &[(0,3,158)]), ((1,214,182), &[(0,3,159)]),
  ((1,214,183), &[(0,3,160)]), ((1,214,184), &[(0,3,161)]), ((1,214,185),
  &[(0,3,244)]), ((1,214,186), &[(0,3,163)]), ((1,214,187), &[(0,3,164)]),
  ((1,214,188), &[(0,3,165)]), ((1,214,189), &[(0,3,166)]), ((1,214,190),
  &[(0,3,167)]), ((1,214,191), &[(0,3,168)]), ((1,214,192), &[(0,3,169)]),
  ((1,214,193), &[(0,34,7)]), ((1,214,194), &[(0,3,177)]), ((1,214,195),
  &[(0,3,178)]), ((1,214,196), &[(0,3,179)]), ((1,214,197), &[(0,3,180)]),
  ((1,214,198), &[(0,3,181)]), ((1,214,199), &[(0,3,182)]), ((1,214,200),
  &[(0,3,183)]), ((1,214,201), &[(0,3,184)]), ((1,214,202), &[(0,3,185)]),
  ((1,214,203), &[(0,3,186)]), ((1,214,204), &[(0,3,187)]), ((1,214,205),
  &[(0,3,188)]), ((1,214,206), &[(0,3,189)]), ((1,214,207), &[(0,3,190)]),
  ((1,214,208), &[(0,3,191)]), ((1,214,209), &[(0,3,192)]), ((1,214,210),
  &[(0,3,193)]), ((1,214,211), &[(0,3,194)]), ((1,214,212), &[(0,3,195)]),
  ((1,214,213), &[(0,3,196)]), ((1,214,214), &[(0,3,197)]), ((1,214,215),
  &[(0,3,198)]), ((1,214,216), &[(0,3,199)]), ((1,214,217), &[(0,3,200)]),
  ((1,214,218), &[(0,3,201)]), ((1,214,219), &[(0,34,2)]), ((1,214,220),
  &[(0,3,245)]), ((1,214,221), &[(0,3,209)]), ((1,214,222), &[(0,3,240)]),
  ((1,214,223), &[(0,3,213)]), ((1,214,224), &[(0,3,241)]), ((1,214,225),
  &[(0,3,214)]), ((1,214,226), &[(0,3,145)]), ((1,214,227), &[(0,3,146)]),
  ((1,214,228), &[(0,3,147)]), ((1,214,229), &[(0,3,148)]), ((1,214,230),
  &[(0,3,149)]), ((1,214,231), &[(0,3,150)]), ((1,214,232), &[(0,3,151)]),
  ((1,214,233), &[(0,3,152)]), ((1,214,234), &[(0,3,153)]), ((1,214,235),
  &[(0,3,154)]), ((1,214,236), &[(0,3,155)]), ((1,214,237), &[(0,3,156)]),
  ((1,214,238), &[(0,3,157)]), ((1,214,239), &[(0,3,158)]), ((1,214,240),
  &[(0,3,159)]), ((1,214,241), &[(0,3,160)]), ((1,214,242), &[(0,3,161)]),
  ((1,214,243), &[(0,3,244)]), ((1,214,244), &[(0,3,163)]), ((1,214,245),
  &[(0,3,164)]), ((1,214,246), &[(0,3,165)]), ((1,214,247), &[(0,3,166)]),
  ((1,214,248), &[(0,3,167)]), ((1,214,249), &[(0,3,168)]), ((1,214,250),
  &[(0,3,169)]), ((1,214,251), &[(0,34,7)]), ((1,214,252), &[(0,3,177)]),
  ((1,214,253), &[(0,3,178)]), ((1,214,254), &[(0,3,179)]), ((1,214,255),
  &[(0,3,180)]), ((1,215,0), &[(0,3,181)]), ((1,215,1), &[(0,3,182)]),
  ((1,215,2), &[(0,3,183)]), ((1,215,3), &[(0,3,184)]), ((1,215,4),
  &[(0,3,185)]), ((1,215,5), &[(0,3,186)]), ((1,215,6), &[(0,3,187)]),
  ((1,215,7), &[(0,3,188)]), ((1,215,8), &[(0,3,189)]), ((1,215,9),
  &[(0,3,190)]), ((1,215,10), &[(0,3,191)]), ((1,215,11), &[(0,3,192)]),
  ((1,215,12), &[(0,3,193)]), ((1,215,13), &[(0,3,194)]), ((1,215,14),
  &[(0,3,195)]), ((1,215,15), &[(0,3,196)]), ((1,215,16), &[(0,3,197)]),
  ((1,215,17), &[(0,3,198)]), ((1,215,18), &[(0,3,199)]), ((1,215,19),
  &[(0,3,200)]), ((1,215,20), &[(0,3,201)]), ((1,215,21), &[(0,34,2)]),
  ((1,215,22), &[(0,3,245)]), ((1,215,23), &[(0,3,209)]), ((1,215,24),
  &[(0,3,240)]), ((1,215,25), &[(0,3,213)]), ((1,215,26), &[(0,3,241)]),
  ((1,215,27), &[(0,3,214)]), ((1,215,28), &[(0,3,145)]), ((1,215,29),
  &[(0,3,146)]), ((1,215,30), &[(0,3,147)]), ((1,215,31), &[(0,3,148)]),
  ((1,215,32), &[(0,3,149)]), ((1,215,33), &[(0,3,150)]), ((1,215,34),
  &[(0,3,151)]), ((1,215,35), &[(0,3,152)]), ((1,215,36), &[(0,3,153)]),
  ((1,215,37), &[(0,3,154)]), ((1,215,38), &[(0,3,155)]), ((1,215,39),
  &[(0,3,156)]), ((1,215,40), &[(0,3,157)]), ((1,215,41), &[(0,3,158)]),
  ((1,215,42), &[(0,3,159)]), ((1,215,43), &[(0,3,160)]), ((1,215,44),
  &[(0,3,161)]), ((1,215,45), &[(0,3,244)]), ((1,215,46), &[(0,3,163)]),
  ((1,215,47), &[(0,3,164)]), ((1,215,48), &[(0,3,165)]), ((1,215,49),
  &[(0,3,166)]), ((1,215,50), &[(0,3,167)]), ((1,215,51), &[(0,3,168)]),
  ((1,215,52), &[(0,3,169)]), ((1,215,53), &[(0,34,7)]), ((1,215,54),
  &[(0,3,177)]), ((1,215,55), &[(0,3,178)]), ((1,215,56), &[(0,3,179)]),
  ((1,215,57), &[(0,3,180)]), ((1,215,58), &[(0,3,181)]), ((1,215,59),
  &[(0,3,182)]), ((1,215,60), &[(0,3,183)]), ((1,215,61), &[(0,3,184)]),
  ((1,215,62), &[(0,3,185)]), ((1,215,63), &[(0,3,186)]), ((1,215,64),
  &[(0,3,187)]), ((1,215,65), &[(0,3,188)]), ((1,215,66), &[(0,3,189)]),
  ((1,215,67), &[(0,3,190)]), ((1,215,68), &[(0,3,191)]), ((1,215,69),
  &[(0,3,192)]), ((1,215,70), &[(0,3,193)]), ((1,215,71), &[(0,3,194)]),
  ((1,215,72), &[(0,3,195)]), ((1,215,73), &[(0,3,196)]), ((1,215,74),
  &[(0,3,197)]), ((1,215,75), &[(0,3,198)]), ((1,215,76), &[(0,3,199)]),
  ((1,215,77), &[(0,3,200)]), ((1,215,78), &[(0,3,201)]), ((1,215,79),
  &[(0,34,2)]), ((1,215,80), &[(0,3,245)]), ((1,215,81), &[(0,3,209)]),
  ((1,215,82), &[(0,3,240)]), ((1,215,83), &[(0,3,213)]), ((1,215,84),
  &[(0,3,241)]), ((1,215,85), &[(0,3,214)]), ((1,215,86), &[(0,3,145)]),
  ((1,215,87), &[(0,3,146)]), ((1,215,88), &[(0,3,147)]), ((1,215,89),
  &[(0,3,148)]), ((1,215,90), &[(0,3,149)]), ((1,215,91), &[(0,3,150)]),
  ((1,215,92), &[(0,3,151)]), ((1,215,93), &[(0,3,152)]), ((1,215,94),
  &[(0,3,153)]), ((1,215,95), &[(0,3,154)]), ((1,215,96), &[(0,3,155)]),
  ((1,215,97), &[(0,3,156)]), ((1,215,98), &[(0,3,157)]), ((1,215,99),
  &[(0,3,158)]), ((1,215,100), &[(0,3,159)]), ((1,215,101), &[(0,3,160)]),
  ((1,215,102), &[(0,3,161)]), ((1,215,103), &[(0,3,244)]), ((1,215,104),
  &[(0,3,163)]), ((1,215,105), &[(0,3,164)]), ((1,215,106), &[(0,3,165)]),
  ((1,215,107), &[(0,3,166)]), ((1,215,108), &[(0,3,167)]), ((1,215,109),
  &[(0,3,168)]), ((1,215,110), &[(0,3,169)]), ((1,215,111), &[(0,34,7)]),
  ((1,215,112), &[(0,3,177)]), ((1,215,113), &[(0,3,178)]), ((1,215,114),
  &[(0,3,179)]), ((1,215,115), &[(0,3,180)]), ((1,215,116), &[(0,3,181)]),
  ((1,215,117), &[(0,3,182)]), ((1,215,118), &[(0,3,183)]), ((1,215,119),
  &[(0,3,184)]), ((1,215,120), &[(0,3,185)]), ((1,215,121), &[(0,3,186)]),
  ((1,215,122), &[(0,3,187)]), ((1,215,123), &[(0,3,188)]), ((1,215,124),
  &[(0,3,189)]), ((1,215,125), &[(0,3,190)]), ((1,215,126), &[(0,3,191)]),
  ((1,215,127), &[(0,3,192)]), ((1,215,128), &[(0,3,193)]), ((1,215,129),
  &[(0,3,194)]), ((1,215,130), &[(0,3,195)]), ((1,215,131), &[(0,3,196)]),
  ((1,215,132), &[(0,3,197)]), ((1,215,133), &[(0,3,198)]), ((1,215,134),
  &[(0,3,199)]), ((1,215,135), &[(0,3,200)]), ((1,215,136), &[(0,3,201)]),
  ((1,215,137), &[(0,34,2)]), ((1,215,138), &[(0,3,245)]), ((1,215,139),
  &[(0,3,209)]), ((1,215,140), &[(0,3,240)]), ((1,215,141), &[(0,3,213)]),
  ((1,215,142), &[(0,3,241)]), ((1,215,143), &[(0,3,214)]), ((1,215,144),
  &[(0,3,145)]), ((1,215,145), &[(0,3,146)]), ((1,215,146), &[(0,3,147)]),
  ((1,215,147), &[(0,3,148)]), ((1,215,148), &[(0,3,149)]), ((1,215,149),
  &[(0,3,150)]), ((1,215,150), &[(0,3,151)]), ((1,215,151), &[(0,3,152)]),
  ((1,215,152), &[(0,3,153)]), ((1,215,153), &[(0,3,154)]), ((1,215,154),
  &[(0,3,155)]), ((1,215,155), &[(0,3,156)]), ((1,215,156), &[(0,3,157)]),
  ((1,215,157), &[(0,3,158)]), ((1,215,158), &[(0,3,159)]), ((1,215,159),
  &[(0,3,160)]), ((1,215,160), &[(0,3,161)]), ((1,215,161), &[(0,3,244)]),
  ((1,215,162), &[(0,3,163)]), ((1,215,163), &[(0,3,164)]), ((1,215,164),
  &[(0,3,165)]), ((1,215,165), &[(0,3,166)]), ((1,215,166), &[(0,3,167)]),
  ((1,215,167), &[(0,3,168)]), ((1,215,168), &[(0,3,169)]), ((1,215,169),
  &[(0,34,7)]), ((1,215,170), &[(0,3,177)]), ((1,215,171), &[(0,3,178)]),
  ((1,215,172), &[(0,3,179)]), ((1,215,173), &[(0,3,180)]), ((1,215,174),
  &[(0,3,181)]), ((1,215,175), &[(0,3,182)]), ((1,215,176), &[(0,3,183)]),
  ((1,215,177), &[(0,3,184)]), ((1,215,178), &[(0,3,185)]), ((1,215,179),
  &[(0,3,186)]), ((1,215,180), &[(0,3,187)]), ((1,215,181), &[(0,3,188)]),
  ((1,215,182), &[(0,3,189)]), ((1,215,183), &[(0,3,190)]), ((1,215,184),
  &[(0,3,191)]), ((1,215,185), &[(0,3,192)]), ((1,215,186), &[(0,3,193)]),
  ((1,215,187), &[(0,3,194)]), ((1,215,188), &[(0,3,195)]), ((1,215,189),
  &[(0,3,196)]), ((1,215,190), &[(0,3,197)]), ((1,215,191), &[(0,3,198)]),
  ((1,215,192), &[(0,3,199)]), ((1,215,193), &[(0,3,200)]), ((1,215,194),
  &[(0,3,201)]), ((1,215,195), &[(0,34,2)]), ((1,215,196), &[(0,3,245)]),
  ((1,215,197), &[(0,3,209)]), ((1,215,198), &[(0,3,240)]), ((1,215,199),
  &[(0,3,213)]), ((1,215,200), &[(0,3,241)]), ((1,215,201), &[(0,3,214)]),
  ((1,215,202), &[(0,3,220)]), ((1,215,203), &[(0,3,221)]), ((1,215,206),
  &[(0,0,48)]), ((1,215,207), &[(0,0,49)]), ((1,215,208), &[(0,0,50)]),
  ((1,215,209), &[(0,0,51)]), ((1,215,210), &[(0,0,52)]), ((1,215,211),
  &[(0,0,53)]), ((1,215,212), &[(0,0,54)]), ((1,215,213), &[(0,0,55)]),
  ((1,215,214), &[(0,0,56)]), ((1,215,215), &[(0,0,57)]), ((1,215,216),
  &[(0,0,48)]), ((1,215,217), &[(0,0,49)]), ((1,215,218), &[(0,0,50)]),
  ((1,215,219), &[(0,0,51)]), ((1,215,220), &[(0,0,52)]), ((1,215,221),
  &[(0,0,53)]), ((1,215,222), &[(0,0,54)]), ((1,215,223), &[(0,0,55)]),
  ((1,215,224), &[(0,0,56)]), ((1,215,225), &[(0,0,57)]), ((1,215,226),
  &[(0,0,48)]), ((1,215,227), &[(0,0,49)]), ((1,215,228), &[(0,0,50)]),
  ((1,215,229), &[(0,0,51)]), ((1,215,230), &[(0,0,52)]), ((1,215,231),
  &[(0,0,53)]), ((1,215,232), &[(0,0,54)]), ((1,215,233), &[(0,0,55)]),
  ((1,215,234), &[(0,0,56)]), ((1,215,235), &[(0,0,57)]), ((1,215,236),
  &[(0,0,48)]), ((1,215,237), &[(0,0,49)]), ((1,215,238), &[(0,0,50)]),
  ((1,215,239), &[(0,0,51)]), ((1,215,240), &[(0,0,52)]), ((1,215,241),
  &[(0,0,53)]), ((1,215,242), &[(0,0,54)]), ((1,215,243), &[(0,0,55)]),
  ((1,215,244), &[(0,0,56)]), ((1,215,245), &[(0,0,57)]), ((1,215,246),
  &[(0,0,48)]), ((1,215,247), &[(0,0,49)]), ((1,215,248), &[(0,0,50)]),
  ((1,215,249), &[(0,0,51)]), ((1,215,250), &[(0,0,52)]), ((1,215,251),
  &[(0,0,53)]), ((1,215,252), &[(0,0,54)]), ((1,215,253), &[(0,0,55)]),
  ((1,215,254), &[(0,0,56)]), ((1,215,255), &[(0,0,57)]), ((1,238,0),
  &[(0,6,39)]), ((1,238,1), &[(0,6,40)]), ((1,238,2), &[(0,6,44)]), ((1,238,3),
  &[(0,6,47)]), ((1,238,5), &[(0,6,72)]), ((1,238,6), &[(0,6,50)]), ((1,238,7),
  &[(0,6,45)]), ((1,238,8), &[(0,6,55)]), ((1,238,9), &[(0,6,74)]), ((1,238,10),
  &[(0,6,67)]), ((1,238,11), &[(0,6,68)]), ((1,238,12), &[(0,6,69)]),
  ((1,238,13), &[(0,6,70)]), ((1,238,14), &[(0,6,51)]), ((1,238,15),
  &[(0,6,57)]), ((1,238,16), &[(0,6,65)]), ((1,238,17), &[(0,6,53)]),
  ((1,238,18), &[(0,6,66)]), ((1,238,19), &[(0,6,49)]), ((1,238,20),
  &[(0,6,52)]), ((1,238,21), &[(0,6,42)]), ((1,238,22), &[(0,6,43)]),
  ((1,238,23), &[(0,6,46)]), ((1,238,24), &[(0,6,48)]), ((1,238,25),
  &[(0,6,54)]), ((1,238,26), &[(0,6,56)]), ((1,238,27), &[(0,6,58)]),
  ((1,238,28), &[(0,6,110)]), ((1,238,29), &[(0,6,186)]), ((1,238,30),
  &[(0,6,161)]), ((1,238,31), &[(0,6,111)]), ((1,238,33), &[(0,6,40)]),
  ((1,238,34), &[(0,6,44)]), ((1,238,36), &[(0,6,71)]), ((1,238,39),
  &[(0,6,45)]), ((1,238,41), &[(0,6,74)]), ((1,238,42), &[(0,6,67)]),
  ((1,238,43), &[(0,6,68)]), ((1,238,44), &[(0,6,69)]), ((1,238,45),
  &[(0,6,70)]), ((1,238,46), &[(0,6,51)]), ((1,238,47), &[(0,6,57)]),
  ((1,238,48), &[(0,6,65)]), ((1,238,49), &[(0,6,53)]), ((1,238,50),
  &[(0,6,66)]), ((1,238,52), &[(0,6,52)]), ((1,238,53), &[(0,6,42)]),
  ((1,238,54), &[(0,6,43)]), ((1,238,55), &[(0,6,46)]), ((1,238,57),
  &[(0,6,54)]), ((1,238,59), &[(0,6,58)]), ((1,238,66), &[(0,6,44)]),
  ((1,238,71), &[(0,6,45)]), ((1,238,73), &[(0,6,74)]), ((1,238,75),
  &[(0,6,68)]), ((1,238,77), &[(0,6,70)]), ((1,238,78), &[(0,6,51)]),
  ((1,238,79), &[(0,6,57)]), ((1,238,81), &[(0,6,53)]), ((1,238,82),
  &[(0,6,66)]), ((1,238,84), &[(0,6,52)]), ((1,238,87), &[(0,6,46)]),
  ((1,238,89), &[(0,6,54)]), ((1,238,91), &[(0,6,58)]), ((1,238,93),
  &[(0,6,186)]), ((1,238,95), &[(0,6,111)]), ((1,238,97), &[(0,6,40)]),
  ((1,238,98), &[(0,6,44)]), ((1,238,100), &[(0,6,71)]), ((1,238,103),
  &[(0,6,45)]), ((1,238,104), &[(0,6,55)]), ((1,238,105), &[(0,6,74)]),
  ((1,238,106), &[(0,6,67)]), ((1,238,108), &[(0,6,69)]), ((1,238,109),
  &[(0,6,70)]), ((1,238,110), &[(0,6,51)]), ((1,238,111), &[(0,6,57)]),
  ((1,238,112), &[(0,6,65)]), ((1,238,113), &[(0,6,53)]), ((1,238,114),
  &[(0,6,66)]), ((1,238,116), &[(0,6,52)]), ((1,238,117), &[(0,6,42)]),
  ((1,238,118), &[(0,6,43)]), ((1,238,119), &[(0,6,46)]), ((1,238,121),
  &[(0,6,54)]), ((1,238,122), &[(0,6,56)]), ((1,238,123), &[(0,6,58)]),
  ((1,238,124), &[(0,6,110)]), ((1,238,126), &[(0,6,161)]), ((1,238,128),
  &[(0,6,39)]), ((1,238,129), &[(0,6,40)]), ((1,238,130), &[(0,6,44)]),
  ((1,238,131), &[(0,6,47)]), ((1,238,132), &[(0,6,71)]), ((1,238,133),
  &[(0,6,72)]), ((1,238,134), &[(0,6,50)]), ((1,238,135), &[(0,6,45)]),
  ((1,238,136), &[(0,6,55)]), ((1,238,137), &[(0,6,74)]), ((1,238,139),
  &[(0,6,68)]), ((1,238,140), &[(0,6,69)]), ((1,238,141), &[(0,6,70)]),
  ((1,238,142), &[(0,6,51)]), ((1,238,143), &[(0,6,57)]), ((1,238,144),
  &[(0,6,65)]), ((1,238,145), &[(0,6,53)]), ((1,238,146), &[(0,6,66)]),
  ((1,238,147), &[(0,6,49)]), ((1,238,148), &[(0,6,52)]), ((1,238,149),
  &[(0,6,42)]), ((1,238,150), &[(0,6,43)]), ((1,238,151), &[(0,6,46)]),
  ((1,238,152), &[(0,6,48)]), ((1,238,153), &[(0,6,54)]), ((1,238,154),
  &[(0,6,56)]), ((1,238,155), &[(0,6,58)]), ((1,238,161), &[(0,6,40)]),
  ((1,238,162), &[(0,6,44)]), ((1,238,163), &[(0,6,47)]), ((1,238,165),
  &[(0,6,72)]), ((1,238,166), &[(0,6,50)]), ((1,238,167), &[(0,6,45)]),
  ((1,238,168), &[(0,6,55)]), ((1,238,169), &[(0,6,74)]), ((1,238,171),
  &[(0,6,68)]), ((1,238,172), &[(0,6,69)]), ((1,238,173), &[(0,6,70)]),
  ((1,238,174), &[(0,6,51)]), ((1,238,175), &[(0,6,57)]), ((1,238,176),
  &[(0,6,65)]), ((1,238,177), &[(0,6,53)]), ((1,238,178), &[(0,6,66)]),
  ((1,238,179), &[(0,6,49)]), ((1,238,180), &[(0,6,52)]), ((1,238,181),
  &[(0,6,42)]), ((1,238,182), &[(0,6,43)]), ((1,238,183), &[(0,6,46)]),
  ((1,238,184), &[(0,6,48)]), ((1,238,185), &[(0,6,54)]), ((1,238,186),
  &[(0,6,56)]), ((1,238,187), &[(0,6,58)]), ((1,241,0), &[(0,0,48), (0,0,46)]),
  ((1,241,1), &[(0,0,48), (0,0,44)]), ((1,241,2), &[(0,0,49), (0,0,44)]),
  ((1,241,3), &[(0,0,50), (0,0,44)]), ((1,241,4), &[(0,0,51), (0,0,44)]),
  ((1,241,5), &[(0,0,52), (0,0,44)]), ((1,241,6), &[(0,0,53), (0,0,44)]),
  ((1,241,7), &[(0,0,54), (0,0,44)]), ((1,241,8), &[(0,0,55), (0,0,44)]),
  ((1,241,9), &[(0,0,56), (0,0,44)]), ((1,241,10), &[(0,0,57), (0,0,44)]),
  ((1,241,16), &[(0,0,40), (0,0,65), (0,0,41)]), ((1,241,17), &[(0,0,40),
  (0,0,66), (0,0,41)]), ((1,241,18), &[(0,0,40), (0,0,67), (0,0,41)]),
  ((1,241,19), &[(0,0,40), (0,0,68), (0,0,41)]), ((1,241,20), &[(0,0,40),
  (0,0,69), (0,0,41)]), ((1,241,21), &[(0,0,40), (0,0,70), (0,0,41)]),
  ((1,241,22), &[(0,0,40), (0,0,71), (0,0,41)]), ((1,241,23), &[(0,0,40),
  (0,0,72), (0,0,41)]), ((1,241,24), &[(0,0,40), (0,0,73), (0,0,41)]),
  ((1,241,25), &[(0,0,40), (0,0,74), (0,0,41)]), ((1,241,26), &[(0,0,40),
  (0,0,75), (0,0,41)]), ((1,241,27), &[(0,0,40), (0,0,76), (0,0,41)]),
  ((1,241,28), &[(0,0,40), (0,0,77), (0,0,41)]), ((1,241,29), &[(0,0,40),
  (0,0,78), (0,0,41)]), ((1,241,30), &[(0,0,40), (0,0,79), (0,0,41)]),
  ((1,241,31), &[(0,0,40), (0,0,80), (0,0,41)]), ((1,241,32), &[(0,0,40),
  (0,0,81), (0,0,41)]), ((1,241,33), &[(0,0,40), (0,0,82), (0,0,41)]),
  ((1,241,34), &[(0,0,40), (0,0,83), (0,0,41)]), ((1,241,35), &[(0,0,40),
  (0,0,84), (0,0,41)]), ((1,241,36), &[(0,0,40), (0,0,85), (0,0,41)]),
  ((1,241,37), &[(0,0,40), (0,0,86), (0,0,41)]), ((1,241,38), &[(0,0,40),
  (0,0,87), (0,0,41)]), ((1,241,39), &[(0,0,40), (0,0,88), (0,0,41)]),
  ((1,241,40), &[(0,0,40), (0,0,89), (0,0,41)]), ((1,241,41), &[(0,0,40),
  (0,0,90), (0,0,41)]), ((1,241,42), &[(0,48,20), (0,0,83), (0,48,21)]),
  ((1,241,43), &[(0,0,67)]), ((1,241,44), &[(0,0,82)]), ((1,241,45), &[(0,0,67),
  (0,0,68)]), ((1,241,46), &[(0,0,87), (0,0,90)]), ((1,241,48), &[(0,0,65)]),
  ((1,241,49), &[(0,0,66)]), ((1,241,50), &[(0,0,67)]), ((1,241,51),
  &[(0,0,68)]), ((1,241,52), &[(0,0,69)]), ((1,241,53), &[(0,0,70)]),
  ((1,241,54), &[(0,0,71)]), ((1,241,55), &[(0,0,72)]), ((1,241,56),
  &[(0,0,73)]), ((1,241,57), &[(0,0,74)]), ((1,241,58), &[(0,0,75)]),
  ((1,241,59), &[(0,0,76)]), ((1,241,60), &[(0,0,77)]), ((1,241,61),
  &[(0,0,78)]), ((1,241,62), &[(0,0,79)]), ((1,241,63), &[(0,0,80)]),
  ((1,241,64), &[(0,0,81)]), ((1,241,65), &[(0,0,82)]), ((1,241,66),
  &[(0,0,83)]), ((1,241,67), &[(0,0,84)]), ((1,241,68), &[(0,0,85)]),
  ((1,241,69), &[(0,0,86)]), ((1,241,70), &[(0,0,87)]), ((1,241,71),
  &[(0,0,88)]), ((1,241,72), &[(0,0,89)]), ((1,241,73), &[(0,0,90)]),
  ((1,241,74), &[(0,0,72), (0,0,86)]), ((1,241,75), &[(0,0,77), (0,0,86)]),
  ((1,241,76), &[(0,0,83), (0,0,68)]), ((1,241,77), &[(0,0,83), (0,0,83)]),
  ((1,241,78), &[(0,0,80), (0,0,80), (0,0,86)]), ((1,241,79), &[(0,0,87),
  (0,0,67)]), ((1,241,106), &[(0,0,77), (0,0,67)]), ((1,241,107), &[(0,0,77),
  (0,0,68)]), ((1,241,144), &[(0,0,68), (0,0,74)]), ((1,242,0), &[(0,48,123),
  (0,48,75)]), ((1,242,1), &[(0,48,179), (0,48,179)]), ((1,242,2),
  &[(0,48,181)]), ((1,242,16), &[(0,98,75)]), ((1,242,17), &[(0,91,87)]),
  ((1,242,18), &[(0,83,204)]), ((1,242,19), &[(0,48,199)]), ((1,242,20),
  &[(0,78,140)]), ((1,242,21), &[(0,89,26)]), ((1,242,22), &[(0,137,227)]),
  ((1,242,23), &[(0,89,41)]), ((1,242,24), &[(0,78,164)]), ((1,242,25),
  &[(0,102,32)]), ((1,242,26), &[(0,113,33)]), ((1,242,27), &[(0,101,153)]),
  ((1,242,28), &[(0,82,77)]), ((1,242,29), &[(0,95,140)]), ((1,242,30),
  &[(0,81,141)]), ((1,242,31), &[(0,101,176)]), ((1,242,32), &[(0,82,29)]),
  ((1,242,33), &[(0,125,66)]), ((1,242,34), &[(0,117,31)]), ((1,242,35),
  &[(0,140,169)]), ((1,242,36), &[(0,88,240)]), ((1,242,37), &[(0,84,57)]),
  ((1,242,38), &[(0,111,20)]), ((1,242,39), &[(0,98,149)]), ((1,242,40),
  &[(0,99,85)]), ((1,242,41), &[(0,78,0)]), ((1,242,42), &[(0,78,9)]),
  ((1,242,43), &[(0,144,74)]), ((1,242,44), &[(0,93,230)]), ((1,242,45),
  &[(0,78,45)]), ((1,242,46), &[(0,83,243)]), ((1,242,47), &[(0,99,7)]),
  ((1,242,48), &[(0,141,112)]), ((1,242,49), &[(0,98,83)]), ((1,242,50),
  &[(0,121,129)]), ((1,242,51), &[(0,122,122)]), ((1,242,52), &[(0,84,8)]),
  ((1,242,53), &[(0,110,128)]), ((1,242,54), &[(0,103,9)]), ((1,242,55),
  &[(0,103,8)]), ((1,242,56), &[(0,117,51)]), ((1,242,57), &[(0,82,114)]),
  ((1,242,58), &[(0,85,182)]), ((1,242,59), &[(0,145,77)]), ((1,242,64),
  &[(0,48,20), (0,103,44), (0,48,21)]), ((1,242,65), &[(0,48,20), (0,78,9),
  (0,48,21)]), ((1,242,66), &[(0,48,20), (0,78,140), (0,48,21)]), ((1,242,67),
  &[(0,48,20), (0,91,137), (0,48,21)]), ((1,242,68), &[(0,48,20), (0,112,185),
  (0,48,21)]), ((1,242,69), &[(0,48,20), (0,98,83), (0,48,21)]), ((1,242,70),
  &[(0,48,20), (0,118,215), (0,48,21)]), ((1,242,71), &[(0,48,20), (0,82,221),
  (0,48,21)]), ((1,242,72), &[(0,48,20), (0,101,87), (0,48,21)]), ((1,242,80),
  &[(0,95,151)]), ((1,242,81), &[(0,83,239)]), ((2,248,0), &[(0,78,61)]),
  ((2,248,1), &[(0,78,56)]), ((2,248,2), &[(0,78,65)]), ((2,248,3),
  &[(2,1,34)]), ((2,248,4), &[(0,79,96)]), ((2,248,5), &[(0,79,174)]),
  ((2,248,6), &[(0,79,187)]), ((2,248,7), &[(0,80,2)]), ((2,248,8),
  &[(0,80,122)]), ((2,248,9), &[(0,80,153)]), ((2,248,10), &[(0,80,231)]),
  ((2,248,11), &[(0,80,207)]), ((2,248,12), &[(0,52,158)]), ((2,248,13),
  &[(2,6,58)]), ((2,248,14), &[(0,81,77)]), ((2,248,15), &[(0,81,84)]),
  ((2,248,16), &[(0,81,100)]), ((2,248,17), &[(0,81,119)]), ((2,248,18),
  &[(2,5,28)]), ((2,248,19), &[(0,52,185)]), ((2,248,20), &[(0,81,103)]),
  ((2,248,21), &[(0,81,141)]), ((2,248,22), &[(2,5,75)]), ((2,248,23),
  &[(0,81,151)]), ((2,248,24), &[(0,81,164)]), ((2,248,25), &[(0,78,204)]),
  ((2,248,26), &[(0,81,172)]), ((2,248,27), &[(0,81,181)]), ((2,248,28),
  &[(2,145,223)]), ((2,248,29), &[(0,81,245)]), ((2,248,30), &[(0,82,3)]),
  ((2,248,31), &[(0,52,223)]), ((2,248,32), &[(0,82,59)]), ((2,248,33),
  &[(0,82,70)]), ((2,248,34), &[(0,82,114)]), ((2,248,35), &[(0,82,119)]),
  ((2,248,36), &[(0,53,21)]), ((2,248,37), &[(0,82,199)]), ((2,248,38),
  &[(0,82,201)]), ((2,248,39), &[(0,82,228)]), ((2,248,40), &[(0,82,250)]),
  ((2,248,41), &[(0,83,5)]), ((2,248,42), &[(0,83,6)]), ((2,248,43),
  &[(0,83,23)]), ((2,248,44), &[(0,83,73)]), ((2,248,45), &[(0,83,81)]),
  ((2,248,46), &[(0,83,90)]), ((2,248,47), &[(0,83,115)]), ((2,248,48),
  &[(0,83,125)]), ((2,248,49), &[(0,83,127)]), ((2,248,50), &[(0,83,127)]),
  ((2,248,51), &[(0,83,127)]), ((2,248,52), &[(2,10,44)]), ((2,248,53),
  &[(0,112,112)]), ((2,248,54), &[(0,83,202)]), ((2,248,55), &[(0,83,223)]),
  ((2,248,56), &[(2,11,99)]), ((2,248,57), &[(0,83,235)]), ((2,248,58),
  &[(0,83,241)]), ((2,248,59), &[(0,84,6)]), ((2,248,60), &[(0,84,158)]),
  ((2,248,61), &[(0,84,56)]), ((2,248,62), &[(0,84,72)]), ((2,248,63),
  &[(0,84,104)]), ((2,248,64), &[(0,84,162)]), ((2,248,65), &[(0,84,246)]),
  ((2,248,66), &[(0,85,16)]), ((2,248,67), &[(0,85,83)]), ((2,248,68),
  &[(0,85,99)]), ((2,248,69), &[(0,85,132)]), ((2,248,70), &[(0,85,132)]),
  ((2,248,71), &[(0,85,153)]), ((2,248,72), &[(0,85,171)]), ((2,248,73),
  &[(0,85,179)]), ((2,248,74), &[(0,85,194)]), ((2,248,75), &[(0,87,22)]),
  ((2,248,76), &[(0,86,6)]), ((2,248,77), &[(0,87,23)]), ((2,248,78),
  &[(0,86,81)]), ((2,248,79), &[(0,86,116)]), ((2,248,80), &[(0,82,7)]),
  ((2,248,81), &[(0,88,238)]), ((2,248,82), &[(0,87,206)]), ((2,248,83),
  &[(0,87,244)]), ((2,248,84), &[(0,88,13)]), ((2,248,85), &[(0,87,139)]),
  ((2,248,86), &[(0,88,50)]), ((2,248,87), &[(0,88,49)]), ((2,248,88),
  &[(0,88,172)]), ((2,248,89), &[(2,20,228)]), ((2,248,90), &[(0,88,242)]),
  ((2,248,91), &[(0,88,247)]), ((2,248,92), &[(0,89,6)]), ((2,248,93),
  &[(0,89,26)]), ((2,248,94), &[(0,89,34)]), ((2,248,95), &[(0,89,98)]),
  ((2,248,96), &[(2,22,168)]), ((2,248,97), &[(2,22,234)]), ((2,248,98),
  &[(0,89,236)]), ((2,248,99), &[(0,90,27)]), ((2,248,100), &[(0,90,39)]),
  ((2,248,101), &[(0,89,216)]), ((2,248,102), &[(0,90,102)]), ((2,248,103),
  &[(0,54,238)]), ((2,248,104), &[(0,54,252)]), ((2,248,105), &[(0,91,8)]),
  ((2,248,106), &[(0,91,62)]), ((2,248,107), &[(0,91,62)]), ((2,248,108),
  &[(2,25,200)]), ((2,248,109), &[(0,91,195)]), ((2,248,110), &[(0,91,216)]),
  ((2,248,111), &[(0,91,231)]), ((2,248,112), &[(0,91,243)]), ((2,248,113),
  &[(2,27,24)]), ((2,248,114), &[(0,91,255)]), ((2,248,115), &[(0,92,6)]),
  ((2,248,116), &[(0,95,83)]), ((2,248,117), &[(0,92,34)]), ((2,248,118),
  &[(0,55,129)]), ((2,248,119), &[(0,92,96)]), ((2,248,120), &[(0,92,110)]),
  ((2,248,121), &[(0,92,192)]), ((2,248,122), &[(0,92,141)]), ((2,248,123),
  &[(2,29,228)]), ((2,248,124), &[(0,93,67)]), ((2,248,125), &[(2,29,230)]),
  ((2,248,126), &[(0,93,110)]), ((2,248,127), &[(0,93,107)]), ((2,248,128),
  &[(0,93,124)]), ((2,248,129), &[(0,93,225)]), ((2,248,130), &[(0,93,226)]),
  ((2,248,131), &[(0,56,47)]), ((2,248,132), &[(0,93,253)]), ((2,248,133),
  &[(0,94,40)]), ((2,248,134), &[(0,94,61)]), ((2,248,135), &[(0,94,105)]),
  ((2,248,136), &[(0,56,98)]), ((2,248,137), &[(2,33,131)]), ((2,248,138),
  &[(0,56,124)]), ((2,248,139), &[(0,94,176)]), ((2,248,140), &[(0,94,179)]),
  ((2,248,141), &[(0,94,182)]), ((2,248,142), &[(0,94,202)]), ((2,248,143),
  &[(2,163,146)]), ((2,248,144), &[(0,94,254)]), ((2,248,145), &[(2,35,49)]),
  ((2,248,146), &[(2,35,49)]), ((2,248,147), &[(0,130,1)]), ((2,248,148),
  &[(0,95,34)]), ((2,248,149), &[(0,95,34)]), ((2,248,150), &[(0,56,199)]),
  ((2,248,151), &[(2,50,184)]), ((2,248,152), &[(2,97,218)]), ((2,248,153),
  &[(0,95,98)]), ((2,248,154), &[(0,95,107)]), ((2,248,155), &[(0,56,227)]),
  ((2,248,156), &[(0,95,154)]), ((2,248,157), &[(0,95,205)]), ((2,248,158),
  &[(0,95,215)]), ((2,248,159), &[(0,95,249)]), ((2,248,160), &[(0,96,129)]),
  ((2,248,161), &[(0,57,58)]), ((2,248,162), &[(0,57,28)]), ((2,248,163),
  &[(0,96,148)]), ((2,248,164), &[(2,38,212)]), ((2,248,165), &[(0,96,199)]),
  ((2,248,166), &[(0,97,72)]), ((2,248,167), &[(0,97,76)]), ((2,248,168),
  &[(0,97,78)]), ((2,248,169), &[(0,97,76)]), ((2,248,170), &[(0,97,122)]),
  ((2,248,171), &[(0,97,142)]), ((2,248,172), &[(0,97,178)]), ((2,248,173),
  &[(0,97,164)]), ((2,248,174), &[(0,97,175)]), ((2,248,175), &[(0,97,222)]),
  ((2,248,176), &[(0,97,242)]), ((2,248,177), &[(0,97,246)]), ((2,248,178),
  &[(0,98,16)]), ((2,248,179), &[(0,98,27)]), ((2,248,180), &[(0,98,93)]),
  ((2,248,181), &[(0,98,177)]), ((2,248,182), &[(0,98,212)]), ((2,248,183),
  &[(0,99,80)]), ((2,248,184), &[(2,43,12)]), ((2,248,185), &[(0,99,61)]),
  ((2,248,186), &[(0,98,252)]), ((2,248,187), &[(0,99,104)]), ((2,248,188),
  &[(0,99,131)]), ((2,248,189), &[(0,99,228)]), ((2,248,190), &[(2,43,241)]),
  ((2,248,191), &[(0,100,34)]), ((2,248,192), &[(0,99,197)]), ((2,248,193),
  &[(0,99,169)]), ((2,248,194), &[(0,58,46)]), ((2,248,195), &[(0,100,105)]),
  ((2,248,196), &[(0,100,126)]), ((2,248,197), &[(0,100,157)]), ((2,248,198),
  &[(0,100,119)]), ((2,248,199), &[(0,58,108)]), ((2,248,200), &[(0,101,79)]),
  ((2,248,201), &[(0,101,108)]), ((2,248,202), &[(2,48,10)]), ((2,248,203),
  &[(0,101,227)]), ((2,248,204), &[(0,102,248)]), ((2,248,205), &[(0,102,73)]),
  ((2,248,206), &[(0,59,25)]), ((2,248,207), &[(0,102,145)]), ((2,248,208),
  &[(0,59,8)]), ((2,248,209), &[(0,58,228)]), ((2,248,210), &[(0,81,146)]),
  ((2,248,211), &[(0,81,149)]), ((2,248,212), &[(0,103,0)]), ((2,248,213),
  &[(0,102,156)]), ((2,248,214), &[(0,128,173)]), ((2,248,215), &[(0,67,217)]),
  ((2,248,216), &[(0,103,23)]), ((2,248,217), &[(0,103,27)]), ((2,248,218),
  &[(0,103,33)]), ((2,248,219), &[(0,103,94)]), ((2,248,220), &[(0,103,83)]),
  ((2,248,221), &[(2,51,195)]), ((2,248,222), &[(0,59,73)]), ((2,248,223),
  &[(0,103,250)]), ((2,248,224), &[(0,103,133)]), ((2,248,225), &[(0,104,82)]),
  ((2,248,226), &[(0,104,133)]), ((2,248,227), &[(2,52,109)]), ((2,248,228),
  &[(0,104,142)]), ((2,248,229), &[(0,104,31)]), ((2,248,230), &[(0,105,20)]),
  ((2,248,231), &[(0,59,157)]), ((2,248,232), &[(0,105,66)]), ((2,248,233),
  &[(0,105,163)]), ((2,248,234), &[(0,105,234)]), ((2,248,235), &[(0,106,168)]),
  ((2,248,236), &[(2,54,163)]), ((2,248,237), &[(0,106,219)]), ((2,248,238),
  &[(0,60,24)]), ((2,248,239), &[(0,107,33)]), ((2,248,240), &[(2,56,167)]),
  ((2,248,241), &[(0,107,84)]), ((2,248,242), &[(0,60,78)]), ((2,248,243),
  &[(0,107,114)]), ((2,248,244), &[(0,107,159)]), ((2,248,245), &[(0,107,186)]),
  ((2,248,246), &[(0,107,187)]), ((2,248,247), &[(2,58,141)]), ((2,248,248),
  &[(2,29,11)]), ((2,248,249), &[(2,58,250)]), ((2,248,250), &[(0,108,78)]),
  ((2,248,251), &[(2,60,188)]), ((2,248,252), &[(0,108,191)]), ((2,248,253),
  &[(0,108,205)]), ((2,248,254), &[(0,108,103)]), ((2,248,255), &[(0,109,22)]),
  ((2,249,0), &[(0,109,62)]), ((2,249,1), &[(0,109,119)]), ((2,249,2),
  &[(0,109,65)]), ((2,249,3), &[(0,109,105)]), ((2,249,4), &[(0,109,120)]),
  ((2,249,5), &[(0,109,133)]), ((2,249,6), &[(2,61,30)]), ((2,249,7),
  &[(0,109,52)]), ((2,249,8), &[(0,110,47)]), ((2,249,9), &[(0,110,110)]),
  ((2,249,10), &[(0,61,51)]), ((2,249,11), &[(0,110,203)]), ((2,249,12),
  &[(0,110,199)]), ((2,249,13), &[(2,62,209)]), ((2,249,14), &[(0,109,249)]),
  ((2,249,15), &[(0,111,110)]), ((2,249,16), &[(2,63,94)]), ((2,249,17),
  &[(2,63,142)]), ((2,249,18), &[(0,111,198)]), ((2,249,19), &[(0,112,57)]),
  ((2,249,20), &[(0,112,30)]), ((2,249,21), &[(0,112,27)]), ((2,249,22),
  &[(0,61,150)]), ((2,249,23), &[(0,112,74)]), ((2,249,24), &[(0,112,125)]),
  ((2,249,25), &[(0,112,119)]), ((2,249,26), &[(0,112,173)]), ((2,249,27),
  &[(2,5,37)]), ((2,249,28), &[(0,113,69)]), ((2,249,29), &[(2,66,99)]),
  ((2,249,30), &[(0,113,156)]), ((2,249,31), &[(2,67,171)]), ((2,249,32),
  &[(0,114,40)]), ((2,249,33), &[(0,114,53)]), ((2,249,34), &[(0,114,80)]),
  ((2,249,35), &[(2,70,8)]), ((2,249,36), &[(0,114,128)]), ((2,249,37),
  &[(0,114,149)]), ((2,249,38), &[(2,71,53)]), ((2,249,39), &[(2,72,20)]),
  ((2,249,40), &[(0,115,122)]), ((2,249,41), &[(0,115,139)]), ((2,249,42),
  &[(0,62,172)]), ((2,249,43), &[(0,115,165)]), ((2,249,44), &[(0,62,184)]),
  ((2,249,45), &[(0,62,184)]), ((2,249,46), &[(0,116,71)]), ((2,249,47),
  &[(0,116,92)]), ((2,249,48), &[(0,116,113)]), ((2,249,49), &[(0,116,133)]),
  ((2,249,50), &[(0,116,202)]), ((2,249,51), &[(0,63,27)]), ((2,249,52),
  &[(0,117,36)]), ((2,249,53), &[(2,76,54)]), ((2,249,54), &[(0,117,62)]),
  ((2,249,55), &[(2,76,146)]), ((2,249,56), &[(0,117,112)]), ((2,249,57),
  &[(2,33,159)]), ((2,249,58), &[(0,118,16)]), ((2,249,59), &[(2,79,161)]),
  ((2,249,60), &[(2,79,184)]), ((2,249,61), &[(2,80,68)]), ((2,249,62),
  &[(0,63,252)]), ((2,249,63), &[(0,64,8)]), ((2,249,64), &[(0,118,244)]),
  ((2,249,65), &[(2,80,243)]), ((2,249,66), &[(2,80,242)]), ((2,249,67),
  &[(2,81,25)]), ((2,249,68), &[(2,81,51)]), ((2,249,69), &[(0,119,30)]),
  ((2,249,70), &[(0,119,31)]), ((2,249,71), &[(0,119,31)]), ((2,249,72),
  &[(0,119,74)]), ((2,249,73), &[(0,64,57)]), ((2,249,74), &[(0,119,139)]),
  ((2,249,75), &[(0,64,70)]), ((2,249,76), &[(0,64,150)]), ((2,249,77),
  &[(2,84,29)]), ((2,249,78), &[(0,120,78)]), ((2,249,79), &[(0,120,140)]),
  ((2,249,80), &[(0,120,204)]), ((2,249,81), &[(0,64,227)]), ((2,249,82),
  &[(2,86,38)]), ((2,249,83), &[(0,121,86)]), ((2,249,84), &[(2,86,154)]),
  ((2,249,85), &[(2,86,197)]), ((2,249,86), &[(0,121,143)]), ((2,249,87),
  &[(0,121,235)]), ((2,249,88), &[(0,65,47)]), ((2,249,89), &[(0,122,64)]),
  ((2,249,90), &[(0,122,74)]), ((2,249,91), &[(0,122,79)]), ((2,249,92),
  &[(2,89,124)]), ((2,249,93), &[(2,90,167)]), ((2,249,94), &[(2,90,167)]),
  ((2,249,95), &[(0,122,238)]), ((2,249,96), &[(0,66,2)]), ((2,249,97),
  &[(2,91,171)]), ((2,249,98), &[(0,123,198)]), ((2,249,99), &[(0,123,201)]),
  ((2,249,100), &[(0,66,39)]), ((2,249,101), &[(2,92,128)]), ((2,249,102),
  &[(0,124,210)]), ((2,249,103), &[(0,66,160)]), ((2,249,104), &[(0,124,232)]),
  ((2,249,105), &[(0,124,227)]), ((2,249,106), &[(0,125,0)]), ((2,249,107),
  &[(2,95,134)]), ((2,249,108), &[(0,125,99)]), ((2,249,109), &[(0,67,1)]),
  ((2,249,110), &[(0,125,199)]), ((2,249,111), &[(0,126,2)]), ((2,249,112),
  &[(0,126,69)]), ((2,249,113), &[(0,67,52)]), ((2,249,114), &[(2,98,40)]),
  ((2,249,115), &[(2,98,71)]), ((2,249,116), &[(0,67,89)]), ((2,249,117),
  &[(2,98,217)]), ((2,249,118), &[(0,127,122)]), ((2,249,119), &[(2,99,62)]),
  ((2,249,120), &[(0,127,149)]), ((2,249,121), &[(0,127,250)]), ((2,249,122),
  &[(0,128,5)]), ((2,249,123), &[(2,100,218)]), ((2,249,124), &[(2,101,35)]),
  ((2,249,125), &[(0,128,96)]), ((2,249,126), &[(2,101,168)]), ((2,249,127),
  &[(0,128,112)]), ((2,249,128), &[(2,51,95)]), ((2,249,129), &[(0,67,213)]),
  ((2,249,130), &[(0,128,178)]), ((2,249,131), &[(0,129,3)]), ((2,249,132),
  &[(0,68,11)]), ((2,249,133), &[(0,129,62)]), ((2,249,134), &[(0,90,181)]),
  ((2,249,135), &[(2,103,167)]), ((2,249,136), &[(2,103,181)]), ((2,249,137),
  &[(2,51,147)]), ((2,249,138), &[(2,51,156)]), ((2,249,139), &[(0,130,1)]),
  ((2,249,140), &[(0,130,4)]), ((2,249,141), &[(0,143,158)]), ((2,249,142),
  &[(0,68,107)]), ((2,249,143), &[(0,130,145)]), ((2,249,144), &[(0,130,139)]),
  ((2,249,145), &[(0,130,157)]), ((2,249,146), &[(0,82,179)]), ((2,249,147),
  &[(0,130,177)]), ((2,249,148), &[(0,130,179)]), ((2,249,149), &[(0,130,189)]),
  ((2,249,150), &[(0,130,230)]), ((2,249,151), &[(2,107,60)]), ((2,249,152),
  &[(0,130,229)]), ((2,249,153), &[(0,131,29)]), ((2,249,154), &[(0,131,99)]),
  ((2,249,155), &[(0,131,173)]), ((2,249,156), &[(0,131,35)]), ((2,249,157),
  &[(0,131,189)]), ((2,249,158), &[(0,131,231)]), ((2,249,159), &[(0,132,87)]),
  ((2,249,160), &[(0,131,83)]), ((2,249,161), &[(0,131,202)]), ((2,249,162),
  &[(0,131,204)]), ((2,249,163), &[(0,131,220)]), ((2,249,164), &[(2,108,54)]),
  ((2,249,165), &[(2,109,107)]), ((2,249,166), &[(2,108,213)]), ((2,249,167),
  &[(0,69,43)]), ((2,249,168), &[(0,132,241)]), ((2,249,169), &[(0,132,243)]),
  ((2,249,170), &[(0,133,22)]), ((2,249,171), &[(2,115,202)]), ((2,249,172),
  &[(0,133,100)]), ((2,249,173), &[(2,111,44)]), ((2,249,174), &[(0,69,93)]),
  ((2,249,175), &[(0,69,97)]), ((2,249,176), &[(2,111,177)]), ((2,249,177),
  &[(2,112,210)]), ((2,249,178), &[(0,69,107)]), ((2,249,179), &[(0,134,80)]),
  ((2,249,180), &[(0,134,92)]), ((2,249,181), &[(0,134,103)]), ((2,249,182),
  &[(0,134,105)]), ((2,249,183), &[(0,134,169)]), ((2,249,184), &[(0,134,136)]),
  ((2,249,185), &[(0,135,14)]), ((2,249,186), &[(0,134,226)]), ((2,249,187),
  &[(0,135,121)]), ((2,249,188), &[(0,135,40)]), ((2,249,189), &[(0,135,107)]),
  ((2,249,190), &[(0,135,134)]), ((2,249,191), &[(0,69,215)]), ((2,249,192),
  &[(0,135,225)]), ((2,249,193), &[(0,136,1)]), ((2,249,194), &[(0,69,249)]),
  ((2,249,195), &[(0,136,96)]), ((2,249,196), &[(0,136,99)]), ((2,249,197),
  &[(2,118,103)]), ((2,249,198), &[(0,136,215)]), ((2,249,199), &[(0,136,222)]),
  ((2,249,200), &[(0,70,53)]), ((2,249,201), &[(0,136,250)]), ((2,249,202),
  &[(0,52,187)]), ((2,249,203), &[(2,120,174)]), ((2,249,204), &[(2,121,102)]),
  ((2,249,205), &[(0,70,190)]), ((2,249,206), &[(0,70,199)]), ((2,249,207),
  &[(0,138,160)]), ((2,249,208), &[(0,138,237)]), ((2,249,209), &[(0,139,138)]),
  ((2,249,210), &[(0,140,85)]), ((2,249,211), &[(2,124,168)]), ((2,249,212),
  &[(0,140,171)]), ((2,249,213), &[(0,140,193)]), ((2,249,214), &[(0,141,27)]),
  ((2,249,215), &[(0,141,119)]), ((2,249,216), &[(2,127,47)]), ((2,249,217),
  &[(2,8,4)]), ((2,249,218), &[(0,141,203)]), ((2,249,219), &[(0,141,188)]),
  ((2,249,220), &[(0,141,240)]), ((2,249,221), &[(2,8,222)]), ((2,249,222),
  &[(0,142,212)]), ((2,249,223), &[(0,143,56)]), ((2,249,224), &[(2,133,210)]),
  ((2,249,225), &[(2,133,237)]), ((2,249,226), &[(0,144,148)]), ((2,249,227),
  &[(0,144,241)]), ((2,249,228), &[(0,145,17)]), ((2,249,229), &[(2,135,46)]),
  ((2,249,230), &[(0,145,27)]), ((2,249,231), &[(0,146,56)]), ((2,249,232),
  &[(0,146,215)]), ((2,249,233), &[(0,146,216)]), ((2,249,234), &[(0,146,124)]),
  ((2,249,235), &[(0,147,249)]), ((2,249,236), &[(0,148,21)]), ((2,249,237),
  &[(2,139,250)]), ((2,249,238), &[(0,149,139)]), ((2,249,239), &[(0,73,149)]),
  ((2,249,240), &[(0,149,183)]), ((2,249,241), &[(2,141,119)]), ((2,249,242),
  &[(0,73,230)]), ((2,249,243), &[(0,150,195)]), ((2,249,244), &[(0,93,178)]),
  ((2,249,245), &[(0,151,35)]), ((2,249,246), &[(2,145,69)]), ((2,249,247),
  &[(2,146,26)]), ((2,249,248), &[(0,74,110)]), ((2,249,249), &[(0,74,118)]),
  ((2,249,250), &[(0,151,224)]), ((2,249,251), &[(2,148,10)]), ((2,249,252),
  &[(0,74,178)]), ((2,249,253), &[(2,148,150)]), ((2,249,254), &[(0,152,11)]),
  ((2,249,255), &[(0,152,11)]), ((2,250,0), &[(0,152,41)]), ((2,250,1),
  &[(2,149,182)]), ((2,250,2), &[(0,152,226)]), ((2,250,3), &[(0,75,51)]),
  ((2,250,4), &[(0,153,41)]), ((2,250,5), &[(0,153,167)]), ((2,250,6),
  &[(0,153,194)]), ((2,250,7), &[(0,153,254)]), ((2,250,8), &[(0,75,206)]),
  ((2,250,9), &[(2,155,48)]), ((2,250,10), &[(0,155,18)]), ((2,250,11),
  &[(0,156,64)]), ((2,250,12), &[(0,156,253)]), ((2,250,13), &[(0,76,206)]),
  ((2,250,14), &[(0,76,237)]), ((2,250,15), &[(0,157,103)]), ((2,250,16),
  &[(2,160,206)]), ((2,250,17), &[(0,76,248)]), ((2,250,18), &[(2,161,5)]),
  ((2,250,19), &[(2,162,14)]), ((2,250,20), &[(2,162,145)]), ((2,250,21),
  &[(0,158,187)]), ((2,250,22), &[(0,77,86)]), ((2,250,23), &[(0,158,249)]),
  ((2,250,24), &[(0,158,254)]), ((2,250,25), &[(0,159,5)]), ((2,250,26),
  &[(0,159,15)]), ((2,250,27), &[(0,159,22)]), ((2,250,28), &[(0,159,59)]),
  ((2,250,29), &[(2,166,0)])
];

