# 2024-12-03 Triage Log

Busy week with more PRs impacting performance than is typical. Luckily performance improvements outweighed regressions in real world benchmarks with the largest single performance gain coming from a change to no longer unconditionally do LLVM IR verification in debug builds which was just wasted work.

Triage done by **@rylev**.
Revision range: [7db7489f..490b2cc0](https://perf.rust-lang.org/?start=7db7489f9bc274cb60c4956bfa56de0185eb1b9b&end=490b2cc09860dd62a7595bb07364d71c12ce4e60&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.9%]   | 58    |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [0.2%, 5.1%]   | 85    |
| Improvements ✅ <br /> (primary)   | -2.3% | [-8.2%, -0.2%] | 116   |
| Improvements ✅ <br /> (secondary) | -2.5% | [-8.9%, -0.1%] | 55    |
| All ❌✅ (primary)                 | -1.4% | [-8.2%, 1.9%]  | 174   |


6 Regressions, 6 Improvements, 5 Mixed; 5 of them in rollups
49 artifact comparisons made in total

#### Regressions

Rollup of 5 pull requests [#133551](https://github.com/rust-lang/rust/pull/133551) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=66adeaf46b7a646daeed29518ef76235fcdb9726&end=eddb717281a9031f645d88dd3b8323a7e25632cc&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 1.6%] | 20    |
| Regressions ❌ <br /> (secondary)  | 2.4% | [0.3%, 4.8%] | 22    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 1.6%] | 20    |
- Issue cased by https://github.com/rust-lang/rust/pull/133518


Rollup of 12 pull requests [#133561](https://github.com/rust-lang/rust/pull/133561) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=eddb717281a9031f645d88dd3b8323a7e25632cc&end=f005c7437def424a1c43cbc380352a58d8ac920b&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.1%, 0.3%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.2%, 0.9%] | 10    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.1%, 0.3%] | 3     |
- The regressions in the primary benchmarks reverted back to their previous mean after a few PRs so I don't think this is necessarily worth looking further into.


Remove `HybridBitSet` [#133431](https://github.com/rust-lang/rust/pull/133431) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cb2bd2bb06380896368b0edb02ada0117cc856be&end=5bbbc0938cfeb3dbd348d5258ddb6025bc8398c7&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.1%, 0.2%] | 6     |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.1%, 0.3%] | 9     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.1%, 0.2%] | 6     |
- Post merge perf results are a bit different from the pre-merge run, but they look similar enough that this doesn't require more investigation. 


Rollup of 6 pull requests [#133659](https://github.com/rust-lang/rust/pull/133659) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e93e096cc88728337fb41ff74431ebe71a1b4663&end=f981b2e27a7505468fac637ee67faef81b57fec0&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.3%, 0.4%] | 2     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.3%, 0.3%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.3%, 0.4%] | 2     |
- Perf regressions are small enough that I don't think this requires investigation especially considering that one of the primary regressions returned to its previous state a bit later on.


Make `compare_impl_item` into a query [#133365](https://github.com/rust-lang/rust/pull/133365) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7442931d49b199ad0a1cc0f8ca54e327b5139b66&end=4af7fa79a0e829c0edcc93434a8c788be8ec58c6&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.5%] | 27    |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.3%, 1.3%] | 7     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.5%] | 27    |
- Perf regressions were excused [here](https://github.com/rust-lang/rust/pull/133365#issuecomment-2495766076)


fast-reject: add depth check [#133566](https://github.com/rust-lang/rust/pull/133566) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=caa81728c37f5ccfa9a0979574b9272a67f8a286&end=bd36e69d2533ee750e2d805915b8ca88d2825e0f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.4%, 0.7%] | 13    |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.4%, 0.7%] | 13    |
- "Only a small regression, multiple strategies were tried here and in other PRs to get to this result — and it's a necessary hit."


#### Improvements

Recover some lost performence from #132732 [#133509](https://github.com/rust-lang/rust/pull/133509) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6b6a867ae9eac4e78d041ac4ee84be1072a48cf7&end=66adeaf46b7a646daeed29518ef76235fcdb9726&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.7% | [-4.2%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.7% | [-4.2%, -0.2%] | 8     |


Respect verify-llvm-ir option in the backend [#133499](https://github.com/rust-lang/rust/pull/133499) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4af7fa79a0e829c0edcc93434a8c788be8ec58c6&end=8ac313bdbede661669d7a7b4504b0f74d4ed9222&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.3% | [-8.1%, -0.2%] | 89    |
| Improvements ✅ <br /> (secondary) | -2.9% | [-9.8%, -0.3%] | 41    |
| All ❌✅ (primary)                 | -2.3% | [-8.1%, -0.2%] | 89    |


Stop cloning `Context` so much [#133345](https://github.com/rust-lang/rust/pull/133345) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5e1440ae514d98ddfcbf1607acb64d41e07ef616&end=a522d78598415cdd614ccc6d961160f192f64b5c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.3%, -0.1%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-0.8%, -0.8%] | 1     |
| All ❌✅ (primary)                 | -0.5% | [-1.3%, -0.1%] | 5     |


check local cache even if global is usable [#133626](https://github.com/rust-lang/rust/pull/133626) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3bff51ea912d4dfd9caa1e3bc6f68352618208a7&end=32eea2f4460b06b12acc98050a4211b8c0ccfd67&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.5% | [-3.1%, -1.8%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 2     |
| All ❌✅ (primary)                 | -2.5% | [-3.1%, -1.8%] | 2     |


Get rid of HIR const checker [#133321](https://github.com/rust-lang/rust/pull/133321) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=41cbe3e4d1ef8de310fbbd77043082960def9446&end=efdd9e802053caeb52103945df858e87f837e59a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 12    |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.4%, -0.1%] | 28    |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.1%] | 12    |


switch `jemalloc-sys` back to `tikv-jemalloc-sys`, and update to 0.6.0 [#133792](https://github.com/rust-lang/rust/pull/133792) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8575f8f91bbd7dca529d362afc8117db74661c3b&end=490b2cc09860dd62a7595bb07364d71c12ce4e60&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.3%, -0.1%] | 30    |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.2%, -0.1%] | 8     |
| All ❌✅ (primary)                 | -0.1% | [-0.3%, -0.1%] | 30    |


#### Mixed

Rollup of 12 pull requests [#133505](https://github.com/rust-lang/rust/pull/133505) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=dff3e7ccd4a18958c938136c4ccdc853fcc86194&end=dd2837ec5de4301a692e05a7c4475e980af57a57&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.7%, 0.7%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.1%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-1.9%, -0.1%] | 19    |
| All ❌✅ (primary)                 | 0.0%  | [-0.2%, 0.7%]  | 4     |
- The negative results are small enough (and reverted to their previous mean in a later PR) that this isn't worth investigating.


Do not unify dereferences of shared borrows in GVN [#133474](https://github.com/rust-lang/rust/pull/133474) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c322cd5c5ac13b5ef16a487c889f8c148d8e3841&end=6b6a867ae9eac4e78d041ac4ee84be1072a48cf7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.6%]   | 14    |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.4%]   | 10    |
| Improvements ✅ <br /> (primary)   | -1.7% | [-6.7%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.1%] | 6     |
| All ❌✅ (primary)                 | -0.5% | [-6.7%, 0.6%]  | 23    |
- "This fixes a miscompilation due to an unsound MIR optimization which is disabled in this PR."


always create `DefId`s for anon consts [#133468](https://github.com/rust-lang/rust/pull/133468) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9b4d7c6a40b328d212095c28670c629facf1557d&end=7e565cce6a03340edb4b9f56228cf5e480e24806&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 4.2%  | [4.2%, 4.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.0%, -0.3%] | 9     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.3%] | 1     |
- "The coercions regression was noise and was fixed in the next merge"


Enable -Zshare-generics for inline(never) functions [#123244](https://github.com/rust-lang/rust/pull/123244) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a2545fd6fc66b4323f555223a860c451885d1d2b&end=d53f0b1d8e261f2f3535f1cd165c714fc0b0b298&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.1%, 5.5%]   | 58    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.1%, 1.6%]   | 84    |
| Improvements ✅ <br /> (primary)   | -0.7% | [-3.8%, -0.1%] | 44    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-8.0%, -0.2%] | 25    |
| All ❌✅ (primary)                 | -0.0% | [-3.8%, 5.5%]  | 102   |
- "Regressions remain pretty similar to what we saw before (primarily in incremental it looks like?), and bootstrap times reflect the expectation that this significantly helps with larger crate graphs where there's more opportunity for reuse. Binary size win is also pretty nice." (more context [here](https://github.com/rust-lang/rust/pull/123244#issuecomment-2156720584))


Rollup of 8 pull requests [#133694](https://github.com/rust-lang/rust/pull/133694) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8ac313bdbede661669d7a7b4504b0f74d4ed9222&end=6c76ed5503966c39381fac64eb905ac45e346695&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 0.7%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 0.7%]   | 19    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.1%, 0.7%]   | 6     |
- Most of the regressions are in doc-full scenarios, and I don't see anything that is obviously a culprit.

