# 2023-03-07 Triage Log

A really quiet week with almost all regressions being due to noise in benchmarks that show "bimodality" in codegen that can cause swings in performance from one change to the other. The only true performance change was a two-line change by @nnethercote to remove a redundant function call which led to a 0.3% improvement in performance across roughly 15 benchmarks.

Triage done by **@rylev**.
Revision range: [31f858d9..8f9e09ac](https://perf.rust-lang.org/?start=31f858d9a511f24fedb8ed997b28304fec809630&end=8f9e09ac3ef3fa85d23ad6a0c920d49987144b13&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [1.2%, 2.8%]   | 8     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.7%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.8%, -0.1%] | 31    |
| All ❌✅ (primary)                 | -0.4% | [-0.7%, -0.2%] | 7     |


7 Regressions, 8 Improvements, 2 Mixed; 7 of them in rollups
35 artifact comparisons made in total

#### Regressions

Rollup of 5 pull requests [#108640](https://github.com/rust-lang/rust/pull/108640) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=18caf88956ecf454e24307e598b8ac9967f10b07&end=7e966bcd03f6d0fae41f58cf80bcb10566ab971a&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 3.2% | [2.1%, 4.4%] | 8     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |
- @nnethercote expects that `deep-vector` may have become susceptible to bimodal codegen which can cause swings in perf performance. 


Revert stabilization of `#![feature(target_feature_11)]` [#108654](https://github.com/rust-lang/rust/pull/108654) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7e966bcd03f6d0fae41f58cf80bcb10566ab971a&end=13471d3b2046cce78181dde6cfc146c09f55e29e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.6%, 0.7%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.3%, 0.5%] | 4     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.6%, 0.7%] | 3     |
- Noise: small regressions are immediately reversed in the next run.


Add vectored positioned I/O on Unix [#89518](https://github.com/rust-lang/rust/pull/89518) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=70adb4e5b4c8f8bde4ade0edcb0435ff7bf31281&end=0fbfc3e76916521b509b63286296dd0762170d34&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.3%] | 4     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.3%] | 4     |
- Small regression in Diesel which has started to show some bimodality. I think it's safe to call this triaged.


Remove `NormalizationError::ConstantKind` [#108689](https://github.com/rust-lang/rust/pull/108689) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0fbfc3e76916521b509b63286296dd0762170d34&end=01b7a6a9eac151f82831c402f91894552f5ca36d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [1.0%, 1.1%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 2.3%  | [2.1%, 2.7%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.6%, -0.6%] | 1     |
| All ❌✅ (primary)                 | 1.1%  | [1.0%, 1.1%]   | 2     |
- more `keccak` and `cranelift-codegen` noise. 


Bump version to 1.70.0 [#108740](https://github.com/rust-lang/rust/pull/108740) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b1719530f44e3c8ec903f76020a52bd8764d5d10&end=f15f0ea73972786e426732c5b92ba9a904b866c4&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.3%, 0.4%] | 6     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.3%, 0.4%] | 6     |
- Perhaps due to shuffled hashes? In any case, not much that can be done.


Add more debug assertions to unsafe functions [#105117](https://github.com/rust-lang/rust/pull/105117) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=73c8d2df7b36387553442a815d2b72f7ea5878aa&end=7820b62d20bc548096d4632a3487987308cb4b5d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0% | [0.9%, 1.1%] | 2     |
| Regressions ❌ <br /> (secondary)  | 2.3% | [2.0%, 2.7%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.0% | [0.9%, 1.1%] | 2     |
- more `cranelift-codegen` noise. 


Rollup of 7 pull requests [#108789](https://github.com/rust-lang/rust/pull/108789) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=816f958ac3db8931855c42649809aead01d20d9b&end=8c0f83d773370150a6ea1b40b36b55566e40a73c&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1% | [1.0%, 1.1%] | 2     |
| Regressions ❌ <br /> (secondary)  | 2.3% | [2.1%, 2.7%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.1% | [1.0%, 1.1%] | 2     |
- more `keccak` and `cranelift-codegen` noise. 


#### Improvements

Remove or document uses of #[rustc_box] in library [#108476](https://github.com/rust-lang/rust/pull/108476) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bcb610da7fae8297689883782601ecb8645604e2&end=64165aac68af780182ff89a6eb3982e3c262266e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.7%, -0.5%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 3     |
| All ❌✅ (primary)                 | -0.6% | [-0.7%, -0.5%] | 4     |
- Revert of noise


Rollup of 8 pull requests [#108677](https://github.com/rust-lang/rust/pull/108677) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=13471d3b2046cce78181dde6cfc146c09f55e29e&end=7a809ce8997a1697b166b4bb2594993e87d69f31&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.7%, -0.6%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 4     |
| All ❌✅ (primary)                 | -0.6% | [-0.7%, -0.6%] | 3     |
- Revert of noise


Rollup of 8 pull requests [#108709](https://github.com/rust-lang/rust/pull/108709) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=44cfafe2fafe816395d3acc434663a45d5178c41&end=70adb4e5b4c8f8bde4ade0edcb0435ff7bf31281&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.1%, -0.9%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.3% | [-2.6%, -2.0%] | 6     |
| All ❌✅ (primary)                 | -1.0% | [-1.1%, -0.9%] | 2     |
- Revert of noise


Rollup of 6 pull requests [#108732](https://github.com/rust-lang/rust/pull/108732) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=01b7a6a9eac151f82831c402f91894552f5ca36d&end=276b75a843af8822ffe4e395266d9445679a57a4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.3%] | 6     |
- Revert of noise


Don't call `temporary_scope` twice. [#108692](https://github.com/rust-lang/rust/pull/108692) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=276b75a843af8822ffe4e395266d9445679a57a4&end=b1719530f44e3c8ec903f76020a52bd8764d5d10&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.6%, -0.2%] | 15    |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.5%, -0.4%] | 27    |
| All ❌✅ (primary)                 | -0.3% | [-0.6%, -0.2%] | 15    |


Desugaring of drop and replace at MIR build [#107844](https://github.com/rust-lang/rust/pull/107844) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=35636f9459720513ca4ed19373a4a7c9e0ea3c46&end=14c54b637b18f74680d0c0441216714b5e9c150d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.1%, -1.0%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.0% | [-2.6%, -0.3%] | 7     |
| All ❌✅ (primary)                 | -1.0% | [-1.1%, -1.0%] | 2     |


Use `partial_cmp` to implement tuple `lt`/`le`/`ge`/`gt` [#108157](https://github.com/rust-lang/rust/pull/108157) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7820b62d20bc548096d4632a3487987308cb4b5d&end=816f958ac3db8931855c42649809aead01d20d9b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.2% | [-1.6%, -0.6%] | 3     |
| Improvements ✅ <br /> (secondary) | -2.2% | [-2.6%, -2.0%] | 6     |
| All ❌✅ (primary)                 | -1.2% | [-1.6%, -0.6%] | 3     |


Erase regions even when failing to normalize type in MIR opts [#108787](https://github.com/rust-lang/rust/pull/108787) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c0f83d773370150a6ea1b40b36b55566e40a73c&end=ac4379fea9e83465d814bb05005689f49bd2141e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.1%, -1.0%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.2% | [-2.6%, -2.0%] | 6     |
| All ❌✅ (primary)                 | -1.0% | [-1.1%, -1.0%] | 2     |


#### Mixed

Rollup of 10 pull requests [#108587](https://github.com/rust-lang/rust/pull/108587) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5983a3a99ea631da9d7d1ce510a6761913f92a89&end=bcb610da7fae8297689883782601ecb8645604e2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.7%, 0.8%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.6%]   | 4     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-0.8%, -0.8%] | 1     |
| All ❌✅ (primary)                 | 0.7%  | [0.7%, 0.8%]   | 4     |
- Noise that is counter balanced by [#108476](https://github.com/rust-lang/rust/pull/108476).


Rollup of 7 pull requests [#108707](https://github.com/rust-lang/rust/pull/108707) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7a809ce8997a1697b166b4bb2594993e87d69f31&end=44cfafe2fafe816395d3acc434663a45d5178c41&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.6%, 0.7%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 1.5%  | [1.3%, 1.7%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.3%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.0%, -0.5%] | 9     |
| All ❌✅ (primary)                 | 0.1%  | [-0.4%, 0.7%]  | 5     |
- Regressions are just noise in the historically noisy benchmarks
