# 2022-09-14 Triage Log

From the viewpoint of metrics gathering, this was an absolutely terrible week,
because the vast majority of this week's report is dominated by noise. Several
benchmarks (html5ever, cranelift-codegen, and keccak) have all been exhibiting
bimodal behavior where their compile-times would regress and improve randomly
from run to run. Looking past that, we had one small win from adding an inline
directive.

Triage done by **@pnkfelix**.
Revision range: [e7cdd4c0..17cbdfd0](https://perf.rust-lang.org/?start=e7cdd4c0909b62f2ee0368fd10e6e244f2af44b4&end=17cbdfd07178349d0a3cecb8e7dde8f915666ced&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.1% | [0.2%, 6.2%] | 26    |
| Regressions ❌ <br /> (secondary) | 1.9% | [0.1%, 5.6%] | 34    |
| Improvements ✅ <br /> (primary) | -1.8% | [-29.4%, -0.2%] | 42    |
| Improvements ✅ <br /> (secondary) | -1.3% | [-5.3%, -0.2%] | 50    |
| All ❌✅ (primary) | -0.7% | [-29.4%, 6.2%] | 68    |


11 Regressions, 11 Improvements, 13 Mixed; 11 of them in rollups
71 artifact comparisons made in total

#### Regressions

Simplify `hir::PathSegment` [#101228](https://github.com/rust-lang/rust/pull/101228) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6e4a9ab650b135ae0ff761e4a37d96c8bcaf7b3d&end=2dc703fd6e3aaaf343828cc7dd1aec192d24c628&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.7% | [0.3%, 1.3%] | 16    |
| Regressions ❌ <br /> (secondary) | 1.3% | [0.9%, 1.8%] | 14    |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.7% | [0.3%, 1.3%] | 16    |

* [already triaged](https://github.com/rust-lang/rust/pull/101228#issuecomment-1238065150) as "these regressions aren't real; they are an artifact of some current bimodality"

Rollup of 7 pull requests [#101485](https://github.com/rust-lang/rust/pull/101485) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=380addd7d2971447d7f6828c508a93fa8018a9b6&end=78a891d364a7358ed9eb9c93099ba2f3e6817ca6&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.9% | [0.3%, 1.6%] | 15    |
| Regressions ❌ <br /> (secondary) | 1.2% | [0.8%, 1.6%] | 9     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.9% | [0.3%, 1.6%] | 15    |

* [already triaged](https://github.com/rust-lang/rust/pull/101485#issuecomment-1238769318)  as "these regressions aren't real; they are an artifact of some current bimodality"

Track PGO profiles in depinfo [#100801](https://github.com/rust-lang/rust/pull/100801) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c41305631f96bae3e456d7942f00e0d437c350e&end=ff479b1f3c77e8312843e7de212253632f4c1a8a&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 2.0% | [1.8%, 2.4%] | 6     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | -    | -     | 0     |

* [already triaged](https://github.com/rust-lang/rust/pull/100801#issuecomment-1239043740) as "these regressions aren't real; they are an artifact of some current bimodality"

Make `HandleCycleError` an enum instead of a macro-generated closure [#101303](https://github.com/rust-lang/rust/pull/101303) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=512bd84f51ba6963c84506f408840e5341abe499&end=4af35b8e3017cb080630942d1c2b7045c74e450a&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.2% | [1.1%, 1.3%] | 2     |
| Regressions ❌ <br /> (secondary) | 3.4% | [3.1%, 3.9%] | 6     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 1.2% | [1.1%, 1.3%] | 2     |

* [already triaged](https://github.com/rust-lang/rust/pull/101303#issuecomment-1240524838) as "these regressions aren't real; they are an artifact of some current bimodality"

Shrink `hir::Ty` and `hir::Pat` [#101467](https://github.com/rust-lang/rust/pull/101467) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ccb5595df2ed412eda6444edc7eaf06f709fa79d&end=24d69920201563f0ee7b530f1cda0f171b205cc2&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.8% | [0.8%, 1.0%] | 6     |
| Regressions ❌ <br /> (secondary) | 7.5% | [7.5%, 7.5%] | 1     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.8% | [0.8%, 1.0%] | 6     |

* [already triaged](https://github.com/rust-lang/rust/pull/101467#issuecomment-1241210848) as noise (all regressions are noise in html5ever).

Normalize before erasing late-bound regions in `equal_up_to_regions` [#101437](https://github.com/rust-lang/rust/pull/101437) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=87788097b776f8e3662f76627944230684b671bd&end=1120c5e01df508de64fe6642f22fadeb574afd6d&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.2% | [1.1%, 1.3%] | 2     |
| Regressions ❌ <br /> (secondary) | 3.4% | [3.0%, 3.9%] | 6     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 1.2% | [1.1%, 1.3%] | 2     |

* [already triaged](https://github.com/rust-lang/rust/pull/101437#issuecomment-1244842297) as noise; cranelift-codegen and keccak have been noisy lately.

Rollup of 6 pull requests [#101639](https://github.com/rust-lang/rust/pull/101639) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cedd26b1ea066fe243b82b0f78e37066c6f4d789&end=db9d86b58dff2a19d84d5e557641dfbb4cbb3a8d&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.3% | [1.2%, 1.4%] | 2     |
| Regressions ❌ <br /> (secondary) | 3.1% | [0.8%, 4.0%] | 8     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 1.3% | [1.2%, 1.4%] | 2     |

* [already triaged](https://github.com/rust-lang/rust/pull/101639#issuecomment-1242799249) as noise from bimodality.

Only compute captures once when building MIR. [#100968](https://github.com/rust-lang/rust/pull/100968) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5197c96c49fc3b7de3ce9a31f7cc62d2cbd1f70c&end=2e44c17c12cec45b6a682b1e53a04ac5b5fcc9d2&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.2% | [1.1%, 1.3%] | 2     |
| Regressions ❌ <br /> (secondary) | 3.4% | [3.1%, 3.9%] | 6     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 1.2% | [1.1%, 1.3%] | 2     |

* [already triaged](https://github.com/rust-lang/rust/pull/100968#issuecomment-1243200319) as noise.

Fix LLVM IR type mismatch reported in #99551 [#101647](https://github.com/rust-lang/rust/pull/101647) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=14636887008d9ee67a12b4f05f1e404ed1d64579&end=4a6ac3c225d6322caaf0ef86623cddc74e5260c6&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.3% | [1.3%, 1.3%] | 1     |
| Regressions ❌ <br /> (secondary) | 3.4% | [3.1%, 3.9%] | 6     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 1.3% | [1.3%, 1.3%] | 1     |

* [already triaged](https://github.com/rust-lang/rust/pull/101647#issuecomment-1243202926) as noise from cranelift-codegen and keccak.

Simplify codeblock and their associated tooltip [#101613](https://github.com/rust-lang/rust/pull/101613) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2287107588d92889d282e6cd3c1ca5df34cd34a5&end=781ef3e99582fee003264087b0eea106a8c7518f&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.3% | [1.3%, 1.3%] | 1     |
| Regressions ❌ <br /> (secondary) | 3.4% | [3.1%, 3.9%] | 6     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 1.3% | [1.3%, 1.3%] | 1     |

* [already triaged](https://github.com/rust-lang/rust/pull/101613#issuecomment-1242919852) as noise.

Compute information about function parameters on THIR [#101086](https://github.com/rust-lang/rust/pull/101086) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1ce51982b8550c782ded466c1abff0d2b2e21c4e&end=c84083b08e2db69fcf270c4045837fa02663a3bf&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.4% | [0.2%, 0.5%] | 10    |
| Regressions ❌ <br /> (secondary) | 0.6% | [0.3%, 1.6%] | 4     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | 0.4% | [0.2%, 0.5%] | 10    |

* between 0.38% and 0.47% regression for stm32f4 in various incremental scenarios. Approximately 0.25% on serde,clap,image for incremental.
* it seems plausible that this is just overhead that we have to pay, in terms of adding more state to the THIR, in exchange for simpler MIR construction code.
* (its also possible that this is just noise, though the listed benchmarks are not the same as the other ones that have been exhibiting bimodality this last week.)
* [marking as triaged.](https://github.com/rust-lang/rust/pull/101086#issuecomment-1246191513)

#### Improvements

Inline `<T as From<T>>::from` [#100733](https://github.com/rust-lang/rust/pull/100733) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3c7278846102bb829c9a789e91bc43f0ed612943&end=380addd7d2971447d7f6828c508a93fa8018a9b6&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.8% | [-2.2%, -0.2%] | 25    |
| Improvements ✅ <br /> (secondary) | -1.4% | [-2.2%, -0.5%] | 22    |
| All ❌✅ (primary) | -0.8% | [-2.2%, -0.2%] | 25    |


Rollup of 8 pull requests [#101508](https://github.com/rust-lang/rust/pull/101508) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=699bfa882b34a73b333e684e96984c1c565d2eff&end=8c41305631f96bae3e456d7942f00e0d437c350e&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -1.2% | [-1.3%, -1.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -3.3% | [-3.8%, -2.9%] | 6     |
| All ❌✅ (primary) | -1.2% | [-1.3%, -1.1%] | 2     |

* (bimodality in other direction, cranelift-codegen and keccak)

Lower the assume intrinsic to a MIR statement [#98332](https://github.com/rust-lang/rust/pull/98332) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0568b0a3de4eb37bf187eb61a9f017ae0018ad8f&end=e7c7aa7288559f8e5ea7ce3543ff946b09783628&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.8% | [-0.9%, -0.7%] | 6     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | -0.8% | [-0.9%, -0.7%] | 6     |

* presume bimodality in other direction for html5ever

Update miri submodule [#101522](https://github.com/rust-lang/rust/pull/101522) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a4d034126da8ff42590325622b1861c2597e870b&end=f91ca2878af792bc6969b97d78fe91b27739ac2d&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.8% | [-0.9%, -0.7%] | 6     |
| Improvements ✅ <br /> (secondary) | -    | -     | 0     |
| All ❌✅ (primary) | -0.8% | [-0.9%, -0.7%] | 6     |

* presume bimodality in other direction for html5ever

Rollup of 14 pull requests [#101544](https://github.com/rust-lang/rust/pull/101544) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9682b5d3a34b3167d7f2f2d0cf6ddc485cd51b4b&end=c2804e6ec2c29a5c7368600ea173b890e2655c3d&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -1.2% | [-1.3%, -1.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -3.3% | [-3.8%, -3.0%] | 6     |
| All ❌✅ (primary) | -1.2% | [-1.3%, -1.1%] | 2     |

* (bimodality in other direction, cranelift-codegen and keccak)

const_generics: correctly deal with bound variables [#98900](https://github.com/rust-lang/rust/pull/98900) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b42244c2ab462a5ac4c901e8988f9fcb78776d9c&end=ccb5595df2ed412eda6444edc7eaf06f709fa79d&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.9% | [-1.3%, -0.8%] | 8     |
| Improvements ✅ <br /> (secondary) | -3.3% | [-3.8%, -2.9%] | 6     |
| All ❌✅ (primary) | -0.9% | [-1.3%, -0.8%] | 8     |

* (bimodality in other direction, html5ever, cranelift-codegen, and keccak)

Rollup of 7 pull requests [#101577](https://github.com/rust-lang/rust/pull/101577) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=24d69920201563f0ee7b530f1cda0f171b205cc2&end=87788097b776f8e3662f76627944230684b671bd&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -1.1% | [-1.1%, -1.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -7.5% | [-7.5%, -7.5%] | 1     |
| All ❌✅ (primary) | -1.1% | [-1.1%, -1.1%] | 1     |


Rollup of 6 pull requests [#101603](https://github.com/rust-lang/rust/pull/101603) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ab32548539ec38a939c1b58599249f3b54130026&end=4a09adf99fff9b009ff517b9cf5bfce363130e16&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -1.3% | [-1.4%, -1.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -3.3% | [-3.8%, -2.8%] | 7     |
| All ❌✅ (primary) | -1.3% | [-1.4%, -1.2%] | 2     |

* (bimodality in other direction, cranelift-codegen, keccak, and coercions)


Rollup of 6 pull requests [#101652](https://github.com/rust-lang/rust/pull/101652) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2e44c17c12cec45b6a682b1e53a04ac5b5fcc9d2&end=14636887008d9ee67a12b4f05f1e404ed1d64579&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.4% | [-1.3%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -2.6% | [-3.8%, -0.4%] | 8     |
| All ❌✅ (primary) | -0.4% | [-1.3%, -0.2%] | 7     |

* largely cranelift-codegen, keccak

Remove ReEmpty [#98559](https://github.com/rust-lang/rust/pull/98559) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4a6ac3c225d6322caaf0ef86623cddc74e5260c6&end=2287107588d92889d282e6cd3c1ca5df34cd34a5&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.7% | [-1.3%, -0.3%] | 5     |
| Improvements ✅ <br /> (secondary) | -3.3% | [-3.8%, -3.0%] | 6     |
| All ❌✅ (primary) | -0.7% | [-1.3%, -0.3%] | 5     |

* largely cranelift-codegen, keccak

Make `compare_predicate_entailment` no longer a query [#101615](https://github.com/rust-lang/rust/pull/101615) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5338f5f1d4ad9c99706e5cb691f8d5bbac341262&end=1ce51982b8550c782ded466c1abff0d2b2e21c4e&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.4% | [-0.5%, -0.4%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 5     |
| All ❌✅ (primary) | -0.4% | [-0.5%, -0.4%] | 6     |


#### Mixed

Make `const_eval_select` a real intrinsic [#100759](https://github.com/rust-lang/rust/pull/100759) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e7cdd4c0909b62f2ee0368fd10e6e244f2af44b4&end=9358d09a55307e47bde0276e2390c603c35d5fb6&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.8% | [0.3%, 1.4%] | 12    |
| Regressions ❌ <br /> (secondary) | 2.4% | [0.2%, 4.1%] | 9     |
| Improvements ✅ <br /> (primary) | -1.2% | [-3.0%, -0.6%] | 7     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.6%, -1.0%] | 10    |
| All ❌✅ (primary) | 0.1% | [-3.0%, 1.4%] | 19    |

* If you take html5ever, cranelift-codegen, keccak out of the mix here, ...
* ... you are left with the following four primary regressions: ripgrep by 1.37%, clap by 1.34%, cargo by 0.80%, serde_derive by 0.33%.
* The regression to ripgrep does look like it might be legitimate, at least from skimming its [graph](https://perf.rust-lang.org/index.html?start=2022-08-06&end=c84083b08e2db69fcf270c4045837fa02663a3bf&benchmark=ripgrep-13.0.0&profile=opt&scenario=full&stat=instructions:u) and zooming in.

proc_macro/bridge: use the cross-thread executor for nested proc-macros [#101414](https://github.com/rust-lang/rust/pull/101414) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=406e03fd02faf5cc8409a8b6b04c26990d6227e6&end=5b4bd154de6e41d4739914f446349f8201ec3ef9&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.9% | [0.4%, 1.4%] | 10    |
| Regressions ❌ <br /> (secondary) | 1.1% | [0.6%, 1.7%] | 9     |
| Improvements ✅ <br /> (primary) | -1.2% | [-1.3%, -1.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -3.4% | [-3.9%, -3.0%] | 6     |
| All ❌✅ (primary) | 0.5% | [-1.3%, 1.4%] | 12    |


* As noted elsewhere https://github.com/rust-lang/rust/pull/101461#issuecomment-1238192638 ...
* ... the regressions flagged here are almost certainly noise from recently arising bimodality in certain benchmarks.
* marked as triaged


Rollup of 6 pull requests [#101439](https://github.com/rust-lang/rust/pull/101439) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5b4bd154de6e41d4739914f446349f8201ec3ef9&end=6e4a9ab650b135ae0ff761e4a37d96c8bcaf7b3d&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.9% | [0.9%, 1.0%] | 2     |
| Regressions ❌ <br /> (secondary) | 2.1% | [1.8%, 2.4%] | 6     |
| Improvements ✅ <br /> (primary) | -2.9% | [-29.7%, -0.3%] | 18    |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.8%, -0.7%] | 9     |
| All ❌✅ (primary) | -2.5% | [-29.7%, 1.0%] | 20    |

* the regressions flagged here are almost certainly noise from recently arising bimodality in certain benchmarks.
* [already marked as triaged](https://github.com/rust-lang/rust/pull/101439#issuecomment-1238725357)

Rollup of 7 pull requests [#101464](https://github.com/rust-lang/rust/pull/101464) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=676afc514944aa618977bacf8fe28cefc443a13a&end=56b27110e7f72ea01312d99f1b1e0577431cbbd0&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 1.6% | [1.6%, 1.6%] | 1     |
| Improvements ✅ <br /> (primary) | -0.8% | [-1.3%, -0.3%] | 13    |
| Improvements ✅ <br /> (secondary) | -1.3% | [-1.7%, -0.8%] | 8     |
| All ❌✅ (primary) | -0.8% | [-1.3%, -0.3%] | 13    |

* [already marked as triaged](https://github.com/rust-lang/rust/pull/101464#issuecomment-1238064407) due to ongoing bimodality noise issue.

Rollup of 5 pull requests [#101479](https://github.com/rust-lang/rust/pull/101479) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a594044533b5e309eab7ac6b71f4ba8a909af653&end=3c7278846102bb829c9a789e91bc43f0ed612943&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.9% | [0.4%, 1.3%] | 10    |
| Regressions ❌ <br /> (secondary) | 1.3% | [0.8%, 1.8%] | 8     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.6%, -1.2%] | 6     |
| All ❌✅ (primary) | 0.9% | [0.4%, 1.3%] | 10    |

* [already marked as triaged](https://github.com/rust-lang/rust/pull/101479#issuecomment-1238517669) due to ongoing bimodality noise issue.

change stdlib circular dependencies handling [#100404](https://github.com/rust-lang/rust/pull/100404) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=78a891d364a7358ed9eb9c93099ba2f3e6817ca6&end=699bfa882b34a73b333e684e96984c1c565d2eff&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 1.2% | [1.1%, 1.3%] | 2     |
| Regressions ❌ <br /> (secondary) | 3.4% | [3.0%, 3.9%] | 6     |
| Improvements ✅ <br /> (primary) | -0.8% | [-0.9%, -0.7%] | 6     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.0%, -1.0%] | 1     |
| All ❌✅ (primary) | -0.3% | [-0.9%, 1.3%] | 8     |

* [marked as triaged](https://github.com/rust-lang/rust/pull/100404#issuecomment-1246204266) due to ongoing bimodality noise issue.

Add test for #98294 [#101232](https://github.com/rust-lang/rust/pull/101232) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ff479b1f3c77e8312843e7de212253632f4c1a8a&end=0568b0a3de4eb37bf187eb61a9f017ae0018ad8f&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.8% | [0.7%, 0.9%] | 6     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -    | -     | 0     |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.1%, -1.1%] | 1     |
| All ❌✅ (primary) | 0.8% | [0.7%, 0.9%] | 6     |

* [already marked as triaged](https://github.com/rust-lang/rust/pull/101232#issuecomment-1239332094) due to ongoing bimodality noise issue.

Shrink `PredicateS` [#101432](https://github.com/rust-lang/rust/pull/101432) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e7c7aa7288559f8e5ea7ce3543ff946b09783628&end=a4d034126da8ff42590325622b1861c2597e870b&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.8% | [0.7%, 0.9%] | 6     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -0.4% | [-0.5%, -0.4%] | 5     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.4%, -1.4%] | 1     |
| All ❌✅ (primary) | 0.2% | [-0.5%, 0.9%] | 11    |

* [already marked as triaged](https://github.com/rust-lang/rust/pull/101432#issuecomment-1239987405) due to ongoing bimodality noise issue.

Use niche-filling optimization even when multiple variants have data. [#94075](https://github.com/rust-lang/rust/pull/94075) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c2804e6ec2c29a5c7368600ea173b890e2655c3d&end=512bd84f51ba6963c84506f408840e5341abe499&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 3.2% | [0.8%, 9.4%] | 5     |
| Regressions ❌ <br /> (secondary) | 1.8% | [0.2%, 5.2%] | 27    |
| Improvements ✅ <br /> (primary) | -0.6% | [-1.1%, -0.2%] | 23    |
| Improvements ✅ <br /> (secondary) | -1.5% | [-2.9%, -0.2%] | 16    |
| All ❌✅ (primary) | 0.1% | [-1.1%, 9.4%] | 28    |

The syn regression sounds bad. Left a [comment](https://github.com/rust-lang/rust/pull/94075#issuecomment-1246210283).


Rollup of 7 pull requests [#101592](https://github.com/rust-lang/rust/pull/101592) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1120c5e01df508de64fe6642f22fadeb574afd6d&end=c6861df8368a35ef3814e0c379754bb4c7013401&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 4.6% | [4.6%, 4.6%] | 1     |
| Improvements ✅ <br /> (primary) | -1.2% | [-1.3%, -1.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -3.3% | [-3.8%, -2.9%] | 6     |
| All ❌✅ (primary) | -1.2% | [-1.3%, -1.1%] | 2     |

* [Already triaged](https://github.com/rust-lang/rust/pull/101592#issuecomment-1243205092) saying "The coercions regression is only for a single profile/scenario combination, so I don't think it's meaningful."

Initial implementation of return-position `impl Trait` in traits [#101224](https://github.com/rust-lang/rust/pull/101224) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7200da0217f99e929e58d0b40483097db37270ac&end=ab32548539ec38a939c1b58599249f3b54130026&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.5% | [0.2%, 1.4%] | 19    |
| Regressions ❌ <br /> (secondary) | 2.0% | [0.2%, 4.1%] | 13    |
| Improvements ✅ <br /> (primary) | -0.9% | [-1.1%, -0.8%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary) | 0.2% | [-1.1%, 1.4%] | 25    |

* Many of regressions fall in the bimodal noise category.
* The serde regression did not, but it is addressed by the follow-up PR [#101615](https://github.com/rust-lang/rust/pull/101615)
* Marking as triaged.

Update LLVM used in x86 CI dist builds to `15.0.0` [#101527](https://github.com/rust-lang/rust/pull/101527) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4a09adf99fff9b009ff517b9cf5bfce363130e16&end=98f3001eecbe4cbd091c10ffab45b4c164bb507b&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | -    | -     | 0     |
| Regressions ❌ <br /> (secondary) | 1.3% | [1.3%, 1.3%] | 1     |
| Improvements ✅ <br /> (primary) | -0.6% | [-0.8%, -0.5%] | 12    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.3%] | 4     |
| All ❌✅ (primary) | -0.6% | [-0.8%, -0.5%] | 12    |

* [Already triaged](https://github.com/rust-lang/rust/pull/101527#issuecomment-1242422341)

The `<*const T>::guaranteed_*` methods now return an option for the unknown case [#101483](https://github.com/rust-lang/rust/pull/101483) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=db9d86b58dff2a19d84d5e557641dfbb4cbb3a8d&end=5197c96c49fc3b7de3ce9a31f7cc62d2cbd1f70c&stat=instructions:u)

| (instructions:u) | mean | range | count |
|:----------------:|:----:|:-----:|:-----:|
| Regressions ❌ <br /> (primary) | 0.4% | [0.2%, 0.6%] | 5     |
| Regressions ❌ <br /> (secondary) | -    | -     | 0     |
| Improvements ✅ <br /> (primary) | -1.1% | [-1.4%, -0.9%] | 5     |
| Improvements ✅ <br /> (secondary) | -2.9% | [-3.8%, -0.7%] | 8     |
| All ❌✅ (primary) | -0.4% | [-1.4%, 0.6%] | 10    |

* The big improvements are just noise from some bimodal behavior we've been observing this week.
* Its possible that there was some regression to cargo here, but I don't think the data shows it to be large enough to be worth investigating. (I admit, my attitude there might be colored by my frustration with the huge noise impact of the aforementioned bimodality on all of the perf results from the last week.)
* [marked as triaged](https://github.com/rust-lang/rust/pull/101483#issuecomment-1246216066)

#### Untriaged Pull Requests

- [#101483 The `<*const T>::guaranteed_*` methods now return an option for the unknown case](https://github.com/rust-lang/rust/pull/101483)
- [#101414 proc_macro/bridge: use the cross-thread executor for nested proc-macros](https://github.com/rust-lang/rust/pull/101414)
- [#101224 Initial implementation of return-position `impl Trait` in traits](https://github.com/rust-lang/rust/pull/101224)
- [#101086 Compute information about function parameters on THIR](https://github.com/rust-lang/rust/pull/101086)
- [#100963 Rollup of 15 pull requests](https://github.com/rust-lang/rust/pull/100963)
- [#100869 Replace `rustc_data_structures::thin_vec::ThinVec` with `thin_vec::ThinVec`](https://github.com/rust-lang/rust/pull/100869)
- [#100841 update Miri](https://github.com/rust-lang/rust/pull/100841)
- [#100759 Make `const_eval_select` a real intrinsic](https://github.com/rust-lang/rust/pull/100759)
- [#100748 add `depth_limit` in `QueryVTable` to avoid entering a new tcx in `layout_of`](https://github.com/rust-lang/rust/pull/100748)
- [#100676 implied bounds: explicitly state which types are assumed to be wf](https://github.com/rust-lang/rust/pull/100676)
- [#100652 Remove deferred sized checks (make them eager)](https://github.com/rust-lang/rust/pull/100652)
- [#100497 Avoid cloning a collection only to iterate over it](https://github.com/rust-lang/rust/pull/100497)
- [#100429 rustdoc: Merge source code pages HTML elements together](https://github.com/rust-lang/rust/pull/100429)
- [#100404 change stdlib circular dependencies handling](https://github.com/rust-lang/rust/pull/100404)
- [#100293 Add inline-llvm option for disabling/enabling LLVM inlining](https://github.com/rust-lang/rust/pull/100293)
- [#99792 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/99792)
- [#99520 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/99520)
- [#99251 Upgrade indexmap and thorin-dwp to use hashbrown 0.12](https://github.com/rust-lang/rust/pull/99251)
- [#99231 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/99231)
- [#99210 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/99210)
- [#99126 remove allow(rustc::potential_query_instability) in rustc_span](https://github.com/rust-lang/rust/pull/99126)
- [#99123 proc_macro: use crossbeam channels for the proc_macro cross-thread bridge](https://github.com/rust-lang/rust/pull/99123)
- [#99102 Rework definition of MIR phases to more closely reflect semantic concerns](https://github.com/rust-lang/rust/pull/99102)
- [#99047 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/99047)
- [#99014 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/99014)
- [#98987 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/98987)
- [#98957  don't allow ZST in ScalarInt ](https://github.com/rust-lang/rust/pull/98957)
- [#98904 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/98904)
- [#98874 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/98874)
- [#98612 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/98612)
