# 2021-11-16 Triage Log

A large amount of noise in the comparisons this week, likely due to new
probabilistic query hash verification increasing likelihood of changes in each
benchmark; solutions are being tracked in [rustc-perf#1105].

Otherwise, though, the week largely amounted to a neutral one for performance.
There were some regressions, particularly in doc builds, as a result of the
addition of portable SIMD. These are relatively speaking minor and primarily
impact small crates.

[rustc-perf#1105]: https://github.com/rust-lang/rustc-perf/issues/1105

Triage done by **@simulacrum**.
Revision range: [eee8b9c7bafade55981d155dae71657f1cc55a22..934624fe5f66ce3fb8abf0597a6deb079783335f](https://perf.rust-lang.org/?start=eee8b9c7bafade55981d155dae71657f1cc55a22&end=934624fe5f66ce3fb8abf0597a6deb079783335f&absolute=false&stat=instructions%3Au)

5 Regressions, 2 Improvements, 6 Mixed; 2 of them in rollups

41 comparisons made in total

#### Regressions

pub use core::simd; [#89167](https://github.com/rust-lang/rust/issues/89167)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e90c5fbbc5df5c81267747daeb937d4e955ce6ad&end=032dfe43605f4324966933078ffe6f717b77c7c8&stat=instructions:u) (up to 11.8% on `full` builds of `helloworld`)
- Expected regression due to expansion of libcore size; this continues to be a
  pain point as we add features to the standard library. Largest regressions are
  in rustdoc builds as it's more sensitive to the addition of new traits and
  impls.

proc_macro: Add an expand_expr method to TokenStream [#87264](https://github.com/rust-lang/rust/issues/87264)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=7594067b69eac2395f7b3b42d519a559dae2d9d9&end=3e018ce194ab16125747220676dd8a20aecd5196&stat=instructions:u) (up to 5.3% on `incr-unchanged` builds of `inflate`)
- Incremental regressions are likely to be due to random hashing added for
  incr-comp verification (which we may decide to disable during perf collection
  to avoid this). Otherwise, the regression is minimal to TokenStream
  processing.

MIRI says `reverse` is UB, so replace it with something LLVM can vectorize [#90821](https://github.com/rust-lang/rust/issues/90821)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c26746af5a925bad66b7ed4f9e7c3018f00d4010&end=891ca5f63c3b3cfe3939710a728671243e881ed6&stat=instructions:u) (up to 0.8% on `full` builds of `deeply-nested`)
- Unclear cause to these regressions, but they seem to larely be in doc builds.

Rollup of 5 pull requests [#90769](https://github.com/rust-lang/rust/issues/90769)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=68ca579406f2fa9ec62710e4a4d5d3e07a168d3c&end=82af160c2cb9c349a0373cba98d8ad7f911f0d34&stat=instructions:u) (up to 84.9% on `full` builds of `webrender-wrench`)
- Also has a small improvement, but that is likely to be the incremental
  verification noise.

Added the --temps-dir option [#83846](https://github.com/rust-lang/rust/issues/83846)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=8e0293137f895a417fa043b9817c455150769406&end=9dbbbb12c0b796f35cbf5a518ac12846c969a214&stat=instructions:u) (up to 0.5% on `incr-unchanged` builds of `helloworld`)
- Unclear what the cause of this is; we would not generally expect a regression
  from such an introduction.

#### Improvements

Use Vec extend and collect instead of repeatedly calling push [#90813](https://github.com/rust-lang/rust/issues/90813)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e4c23daeb461ac02413eb36c8cefcc5530638a05&end=f31622a50b06e4e5775cf71d1dfe3e59ffc21aa5&stat=instructions:u) (up to -8.7% on `full` builds of `match-stress-enum`)
- Excellent improvement to a number of benchmarks. Mostly limited to somewhat
  unrealistic stress tests.

Address performance regression introduced by #90218 [#90845](https://github.com/rust-lang/rust/issues/90845)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=02063124f96aac10f8c5c70653242b0704d397e0&end=a2a7683e8f321e3c0b9d648ae480827b5ab70e1d&stat=instructions:u) (up to -5.1% on `full` builds of `regression-31157`)


#### Mixed

Replace Copy/Clone compiler magic on arrays with library impls [#86041](https://github.com/rust-lang/rust/issues/86041)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=07acdb48a0e0b22d08a45e3ced0378e0027b40eb&end=d6082292a6f3207cbdacd6633a5b9d1476bb6772&stat=instructions:u) (up to -1.2% on `incr-unchanged` builds of `deeply-nested`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=07acdb48a0e0b22d08a45e3ced0378e0027b40eb&end=d6082292a6f3207cbdacd6633a5b9d1476bb6772&stat=instructions:u) (up to 1.0% on `full` builds of `cranelift-codegen`)
- Limited regressions in codegen, mostly due to more complicated MIR for these
  impls when done in library code vs. directly generated.

Optimize pattern matching [#90746](https://github.com/rust-lang/rust/issues/90746)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3d29b6807740db74aeb9c2f626115e519dee4a62&end=936238a92b2f9d6e7afe7dda69b4afd903f96399&stat=instructions:u) (up to -5.3% on `full` builds of `match-stress-enum`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3d29b6807740db74aeb9c2f626115e519dee4a62&end=936238a92b2f9d6e7afe7dda69b4afd903f96399&stat=instructions:u) (up to 4.0% on `incr-unchanged` builds of `deep-vector`)

rustdoc: Go back to loading all external crates unconditionally [#90489](https://github.com/rust-lang/rust/issues/90489)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=936238a92b2f9d6e7afe7dda69b4afd903f96399&end=14a2fd640e0df9ee8cc1e04280b0c3aff93c42da&stat=instructions:u) (up to -3.9% on `incr-unchanged` builds of `deep-vector`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=936238a92b2f9d6e7afe7dda69b4afd903f96399&end=14a2fd640e0df9ee8cc1e04280b0c3aff93c42da&stat=instructions:u) (up to 2.8% on `full` builds of `cargo`)

Make RawVec private to alloc [#90542](https://github.com/rust-lang/rust/issues/90542)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3e018ce194ab16125747220676dd8a20aecd5196&end=1b12d01903293453dd94aa170c82caf94415629f&stat=instructions:u) (up to -5.1% on `incr-unchanged` builds of `inflate`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3e018ce194ab16125747220676dd8a20aecd5196&end=1b12d01903293453dd94aa170c82caf94415629f&stat=instructions:u) (up to 4.0% on `incr-unchanged` builds of `deep-vector`)

Optimize Eq and Hash for Path/PathBuf [#90596](https://github.com/rust-lang/rust/issues/90596)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3b2c45441d7eefed63f6658ff8becd5a51eaeae1&end=c8e94975a6541e947a1bd4971e084c8ba637f2b6&stat=instructions:u) (up to -6.0% on `incr-unchanged` builds of `coercions`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3b2c45441d7eefed63f6658ff8becd5a51eaeae1&end=c8e94975a6541e947a1bd4971e084c8ba637f2b6&stat=instructions:u) (up to 12.9% on `incr-unchanged` builds of `tuple-stress`)

Rollup of 8 pull requests [#90945](https://github.com/rust-lang/rust/issues/90945)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a2a7683e8f321e3c0b9d648ae480827b5ab70e1d&end=934624fe5f66ce3fb8abf0597a6deb079783335f&stat=instructions:u) (up to -0.4% on `full` builds of `deeply-nested-async`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a2a7683e8f321e3c0b9d648ae480827b5ab70e1d&end=934624fe5f66ce3fb8abf0597a6deb079783335f&stat=instructions:u) (up to 0.3% on `incr-patched: println` builds of `clap-rs`)

#### Untriaged Pull Requests

- [#90883 Rollup of 3 pull requests](https://github.com/rust-lang/rust/pull/90883)
- [#90839 Generate documentation in rustc `rustc_index::newtype_index` macro](https://github.com/rust-lang/rust/pull/90839)
- [#90821 MIRI says `reverse` is UB, so replace it with something LLVM can vectorize](https://github.com/rust-lang/rust/pull/90821)
- [#90769 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/90769)
- [#90746 Optimize pattern matching](https://github.com/rust-lang/rust/pull/90746)
- [#90695 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/90695)
- [#90684 Change paths for `dist` command to match the components they generate](https://github.com/rust-lang/rust/pull/90684)
- [#90645 Implement diagnostic for String conversion](https://github.com/rust-lang/rust/pull/90645)
- [#90559 Optimize bidi character detection.](https://github.com/rust-lang/rust/pull/90559)
- [#90542 Make RawVec private to alloc](https://github.com/rust-lang/rust/pull/90542)
- [#90489 rustdoc: Go back to loading all external crates unconditionally](https://github.com/rust-lang/rust/pull/90489)
- [#90485 Don't destructure args tuple in format_args!](https://github.com/rust-lang/rust/pull/90485)
- [#90462 [master] Fix CVE-2021-42574](https://github.com/rust-lang/rust/pull/90462)
- [#90443 Merge `DocContext.{ty,lt,ct}_substs` into one map](https://github.com/rust-lang/rust/pull/90443)
- [#90422 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/90422)
- [#90235 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/90235)
- [#90183 Show all Deref implementations recursively](https://github.com/rust-lang/rust/pull/90183)
- [#90067 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/90067)
- [#89939 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/89939)
- [#89858 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/89858)
- [#89695 Move top part of print_item to Tera templates](https://github.com/rust-lang/rust/pull/89695)
- [#89608 Rollup of 12 pull requests](https://github.com/rust-lang/rust/pull/89608)
- [#89551 Stabilize `const_raw_ptr_deref` for `*const T`](https://github.com/rust-lang/rust/pull/89551)
- [#89534 Introduce `tcx.get_diagnostic_name`](https://github.com/rust-lang/rust/pull/89534)
- [#89435 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/89435)
- [#89405 Fix clippy lints](https://github.com/rust-lang/rust/pull/89405)
- [#89263 Suggest both of immutable and mutable trait implementations](https://github.com/rust-lang/rust/pull/89263)
- [#89165 Fix read_to_end to not grow an exact size buffer](https://github.com/rust-lang/rust/pull/89165)
- [#89125 Don't use projection cache or candidate cache in intercrate mode](https://github.com/rust-lang/rust/pull/89125)
- [#89124 Index and hash HIR as part of lowering](https://github.com/rust-lang/rust/pull/89124)
