use super::{Command, Representation};
use clap::Args;
use objio::{ObjectWriter};
use rdftk_core::{error::Error};
use rdftk_io::{dot};
use std::process::ExitCode;

// ------------------------------------------------------------------------------------------------
// Public Macros
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Public Types
// ------------------------------------------------------------------------------------------------

#[derive(Args, Debug)]
pub(crate) struct DrawCmd {
    #[arg(short = 'f', long)]
    #[arg(value_enum)]
    from: Representation,

    /// Input SDML file name to read from, or '-' to read from stdin
    #[arg(short, long)]
    #[clap(value_parser, default_value = "-")]
    input: clio::Input,

    /// File name to write to, or '-' to write to stdout
    #[arg(short, long)]
    #[clap(value_parser, default_value = "-")]
    output: clio::Output,
}

// ------------------------------------------------------------------------------------------------
// Public Functions
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Private Macros
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Private Types
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Implementations
// ------------------------------------------------------------------------------------------------

impl Command for DrawCmd {
    fn execute(mut self) -> Result<ExitCode, Error> {
        if self.from.is_dataset_representation() {
            eprintln!("Currently unable to draw diagrams of datasets.");
            Ok(ExitCode::FAILURE)
        } else {
            let graph = super::read_graph(&mut self.input, self.from)?;
            let writer = dot::DotWriter::default();
            writer.write(&mut self.output, &graph)?;
            Ok(ExitCode::SUCCESS)
        }
    }
}

// ------------------------------------------------------------------------------------------------
// Private Functions
// ------------------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------------------
// Modules
// ------------------------------------------------------------------------------------------------
