// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"0xacab.org/leap/menshen/models"
)

// GetAPI5ServiceReader is a Reader for the GetAPI5Service structure.
type GetAPI5ServiceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAPI5ServiceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetApi5ServiceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetApi5ServiceBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetApi5ServiceNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetApi5ServiceInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /api/5/service] GetAPI5Service", response, response.Code())
	}
}

// NewGetApi5ServiceOK creates a GetApi5ServiceOK with default headers values
func NewGetApi5ServiceOK() *GetApi5ServiceOK {
	return &GetApi5ServiceOK{}
}

/*
GetApi5ServiceOK describes a response with status code 200, with default header values.

OK
*/
type GetApi5ServiceOK struct {
	Payload *models.ModelsEIPService
}

// IsSuccess returns true when this get api5 service o k response has a 2xx status code
func (o *GetApi5ServiceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get api5 service o k response has a 3xx status code
func (o *GetApi5ServiceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get api5 service o k response has a 4xx status code
func (o *GetApi5ServiceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get api5 service o k response has a 5xx status code
func (o *GetApi5ServiceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get api5 service o k response a status code equal to that given
func (o *GetApi5ServiceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get api5 service o k response
func (o *GetApi5ServiceOK) Code() int {
	return 200
}

func (o *GetApi5ServiceOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/service][%d] getApi5ServiceOK %s", 200, payload)
}

func (o *GetApi5ServiceOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/service][%d] getApi5ServiceOK %s", 200, payload)
}

func (o *GetApi5ServiceOK) GetPayload() *models.ModelsEIPService {
	return o.Payload
}

func (o *GetApi5ServiceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ModelsEIPService)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetApi5ServiceBadRequest creates a GetApi5ServiceBadRequest with default headers values
func NewGetApi5ServiceBadRequest() *GetApi5ServiceBadRequest {
	return &GetApi5ServiceBadRequest{}
}

/*
GetApi5ServiceBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetApi5ServiceBadRequest struct {
	Payload interface{}
}

// IsSuccess returns true when this get api5 service bad request response has a 2xx status code
func (o *GetApi5ServiceBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get api5 service bad request response has a 3xx status code
func (o *GetApi5ServiceBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get api5 service bad request response has a 4xx status code
func (o *GetApi5ServiceBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get api5 service bad request response has a 5xx status code
func (o *GetApi5ServiceBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get api5 service bad request response a status code equal to that given
func (o *GetApi5ServiceBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get api5 service bad request response
func (o *GetApi5ServiceBadRequest) Code() int {
	return 400
}

func (o *GetApi5ServiceBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/service][%d] getApi5ServiceBadRequest %s", 400, payload)
}

func (o *GetApi5ServiceBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/service][%d] getApi5ServiceBadRequest %s", 400, payload)
}

func (o *GetApi5ServiceBadRequest) GetPayload() interface{} {
	return o.Payload
}

func (o *GetApi5ServiceBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetApi5ServiceNotFound creates a GetApi5ServiceNotFound with default headers values
func NewGetApi5ServiceNotFound() *GetApi5ServiceNotFound {
	return &GetApi5ServiceNotFound{}
}

/*
GetApi5ServiceNotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetApi5ServiceNotFound struct {
	Payload interface{}
}

// IsSuccess returns true when this get api5 service not found response has a 2xx status code
func (o *GetApi5ServiceNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get api5 service not found response has a 3xx status code
func (o *GetApi5ServiceNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get api5 service not found response has a 4xx status code
func (o *GetApi5ServiceNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get api5 service not found response has a 5xx status code
func (o *GetApi5ServiceNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get api5 service not found response a status code equal to that given
func (o *GetApi5ServiceNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get api5 service not found response
func (o *GetApi5ServiceNotFound) Code() int {
	return 404
}

func (o *GetApi5ServiceNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/service][%d] getApi5ServiceNotFound %s", 404, payload)
}

func (o *GetApi5ServiceNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/service][%d] getApi5ServiceNotFound %s", 404, payload)
}

func (o *GetApi5ServiceNotFound) GetPayload() interface{} {
	return o.Payload
}

func (o *GetApi5ServiceNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetApi5ServiceInternalServerError creates a GetApi5ServiceInternalServerError with default headers values
func NewGetApi5ServiceInternalServerError() *GetApi5ServiceInternalServerError {
	return &GetApi5ServiceInternalServerError{}
}

/*
GetApi5ServiceInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetApi5ServiceInternalServerError struct {
	Payload interface{}
}

// IsSuccess returns true when this get api5 service internal server error response has a 2xx status code
func (o *GetApi5ServiceInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get api5 service internal server error response has a 3xx status code
func (o *GetApi5ServiceInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get api5 service internal server error response has a 4xx status code
func (o *GetApi5ServiceInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get api5 service internal server error response has a 5xx status code
func (o *GetApi5ServiceInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get api5 service internal server error response a status code equal to that given
func (o *GetApi5ServiceInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get api5 service internal server error response
func (o *GetApi5ServiceInternalServerError) Code() int {
	return 500
}

func (o *GetApi5ServiceInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/service][%d] getApi5ServiceInternalServerError %s", 500, payload)
}

func (o *GetApi5ServiceInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /api/5/service][%d] getApi5ServiceInternalServerError %s", 500, payload)
}

func (o *GetApi5ServiceInternalServerError) GetPayload() interface{} {
	return o.Payload
}

func (o *GetApi5ServiceInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
