# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.policyinsights.aio import PolicyInsightsClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPolicyInsightsAttestationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PolicyInsightsClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_list_for_subscription(self, resource_group):
        response = self.client.attestations.list_for_subscription(
            api_version="2024-10-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_begin_create_or_update_at_subscription(self, resource_group):
        response = await (
            await self.client.attestations.begin_create_or_update_at_subscription(
                attestation_name="str",
                parameters={
                    "policyAssignmentId": "str",
                    "assessmentDate": "2020-02-20 00:00:00",
                    "comments": "str",
                    "complianceState": "str",
                    "evidence": [{"description": "str", "sourceUri": "str"}],
                    "expiresOn": "2020-02-20 00:00:00",
                    "id": "str",
                    "lastComplianceStateChangeAt": "2020-02-20 00:00:00",
                    "metadata": {},
                    "name": "str",
                    "owner": "str",
                    "policyDefinitionReferenceId": "str",
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2024-10-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_get_at_subscription(self, resource_group):
        response = await self.client.attestations.get_at_subscription(
            attestation_name="str",
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_delete_at_subscription(self, resource_group):
        response = await self.client.attestations.delete_at_subscription(
            attestation_name="str",
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_list_for_resource_group(self, resource_group):
        response = self.client.attestations.list_for_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-10-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_begin_create_or_update_at_resource_group(self, resource_group):
        response = await (
            await self.client.attestations.begin_create_or_update_at_resource_group(
                resource_group_name=resource_group.name,
                attestation_name="str",
                parameters={
                    "policyAssignmentId": "str",
                    "assessmentDate": "2020-02-20 00:00:00",
                    "comments": "str",
                    "complianceState": "str",
                    "evidence": [{"description": "str", "sourceUri": "str"}],
                    "expiresOn": "2020-02-20 00:00:00",
                    "id": "str",
                    "lastComplianceStateChangeAt": "2020-02-20 00:00:00",
                    "metadata": {},
                    "name": "str",
                    "owner": "str",
                    "policyDefinitionReferenceId": "str",
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2024-10-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_get_at_resource_group(self, resource_group):
        response = await self.client.attestations.get_at_resource_group(
            resource_group_name=resource_group.name,
            attestation_name="str",
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_delete_at_resource_group(self, resource_group):
        response = await self.client.attestations.delete_at_resource_group(
            resource_group_name=resource_group.name,
            attestation_name="str",
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_list_for_resource(self, resource_group):
        response = self.client.attestations.list_for_resource(
            resource_id="str",
            api_version="2024-10-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_begin_create_or_update_at_resource(self, resource_group):
        response = await (
            await self.client.attestations.begin_create_or_update_at_resource(
                resource_id="str",
                attestation_name="str",
                parameters={
                    "policyAssignmentId": "str",
                    "assessmentDate": "2020-02-20 00:00:00",
                    "comments": "str",
                    "complianceState": "str",
                    "evidence": [{"description": "str", "sourceUri": "str"}],
                    "expiresOn": "2020-02-20 00:00:00",
                    "id": "str",
                    "lastComplianceStateChangeAt": "2020-02-20 00:00:00",
                    "metadata": {},
                    "name": "str",
                    "owner": "str",
                    "policyDefinitionReferenceId": "str",
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2024-10-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_get_at_resource(self, resource_group):
        response = await self.client.attestations.get_at_resource(
            resource_id="str",
            attestation_name="str",
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_attestations_delete_at_resource(self, resource_group):
        response = await self.client.attestations.delete_at_resource(
            resource_id="str",
            attestation_name="str",
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...
