/*
 * Copyright (c) 2005, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */

provider hotspot_jni {
  probe AllocObject__entry(void*, void*);
  probe AllocObject__return(void*);
  probe AttachCurrentThreadAsDaemon__entry(void*, void**, void*);
  probe AttachCurrentThreadAsDaemon__return(uint32_t);
  probe AttachCurrentThread__entry(void*, void**, void*);
  probe AttachCurrentThread__return(uint32_t);
  probe CallBooleanMethodA__entry(void*, void*, uintptr_t);
  probe CallBooleanMethodA__return(uintptr_t);
  probe CallBooleanMethod__entry(void*, void*, uintptr_t);
  probe CallBooleanMethod__return(uintptr_t);
  probe CallBooleanMethodV__entry(void*, void*, uintptr_t);
  probe CallBooleanMethodV__return(uintptr_t);
  probe CallByteMethodA__entry(void*, void*, uintptr_t);
  probe CallByteMethodA__return(char);
  probe CallByteMethod__entry(void*, void*, uintptr_t);
  probe CallByteMethod__return(char);
  probe CallByteMethodV__entry(void*, void*, uintptr_t);
  probe CallByteMethodV__return(char);
  probe CallCharMethodA__entry(void*, void*, uintptr_t);
  probe CallCharMethodA__return(uint16_t);
  probe CallCharMethod__entry(void*, void*, uintptr_t);
  probe CallCharMethod__return(uint16_t);
  probe CallCharMethodV__entry(void*, void*, uintptr_t);
  probe CallCharMethodV__return(uint16_t);
  probe CallDoubleMethodA__entry(void*, void*, uintptr_t);
  probe CallDoubleMethodA__return();
  probe CallDoubleMethod__entry(void*, void*, uintptr_t);
  probe CallDoubleMethod__return();
  probe CallDoubleMethodV__entry(void*, void*, uintptr_t);
  probe CallDoubleMethodV__return();
  probe CallFloatMethodA__entry(void*, void*, uintptr_t);
  probe CallFloatMethodA__return();
  probe CallFloatMethod__entry(void*, void*, uintptr_t);
  probe CallFloatMethod__return();
  probe CallFloatMethodV__entry(void*, void*, uintptr_t);
  probe CallFloatMethodV__return();
  probe CallIntMethodA__entry(void*, void*, uintptr_t);
  probe CallIntMethodA__return(uint32_t);
  probe CallIntMethod__entry(void*, void*, uintptr_t);
  probe CallIntMethod__return(uint32_t);
  probe CallIntMethodV__entry(void*, void*, uintptr_t);
  probe CallIntMethodV__return(uint32_t);
  probe CallLongMethodA__entry(void*, void*, uintptr_t);
  probe CallLongMethodA__return(uintptr_t);
  probe CallLongMethod__entry(void*, void*, uintptr_t);
  probe CallLongMethod__return(uintptr_t);
  probe CallLongMethodV__entry(void*, void*, uintptr_t);
  probe CallLongMethodV__return(uintptr_t);
  probe CallNonvirtualBooleanMethodA__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualBooleanMethodA__return(uintptr_t);
  probe CallNonvirtualBooleanMethod__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualBooleanMethod__return(uintptr_t);
  probe CallNonvirtualBooleanMethodV__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualBooleanMethodV__return(uintptr_t);
  probe CallNonvirtualByteMethodA__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualByteMethodA__return(char);
  probe CallNonvirtualByteMethod__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualByteMethod__return(char);
  probe CallNonvirtualByteMethodV__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualByteMethodV__return(char);
  probe CallNonvirtualCharMethodA__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualCharMethodA__return(uint16_t);
  probe CallNonvirtualCharMethod__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualCharMethod__return(uint16_t);
  probe CallNonvirtualCharMethodV__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualCharMethodV__return(uint16_t);
  probe CallNonvirtualDoubleMethodA__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualDoubleMethodA__return();
  probe CallNonvirtualDoubleMethod__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualDoubleMethod__return();
  probe CallNonvirtualDoubleMethodV__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualDoubleMethodV__return();
  probe CallNonvirtualFloatMethodA__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualFloatMethodA__return();
  probe CallNonvirtualFloatMethod__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualFloatMethod__return();
  probe CallNonvirtualFloatMethodV__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualFloatMethodV__return();
  probe CallNonvirtualIntMethodA__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualIntMethodA__return(uint32_t);
  probe CallNonvirtualIntMethod__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualIntMethod__return(uint32_t);
  probe CallNonvirtualIntMethodV__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualIntMethodV__return(uint32_t);
  probe CallNonvirtualLongMethodA__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualLongMethodA__return(uintptr_t);
  probe CallNonvirtualLongMethod__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualLongMethod__return(uintptr_t);
  probe CallNonvirtualLongMethodV__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualLongMethodV__return(uintptr_t);
  probe CallNonvirtualObjectMethodA__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualObjectMethodA__return(void*);
  probe CallNonvirtualObjectMethod__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualObjectMethod__return(void*);
  probe CallNonvirtualObjectMethodV__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualObjectMethodV__return(void*);
  probe CallNonvirtualShortMethodA__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualShortMethodA__return(uint16_t);
  probe CallNonvirtualShortMethod__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualShortMethod__return(uint16_t);
  probe CallNonvirtualShortMethodV__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualShortMethodV__return(uint16_t);
  probe CallNonvirtualVoidMethodA__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualVoidMethodA__return();
  probe CallNonvirtualVoidMethod__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualVoidMethod__return();
  probe CallNonvirtualVoidMethodV__entry(void*, void*, void*, uintptr_t);
  probe CallNonvirtualVoidMethodV__return();
  probe CallObjectMethodA__entry(void*, void*, uintptr_t);
  probe CallObjectMethodA__return(void*);
  probe CallObjectMethod__entry(void*, void*, uintptr_t);
  probe CallObjectMethod__return(void*);
  probe CallObjectMethodV__entry(void*, void*, uintptr_t);
  probe CallObjectMethodV__return(void*);
  probe CallShortMethodA__entry(void*, void*, uintptr_t);
  probe CallShortMethodA__return(uint16_t);
  probe CallShortMethod__entry(void*, void*, uintptr_t);
  probe CallShortMethod__return(uint16_t);
  probe CallShortMethodV__entry(void*, void*, uintptr_t);
  probe CallShortMethodV__return(uint16_t);
  probe CallStaticBooleanMethodA__entry(void*, void*, uintptr_t);
  probe CallStaticBooleanMethodA__return(uintptr_t);
  probe CallStaticBooleanMethod__entry(void*, void*, uintptr_t);
  probe CallStaticBooleanMethod__return(uintptr_t);
  probe CallStaticBooleanMethodV__entry(void*, void*, uintptr_t);
  probe CallStaticBooleanMethodV__return(uintptr_t);
  probe CallStaticByteMethodA__entry(void*, void*, uintptr_t);
  probe CallStaticByteMethodA__return(char);
  probe CallStaticByteMethod__entry(void*, void*, uintptr_t);
  probe CallStaticByteMethod__return(char);
  probe CallStaticByteMethodV__entry(void*, void*, uintptr_t);
  probe CallStaticByteMethodV__return(char);
  probe CallStaticCharMethodA__entry(void*, void*, uintptr_t);
  probe CallStaticCharMethodA__return(uint16_t);
  probe CallStaticCharMethod__entry(void*, void*, uintptr_t);
  probe CallStaticCharMethod__return(uint16_t);
  probe CallStaticCharMethodV__entry(void*, void*, uintptr_t);
  probe CallStaticCharMethodV__return(uint16_t);
  probe CallStaticDoubleMethodA__entry(void*, void*, uintptr_t);
  probe CallStaticDoubleMethodA__return();
  probe CallStaticDoubleMethod__entry(void*, void*, uintptr_t);
  probe CallStaticDoubleMethod__return();
  probe CallStaticDoubleMethodV__entry(void*, void*, uintptr_t);
  probe CallStaticDoubleMethodV__return();
  probe CallStaticFloatMethodA__entry(void*, void*, uintptr_t);
  probe CallStaticFloatMethodA__return();
  probe CallStaticFloatMethod__entry(void*, void*, uintptr_t);
  probe CallStaticFloatMethod__return();
  probe CallStaticFloatMethodV__entry(void*, void*, uintptr_t);
  probe CallStaticFloatMethodV__return();
  probe CallStaticIntMethodA__entry(void*, void*, uintptr_t);
  probe CallStaticIntMethodA__return(uint32_t);
  probe CallStaticIntMethod__entry(void*, void*, uintptr_t);
  probe CallStaticIntMethod__return(uint32_t);
  probe CallStaticIntMethodV__entry(void*, void*, uintptr_t);
  probe CallStaticIntMethodV__return(uint32_t);
  probe CallStaticLongMethodA__entry(void*, void*, uintptr_t);
  probe CallStaticLongMethodA__return(uintptr_t);
  probe CallStaticLongMethod__entry(void*, void*, uintptr_t);
  probe CallStaticLongMethod__return(uintptr_t);
  probe CallStaticLongMethodV__entry(void*, void*, uintptr_t);
  probe CallStaticLongMethodV__return(uintptr_t);
  probe CallStaticObjectMethodA__entry(void*, void*, uintptr_t);
  probe CallStaticObjectMethodA__return(void*);
  probe CallStaticObjectMethod__entry(void*, void*, uintptr_t);
  probe CallStaticObjectMethod__return(void*);
  probe CallStaticObjectMethodV__entry(void*, void*, uintptr_t);
  probe CallStaticObjectMethodV__return(void*);
  probe CallStaticShortMethodA__entry(void*, void*, uintptr_t);
  probe CallStaticShortMethodA__return(uint16_t);
  probe CallStaticShortMethod__entry(void*, void*, uintptr_t);
  probe CallStaticShortMethod__return(uint16_t);
  probe CallStaticShortMethodV__entry(void*, void*, uintptr_t);
  probe CallStaticShortMethodV__return(uint16_t);
  probe CallStaticVoidMethodA__entry(void*, void*, uintptr_t);
  probe CallStaticVoidMethodA__return();
  probe CallStaticVoidMethod__entry(void*, void*, uintptr_t);
  probe CallStaticVoidMethod__return();
  probe CallStaticVoidMethodV__entry(void*, void*, uintptr_t);
  probe CallStaticVoidMethodV__return();
  probe CallVoidMethodA__entry(void*, void*, uintptr_t);
  probe CallVoidMethodA__return();
  probe CallVoidMethod__entry(void*, void*, uintptr_t);
  probe CallVoidMethod__return();
  probe CallVoidMethodV__entry(void*, void*, uintptr_t);
  probe CallVoidMethodV__return();
  probe CreateJavaVM__entry(void**, void**, void*);
  probe CreateJavaVM__return(uint32_t);
  probe DefineClass__entry(void*, const char*, void*, char*, uintptr_t);
  probe DefineClass__return(void*);
  probe DeleteGlobalRef__entry(void*, void*);
  probe DeleteGlobalRef__return();
  probe DeleteLocalRef__entry(void*, void*);
  probe DeleteLocalRef__return();
  probe DeleteWeakGlobalRef__entry(void*, void*);
  probe DeleteWeakGlobalRef__return();
  probe DestroyJavaVM__entry(void*);
  probe DestroyJavaVM__return(uint32_t);
  probe DetachCurrentThread__entry(void*);
  probe DetachCurrentThread__return(uint32_t);
  probe EnsureLocalCapacity__entry(void*, uint32_t);
  probe EnsureLocalCapacity__return(uint32_t);
  probe ExceptionCheck__entry(void*);
  probe ExceptionCheck__return(uintptr_t);
  probe ExceptionClear__entry(void*);
  probe ExceptionClear__return();
  probe ExceptionDescribe__entry(void*);
  probe ExceptionDescribe__return();
  probe ExceptionOccurred__entry(void*);
  probe ExceptionOccurred__return(void*);
  probe FatalError__entry(void* env, const char*);
  probe FindClass__entry(void*, const char*);
  probe FindClass__return(void*);
  probe FromReflectedField__entry(void*, void*);
  probe FromReflectedField__return(uintptr_t);
  probe FromReflectedMethod__entry(void*, void*);
  probe FromReflectedMethod__return(uintptr_t);
  probe GetArrayLength__entry(void*, void*);
  probe GetArrayLength__return(uintptr_t);
  probe GetBooleanArrayElements__entry(void*, void*, uintptr_t*);
  probe GetBooleanArrayElements__return(uintptr_t*);
  probe GetBooleanArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, uintptr_t*);
  probe GetBooleanArrayRegion__return();
  probe GetBooleanField__entry(void*, void*, uintptr_t);
  probe GetBooleanField__return(uintptr_t);
  probe GetByteArrayElements__entry(void*, void*, uintptr_t*);
  probe GetByteArrayElements__return(char*);
  probe GetByteArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, char*);
  probe GetByteArrayRegion__return();
  probe GetByteField__entry(void*, void*, uintptr_t);
  probe GetByteField__return(char);
  probe GetCharArrayElements__entry(void*, void*, uintptr_t*);
  probe GetCharArrayElements__return(uint16_t*);
  probe GetCharArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, uint16_t*);
  probe GetCharArrayRegion__return();
  probe GetCharField__entry(void*, void*, uintptr_t);
  probe GetCharField__return(uint16_t);
  probe GetCreatedJavaVMs__entry(void**, uintptr_t, uintptr_t*);
  probe GetCreatedJavaVMs__return(uintptr_t);
  probe GetDefaultJavaVMInitArgs__entry(void*);
  probe GetDefaultJavaVMInitArgs__return(uint32_t);
  probe GetDirectBufferAddress__entry(void*, void*);
  probe GetDirectBufferAddress__return(void*);
  probe GetDirectBufferCapacity__entry(void*, void*);
  probe GetDirectBufferCapacity__return(uintptr_t);
  probe GetDoubleArrayElements__entry(void*, void*, uintptr_t*);
  probe GetDoubleArrayElements__return(double*);
  probe GetDoubleArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, double*);
  probe GetDoubleArrayRegion__return();
  probe GetDoubleField__entry(void*, void*, uintptr_t);
  probe GetDoubleField__return();
  probe GetEnv__entry(void*, void*, uint32_t);
  probe GetEnv__return(uint32_t);
  probe GetFieldID__entry(void*, void*, const char*, const char*);
  probe GetFieldID__return(uintptr_t);
  probe GetFloatArrayElements__entry(void*, void*, uintptr_t*);
  probe GetFloatArrayElements__return(float*);
  probe GetFloatArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, float*);
  probe GetFloatArrayRegion__return();
  probe GetFloatField__entry(void*, void*, uintptr_t);
  probe GetFloatField__return();
  probe GetIntArrayElements__entry(void*, void*, uintptr_t*);
  probe GetIntArrayElements__return(uint32_t*);
  probe GetIntArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, uint32_t*);
  probe GetIntArrayRegion__return();
  probe GetIntField__entry(void*, void*, uintptr_t);
  probe GetIntField__return(uint32_t);
  probe GetJavaVM__entry(void*, void**);
  probe GetJavaVM__return(uint32_t);
  probe GetLongArrayElements__entry(void*, void*, uintptr_t*);
  probe GetLongArrayElements__return(uintptr_t*);
  probe GetLongArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, uintptr_t*);
  probe GetLongArrayRegion__return();
  probe GetLongField__entry(void*, void*, uintptr_t);
  probe GetLongField__return(uintptr_t);
  probe GetMethodID__entry(void*, void*, const char*, const char*);
  probe GetMethodID__return(uintptr_t);
  probe GetModule__entry(void*, void*);
  probe GetModule__return(void*);
  probe GetObjectArrayElement__entry(void*, void*, uintptr_t);
  probe GetObjectArrayElement__return(void*);
  probe GetObjectClass__entry(void*, void*);
  probe GetObjectClass__return(void*);
  probe GetObjectField__entry(void*, void*, uintptr_t);
  probe GetObjectField__return(void*);
  probe GetObjectRefType__entry(void*, void*);
  probe GetObjectRefType__return(void*);
  probe GetPrimitiveArrayCritical__entry(void*, void*, uintptr_t*);
  probe GetPrimitiveArrayCritical__return(void*);
  probe GetShortArrayElements__entry(void*, void*, uintptr_t*);
  probe GetShortArrayElements__return(uint16_t*);
  probe GetShortArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, uint16_t*);
  probe GetShortArrayRegion__return();
  probe GetShortField__entry(void*, void*, uintptr_t);
  probe GetShortField__return(uint16_t);
  probe GetStaticBooleanField__entry(void*, void*, uintptr_t);
  probe GetStaticBooleanField__return(uintptr_t);
  probe GetStaticByteField__entry(void*, void*, uintptr_t);
  probe GetStaticByteField__return(char);
  probe GetStaticCharField__entry(void*, void*, uintptr_t);
  probe GetStaticCharField__return(uint16_t);
  probe GetStaticDoubleField__entry(void*, void*, uintptr_t);
  probe GetStaticDoubleField__return();
  probe GetStaticFieldID__entry(void*, void*, const char*, const char*);
  probe GetStaticFieldID__return(uintptr_t);
  probe GetStaticFloatField__entry(void*, void*, uintptr_t);
  probe GetStaticFloatField__return();
  probe GetStaticIntField__entry(void*, void*, uintptr_t);
  probe GetStaticIntField__return(uint32_t);
  probe GetStaticLongField__entry(void*, void*, uintptr_t);
  probe GetStaticLongField__return(uintptr_t);
  probe GetStaticMethodID__entry(void*, void*, const char*, const char*);
  probe GetStaticMethodID__return(uintptr_t);
  probe GetStaticObjectField__entry(void*, void*, uintptr_t);
  probe GetStaticObjectField__return(void*);
  probe GetStaticShortField__entry(void*, void*, uintptr_t);
  probe GetStaticShortField__return(uint16_t);
  probe GetStringChars__entry(void*, void*, uintptr_t*);
  probe GetStringChars__return(const uint16_t*);
  probe GetStringCritical__entry(void*, void*, uintptr_t*);
  probe GetStringCritical__return(const uint16_t*);
  probe GetStringLength__entry(void*, void*);
  probe GetStringLength__return(uintptr_t);
  probe GetStringRegion__entry(void*, void*, uintptr_t, uintptr_t, uint16_t*);
  probe GetStringRegion__return();
  probe GetStringUTFChars__entry(void*, void*, uintptr_t*);
  probe GetStringUTFChars__return(const char*);
  probe GetStringUTFLength__entry(void*, void*);
  probe GetStringUTFLength__return(uintptr_t);
  probe GetStringUTFLengthAsLong__entry(void*, void*);
  probe GetStringUTFLengthAsLong__return(uintptr_t);
  probe GetStringUTFRegion__entry(void*, void*, uintptr_t, uintptr_t, char*);
  probe GetStringUTFRegion__return();
  probe GetSuperclass__entry(void*, void*);
  probe GetSuperclass__return(void*);
  probe GetVersion__entry(void*);
  probe GetVersion__return(uint32_t);
  probe IsAssignableFrom__entry(void*, void*, void*);
  probe IsAssignableFrom__return(uintptr_t);
  probe IsInstanceOf__entry(void*, void*, void*);
  probe IsInstanceOf__return(uintptr_t);
  probe IsSameObject__entry(void*, void*, void*);
  probe IsSameObject__return(uintptr_t);
  probe MonitorEnter__entry(void*, void*);
  probe MonitorEnter__return(uint32_t);
  probe MonitorExit__entry(void*, void*);
  probe MonitorExit__return(uint32_t);
  probe NewBooleanArray__entry(void*, uintptr_t);
  probe NewBooleanArray__return(void*);
  probe NewByteArray__entry(void*, uintptr_t);
  probe NewByteArray__return(void*);
  probe NewCharArray__entry(void*, uintptr_t);
  probe NewCharArray__return(void*);
  probe NewDirectByteBuffer__entry(void*, void*, uintptr_t);
  probe NewDirectByteBuffer__return(void*);
  probe NewDoubleArray__entry(void*, uintptr_t);
  probe NewDoubleArray__return(void*);
  probe NewFloatArray__entry(void*, uintptr_t);
  probe NewFloatArray__return(void*);
  probe NewGlobalRef__entry(void*, void*);
  probe NewGlobalRef__return(void*);
  probe NewIntArray__entry(void*, uintptr_t);
  probe NewIntArray__return(void*);
  probe NewLocalRef__entry(void*, void*);
  probe NewLocalRef__return(void*);
  probe NewLongArray__entry(void*, uintptr_t);
  probe NewLongArray__return(void*);
  probe NewObjectA__entry(void*, void*, uintptr_t);
  probe NewObjectA__return(void*);
  probe NewObjectArray__entry(void*, uintptr_t, void*, void*);
  probe NewObjectArray__return(void*);
  probe NewObject__entry(void*, void*, uintptr_t);
  probe NewObject__return(void*);
  probe NewObjectV__entry(void*, void*, uintptr_t);
  probe NewObjectV__return(void*);
  probe NewShortArray__entry(void*, uintptr_t);
  probe NewShortArray__return(void*);
  probe NewString__entry(void*, const uint16_t*, uintptr_t);
  probe NewString__return(void*);
  probe NewStringUTF__entry(void*, const char*);
  probe NewStringUTF__return(void*);
  probe NewWeakGlobalRef__entry(void*, void*);
  probe NewWeakGlobalRef__return(void*);
  probe PopLocalFrame__entry(void*, void*);
  probe PopLocalFrame__return(void*);
  probe PushLocalFrame__entry(void*, uint32_t);
  probe PushLocalFrame__return(uint32_t);
  probe RegisterNatives__entry(void*, void*, const void*, uint32_t);
  probe RegisterNatives__return(uint32_t);
  probe ReleaseBooleanArrayElements__entry(void*, void*, uintptr_t*, uint32_t);
  probe ReleaseBooleanArrayElements__return();
  probe ReleaseByteArrayElements__entry(void*, void*, char*, uint32_t);
  probe ReleaseByteArrayElements__return();
  probe ReleaseCharArrayElements__entry(void*, void*, uint16_t*, uint32_t);
  probe ReleaseCharArrayElements__return();
  probe ReleaseDoubleArrayElements__entry(void*, void*, double*, uint32_t);
  probe ReleaseDoubleArrayElements__return();
  probe ReleaseFloatArrayElements__entry(void*, void*, float*, uint32_t);
  probe ReleaseFloatArrayElements__return();
  probe ReleaseIntArrayElements__entry(void*, void*, uint32_t*, uint32_t);
  probe ReleaseIntArrayElements__return();
  probe ReleaseLongArrayElements__entry(void*, void*, uintptr_t*, uint32_t);
  probe ReleaseLongArrayElements__return();
  probe ReleasePrimitiveArrayCritical__entry(void*, void*, void*, uint32_t);
  probe ReleasePrimitiveArrayCritical__return();
  probe ReleaseShortArrayElements__entry(void*, void*, uint16_t*, uint32_t);
  probe ReleaseShortArrayElements__return();
  probe ReleaseStringChars__entry(void*, void*, const uint16_t*);
  probe ReleaseStringChars__return();
  probe ReleaseStringCritical__entry(void*, void*, const uint16_t*);
  probe ReleaseStringCritical__return();
  probe ReleaseStringUTFChars__entry(void*, void*, const char*);
  probe ReleaseStringUTFChars__return();
  probe SetBooleanArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, const uintptr_t*);
  probe SetBooleanArrayRegion__return();
  probe SetBooleanField__entry(void*, void*, uintptr_t, uintptr_t);
  probe SetBooleanField__return();
  probe SetByteArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, const char*);
  probe SetByteArrayRegion__return();
  probe SetByteField__entry(void*, void*, uintptr_t, char);
  probe SetByteField__return();
  probe SetCharArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, const uint16_t*);
  probe SetCharArrayRegion__return();
  probe SetCharField__entry(void*, void*, uintptr_t, uint16_t);
  probe SetCharField__return();
  probe SetDoubleArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, const double*);
  probe SetDoubleArrayRegion__return();
  probe SetDoubleField__entry(void*, void*, uintptr_t);
  probe SetDoubleField__return();
  probe SetFloatArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, const float*);
  probe SetFloatArrayRegion__return();
  probe SetFloatField__entry(void*, void*, uintptr_t);
  probe SetFloatField__return();
  probe SetIntArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, const uint32_t*);
  probe SetIntArrayRegion__return();
  probe SetIntField__entry(void*, void*, uintptr_t, uint32_t);
  probe SetIntField__return();
  probe SetLongArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, const uintptr_t*);
  probe SetLongArrayRegion__return();
  probe SetLongField__entry(void*, void*, uintptr_t, uintptr_t);
  probe SetLongField__return();
  probe SetObjectArrayElement__entry(void*, void*, uintptr_t, void*);
  probe SetObjectArrayElement__return();
  probe SetObjectField__entry(void*, void*, uintptr_t, void*);
  probe SetObjectField__return();
  probe SetShortArrayRegion__entry(void*, void*, uintptr_t, uintptr_t, const uint16_t*);
  probe SetShortArrayRegion__return();
  probe SetShortField__entry(void*, void*, uintptr_t, uint16_t);
  probe SetShortField__return();
  probe SetStaticBooleanField__entry(void*, void*, uintptr_t, uintptr_t);
  probe SetStaticBooleanField__return();
  probe SetStaticByteField__entry(void*, void*, uintptr_t, char);
  probe SetStaticByteField__return();
  probe SetStaticCharField__entry(void*, void*, uintptr_t, uint16_t);
  probe SetStaticCharField__return();
  probe SetStaticDoubleField__entry(void*, void*, uintptr_t);
  probe SetStaticDoubleField__return();
  probe SetStaticFloatField__entry(void*, void*, uintptr_t);
  probe SetStaticFloatField__return();
  probe SetStaticIntField__entry(void*, void*, uintptr_t, uint32_t);
  probe SetStaticIntField__return();
  probe SetStaticLongField__entry(void*, void*, uintptr_t, uintptr_t);
  probe SetStaticLongField__return();
  probe SetStaticObjectField__entry(void*, void*, uintptr_t, void*);
  probe SetStaticObjectField__return();
  probe SetStaticShortField__entry(void*, void*, uintptr_t, uint16_t);
  probe SetStaticShortField__return();
  probe Throw__entry(void*, void*);
  probe Throw__return(intptr_t);
  probe ThrowNew__entry(void*, void*, const char*);
  probe ThrowNew__return(intptr_t);
  probe ToReflectedField__entry(void*, void*, uintptr_t, uintptr_t);
  probe ToReflectedField__return(void*);
  probe ToReflectedMethod__entry(void*, void*, uintptr_t, uintptr_t);
  probe ToReflectedMethod__return(void*);
  probe UnregisterNatives__entry(void*, void*);
  probe UnregisterNatives__return(uint32_t);
};

#pragma D attributes Standard/Standard/Common provider hotspot_jni provider
#pragma D attributes Private/Private/Unknown provider hotspot_jni module
#pragma D attributes Private/Private/Unknown provider hotspot_jni function
#pragma D attributes Standard/Standard/Common provider hotspot_jni name
#pragma D attributes Evolving/Evolving/Common provider hotspot_jni args
