#region MIT license
// 
// MIT license
//
// Copyright (c) 2007-2008 Jiri Moudry, Pascal Craponne
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// 
#endregion

namespace DbLinq.Data.Linq.Sugar.Expressions
{
    /// <summary>
    /// SQL specific (and DBlinq required) custom expression types.
    /// To add a new value here, please be sure to handle it everywhere
    /// For this, search for "// SETuse" comment in project
    /// </summary>
#if !MONO_STRICT
    public
#endif
    enum SpecialExpressionType
    {
        IsNull = 100,
        IsNotNull,
        Concat,
        Count,
        Exists,
        Like,
        Min,
        Max,
        Sum,
        Average,
        StringLength,
        ToUpper,
        ToLower,
        In,
        Substring,
        Trim,
        LTrim,
        RTrim,

        StringInsert,
        Replace,
        Remove,
        IndexOf,

        Year,
        Month,
        Day,
        Hour,
        Minute,
        Second,
        Millisecond,
        Now,
        Date,
        DateDiffInMilliseconds,

        Abs,
        Exp,
        Floor,
        Ln,
        Log,
        Pow,
        Round,
        Sign,
        Sqrt
    }
}