---
name: Bug report
about: Create a report to help us improve
title: ""
labels: "bug"
---

### Describe the bug

A clear and concise description of what the bug is.
Before submitting a bug report, please check the following:

- [ ] The bug is reproducible with the latest version of njs.
- [ ] I minimized the code and NGINX configuration to the smallest
possible to reproduce the issue.

### To reproduce

Steps to reproduce the behavior:

- JS script
```js
// Your JS code here
```
or put the code in a [gist](https://gist.github.com/) and link it here.
- NGINX configuration if applicable
```
# Your NGINX configuration here
```
or put the configuration in a [gist](https://gist.github.com/) and link it here.
- NGINX logs if applicable
```
# Your NGINX logs here
```
or post the full log to a [gist](https://gist.github.com/) and link it here.
- Output of the `nginx -V` command if applicable.
- Exact steps to reproduce the behavior

### Expected behavior

A clear and concise description of what you expected to happen.

### Your environment

- Version of njs or specific commit
- Version of NGINX if applicable
- List of other enabled nginx modules if applicable
- OS: [e.g. Ubuntu 20.04]

### Additional context

Add any other context about the problem here.
