/*
 * Copyright 2006, 2007 Aaron Spike <aaron@ekips.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it either under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation
 * (the "LGPL") or, at your option, under the terms of the Mozilla
 * Public License Version 1.1 (the "MPL"). If you do not alter this
 * notice, a recipient may use your version of this file under either
 * the MPL or the LGPL.
 *
 * You should have received a copy of the LGPL along with this library
 * in the file COPYING-LGPL-2.1; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * You should have received a copy of the MPL along with this library
 * in the file COPYING-MPL-1.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY
 * OF ANY KIND, either express or implied. See the LGPL or the MPL for
 * the specific language governing rights and limitations.
 *
 */

#ifndef SEEN_PY2GEOM_H
#define SEEN_PY2GEOM_H

void wrap_point();
void wrap_etc();
void wrap_interval();
void wrap_transforms();
void wrap_rect();
void wrap_circle();
void wrap_ellipse();
void wrap_sbasis();
void wrap_bezier();
void wrap_linear();
void wrap_pw();
void wrap_d2();
void wrap_path();
void wrap_parser();
void wrap_ray();
// void wrap_shape();
void wrap_line();
void wrap_conic();
void wrap_crossing();
// void wrap_convex_cover();
namespace Geom{
class Point;
class Linear;
};
#include <vector>
typedef std::vector<Geom::Point > PointVec;
typedef std::vector<double > DoubleVec;
typedef std::vector<Geom::Linear> LinearVec;

#endif
/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4:fileencoding=utf-8:textwidth=99 :
