#pragma once
/*
 *  $Id: gradient-swatch.h 28233 2025-07-16 10:46:57Z yeti-dn $
 *  Copyright (C) 2024-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GRADIENT_SWATCH_H__
#define __GWYUI_GRADIENT_SWATCH_H__

#include <gtk/gtk.h>
#include <libgwyddion/gradient.h>

G_BEGIN_DECLS

#define GWY_TYPE_GRADIENT_SWATCH            (gwy_gradient_swatch_get_type())
#define GWY_GRADIENT_SWATCH(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GRADIENT_SWATCH, GwyGradientSwatch))
#define GWY_GRADIENT_SWATCH_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GRADIENT_SWATCH, GwyGradientSwatchClass))
#define GWY_IS_GRADIENT_SWATCH(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GRADIENT_SWATCH))
#define GWY_IS_GRADIENT_SWATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GRADIENT_SWATCH))
#define GWY_GRADIENT_SWATCH_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GRADIENT_SWATCH, GwyGradientSwatchClass))

typedef struct _GwyGradientSwatch             GwyGradientSwatch;
typedef struct _GwyGradientSwatchClass        GwyGradientSwatchClass;
typedef struct _GwyGradientSwatchPrivate      GwyGradientSwatchPrivate;

struct _GwyGradientSwatch {
    GtkWidget widget;
    GwyGradientSwatchPrivate *priv;
};

struct _GwyGradientSwatchClass {
    GtkWidgetClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
};

GType          gwy_gradient_swatch_get_type      (void)                       G_GNUC_CONST;
GtkWidget*     gwy_gradient_swatch_new           (void);
void           gwy_gradient_swatch_set_gradient  (GwyGradientSwatch *swatch,
                                                  GwyGradient *gradient);
GwyGradient*   gwy_gradient_swatch_get_gradient  (GwyGradientSwatch *swatch);
void           gwy_gradient_swatch_set_use_alpha (GwyGradientSwatch *swatch,
                                                  gboolean use_alpha);
gboolean       gwy_gradient_swatch_get_use_alpha (GwyGradientSwatch *swatch);
void           gwy_gradient_swatch_set_editable  (GwyGradientSwatch *swatch,
                                                  gboolean editable);
gboolean       gwy_gradient_swatch_get_editable  (GwyGradientSwatch *swatch);
void           gwy_gradient_swatch_set_has_marker(GwyGradientSwatch *swatch,
                                                  gboolean has_marker);
gboolean       gwy_gradient_swatch_get_has_marker(GwyGradientSwatch *swatch);
void           gwy_gradient_swatch_set_adjustment(GwyGradientSwatch *swatch,
                                                  GtkAdjustment *adj);
GtkAdjustment* gwy_gradient_swatch_get_adjustment(GwyGradientSwatch *swatch);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
