/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/core/v1"
	corev1 "k8s.io/client-go/applyconfigurations/core/v1"
	gentype "k8s.io/client-go/gentype"
	typedcorev1 "k8s.io/client-go/kubernetes/typed/core/v1"
)

// fakePersistentVolumes implements PersistentVolumeInterface
type fakePersistentVolumes struct {
	*gentype.FakeClientWithListAndApply[*v1.PersistentVolume, *v1.PersistentVolumeList, *corev1.PersistentVolumeApplyConfiguration]
	Fake *FakeCoreV1
}

func newFakePersistentVolumes(fake *FakeCoreV1) typedcorev1.PersistentVolumeInterface {
	return &fakePersistentVolumes{
		gentype.NewFakeClientWithListAndApply[*v1.PersistentVolume, *v1.PersistentVolumeList, *corev1.PersistentVolumeApplyConfiguration](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("persistentvolumes"),
			v1.SchemeGroupVersion.WithKind("PersistentVolume"),
			func() *v1.PersistentVolume { return &v1.PersistentVolume{} },
			func() *v1.PersistentVolumeList { return &v1.PersistentVolumeList{} },
			func(dst, src *v1.PersistentVolumeList) { dst.ListMeta = src.ListMeta },
			func(list *v1.PersistentVolumeList) []*v1.PersistentVolume { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.PersistentVolumeList, items []*v1.PersistentVolume) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
